<%
/**
 *	Bottom frame of Event History Page
 *
 *	@author		Arun Jayaprakash
 *	@created	13/03/2003
 *	@version	3.0
 *
 *	@modified
 *		17/03/2003	Arun	Validates selection of component names and types. Corrected bug that would occur 
 *							if the user was allowed to proceed without selecting  component name or type, if 
 *							All Events was not chosen.
 *		18/03/2003	Arun	Integrate AlarmHistoryAdapter, Bug fixes - Goto Page, Data validation using 
 *							JavaScript
 *		19/03/2003	Arun	Fixed recurring bugs with pager-taglib
 *		29/07/2003	John	eG 3.0 Layout Modifications
 *		27/09/2003	Arun	Fixed Description layout bug
 *		04/11/2003	Arun	Does not show ports is NULL
 *		27/01/2004	Arun	Fixed the problem of missing : and _ when the rows wrap
 *		21/05/2004	Arun	Included links to Graphs and DD
 *		07/07/2004	Arun	Graphs and DD would not be displayed for components with non-null ports.
 *		14/07/2004	Arun	Fixed to show graphs from start time of the event instead of previous hour.
 *		02/09/2004	Solomon	DD not shown for Agentless server except external tests. DD not shown for DD enabled 
  *		07/03/2006	James Thomas to save the data in CVS Formattests with lengthy names is fixed.
 */
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgAgentInfo"%>
<%@ page import = "com.eg.LangInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.monitor.EgAlarmsBean"%>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "egurkha.EgSettingsTimeStamp" %>
<%@ page import = "egurkha.TestBean" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.text.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.io.*"  %>
<%@ page import = "com.eg.IniFile"%>
<%@ taglib uri="/WEB-INF/indexer-taglib.tld" prefix="id" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.monitor.EgAlarmComparator"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgURLDecoder" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO"%>
<%@ page import="com.egurkha.monitor.EgServerDashboardModel"%>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory"%>
<%@ page import = "com.eg.EgTestInfo"%>
<%@ page import ="com.eg.EgViewInfo" %>
<%@ page import = "egurkha.reporter.*" %>
<%@ page import ="com.eg.EgTopoInfo"%>
<%@ page import ="com.eg.EgGroupInfo"%>
<%@ page import = "com.egurkha.monitor.*" %>
<jsp:useBean id="dd" scope="page" class="com.egurkha.monitor.EgDiagnosisBean" />
<html>
<head>
<title> &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<egui:skin ui="monitor"/>
<meta name="Author" content="" />
<!--<link rel="stylesheet" href="../monitor/eg_styles/eg_monitorstyle.css" />-->
<!--<link rel="stylesheet" href="eg_styles/monstyle_gray.css" />-->
<%!
int compNameLength=32;
int displayLength=18;
String testList="";
%>
<script language="javascript">
var ddwin=null;
var gwin=null;

function getDateObj(date, hour)
{
	var index = date.indexOf("/");
	var lastIndex = date.lastIndexOf("/");

	var day = date.substr(0, index);
	var month = date.substr(index+1, lastIndex-index-1);
	var year = date.substr(lastIndex+1);

	var dateObj = new Date(year, month, day, hour, 0, 0);
	return dateObj;
}

function findPagerOffset(page)
{
	var url = window.location.href;
	var index = url.indexOf("indexeroffset");

	if (index != -1)
	{
		var beforeStr = url.substr(0, index);
		var afterStr = url.substr(index);
		index = afterStr.indexOf("&");
		if (index == -1)
		{
			url = beforeStr + "indexeroffset=" + page;
		}
		else
		{
			afterStr = afterStr.substr(index);
			url = beforeStr + "indexeroffset=" + page + afterStr;
		}
	}
	else
	{
		url += "&indexeroffset="+page;
	}
	return url;
}

function onGoToPage(maxEntriesPerPage, totalEntries)
{
	var page = document.Event.pageno.value;
	
	if (!isNaN(page))
	{
		var offset = (page-1) * maxEntriesPerPage;
		if ((offset > totalEntries) || (page < 1))
		{
			alert('<egui:intnl text="monitor.history.Page"/>' +page+'<egui:intnl text="monitor.history.does not exist"/>');
			document.Event.pageno.value = "";
		}
		else
		{
			window.location.href = findPagerOffset(offset);
		}
	}
	else
	{
		alert('<egui:intnl text="monitor.history.Page"/>'+page+' <egui:intnl text="monitor.history.is invalid"/> ');
		document.Event.pageno.value = "";
	}
}

function popupValue(thisQuery,type)
{
	var newWindow = false;
	newWindow = document.Event.popup_selection.checked;
	parent.popup(encodeURI(thisQuery),type,newWindow);
}

/*function popup(thisQuery,type)
{
	var newWindow = false;
	newWindow = document.Event.popup_selection.checked;
	var jsp = "";
	var title = "";
	if(type == 'data')
	{

		jsp = "/final/monitor/EgGraphGenerator.jsp?";
		title = "GRAPHS";
		//document.getElementById("main").src=jsp;
		//alert("test");
		//target = "event_main";
	}
	else
	{
		jsp = "/final/monitor/EgDiagnosis.jsp?";
		title = "DIAGNOSIS";
		//document.getElementById("main").src=jsp;
	}
	if(newWindow!=null && newWindow!='undefined' && newWindow)
	{
		window.openWindow(jsp + thisQuery + "&popup=true", title, 'toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
	else
	{
		window.location.href = jsp+thisQuery;
	}

}*/
function closeWin ()
{
	if(window.gwin!=null)
	gwin.close();
	if(window.ddwin!=null)
	ddwin.close();
}

/*------------------------Div Resize--------------------*/
window.onresize = myResize;
function myResize() 
	{
var myWidth = 900, myHeight = 500;

if( typeof( window.innerWidth ) == 'number' ) 
{
    //Non-IE
	document.getElementById("my_div").style.width=(window.innerWidth-15)+"px";
	document.getElementById("my_div").style.height=(window.innerHeight-14)+"px";

	}
	else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight )) 
	{
    //IE 6+ in 'standards compliant mode'
   document.getElementById("my_div").style.width=(document.documentElement.clientWidth-14)+"px";
	document.getElementById("my_div").style.height=(document.documentElement.clientHeight-14)+"px";

  } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
	document.getElementById("my_div").style.width=(document.body.clientWidth-14)+"px";
	//document.getElementById("my_applet").style.height=(document.body.clientHeight-37)+"px";
	document.getElementById("my_div").style.height=(document.body.clientHeight-14)+"px";

  }

}
/*-----------------------Div Resize---------------------*/ 

</script>

</head>

<body leftmargin="0" topmargin="0" style="overflow:hidden" scroll="no" marginheight="0" marginwidth="0" id="inner_bg" onUnload="javascript: closeWin()" class="space6" style="visibility:visible;" onload="myResize()">
 <script type="text/javascript" src="/final/monitor/eg_scripts/wz_tooltip.js"></script>
	<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" valign="top" height="100%" id="data_border"  >
		<tr>
			<td width="100%" valign="top">
<!--<form method="POST" name="Event">-->
<%!
	String licenseCheck = "me";
	String thisLanguage="";
	public Vector syncVector = new Vector();
	boolean isFromDashBoard=false;
	boolean isFromInsideviewDashboard=false;
	Hashtable ht = new Hashtable();
	String insideViewInfo=null;
%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	isFromDashBoard=(request.getParameter("fromDashBoard")!=null && request.getParameter("fromDashBoard").equals("true"));
	isFromInsideviewDashboard=(request.getParameter("from_page")!=null && request.getParameter("from_page").equalsIgnoreCase("insideviewDashboard"));
	String tab=request.getParameter("tab");
	if(isFromInsideviewDashboard)
	{
		insideViewInfo=request.getParameter("insideview_info");
		if(insideViewInfo!=null && insideViewInfo.trim().length()>0 && !insideViewInfo.startsWith("+"))
		{
			insideViewInfo="+"+insideViewInfo.toLowerCase();
		}
		else if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
		{
			insideViewInfo=insideViewInfo.toLowerCase();
		}
	}
	boolean isAllComp=false;
	boolean  ddEnabled=false;
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI ui = (IniUI)com.egurkha.ini.IniUI.getInstance();
	
	String loginid = user.getLoginID();
	LangInfo langinfo = new LangInfo(loginid);

	String LABELS = "LABELS";
	thisLanguage = ui.getDefaultLanguage();
	if (user!=null)
	{
		String userLang = user.getLanguage();
		if (userLang!=null && !userLang.equalsIgnoreCase("NULL"))
		{
			thisLanguage=userLang;
		}
	}
	
	EgMappingInfo mappingInfo = new EgMappingInfo(thisLanguage);
	EgUserRole userRole = EgUserRole.getRoleObject(user.getLoginType());
	isAllComp = userRole.hasAllComponentAccess();
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
    IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	String currDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	currentDateFormat = currentDateFormat + " HH:mm:ss";
	String selectedArrangeOption      = request.getParameter("arrangeAlarms");

	String layerName = request.getParameter("selectedLayer");


	synchronized(licenseCheck)
	{
		ddEnabled = EgMemInfo.ddEnabled;
	}
	EgSpecsInfo specsInfo = new EgSpecsInfo(EgConstants.MANAGER);
	EgAgentInfo agentInfo = new EgAgentInfo(EgConstants.MANAGER);
	
	Vector vpdfData=new Vector();
	List lst=new LinkedList();//to store into the session object
	List data_list=new LinkedList();//to store the data for CSV format
	Vector heads=new Vector();//to store table heading to CSV format
	Vector date=new Vector();
	
	lst.add(mappingInfo.getTextDescription("monitor.history.Event History"));

	String pdfHeading="";


	List all = null;	//Result from the database
	List history = null;//Same as all, but contains data as is from database. all undergoes modifications for display.
	int size = 0;		//The size of the Vector all

	//---For indexer-taglib.jar
	String index = "center";
	//int maxPageItems = 10;

	//added by ahamed
	String count = request.getParameter("eventsCount");
	String eventsPerPage = request.getParameter("eventsPerPage");
	if(eventsPerPage == null)
	{
		eventsPerPage = egUI.getValue("ALARMS","Row_Multiplier");
	}
	if("ALL".equalsIgnoreCase(eventsPerPage))
	{
		eventsPerPage = count;
	}
	int eventsperPage_int = 10;
	if(eventsPerPage != null && !eventsPerPage.equalsIgnoreCase("null") && !eventsPerPage.equalsIgnoreCase(""))
	{
		eventsperPage_int = Integer.parseInt(eventsPerPage);
	}
	//end

	int maxPageItems = eventsperPage_int;//ui.getMaxPageItems();
	int maxIndexPages = 10;
	int thisPageNumber = 1;
	int maxWidth = 0;

	String durationStr = request.getParameter("filterOut");
	char condition = '>';			//Filter out by more than or less than?
	long minDuration = 0;
	if (durationStr != null)
	{
		minDuration = Long.parseLong(durationStr);
		if (durationStr.startsWith("-"))
		{
			condition = '<';
		}
	}

	int eventCount = 0;
	int offsetCount = 0;

	String infosearch=request.getParameter("infosearch");
	String s_event = request.getParameter("s_event");
	String subevent = request.getParameter("subevent");
	String selectedsubzone = request.getParameter("selectedsubzone");
	String startTime = request.getParameter("startDate");
	String endTime = request.getParameter("endDate");
	String s_state = request.getParameter("state");
	String selectedCompName = request.getParameter("compName");
	if(selectedCompName!=null)
		selectedCompName=EgURLDecoder.decode(selectedCompName,"UTF-8");
	if(selectedCompName.equals("-1")) selectedCompName="Component Name (Optional)";
	String selectedCompType = request.getParameter("compType");
	String dashboardcomptype=request.getParameter("dashboardcomptype");
	if(selectedCompType!=null)
		selectedCompType=EgURLDecoder.decode(selectedCompType,"UTF-8");
	if(selectedCompType.equals("-1")) selectedCompType="Component Type (Optional)";

	int selection=0;
	
	
	String pdfHeading1="";
	String pdfHeading2="";
	String pdfHeading3="";
	String zonepdf="";
	String infosearchpdf="";
	if(s_event!=null && s_event.trim().length()>0 && (s_event.equalsIgnoreCase("Service") || s_event.equalsIgnoreCase("Segment") || s_event.equalsIgnoreCase("Zone")))
	{
		Vector v=new Vector();
		String str= mappingInfo.getTextDescription("monitor.history.Analysis By")+":"+s_event;
		pdfHeading1=str;
		v.add(str);
		lst.add(v);
	}

	if(s_event!=null && s_event.trim().length()>0 && (s_event.equalsIgnoreCase("Service") || s_event.equalsIgnoreCase("Segment") || s_event.equalsIgnoreCase ("Zone")))
	{
		if(subevent!=null && subevent.trim().length()>0)
		{
			Vector v=new Vector();
			String str= mappingInfo.getTextDescription("monitor.history.Name") +":"+subevent;
			pdfHeading2=""+str;
			v.add(str);
			lst.add(v);
		}
	}

	if(s_event!=null && s_event.equals("Zone") && subevent!=null && subevent.trim().length()>0 && !subevent.equals("null"))
	{
		if(selectedsubzone!=null && selectedsubzone.trim().length()>0)
		{
			Vector v=new Vector();
			zonepdf= mappingInfo.getTextDescription("monitor.history.IncludeSubZone")+ ":"+selectedsubzone;
			if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0)
				pdfHeading=pdfHeading1+","+pdfHeading2+","+""+zonepdf;
			v.add(zonepdf);
			lst.add(v);
		}
	}

	if(infosearch!=null && infosearch.trim().length()>0)
	{
		Vector v=new Vector();
		infosearchpdf= mappingInfo.getTextDescription("monitor.history.Description Search")+" : "+infosearch;
		pdfHeading3=infosearchpdf;
		v.add(infosearchpdf);
		lst.add(v);
	}
	if((selectedCompName.length()==0 || selectedCompName.equals("Component Name (Optional)")) && (selectedCompType.length()==0 || selectedCompType.equals("Component Type (Optional)")))
	{
		String str=mappingInfo.getTextDescription("monitor.history.All Events");
		pdfHeading=mappingInfo.getTextDescription("monitor.history.All Events");
		if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equalsIgnoreCase("null"))
		{
			pdfHeading=pdfHeading+","+pdfHeading3;
		}
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}
	else
	selection=1;

	if(selectedCompName.length()==0 && (selectedCompType.length()!=0 && !selectedCompType.equals("Component Type (Optional)") && !selectedCompType.equals("-1")))
	{
		String str=mappingInfo.getTextDescription("monitor.history.Component Type")+" : "+mappingInfo.getComponentTypeDescription(selectedCompType);
		if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0 && zonepdf!=null && zonepdf.trim().length()>0)
			pdfHeading=pdfHeading1+","+pdfHeading2+","+zonepdf+ ","+str;
		else if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0)
			pdfHeading=pdfHeading1+","+pdfHeading2+","+str;
		if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equalsIgnoreCase("null"))
		{
			pdfHeading=pdfHeading+","+pdfHeading3;
		}
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}

	if((selectedCompName.length() !=0 && !selectedCompName.equals("Component Name (Optional)") && !selectedCompName.equals("-1"))  && selectedCompType.length() == 0)
	{
		String str=mappingInfo.getTextDescription("monitor.history.Component Name")+" : "+selectedCompName;
		if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0 && zonepdf!=null && zonepdf.trim().length()>0)
			pdfHeading=pdfHeading1+" , "+pdfHeading2+" , "+zonepdf+ " , "+str;
		else if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0)
			pdfHeading=pdfHeading1+","+pdfHeading2+","+str;
		if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equalsIgnoreCase("null"))
		{
			pdfHeading=pdfHeading+","+pdfHeading3;
		}
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}

	if((selectedCompName.length() !=0 && !selectedCompName.equals("-1")) && (selectedCompType.length()!=0 && !selectedCompType.equals("-1")))
	{
		String str = "";

		if(selectedCompType.equalsIgnoreCase("Component Type (Optional)") && selectedCompName.equalsIgnoreCase("Component Name (Optional)"))
		{
			str = mappingInfo.getTextDescription("monitor.history.All Events");
		}
		else if(selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
		{
			str=mappingInfo.getTextDescription("monitor.history.Component Name")+" : " +selectedCompName;
		}
		else if(selectedCompName.equalsIgnoreCase("Component Name (Optional)"))
		{
			str=mappingInfo.getTextDescription("monitor.history.Component Type")+" : " + mappingInfo.getComponentTypeDescription(selectedCompType);
		}
		else if(!selectedCompType.equalsIgnoreCase("Component Type (Optional)") && !selectedCompName.equalsIgnoreCase("Component Name (Optional)"))
		{
			str="Component Type : " + mappingInfo.getComponentTypeDescription(selectedCompType)+" , Component Name : "+selectedCompName;
		}

		if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0 && zonepdf!=null && zonepdf.trim().length()>0)
			pdfHeading=pdfHeading1+","+pdfHeading2+","+zonepdf+ ","+str;
		else if(pdfHeading1!=null && pdfHeading1.trim().length()>0 && pdfHeading2!=null && pdfHeading2.trim().length()>0)
			pdfHeading=pdfHeading1+","+pdfHeading2+","+str;
		else
			pdfHeading=str;
		if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equalsIgnoreCase("null"))
		{
			pdfHeading=pdfHeading+","+pdfHeading3;
		}
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}
	StringBuffer sbuf=new StringBuffer(pdfHeading);	
	for(int i=sbuf.length();i<=100;i++)
	{
		sbuf.append(" ");
	}
	
	pdfHeading=sbuf.toString();
	
	
	if(s_state.length()==0)
	{
		String str=mappingInfo.getTextDescription("monitor.history.All Priorities");
		pdfHeading+=mappingInfo.getTextDescription("monitor.history.All Priorities");
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}
	else
	{
		String str=mappingInfo.getTextDescription("monitor.history.Priority")+" : ";
		if(s_state.equalsIgnoreCase("HIGHINTERMEDIATE"))
			str+=mappingInfo.getLabelDescription("Critical")+" & "+mappingInfo.getLabelDescription( "Major");	
		else if(s_state.equalsIgnoreCase("HIGH"))
			str+=" "+mappingInfo.getLabelDescription("Critical");		
		else if(s_state.equalsIgnoreCase("INTERMEDIATE"))
			str+=" "+mappingInfo.getLabelDescription("Major");
		else
			str+=" "+mappingInfo.getLabelDescription("Minor");
		pdfHeading+=str;
		Vector v=new Vector();
		v.add(str);
		lst.add(v);
		selection=0;
	}
	if(startTime != null && !endTime.equals(""))
	{
		date.add(mappingInfo.getTextDescription("monitor.history.Start Date") + ":" +DateUtil.changeDateFormat(startTime,"MM/dd/yyyy HH:mm",currentDateFormat));
	}
	if(endTime != null && !endTime.equals(""))
	{
		date.add(mappingInfo.getTextDescription("monitor.history.End Date")+ ":" +DateUtil.changeDateFormat(endTime,"MM/dd/yyyy HH:mm",currentDateFormat));
	}
	lst.add(date);
	
	String offsetStr = request.getParameter("indexeroffset");
	
	if (offsetStr != null)
	{
		offsetCount = Integer.parseInt(offsetStr);
	}
	
	if (StringUtils.isNull(count))
	{
		count = EgConstants.BLANK_STRING;
	}
	else
	{
		eventCount = Integer.parseInt(count);
	}
	
	logToTmpFile("INFO"," ","User = " + user.getLoginID()+"  HasAllCompAccess = " + isAllComp);
	ErUserData erdata = new ErUserData(loginid,false);
	Vector v_zone=new Vector();
	Vector v_site=new Vector();
	Vector v_segment=new Vector();
	Vector v_availComps=new Vector();
	Vector v_segComp=new Vector();
	
	List servers = user.getServers(false);
	List getServers = null;
	List getCompTypes = null;
	List getCompNames = null;
	List zoneComps=new ArrayList();
	boolean subzone=false;
	logToTmpFile("INFO","","Servers ... "+ servers);


	if (servers.size() > 0)
	{
		String nameList = null;
		
		List serverNames = new LinkedList();
		String typeList = null;
		List serverTypes = new LinkedList();

		boolean allEvents = StringUtils.isNull(selectedCompName) && StringUtils.isNull(selectedCompType);
		
		boolean showAll = false;
		boolean showAllTypes = false;
		boolean showAllComps = false;
		EgTopoInfo topoInfo = new EgTopoInfo("manager");
		EgGroupInfo groupInfo = new EgGroupInfo();
		if(selectedCompName!=null && selectedCompName.equalsIgnoreCase("Component Name (Optional)") && selectedCompType!=null && selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
		{
			showAll = true;
		}
		if(selectedCompName !=null && selectedCompName.equalsIgnoreCase("Component Name (Optional)"))
		{
			showAllComps = true;
		}
		if(selectedCompType!=null && selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
		{
			showAllTypes = true;
		}
		if(showAllTypes && showAllComps)
		{
			showAll = true;
		}
		logToTmpFile("INFO","","All Events is " + allEvents);

		if(s_event!=null && s_event.trim().length()>0 && (s_event.equals("Service") || s_event.equals("Segment") || s_event.equals("Zone")) && subevent!=null && subevent.trim().length()>0)
		{
			v_availComps = topoInfo.getComponentsForSite(subevent);
			v_segComp = topoInfo.getComponentsForSegment(subevent);
			if(selectedsubzone!=null && selectedsubzone.trim().length()>0 && selectedsubzone.equalsIgnoreCase("Yes"))
			{
				subzone=true;
			}
			zoneComps = groupInfo.getAllComponentsUnderZone(subevent,subzone);
		}

		if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Component"))
		{
			if (allEvents || showAll)
			{
				if (isAllComp)
				{
					servers = new LinkedList();
				}
				else
				{
					List ls = user.getServerTypes();
					for (int i=0;i<ls.size();i++)
						serverTypes.add((String)ls.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(servers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(servers);
					servers = HostSysServers;
					
				}
			logToTmpFile("INFO","","Servers for this User = "+servers);
			}
			else
			{
				if(showAllTypes && !showAllComps)
				{
					List ls = user.getServerTypes();
					for (int i=0;i<ls.size();i++)
						serverTypes.add((String)ls.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						String s = selectedCompName.substring(0,ind);
						serverNames.add(s+":NULL");
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
						
					}
					serverNames.add(selectedCompName);
					// get only servers of the name we want
					List xx = new LinkedList();
					String search = ":"+selectedCompName;
					for (int r=0; r<servers.size(); r++)
					{
						String ss = (String) servers.get(r);
						if (ss.endsWith(search))
						{
							xx.add(ss);
						}
					}
					servers = xx;
					
				}
				if(!showAllTypes && showAllComps)
				{
					serverTypes.add(selectedCompType);
						// get only servers of the type we want
					List xx = new LinkedList();

					for (int r=0; r<servers.size(); r++)
					{
						String ss = (String) servers.get(r);
						int ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String typ = ss.substring(0,ind);
							if(!selectedCompType.equals("Host_system"))
							{
								if (!serverTypes.contains(typ))
									continue;
								xx.add(ss);
							}
							else
							{
								xx.add(ss);
							}
						}
					}
					servers = xx;
					logToTmpFile("INFO","","Servers for this User for compType " +selectedCompType+ " = "+servers);
				}
				if(!showAllComps && !showAllTypes)
				{
					if(selectedCompType.equals(Server.HOST_SYSTEM))
					{
						serverTypes.add(Server.HOST_SYSTEM);
					}
					else
					{
						serverTypes.add(selectedCompType);
					}
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						//String s = selectedCompName.substring(0,ind);
						//serverNames.add(s+":NULL");
						serverNames.add(selectedCompName);
					} 
					else
					{
						selectedCompName = selectedCompName + ":NULL";
						serverNames.add(selectedCompName);
					}

					List xx = new LinkedList();
					String search = ":" + selectedCompName;
					for (int r=0; r<servers.size(); r++)
					{
						String ss = (String) servers.get(r);
						ind = ss.indexOf(":");
						
						if (ind >= 0)
						{
							String t_ss = "";
							String typ = ss.substring(0,ind);
							if(selectedCompType!=null && !selectedCompType.equals("Host_system"))
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if (!serverTypes.contains(typ))
									continue;
								if(serverNames.contains(ss.trim()))
								{
									xx.add(t_ss);
								}
							}
							else
							{
								t_ss = ss;

								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if(selectedCompType.equals("Host_system"))
								{
									if(ss.indexOf(":") > 0)
									{
										ss = ss.substring(0,ss.indexOf(":"));
									}
								}
								if(serverNames.contains(ss + ":NULL"))
								{
									xx.add("Host_system:" + ss + ":NULL");
								}
							}
						}
					}
					servers = xx;
				}

				if(selectedCompType.equalsIgnoreCase("Host_system") || selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
				{
				List HostSysServers = new LinkedList();
				List xx = Server.getHostSystems(servers, true);
				for (int r=0; r<xx.size(); r++)
				{
					String s = (String) xx.get(r);

					s =Server.HOST_SYSTEM+":"+s;
					if (!HostSysServers.contains(s))
						HostSysServers.add(s);
				}
				HostSysServers.addAll(servers);
				logToTmpFile("INFO","","Host_System servers  = "+HostSysServers);
				servers = HostSysServers;
				}
			}
		}

		else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Service") && subevent!=null && subevent.trim().length()>0)
		{
			getServers = new ArrayList();
			getCompNames = new ArrayList();
			getCompTypes = new ArrayList();
			for(int i=0;i<v_availComps.size();i++)
			{
				String compTypes = (String)v_availComps.get(i);
				String comp_type=null;
				String comp_name=null;
				if(compTypes!=null && compTypes.trim().length()>0)
				{
					comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
					comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
					getServers.add(comp_type+":"+comp_name);
					if(!getCompNames.contains(comp_name))
					{
						getCompNames.add(comp_name);
					}
					if(!getCompTypes.contains(comp_type))
					{
						getCompTypes.add(comp_type);
					}
				}
			}
			if (showAll)
			{
				if (isAllComp)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(getServers);
					servers = HostSysServers;
				}
				else 
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(getServers);
					servers = HostSysServers;
				}
				logToTmpFile("INFO","","Servers for this User = "+servers);
			}
			else
			{
				if(showAllTypes && !showAllComps)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						String s = selectedCompName.substring(0,ind);
						serverNames.add(s+":NULL");
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
					}
					serverNames.add(selectedCompName);
					// get only servers of the name we want
					List xx = new LinkedList();
					String search = ":"+selectedCompName;
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String) getServers.get(r);
						if (ss.endsWith(search))
						{
							xx.add(ss);
						}
					}
					servers = xx;
				}

				if(!showAllTypes && showAllComps)
				{
					serverTypes.add(selectedCompType);
					// get only servers of the type we want
					List xx = new LinkedList();
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String) getServers.get(r);
						int ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String typ = ss.substring(0,ind);
							if(!selectedCompType.equals("Host_system"))
							{
								if (!serverTypes.contains(typ))
									continue;
								xx.add(ss);
							}
							else
							{
								xx.add(ss);
							}
						}
					}

					servers = xx;
					logToTmpFile("INFO","","Servers for this User for compType " +selectedCompType+ " = "+servers);
				}
				if(!showAllComps && !showAllTypes)
				{
					if(selectedCompType.equals(Server.HOST_SYSTEM))
					{
						serverTypes.add(Server.HOST_SYSTEM);
					}
					else
					{
						serverTypes.add(selectedCompType);
					}
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						serverNames.add(selectedCompName);
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
						serverNames.add(selectedCompName);
					}
					List xx = new LinkedList();
					String search = ":" + selectedCompName;
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String)getServers.get(r);
						ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String t_ss = "";
							String typ = ss.substring(0,ind);
							if(selectedCompType!=null && !selectedCompType.equals("Host_system"))
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if (!serverTypes.contains(typ))
									continue;
								if(serverNames.contains(ss.trim()))
								{
									xx.add(t_ss);
								}
							}
							else
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if(selectedCompType.equals("Host_system"))
								{
									if(ss.indexOf(":") > 0)
									{
										ss = ss.substring(0,ss.indexOf(":"));
									}
								}
								if(serverNames.contains(ss + ":NULL"))
								{
									xx.add("Host_system:" + ss + ":NULL");
								}
							}
						}
					}
					servers = xx;
				}
				if(selectedCompType.equalsIgnoreCase("Host_system") || selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
				{
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
							HostSysServers.add(s);
					}
					HostSysServers.addAll(getServers);
					logToTmpFile("INFO","","Host_System servers  = "+HostSysServers);
					servers = HostSysServers;
				}
			}
		}
		
		else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Segment") && subevent!=null && subevent.trim().length()>0)
		{
			getServers = new ArrayList();
			getCompNames = new ArrayList();
			getCompTypes = new ArrayList();
			for(int i=0;i<v_segComp.size();i++)
			{
				String compTypes = (String)v_segComp.get(i);
				String comp_type=null;
				String comp_name=null;
				if(compTypes!=null && compTypes.trim().length()>0)
				{
					comp_name = compTypes.substring(0,compTypes.lastIndexOf(":"));
					comp_type = compTypes.substring(compTypes.lastIndexOf(":")+1);
					getServers.add(comp_type+":"+comp_name);
					if(!getCompNames.contains(comp_name))
					{
						getCompNames.add(comp_name);
					}
					if(!getCompTypes.contains(comp_type))
					{
						getCompTypes.add(comp_type);
					}
				}
			}
			if (showAll)
			{
				if (isAllComp)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(getServers);
					servers = HostSysServers;
				}
				else 
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(getServers);
					servers = HostSysServers;
				}
				logToTmpFile("INFO","","Servers for this User = "+servers);
			}
			else
			{
				if(showAllTypes && !showAllComps)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						String s = selectedCompName.substring(0,ind);
						serverNames.add(s+":NULL");
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
					}
					serverNames.add(selectedCompName);
					// get only servers of the name we want
					List xx = new LinkedList();
					String search = ":"+selectedCompName;
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String) getServers.get(r);
						if (ss.endsWith(search))
						{
							xx.add(ss);
						}
					}
					servers = xx;
				}

				if(!showAllTypes && showAllComps)
				{
					serverTypes.add(selectedCompType);
					// get only servers of the type we want
					List xx = new LinkedList();
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String) getServers.get(r);
						int ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String typ = ss.substring(0,ind);
							if(!selectedCompType.equals("Host_system"))
							{
								if (!serverTypes.contains(typ))
									continue;
								xx.add(ss);
							}
							else
							{
								xx.add(ss);
							}
						}
					}

					servers = xx;
					logToTmpFile("INFO","","Servers for this User for compType " +selectedCompType+ " = "+servers);
				}
				if(!showAllComps && !showAllTypes)
				{
					if(selectedCompType.equals(Server.HOST_SYSTEM))
					{
						serverTypes.add(Server.HOST_SYSTEM);
					}
					else
					{
						serverTypes.add(selectedCompType);
					}
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						serverNames.add(selectedCompName);
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
						serverNames.add(selectedCompName);
					}
					List xx = new LinkedList();
					String search = ":" + selectedCompName;
					for (int r=0; r<getServers.size(); r++)
					{
						String ss = (String)getServers.get(r);
						ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String t_ss = "";
							String typ = ss.substring(0,ind);
							if(selectedCompType!=null && !selectedCompType.equals("Host_system"))
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if (!serverTypes.contains(typ))
									continue;
								if(serverNames.contains(ss.trim()))
								{
									xx.add(t_ss);
								}
							}
							else
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if(selectedCompType.equals("Host_system"))
								{
									if(ss.indexOf(":") > 0)
									{
										ss = ss.substring(0,ss.indexOf(":"));
									}
								}
								if(serverNames.contains(ss + ":NULL"))
								{
									xx.add("Host_system:" + ss + ":NULL");
								}
							}
						}
					}
					servers = xx;
				}
				if(selectedCompType.equalsIgnoreCase("Host_system") || selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
				{
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(getServers, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
							HostSysServers.add(s);
					}
					HostSysServers.addAll(getServers);
					logToTmpFile("INFO","","Host_System servers  = "+HostSysServers);
					servers = HostSysServers;
				}
			}
		}

		else if(s_event!=null && s_event.trim().length()>0 && s_event.equals("Zone") && subevent!=null && subevent.trim().length()>0 && selectedsubzone!=null && selectedsubzone.trim().length()>0 && !zoneComps.isEmpty())
		{
			getCompNames = new ArrayList();
			getCompTypes = new ArrayList();
			for(int i=0;i<zoneComps.size();i++)
			{
				String compTypes = (String)zoneComps.get(i);
				String comp_type=null;
				String comp_name=null;
				if(compTypes!=null && compTypes.trim().length()>0)
				{
					comp_type = compTypes.substring(0,compTypes.indexOf(":"));
					comp_name = compTypes.substring(compTypes.indexOf(":")+1);
					if(!getCompNames.contains(comp_name))
					{
						getCompNames.add(comp_name);
					}
					if(!getCompTypes.contains(comp_type))
					{
						getCompTypes.add(comp_type);
					}
				}
			}
			if (showAll)
			{
				if (isAllComp)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(zoneComps, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(zoneComps);
					servers = HostSysServers;
				}
				else 
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(zoneComps, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
						{
							HostSysServers.add(s);
						}
					}
					HostSysServers.addAll(zoneComps);
					servers = HostSysServers;
				}
				logToTmpFile("INFO","","Servers for this User = "+servers);
			}
			else
			{
				if(showAllTypes && !showAllComps)
				{
					for (int i=0;i<getCompTypes.size();i++)
						serverTypes.add((String)getCompTypes.get(i));
					serverTypes.add(Server.HOST_SYSTEM);
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						String s = selectedCompName.substring(0,ind);
						serverNames.add(s+":NULL");
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
					}
					serverNames.add(selectedCompName);
					// get only servers of the name we want
					List xx = new LinkedList();
					String search = ":"+selectedCompName;
					for (int r=0; r<zoneComps.size(); r++)
					{
						String ss = (String)zoneComps.get(r);
						if (ss.endsWith(search))
						{
							xx.add(ss);
						}
					}
					servers = xx;
				}

				if(!showAllTypes && showAllComps)
				{
					serverTypes.add(selectedCompType);
					// get only servers of the type we want
					List xx = new LinkedList();
					for (int r=0; r<zoneComps.size(); r++)
					{
						String ss = (String)zoneComps.get(r);
						int ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String typ = ss.substring(0,ind);
							if(!selectedCompType.equals("Host_system"))
							{
								if (!serverTypes.contains(typ))
									continue;
								xx.add(ss);
							}
							else
							{
								xx.add(ss);
							}
						}
					}

					servers = xx;
					logToTmpFile("INFO","","Servers for this User for compType " +selectedCompType+ " = "+servers);
				}
				if(!showAllComps && !showAllTypes)
				{
					if(selectedCompType.equals(Server.HOST_SYSTEM))
					{
						serverTypes.add(Server.HOST_SYSTEM);
					}
					else
					{
						serverTypes.add(selectedCompType);
					}
					int ind = selectedCompName.indexOf(":");
					if (ind >= 0)
					{
						serverNames.add(selectedCompName);
					}
					else
					{
						selectedCompName = selectedCompName + ":NULL";
						serverNames.add(selectedCompName);
					}
					List xx = new LinkedList();
					String search = ":" + selectedCompName;
					for (int r=0; r<zoneComps.size(); r++)
					{
						String ss = (String)zoneComps.get(r);
						ind = ss.indexOf(":");
						if (ind >= 0)
						{
							String t_ss = "";
							String typ = ss.substring(0,ind);
							if(selectedCompType!=null && !selectedCompType.equals("Host_system"))
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if (!serverTypes.contains(typ))
									continue;
								if(serverNames.contains(ss.trim()))
								{
									xx.add(t_ss);
								}
							}
							else
							{
								t_ss = ss;
								ss = ss.substring(ss.indexOf(":")+1,ss.length());
								if(selectedCompType.equals("Host_system"))
								{
									if(ss.indexOf(":") > 0)
									{
										ss = ss.substring(0,ss.indexOf(":"));
									}
								}
								if(serverNames.contains(ss + ":NULL"))
								{
									xx.add("Host_system:" + ss + ":NULL");
								}
							}
						}
					}
					servers = xx;
				}
				if(selectedCompType.equalsIgnoreCase("Host_system") || selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
				{
					List HostSysServers = new LinkedList();
					List xx = Server.getHostSystems(zoneComps, true);
					for (int r=0; r<xx.size(); r++)
					{
						String s = (String) xx.get(r);
						s =Server.HOST_SYSTEM+":"+s;
						if (!HostSysServers.contains(s))
							HostSysServers.add(s);
					}
					HostSysServers.addAll(zoneComps);
					logToTmpFile("INFO","","Host_System servers  = "+HostSysServers);
					servers = HostSysServers;
				}
			}
		}

		String ctypes = "";
		if (serverTypes.size() > 0)
			ctypes = StringUtils.getArrayAsString(serverTypes.toArray(), '\'');
		String cnames = "";
		if (serverNames.size() > 0)
			cnames = StringUtils.getArrayAsString(serverNames.toArray(), '\'');

		/*if (serverTypes.indexOf(Server.HOST_SYSTEM) == -1)
		{
			serverTypes.add(Server.HOST_SYSTEM);
		}*/
		List serversWithHost = null;
		if (selectedCompName!=null || selectedCompType.equals(Server.HOST_SYSTEM) || selectedCompType.equalsIgnoreCase("Component Type (Optional)"))
		{
			/*
			 * When a component name is selected, the component type will not be known
			 */
			serversWithHost = Server.getServersWithHostIp(serverNames, false);
		}
		else
		{
			serversWithHost = Server.getServersWithHostIp(serverNames, true);
		}
		
		nameList = StringUtils.getArrayAsString(serversWithHost.toArray(), '\'');
		typeList = StringUtils.getArrayAsString(serverTypes.toArray(), '\'');
		
		if(isFromDashBoard)
		{
			MonitorDAOFactory monitorDaoFactory = MonitorDAOFactory.getInstance();
			EgServerDashBoardDAO dashboardDAO=monitorDaoFactory.getServerDashBoardDAO();
			EgServerDashboardModel dashboardModel=new EgServerDashboardModel();
			StringBuffer sb_layer=new StringBuffer();
			String  layerList="";
			String isNoComponentsSelected=request.getParameter("NoComponentsSelected");
			//Vector layers=dashboardModel.getLayersForModule(ctypes,"System");
			Vector layers = new Vector();
			if(isFromInsideviewDashboard)
			{
				layers.add(request.getParameter("Layer"));
			}
			else if(isNoComponentsSelected!=null && isNoComponentsSelected.equals("true"))
			{
				if(layerName!=null && layerName.equalsIgnoreCase("All"))
				{
					Vector hostLayers=dashboardModel.getLayersForModule(ctypes,"System");
					Vector networkLayers=dashboardModel.getLayersForModule(ctypes,"Network");
					if(hostLayers!=null && !hostLayers.isEmpty())
					{
						layers.addAll(hostLayers);
					}
					if(networkLayers!=null && !networkLayers.isEmpty())
					{
						layers.addAll(networkLayers);
					}
				}
			}
			else
			{
				if(layerName!=null && layerName.equalsIgnoreCase("All") && tab!=null && tab.equalsIgnoreCase("Network"))
				{
					layers=dashboardModel.getLayersForModule(ctypes,"Network");
				}
				else if(layerName!=null && layerName.equalsIgnoreCase("All") && tab!=null && tab.equalsIgnoreCase("Application"))
				{
					String selCompType=com.egurkha.util.StringUtils.replace(ctypes,"'","");
					layers=dashboardModel.getLayersForModule(selCompType,"Application");
				}
				else if(layerName!=null && layerName.equalsIgnoreCase("All") && tab!=null && tab.equalsIgnoreCase("System"))
				{
					layers=dashboardModel.getLayersForModule(ctypes,"System");
				}
				else if(layerName!=null && layerName.equalsIgnoreCase("HOST") && tab!=null && tab.equalsIgnoreCase("System"))
				{
					layers=dashboardModel.getLayersForModule(ctypes,"System");
				}

				else if(tab!=null && tab.equalsIgnoreCase("custom"))
				{
					String selCompType=com.egurkha.util.StringUtils.replace(ctypes,"'","");
					layers=dashboardModel.getLayersForModule(dashboardcomptype,"custom");
				}
			}

			if(layerName!=null && (layerName.equalsIgnoreCase("All") || layerName.equalsIgnoreCase("HOST")))
			{
				if(layers!=null && layers.size()>0)
				{
					for(int  i=0;i<layers.size();i++)
					{
						String tmp_layer=(String)layers.get(i);
						sb_layer.append("'");
						sb_layer.append(tmp_layer);
						sb_layer.append("'");
						if(i!=layers.size()-1)
						{
							sb_layer.append(",");
						}
					}
				}
				layerList=sb_layer.toString();
				if(layerList.endsWith(","))
				{
					layerList=layerList.substring(0,layerList.lastIndexOf(","));
				}
			}
			else
			{
				if(isFromInsideviewDashboard && layers!=null && layers.size()>0)
				{
					for(int  i=0;i<layers.size();i++)
					{
						String tmp_layer=(String)layers.get(i);
						sb_layer.append("'");
						sb_layer.append(tmp_layer);
						sb_layer.append("'");
						if(i!=layers.size()-1)
						{
							sb_layer.append(",");
						}
					}
					layerList=sb_layer.toString();
				}
				else
				{
					layerList="'"+layerName+"'";
				}
				if(layerList.endsWith(","))
				{
					layerList=layerList.substring(0,layerList.lastIndexOf(","));
				}
				
			}
			String cnames1="",ctypes1="";
			if(cnames!=null && cnames.indexOf("'")!=-1)
			{
				cnames1=cnames.substring(1,cnames.length()-1);
			}
			if(ctypes!=null && ctypes.indexOf("'")!=-1)
			{
				ctypes1=ctypes.substring(1,ctypes.length()-1);
			}
			if(dashboardcomptype.equalsIgnoreCase("Network_node"))
			{
					ctypes1="Network_node";
			}
			Vector tests=dashboardDAO.getTestsForLayer(cnames1,ctypes1,layerList);
			StringBuffer sb_test=new StringBuffer();
			if(tests!=null && tests.size()>0)
			{
				for(int  i=0;i<tests.size();i++)
				{
					String tmp_test=(String)tests.get(i);
					sb_test.append("'");
					sb_test.append(tmp_test);
					sb_test.append("'");
					if(i!=tests.size()-1)
					{
						sb_test.append(",");
					}
				}
			}
			testList=sb_test.toString();
			if(testList.endsWith(","))
				testList=testList.substring(0,testList.lastIndexOf(","));

		}
		
		boolean reverseList = false;

		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		String status = egDb.setConnection();
		try
		{
			if (eventCount == 0)
			{
				if(tab!=null && tab.equalsIgnoreCase("custom"))
				{
					String selCompName=com.egurkha.util.StringUtils.replace(cnames,"'","");
					ctypes+=",";
					ctypes+="'Host_system'";
					servers.add("Host_system:"+selCompName);
				}
				if(infosearch==null || infosearch.trim().length()==0 || StringUtils.isNull(infosearch) || infosearch.equals(""))
				{
					eventCount = getEventsCount(servers, cnames, ctypes, startTime, endTime, minDuration,s_state, egDb);
				}
				if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equalsIgnoreCase("null"))
				{
					eventCount = getEventsCount(servers, cnames, ctypes, startTime, endTime, minDuration,s_state, egDb,infosearch,mappingInfo);
				}
				if("ALL".equalsIgnoreCase(request.getParameter("eventsPerPage")))
				{
					maxPageItems = eventCount;
				}
				logToTmpFile("INFO","","Event Count for the selection is " + eventCount);
			}
			if (eventCount > 0)
			{
				if (offsetCount > eventCount/2)
				{
					if(selectedArrangeOption==null)
					{
						reverseList = true;
						offsetCount = eventCount - offsetCount;
					}
					else
					{
						reverseList = false;
						offsetCount += maxPageItems;
					}
				}
				else
				{
					reverseList = false;
					offsetCount += maxPageItems;
				}
				
				String fromLink  =request.getParameter("fromLink");
				history = getEventHistory(servers, cnames, ctypes, startTime, endTime, null,
							offsetCount, minDuration,s_state, !reverseList, egDb,mappingInfo,langinfo,selectedArrangeOption,infosearch);
			// session objects created here which is used to store the request parameters needed for pdf and csv format

				String offset = Integer.toString(offsetCount);
				String ev_count = Integer.toString(eventCount);
				String min_duration = Long.toString(minDuration);
				
				HashMap eventHist = new HashMap();
				eventHist.put("pdfheading",pdfHeading);
				eventHist.put("lst", lst);
				eventHist.put("servers",servers);
				eventHist.put("cnames", cnames);
				eventHist.put("ctypes", ctypes);
				eventHist.put("startTime", startTime);
				eventHist.put("endTime", endTime);
				eventHist.put("offsetCount", offset);
				eventHist.put("arrangeAlarms", selectedArrangeOption);
				eventHist.put("minDuration", min_duration);
				eventHist.put("s_state", s_state);
				eventHist.put("infosearch", infosearch);
				eventHist.put("s_event", s_event);
				
				HashMap eventHistDB = new HashMap();

				eventHistDB.put("nameList",nameList);
				eventHistDB.put("typeList", typeList);
				eventHistDB.put("startTime", startTime);
				eventHistDB.put("endTime", endTime);
				eventHistDB.put("eventCount", ev_count);
				eventHistDB.put("arrangeAlarms", selectedArrangeOption);
				eventHistDB.put("minDuration", min_duration);
				eventHistDB.put("s_state", s_state);
				eventHistDB.put("infosearch", infosearch);
				eventHistDB.put("s_event", s_event);
				
				session.setAttribute("eventdata", eventHist); //session object for all component access
				session.setAttribute("eventdatadb", eventHistDB); //session object for selected components

				int recordCount = history.size();
				if (recordCount > maxPageItems)
				{
					if (reverseList)
					{
						history.subList(0 , recordCount-maxPageItems).clear();
						Collections.reverse(history);
					}
					else 
					{
						
						history.subList(Math.min(offsetCount, recordCount), recordCount).clear();
						history.subList(0, offsetCount-maxPageItems).clear();
					}
				}
				else
				{
					 // If the user directly goes to the last page
					if (reverseList)
					{
						Collections.reverse(history);
					}
				}
				//rs.close();

				//Change maxWidth to any number for splitting the line
				maxWidth = 20;
				if (allEvents)
				{
					maxWidth = 15;
				}
				all = (List)this.processResults(history, maxWidth,langinfo);
			}
			egDb.releaseConnection(false);
		}
		catch(Exception se)
		{
			egDb.releaseConnection(true);
		}
		finally
		{
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
	}
%>
				
			<div id="my_div" class="div_scroll" style="width:100%;">
				<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<td width="100%"  align="center">
<%

		if (eventCount > 0 && all!=null) 
		{
			size = all.size();

			//---Configure DateTimeTokenizer for results
			DateTimeTokenizer dtt = new DateTimeTokenizer();
			dtt.setDateFormat(DateTimeTokenizer._YMD);
			dtt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
			dtt.setTimeFormat(DateTimeTokenizer.HMS);
			dtt.setYearAsYY(false);

			String selectedType = null;
			String selectedName = null;
			if (!StringUtils.isNull(selectedCompType))
			{
				selectedType = "type";
			}
			else if (!StringUtils.isNull(selectedCompName))
			{
				selectedName = "name";
			}
%>
		<!-- Indexer taglib begins here -->
		
		<id:indexer
		isOffset = "<%= true %>"
		index = "<%= index %>"
		items = "<%= eventCount%>"
		maxPageItems = "<%= maxPageItems %>"
		maxIndexPages = "<%= maxIndexPages %>"
		export = "offset,currentPageNumber=pageNumber"
		scope = "request">

		<!-- Parameters for the request query string -->
		<id:param name="eventsCount" value="<%=String.valueOf(eventCount)%>" />
		<id:param name="s_event" value="<%=s_event %>" /> 
		<id:param name="subevent" value="<%=subevent%>" />
		<id:param name="selectedsubzone" value="<%=selectedsubzone%>" />
		<id:param name="compName" value="<%=EgURLEncoder.encode((selectedCompName==null?"":selectedCompName),"UTF-8")%>" />
		<id:param name="compType" value="<%=EgURLEncoder.encode((selectedCompType==null?"":selectedCompType),"UTF-8")%>" />
		<id:param name="startDate" value="<%=startTime %>" /> 
		<id:param name="endDate" value="<%=endTime %>" /> 
		<id:param name="filterOut" value="<%=durationStr%>" />
		<id:param name="state" value="<%=s_state%>" />
		<id:param name="eventsPerPage" value="<%=eventsPerPage%>" />
		<id:param name="arrangeAlarms" value="<%=selectedArrangeOption%>" />
		<id:param name="infosearch" value="<%=infosearch%>" />

		<!-- save Indexer offset during form changes -->
		<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" height="100%">
			<tr>
				<td  width="100%">	
					<form method="POST" name="Event" style="margin:0px">

						<table width="100%" cellspacing="0" cellpadding="0" align="center" border="0">
							<tr>
<%
			int start = offset.intValue();
														
%>
								<th id="eg_cellbglight" id="white_text" width="95%" align="left"  nowrap>&nbsp;&nbsp;<%=start+1%>&nbsp;<egui:intnl text="monitor.history.to"/>&nbsp;<%=Math.min(start+maxPageItems,eventCount)%>&nbsp;<egui:intnl text="monitor.history.of"/>&nbsp;<%=eventCount%>&nbsp;<egui:intnl text="monitor.history.alarms found"/>&nbsp;</th>
									<td id="eg_cellbglight" width="20" align="right">
												<input id="eg_input" name="popup_selection"  type="checkbox" ></td>
									<td width="30" id="eg_cellbglight" align="left"><img src="/final/monitor/eg_images/icon-newwindow_o.gif" width="12" height="12"></td>
							</tr>
						</table>
				</td>
			</tr>
			<tr>
				<td colspan="3" align="center" width="100%" id="white_bg" >
					<div id="div_scroll" style="width:100%;overflow:auto;overflow-x:auto;overflow-y:auto;" align="center">
					<!--form name-->
									
						<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" style="border-left-width:0px; border-right-width:0px">
							<tr>
								<td width="100%"  align="center" rowspan="2"><input type="hidden" name="indexeroffset" value="<%=offset%>">
									<!-- THE TABLE STARTS HERE -->
									<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
										<tr>
											<td align="center" >
												<table align="center" cellspacing="0" cellpadding="0" border="0" style="table-layout:auto" width="100%">
													<col width="18"><col width="17%">
													<col width="70"><col width="10%">
													<col width="15%"><col width="48%">
													<col width="120"><col width="50">
													<col width="25" ><col width="23" >
													<tr>
														<td id="eg_cellbglightdark" class="alarm_layer_head">
															<img src="/final/monitor/eg_images/spacer.gif" width="18" height="21">
														</td>
																		
<%
		if (selectedType == null || selectedType.equals("type"))
		{
%>
														<td  nowrap="nowrap"  id="eg_cellbglightdark" class="alarm_layer_head" style="border-top-width:0px;border-left-width:0px" align="center" ><egui:intnl text="monitor.history.Comp Type"/></td>
<%
		}

		if (selectedName == null || selectedName.equals("name"))
		{
%>
														<td  id="eg_cellbglightdark" class="alarm_layer_head" nowrap="nowrap"   style="border-top-width:0px;border-left-width:0px" align="center"><egui:intnl text="monitor.history.Comp Name"/></td>

<%
		}
%>
														<td  nowrap="nowrap" id="eg_cellbglightdark" class="alarm_layer_head" style="border-top-width:0px;border-left-width:0px" align="center">&nbsp;<egui:intnl text="monitor.common.Service"/>&nbsp;</td>
														<td  nowrap="nowrap" id="eg_cellbglightdark" class="alarm_layer_head" style="border-top-width:0px;border-left-width:0px" align="center">&nbsp;<egui:intnl text="monitor.common.Test"/>&nbsp;</td>
														<td  nowrap id="eg_cellbglightdark" class="alarm_layer_head" style="border-top-width:0px;border-left-width:0px;" align="center"><egui:intnl text="monitor.common.Description"/></td>


														<td  height="20" id="eg_cellbglightdark" class="alarm_layer_head" nowrap="nowrap"  style="border-top-width:0px;border-left-width:0px" align="center"><egui:intnl text="monitor.history.Start Time"/></td>
														<td  nowrap="nowrap" id="eg_cellbglightdark" class="alarm_layer_head" align="center">&nbsp;<egui:intnl text="monitor.history.Duration"/>&nbsp;</td>

														<td  nowrap="nowrap" id="eg_cellbglightdark" class="alarm_layer_head"  align="center">&nbsp;</td>
														<td  nowrap="nowrap" id="eg_cellbglightdark" class="alarm_layer_head"  align="center">&nbsp;&nbsp;</td>
													</tr>
<%
		int historyCount = 0;
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		EgDbInfo dbInfo = new EgDbInfo(EgConstants.MANAGER);
		EgTestInfo tokInfo = new EgTestInfo(EgConstants.MANAGER);
		TestBean testBean = new TestBean();
		if(all!=null)
		for (Iterator i=all.iterator(); i.hasNext();)
		{
			
			String[] row = (String[])i.next();
			long timeDiff = Long.parseLong((String)row[7]);

			String fileName = null;
			
			if (AlarmPriorities.HIGH_PRIORITY.equals(row[10]))
			{
				fileName = "/final/monitor/eg_images/bullet_s_HIGH.gif";
			}
			else if (AlarmPriorities.MEDIUM_PRIORITY.equals(row[10]))
			{
				fileName = "/final/monitor/eg_images/bullet_s_INTERMEDIATE.gif";
			}
			else if (AlarmPriorities.LOW_PRIORITY.equals(row[10]))
			{
				fileName = "/final/monitor/eg_images/bullet_s_LOW.gif";
			}
			else if (AlarmPriorities.UNKNOWN_STATE.equals(row[10]))
			{
				fileName = "/final/monitor/eg_images/bullet_s_UNKNOWN.gif";
			}
			else //if (AlarmPriorities.GOOD_STATE.equals(row[10]))
			{
				fileName = "/final/monitor/eg_images/bullet_s_GOOD.gif";
			}

			/*
			 * 0	SITE_NAME
			 * 1	COMP_NAME
			 * 2	COMP_TYPE
			 * 3	INFO
			 * 4	TEST_NAME
			 * 5	MEASURE
			 * 6	MSMT_TIME_START
			 * 7	MSMT_TIME_END
			 * 8	MSMT_HOST
			 * 9	EVENT_ID
			 * 10	EVENT_SVRTY
			 */
			
			String test_name_value=row[4];
			String testLabel_for_display=row[3];
			String testMeasureAlert=null;
			boolean ifInside=false;
			if(testLabel_for_display!=null && testLabel_for_display.lastIndexOf("{")>-1 && testLabel_for_display.lastIndexOf("}")>-1)
			{
				testMeasureAlert=testLabel_for_display.substring(0,testLabel_for_display.lastIndexOf("{"));
				testLabel_for_display=testLabel_for_display.substring(testLabel_for_display.lastIndexOf("{")+1,testLabel_for_display.lastIndexOf("}"));
				
				ifInside=true;
				if(testLabel_for_display!=null && testLabel_for_display.startsWith("+"))
				{
					testLabel_for_display=testLabel_for_display.substring(1);
				}
			}
			
			String isSymbol=(String)egUI.getValue("Tests_For_LayerModel_Images",test_name_value);
			if(isSymbol!=null && isSymbol.trim().equalsIgnoreCase("::") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
			{
				String temp_testLabel="";
				ArrayList token_list = tokInfo.egTokenizer(testLabel_for_display, "::");
				
				if(token_list!=null && token_list.size()>0)
				{
					String end_image_name_value="";
					String tooltip_value="";
					for(int ind_no=0;ind_no<token_list.size();ind_no++)
					{
						String path=(String)token_list.get(ind_no);

						if(ind_no==0)
						{
							end_image_name_value="vsphere_datacenter_11";
							tooltip_value="monitor.layermodel.Datacenter";
						}
						else if(ind_no==1)
						{
							end_image_name_value="vsphere_cluster_11";
							tooltip_value="monitor.layermodel.Cluster";
						}
						else if(ind_no==2)
						{
							end_image_name_value="vsphere_resourcepool_11";
							tooltip_value="monitor.layermodel.monitor.layermodel.Resource&nbsp;pool";
						}

						if(path!=null && path.trim().length()>0)
						{
							ArrayList path_list = tokInfo.egTokenizer(path, "->");
							if(path_list!=null && path_list.size()==2)
							{
								String folder_part=(String)path_list.get(0);
								if(folder_part!=null && folder_part.trim().length()>0)
								{
									ArrayList folder_list = tokInfo.egTokenizer(folder_part, "\\");
									if(folder_list!=null && folder_list.size()>0)
									{
										for(int w=0;w<folder_list.size();w++)
										{
											String folder_name=(String)folder_list.get(w);

											temp_testLabel=temp_testLabel+" <img src ='/final/monitor/eg_images/vsphere_folder_11.png'  border = '0' onmouseover=Tip('"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"',FONTWEIGHT,\'bold\',FONTSIZE,\'8pt\',BGCOLOR,\'#FFFFE1\') onmouseout='UnTip()' title='"+mappingInfo.getTextDescription("monitor.layermodel.Folder")+"'/> "+folder_name.trim();
										}
									}
								}

								String dc_or_cl_rp_path=(String)path_list.get(1);
								if(dc_or_cl_rp_path!=null && dc_or_cl_rp_path.trim().length()>0)
								{
									ArrayList dc_or_cl_rp_list = tokInfo.egTokenizer(dc_or_cl_rp_path,"/");
						
									if(dc_or_cl_rp_list!=null && dc_or_cl_rp_list.size()>0)
									{
										for(int w=0;w<dc_or_cl_rp_list.size();w++)
										{
											String dc_or_cl_rp_name=(String)dc_or_cl_rp_list.get(w);
											temp_testLabel=temp_testLabel+" <img src ='/final/monitor/eg_images/"+end_image_name_value+".png'  border = '0' onmouseover=Tip('"+mappingInfo.getTextDescription(tooltip_value)+"',FONTWEIGHT,\'bold\',FONTSIZE,\'8pt\',BGCOLOR,\'#FFFFE1\') onmouseout='UnTip()' title='"+mappingInfo.getTextDescription(tooltip_value)+"'/> "+dc_or_cl_rp_name.trim();
										}
									}
								}
							}
							else if(path_list!=null && path_list.size()==1)
							{
								String dc_or_cl_rp_path=(String)path_list.get(0);
								if(dc_or_cl_rp_path!=null && dc_or_cl_rp_path.trim().length()>0)
								{
									ArrayList dc_or_cl_rp_list = tokInfo.egTokenizer(dc_or_cl_rp_path,"/");
						
									if(dc_or_cl_rp_list!=null && dc_or_cl_rp_list.size()>0)
									{
										for(int w=0;w<dc_or_cl_rp_list.size();w++)
										{
											String dc_or_cl_rp_name=(String)dc_or_cl_rp_list.get(w);
											temp_testLabel=temp_testLabel+" <img src ='/final/monitor/eg_images/"+end_image_name_value+".png'  border = '0' onmouseover=Tip('"+mappingInfo.getTextDescription(tooltip_value)+"',FONTWEIGHT,\'bold\',FONTSIZE,\'8pt\',BGCOLOR,\'#FFFFE1\') onmouseout='UnTip()' title='"+mappingInfo.getTextDescription(tooltip_value)+"'/> "+dc_or_cl_rp_name.trim();
										}
									}
								}
							}
						}
					}
					if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
						testLabel_for_display=temp_testLabel;
				}
			}
			else if(isSymbol!=null && isSymbol.trim().equalsIgnoreCase("/") && testLabel_for_display!=null && testLabel_for_display.trim().length()>0)
			{
				String temp_testLabel="";
				ArrayList resourcepool_list = tokInfo.egTokenizer(testLabel_for_display,"/");
				if(resourcepool_list!=null && resourcepool_list.size()>0)
				{
					for(int w=0;w<resourcepool_list.size();w++)
					{
						String resourcepool_name=(String)resourcepool_list.get(w);
						temp_testLabel=temp_testLabel+" <img src ='/final/monitor/eg_images/vsphere_resourcepool_11.png'  border = '0' onmouseover=Tip('"+mappingInfo.getTextDescription("monitor.layermodel.Resource&nbsp;pool")+"',FONTWEIGHT,\'bold\',FONTSIZE,\'8pt\',BGCOLOR,\'#FFFFE1\') onmouseout='UnTip()' title='"+mappingInfo.getTextDescription("monitor.layermodel.Resource&nbsp;pool")+"'/> "+resourcepool_name.trim();
					}
				}
				if(temp_testLabel!=null && temp_testLabel.trim().length()>0)
					testLabel_for_display=temp_testLabel;
			}

			if(ifInside && testLabel_for_display!=null && testMeasureAlert!=null && testMeasureAlert.trim().length()>0)
			{
				testLabel_for_display=testMeasureAlert+" {"+testLabel_for_display+"}";
			}
			

			String[] data = (String[])history.get(historyCount);
			StringBuffer urlForImages = new StringBuffer(128);
			urlForImages.append("site=");
			if(data[0].equals("NULL"))
			{
				urlForImages.append("-1");
			}
			else
			{
				urlForImages.append(data[0]);
			}
			urlForImages.append("&comptype=");
			urlForImages.append(data[2]);			
			String s_host = Server.getServerNameWithoutPort(data[1]);
			urlForImages.append("&host=");
			urlForImages.append(s_host);
			
			String s_port = Server.getServerPort(data[1], false);
			urlForImages.append("&port=");
			urlForImages.append(s_port);

			String comp_name=data[1];
			String sid="";
			StringTokenizer st=new StringTokenizer(comp_name,":");
			if(st.countTokens()==3)
			{
				if(comp_name!=null && comp_name.trim().length()>0)
					sid=comp_name.substring(comp_name.lastIndexOf(":")+1);
			}
			if(sid!=null && sid.trim().length()>0 && !sid.equalsIgnoreCase("NULL"))
			{
				urlForImages.append("&sid=");
				urlForImages.append(sid);
			}
			String layer = tablesInfo.getRelevantLayer(data[2], data[4], data[5]);
			urlForImages.append("&layer=");
			urlForImages.append(layer);

			urlForImages.append("&test=");
			urlForImages.append(data[4]);
			String s_info ="";
			String s_comp = s_host + ":" +s_port;
			if(data[1].startsWith(s_comp + ":"))
				s_info = data[1].substring(s_comp.length() + 1);
			String info_spl=data[3];
			if(info_spl!=null && info_spl.startsWith("+"))
				info_spl="*"+info_spl.substring(1);
			if(info_spl!=null && info_spl.indexOf("+")>-1)
			{
				info_spl=com.egurkha.util.StringUtils.replace(info_spl,"+","|plus|");
			}
			if(info_spl!=null && info_spl.indexOf("&")>-1)
			{
				info_spl=com.egurkha.util.StringUtils.replace(info_spl,"&","|amp|");
			}
			if(info_spl!=null && info_spl.indexOf("%")>-1)
			{
				info_spl=com.egurkha.util.StringUtils.replace(info_spl,"%","|pct|");
			}
			//s_info += data[3].replace('+', '*');
			s_info += info_spl;
			//if(s_info.indexOf("*") > 0)
			{
				//s_info = s_info.substring(s_info.indexOf("*"));
			}
			urlForImages.append("&stest=");
			//urlForImages.append(data[4]+"-" + data[3].replace('+','*'));
			urlForImages.append(data[4]+"-" + info_spl);
			urlForImages.append("&info=");
			urlForImages.append(s_info);
			urlForImages.append("&msmt_host=");
			urlForImages.append(data[8]);
			urlForImages.append("&time=Any");
			urlForImages.append("&timeline=Any");
			dtt.setStartDateTime(data[6]);
			urlForImages.append("&starttime=");
			urlForImages.append(dtt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));

			urlForImages.append("&starthr=");
			String graphStartTime = dtt.getStartTime();
			urlForImages.append(graphStartTime.substring(0, graphStartTime.indexOf(EgConstants.COLON)));

			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Calendar calendar = Calendar.getInstance();
			if (timeDiff < 0)
			{
				calendar.setTime(new java.util.Date(new EgDateInfo().egetUTCDate(false)));
			}
			else
			{
				ParsePosition pos = new ParsePosition(0);
				java.util.Date endDate = sdf.parse(data[7], pos);
				calendar.setTime(endDate);
			}

			calendar.add(Calendar.HOUR_OF_DAY, 1);
			dtt.setEndDateTime(sdf.format(calendar.getTime()));

			urlForImages.append("&endtime=");
			urlForImages.append(dtt.getEndDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));

			urlForImages.append("&endhr=");
			String graphEndTime = dtt.getEndTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR);
			urlForImages.append(graphEndTime.substring(0, graphEndTime.indexOf(EgConstants.COLON)));

			String urlStr = urlForImages.toString();
%>
									<id:item>
													<tr>
														<td nowrap="nowrap" align="center" id="<%=row[10]%>alarms" class="alarm_td" TITLE='<%=mappingInfo.getLabelDescription(row[10])%>' style="border-top: 1px solid #ffffff;">
														<img src="/final/monitor/eg_images/spacer.gif" border="0" height="8" width="8">
														</td>
																	
<%
			if (selectedType == null || selectedType.equals("type"))
			{
				
				row[2]= mappingInfo.getComponentTypeDescription(row[2]);
				//out.println(split(row[2], maxWidth));
%>
															
														<td align="left" class="alarm_td" wrap>
<%
				if (row[2].length() <= displayLength)
				{
					out.println(row[2]);
				}
				else
				{
%>
					<a href="#" target="" class="eg_monlink" title="<%=row[2]%>">
						<egui:display name="<%=row[2]%>" length="<%=Integer.toString(displayLength)%>"/>
					</a>
<%
				}
%>
														</td>
<%
			}

			if (selectedName == null || selectedName.equals("name"))
			{
				if (((String)row[1]).endsWith(EgConstants.NULL_PORT))
				{
					row[1] = Server.getServerNameWithoutPort((String)row[1], false);
				}
%>
				<!-- Component -->
														<td  align="left" nowrap class="alarm_td">
<%
				if (row[1].length() <= displayLength)
				{
					out.println(row[1]);
				}
				else
				{
%>
					<a href="#" target="" class="eg_monlink" title="<%=row[1]%>">
						<egui:display name="<%=row[1]%>" length="<%=Integer.toString(displayLength)%>"/>
					</a>
<%
				}
%>
														</td>
<%
			}

			String salign="left";
			String s_id = "eg_alarmcontenthist";
			if(row[0].equals("NONE"))
			{
				row[0] = "-";
				salign="center";
				s_id = "eg_alarmcontenthistcnt";
			}
%>
		
			<!-- Service -->
														<td id="<%=s_id%>" align="<%=salign%>" nowrap="nowrap" class="alarm_td">
<%
			if (row[0].equals("-"))
			{
				out.println(row[0]);
			}
			else
			{
				if (row[0].length() <= displayLength-2)
				{
					out.println(row[0]);
				}
				else
				{
%>
					<a href="#" target="" class="eg_monlink" title="<%=row[0]%>">
						<egui:display name="<%=row[0]%>" length="<%=Integer.toString(displayLength-2)%>"/>
					</a>
<%
				}
			}
%>
														</td>
			<!-- Test -->
														<td  align="left" nowrap="nowrap" class="alarm_td" >
<%
			row[4]= mappingInfo.getTestDescription(row[4]);
			out.println(split(row[4], 20));

%>
														<td  align="left" wrap class="alarm_td" >
<%
			//out.println(row[3]);
			out.println(testLabel_for_display);
			String displayDate = "";
			if(row[6] != null && !row[6].equals(""))
			{
				displayDate = DateUtil.changeDateFormat(row[6],"MM/dd/yy HH:mm",currentDateFormat);
			}
%>				
			<!-- Start Time -->
														<td  class="alarm_td" align="center"  nowrap="nowrap"><%=displayDate %></td>
			<!-- Duration -->
														<td  align="center" nowrap="nowrap" class="alarm_td">
<%
			if (timeDiff < 0)
			{
				String urlType = row[2];
				String urlComp = row[1];
				
%>
			<!--<a href="/final/monitor/componentTabSet.jsp?monCmd=componentDashboard&componentName=<%//=urlType%>:<%//=urlComp%>" class="type_comps"><egui:intnl text="Current"/></a>-->
				<egui:intnl text="monitor.history.Current"/>
<%				//out.print("Current");
			}
			else
			{
				out.print(DateTimeTokenizer.getTimeDifference(timeDiff));
			}
%>
														</td>


			<!-- Priority Colour -->
			<!--<td id="<%//=row[9]%>border" width="10" nowrap="nowrap">&nbsp;</td>-->
<%
			String mes = dbInfo.getColumnForMeasure(data[4], data[5]);
																
			urlStr=com.egurkha.util.StringUtils.replace(urlStr, "\\", "\\\\");
			String thisQuery = urlStr + "&measure=" + mes +"&gtype=0&draw=1&gformat=graph&from=test&mode=3D&qctr=5&search=&thisIs=event&showRange=Range";
%>
														<td  align="center" nowrap="nowrap"  class="alarm_td" style="padding-left:1px;padding-right:3px">
														<a id="mouse" onClick="javascript:popupValue('<%=thisQuery%>','data')" >
														<img src="/final/monitor/eg_images/graph-o.gif" alt="<egui:intnl text='monitor.common.GRAPH'/>" border="0" align="absBottom" title="<egui:intnl text='monitor.common.GRAPH'/>"/></a>
														</td>
<%
			boolean isAgentlessServer = agentInfo.isAgentlessServer(s_host, data[2],true);
			boolean isTestExternal =specsInfo.isTestExternal(data[4]);
			//System.out.println("SRI : EVENT>. test " + data[4]);
			//System.out.println("SRI : EVENT>. ddEnabled " + ddEnabled);
			//System.out.println("SRI : EVENT>. testBean ddenab " + testBean.isDdEnabled(data[4],data[5]));
			//System.out.println("SRI : EVENT>. isAgentlessServer " + !isAgentlessServer);
			//System.out.println("SRI : EVENT>. isTestExternal " + isTestExternal);
%>
														<td  class="alarm_td" style="width:18px;padding:0px" align="center" width="18">
<%

			boolean showDDIcon = false;
			if ((ddEnabled && testBean.isDdEnabled(data[4], data[5])  && (!isAgentlessServer || isTestExternal)) || (ddEnabled && testBean.isDdEnabled(data[4], data[5])))
			{
				thisQuery = urlStr + "&measure=" + data[5] + "&from=0&firsttime=true&flag=1";

				if(s_info!=null && s_info.indexOf("*")>-1)
					s_info=com.egurkha.util.StringUtils.replace(s_info,"*","+");

				showDDIcon = dd.ShowDDData(data[0],s_host,data[4],data[5],s_info,data[8]);

				if(showDDIcon)
				{
%>
														<a id="mouse" onClick="javascript:popupValue('<%=thisQuery%>','dd')">
														<img src="/final/monitor/eg_images/Diagnosis-o.gif" alt="<egui:intnl text='monitor.common.DIAGNOSIS'/>" border="0" align="absBottom" title="<egui:intnl text='monitor.common.DIAGNOSIS'/>"/></a>
<%
				}
				else
				{
					out.println("<img src='/final/monitor/eg_images/spacer.gif' width='18'>");
				}
			}
			else

			{
				out.print("<img src='/final/monitor/eg_images/spacer.gif' width='18'>");
			}
%>
														</td>
													</tr>

<% 

	//to display acknowledgement details as a sub-table in event history page
	//start
	Hashtable hTable = putAcknowledgeDetails(row[9]);
	ArrayList ackData_aList_outer = new ArrayList();
	ArrayList ackData_aList_inner = new ArrayList();

	String user_ID = "";
	String ack_Desc = "";
	String ack_Time = "";
	String action = "";

	if(hTable.containsKey(row[9]))
	{
			
%>

<tr>
	<td colspan="10">
		<table align = "center" cellspacing = "0" cellpadding = "0" width = "100%" border = "0">
		<tr>
			<td id = "eg_whitebg" width = "100%">
				<table align = "center" cellspacing = "0" cellpadding = "0" width = "100%" border = "0" id = "alarm_main_border">
				<tr>
					<td id = "eg_alarmlayerhead" width = "25%" class = "alarm_layer_head" style="font-size:10px"><egui:intnl text = "monitor.currentAlarms.USER"/></td>
					<td id = "eg_alarmlayerhead" width = "24%" class = "alarm_layer_head" style="font-size:10px"><egui:intnl text = "monitor.currentAlarms.ACKNOWLEDGEMENT DETAIL"/></td>
					<td id = "eg_alarmlayerhead"   width = "11%" height = "18" class = "alarm_layer_head" style="font-size:10px"><egui:intnl text = "monitor.currentAlarms.ACTION"/></td>
					<td id = "eg_alarmlayerhead"   width = "11%" height = "18" class = "alarm_layer_head" style="font-size:10px"><egui:intnl text = "monitor.currentAlarms.TIME"/></td>
				</tr>

<%
			ackData_aList_outer = (ArrayList)hTable.get(row[9]);
			for(int kk=0; kk<ackData_aList_outer.size(); kk++)
			{
				ackData_aList_inner =  (ArrayList) ackData_aList_outer.get(kk);
			
				user_ID = (String) ackData_aList_inner.get(0);
				ack_Desc = (String) ackData_aList_inner.get(1);
				action = (String) ackData_aList_inner.get(2);
				ack_Time = (String) ackData_aList_inner.get(3);
				ack_Time = DateUtil.changeDateFormat(ack_Time,"yyyy-MM-dd HH:mm:s",currentDateFormat);
%>
				<tr>
					<td class = "alarm_td" id = "eg_cellbgmedium" height = "15">&nbsp;<%=user_ID%>&nbsp;</td>
					<td class = "alarm_td" id = "eg_cellbgmedium" height = "15">&nbsp;<%=ack_Desc%>&nbsp;</td>
					<td class = "alarm_td" id = "eg_cellbgmedium" height = "15">&nbsp;<%=action%>&nbsp;</td>
					<td class = "alarm_td" id = "eg_cellbgmedium" height = "15">&nbsp;<%=ack_Time%>&nbsp;</td>
				</tr>
<%
			}
%>
				</table>
			</td>
		</tr>
		</table>
	</td>
</tr>
<%
	}
	//end of part acknowledgement details
%>

	
					
					</id:item>
<%
			historyCount++;
		} //---end of the for loop
%>

															</table>
														</td>
													</tr>

												</table>
										<!-- THE TABLE ENDS HERE -->
										<!-- CODE FOR BUTTONS STARTS HERE -->
<%
	//System.out.println("SRI: EVENT>. eventCount " + eventCount);	
	//System.out.println("SRI: EVENT>. maxPageItems " + maxPageItems);	
	int fCount =0;
	if (eventCount > maxPageItems)
		{
%>
			<table align="center" cellspacing="0" cellpadding="2"  width="100%" border="0" id="eg_cellbglight" class="linebottom">
				<tr>
					<td align="center" width="100%" valign="bottom">
						<table cellspacing="0" cellpadding="0" align="center" border="0" style="table-layout:collapse" width="100%">
	
							<tr>
								<td align="right" nowrap> &nbsp; &nbsp; <egui:intnl text="monitor.history.Go to page"/> # :&nbsp;</td>
								<td nowrap><input type="text" name="pageno" width="6" size="3" style="width: 35px; text-align: center;" >&nbsp;</td>
								<td nowrap> <img src="/final/monitor/eg_images/arrow_1.gif" name="gotopage" onClick="onGoToPage(<%=maxPageItems%>, <%=eventCount%>)" alt="<egui:intnl text='monitor.common.Go'/>" id="eg_input" class="mouse"> </td>
								<td width="15%">&nbsp;</td>
						<id:index><id:pages>
<%
																				
			if(!(String.valueOf(currentPageNumber)).equals("1") && fCount == 0)
			{
				fCount++;
%>
								<td align="left" nowrap width="90">&nbsp;
								<id:first export="firstPageUrl=pageUrl">
								<a href="#"  id="eg_monlink" onClick='window.location.href = "<%=firstPageUrl%>"'/>
								<img src="/final/monitor/eg_images/back-arrow.gif" border="0">
								<img src="/final/monitor/eg_images/back-arrow.gif" border="0">&nbsp;<b><egui:intnl text="monitor.history.FIRST"/></b></a>
																			

						</id:first>
								</td>
<%
			}
%>
									</id:pages>
						<id:prev export="prevPageUrl=pageUrl">

								<td align="left" nowrap>			
								<a href="#"  id="eg_monlink" onClick='window.location.href = "<%=prevPageUrl%>"'/><img src="/final/monitor/eg_images/back-arrow.gif" border="0">&nbsp;<b><egui:intnl text="monitor.history.PREV"/></b></a>
								</td>
						</id:prev>
																		
								<td align="right"  width="40%">

									<id:pages>
<%
			if (pageNumber.equals(currentPageNumber))
			{
%>
				<span id="page_no"><%= pageNumber %></span>
<%
			}
			else
			{
%>
				&nbsp;<a href="<%=pageUrl%>&fromLink=true" id="eg_alarmlink"><%= pageNumber%></a>
<%
			}
%>
									</id:pages>&nbsp; &nbsp;</td>
						<id:next export="nextPageUrl=pageUrl">
									<td align="center" nowrap width="85">
									<a href="#"  id="eg_monlink" onClick='window.location.href = "<%=nextPageUrl%>"'/><b><egui:intnl text="monitor.history.NEXT"/></b>&nbsp;<img src="/final/monitor/eg_images/forward-arrow.gif" border="0"></a>
									</td>
						</id:next>
															
<%
			if(Math.min(start+maxPageItems,eventCount) < eventCount)
			{
%>
									<td align="right" nowrap width="90">
									<id:last export="lastPageUrl=pageUrl"> <a href="#"  id="eg_monlink" onClick='window.location.href = "<%=lastPageUrl%>"'/><b><egui:intnl text="monitor.history.LAST"/></b>&nbsp;<img src="/final/monitor/eg_images/forward-arrow.gif" border="0"><img src="/final/monitor/eg_images/forward-arrow.gif" border="0"></a>
									</id:last>
									</td>

<%
			}
%>
															
															
					</id:index>
									<td width="25%">&nbsp;</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</form>
										
												
<%
		}
%>
					</id:indexer>
								<!-- CODE FOR BUTTONS ENDS HERE -->
												</td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
							<!-- <tr><td width="100%" align="center"   height="10">&nbsp;</td></tr> -->
						</table>
					</td>
				</tr>
			<tr>
		<td>
<%
	} //---end of the Show alarms If size > 0
	else 
	{
	//---Show the smiley otherwise
%>
					<table align="center" cellspacing="0" cellpadding="2" border="0" valign="middle" height="100%" width="100%">
						<tr>
							<td height="170">&nbsp;</td>
						</tr>
						<tr>
							<th id="eg_alarmth" align="center" valign="middle" height="100%">
								<table align="center" cellspacing="0" cellpadding="10" border="0">
									<tr>
										<td align="center"><img src="../monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif" align="center" border="0" /></td>
									</tr>
									<tr>
										<td align="center" id="eg_errorsmall"><egui:intnl text="monitor.history.No alarms found"/></td>
									</tr>
								</table>
							</th>
						</tr>
					</table>
<%
	} //---end of the Show smiley Else
%>
				</div>
			</td>
		</tr>
	</table>

<%!
	String blank = "&nbsp;";
	private String tmpFile = EgInstallInfo.getInstallDir()+"/manager/logs/tmp.log";
	private boolean tmpLog = false;

	public boolean includeInTable(long value1, long value2, char condition)
	{
		if (condition == '<') 
		{
			return (value1 < value2);
		} else // if (condition.equals(">") 
		{
			return (value1 > value2);
		}
	}

	public List processResults(List list, int maxWidth,LangInfo langinfo) 
	{
		List results = new LinkedList();

		int length = 0;
		int oldWidth = maxWidth;

		String nullStr = EgConstants.NULL_STRING.toUpperCase();

		DateTimeTokenizer dt = new DateTimeTokenizer();
		dt.setDateFormat(DateTimeTokenizer._YMD);
		dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
		dt.setTimeFormat(DateTimeTokenizer.HMS);
		dt.setYearAsYY(true);

		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		for (int z=0; z<list.size(); z++)
		{
			String[] values = (String[])list.get(z);
			String[] row = new String[values.length];
			System.arraycopy(values, 0, row, 0, row.length);

			int a = 0;
			//Site name
			if (StringUtils.isNull(row[a]) || row[a].equals(nullStr))
			{
				row[a] = "NONE";
			}
			else
			{
				if (row[a].length() > maxWidth)
				{
					//row[a] = split(row[a], maxWidth);
				}
			}

			a++;	//a = 1
			//Comp Name
			if (row[a].endsWith(EgConstants.NULL_PORT))
			{
				row[a] = Server.getServerNameWithoutPort(row[a], false).trim();
			}

			if (row[a].length() > maxWidth)
			{
				//row[a] = mergeSplitStr(StringUtils.split(row[a], EgConstants.COLON));
				//row[a] = split(row[a], maxWidth);
			}

			a++;	//a = 2 
			//Comp Type

			a++;	// a = 3
			//Info
			StringBuffer key = new StringBuffer();
			key.append(row[4]);
			key.append(EgConstants.COLON);
			key.append(row[5]);
			String description = tablesInfo.getMeasureAlert(key.toString(), row[3],thisLanguage);
			row[3] = description;


			a++;
			//Test name
			if (row[a].length() > maxWidth)
			{
				//String tagTest = langinfo.getValue("TEST_NAME_MAPPING",row[a]);
				/*if(tagTest != null && !tagTest.equals(""))
				{
					row[a] = tagTest;
				}*/
				//row[a] = split(row[a], maxWidth);
			}

			a++;
			//Measure
			//Ignored because it will be taken care of while displaying meaningful messages

			a++;
			//Start time
			StringBuffer value = new StringBuffer();
			dt.setStartDateTime((String)row[a]);
			value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
			value.append(DateTimeTokenizer.BLANK_SPACE);
			value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
			row[a] = value.toString();
			a++;
			//End time
			String temp = row[a];
			value = new StringBuffer();
			if ((row[a] != null) && (row[a].indexOf("1900") == -1))
			{
				dt.setEndDateTime(row[a]);
				long tDiff = dt.getDateDifference();
				value.append(tDiff);
			}
			else
			{
				java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				sdf.setTimeZone(EgDateInfo.getRealTimeZone());
				java.util.Date today = new java.util.Date((new EgDateInfo()).egetUTCDate());
				
				dt.setEndDateTime(sdf.format(today));
				value.append("-");
				value.append(dt.getDateDifference());
			}

			row[a] = value.toString();
			
			results.add(row);
		}
		return results;
	}

	private String mergeSplitStr(String[] splits)
	{
		StringBuffer value = new StringBuffer();

		for (int a=0; a<splits.length; a++)
		{
			value.append(splits[a]);
			value.append("<br>");
		}

		return value.toString();
	}

	private String split (String string, int width)
	{
		/*String breakStr = "<br>&nbsp;";
		StringBuffer splitStr = new StringBuffer();

		int times = string.length()/width;
		int start = 0;
		for (int a=0; a<times; a++)
		{
			splitStr.append(string.substring(start, start+width));
			splitStr.append(blank);
			start += width;
			splitStr.append(breakStr);
		}

		splitStr.append(string.substring(width*times));*/
		StringBuffer splitStr = new StringBuffer();
		String[] tokens;
		String delimiter = ":";
		if (string.indexOf(delimiter) == -1)
		{
			/*tokens = new String[1];
			tokens[0] = string;*/
			int count = string.length()/width;
			if (string.length()%width > 0)
			{
				count++;
			}
			
			tokens = new String[count];
			for (int a=0; a<count; a++)
			{
				tokens[a] = string.substring(a*width, Math.min(string.length(), (a+1)*width));
				splitStr.append(tokens[a]);
				if(a < count-1)
				{
					splitStr.append("<br>&nbsp;");
				}

			}

		}
		else
		{
			StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
			int count = tokenizer.countTokens();

			tokens = new String[count];
			for (int a=0; a<count; a++)
			{
				tokens[a] = tokenizer.nextToken();
				splitStr.append(tokens[a]);
				if(a < count-1)
				{
					splitStr.append(":<br>&nbsp;");
				}
			}
		}
		return splitStr.toString();
	}
	
	public int getEventsCount(
		List servers,
		String compNames,
		String compTypes,
		String fromDate,
		String toDate,
		long durationFilter,String state, EgDbAdapterUI egDb)
	{
		EgDateInfo dateInfo = new EgDateInfo();
		int count = 0;
		//TODO Check the date format for compatibility
		StringBuffer sb = new StringBuffer();
		if (servers.isEmpty())
		{//all component access and choosing all events
			if (durationFilter != 0)
			{
				if (EgDbInfo.isOraAdapter)
				{
					sb.append("SELECT MSMT_TIME_START,MSMT_TIME_END FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					sb.append(fromDate);
					sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
					sb.append(toDate);
					sb.append("','mm/dd/yyyy hh24:mi') ");
				}
				else
				{
					sb.append("SELECT MSMT_TIME_START,MSMT_TIME_END FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' '");
					sb.append(" AND MSMT_TIME_START BETWEEN convert(datetime,'");
					sb.append(fromDate);
					sb.append("', 101) AND convert(datetime,'");
					sb.append(toDate);
					sb.append("', 101) ");
				}

				if(EgDbInfo.isOraAdapter)
				{
					sb.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					sb.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}

				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				boolean lessThanZero = (durationFilter < 0);
				durationFilter = Math.abs(durationFilter);

				logToTmpFile("INFO","","Query for events count 1 "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());
				try
				{
					if(rs != null)
					{
						DateTimeTokenizer dt = new DateTimeTokenizer();
						dt.setDateFormat(DateTimeTokenizer._YMD);
						dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
						dt.setTimeFormat(DateTimeTokenizer.HMS);
						dt.setYearAsYY(true);
						while (rs.next())
						{
							String start_time_value=rs.getString(1);
							String end_time_value=rs.getString(2);

							//Start time
							StringBuffer value = new StringBuffer();
							if(start_time_value!=null && start_time_value.trim().length()>0)
							{
								dt.setStartDateTime((String)start_time_value);
								value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
								value.append(DateTimeTokenizer.BLANK_SPACE);
								value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
								start_time_value = value.toString();
							}
							value = new StringBuffer();

							if ((end_time_value != null) && (end_time_value.trim().length()>0) && (end_time_value.indexOf("1900") == -1))
							{
								dt.setEndDateTime(end_time_value);
								long tDiff = dt.getDateDifference();
								
								if (lessThanZero)
								{
									if(tDiff<durationFilter)
									{
										count++;
									}
								}
								else
								{
									if(tDiff>durationFilter)
									{
										count++;
									}
								}
							}
						}
					}
					try
					{
						rs.close();
						rs = null;
					}
					catch (Exception grrr)
					{
					}
				}
				catch (SQLException e)
				{
					// TODO Auto-generated catch block
					// logger.error("Error retrieving events count ", e);
				}
				return count;
			}
			else
			{
				if (EgDbInfo.isOraAdapter)
				{
					sb.append("SELECT COUNT(EVENT_ID) FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					sb.append(fromDate);
					sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
					sb.append(toDate);
					sb.append("','mm/dd/yyyy hh24:mi') ");
				}
				else
				{
					sb.append("SELECT COUNT(EVENT_ID) FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' '");
					sb.append(" AND MSMT_TIME_START BETWEEN convert(datetime,'");
					sb.append(fromDate);
					sb.append("', 101) AND convert(datetime,'");
					sb.append(toDate);
					sb.append("', 101) ");
				}
				
				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				logToTmpFile("INFO","","Query for events count 1 "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());
				try
				{
					if (rs != null && rs.next())
					{
						count = rs.getInt(1);
						try {
							rs.close();
							rs = null;
						} catch (Exception grrr)
						{
						}
					}
				}
				catch (SQLException e)
				{
					// TODO Auto-generated catch block
					// logger.error("Error retrieving events count ", e);
				}
				return count;
			}
		}
		else
		{
			if (durationFilter != 0)
			{
				// restricted access or using specific comp-name and type 
				if (EgDbInfo.isOraAdapter)
					sb.append("SELECT COMP_TYPE||':'||COMP_NAME,MSMT_TIME_START,MSMT_TIME_END FROM EVENT_HIST WHERE SITE_NAME>' ' and ");
				else
					sb.append("SELECT COMP_TYPE+':'+COMP_NAME,MSMT_TIME_START,MSMT_TIME_END FROM EVENT_HIST WHERE SITE_NAME> ' ' AND ");


				if (compNames.length()==0)
				{// filter based on comp_type
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						//sb.append("', 101) AND convert(datetime,'")
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
				else 
				{ // filter based on comp_name 
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);

						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}

						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
				
				if(EgDbInfo.isOraAdapter)
				{
					sb.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					sb.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}

				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				boolean lessThanZero = (durationFilter < 0);
				durationFilter = Math.abs(durationFilter);

				logToTmpFile("INFO","","Query for events count "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());

				count = 0;
				try
				{
					if (rs != null)
					{
						DateTimeTokenizer dt = new DateTimeTokenizer();
						dt.setDateFormat(DateTimeTokenizer._YMD);
						dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
						dt.setTimeFormat(DateTimeTokenizer.HMS);
						dt.setYearAsYY(true);
						while (rs.next())
						{
							String s = rs.getString(1);
							if (servers.contains(s))
							{
								String start_time_value=rs.getString(2);
								String end_time_value=rs.getString(3);

								//Start time
								StringBuffer value = new StringBuffer();
								if(start_time_value!=null && start_time_value.trim().length()>0)
								{
									dt.setStartDateTime((String)start_time_value);
									value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
									value.append(DateTimeTokenizer.BLANK_SPACE);
									value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
									start_time_value = value.toString();
								}
								value = new StringBuffer();
								if ((end_time_value != null) && end_time_value.trim().length()>0 && (end_time_value.indexOf("1900") == -1))
								{
									dt.setEndDateTime(end_time_value);
									long tDiff = dt.getDateDifference();
									
									if (lessThanZero)
									{
										if(tDiff<durationFilter)
										{
											count++;
										}
									}
									else
									{
										if(tDiff>durationFilter)
										{
											count++;
										}
									}
									
								}
							}
						}
						try 
						{
							rs.close();
							rs = null;
						} 
						catch (Exception grrr)
						{
						}
					}
				}
				catch (SQLException e)
				{
					try 
					{
						rs.close();
						rs = null;
					} 
					catch (Exception grrr)
					{
					}
				}
				return count;
			}
			else
			{
				// restricted access or using specific comp-name and type 
				if (EgDbInfo.isOraAdapter)
					sb.append("SELECT COMP_TYPE||':'||COMP_NAME FROM EVENT_HIST WHERE SITE_NAME>' ' and ");
				else
					sb.append("SELECT COMP_TYPE+':'+COMP_NAME FROM EVENT_HIST WHERE SITE_NAME> ' ' AND ");

				if (compNames.length()==0)
				{// filter based on comp_type
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						//sb.append("', 101) AND convert(datetime,'")
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
				else 
				{ // filter based on comp_name 
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
			
				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				logToTmpFile("INFO","","Query for events count "+sb.toString());

				ResultSet rs = egDb.dbselect(sb.toString());
				count = 0;
				try
				{
					if (rs != null)
					{
						while (rs.next())
						{
							String s = rs.getString(1);
							if (servers.contains(s))
							{
								count ++;
							}
						}
						try {
							rs.close();
							rs = null;
						} catch (Exception grrr)
						{
						}
					}
				}
				catch (SQLException e)
				{
					try {
						rs.close();
						rs = null;
					} catch (Exception grrr)
					{
					}
				}
				return count;
			}
		}
	}
	
	public int getEventsCount(
		List servers,
		String compNames,
		String compTypes,
		String fromDate,
		String toDate,
		long durationFilter,String state, EgDbAdapterUI egDb,String infosearch,EgMappingInfo mappingInfo)
	{
		EgDateInfo dateInfo = new EgDateInfo();
		int count = 0;
		//TODO Check the date format for compatibility
		StringBuffer sb = new StringBuffer();
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		if (servers.isEmpty())
		{//all component access and choosing all events
			if (durationFilter != 0)
			{
				if (EgDbInfo.isOraAdapter)
				{
					sb.append("SELECT MSMT_TIME_START,MSMT_TIME_END,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					sb.append(fromDate);
					sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
					sb.append(toDate);
					sb.append("','mm/dd/yyyy hh24:mi') ");
				}
				else
				{
					sb.append("SELECT MSMT_TIME_START,MSMT_TIME_END,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' '");
					sb.append(" AND MSMT_TIME_START BETWEEN convert(datetime,'");
					sb.append(fromDate);
					sb.append("', 101) AND convert(datetime,'");
					sb.append(toDate);
					sb.append("', 101) ");
				}

				if(EgDbInfo.isOraAdapter)
				{
					sb.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					sb.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}

				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				boolean lessThanZero = (durationFilter < 0);
				durationFilter = Math.abs(durationFilter);
				logToTmpFile("INFO","","Query for events count 1 "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());
				try
				{
					if(rs != null)
					{
						DateTimeTokenizer dt = new DateTimeTokenizer();
						dt.setDateFormat(DateTimeTokenizer._YMD);
						dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
						dt.setTimeFormat(DateTimeTokenizer.HMS);
						dt.setYearAsYY(true);
						while (rs.next())
						{
							String start_time_value=rs.getString(1);
							String end_time_value=rs.getString(2);
							StringBuffer desc_key=new StringBuffer();
							String test = rs.getString(4);
							String measure = rs.getString(5);
							String info = rs.getString(3);
							desc_key.append(test);
							desc_key.append(EgConstants.COLON);
							desc_key.append(measure);
							String description = tablesInfo.getMeasureAlert(desc_key.toString(),info,thisLanguage);

							//Start time
							StringBuffer value = new StringBuffer();
							if(start_time_value!=null && start_time_value.trim().length()>0)
							{
								dt.setStartDateTime((String)start_time_value);
								value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
								value.append(DateTimeTokenizer.BLANK_SPACE);
								value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
								start_time_value = value.toString();
							}
							value = new StringBuffer();

							if ((end_time_value != null) && (end_time_value.trim().length()>0) && (end_time_value.indexOf("1900") == -1))
							{
								dt.setEndDateTime(end_time_value);
								long tDiff = dt.getDateDifference();
								if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
								{
									if(infosearch.startsWith("*"))
									{
										infosearch=infosearch.substring(1);
									}
									if(infosearch.endsWith("*"))
									{
										infosearch=infosearch.substring(0,infosearch.length()-1);
									}
									if(infosearch.startsWith("*") && infosearch.endsWith("*"))
									{
										infosearch=infosearch.substring(1);
										infosearch=infosearch.substring(0,infosearch.length()-1);
									}
								}
								if (lessThanZero)
								{
									if(tDiff<durationFilter)
									{
										if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
										{
											infosearch=infosearch.toLowerCase();
											description=description.toLowerCase();
											if(description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
											{
												count++;
											}
										}
									}
								}
								else
								{
									if(tDiff>durationFilter)
									{
										if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
										{
											infosearch=infosearch.toLowerCase();
											description=description.toLowerCase();
											if(description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
											{
												count++;
											}
										}
									}
								}
							}
						}
					}
					try
					{
						rs.close();
						rs = null;
					}
					catch (Exception grrr)
					{
					}
				}
				catch (SQLException e)
				{
					// TODO Auto-generated catch block
					// logger.error("Error retrieving events count ", e);
				}
				return count;
			}
			else 
			{
				if (EgDbInfo.isOraAdapter)
				{
					sb.append("SELECT INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					sb.append(fromDate);
					sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
					sb.append(toDate);
					sb.append("','mm/dd/yyyy hh24:mi') ");
				}
				else
				{
					sb.append("SELECT INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' '");
					sb.append(" AND MSMT_TIME_START BETWEEN convert(datetime,'");
					sb.append(fromDate);
					sb.append("', 101) AND convert(datetime,'");
					sb.append(toDate);
					sb.append("', 101) ");
				}
				
				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}
				logToTmpFile("INFO","","Query for events count 1 "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());
				
				try
				{
					if (rs != null)
					{
						while(rs.next())
						{
							StringBuffer desc_key=new StringBuffer();
							String test = rs.getString(2);
							String measure = rs.getString(3);
							String info = rs.getString(1);
							desc_key.append(test);
							desc_key.append(EgConstants.COLON);
							desc_key.append(measure);
							String description = tablesInfo.getMeasureAlert(desc_key.toString(),info,thisLanguage);
							if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
							{
								if(infosearch.startsWith("*"))
								{
									infosearch=infosearch.substring(1);
								}
								if(infosearch.endsWith("*"))
								{
									infosearch=infosearch.substring(0,infosearch.length()-1);
								}
								if(infosearch.startsWith("*") && infosearch.endsWith("*"))
								{
									infosearch=infosearch.substring(1);
									infosearch=infosearch.substring(0,infosearch.length()-1);
								}
								infosearch=infosearch.toLowerCase();
								description=description.toLowerCase();
								if(description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
								{
									count++;
								}
							}
						}
					}
					try 
					{
						rs.close();
						rs = null;
					}
					catch (Exception grrr)
					{
					}
				}
				catch (SQLException e)
				{
					// TODO Auto-generated catch block
					// logger.error("Error retrieving events count ", e);
				}
				return count;
			}
		}
		else
		{
			if (durationFilter != 0)
			{
				// restricted access or using specific comp-name and type 
				if (EgDbInfo.isOraAdapter)
					sb.append("SELECT COMP_TYPE||':'||COMP_NAME,MSMT_TIME_START,MSMT_TIME_END,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME>' ' and ");
				else
					sb.append("SELECT COMP_TYPE+':'+COMP_NAME,MSMT_TIME_START,MSMT_TIME_END,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' AND ");


				if (compNames.length()==0)
				{// filter based on comp_type
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						//sb.append("', 101) AND convert(datetime,'")
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
				else 
				{ // filter based on comp_name 
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);

						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}

						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");
					}
				}
				
				if(EgDbInfo.isOraAdapter)
				{
					sb.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					sb.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}

				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				boolean lessThanZero = (durationFilter < 0);
				durationFilter = Math.abs(durationFilter);
				logToTmpFile("INFO","","Query for events count "+sb.toString());
				ResultSet rs = egDb.dbselect(sb.toString());

				count = 0;
				try
				{
					if (rs != null)
					{
						DateTimeTokenizer dt = new DateTimeTokenizer();
						dt.setDateFormat(DateTimeTokenizer._YMD);
						dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
						dt.setTimeFormat(DateTimeTokenizer.HMS);
						dt.setYearAsYY(true);
						while (rs.next())
						{
							String s = rs.getString(1);
							if (servers.contains(s))
							{
								String start_time_value=rs.getString(2);
								String end_time_value=rs.getString(3);
								StringBuffer desc_key=new StringBuffer();
								String test = rs.getString(5);
								String measure = rs.getString(6);
								String info = rs.getString(4);
								desc_key.append(test);
								desc_key.append(EgConstants.COLON);
								desc_key.append(measure);
								String description = tablesInfo.getMeasureAlert(desc_key.toString(),info,thisLanguage);
								//Start time
								StringBuffer value = new StringBuffer();
								if(start_time_value!=null && start_time_value.trim().length()>0)
								{
									dt.setStartDateTime((String)start_time_value);
									value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
									value.append(DateTimeTokenizer.BLANK_SPACE);
									value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
									start_time_value = value.toString();
								}
								value = new StringBuffer();
								if ((end_time_value != null) && end_time_value.trim().length()>0 && (end_time_value.indexOf("1900") == -1))
								{
									dt.setEndDateTime(end_time_value);
									long tDiff = dt.getDateDifference();
									if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
									{
										if(infosearch.startsWith("*"))
										{
											infosearch=infosearch.substring(1);
										}
										if(infosearch.endsWith("*"))
										{
											infosearch=infosearch.substring(0,infosearch.length()-1);
										}
										if(infosearch.startsWith("*") && infosearch.endsWith("*"))
										{
											infosearch=infosearch.substring(1);
											infosearch=infosearch.substring(0,infosearch.length()-1);
										}
									}
									if (lessThanZero)
									{
										if(tDiff<durationFilter)
										{
											if(!StringUtils.isNull(infosearch))
											{
												infosearch=infosearch.toLowerCase();
												description=description.toLowerCase();
												if(description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
												{
													count++;
												}
											}
										}
									}
									else
									{
										if(tDiff>durationFilter)
										{
											if(!StringUtils.isNull(infosearch))
											{
												infosearch=infosearch.toLowerCase();
												description=description.toLowerCase();
												if(description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
												{
													count++;
												}
											}
										}
									}
								}
							}
						}
						try 
						{
							rs.close();
							rs = null;
						}
						catch (Exception grrr)
						{
						}
					}
				}
				catch (SQLException e)
				{
					try 
					{
						rs.close();
						rs = null;
					} 
					catch (Exception grrr)
					{
					}
				}
				return count;
			}
			else
			{
				// restricted access or using specific comp-name and type 
				if (EgDbInfo.isOraAdapter)
					sb.append("SELECT COMP_TYPE||':'||COMP_NAME,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME>' ' and ");
				else
					sb.append("SELECT COMP_TYPE+':'+COMP_NAME,INFO,TEST_NAME,MEASURE FROM EVENT_HIST WHERE SITE_NAME> ' ' AND ");
				if (compNames.length()==0)
				{// filter based on comp_type
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME>' ' and COMP_TYPE IN (");
						sb.append(compTypes);
						sb.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						//sb.append("', 101) AND convert(datetime,'")
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
				else 
				{ // filter based on comp_name 
					if (EgDbInfo.isOraAdapter)
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
						sb.append(fromDate);
						sb.append("','mm/dd/yyyy hh24:mi') AND to_date('");
						sb.append(toDate);
						sb.append("','mm/dd/yyyy hh24:mi') ");
					}
					else
					{
						sb.append("COMP_NAME IN (");
						sb.append(compNames);
						sb.append(") and ");
						sb.append("COMP_TYPE IN(");
						sb.append(compTypes);
						//sb.append(") and INFO>' ' ");
						if(isFromInsideviewDashboard)
						{
							if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
								sb.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
							else
								sb.append(") and INFO>' ' ");
						}
						else
						{
							sb.append(") and INFO>' ' ");
						}
						if(isFromDashBoard)
						{
							sb.append(" and test_name in("+testList+") ");
						}
						else
						{
							sb.append("and TEST_NAME>' '"); 
						}
						sb.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
						sb.append(fromDate);
						sb.append("', 101) AND convert(datetime,'");
						sb.append(toDate);
						sb.append("', 101) ");

					}
				}
			
				if(state!=null && !state.equals(""))
				{
					if(state.equals("HIGHINTERMEDIATE"))
					{
						sb.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
					}
					else
					{
						sb.append(" AND event_svrty='");
						sb.append(state);
						sb.append("'");
					}
				}

				logToTmpFile("INFO","","Query for events count "+sb.toString());
				
				ResultSet rs = egDb.dbselect(sb.toString());

				count = 0;
				try
				{
					if (rs != null)
					{
						while (rs.next())
						{
							String s = rs.getString(1);
							StringBuffer desc_key=new StringBuffer();
							String info = rs.getString(2);
							String test = rs.getString(3);
							String measure = rs.getString(4);
							desc_key.append(test);
							desc_key.append(EgConstants.COLON);
							desc_key.append(measure);
							String description = tablesInfo.getMeasureAlert(desc_key.toString(),info,thisLanguage);
							if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
							{
								if(infosearch.startsWith("*"))
								{
									infosearch=infosearch.substring(1);
								}
								if(infosearch.endsWith("*"))
								{
									infosearch=infosearch.substring(0,infosearch.length()-1);
								}
								if(infosearch.startsWith("*") && infosearch.endsWith("*"))
								{
									infosearch=infosearch.substring(1);
									infosearch=infosearch.substring(0,infosearch.length()-1);
								}
							}
							if(s!=null && s.trim().length()>0 && (infosearch==null || infosearch.trim().length()==0 || infosearch.equals("null")))
							{
								if (servers.contains(s))
								{
									count ++;
								}
							}
							else if(s!=null && s.trim().length()>0 && (infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch)))
							{
								infosearch=infosearch.toLowerCase();
								description=description.toLowerCase();
								if((servers.contains(s)) && description!=null && description.trim().length()>0 && description.indexOf(infosearch)>-1)
								{
									count++;
								}
							}
						}
						try {
							rs.close();
							rs = null;
						} catch (Exception grrr)
						{
						}
					}
				}
				catch (SQLException e)
				{
					try {
						rs.close();
						rs = null;
					} catch (Exception grrr)
					{
					}
				}
				return count;
			}
		}
	}
	/**
	 * Returns all the events in the Report table for the specified component
	 * name, component type, start and end times.
	 *
	 * @see 	Event History
	 *
	 * @param 	serverNmes	Comma-separated component names
	 * @param 	serverTypes	Comma-separated component types
	 * @param 	fromTime
	 * @param 	toTime
	 *
	 * @return	java.sql.ResultSet
	 */
	public List getEventHistory(
		List servers,
		String serverNames,
		String serverTypes,
		String fromTime,
		String toTime,
		String eventID,
		int offsetCount,
		long durationFilter,
		String state,
		boolean reverseList, EgDbAdapterUI egDb,EgMappingInfo mappingInfo,LangInfo langinfo,String selectedArrangeOption,String infosearch)
	{
		EgDateInfo dateInfo = new EgDateInfo();
		StringBuffer query = new StringBuffer(320);
		StringBuffer sb_time =new StringBuffer();
		//TODO Check the date format for compatibility
		if (servers.isEmpty())
		{// all components
			//query.append("SELECT * FROM (");
			query.append(
					"SELECT SITE_NAME, COMP_NAME, COMP_TYPE, INFO, TEST_NAME, MEASURE, MSMT_TIME_START, MSMT_TIME_END, MSMT_HOST, EVENT_ID, EVENT_SVRTY FROM EVENT_HIST WHERE EVENT_ID >0 ");
			if (EgDbInfo.isOraAdapter)
			{
				
				sb_time.append("AND MSMT_TIME_START BETWEEN to_date('");
				sb_time.append(fromTime);
				sb_time.append("','mm/dd/yyyy hh24:mi:ss') AND to_date('");
				sb_time.append(toTime);
				sb_time.append("','mm/dd/yyyy hh24:mi:ss') ");

				
				query.append(sb_time);
				//query.append("AND SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' ");
			}
			else
			{
				sb_time.append("AND MSMT_TIME_START BETWEEN convert(datetime,'");
					//sb.append("', 101) AND convert(datetime,'")
				sb_time.append(fromTime);
				sb_time.append("', 101) AND convert(datetime,'");
				sb_time.append(toTime);
				sb_time.append("',101) ");

				//query.append(
					//"SELECT SITE_NAME, COMP_NAME, COMP_TYPE, INFO, TEST_NAME, MEASURE, MSMT_TIME_START, MSMT_TIME_END, MSMT_HOST, EVENT_ID, EVENT_SVRTY FROM EVENT_HIST WHERE ");
				query.append(sb_time);
				

			}
			//query.append(" AND SITE_NAME> ' ' and COMP_NAME>' ' and COMP_TYPE>' ' and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' ");
			if (eventID != null)
			{
				if (reverseList)
				{
					query.append(" AND EVENT_ID < ");
					query.append(eventID);
				}
				else
				{
					query.append(" AND EVENT_ID > ");
					query.append(eventID);
				}
			}

			if(durationFilter != 0)
			{
				if(EgDbInfo.isOraAdapter)
				{
					query.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					query.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}
			}

			if(state!=null && !state.equals(""))
			{
				if(state.equals("HIGHINTERMEDIATE"))
				{
					query.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
				}
				else
				{
					query.append(" AND event_svrty='");
					query.append(state);
					query.append("'");
				}
			}

			query.append(" ORDER BY EVENT_ID");
			if (reverseList)
			{
				query.append(" DESC");
			}

			query.append(", COMP_NAME");
			//	query.append(") WHERE ROWNUM BETWEEN 1 AND ");
			//	query.append(offsetCount);
			logToTmpFile("INFO","","Query for event history is "+query.toString());
			ResultSet rs = null;
			try
			{
				rs = egDb.dbselect(query.toString());

				List result = new LinkedList();
				ArrayList sortEvent=new ArrayList();
				if(durationFilter != 0)
				{
					if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
					{
						sortEvent= (ArrayList)egDb.getResultSetAsList(rs,mappingInfo,thisLanguage,durationFilter);
					}
					else
					{
						result = (List)egDb.getResultSetAsList(rs,durationFilter);
					}
				}
				else
				{
					if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
					{
						sortEvent= (ArrayList)egDb.getResultSetAsList(rs,mappingInfo,thisLanguage);
					}
					else
					{
						result = (List)egDb.getResultSetAsList(rs);
					}
				}

				try
				{
					rs.close();
					rs = null;
				}
				catch (Exception hh)
				{
					rs = null;
				}
				/*
				 * 0	SITE_NAME
				 * 1	COMP_NAME
				 * 2	COMP_TYPE
				 * 3	INFO
				 * 4	TEST_NAME
				 * 5	MEASURE
				 * 6	MSMT_TIME_START
				 * 7	MSMT_TIME_END
				 * 8	MSMT_HOST
				 * 9	EVENT_ID
				 * 10	EVENT_SVRTY
				 */
				
				if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
				{
					//thendral
					if(sortEvent!=null && sortEvent.size()>0)
					{
						if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("problem_desc"))
						{
							EgAlarmComparator.compareValue=3;
							Collections.sort(sortEvent,new EgAlarmComparator());

							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();

								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("comp_type"))
						{
							
							EgAlarmComparator.compareValue=2;
							Collections.sort(sortEvent,new EgAlarmComparator());

							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();
					
								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("comp_name"))
						{
							EgAlarmComparator.compareValue=1;
							Collections.sort(sortEvent,new EgAlarmComparator());

							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();
					
								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("Service"))
						{
							EgAlarmComparator.compareValue=6;
							Collections.sort(sortEvent,new EgAlarmComparator());

							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();

								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("Test"))
						{
							EgAlarmComparator.compareValue=5;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();

								result.add((String[])temp_str);
							}
						}
					}
					//end here
					if (result != null && result.size()>0)
					{
						if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equals("null") && !infosearch.equals(""))
							result = getDescriptionSearch(result,infosearch);
						int recordCount = result.size();
						if (recordCount > offsetCount)
							result.subList(offsetCount , recordCount).clear();
					}
				}
				else
				{
					if (result != null && result.size()>0)
					{
						if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equals("null") && !infosearch.equals(""))
							result = getDescriptionSearch(result,infosearch);
						int recordCount = result.size();
						if (recordCount > offsetCount)
							result.subList(offsetCount , recordCount).clear();
					}
				}
				return result;
			}
			catch (Exception jpm)
			{
				logToTmpFile("INFO","","Error "+jpm.toString());
				jpm.printStackTrace();
				try
				{
					if (rs != null)
					{
						rs.close();
					}
				}
				catch (Exception grr)
				{
				}
				return null;
			}
		}
		else
		{
			query.append(
			"SELECT SITE_NAME, COMP_NAME, COMP_TYPE, INFO, TEST_NAME, MEASURE, MSMT_TIME_START, MSMT_TIME_END, MSMT_HOST, EVENT_ID, EVENT_SVRTY FROM EVENT_HIST WHERE SITE_NAME>' ' AND ");
			if (serverNames.length()==0)
			{// filter based on comp_type
				if (EgDbInfo.isOraAdapter)
				{
					query.append("COMP_NAME>' ' and COMP_TYPE IN (");
					query.append(serverTypes);
					query.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					query.append(fromTime);
					query.append("','mm/dd/yyyy hh24:mi:ss') AND to_date('");
					query.append(toTime);
					query.append("','mm/dd/yyyy hh24:mi:ss') ");
				}
				else
				{
					query.append("COMP_NAME>' ' and COMP_TYPE IN (");
					query.append(serverTypes);
					query.append(") and INFO>' ' and TEST_NAME>' ' and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
					query.append(fromTime);
					query.append("',101 ) AND convert(datetime,'");
					query.append(toTime);
					query.append("',101) ");
				  		//sb.append("', 101) AND convert(datetime,'")
				}
			}
			else 
			{ // filter based on comp_name 
				if (EgDbInfo.isOraAdapter)
				{
					query.append("COMP_NAME IN (");
					query.append(serverNames);
					query.append(") and ");
					query.append("COMP_TYPE IN (");
					query.append(serverTypes);
					//query.append(") and INFO>' ' "); 
					if(isFromInsideviewDashboard)
					{
						if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
							query.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
						else
							query.append(") and INFO>' ' ");
					}
					else
					{
						query.append(") and INFO>' ' ");
					}

					if(isFromDashBoard)
					{
						query.append(" and test_name in("+testList+") ");
					}
					else
					{
						query.append("and TEST_NAME>' ' ");
					}
					query.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN to_date('");
					query.append(fromTime);
					query.append("','mm/dd/yyyy hh24:mi:ss') AND to_date('");
					query.append(toTime);
					query.append("','mm/dd/yyyy hh24:mi:ss') ");
				}
				else
				{
					query.append("COMP_NAME IN (");
					query.append(serverNames);
					query.append(") and ");
					query.append("COMP_TYPE IN(");
					query.append(serverTypes);
					//query.append(") and INFO>' ' ");
					if(isFromInsideviewDashboard)
					{
						if(insideViewInfo!=null && insideViewInfo.trim().length()>0)
							query.append(") and lower(INFO) like ('"+insideViewInfo+"%')");
						else
							query.append(") and INFO>' ' ");
					}
					else
					{
						query.append(") and INFO>' ' ");
					}

					if(isFromDashBoard)
					{
						query.append(" and test_name in("+testList+") ");
					}
					else
					{
						query.append("and TEST_NAME>' ' ");
					}
					query.append(" and MEASURE>' ' and MSMT_TIME_START BETWEEN convert(datetime,'");
					query.append(fromTime);
					query.append("',101 ) AND convert(datetime,'");
					query.append(toTime);
					query.append("',101) ");

				}
			}
			if (eventID != null)
			{
				if (reverseList)
				{
					query.append(" AND EVENT_ID < ");
					query.append(eventID);
				}
				else
				{
					query.append(" AND EVENT_ID > ");
					query.append(eventID);
				}
			}

			if(durationFilter != 0)
			{
				if(EgDbInfo.isOraAdapter)
				{
					query.append("AND (MSMT_TIME_END IS NOT NULL) ");
				}
				else
				{
					query.append("AND (MSMT_TIME_END <> convert(datetime,'01/01/1900 00:00', 101)) ");
				}
			}

			if(state!=null && !state.equals(""))
			{
				if(state.equals("HIGHINTERMEDIATE"))
				{
					query.append(" AND event_svrty in('HIGH','INTERMEDIATE')");
				}
				else
				{
					query.append(" AND event_svrty='");
					query.append(state);
					query.append("'");
				}
			}

			query.append(" ORDER BY EVENT_ID");
			if (reverseList)
			{
				query.append(" DESC");
			}
			query.append(", COMP_NAME");
			logToTmpFile("INFO","","Query for event history2 is "+query.toString());

			ResultSet rs = null;
			try
			{
				rs = egDb.dbselect(query.toString());
				
				List result = new LinkedList();
				ArrayList sortEvent=new ArrayList();
				if(durationFilter != 0)
				{
					if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
					{
						sortEvent= (ArrayList)getEventHistAsList(rs,servers,mappingInfo,durationFilter);
					}
					else
					{
						result = (List)getEventHistAsList(rs,servers,durationFilter);
					}
				}
				else
				{
					if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
					{
						sortEvent= (ArrayList)getEventHistAsList(rs,servers,mappingInfo);
					}
					else
					{
						result = (List)getEventHistAsList(rs, servers);
					}
				}
				
				try
				{
					rs.close();
					rs = null;
				}
				catch (Exception hh)
				{
					rs = null;
				}

				if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && !selectedArrangeOption.equalsIgnoreCase("-1"))
				{
					//here start thendral
					if(sortEvent!=null && sortEvent.size()>0)
					{
						if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("problem_desc"))
						{
							EgAlarmComparator.compareValue=3;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();
					
								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("comp_type"))
						{
							
							EgAlarmComparator.compareValue=2;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();
					
								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("comp_name"))
						{
							EgAlarmComparator.compareValue=1;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();

								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("Service"))
						{
							EgAlarmComparator.compareValue=6;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();

								result.add((String[])temp_str);
							}
						}
						else if(selectedArrangeOption!=null && selectedArrangeOption.trim().length()>0 && selectedArrangeOption.trim().equalsIgnoreCase("Test"))
						{
							EgAlarmComparator.compareValue=5;
							Collections.sort(sortEvent,new EgAlarmComparator());
							result.clear();
							for (int i=0;i<sortEvent.size();i++)
							{
								EgAlarmsBean obj=(EgAlarmsBean)sortEvent.get(i);
								String temp_str[]=new String[11];
								temp_str[0]=obj.getRealCompSite();
								temp_str[1]=obj.getRealCompName();
								temp_str[2]=obj.getRealCompType();
								temp_str[3]=obj.getInfo();
								temp_str[4]=obj.getRealCompTest();
								temp_str[5]=obj.getRealMeasure();
								
								temp_str[6]=obj.getStartTime();
								temp_str[7]=obj.getEndTime();
								temp_str[8]=obj.getMeasurementHost();
								temp_str[9]=obj.getAlarmId();
								temp_str[10]=obj.getAlarmPriority();
								result.add((String[])temp_str);
							}
						}
					}
					//here end thendral
					if (result != null && result.size()>0)
					{
						if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equals("null") && !infosearch.equals(""))
						{
							result = getDescriptionSearch(result,infosearch);
						}
						int recordCount = result.size();
						if(offsetCount < recordCount)
							result.subList(offsetCount , recordCount).clear();
					}
				}
				else
				{
					if (result != null && result.size()>0)
					{
						if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equals("null") && !infosearch.equals(""))
						{
							result = getDescriptionSearch(result,infosearch);
						}
						int recordCount = result.size();
						if(offsetCount < recordCount)
							result.subList(offsetCount , recordCount).clear();
					}
				}
				return result;
			}
			catch (Exception chasegrrr)
			{
				try
				{
					if (rs != null)
					{
						rs.close();
					}
				}
				catch (Exception grr)
				{
				}
				return null;
			}
		}
	}
	
	public List getDescriptionSearch(List result,String infosearch)throws SQLException
	{
		List descSearch=new LinkedList();
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		if(infosearch!=null && infosearch.trim().length()>0 && !infosearch.equals("null"))
		{
			if(infosearch.startsWith("*"))
			{
				infosearch=infosearch.substring(1);
			}
			if(infosearch.endsWith("*"))
			{
				infosearch=infosearch.substring(0,infosearch.length()-1);
			}
			if(infosearch.startsWith("*") && infosearch.endsWith("*"))
			{
				infosearch=infosearch.substring(1);
				infosearch=infosearch.substring(0,infosearch.length()-1);
			}
		}
		for (Iterator i=result.iterator(); i.hasNext();)
		{
			String[] row = (String[])i.next();
			StringBuffer desc_key=new StringBuffer();
			desc_key.append(row[4]);
			desc_key.append(EgConstants.COLON);
			desc_key.append(row[5]);
			String description = tablesInfo.getMeasureAlert(desc_key.toString(),row[3],thisLanguage);
			if(infosearch!=null && infosearch.trim().length()>0 && !StringUtils.isNull(infosearch))
			{
				infosearch=infosearch.toLowerCase();
				description=description.toLowerCase();
				if (description!=null && description.indexOf(infosearch) >-1)
				{
					descSearch.add((String[])row);
				}
			}
		}
		return descSearch;
	}
	public final List getEventHistAsList(ResultSet rs, List servers) throws SQLException
	{
		List list = new LinkedList();
		ResultSetMetaData rsmd = rs.getMetaData();
		int count = rsmd.getColumnCount();
		while (rs.next())
		{
			if (count > 1)
			{
				/*
				 * Create a String[] for a row if more than one column of data is returned
				 */
				String[] row = new String[count];
				for (int a = 0; a < count; a++)
				{
					row[a] = rs.getString(a + 1);
				}
				String ctypeName = row[2]+":"+row[1];
				if (!servers.contains(ctypeName))
				{
					continue; // not one of our servers
				}
				list.add(row);
			}
			else
			{
				/*
				 * Just the dump the row into the list
				 */
				list.add(rs.getString(1));
			}
		}

		return list;
	}
	//overloaded method for duration and not sortting
	public final List getEventHistAsList(ResultSet rs, List servers,long durationFilter) throws SQLException
	{
		List list = new LinkedList();
		ResultSetMetaData rsmd = rs.getMetaData();
		int count = rsmd.getColumnCount();
		boolean lessThanZero =false;
		DateTimeTokenizer dt = new DateTimeTokenizer();
		if(durationFilter != 0)
		{
			lessThanZero = (durationFilter < 0);

			durationFilter = Math.abs(durationFilter);
			dt.setDateFormat(DateTimeTokenizer._YMD);
			dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
			dt.setTimeFormat(DateTimeTokenizer.HMS);
			dt.setYearAsYY(true);
		}
		while (rs.next())
		{
			if (count > 1)
			{
				/*
				 * Create a String[] for a row if more than one column of data is returned
				 */
				String[] row = new String[count];
				for (int a = 0; a < count; a++)
				{
					row[a] = rs.getString(a + 1);
				}
				String ctypeName = row[2]+":"+row[1];
				if (!servers.contains(ctypeName))
				{
					continue; // not one of our servers
				}

				if(durationFilter != 0 && row.length>0 && row.length==count)
				{
					String start_time_value=row[6];//Start time
					String end_time_value=row[7];//End time
					
					StringBuffer value = new StringBuffer();
					if(start_time_value!=null && start_time_value.trim().length()>0)
					{
						dt.setStartDateTime((String)start_time_value);
						value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
						value.append(DateTimeTokenizer.BLANK_SPACE);
						value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
						start_time_value = value.toString();
					}
					
					value = new StringBuffer();
					
					if ((end_time_value != null) && (end_time_value.trim().length()>0) && (end_time_value.indexOf("1900") == -1))
					{
						dt.setEndDateTime(end_time_value);
						long tDiff = dt.getDateDifference();
						
						if (lessThanZero)
						{
							if(tDiff<durationFilter)
							{
								list.add(row);
							}
						}
						else
						{
							if(tDiff>durationFilter)
							{
								list.add(row);
							}
						}
					}
				}
				else
				{
					list.add(row);
				}
			}
			else
			{
				/*
				 * Just the dump the row into the list
				 */
				list.add(rs.getString(1));
			}
		}

		return list;
	}
	public final ArrayList getEventHistAsList(ResultSet rs,List servers,EgMappingInfo mappingInfo) throws SQLException
	{
		List list = new LinkedList();
		ResultSetMetaData rsmd = rs.getMetaData();
		int count = rsmd.getColumnCount();
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		ArrayList sortEvent=new ArrayList();
		while (rs.next())
		{
			if (count > 1)
			{
				/*
				 * Create a String[] for a row if more than one column of data is returned
				 */
				String[] row = new String[count];
				for (int a = 0; a < count; a++)
				{
					row[a] = rs.getString(a + 1);
				}
				String ctypeName = row[2]+":"+row[1];
				if (!servers.contains(ctypeName))
				{
					continue; // not one of our servers
				}

				if(row.length>0 && row.length==count)
				{
					EgAlarmsBean eab=new EgAlarmsBean();
					
					String temp_compType=row[2];
					eab.setRealCompType(temp_compType);
					eab.setCompType(mappingInfo.getComponentTypeDescription(temp_compType));
					
					String temp_compName=row[1];
					eab.setRealCompName(temp_compName);
					eab.setCompName(temp_compName);
					
					String temp_siteName=row[0];
					eab.setRealCompSite(temp_siteName);
					eab.setCompSite(temp_siteName);
					
					String temp_testName=row[4];
					eab.setRealCompTest(temp_testName);
					eab.setCompTest(mappingInfo.getTestDescription(temp_testName));
					
					String temp_info=row[3];
					eab.setInfo(temp_info);
					
					StringBuffer dec_key = new StringBuffer();
					dec_key.append(row[4]);
					dec_key.append(EgConstants.COLON);
					dec_key.append(row[5]);
					//start
					String temp_description ="";
					if(temp_compType!=null && temp_compType.endsWith("_ex"))
					{
						temp_description = tablesInfo.getMeasureAlert(dec_key.toString(),row[3],thisLanguage);
					}
					else
					{
						temp_description = mappingInfo.getMeasureAlert(dec_key.toString());
					}
					//end
					
					eab.setRealAlarmDesc(temp_description);
					eab.setAlarmDesc(temp_description);

					String temp_measure=row[5];
					eab.setRealMeasure(temp_measure);
					eab.setMeasure(mappingInfo.getMeasureDescription(temp_testName,temp_measure));

					String temp_starttime=row[6];
					eab.setStartTime(temp_starttime);

					String temp_endtime=row[7];
					eab.setEndTime(temp_endtime);

					String temp_mhost=row[8];
					eab.setMeasurementHost(temp_mhost);
					
					String temp_eventId=row[9];
					eab.setAlarmId(temp_eventId);
				
					String temp_eventPriority=row[10];
					eab.setAlarmPriority(temp_eventPriority);
					sortEvent.add(eab);
				}
				list.add(row);
			}
			else
			{
				/*
				 * Just the dump the row into the list
				 */
				list.add(rs.getString(1));
			}
		}

		return sortEvent;
	}
	//over loaded method for durations and sortting
	public final ArrayList getEventHistAsList(ResultSet rs,List servers,EgMappingInfo mappingInfo,long durationFilter) throws SQLException
	{
		List list = new LinkedList();
		ResultSetMetaData rsmd = rs.getMetaData();
		int count = rsmd.getColumnCount();
		EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);
		ArrayList sortEvent=new ArrayList();
		boolean lessThanZero =false;
		DateTimeTokenizer dt = new DateTimeTokenizer();
		if(durationFilter != 0)
		{
			lessThanZero = (durationFilter < 0);
			durationFilter = Math.abs(durationFilter);
			dt.setDateFormat(DateTimeTokenizer._YMD);
			dt.setDateSeparator(DateTimeTokenizer.HYPHEN_SEPARATOR);
			dt.setTimeFormat(DateTimeTokenizer.HMS);
			dt.setYearAsYY(true);
		}
		while (rs.next())
		{
			if (count > 1)
			{
				/*
				 * Create a String[] for a row if more than one column of data is returned
				 */
				String[] row = new String[count];
				for (int a = 0; a < count; a++)
				{
					row[a] = rs.getString(a + 1);
				}
				String ctypeName = row[2]+":"+row[1];
				if (!servers.contains(ctypeName))
				{
					continue; // not one of our servers
				}
				boolean isTrue=false;
				if(durationFilter != 0 && row.length>0 && row.length==count)
				{
					String start_time_value=row[6];//Start time
					String end_time_value=row[7];//End time
					
					StringBuffer value = new StringBuffer();
					if(start_time_value!=null && start_time_value.trim().length()>0)
					{
						dt.setStartDateTime((String)start_time_value);
						value.append(dt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR));
						value.append(DateTimeTokenizer.BLANK_SPACE);
						value.append(dt.getStartTimeAsFormat(DateTimeTokenizer.HM, DateTimeTokenizer.COLON_SEPARATOR));
						start_time_value = value.toString();
					}
					value = new StringBuffer();
					
					if ((end_time_value != null) && (end_time_value.trim().length()>0) && (end_time_value.indexOf("1900") == -1))
					{
						dt.setEndDateTime(end_time_value);
						long tDiff = dt.getDateDifference();
						
						if (lessThanZero)
						{
							if(tDiff<durationFilter)
							{
								isTrue=true;
							}
						}
						else
						{
							if(tDiff>durationFilter)
							{
								isTrue=true;
							}
						}
					}
				}
				else
				{
					isTrue=true;
				}

				if(isTrue)
				{
					if(row.length>0 && row.length==count)
					{
						EgAlarmsBean eab=new EgAlarmsBean();
						
						String temp_compType=row[2];
						eab.setRealCompType(temp_compType);
						eab.setCompType(mappingInfo.getComponentTypeDescription(temp_compType));
						
						String temp_compName=row[1];
						eab.setRealCompName(temp_compName);
						eab.setCompName(temp_compName);
						
						String temp_siteName=row[0];
						eab.setRealCompSite(temp_siteName);
						eab.setCompSite(temp_siteName);
						
						String temp_testName=row[4];
						eab.setRealCompTest(temp_testName);
						eab.setCompTest(mappingInfo.getTestDescription(temp_testName));
						
						String temp_info=row[3];
						eab.setInfo(temp_info);
						
						StringBuffer dec_key = new StringBuffer();
						dec_key.append(row[4]);
						dec_key.append(EgConstants.COLON);
						dec_key.append(row[5]);
						//start
						String temp_description ="";
						if(temp_compType!=null && temp_compType.endsWith("_ex"))
						{
							temp_description = tablesInfo.getMeasureAlert(dec_key.toString(),row[3],thisLanguage);
						}
						else
						{
							temp_description = mappingInfo.getMeasureAlert(dec_key.toString());
						}
						//end
						
						eab.setRealAlarmDesc(temp_description);
						eab.setAlarmDesc(temp_description);

						String temp_measure=row[5];
						eab.setRealMeasure(temp_measure);
						eab.setMeasure(mappingInfo.getMeasureDescription(temp_testName,temp_measure));

						String temp_starttime=row[6];
						eab.setStartTime(temp_starttime);

						String temp_endtime=row[7];
						eab.setEndTime(temp_endtime);

						String temp_mhost=row[8];
						eab.setMeasurementHost(temp_mhost);
						
						String temp_eventId=row[9];
						eab.setAlarmId(temp_eventId);
					
						String temp_eventPriority=row[10];
						eab.setAlarmPriority(temp_eventPriority);
						sortEvent.add(eab);
					}
					list.add(row);
				}
			}
			else
			{
				/*
				 * Just the dump the row into the list
				 */
				list.add(rs.getString(1));
			}
		}
		return sortEvent;
	}

	public Hashtable putAcknowledgeDetails(String eventid) throws SQLException
	{
		String user_id = "";
		String ack_time = "";
		String ack_desc = "";
		String option = "";

		ArrayList al_ackDetails = new ArrayList();
		ArrayList al_singleackDetails = new ArrayList();
		ArrayList al_multiackDetails = new ArrayList();
		
		Hashtable htable = new Hashtable();
		String status = "";
		ResultSet rs2 = null;
		EgDbAdapterUI egDb = EgDbAdapterTypeUI.getObject();
		status = egDb.setConnection();

		try
		{
		
			String res = "select * from acknowledgement_history where event_id ='" + eventid + "' order by ack_time desc";
			
			rs2 = egDb.dbselect(res);
			
			while (rs2.next())
			{
				al_ackDetails=new ArrayList();
				
				user_id = rs2.getString("user_id");
				al_ackDetails.add(user_id);
				
				ack_desc = rs2.getString("ack_description");
				al_ackDetails.add(ack_desc);

				option = rs2.getString("options");
				al_ackDetails.add(option);
				
				ack_time = rs2.getString("ack_time");
				al_ackDetails.add(ack_time);
				
				if(htable.containsKey(eventid))
				{
					al_multiackDetails.add(al_ackDetails);
					htable.put(eventid, al_multiackDetails);
				}
				else
				{
					al_singleackDetails.add(al_ackDetails);
					htable.put(eventid, al_singleackDetails);
					al_multiackDetails.add(al_ackDetails);
				}
			}
		
			rs2.close();
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}

		catch(SQLException e)
		{
			e.printStackTrace();
			rs2.close();
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		return (htable);
	}

	public void logToTmpFile(String type, String entity,String msg)
	{
		PrintWriter logWriter;
		if (!tmpLog)
		return;
		synchronized(syncVector)
		{
			EgDateInfo dateInfo = new EgDateInfo();
			String logDateAndTime = dateInfo.egetDate(false);
			try
			{
				logWriter = new PrintWriter(new FileWriter(tmpFile, true));
			}
			catch(Exception e)
			{
				System.err.println("Cannot open tmp log file ");
				return;
			}
			String log=new String(logDateAndTime+" "+type + " "+ entity + " "+ msg);
			logWriter.println(log);
			logWriter.flush();
			logWriter.close();
		}
	}
%>

<%
	if(history!=null && history.size()>0)
	{
%>
			<script>

				if(window.parent.document.getElementById("hidVpdfData")!=null)
				{
					window.parent.document.getElementById("hidVpdfData").value="true";
				}
						
			</script>
<%
	}
	else
	{
%>
			<script>

				if(window.parent.document.getElementById("hidVpdfData")!=null)
				{
					window.parent.document.getElementById("hidVpdfData").value="false";
				}
						
			</script>
<%
	}
%>


<!--</form>-->

</body>
</html>

