<%
/**
 *	Requires 3 parameters - Site Name, Host & Layer.  Displays the tests for the particular layer.
 *
 *	@author		KrishnaKumar.C
 *	@created	17/07/2000
 *	@version	3.0
 *
 *	@modified
 *		26/07/2004	Arun		If fakeType is not used with Network nodes (while having a lot of infos)
 *								incorrect state was shown.
 *		03/03/2003	Arun		Reflect priorities for the tests when state is BAD
 *		23/07/2003	Williams	eG 3.0 Layout
 *		21/08/2003	Saravanan	Populating infos dynamically
 *		18/09/2003	Williams	Test Row Beautification!!!
 *		27/09/2003	Arun		Singular infos are displayed in the next line
 *		13/10/2003	Arun		Commented specsInfo.checkForUpdate()
 *		23/10/2003	Williams	Removed bold tag and link from unnecessary places
 *		23/10/2003	Williams	Adjusted the height for giving more space/height to Measurements
 *		27/10/2003	Arun		Included Gopi's changes
 *		30/12/2003	Arun		Wraps long descriptors if longer than 50 characters
 *		09/04/2004	Arun		Modified to display infos in a separate page if count exceeds a fixed number
 *		05/05/2004	Arun		Modified More information to Click here for more information
 *		07/05/2004	Arun		Included missing colspan attribute that did not open More Infos window. 
 *								Fixed script that opened More Infos in a new window.
 *		13/05/2004	Arun		Fixed bug where disabled tests throw a StringIndexOutOfBounds exception.
 */
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgErrorLayersSmall.jsp" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.monitor.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "com.eg.supermanager.*"%>
<html>
<head>
<title>TESTS</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="Author" content="John Williams" />
<egui:skin ui="monitor"/>
<script language="JavaScript1.2" src="eg_scripts/eg_validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>

<script language="javascript">
	function openRequest(qry)
	{
		var thisParent = window.parent;
		if(thisParent!=null)
		{
			thisParent.setQry(qry);
		}else
		{
			window.location.href("/final/monitor/EgDispLayers.jsp?"+qry);
		}
	}
	function showMoreInfos(url)
	{
		if(!window.moreinfos)
		{
			moreinfos = window.openWindow(url,"MoreInfos","toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,screenx=0,screeny=0,resizable=yes");
		}
		else
		{
			if(window.moreinfos != null)
			{
				moreinfos = null;
			}

			moreinfos = window.openWindow(url,"MoreInfos","toolbar=no,menubar=no,location=no,status=no,width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,screenx=0,screeny=0,resizable=yes");
		}

		moreinfos.focus();
	}
</script>
</head>
<body leftmargin="0" topmargin="0" marginheight="0" marginwidth="0" bgcolor="#FFFFFF" id="eg_whitebg">
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean" />
<jsp:useBean id="trans1" scope="page" class="egurkha.TransactionBean" />
<%
	//  All Declarations here
	EgDbAdapterUI egDb;
	ResultSet rs_report=null;
	ResultSet rs_lastMeasure = null;
	IniUI ui = IniUI.getInstance();
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	List testsForLayer = new LinkedList();
	Vector v_rept = new Vector();
	Vector v_test = new Vector();
	String str_conn="";
	String str_site="";
	String str_host="";
	String str_layer="";
	String sql_query1="";
	String sql_query2="";
	String sql_query3="";
	String str_image="";
	String str_host_image="";
	String s_flagalarm = "";
	String str_host_type = "";
	String s_fake_type = "";
	boolean b_state1 = false;
	boolean b_state2 = false;
	boolean b_isTestRelevantForServer = false;
	
	// for Db Optimization
	String st_host="";

	EgTablesInfo tableInfo = new EgTablesInfo("manager");
	EgServicesInfo egserInfo = new EgServicesInfo("manager");
	EgExternalInfo extInfo =new EgExternalInfo("manager");
	boolean uniqueHostSystemData = egserInfo.isUniqueHostSystemData();
	Vector hostSysTests = egserInfo.getHostSysTest();
	Hashtable hash = extInfo.getInternalAgentMap();

%>
<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td colspan="2" height="8" id="eg_blankspace">&nbsp;</td>
	</tr>
	<tr>
		<td width="16" id="eg_blankspace" nowrap>&nbsp;</td>
		<td align="center">
<!-- Tests Table begins -->
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
	String str_hosttype;
	String s_qctr = request.getParameter("qctr");
	if(s_qctr.equals("1") || s_qctr.equals("2"))
	{
		long time_diff_in_ms = 0;
		if(com.eg.EgInstallInfo.isSuperManager)
		{
			String currentSession = session.getId();
			String hostname = request.getParameter("host");
			//System.out.println("EgDispTest.jsp hostname " + hostname);
			if(hostname != null)
			{
				if(hostname.indexOf(":")>-1)
				{
					hostname = hostname.substring(0,hostname.indexOf(":"));
				}
				//System.out.println("EgDispTest.jsp host " + hostname);
				ArrayList managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
				//System.out.println("EgDispTest.jsp managerIds " + managerIds);
				if(managerIds != null && !managerIds.isEmpty())
				{
					String s_mgrid = (String)managerIds.get(0);
					String ms = EgSmSuperInfo.getInstance().getValue(s_mgrid,"TIME_DIFF");
					try
					{
						if(ms != null && ms.trim().length()>0)
						{
							time_diff_in_ms = Long.parseLong(ms);
						}
					}
					catch(Exception e)
					{
						e.printStackTrace();
					}
					SmSessionData smsData = new SmSessionData(currentSession,managerIds);
					EgThreadLocal egtl = new EgThreadLocal();
					egtl.set(smsData);
				}
			}
		}
		str_site=request.getParameter("site");
		str_host=request.getParameter("host");
		str_layer=request.getParameter("layer");
		s_flagalarm = request.getParameter("fromalarm");

		// Bye Arun -- str_host_type = null;
		str_host_type = request.getParameter("comptype");
		s_fake_type = request.getParameter("faketype");
		if (s_fake_type!=null && s_fake_type.equalsIgnoreCase("host_system"))
		{
			String testName=request.getParameter("test");
			testName=testName.substring(0,testName.indexOf('-'));
			s_fake_type = discInfo.getTypeForHostTest(str_host,testName);
		}
		/* Bye Arun -- 
		if (StringUtils.isNull(s_fake_type) || s_fake_type.equalsIgnoreCase("null"))
		{
			str_host_type = request.getParameter("comptype");
		}
		else
		{
			str_host_type = s_fake_type;
		}*/

		str_hosttype = str_host_type;

		Hashtable ht_testInfo = new Hashtable();
		boolean b_timeOut = false;
		egDb=EgDbAdapterTypeUI.getObject();
		str_conn=egDb.setConnection();
		if (str_conn != null && str_conn.equalsIgnoreCase("CONNECTED"))
		{
			//new code for dynamic infos starts
			try
			{
				String s_temp = "";
				String s_tempIp = "";
				String s_port = "";
				StringTokenizer st = null;

				if(str_host != null && str_host.indexOf(":") > -1)
				{
					st = new StringTokenizer(str_host,":");
					if(st.countTokens()>1)
					{
						s_tempIp = st.nextToken();
						s_port = st.nextToken();
					}
					//s_tempIp = str_host.substring(0, str_host.indexOf(":"));
				}
				else
				{
					s_tempIp = str_host;
					if (s_tempIp == null)
						s_tempIp = "";
				}

				//new code for infos populate bug fix for multiple msmt_host 
				String s_msmtHostQuery = "Select distinct(msmt_host) from measure_last where trgt_host='" +s_tempIp+ "'";
				Vector v_msmtHost = new Vector();
				ResultSet rs_msmtHost=null;
				try
				{
					rs_msmtHost = egDb.dbselect(s_msmtHostQuery);
					if(rs_msmtHost != null)
					{
						while(rs_msmtHost != null && rs_msmtHost.next())
						{
							String ss = rs_msmtHost.getString("msmt_host");
							if (ss == null)
								continue;
							if (!v_msmtHost.contains(ss))
								v_msmtHost.addElement(ss);
						}
						if (rs_msmtHost != null)
							rs_msmtHost.close();
					}
					if(v_msmtHost.size()==0)
						v_msmtHost.addElement("Test");
				}
				catch(Exception rss)
				{
					if (rs_msmtHost != null)
						try { rs_msmtHost.close(); } catch (Exception grr) {}
					rss.printStackTrace();
				}
				//new code for infos populate bug fix
				for(int i=0; i<v_msmtHost.size();i++)
				{
					String s_tempmsmtHost = (String) v_msmtHost.get(i);
					if(s_tempmsmtHost != null &&
							s_tempmsmtHost.equalsIgnoreCase("Test"))
						s_tempmsmtHost=null;

					//public ResultSet SelectLastMeasTimeInfo(String str_ip, String s_port, String s_site,String s_layer,String s_msmtHost)
					//rs_lastMeasure = egDb.SelectLastMeas(s_tempIp);
					rs_lastMeasure = egDb.SelectLastMeasTimeInfo(s_tempIp, s_port, str_site, str_layer, s_tempmsmtHost);
					if (rs_lastMeasure != null)
					{
						try
						{
							while(rs_lastMeasure != null && rs_lastMeasure.next())
							{
								s_temp = rs_lastMeasure.getString("INFO");
								//s_temp = s_temp.substring(s_temp.indexOf("+")+1, s_temp.length());
								ht_testInfo.put((rs_lastMeasure.getString("TEST_NAME")+ "||" +s_temp), rs_lastMeasure.getString("MSMT_TIME"));
							}
							if (rs_lastMeasure != null)
								rs_lastMeasure.close();
							rs_lastMeasure = null;
						}
						catch (Exception grr)
						{
							if (rs_lastMeasure != null)
							{
								try
								{
									rs_lastMeasure.close();
									rs_lastMeasure = null;
								}
								catch (Exception g2)
								{
								}
							}
						}	
					}
				}//for loop iteration for msmt_host
				//egDb.releaseConnection (false);
			}
			catch(Exception ex)
			{
				System.out.println("During last measurement time info from db "+ex);
				ex.printStackTrace();
				//egDb.releaseConnection (true);
			}
		}
		//new code for dynamic infos ends
		//EgDbAdapterTypeUI.releaseObject(egDb);

		//egDb=EgDbAdapterTypeUI.getObject();
		//str_conn=egDb.setConnection();
		//****** db optimization *****************
		st_host = str_host;

		if (uniqueHostSystemData)
		{
			String compName="";
			compName = st_host.substring(0,st_host.indexOf(":")).trim();
			String st_layer = request.getParameter("layer");
			ArrayList arr = tableInfo.getTestsForLayer(st_layer);

			for (int i=0;i<arr.size();i++)
			{
				if (hash.containsKey(compName) && hostSysTests.contains((String) arr.get(i)))
				{
					String ss = (String)hash.get(compName);
					if(ss != null && !ss.equals(""))
					{
						st_host = ss + str_host.substring(str_host.indexOf(":"));
					}
				}
			}	
		}
		//****************************************
		try
		{
			rs_report = egDb.SelectDispTest_1(st_host, str_site, str_layer, str_host_type, str_hosttype);
			b_state1 = egDb.getState();
			trans.createFile("eg_services.ini");
			boolean agentsOpened = false;
			Hashtable h = new Hashtable();
			ArrayList tests2 = new ArrayList();
			ArrayList infos = new ArrayList();
			ArrayList msmt = new ArrayList();
			while(rs_report != null && rs_report.next())
			{
				tests2.add(rs_report.getString("test_name"));
				infos.add(rs_report.getString("info"));
				msmt.add(rs_report.getString("msmt_host"));
			}
			if (rs_report != null)
				rs_report.close();
			rs_report = null;
			int count = tests2.size();
			Hashtable cache2 = new Hashtable();
			Hashtable relevant = new Hashtable();
			Hashtable portRel = new Hashtable();
			long l_mgrTime = dateInfo.egetUTCDate(false);
			Hashtable timeoutCache = new Hashtable();
			for(int r=0; r<count; r++)
			{
				b_timeOut = false;
				String s_test = (String) tests2.get(r);
				String ind2 = str_host_type+'~'+s_test;
				Boolean b = (Boolean) relevant.get(ind2);
				if (b == null)
				{
					b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
					relevant.put(ind2,new Boolean (b_isTestRelevantForServer));
				} else {
					b_isTestRelevantForServer = b.booleanValue();
				}
				if(s_flagalarm !=null && s_flagalarm.equals("1"))
				{
					if (s_fake_type != null && s_fake_type.length() > 0)
					{
						ind2 = s_fake_type+'~'+s_test;
						b = (Boolean) relevant.get(ind2);
						if (b == null)
						{
							b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
							relevant.put(ind2, new Boolean (b_isTestRelevantForServer));
						} else {
							b_isTestRelevantForServer = b.booleanValue();
						}
					}
					else
						b_isTestRelevantForServer = true;
				}

				//dynamic infos code starts
				String s_info = (String) infos.get(r);
				String s_multiple = null;
				s_multiple = (String) h.get(s_test);
				if (s_multiple == null)
				{
					s_multiple = trans.getStrValue("CUT_OFF_FACTOR", s_test);
					h.put(s_test,s_multiple);
				}
				String s_msmtHost = (String) msmt.get(r);
				if((s_multiple != null) && (s_multiple.trim().length() != 0))
				{
					String s_temp = "";
					String s_testFreq = "";
					String s_msmtTime = "";
					
					long l_multiple, l_testFreq, l_msmtTime= 0l;
					java.util.Date d_msmtTime;
					String s_ip = str_host.substring(0, str_host.indexOf(':'));
					String s_port = "";
					String s_tempStr = "";
					String s_tempStr1 = "";

					if (!agentsOpened)
					{
						trans1.createFile("eg_agents.ini");
						agentsOpened = true;
					}
					Boolean bb = (Boolean) portRel.get(s_test);
					boolean flag = false;
					if (bb == null)
					{
						flag = specsInfo.isPortRelevantForTest(s_test);
						portRel.put(s_test, new Boolean (flag));
					} else 
						flag = bb.booleanValue();
					if(flag)
					{
						s_tempStr = s_test +":"+str_host_type+":"+ str_host;
						s_tempStr1 = s_test +"::"+ str_host;
					}
					else
					{
						s_tempStr = s_test +"::"+ s_ip;
					}
					String ind = s_msmtHost+'~'+s_tempStr;
					s_temp = (String) cache2.get(ind);
					if (s_temp == null)
					{
						s_temp = trans1.getStrValue(s_msmtHost, s_tempStr);
						if(s_temp == null || s_temp.trim().equals(""))
						{
							s_temp = trans1.getStrValue(s_msmtHost, s_tempStr1);
						}
						if (s_temp != null)
							cache2.put(ind,s_temp);
					}

					s_testFreq = (s_temp.substring(s_temp.lastIndexOf(',')+1)).trim();
					if((s_testFreq != null) && s_testFreq.trim().length() != 0)
					{
						l_multiple = 0l;
						l_testFreq = 0l;
						try
						{
							l_multiple = Long.parseLong(s_multiple);
							l_testFreq = Long.parseLong(s_testFreq);
						}
						catch(Exception we)
						{
							we.printStackTrace();
						}
						if(str_hosttype != null && str_hosttype.equalsIgnoreCase("Oracle_server"))
						{
							s_msmtTime = (String)ht_testInfo.get(s_test + "||" + str_host.substring(str_host.lastIndexOf(":")+1)+ s_info);
						}
						else
						{
							s_msmtTime = (String)ht_testInfo.get(s_test + "||" + s_info);
						}
						String ind3 = ind + '~'+s_msmtTime;
						Boolean cc = (Boolean)timeoutCache.get(ind3);
						if (cc == null)
						{
							if(s_msmtTime != null && s_msmtTime.length() != 0)
							{
								d_msmtTime = new java.util.Date(s_msmtTime);
								l_msmtTime = d_msmtTime.getTime();
								if(EgInstallInfo.isSuperManager)
								{
									l_msmtTime = l_msmtTime + time_diff_in_ms;
								}

								if((l_mgrTime - l_msmtTime) > (l_multiple * l_testFreq * 1000l))
								{
									b_timeOut = true; 
									timeoutCache.put(ind3,new Boolean (true));
									//System.out.println("DISABLING TEST:INFO ==> "+s_test+":"+s_info);
								} else {
									timeoutCache.put(ind3,new Boolean (false));
								}
							}
						} else {
							if (cc.booleanValue())
								b_timeOut = true;
						}
					}
				}
				//dynamic infos code ends

				if(b_isTestRelevantForServer && (!b_timeOut))
				{
					v_test.addElement(s_test);
					String testName = s_test + "-" + s_info;
					//if (!testsForLayer.contains(testName))
					//{
						testsForLayer.add(testName);
						testsForLayer.add(AlarmPriorities.GOOD_STATE);
						testsForLayer.add(s_msmtHost);
					//}
				}
			}

			if((v_test.size() < 1) && (!b_timeOut))
			{
				
				//	The metatest table doesnt get filled upto one hour when the agent is started for the first time so no test or info could be got from that during that period ....
				//	Hence the usage of sql_query3 to get the tests from measurement_layer table!! 
				
				rs_report=egDb.SelectDispTest_3(str_layer);
				b_state1=egDb.getState();
				String s_host_system = request.getParameter("comptype");
				while(rs_report != null && rs_report.next())
				{
					String s_test = rs_report.getString("test_name");

					//To check if the test is relevant for this type of server
					b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
					if(s_flagalarm !=null && s_flagalarm.equals("1"))
					{
						if (s_fake_type != null && s_fake_type.length() > 0)
							b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
						else
							b_isTestRelevantForServer = true;
					}

					if(b_isTestRelevantForServer && !b_timeOut)
					{
						v_test.addElement(s_test);

						String testName = s_test + "-" + rs_report.getString("info");
						//if (!testsForLayer.contains(testName))
						//{
							testsForLayer.add(testName);
							testsForLayer.add(AlarmPriorities.GOOD_STATE);
							testsForLayer.add("");
						//}
					}
				}
				if (rs_report != null)
					rs_report.close();
				rs_report = null;
			}
			rs_report=egDb.SelectDispTest_2(str_site,s_flagalarm,str_host_type,str_host,str_layer,str_hosttype);
			b_state2=egDb.getState();

			String s_dummy = "";
			Vector v_dummy = new Vector();
			while(rs_report != null && rs_report.next())
			{
				String s_test = rs_report.getString("test_name");
				b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(str_host_type,s_test);
				if(s_flagalarm !=null && s_flagalarm.equals("1"))
				{
					if (s_fake_type != null && s_fake_type.length() > 0)
						b_isTestRelevantForServer = specsInfo.isTestRelevantForServer(s_fake_type,s_test);
					else
						b_isTestRelevantForServer = true;
				}

				if(b_isTestRelevantForServer)
				{
					v_rept.addElement(rs_report.getString("test_name")+ "-" +rs_report.getString("info"));
					v_rept.addElement(rs_report.getString("state"));
					v_rept.addElement(rs_report.getString("msmt_host"));
					s_dummy = (String)v_rept.get(v_rept.size()-3);

					if(s_dummy.endsWith("-+"))
					{
						v_dummy.addElement(s_dummy);
						v_dummy.addElement(v_rept.get(v_rept.size()-2));
						v_dummy.addElement(v_rept.get(v_rept.size()-1));
					}
				}
			}
			//out.println("testsForLayer1 "+ testsForLayer+"<br>");
			if (rs_report != null)
				rs_report.close();
			rs_report = null;
			for(int jj =0; jj < v_dummy.size() ; jj= jj+3)
			{
				String s_sick = (String) v_dummy.get(jj);
				String s_overallstate = (String) v_dummy.get(jj+1);
				boolean b_fs = false;
				for(int k = 0 ; k < testsForLayer.size(); k = k+3)
				{
					String s_reallysick = (String) testsForLayer.get(k);
					// There is a state change irrespective of the info
					if(s_reallysick.startsWith(s_sick))
					{
						//Check for msmt_host
						String s_chk1 = (String) v_dummy.get(jj+2);
						String s_chk2 = (String) testsForLayer.get(k+2);
						if(s_chk1.equals(s_chk2))
						{
							//change state only if not bad
							s_chk2 = (String) testsForLayer.get(k+1);
							//if(!s_chk2.equals(AlarmPriorities.BAD_STATE))
							if (!EgConfigInfo.isBad(s_chk2))
							{
								testsForLayer.set(k+1,s_overallstate);
								b_fs = true;
							}
						}
					}
				}

				if(b_fs)
				{
					int k = v_rept.indexOf(s_sick);
					v_rept.removeElementAt(k);
					v_rept.removeElementAt(k);
					v_rept.removeElementAt(k);
				}
			}
			//out.println("testsForLayer2 "+ testsForLayer+"<br>");
			String s_tmp =null;
			String s_tmp2 =null;
			for(int i =0;i< v_rept.size();i=i+3)
			{
				s_tmp =(String) v_rept.get(i);
				s_tmp = s_tmp.trim();
				//out.println("S_TMP "+ s_tmp);
				int ct = testsForLayer.indexOf(s_tmp);
				//out.println("CT is "+ ct);
				if(ct > -1)
				{
					String chk1 = (String) v_rept.get(i+2);
					String chk2 = (String) testsForLayer.get(ct+2);
					//To check if both measurement hosts are same
					if(chk1.equals(chk2) || chk2.length() == 0)
					{
						String s_pain = (String) testsForLayer.get(testsForLayer.indexOf(s_tmp)+1);
						//if(!s_pain.trim().equals(AlarmPriorities.BAD_STATE))
						if (!EgConfigInfo.isBad(s_pain.trim()))
						{
							testsForLayer.set((testsForLayer.indexOf(s_tmp)+1),v_rept.get(i+1));
						}
					}
				}
				else
				{
					//Hot fix - 14/04/2001 
					//To eliminate inconsistent display caused due to inconsistent Data
					int k;
					int c=testsForLayer.size();
					for(k=0;k<c;k=k+3)
					{
						String s_comptest = (String) testsForLayer.get(k);
						//out.println("<br>COMP TEST "+ s_comptest);
						s_comptest = s_comptest.substring(0,s_comptest.indexOf("-+")+2);
						//out.println("<br>COmpare s_comptest "+ s_comptest + " "+ s_tmp);
						//if(s_comptest.equals(s_tmp))
						if (s_tmp.equals(s_comptest))
						{
							break;
						}
					}
					if(k == c)
					{ // not equals match - lets do startsWith
						//out.println("<br>HERE !");
						for(k=0;k<c;k=k+3)
						{
							String s_comptest = (String) testsForLayer.get(k);
							//out.println("<br>COMP TEST "+ s_comptest);
							s_comptest = s_comptest.substring(0,s_comptest.indexOf("-+")+2);
							//out.println("<br>COmpare s_comptest "+ s_comptest + " "+ s_tmp);
							//if(s_comptest.equals(s_tmp))
							if (s_tmp.startsWith(s_comptest))
							{
								break;
							}
						}
						//out.println("<br>K is "+k +" C is "+ c);
						if (k < c)
						{
							String chk1 = (String) v_rept.get(i+2);
							String chk2 = (String) testsForLayer.get(k+2);
							//out.println("<BR> CHECK "+chk1 + " "+ chk2 + " "+ chk2.length()+"<br>");
							//To check if both measurement hosts are same
							if(chk1.equals(chk2) || chk2.length() == 0)
							{
								String s_pain = (String) testsForLayer.get(k+1);
								//out.println ("PAIN IS "+ s_pain);
								//if(!s_pain.trim().equals(AlarmPriorities.BAD_STATE))
								if (!EgConfigInfo.isBad(s_pain.trim()))
								{
									testsForLayer.set((k),v_rept.get(i));
									testsForLayer.set((k+1),v_rept.get(i+1));
									testsForLayer.set((k+2),v_rept.get(i+2));
								}
							}
						} else {
							testsForLayer.add(s_tmp);
							testsForLayer.add(v_rept.get(i+1));
							testsForLayer.add(v_rept.get(i+2));
						}
					}
				}
			}
//out.println("testsForLayer3 "+ testsForLayer+"<br>");
			//Hot fix to remove inconsistent display due to inconsistent data in metatest and report table
			for(int j=0;j < v_rept.size(); j+=3)
			{
				s_tmp = (String)v_rept.get(j);
				s_tmp2 = (String)v_rept.get(j+2);

				boolean b_ms = false;
				for(int i=0;i < testsForLayer.size(); i+=3)
				{
					if(s_tmp.equals(testsForLayer.get(i)))
					{
						if (s_tmp2.equals(testsForLayer.get(i+2)))
						{
							b_ms = true;
							//if(!((String)testsForLayer.get(i+1)).equals(AlarmPriorities.BAD_STATE))
							if (!EgConfigInfo.isBad((String)testsForLayer.get(i+1)))
							{
								testsForLayer.set(i+1,v_rept.get(j+1));
							}
						}
						else if (((String)testsForLayer.get(i+2)).length() == 0)
						{
							testsForLayer.set(i+2,s_tmp2);
							b_ms = true;
						}
					}
				}
				if(!b_ms)
				{
					testsForLayer.add(v_rept.get(j));
					testsForLayer.add(v_rept.get(j+1));
					testsForLayer.add(v_rept.get(j+2));
				}
			}

			String host_color = null;
			/*
			 * Fixed by checking to see if the index of the priority is atthe second place for every row.
			 */
			//if (testsForLayer.indexOf(AlarmPriorities.BAD_STATE) > -1)
			if	(
				(testsForLayer.indexOf(EgConfigInfo.HIGH_PRIORITY)%3 == 1) ||
				(testsForLayer.indexOf(EgConfigInfo.LOW_PRIORITY) %3 == 1) ||
				(testsForLayer.indexOf(EgConfigInfo.MEDIUM_PRIORITY)%3 == 1)
				)
			// Arun to fix
			{
				if (str_layer.equals(LayerModel.WEB_SITE) || str_layer.equals(LayerModel.WEB_TRANSACTIONS))
				{
					host_color = ap.getLayerPriority(str_host, str_host_type, str_site, str_layer);
				}
				else
				{
					host_color = ap.getLayerPriority(str_host, str_host_type, str_layer);
				}
			}
			else if (testsForLayer.indexOf(AlarmPriorities.UNKNOWN_STATE) > -1)
			{
				host_color = AlarmPriorities.UNKNOWN_STATE;
			}
			else
			{
				host_color = AlarmPriorities.GOOD_STATE;
			}
%>
			<table width="100%" height="30" cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td rowspan="2" width="65" height="30"><img src="eg_images/eg_layout/Layer1<%=host_color%>.gif" width="65" height="30" alt="<%=host_color%>" border="0" /></td>
					<td width="100%" height="23" background="eg_images/eg_layout/LayerCTop.gif" id="eg_darktextboldbig" align="center"><%=str_layer%></td>
					<td rowspan="2" width="65" height="30"><img src="eg_images/eg_layout/Layer2<%=host_color%>.gif" width="65" height="30" alt="<%=host_color%>" border="0" /></td>
				</tr>
				<tr>
					<td width="196" height="7" background="eg_images/eg_layout/LayerCBottom.gif" id="eg_blankspace" nowrap>&nbsp;</td>
				</tr>
			</table>
<%
			//Passing to the function to decide on the display of msmt_host

			//Contains the priorities for each test as (TestName, Priority) pairs
			//Map testPriorities = egDb.getPriorityForTestOrMeasure(str_host, str_host_type, str_layer, null);
			egDb.releaseConnection(false);

			if (testsForLayer.size () > 0)
			{
				String testStr = StringUtils.getString(testsForLayer);
				testStr = StringUtils.replace(testStr,"-+", "-||");
				//out.println("TESTS FOR LAYER "+ testsForLayer);
				LayerModel lm = new LayerModel(testsForLayer, request);
				Test[] tests = lm.getTests();
%>
			<table align="center" cellspacing="0" cellpadding="0" width="99%" border="0">
<%
				boolean firstRow = true;
				int cc = tests.length-1;
				int infosForTest = 0;
				for (int a=0; a<tests.length; a++)
				{
					boolean nextTestExists = false;
					if (a < cc)
					{
						Test nextTest = tests[a+1];
						nextTestExists = (tests[a].getTestName().equals(nextTest.getTestName()));
					}

					if (nextTestExists)
					{
%>
	<tr>
		<td colspan="4" id="eg_blankspace" height="3">&nbsp;</td>
	</tr>
	<tr>
		<td width="30" nowrap height="20" valign="top"><img src="eg_images/eg_layout/Test<%=tests[a].getTestState()%>.gif" height="20" width="30" border="0" hspace="0" /></td>
		<td colspan="2" width="100%" class="eg_darktext" background="eg_images/eg_layout/TestsBg.gif">&nbsp;&nbsp;<%= ui.getReverseLookupAll(tests[a].getTestName())%></td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
<%
						while (a < tests.length)
						{
							infosForTest++;

							/*
							 * Track the number of infos for this test
							 */

							String testLabel = tests[a].getTestLabel(false);
							String url = this.getUrl(tests[a], request);
							String titleText = null;
							if (testLabel.trim().length() > 45)
							{
								titleText = testLabel;
								testLabel = StringUtils.elipsis(testLabel, 45);
							}
%>
	<tr>
		<td width="20">&nbsp;</td>
		<td colspan="2" width="100%">
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td width="30" nowrap valign="top" height="20"><a onClick="<%=url%>" id="leftmouse" target="main" id="eg_alarmlink"><img src="eg_images/eg_layout/Tests2<%=tests[a].getTestState()%>.gif" height="20" width="30" border="0" hspace="0" /></a></td>
					<td width="100%" class="eg_darktext" background="eg_images/eg_layout/TestsBg2.gif" nowrap><a onClick="<%=url%>" id="leftmouse" target="main" id="eg_alarmlink"
<%
							if (titleText != null)
							{
%>
					 title="<%=titleText%>" 
<%
							}
%>
					><%= ui.getReverseLookupAll(testLabel)%></a></td>
				</tr>
			</table>
		</td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight2.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
<%
							if (a < tests.length-1)
							{
								Test nextTest = tests[a+1];
								nextTestExists = (tests[a].getTestName().equals(nextTest.getTestName()));
							}

							if (nextTestExists)
							{
								a++;
							}
							else
							{
								break;
							}
						}
					}
					else
					{
						String url = null;
						String label = null;

						String state = tests[a].getTestState();
						if (tests[a].getTestInfo().equals(Test.MORE_INFOS))
						{
							label = "Click here for more information ...";
						}
						else
						{
							url = this.getUrl(tests[a], request);
							label = tests[a].getTestLabel(false);
							if (label.length() > 35)
							{
								label = StringUtils.elipsis(label, 35);
							}
						}
%>
	<tr>
		<td colspan="4" id="eg_blankspace" height="3">&nbsp;</td>
	</tr>
<%
						if (tests[a].getTestInfo().equals(Test.MORE_INFOS))
						{
							StringBuffer moreInfos = new StringBuffer(64);
							moreInfos.append("EgMoreInfosView.jsp?qctr=1&showAll=yes&test=");
							moreInfos.append(tests[a].getTestName());
							moreInfos.append("&host=");
							moreInfos.append(str_host);
							moreInfos.append("&layer=");
							moreInfos.append(str_layer);
							moreInfos.append("&site=");
							moreInfos.append(str_site);
							moreInfos.append("&comptype=");
							moreInfos.append(str_host_type);
							moreInfos.append("&faketype=");
							moreInfos.append(s_fake_type);
							moreInfos.append("&fromalarm=");
							moreInfos.append(s_flagalarm);
							
%>
	<tr>
		<td width="30" nowrap height="20" valign="top"><img src="eg_images/eg_layout/Test<%=state%>.gif" height="20" width="30" border="0" hspace="0" /></td>
		<td colspan="2" width="100%">
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td background="eg_images/eg_layout/TestsBg.gif" class="eg_darktext" colspan="2" height="20" align="left" nowrap valign="top">&nbsp;<%=tests[a].getTestName()%></td>
				</tr>
			</table>
		</td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
	<tr>
		<td width="20">&nbsp;</td>
		<td colspan="2" width="100%">
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td width="30" nowrap valign="top" height="20"><img src="eg_images/eg_layout/Tests2<%=state%>.gif" height="20" width="30" border="0" hspace="0" /></a></td>
					<td width="100%" class="eg_darktext" background="eg_images/eg_layout/TestsBg2.gif" valign="top"><a href="javascript:showMoreInfos('<%=moreInfos.toString()%>')" id="eg_alarmlink"><%=label%></a></td>
				</tr>
			</table>
		</td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight2.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
<%
						}
						else
						{
%>
	<tr>
		<td width="30" nowrap height="20" valign="top"><img src="eg_images/eg_layout/Test<%=state%>.gif" height="20" width="30" border="0" hspace="0" /></td>
		<td colspan="2" width="100%">
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td background="eg_images/eg_layout/TestsBg.gif" class="eg_darktext" colspan="2" height="20" align="left" nowrap valign="top">&nbsp;
<%
							if (!StringUtils.isNull(label))
							{
								out.println(ui.getReverseLookupAll(tests[a].getTestName()));
							}
							else
							{
%>
			<a onClick="<%=url%>" id="leftmouse" target="main" id="eg_alarmlink"><%=ui.getReverseLookupAll(tests[a].getTestName())%></a>
<%
							}
%>

					</td>
				</tr>
			</table>
		</td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
<%
							if (!StringUtils.isNull(label))
							{
%>
	<tr>
		<td width="30">&nbsp;</td>
		<td colspan="2" width="100%">
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td width="30" nowrap valign="top" height="20"><a onClick="<%=url%>" id="leftmouse" target="main" id="eg_alarmlink"><img src="eg_images/eg_layout/Tests2<%=state%>.gif" height="20" width="30" border="0" hspace="0" /></a></td>
					<td width="100%" class="eg_darktext" background="eg_images/eg_layout/TestsBg2.gif"><a onClick="<%=url%>" id="leftmouse" target="main" id="eg_alarmlink"><%= ui.getReverseLookupAll(label)%></a></td>
				</tr>
			</table>
		</td>
		<td width="20" nowrap valign="top"><img src="eg_images/eg_layout/TestsRight2.gif" height="20" width="20" border="0" hspace="0" /></td>
	</tr>
<%
							}
						}
					}
				}
			}
%>
</table>
<%
			if(testsForLayer.size() == 0)
			{
%>
<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
	<tr>
		<td align="center" colspan="4" valign="middle" id="eg_darktext" height="180">No tests are enabled for this layer!</td>
	</tr>
</table>
<%
			}

			//cleanup
			testsForLayer.clear();
			v_rept.clear();
			v_test.clear();

		} //End Of Try Block
		catch(Exception e)
		{
			if(!str_conn.equals("CONNECTED"))
			{
				out.println("Connection could not be established");
			}
			else if(!b_state1)
			{
				out.println("Error in Sql Query");
			}
			else
			{
				out.println(e.toString());
			}
			if (rs_report != null)
			{
				try
				{
					rs_report.close();
					rs_report = null;
				}
				catch (Exception bug123) {}
			}
			try
			{
				egDb.releaseConnection(true);
			}
			catch(Exception e2)
			{
			}
		} //End Of Class Block
		EgDbAdapterTypeUI.releaseObject(egDb);
	}
	else
	{
%>
		<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td align="center" valign="middle" id="eg_darktext" height="232">Please select a layer to view the corresponding tests</td>
			</tr>
		</table>
<%
	}
	
%>
		</td>
	</tr>
</table>
</body>
</html>
<%!
	AlarmPriorities ap = AlarmPriorities.getInstance();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo dateInfo = new EgDateInfo();
//	String indent = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";

	private String getUrl(Test test, HttpServletRequest request)
	{
		IniUI ui = IniUI.getInstance();
		StringBuffer url = new StringBuffer();
		//url.append("/final/monitor/dispLayers.jsp?site=");
		url.append("javascript:openRequest('site=");
		url.append(request.getParameter("site"));
		url.append("&host=");
		url.append(request.getParameter("host"));
		url.append("&layer=");
		url.append(request.getParameter("layer"));
		url.append("&qctr=2&comptype=");
		url.append(request.getParameter("comptype"));
		url.append("&fromalarm=");
		url.append(request.getParameter("fromalarm"));
		url.append("&msmt_host=");
		url.append(test.getMsmtHost());
		url.append("&test=");
		url.append(test.getTestName());
		url.append("-+");
		url.append(URLEncoder.encode(ui.getLookedupString(test.getTestInfo())));
		url.append("&tstate=");
		url.append(test.getTestState());
		String str = request.getParameter("faketype");
		if (str != null && str.length() > 0)
		{
			url.append("&faketype=");
			url.append(request.getParameter("faketype"));
		}
		url.append("')");
		return url.toString();
	}

	//Method to sort and decide on Msmt_host display
//	private List msmthostDisp(List v_m)
//	{
//		if(v_m.size() == 3)
//		{
//			v_m.set(2, EgConstants.BLANK_STRING);
//			return v_m;
//		}
//
//		for(int i=0;i < v_m.size(); i=i+3)
//		{
//			String s_tmp_test = (String) v_m.get(i);
//			if(!specsInfo.isTestExternal(s_tmp_test.substring(0,s_tmp_test.indexOf("-+")-1)))
//			{
//				//Removing the msmt_host display by storing an empty string
//				//If it is an internal test
//				v_m.set(i+2, EgConstants.BLANK_STRING);
//			}
//
//			//This check returns false if there is more than one element of this kind
//			if(v_m.indexOf(s_tmp_test) == v_m.lastIndexOf(s_tmp_test))
//			{
//				int s = 0;
//				for(s=0;s<v_m.size();s++)
//				{
//					String s_tmp = (String) v_m.get(s);
//					if(s_tmp_test.endsWith("-+")  && s_tmp.startsWith(s_tmp_test))
//					{
//						//Check to see if the msmt hosts are different
//						if(!((String)v_m.get(i+2)).equals(v_m.get(s+2)))
//							break;
//					}
//					else if(s_tmp.endsWith("-+") && s_tmp_test.startsWith(s_tmp))
//					{
//					 if(!((String)v_m.get(i+2)).equals(v_m.get(s+2)))
//						break;
//					}
//				}
//				if(s == v_m.size())
//				{
//					//Removing the msmt_host display by storing an empty string
//					v_m.set(i+2, EgConstants.BLANK_STRING);
//				}
//			}
//		}
//		return v_m;
//	}

	private List getTestInfo(List testsForLayer, String compName, String compType, String layerName)
	{
		List newTestInfo = new LinkedList();

		Sorter sorter = new Sorter(AlarmPriorities.getStatesOrder(), true);
		List states = new LinkedList();

		AlarmPriorities ap = AlarmPriorities.getInstance();

		Map map = new HashMap();
		for (Iterator i=testsForLayer.iterator(); i.hasNext();)
		{
			String test = (String)i.next();
			String[] testInfo = StringUtils.split(test, EgConstants.HYPHEN);
			String state = (String)i.next();
			String msmtHost = (String)i.next();

			//if (state.equals(AlarmPriorities.BAD_STATE))
			if (EgConfigInfo.isBad(state))
			{
				state = ap.getTestPriority(compName, compType, layerName, test);
			}

			List row = new LinkedList();
			row.add(testInfo[0]);
			row.add(state);
			states.add(row);

			StringBuffer sb = new StringBuffer();
			if (testInfo[1].startsWith(EgConstants.PLUS) && testInfo[1].length() > 0)
			{
				sb.append(testInfo[1].substring(1));
			}

			int length = msmtHost.length();
			if (length > 0)
			{
				if (length > 25)
				{
					sb.append(msmtHost.substring(0, 25));
				}
				else
				{
					sb.append(msmtHost);
				}
			}

			sb.append(EgConstants.AT_THE_RATE);
			sb.append(state);

			if (map.containsKey(testInfo[0]))
			{
				//
				// Test name is already in the map. Then append to it
				//
				StringBuffer temp = new StringBuffer();
				String prevInfo = (String)map.get(testInfo[0]);
				temp.append(prevInfo);
				temp.append(EgConstants.COMMA);
				temp.append(sb.toString());

				map.put(testInfo[0], temp.toString());
			}
			else
			{
				map.put(testInfo[0], sb.toString());
			}
		}

		Collections.sort(states, sorter);
		for (Iterator i=states.iterator(); i.hasNext(); )
		{
			List row = (List)i.next();

			Object testName = row.get(0);
			if (newTestInfo.indexOf(testName) == -1)
			{
				String testInfo = (String)map.get(testName);
				String[] values = StringUtils.getTokens(testInfo, EgConstants.COMMA);

				for (int a=0; a<values.length; a++)
				{
					String[] info = StringUtils.split(values[a], EgConstants.AT_THE_RATE);

					newTestInfo.add(testName);	//Name of the test
					newTestInfo.add(info[1]);	//State
					newTestInfo.add(info[0]);	//Info and Msmt Host
				}
			}
		}

		return newTestInfo;
	}

	//
	// Splits the info string into info and msmt host
	//
	private String[] getInfo(String testInfo)
	{
		String[] info = new String[2];
		int index = testInfo.indexOf(EgConstants.BLANK_SPACE);
		if (index == -1)
		{
			//
			// See if info or msmtHost is present
			//
			index = testInfo.indexOf("(");
			if (index == -1)
			{
				info[0] = testInfo;
				info[1] = EgConstants.BLANK_STRING;
			}
			else
			{
				info[0] = EgConstants.BLANK_STRING;
				info[1] = testInfo.substring(index, testInfo.lastIndexOf(")"));
			}
		}
		else
		{
			info[0] = testInfo.substring(0, index);
			info[1] = testInfo.substring(index+1);
		}

		return info;
	}
%>
