<%
/*******************************************************************************
*	Name		:	EgDispMonSegments.jsp
*	Author		:	Sandhya.K
*	Purpose		:	To select a segment and display the segment topology
*	Version		:	eG 3.0
*	Created On	:	21/11/2001
*	Modified	:	13/12/2001	kk			Restrict SEGMENT_ from appearing in segment names.
					27/12/2001	Sandhya		Sisplay segments only if they are configured. 
					25/01/2002	Sandhya		Display list box only if more than one segment is configured.
					02/06/2003	Williams	For Version 3.0
					01/12/2003	Arun		Increased the width and height of the applets
					21/05/2004	Arun		Resized applet widths for use with non-flickering applets
*******************************************************************************/
%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage="EgProbsM.jsp"%> 
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgStateZone" %>
<%@ page import="com.eg.EgTopoInfo"%>
<%@ page import="egurkha.EgAspLite" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.monitor.*" %>
<%@ page import = "com.eg.EgAlarmTable" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.ini.*" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgCrawler" %>
<%@ page import = "java.io.*" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store"); 
	response.setHeader("Pragma","no-cache"); 
	response.setDateHeader ("Expires", -1); 

	EgTopoInfo topoInfo=new EgTopoInfo("manager");

	String segment = request.getParameter("segment");
	String service = request.getParameter("service");
	String serviceName = request.getParameter("serviceName");
	String segState = request.getParameter("state");
	String fromSuper = (String)session.getAttribute("fromSuper");

	boolean isJS = false;
	IniUI iniUI = IniUI.getInstance();
	String jsOption = 	iniUI.getValue("TOPOLOGY_OPTIONS","Javascript");
	if(jsOption!=null && jsOption.length() > 0)
	{
		if(jsOption.equalsIgnoreCase("yes") || jsOption.equalsIgnoreCase("true"))
			isJS = true;
		else if(jsOption.equalsIgnoreCase("auto"))
		{
			String max_limit = iniUI.getValue("TOPOLOGY_OPTIONS","Max_limit");
			int max = 100; // Default value
			try{
				max = Integer.parseInt(max_limit);
			}
			catch(Exception exp){
				max = 100;
			}
			String[] totalVariables =  topoInfo.getVariables(segment);
			int totalComps = 0;
			if(totalVariables!=null)
				totalComps = totalVariables.length;
			if(totalComps > max)
				isJS = false;
			else
				isJS = true;
		}
	}
	String zoomLevel = request.getParameter("zoom");
	if(zoomLevel==null)
	{
		zoomLevel = "100";
	}

	
%>
<html>
<head>
<title> &nbsp; eG Manager &nbsp; ? &nbsp; Segments - Topology &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta name="Author" content="John Williams" />
<!-- <link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" /> -->
 <egui:skin ui="monitor"/>
<script language="JavaScript1.2" src="/monitor/eg_scripts/eg_validate.js"></script>
<script language="JavaScript1.2" src="../scripts/<%=script_src%>"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>

<script language="JavaScript1.2">
//<!--

documentView ={
			getObject: function()
			{
				if(typeof( window.innerWidth) == 'number')
				{//Firefox
					this.height = window.innerHeight;
					this.width = window.innerWidth;
					this.fireFox = true;
				}
				else if( document.documentElement && ( document.documentElement.clientWidth
					|| document.documentElement.clientHeight ))
				{//IE 6 + in 'standards compliant mode'
					this.height = document.documentElement.clientHeight;
					this.width = document.documentElement.clientWidth;
					this.ie = true;
				}
				else if(document.body && document.body.clientHeight)
				{ //IE 4 compatible
					this.height = document.body.clientHeight;
					this.width = document.body.clientWidth;
					this.ie = true;
				}
				return this;
			},
			getHeight: function()
			{
				return this.getObject().height;
			},
			getWidth: function()
			{
				return this.getObject().width;
			},
			isIE: function()
			{
					return this.getObject().ie;
			},
			isFireFox: function()
			{
					return this.getObject().fireFox;
			}
	};

function refreshFunction()
{
	var service = '<%=service%>';
	var serviceName = '<%=serviceName%>';
	var segment = '<%=segment%>';
	var segState='<%=segState%>';
	var zoomObj = document.getElementById('zoom');
	var zoom = '100';
	if(zoomObj!=null) zoom = zoomObj.value;

	if(service!=null && service!='null' && service!="")
	{
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment) + "&service=" + encodeURI(service) + "&state="+segState + "&zoom="+zoom;
	}
	else if(serviceName!=null && serviceName!='null')
	{
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment) + "&serviceName=" + encodeURI(serviceName) + "&state="+segState + "&zoom="+zoom;
	}
	else
	{
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment) + "&zoom="+zoom;
	}
}

setInterval("refreshFunction()",60000);

function listselect()
{
	//this method uses object in segmentlist.jsp
	var segfin=window.parent;
	var thisForm = document.showsegments;
	var segment = thisForm.segments.options[thisForm.segments.options.selectedIndex].value;
	/*if(segfin!=null)
	{
		var parentDoc = segfin.document;
		var x=parentDoc.getElementById("windowTitle");
		x.style.visibility="visible";
		x.style.display="block";
		x.innerHTML="<b id='inner_subhead'>"+segment+"</b>";
	}*/
	var url = "";

	var service='<%=request.getParameter("service")%>';
	var serviceName='<%=request.getParameter("serviceName")%>';
	var segState='<%=request.getParameter("state")%>';
	
	if(service!=null && service!='null' && service!="")
	{
		url = "/final/monitor/EgDispMonSegments.jsp?segment=" + segment + "&service=" + service;
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment) + "&service=" + encodeURI(service) + "&state="+segState;
	}
	else if(serviceName!=null && serviceName!='null')
	{
		url = "/final/monitor/EgDispMonSegments.jsp?segment=" + segment + "&serviceName=" + serviceName;
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment) + "&serviceName=" + encodeURI(serviceName) + "&state="+segState;
	}
	else
	{
		url = "/final/monitor/EgDispMonSegments.jsp?segment=" + segment;
		window.location.href = '<%=response.encodeURL("../monitor/EgDispMonSegments.jsp?")%>segment=' + encodeURI(segment);
	}

}
<%

	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	String s_userid = user.getLoginID();
	session.setAttribute("segment",segment);

	Vector v_seg = new Vector();
	v_seg.addAll(user.getSegments());

	if(service!=null && !service.equals(""))
	{
		session.setAttribute("service",service);
	}

%>
//-->
/*------------------------Div Resize--------------------*/
var $j = jQuery.noConflict();
function myResize() 
{
	var jscript = '<%=isJS%>';
  	if(jscript == 'false')
 	{

		var myWidth = 900, myHeight = 480;
		document.getElementById("my_applet").style.width=myWidth+"px";
		document.getElementById("my_applet").style.height=myHeight+"px";

		if( typeof( window.innerWidth ) == 'number' ) 
		{
		//Non-IE
			document.getElementById("my_applet").style.width=(window.innerWidth-12)+"px";
<%
			if(v_seg.size() > 1)
			{
%>
				document.getElementById("my_applet").style.height=(window.innerHeight-68)+"px";
<%
			}
			else
			{
%>
				document.getElementById("my_applet").style.height=(window.innerHeight-38)+"px";
<%
			}
%>
		}
		else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight )) 
		{
			//IE 6+ in 'standards compliant mode'
			document.getElementById("my_applet").style.width=(document.documentElement.clientWidth-12)+"px";
			//document.getElementById("my_applet").style.height=(document.documentElement.clientHeight-37)+"px";
<%
			if(v_seg.size() > 1)
			{
%>
				document.getElementById("my_applet").style.height=(document.documentElement.clientHeight-68)+"px";
<%
			}
			else
			{
%>
				document.getElementById("my_applet").style.height=(document.documentElement.clientHeight-38)+"px";
<%
			}
%>
		}
		else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) )
		{
			//IE 4 compatible
			document.getElementById("my_applet").style.width=(document.body.clientWidth-12)+"px";
			//document.getElementById("my_applet").style.height=(document.body.clientHeight-37)+"px";
<%
			if(v_seg.size() > 1)
			{
%>
				document.getElementById("my_applet").style.height=(document.body.clientHeight-68)+"px";
<%
			}
			else
			{
%>
				document.getElementById("my_applet").style.height=(document.body.clientHeight-38)+"px";
<%
			}
%>
		}
	}
	else
	{
		var winWidth = $j(window).width();
		var winHeight = $j(window).height();
		var size = "<%=v_seg.size()%>";
		var minusValue = 34;
		if (parseInt(size)>1)
		{
			minusValue = 66;
		}
		$j(".topoGraphAppDiv").width(winWidth-10);
		$j(".topoGraphAppDiv").height(winHeight-minusValue);
	}
}
window.onresize = myResize;
/*-----------------------Div Resize---------------------*/
</script>
</head>

<%
	if(v_seg!=null && v_seg.size()>0)
	{
	
		try
		{
			String pageStr = "";

			if(serviceName!=null && !serviceName.equals(""))
			{
				segState = (String)getStateForSegment(service.trim(),"SEG:"+segment.trim());

				//pageStr = "header.jsp?title=SEGMENT PREVIEW of " + EgURLEncoder.encode(segment,"UTF-8") + " for SERVICE : " + EgURLEncoder.encode(serviceName,"UTF-8") + "&state_str=" +  EgStateZone.getState("Segment:"+segment.trim()+":NULL") + "&segForService=" + EgURLEncoder.encode(segment,"UTF-8") + "&fromSegment=true";

				pageStr = "header.jsp?title=SEGMENT PREVIEW of " + EgURLEncoder.encode(segment,"UTF-8") + " for SERVICE : " + EgURLEncoder.encode(service,"UTF-8") + "&state_str=" +  segState + "&segForService=" + EgURLEncoder.encode(segment,"UTF-8") + "&fromSegment=true";
			}
			else
			{
				pageStr = "header.jsp?title=SEGMENT PREVIEW : "+EgURLEncoder.encode(segment,"UTF-8")+"&state_str="+EgStateZone.getState("Segment:"+segment.trim()+":NULL");
			}
%>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0"  style="overflow:hidden" scroll="no" scrolling="no" onload="setTimeout('myResize()',0)">

<form name="showsegments" method="post" style="margin:0px;padding:0px;" id="inner_bg">
<input type="hidden" name='zoom' id='zoom' value='<%=zoomLevel%>'>
<table border="0" width="100%" cellspacing="0" cellpadding="0"  height="100%">

<jsp:include page="<%=pageStr%>"/>
	

<%
	if(v_seg.size() > 1)
	{
%>
	<tr>
		<td >
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" >
			<!-- 		<tr>
						<td>
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="19" id="data_headbg">
								<tr>
									<!-- <td width = "6"><img src = "/final/monitor/eg_images/gray/top-left.gif" border = "0"/></td> -->
									<!-- <td width="100%" nowrap align="left" id="inner_subhead" class="head_padding4"><egui:intnl text="Segment Preview"/> </td> -->
									<!-- <td><img src = "/final/monitor/eg_images/gray/top-header-right.gif"/></td> -->
									
							<!-- 	</tr>
							</table> -->
			<!-- <egui:intnl text="segment preview"/> -->
					<!-- 	</td>
					</tr> -->
					<tr>
						<td align="center" id="inner_bg" class="main_padding4" style="padding-bottom:0px">
							<table width="100%" cellspacing="0" cellpadding="5" height="22" border="0" id="cell_border3">
								<tr>
									<!-- <td width="18" height="22"><img src="eg_images/eg_layout/InnerEdgeLeft.gif" width="18" height="22" border="0" /></td> -->
									<td align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<th  nowrap="nowrap"><egui:intnl text = 'monitor.topology.Select a Segment'/>&nbsp;</th>
												<td  nowrap align="left">
												<select name="segments" size="1" onChange="javascript:listselect();">

				<%
									String siteSegs = "";
									List v_segment_state = new LinkedList();
									Vector vec_seg = new Vector();

									if((service!=null && !service.trim().equals("")) || (serviceName!=null && !serviceName.equals("")))
									{
										if(serviceName!=null && !serviceName.equals(""))
											siteSegs = topoInfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + serviceName.trim()).trim();
										else
											siteSegs = topoInfo.getValue("WEB_SITE_SEGMENTS","Web_site:" + service.trim()).trim();
										if(siteSegs != null && siteSegs.length() > 0)
										{
											StringTokenizer stc = new StringTokenizer(siteSegs,",");
											while(stc.hasMoreTokens())
											{
												vec_seg = new Vector();
												List row = new LinkedList();

												String thisSeg = stc.nextToken().trim();
												if(thisSeg != null)
												{
													row.add(thisSeg);
													
													String thisSegState = (String)getStateForSegment(service,"SEG:"+thisSeg);

													if(thisSegState!=null)
														row.add(thisSegState);
												}
												v_segment_state.add(row);
											}
											
											Object[] segments = v_segment_state.toArray();
											Arrays.sort(segments, new Sorter(AlarmPriorities.getStatesOrder(), true));

											for (int a=0; a<segments.length; a++)
											{
												List lis = (List)segments[a];
												String segmentName = (String)lis.get(0);

												if(segmentName!=null)
												{
													segmentName = segmentName.trim();
													if(!vec_seg.contains(segmentName))
														vec_seg.add(segmentName);
												}
											}
											if(vec_seg!=null && vec_seg.size()>0)
											{
												v_seg = new Vector();
												v_seg.addAll(vec_seg);
											}
										}
									}
									else if(v_seg != null && v_seg.size() > 0)
									{
										vec_seg.addAll(v_seg);
										for(int v=0;v<vec_seg.size();v++)
										{
											//vec_seg = new Vector();
											List row = new LinkedList();

											String thisSeg = (String)vec_seg.get(v);
											if(thisSeg != null)
											{
												row.add(thisSeg);
												
												String thisSegState = EgStateZone.getState("Segment:"+thisSeg.trim()+":NULL");

												if(thisSegState!=null)
													row.add(thisSegState);
											}
											v_segment_state.add(row);
										}
										
										Object[] segments = v_segment_state.toArray();
										Arrays.sort(segments, new Sorter(AlarmPriorities.getStatesOrder(), true));

										vec_seg.clear();
										for (int a=0; a<segments.length; a++)
										{
											List lis = (List)segments[a];
											String segmentName = (String)lis.get(0);

											if(segmentName!=null)
											{
												segmentName = segmentName.trim();
												if(!vec_seg.contains(segmentName))
													vec_seg.add(segmentName);
											}
										}
										if(vec_seg!=null && vec_seg.size()>0)
										{
											v_seg = new Vector();
											v_seg.addAll(vec_seg);
										}
									}

									for(int i=0;i<v_seg.size();i++)
									{
										if(segment.trim().equals((String)v_seg.get(i)))
										{
				%>
										<option value="<%=(String)v_seg.get(i)%>" selected><%=(String)v_seg.get(i)%></option>
				<%
										}
										else
										{
				%>
											<option value="<%=(String)v_seg.get(i)%>"><%=(String)v_seg.get(i)%></option>
				<%
										}
									}
				%>
												</select>
												</td>
											</tr>
										</table>
									</td>
									<!-- <td width="18" height="22"><img src="eg_images/eg_layout/InnerEdgeRight.gif" width="18" height="22" border="0" /></td> -->
								</tr>
							</table>
						</td>
					</tr>
				<%
					}
				%>
					<tr>
						<td align="center" valign="top" id="inner_bg" class="main_padding4" height="100%">
<%
	if(!isJS)
	{
%>
						<div id="mytopohidden" style="visibility:visible;width:100%;border:0px solid #ff0000;" class="data_border"> 
<!-- 							<table cellspacing="0" cellpadding="0"  border="0" width="100%" >
								<tr>
									<td>
										<table align="center" width="100%" cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td valign="top" align="center"> -->
												<applet id="my_applet" align="center" code="com.egurkha.EgTopology.class" codebase="/final/topology" width="935" height="480">
						<!--
											<applet code="com.egurkha.SegmentTopology.class" codebase="/final/monitor" width="25000" height="25000">
						-->
												<param name="fromSuper" value="<%=fromSuper%>" />
												<param name="sessionId" value="<%=session.getId()%>" />
												<param name="physical_topology" value="1" />
												<param name="urlPrefix" value="<%=EgInstallInfo.getUrlPrefix()%>" />
												<param name="segment" value="<%=segment%>" />
<%
	if(service!=null && !service.equals(""))
	{
%>
												<param name="service" value="<%=service%>" />
<%
	}
%>
												<param name="site" value="<%=service%>" />
												<param name="r_uri" value="<%=request.getRequestURI()%>" />
												<param name="r_port" value="<%=request.getServerPort()%>" />
												<param name="r_host" value="<%=request.getServerName()%>" />
												<param name="r_protocol" value="<%=request.getProtocol()%>" />
												<param name="canvasType" value="segment" />
												<param name="urlFinal" value = "<%=request.getScheme()%>://<%=request.getServerName()%>:<%=request.getServerPort()%><%=request.getContextPath()%>" />
												</applet>
			<!-- 									</td>
											</tr>
										</table>
									</td>
								</tr>
							</table> -->
						</div>
<%
	}
	else
	{
%>
						<div id="loading_image" style="position:absolute;top:280px;left:480px;visibility:visible;display:block"><table height="100%"><tr><td height="100%" valign="middle"> <img src='/final/monitor/eg_images/indicator_medium.gif'></td></tr></table> </div>

						<div id="mytopohidden_ram" style="visibility:visible;padding:0px;margin:0px" class="topoGraphAppDiv data_border"> 

<%
		//int iframeWidth = 974;
		//int iframeHeight = 550;
		String frameSrc = "/final/monitor/EgTopologyJS.jsp?segment="+EgURLEncoder.encode(segment,"UTF-8")+"&physical_topology=1"+"&type=segment" + "&zoom="+EgURLEncoder.encode(zoomLevel,"UTF-8");

		if(fromSuper!=null)
		{
			frameSrc = frameSrc + "&fromSuper="+EgURLEncoder.encode(fromSuper,"UTF-8")+ "&sessionId="+(session.getId());
		}
		if(service!=null && !service.equals(""))
		{
			frameSrc = frameSrc+"&service="+EgURLEncoder.encode(service,"UTF-8")+"&site="+EgURLEncoder.encode(service,"UTF-8");
		}
%>
							<iframe  width="100%" height="100%" id="topoFrame" name="topoFrame" src="<%=frameSrc%>" border="0" scrolling="no" marginwidth="0px" marginheight="0px" frameborder="0" color="blue" style="border-width:0px; border-style:solid; border-color:yellow;"></iframe>
						</div>
						
<%
	}
%>

						<div class="data_border" id="myframe_loading" border="0" scrolling="no" marginwidth="0" marginheight="0" style="visibility:hidden;display:none;overflow:auto;height:100%">
							<table width='100%' height='100%' cellspacing="0" cellpadding="0" ><tr><td align='center' valign="middle"> <img src='/final/monitor/eg_images/load_round.gif'></td></tr></table>
						</div> 
						</td>
					</tr>
				</table>
			</td>
		</tr>
</table>
<%
		//To identify for come Back from LayerModel page
			session.setAttribute("prevPage","SEGMENT PREVIEW");//-------06/07/07----------

			if(request.getQueryString()!=null)
			{
				session.setAttribute("monitorLastSession","/final/monitor/EgDispMonSegments.jsp?"+request.getQueryString());
			}
			else
			{
				session.setAttribute("monitorLastSession","/final/monitor/EgDispMonSegments.jsp");
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception in EgDispMonSegments..");
			e.printStackTrace();
		}
	}
	else if(v_seg.size()==0)
	{
		String pageStr = "header.jsp?title=SEGMENT PREVIEW";
%>
	<body style="overflow:auto" marginwidth="0" marginheight="0" topmargin="0" leftmargin="0" scroll="auto">
		<table width="100%" height="100%"  border="0" cellpadding="0" cellspacing="0" align="center" >
			<jsp:include page="<%=pageStr%>"/>
				<tr>
					<td class="main_padding8">
						<table width="100%"  border="0" align="center" cellpadding="0" cellspacing="0" height="10"  >

							<tr>
								<td align="center" height="20" colspan="2">
									<table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" >
										<tr>
											<td align="center" height="10" >&nbsp;</td>
										</tr>
										<tr>
											<td align="center"  ><img src = "/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif" width="44px" height="40px" border="0"></td>
										</tr>
										<tr>
											<td align="center" height="5" ><b><egui:intnl text="monitor.segments.No segments found"/></b></td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
	</body>
<%
	}
%>
<%!
	public String getStateForSegment(String serviceName, String segmentName)
	{
		ServiceDAO dao = MonitorDAOFactory.getInstance().getServiceDAO();
		return dao.getStateForSegment(serviceName, segmentName);
	}
%>
</form>
</body>
</html>







