<%@ page language="java" contentType="application/json; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ include file = "EgMonitorTracker.jsp"%>
<%@ page import="com.egurkha.monitor.EgServerDashboardModel" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgDisableInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="com.egurkha.monitor.EgGraphsUtil" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.supermanager.*"%>
<%@ page import="net.sf.json.*"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	if(com.eg.EgInstallInfo.isSuperManager)
	{
		ArrayList managerIds=null;
		String hostname = request.getParameter("hostName");
		if(hostname != null && hostname.trim().length()>0)
		{
			if(hostname.indexOf(":")>-1)
			{
				hostname = hostname.substring(0,hostname.indexOf(":"));
			}
			managerIds = EgElementInfo.getInstance().getManagerIDs("component",hostname);
		}
		if(managerIds != null && !managerIds.isEmpty())
		{
			SmSessionData smsData = new SmSessionData(session.getId(),managerIds);
			EgThreadLocal egtl = new EgThreadLocal();
			egtl.set(smsData);
		}
	}
	JSONObject rootJson = new JSONObject();
	JSONObject hiddens = new JSONObject();
	//JSONObject selectedValues = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject dialChartValues = new JSONObject();
	JSONObject GridValues = new JSONObject();

	String compType=request.getParameter("compType");
	String compName=request.getParameter("hostName");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	String blockType = request.getParameter("blockType");
	String ciscoSelectedType = request.getParameter("ciscoSelectedType");
	//ciscoSelectedType = ( ciscoSelectedType != null && !ciscoSelectedType.equalsIgnoreCase("overview") )?ciscoSelectedType:"";
	String options[] = {"overview", "protocols", "flows"}, dispVal = "";
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String hostName="";
	String portNo="";
	String sid="";
	String site="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel model=new EgServerDashboardModel();
	
	MonitorDAOFactory monitorfactory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorfactory.getServerDashBoardDAO();
	ErUtils  erutils=new  ErUtils();

	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDisableInfo disableInfo = new EgDisableInfo("manager");
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgGraphsUtil graphUtil=new EgGraphsUtil(trackerLanguage);
	//EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	System.out.println("allMsmtHosts--->"+allMsmtHosts);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	Vector runingTestList=model.getRunningTest(compName,compType,tab);
	ArrayList getExcludedTest = disableInfo.getExcludedTestsForComponent(compName, compType);

%>
<%
	JSONArray subSystemArr = new JSONArray();		
	String overviewSelected = "", protocolsSelected = "", flowsSelected = "" ;
	if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("overview") )
	{		
		overviewSelected = "selected";
		protocolsSelected = "";
		flowsSelected = "";
	}
	else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("protocols") )
	{
		overviewSelected = "";
		protocolsSelected = "selected";
		flowsSelected = "";
	}
	else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("flows") )
	{
		overviewSelected = "";
		protocolsSelected = "";
		flowsSelected = "selected";
	}	
	String subSystemSelected = "";
	for ( int i = 0 ; i < options.length; i++ )
	{
		JSONObject subsystemCombo = new JSONObject();
		if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase( options[ i ] ) )
		{
			subSystemSelected = "selected";
		}
		else
		{
			subSystemSelected = "";
		}

		if ( options[i].equals("overview") )
		{
			dispVal = "Overview";
		}
		else if ( options[i].equals("protocols") )
		{
			dispVal = "Protocols";
		}
		else if ( options[i].equals("flows") )
		{
			dispVal = "Flows";
		}
		//selectedValues.put("subsystemSelected", ciscoSelectedType);
		subsystemCombo.put("displayField",mappingInfo.getTextDescription("monitor.dashboard."+dispVal));
		subsystemCombo.put("valueField",options[i]);
		subSystemArr.add(subsystemCombo);
	}

	Hashtable alaramCount=new Hashtable();
	Hashtable alaramDetails=new Hashtable();
	alaramCount=model.getAlarmCount(compName,compType,"Custom");
	model.setAllAlarmDetails();
	session.setAttribute("DashboardModelObject",model);
	alaramDetails=model.getAlarmDetails();

	int openProblems=0;
	Integer critical = (Integer) alaramCount.get("HIGH");
	Integer major = (Integer) alaramCount.get("INTERMEDIATE");
	Integer minor = (Integer) alaramCount.get("LOW");

	JSONObject overviewObj = new JSONObject();
	overviewObj.put("alertTitle", mappingInfo.getTextDescription("monitor.dashboard.Alerts"));

	if(alaramCount != null && alaramCount.size() > 0 && (critical.intValue()+major.intValue()+minor.intValue()>0))
	{
		JSONObject alertObj = new JSONObject();
		String criticalDesc=(String)alaramDetails.get("HIGH");
		String majorDesc=(String)alaramDetails.get("INTERMEDIATE");
		String minorDesc=(String)alaramDetails.get("LOW");
		openProblems=critical.intValue()+major.intValue()+minor.intValue();			

		alertObj.put("OPEN_ALERT_TITLE", mappingInfo.getTextDescription("monitor.dashboard.Open Alerts"));
		alertObj.put("OPEN_ALERTS", openProblems);
		alertObj.put("DISTRIBUTION_TITLE", mappingInfo.getTextDescription("monitor.dashboard.Distribution"));
		if(critical!=null && critical.intValue()>0)
		{
			alertObj.put("DISTRIBUTION_CRITICAL_VALUE", String.valueOf(critical.intValue()));
			alertObj.put("DISTRIBUTION_CRITICAL_DESC", criticalDesc);
			JSONObject linkObj = new JSONObject();
			linkObj.put("METHOD_NAME", "showAlert");
			linkObj.put("PARAMS", "event|"+criticalDesc+"|"+critical.intValue()+"HIGH");
			alertObj.put("DISTRIBUTION_CRITICAL_LINK", linkObj);
		}
		else
		{
			alertObj.put("DISTRIBUTION_CRITICAL_VALUE", String.valueOf(critical.intValue()));
		}
		if(major!=null && major.intValue()>0)
		{
			alertObj.put("DISTRIBUTION_MAJOR_VALUE", String.valueOf(major.intValue()));
			alertObj.put("DISTRIBUTION_MAJOR_DESC", majorDesc);
			JSONObject linkObj = new JSONObject();
			linkObj.put("METHOD_NAME", "showAlert");
			linkObj.put("PARAMS", "event|"+majorDesc+"|"+major.intValue()+"INTERMEDIATE");
			alertObj.put("DISTRIBUTION_MAJOR_LINK", linkObj);
		}
		else
		{
			alertObj.put("DISTRIBUTION_MAJOR_VALUE", String.valueOf(major.intValue()));
		}
		if(minor!=null && minor.intValue()>0)
		{
			alertObj.put("DISTRIBUTION_MINOR_VALUE", String.valueOf(minor.intValue()));
			alertObj.put("DISTRIBUTION_MINOR_DESC", minorDesc);
			JSONObject linkObj = new JSONObject();
			linkObj.put("METHOD_NAME", "showAlert");
			linkObj.put("PARAMS", "event|"+minorDesc+"|"+minor.intValue()+"LOW");
			alertObj.put("DISTRIBUTION_MINOR_LINK", linkObj);
		}
		else
		{
			alertObj.put("DISTRIBUTION_MINOR_VALUE", String.valueOf(minor.intValue()));
		}
		overviewObj.put("ALERTS", alertObj);
	}
	else
	{
		overviewObj.put("ALERTS", "-");
		overviewObj.put("NO_ALERTS", mappingInfo.getTextDescription("monitor.dashboard.No alarms found")+"!");
	}
	String test="DeviceUptimeTest";
	boolean isRuningTest=false;

	boolean isExcludedTest = false;
	if(getExcludedTest != null && getExcludedTest.contains(test))
		isExcludedTest = true;
	if(enabledTests!=null && enabledTests.contains(test) && !isExcludedTest)
	{	
		String msmtHost= (String)allMsmtHosts.get(test);
		String measure_name="Total_uptime";
		String in_info="+";
		String currentValue=dashboardDAO.getCurrentMeasure(hostName,portNo,in_info,test,measure_name,msmtHost);
		
		if(runingTestList.size()>0)
			isRuningTest= runingTestList.contains(test);		

		if(isRuningTest && currentValue!=null && !currentValue.equals(""))
		{
			String dateDiff="";
			long minites=0;
			int secounds=0;
			if(currentValue!=null && currentValue.indexOf(".")>0)
			{
				minites=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
				if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
					secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1,currentValue.indexOf(".")+3));
				else
					secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1));

			}
			else
			{
				minites=Long.parseLong(currentValue);
			}

			long valueInSecound=(minites*60)+secounds;
			dateDiff=model.getDateDifferenceString(valueInSecound);
			if(dateDiff==null || dateDiff.trim().equals(""))
				dateDiff="-";

			overviewObj.put("UPTIME_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Device Uptime"));
			overviewObj.put("UPTIME",dateDiff);
		}
		else
		{

		}
	}


	String overviewDialGraphs=iniobj.getValue(compType,"Network_Overview_DialGraphs");
	
	//-------------------------------for jvm chart------------------------------------------------------------------
	Vector dialGraphtests=model.getTokensAsVector(overviewDialGraphs,",");
	double defaultDialGraphWidth=200;  // default dial graph width for calculation
	double defaultDialGraphHeight=125;  // default dial graph height for calculation
	double dialGraphWidth=240;  
	double dialGraphHeight=125;
	double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
	double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
	double defaultGauageOuterRadius=69; // default dial graph width for calculation
	double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
	double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
	String gauageOuterRadius="50";
	String gaugeXPos="90";
	String gaugeYPos="93";
	dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
	dialGraphWidth=MathUtils.round(dialGraphWidth,0);
	dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
	dialGraphHeight=MathUtils.round(dialGraphHeight,0);
	double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
	double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
	gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
	double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
	double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
	double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
	gaugeXPos=erutils.round(gaugeXPosInDouble,0);
	double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
	gaugeYPos=erutils.round(gaugeYPosInDouble,0);
	double defaultLedGraphWidth=140;  // default led graph width for calculation
	double defaultLedGraphHeight=85;  // default led graph height for calculation
	double ledGraphWidth=140;  
	double ledGraphHeight=95;
	double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
	double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
	double defaultLedGap=1; // default led graph gap for calculation
	double defaultLedSize=1; // default led graph size for calculation
	String ledGap="1";
	String ledSize="1";
	ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
	ledGraphWidth=MathUtils.round(ledGraphWidth,0);
	ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
	ledGraphHeight=MathUtils.round(ledGraphHeight,0);
	double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
	double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
	ledGap=erutils.round(ledGapInDouble,0);
	double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
	double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
	ledSize=erutils.round(ledSizeInDouble,0);
	double defaultChartLeftMargin=42;
	double defaultChartRightMargin=25;
	String chartLeftMargin="42";
	String chartRightMargin="25";
	double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
	double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
	chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
	double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
	double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
	chartRightMargin=erutils.round(ledRightMarginInDouble,0);
	double pieChartDivHeight = dialGraphHeight+30;
	//-------------------------------for jvm chart------------------------------------------------------------------	
	dialChartValues.put("pieChartDivHeight",pieChartDivHeight);

	int dialChartNoMeasuresCount=0;
	String iniEntries = iniobj.getValue(compType,"Cisco_dial");
	JSONArray ciscoArray =new JSONArray();
	boolean isAnyTestExcludedOrDisabledForDial = false;
	if(iniEntries != null && iniEntries.length() > 0)
	{
		String isDialNeeded=iniobj.getValue("Dashboard_Settings","UseDial");
		String isThresholdNeed=iniobj.getValue("Dashboard_Settings","ApplyThreshold");

		StringTokenizer st=new StringTokenizer(iniEntries,",");
		int dialChartCount=0;
		int i=0;
		ArrayList dialmeasuresNAList = new ArrayList();
		while(st.hasMoreTokens())
		{
			JSONObject ciscoObj=new JSONObject();
			String testWithMeasure=st.nextToken();
			String d_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String d_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			if(enabledTests!=null && !enabledTests.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			if(getExcludedTest != null && getExcludedTest.contains(d_test)) {
				isAnyTestExcludedOrDisabledForDial = true;
				continue;
			}
			String msmtHost=(String)allMsmtHosts.get(d_test);
			String measureValue="";
			String measureForDB=dbInfo.getColumnForMeasure(d_test,d_measure);

			String dial_measureMapping=iniobj.getValue("Dashboard_Dial_mapping",testWithMeasure);

			if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
				dial_measureMapping=mappingInfo.getMeasureDescription(d_test,d_measure);

			String tooltip=dial_measureMapping;

			String unit=tablesInfo.getUnitForMeasure(d_test,d_measure);
			if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
				continue;
			if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
				unit="%";
			long stime=System.currentTimeMillis();
			Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,d_test,tab);
			long ltime=System.currentTimeMillis();
			String key=compName+":"+portNo+":"+d_test+":"+msmtHost;
			String oneMsmtTime=dashboardDAO.getMeasureLastMsmtTime(key);
			
			if(msmtHost==null)
				msmtHost="";


			boolean isFullView=false;
			Vector infos=(Vector)allTestInfos.get(d_test);
			Vector infosForCutOffFactor = new Vector();
			if(model.isTestHasCutOffFactor(d_test))
			{
				if(infos!=null && !infos.isEmpty())
				{
					for(int d=0;d<infos.size();d++)
					{
						String infoForDial=(String)infos.get(d);
						boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,d_test,msmtHost,infoForDial);
						if(!isTestExceededCutOffFactor)
						{
							if(infosForCutOffFactor!=null && !infosForCutOffFactor.contains(infoForDial))
							{
								infosForCutOffFactor.add(infoForDial);
							}
						}
					}
				}
				if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
				{
					infos=infosForCutOffFactor;
				}
			}
			if(infos!=null && !infos.isEmpty() && infos.size()>1)
			{
				isFullView=true;
			}
			String info=fusionChart.getInfoForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

			if(info!=null && info.indexOf("+")!=-1)
				info=info.substring(info.indexOf("+")+1);
			info=StringUtils.replace(info, "+", "|plus|");

			Vector dialChartAttributes=new Vector();
			dialChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
			dialChartAttributes.add("fillAngle='60'");
			dialChartAttributes.add("majorTMNumber='6'");
			dialChartAttributes.add("majorTMHeight='8'");
			dialChartAttributes.add("majorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMColor='e5e5e5'");
			dialChartAttributes.add("minorTMHeight='4'");
			dialChartAttributes.add("minorTMNumber='6'");
			dialChartAttributes.add("majorTMThickness='1'");
			dialChartAttributes.add("markerRadius='30'");
			dialChartAttributes.add("showGaugeBorder='0'");
			dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
			dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
			dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
			dialChartAttributes.add("gaugeInnerRadius='0'");
			dialChartAttributes.add("formatNumberScale='0'");
			dialChartAttributes.add("displayValueDistance='0'");
			dialChartAttributes.add("decimalPrecision='2'");
			dialChartAttributes.add("tickMarkDecimalPrecision='2'");
			dialChartAttributes.add("tickValueDistance='14'");
			dialChartAttributes.add("pivotRadius='6'");
			dialChartAttributes.add("showPivotBorder='1'");
			dialChartAttributes.add("pivotBorderColor='000000'");
			dialChartAttributes.add("pivotBorderThickness='5'");
			dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
			dialChartAttributes.add("paletteThemeColor='ffffff'");
			dialChartAttributes.add("pivotFillType='linear'");
			dialChartAttributes.add("showToolTip='1'");
			dialChartAttributes.add("chartLeftMargin='0'");
			dialChartAttributes.add("chartRightMargin='0'");
			dialChartAttributes.add("chartBottomMargin='0'");
			//dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("baseFontColor='000000'");
			dialChartAttributes.add("adjustTM='0'");
			dialChartAttributes.add("chartTopMargin='0'");
			dialChartAttributes.add("borderAlpha='0'");
			dialChartAttributes.add("bgAlpha='_alpha'");

			dialChartAttributes.add("showToolTipShadow='1'");
			dialChartAttributes.add("toolTipBgColor='ffffff'");
			dialChartAttributes.add("toolTipBorderColor='555555'");
			dialChartAttributes.add("exportEnabled='0'");
			dialChartAttributes.add("exportAction='download'");
			dialChartAttributes.add("exportAtClient='0'");
			dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
			
			String layerName=dashboardDAO.getLayerForTest(compType,d_test,d_measure);

			String compTypeForAlarm=compType;
			if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
				compTypeForAlarm="Host_system";

			String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,d_test+"-"+info,d_measure);

			String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=cisco_Dashboard&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+d_test+"-"+info+"&tstate="+measureState+"&msmt_host=&backNav=cmpDashboard";

			String dialXMLData="";
			if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
			{
				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight,layerPageUrl);
			}
			else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
			{
				Vector jvmChartAttributes=new Vector();
				jvmChartAttributes.add("clickURL='javascript:wayToLayerModel(&apos;dialUrl"+dialChartCount+"&apos;)'");
				jvmChartAttributes.add("upperLimit='100'");
				jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
				jvmChartAttributes.add("bgAlpha='0,0'");
				jvmChartAttributes.add("showBorder='0'");
				jvmChartAttributes.add("adjustTM='0'");
				jvmChartAttributes.add("lowerLimit='0'");
				jvmChartAttributes.add("decimals='2'");
				jvmChartAttributes.add("showValue='0'");
				jvmChartAttributes.add("majorTMNumber='5'");
				//jvmChartAttributes.add("baseFontSize='8'");
				jvmChartAttributes.add("majorTMColor='000000'");
				jvmChartAttributes.add("majorTMHeight='5'");
				jvmChartAttributes.add("minorTMNumber='2'");
				jvmChartAttributes.add("minorTMColor='000000'");
				jvmChartAttributes.add("minorTMHeight='2'");
				jvmChartAttributes.add("majorTMThickness='1'");
				jvmChartAttributes.add("decimalPrecision='0'");
				jvmChartAttributes.add("ledGap='"+ledGap+"'");
				jvmChartAttributes.add("ledSize='"+ledSize+"'");
				jvmChartAttributes.add("tickValueDistance='2'");
				jvmChartAttributes.add("tickMarkDistance='1'");
				jvmChartAttributes.add("tickValueStep='1'");
				jvmChartAttributes.add("tickValueDecimals='8'");
				jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
				jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
				jvmChartAttributes.add("chartTopMargin='21'");
				jvmChartAttributes.add("chartBottomMargin='20'");
				jvmChartAttributes.add("baseFontSize ='9'");
				jvmChartAttributes.add("showToolTip='1'");
				jvmChartAttributes.add("baseFontColor  ='000000'");
				jvmChartAttributes.add("annRenderDelay='1.7'");
				jvmChartAttributes.add("exportEnabled='0'");
				jvmChartAttributes.add("exportAction='download'");
				jvmChartAttributes.add("exportAtClient='0'");
				jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

				dialXMLData=graphUtil.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight,layerPageUrl);
			}
			if(dialXMLData !=null && !dialXMLData.equals(""))
			{
				String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+d_test+"&measure="+d_measure+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&tab="+tab;

				ciscoObj.put("tooltip",tooltip);
				ciscoObj.put("unit",unit);
				ciscoObj.put("dial_measureMapping",dial_measureMapping);
				if(isFullView)
				{
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
				}
				if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphWidth",dialGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					//ciscoObj.put("layerPageUrl",layerPageUrl);
					ciscoObj.put("moreDescriptorUrl",moreDescriptorUrl);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/AngularGauge.swf");
				}
				else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
				{
					ciscoObj.put("dialXMLData",dialXMLData);
					ciscoObj.put("dialGraphHeight",ledGraphHeight);
					ciscoObj.put("dialGraphWidth",ledGraphWidth);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("dialGraphHeight",dialGraphHeight);
					ciscoObj.put("FusionChartsURL","/final/FusionCharts/swf/VLED.swf");
				}
				hiddens.put("dialUrl"+dialChartCount, layerPageUrl);
				dialChartCount++;
				ciscoArray.add(ciscoObj);
			}
			/*else
			{	
				ciscoObj.put("tooltip",tooltip);
				ciscoObj.put("unit",unit);
				ciscoObj.put("dial_measureMapping",dial_measureMapping);
				ciscoObj.put("dialXMLData","-");
				ciscoObj.put("EmptyMsg",mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
				ciscoArray.add(ciscoObj);
				dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
			}*/
			i++;
			
		}
		dialChartValues.put("dialChartValues",ciscoArray);
		for (int na=1;na < dialmeasuresNAList.size()+1;na++)
		{
			if(dialmeasuresNAList.size()==i)
			{
				String NAlistdata = (String)dialmeasuresNAList.get(na-1);
				String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
				String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
				String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
				int temCount=(++dialChartCount)%5;
				dialChartCount--;

				rootJson.put("DIAL_TITLE",mappingInfo.getTextDescription("monitor.dashboard.Dial Graph"));
				rootJson.put("NoMeasure",mappingInfo.getTextDescription("monitor.dashboard.No measures available!"));
				dialChartNoMeasuresCount++;
					int tempCount=(++dialChartCount)%5;
					dialChartCount--;
					break;
				}
			}
		}
		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		String interfaceEntries = iniobj.getValue(compType,"Cisco_Interface");
		boolean isTestEnabledOrIncluded = false;
		if(interfaceEntries!=null && interfaceEntries.length() > 0)
		{
			StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
			StringBuffer infosToAreaChart=new StringBuffer();
			Map mapData=new HashMap();
			ArrayList units=new ArrayList();
			units.add("-");
			String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
			StringBuffer measureColumn=new StringBuffer();
			String fullviewTest="";
			String fullviewMsmtHost="";
			String interfaceCount_fullview="";

			int imgcnt=0;
			int stColPos=1;
			int endColPos=5;
			//String header[]={"Interface","Availability","Data Received Rate","Data transmit Rate","BandWidth Used"};
			List headers=new ArrayList();
			headers.add("Interface");
			while(stoken.hasMoreTokens())
			{
				String testMeasure=stoken.nextToken();
				String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
				String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
				String measureForDB=dbInfo.getColumnForMeasure(interface_test,interface_measure);
				String msmthost=(String)allMsmtHosts.get(interface_test);
				String excludedInfos=iniobj.getValue("INFOS_TO_BE_OMITTED",testMeasure);
				String interfaces_Count=iniobj.getValue("Interfaces","MaxInterfaces");
				String iniheader=iniobj.getValue(compType,testMeasure);
				headers.add(iniheader);
				fullviewTest=interface_test;
				fullviewMsmtHost=msmthost;
				interfaceCount_fullview=interfaces_Count;
				measureColumn.append(measureForDB);
				if(stoken.hasMoreTokens())
					measureColumn.append(",");
				//newly added
				
				StringTokenizer infos=new StringTokenizer(excludedInfos,",");
				Vector excluded_infos=new Vector();
				
				if(enabledTests!=null && !enabledTests.contains(interface_test))
					continue;
				if(getExcludedTest != null && getExcludedTest.contains(interface_test))
					continue;
				isTestEnabledOrIncluded = true;
				while(infos.hasMoreTokens())
				{
						excluded_infos.add("+"+infos.nextToken());
				}
				Vector filtered_infos=new Vector();
				Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,interfaces_Count);//newly added

				String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
				String defaultInfo="";
				String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
				
				units.add(unit);

				if(currentValues!=null && currentValues.size()>0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String interfaceInfo=(String)currentValues.get(i);
						String value=(String)currentValues.get(i+1);
						if(!excluded_infos.contains(interfaceInfo))
						{
								filtered_infos.add(interfaceInfo);
								filtered_infos.add(value);
						}
					}
				}
				if(filtered_infos!=null && filtered_infos.size()>0)
				{
					for(int i=0;i<filtered_infos.size();i=i+2)
					{
						String interfaceInfo=(String)filtered_infos.get(i);
						String value=(String)filtered_infos.get(i+1);
						if(mapData!=null && mapData.containsKey(interfaceInfo))
						{
							ArrayList existingList=(ArrayList)mapData.get(interfaceInfo);
							existingList.add(value);
							mapData.put(interfaceInfo,existingList);
						}
						else
						{
							ArrayList valueList=new ArrayList();
							valueList.add(value);
							mapData.put(interfaceInfo,valueList);
						}
					}
				}
			}

			//List headerList=Arrays.asList(header);
			comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn.toString()+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=true&headerList="+headers+"&inilookup=Cisco_Interface";

			String Interfaces = mappingInfo.getTextDescription("monitor.title.Top Interfaces");
			GridValues.put("MAIN_TITLE",Interfaces);
			GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			if(adminPermission==true)
			{
				GridValues.put("comparisonTableFullViewURL",comparisonTableFullViewURL);
			}		
			JSONObject gridColumns=new JSONObject();
			if(mapData!=null && !mapData.isEmpty())
			{			
				endColPos=headers.size();
				for(int j=0;j<headers.size();j++)
				{
					String h_unit=(String)units.get(j);
					if(h_unit.equals("-"))
						h_unit="";
					if(j==0)
					{
						gridColumns.put("COLUMNam_"+j,(String)headers.get(j));
					}
					else
					{
						gridColumns.put("COLUMNam_"+j,(String)headers.get(j)+"  ("+h_unit+")");
					}
					imgcnt++;
				}
				Iterator itr=mapData.keySet().iterator();
				endColPos=5;

				int k=0;
				JSONArray  stateJson=new JSONArray();
				while(itr.hasNext())
				{
					String info=(String)itr.next();
					infosToAreaChart.append(info);
					if(itr.hasNext())
						infosToAreaChart.append(",");
					String text = mappingInfo.getTextDescription(StringUtils.replace(info, "+", ""));
					text = text.substring(0, text.length() - 1);

					ArrayList values=(ArrayList)mapData.get(info);
					JSONObject jsonObj=new JSONObject();
					if(values!=null && values.size()>0)
					{
						jsonObj.put("COLUMN_0",text);
						for(int i=0;i<values.size();i++)
						{
							String val=(String)values.get(i);
							if(val.startsWith("-"))
								val="-";
							if(i==0)
							{
								String measVal = dbInfo.formatValue(val);
								String img="";
								if(measVal.equals("100"))
								{
									img = "iconRight";
								}
								else
								{
									img="iconWrong";
								}
								jsonObj.put("COLUMN_"+(i+1),img);
								}
							else
							{
								jsonObj.put("COLUMN_"+(i+1),val);
							}
						}
						stateJson.add(jsonObj);	
					}				
					k++;
				}
				GridValues.put("STATE_VALUES",stateJson);			
			}
			else
			{
				gridColumns.put("Interface_NOMes",mappingInfo.getTextDescription("monitor.common.No measures available!"));
			}
			GridValues.put("COLUMN_VALUES",gridColumns);

			String passingInfo=infosToAreaChart.toString();
			String url="/final/monitor/EgCiscoDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&mappingName=abc&blockType=areaChart&infosToArea="+infosToAreaChart;
			String areaChartURL = "/final/monitor/EgCiscoDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=areaChart&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType;

			String protocolsURL = "/final/monitor/EgCiscoDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Protocols&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType;

			String flowsURL = "/final/monitor/EgCiscoDashHelperJSON.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=Flows&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType;

			String[] dateChoice={"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks"};
			List datelist=Arrays.asList(dateChoice);
			JSONArray timelineJson=new JSONArray();
			for(int i=0;i<datelist.size();i++)
			{
				JSONObject tmJson=new JSONObject();
				String element=(String)datelist.get(i);
				String selected="";
				if(element.equals("1 hour"))
					selected="selected";
				tmJson.put("displayField",element);
				tmJson.put("valueField",element);
				timelineJson.add(tmJson);		
			}
			String selectedTimeline=request.getParameter("selectedTimeline");
			if(StringUtils.isNull(selectedTimeline))
				selectedTimeline="1 hour";
			GridValues.put("TIMELINE_VALUES",timelineJson);
			GridValues.put("selectedTimeline",selectedTimeline);
			rootJson.put("GRID_DATA",GridValues);
			rootJson.put("AREACHART_URL",areaChartURL);
			rootJson.put("protocolsURL",protocolsURL);
			rootJson.put("flowsURL",flowsURL);
			
			JSONObject interfaceObj = new JSONObject();
			JSONArray ineterfaceArr = new JSONArray();
			String TITLE = mappingInfo.getTextDescription("Top interfaces by portion of current traffic");
			TITLE = TITLE.substring(0,TITLE.indexOf("#"));
			interfaceObj.put("currenTraffic",TITLE);		
			
			String iniVal=(String)iniobj.getValue(compType,"Cisco_Protocol_piechart");
			if(iniVal!=null )
			{
				double defaultPieGraphWidth=450;  // default dial graph width for calculation
				double defaultPieGraphHeight=350;  // default dial graph height for calculation
				double pieGraphWidth=450;  
				double pieGraphHeight=350;

				double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
				double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;

				pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
				pieGraphWidth=MathUtils.round(pieGraphWidth,0);
				StringTokenizer sto=new StringTokenizer(iniVal,",");
				while(sto.hasMoreTokens())
				{
					String testWithMeasure=sto.nextToken();
					String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));

					String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
					String msmthost=(String)allMsmtHosts.get(s_test);
					
					isExcludedTest = false;
					if(getExcludedTest != null && getExcludedTest.contains(s_test))
						isExcludedTest = true;

					if(enabledTests!=null && enabledTests.contains(s_test) && !isExcludedTest)
					{

						Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,s_measure,msmthost,"",true,"");
						
						Map valuesMap=new HashMap();

						if(currentValues!=null && currentValues.size()>0)
						{
							for(int i=0;i<currentValues.size();i=i+2)
							{
								String infoWithProtocol=(String)currentValues.get(i);
								String info=infoWithProtocol.substring(0,infoWithProtocol.indexOf(":"));
								String protocol=infoWithProtocol.substring(infoWithProtocol.indexOf(":")+1);
								String value=(String)currentValues.get(i+1);
								if(valuesMap!=null && valuesMap.containsKey(info))
								{
									List existingList=(ArrayList)valuesMap.get(info);
									existingList.add(protocol);
									existingList.add(value);
									valuesMap.put(info,existingList);
								}
								else
								{
									List valueList=new ArrayList();
									valueList.add(protocol);
									valueList.add(value);
									valuesMap.put(info,valueList);
									
								}
							}
						}
						int tableSize=0;
						tableSize=valuesMap.size();
						String align=(tableSize==1)?"center":"center";
						String width=(tableSize==1)?"700":"350";
						String pieRadious=(tableSize==1)?"68":"42";

						if(valuesMap!=null && !valuesMap.isEmpty())
						{
							interfaceObj.put("AREACHART","true");
							Iterator itr=valuesMap.keySet().iterator();
							int count=0;
							while(itr.hasNext())
							{
								if(count > 3 )
									break;
								String key=(String)itr.next();
								Vector chartAttributes=new Vector();
								//caption="Sales Per Employee for year 1996" palette="2" animation="1" formatNumberScale="0" numberPrefix="$" pieSliceDepth="30" startingAngle="125"
								//chartAttributes.add("caption='"+key+"'");
								chartAttributes.add("decimals='2'");
								chartAttributes.add("enableRotation='1'");
								chartAttributes.add("bgColor='99CCFF,FFFFFF'");
								chartAttributes.add("bgAlpha='0,0'");
								//chartAttributes.add("bgRatio='0,100'");
								chartAttributes.add("bgAngle='360'");
								chartAttributes.add("showBorder='0'");
								chartAttributes.add("startingAngle='80'");
								//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
								chartAttributes.add("chartLeftMargin ='0'");
								chartAttributes.add("chartTopMargin ='0'");
								chartAttributes.add("chartBottomMargin ='0'");
								chartAttributes.add("chartRightMargin ='0'");
								chartAttributes.add("showToolTipShadow ='1'");
								chartAttributes.add("pieSliceDepth='7'");
								chartAttributes.add("numberSuffix='%'");
								chartAttributes.add("showToolTipShadow ='1'");
								chartAttributes.add("pieOuterFaceAlpha  ='75'");
								chartAttributes.add("pieInnerFaceAlpha  ='100'");
								chartAttributes.add("pieYScale  ='65'");
								chartAttributes.add("smartLineColor  ='000000'");
								chartAttributes.add("smartLabelClearance  ='2'");
								chartAttributes.add("captionPadding  ='0'");
								chartAttributes.add("bgSWFAlpha  ='0'");
								chartAttributes.add("enableSmartLabels='1'");
								chartAttributes.add("pieRadius='"+pieRadious+"'");
								chartAttributes.add("labelDistance='6'");
								chartAttributes.add("isSmartLineSlanted='1'");
								chartAttributes.add("exportEnabled='0'");
								chartAttributes.add("exportAction='download'");
								chartAttributes.add("exportAtClient='0'");
								chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

								String xml=(String)graphUtil.getXMLtoProtocol(key,valuesMap,chartAttributes,"");
								if(xml!=null && !xml.equals(""))
								{
									interfaceObj.put("COLUMN_0",StringUtils.replace(key, "+", ""));
									interfaceObj.put("pieGraphWidth",pieGraphWidth);
									interfaceObj.put("SWF_PATH","/final/FusionCharts/swf/Pie3D.swf");
									interfaceObj.put("XML_DATA",xml);
									interfaceObj.put("render","Pie3DContainer");
									interfaceObj.put("XML_FLAG","true");
								}
								else
								{
									interfaceObj.put("XML_FLAG","false");
									interfaceObj.put("COLUMN_0",StringUtils.replace(key, "+", ""));
									interfaceObj.put("NOMSG",mappingInfo.getTextDescription("monitor.common.No measures available!"));
								}
								count++;
								ineterfaceArr.add(interfaceObj);
							}
						}
						else
						{
							interfaceObj.put("AREACHART","false");
							interfaceObj.put("NOMSG",mappingInfo.getTextDescription("monitor.common.No measures available!"));
							ineterfaceArr.add(interfaceObj);
						}
					}
					else
					{
						rootJson.put("NOtestMSG",mappingInfo.getTextDescription("monitor.common.Test has been excluded or disabled"));											
					}
				}
			}			
			rootJson.put("ineterfaceArr",ineterfaceArr);
		}
	
		String requestData = ErUtils.prepareQueryString(request.getParameterMap());		
		if(requestData!=null)
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+requestData+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		else
		{
			if(session!=null)
			{
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType=overview");
				session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
			}
		}
		rootJson.put("hiddens", hiddens);
		rootJson.put("subSystemArr",subSystemArr);
		rootJson.put("OVERVIEW", overviewObj);	
		rootJson.put("subsystemSelected",ciscoSelectedType);
		rootJson.put("FUSION-CHART",dialChartValues);	
		if(isAnyTestExcludedOrDisabledForDial){
			rootJson.put("DIAL_MSG", mappingInfo.getTextDescription("monitor.dashboard.The test has been excluded or disabled")+"!");
		}
		rootJson.put("NET_TAB_NoGraphTitle", mappingInfo.getTextDescription("monitor.dashboard.Availability/Network Traffic"));

		out.println(rootJson.toString());
		System.out.println("rootJson cisco----->"+rootJson);
	}
	catch(Exception e)
	{
		e.printStackTrace();
	}

%>