<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ taglib uri="../WEB-INF/eg-taglib.tld" prefix="egui" %>

<%@ page import="com.egurkha.monitor.EgServerDashboardModel" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>
<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.eg.EgTablesInfo"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>

<%
try
{
	String compType=request.getParameter("compType");
	String compName=request.getParameter("hostName");
	String tab=request.getParameter("tab");
	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	String blockType = request.getParameter("blockType");
	String ciscoSelectedType = request.getParameter("ciscoSelectedType");
	ciscoSelectedType = ( ciscoSelectedType != null && !ciscoSelectedType.equalsIgnoreCase("overview") )?ciscoSelectedType:"";
	String options[] = {"overview", "protocols", "flows"}, dispVal = "";
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String hostName="";
	String portNo="";
	String sid="";
	String site="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgServerDashboardModel model=new EgServerDashboardModel();
	
	MonitorDAOFactory monitorfactory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=monitorfactory.getServerDashBoardDAO();
	ErUtils  erutils=new  ErUtils();

	EgDbInfo dbInfo=new EgDbInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgMappingInfo mappingInfo=new EgMappingInfo(trackerLanguage);
	
	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);
	Vector runingTestList=model.getRunningTest(compName,compType,tab);

%>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<img src="/final/monitor/eg_images/spacer.gif" border="0" style="display:none" onload="javascript:loadCiscoInterfaceDivs();loadCiscoSubsystems('<%=ciscoSelectedType%>');" />
<div class="mainDiv" id="mainDiv" style="display:block;">

	<div class="layer_headbg1" style="float:left;padding:0px;border:0px;width:100%;height:30px;position:relative">
		<div style="float:left;border:0px solid green;display:inline;position:relative;padding:6px 6px 0px 4px;width:25%">
			<div style="float:left;border:0px solid red;display:inline;position:relative">
				<div style="float:left;padding:2px 10px 2px 4px" class="eg_75bold"><egui:intnl text="Subsystem" />&nbsp;:</div>
				<div style="float:left">
						<select onChange="javascript:loadCiscoSubsystems(this.value);" style="width:120px">
<%
		String overviewSelected = "", protocolsSelected = "", flowsSelected = "" ;
		if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("overview") )
		{
			overviewSelected = "selected";
			protocolsSelected = "";
			flowsSelected = "";
		}
		else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("protocols") )
		{
			overviewSelected = "";
			protocolsSelected = "selected";
			flowsSelected = "";
		}
		else if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase("flows") )
		{
			overviewSelected = "";
			protocolsSelected = "";
			flowsSelected = "selected";
		}
		String subSystemSelected = "";
		for ( int i = 0 ; i < options.length; i++ )
		{
			if ( ciscoSelectedType != null && ciscoSelectedType.equalsIgnoreCase( options[ i ] ) )
			{
				subSystemSelected = "selected";
			}
			else
			{
				subSystemSelected = "";
			}

			if ( options[i].equals("overview") )
			{
				dispVal = "Overview";
			}
			else if ( options[i].equals("protocols") )
			{
				dispVal = "Protocols";
			}
			else if ( options[i].equals("flows") )
			{
				dispVal = "Flows";
			}
%>
							<option value="<%=options[i]%>" <%=subSystemSelected%>><egui:intnl text="<%=dispVal%>" /></option>
<%
		}


%>
						</select>
				</div>
				<!-- <ul id="listTabMenu" style="padding:0px;margin:0px">
					<li id="overview" class="current"> <a href="javascript:void(0);" onclick="javascript:loadCiscoOverview();"> </a></li>
					<li id="protocols" ><a href="javascript:void(0);" onclick="javascript:loadCiscoProtocols();"></a></li>
					<li id="flows" > <a href="javascript:void(0);" onclick="javascript:loadCiscoFlows();"></a></li>
				</ul> -->
			</div>
		</div>

<%
		Hashtable alaramCount=new Hashtable();
		Hashtable alaramDetails=new Hashtable();
		alaramCount=model.getAlarmCount(compName,compType,"Custom");
		model.setAllAlarmDetails();
		session.setAttribute("DashboardModelObject",model);
		alaramDetails=model.getAlarmDetails();

		int openProblems=0;
		Integer critical = (Integer) alaramCount.get("HIGH");
		Integer major = (Integer) alaramCount.get("INTERMEDIATE");
		Integer minor = (Integer) alaramCount.get("LOW");

		if(alaramCount != null && alaramCount.size() > 0 && (critical.intValue()+major.intValue()+minor.intValue()>0))
		{
			String criticalDesc=(String)alaramDetails.get("HIGH");
			String majorDesc=(String)alaramDetails.get("INTERMEDIATE");
			String minorDesc=(String)alaramDetails.get("LOW");
			openProblems=critical.intValue()+major.intValue()+minor.intValue();
%>
		<div style="float:left;border:0px solid red;padding:6px 4px 4px 10px;width:40%">
			<table border="0"  cellpadding="0" cellspacing="0" valign="top" align="center">
				<tr>
					<td class="eg_75bold" align="left" ><egui:intnl text="monitor.dashboard.Alerts:"/></td>
					<td style="padding-left:4px" >
						<table border="0" cellpadding="0" cellspacing="0" >
							<tr>
								<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
								<td background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" ><egui:intnl text="monitor.dashboard.Open Alerts"/>&nbsp;</td>
								<td class="whiteColor eg_75bold" width="30" background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdark.png" align="center" valign="middle" >  <%=openProblems%> </td>
								<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bgdarkright.png" width="5" height="20"></td>
							</tr>
						</table>
					</td>
					<td>&nbsp;</td>
					<td>
						<table border="0" cellpadding="0" cellspacing="0" >
							<tr>
								<td width="5"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_left.png" width="5" height="20"></td>
								<td background="/final/monitor/eg_images/<%=monitor_Skin%>/data_bar_bg.png" ><egui:intnl text="monitor.dashboard.Distribution"/>&nbsp;</td>
	<%
				if(critical!=null && critical.intValue()>0)
				{
%>
								<td width="40" valign="middle" align="center" id="HIGH_alarmsbg" class="whitefont lineright_light" style="cursor: pointer" onclick= "javascript:showAlert(event,'<%=criticalDesc%>','<%=critical.intValue()%>','HIGH')" > <%=critical.intValue()%> </td>
<%
				}
				else
				{
%>
								<td width="40" valign="middle" align="center" id="HIGH_alarmsbg" class="whitefont lineright_light"> <%=critical.intValue()%> </td>
<%
				}

				if(major!=null && major.intValue()>0)
				{
%>
								<td width="40" valign="center" align="center" id="INTERMEDIATE_alarmsbg" class="whitefont lineright_light" style="cursor: pointer"	onclick="javascript:showAlert(event,'<%=majorDesc%>','<%=major.intValue()%>','INTERMEDIATE')" > <%=major.intValue()%> </td>
<%
				}
				else
				{
%>
								<td width="40" valign="middle" align="center" id="INTERMEDIATE_alarmsbg" class="whitefont lineright_light"> <%=major.intValue()%></td>
<%
				}

				if(minor!=null && minor.intValue()>0)
				{
%>

								<td width="40" valign="center" align="center" id="LOW_alarmsbg" class="whitefont" style="cursor: pointer" onclick="javascript:showAlert(event,'<%=minorDesc%>','<%=minor.intValue()%>','LOW')" > <%=minor.intValue()%> </td>
<%
				}
				else
				{
%>
								<td width="40" valign="middle" align="center" id="LOW_alarmsbg" class="whitefont lineright_light"> <%=minor.intValue()%></td>
<%
				}
%>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
<%
		}
		else
		{
%>
		<div style="float:left;border:0px solid red;padding:6px 4px 4px 4px;width:40%">
			<table border="0"  cellpadding="0" cellspacing="0" valign="top" width="100%">
				<tr>
					<td align="center" valign="middle" >
						<table border="0" cellpadding="0" cellspacing="0">
							<tr>
								<td class="eg_75bold" align="left" ><egui:intnl text="monitor.dashboard.Alerts:"/></td>
								<td align="center" width="20%" valign="middle" class="egwhite_75bold"><img class="png" src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_exclamation.png" width="20" height="20"></td>
								<td class="eg_75bold" nowrap><egui:intnl text="monitor.dashboard.No alarms found"/>!</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
<%
		}
%>
				

		<div style="float:right;border:0px solid red;padding:8px 6px 4px 4px;width:30%" class="eg_75bold">
<%
		String test="DeviceUptimeTest";
		boolean isRuningTest=false;
		if(enabledTests!=null && enabledTests.contains(test))
		{
			
			String msmtHost= (String)allMsmtHosts.get(test);
			String measure_name="Total_uptime";
			String in_info="+";
			String currentValue=dashboardDAO.getCurrentMeasure(hostName,portNo,in_info,test,measure_name,msmtHost);
			if(runingTestList.size()>0)
				isRuningTest= runingTestList.contains(test);
			if(isRuningTest && currentValue!=null && !currentValue.equals(""))
			{
				String dateDiff="";
				long minites=0;
				int secounds=0;
				if(currentValue!=null && currentValue.indexOf(".")>0)
				{
					minites=Long.parseLong(currentValue.substring(0,currentValue.indexOf(".")));
					if(currentValue.substring(currentValue.indexOf(".")+1).length()>2)
						secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1,currentValue.indexOf(".")+3));
					else
						secounds=Integer.parseInt(currentValue.substring(currentValue.indexOf(".")+1));

				}
				else
				{
					minites=Long.parseLong(currentValue);
				}

				long valueInSecound=(minites*60)+secounds;
				dateDiff=model.getDateDifferenceString(valueInSecound);
				if(dateDiff==null || dateDiff.trim().equals(""))
					dateDiff="-";
			
%>
						<egui:intnl text="Device Uptime"/>&nbsp;:
						<%=dateDiff%>
<%
			}
			else
			{

			}
		}
%>
		</div>
	</div>

<%

		String overviewDialGraphs=iniobj.getValue(compType,"Network_Overview_DialGraphs");
	
		//-------------------------------for jvm chart------------------------------------------------------------------
			Vector dialGraphtests=model.getTokensAsVector(overviewDialGraphs,",");
			double defaultDialGraphWidth=200;  // default dial graph width for calculation
			double defaultDialGraphHeight=125;  // default dial graph height for calculation
			double dialGraphWidth=240;  
			double dialGraphHeight=125;
			double dialGraphWidthTo1024PxInPercent=defaultDialGraphWidth/1024;
			double dialGraphHeightToDefaultWidthInPercent=defaultDialGraphHeight/defaultDialGraphWidth;
			double defaultGauageOuterRadius=69; // default dial graph width for calculation
			double defaultGaugeXPos=90; // default dial graph Gauge X position for calculation
			double defaultGaugeYPos=93; // default dial graph Gauge Y position for calculation 
			String gauageOuterRadius="50";
			String gaugeXPos="90";
			String gaugeYPos="93";
				dialGraphWidth=screenWidthInDouble*dialGraphWidthTo1024PxInPercent;
				dialGraphWidth=MathUtils.round(dialGraphWidth,0);
				dialGraphHeight=dialGraphWidth*dialGraphHeightToDefaultWidthInPercent;
				dialGraphHeight=MathUtils.round(dialGraphHeight,0);
				double gauageOutRadiusToDefaultWidthInPercent=defaultGauageOuterRadius/defaultDialGraphWidth;
				double gauageOuterRadiusInDouble=dialGraphWidth*gauageOutRadiusToDefaultWidthInPercent;
				gauageOuterRadius=erutils.round(gauageOuterRadiusInDouble,0);
				double gauageXPosToDefaultWidthInPercent=defaultGaugeXPos/defaultDialGraphWidth;
				double gauageYPosToDefaultHeightInPercent=defaultGaugeYPos/defaultDialGraphHeight;
				double gaugeXPosInDouble=dialGraphWidth*gauageXPosToDefaultWidthInPercent;
				gaugeXPos=erutils.round(gaugeXPosInDouble,0);
				double gaugeYPosInDouble=dialGraphHeight*gauageYPosToDefaultHeightInPercent;
				gaugeYPos=erutils.round(gaugeYPosInDouble,0);
			double defaultLedGraphWidth=140;  // default led graph width for calculation
			double defaultLedGraphHeight=85;  // default led graph height for calculation
			double ledGraphWidth=140;  
			double ledGraphHeight=95;
			double ledGraphWidthTo1024PxInPercent=defaultLedGraphWidth/1024;
			double ledGraphHeightToDefaultWidthInPercent=defaultLedGraphHeight/defaultLedGraphWidth;
			double defaultLedGap=1; // default led graph gap for calculation
			double defaultLedSize=1; // default led graph size for calculation
			String ledGap="1";
			String ledSize="1";
			ledGraphWidth=screenWidthInDouble*ledGraphWidthTo1024PxInPercent;
			ledGraphWidth=MathUtils.round(ledGraphWidth,0);
			ledGraphHeight=dialGraphWidth*ledGraphHeightToDefaultWidthInPercent;
			ledGraphHeight=MathUtils.round(ledGraphHeight,0);
			double ledGapToDefaultWidthInPercent=defaultLedGap/defaultLedGraphWidth;
			double ledGapInDouble=ledGraphWidth*ledGapToDefaultWidthInPercent;
			ledGap=erutils.round(ledGapInDouble,0);
			double ledSizeToDefaultWidthInPercent=defaultLedSize/defaultLedGraphWidth;
			double ledSizeInDouble=ledGraphWidth*ledSizeToDefaultWidthInPercent;
			ledSize=erutils.round(ledSizeInDouble,0);
			double defaultChartLeftMargin=42;
			double defaultChartRightMargin=25;
			String chartLeftMargin="42";
			String chartRightMargin="25";
			double chartLeftMarginToDefaultWidthInPercent=defaultChartLeftMargin/defaultLedGraphWidth;
			double ledLeftMarginInDouble=ledGraphWidth*chartLeftMarginToDefaultWidthInPercent;
			chartLeftMargin=erutils.round(ledLeftMarginInDouble,0);
			double chartRightMarginToDefaultWidthInPercent=defaultChartRightMargin/defaultLedGraphWidth;
			double ledRightMarginInDouble=ledGraphWidth*chartRightMarginToDefaultWidthInPercent;
			chartRightMargin=erutils.round(ledRightMarginInDouble,0);
			double pieChartDivHeight = dialGraphHeight+30;
//-------------------------------for jvm chart------------------------------------------------------------------	


%>
	
	<div id="ciscoOverViewDiv" style="margin:0px;padding:0px 6px 6px 6px;visibility:visible:display:block;border:0px solid red" >
	
		<div class="listPa geHeader clr eg_blankspace" style="height:6px;width:100%">&nbsp;</div>
		<div class="ciscoPieChartDiv li  nesquare white_bg" style="width:100%;height:<%=pieChartDivHeight%>;overflow-x:auto;display:block;">
			<div id="dialDiv" style="visibility:visible;display-inline:block;border:0px solid red;">

<%
		int dialChartNoMeasuresCount=0;
		String iniEntries = iniobj.getValue(compType,"Cisco_dial");
		if(iniEntries != null && iniEntries.length() > 0)
		{
			String isDialNeeded=iniobj.getValue("Dashboard_Settings","UseDial");
			String isThresholdNeed=iniobj.getValue("Dashboard_Settings","ApplyThreshold");

			StringTokenizer st=new StringTokenizer(iniEntries,",");
			int dialChartCount=0;
			int i=0;
			ArrayList dialmeasuresNAList = new ArrayList();
			while(st.hasMoreTokens())
			{
				String testWithMeasure=st.nextToken();
				String d_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
				String d_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
				if(enabledTests!=null && !enabledTests.contains(d_test))
					continue;

				String msmtHost=(String)allMsmtHosts.get(d_test);
				String measureValue="";
				String measureForDB=dbInfo.getColumnForMeasure(d_test,d_measure);

				String dial_measureMapping=iniobj.getValue("Dashboard_Dial_mapping",testWithMeasure);

				if(dial_measureMapping==null || dial_measureMapping.trim().equals(""))
					dial_measureMapping=mappingInfo.getMeasureDescription(d_test,d_measure);

				String tooltip=dial_measureMapping;

				String unit=tablesInfo.getUnitForMeasure(d_test,d_measure);
				if((unit!=null) && !(unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage") || unit.equals("%")))
					continue;
				if((unit!=null) && (unit.equalsIgnoreCase("percent") || unit.equalsIgnoreCase("percentage")))
					unit="%";
				long stime=System.currentTimeMillis();
				Vector testInfos=dashboardDAO.getDescriptorsForTest(compName,compType,d_test,tab);
				long ltime=System.currentTimeMillis();
				String key=compName+":"+portNo+":"+d_test+":"+msmtHost;
				String oneMsmtTime=dashboardDAO.getMeasureLastMsmtTime(key);
				
				if(msmtHost==null)
					msmtHost="";


				boolean isFullView=false;
				Vector infos=(Vector)allTestInfos.get(d_test);
				Vector infosForCutOffFactor = new Vector();
				if(model.isTestHasCutOffFactor(d_test))
				{
					if(infos!=null && !infos.isEmpty())
					{
						for(int d=0;d<infos.size();d++)
						{
							String infoForDial=(String)infos.get(d);
							boolean isTestExceededCutOffFactor=dashboardDAO.isTestExceededCutOffFactor(compType,hostName,portNo,d_test,msmtHost,infoForDial);
							if(!isTestExceededCutOffFactor)
							{
								if(infosForCutOffFactor!=null && !infosForCutOffFactor.contains(infoForDial))
								{
									infosForCutOffFactor.add(infoForDial);
								}
							}
						}
					}
					if(infosForCutOffFactor!=null && !infosForCutOffFactor.isEmpty())
					{
						infos=infosForCutOffFactor;
					}
				}
				if(infos!=null && !infos.isEmpty() && infos.size()>1)
				{
					isFullView=true;
				}
				String info=fusionChart.getInfoForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed);

				if(info!=null && info.indexOf("+")!=-1)
					info=info.substring(info.indexOf("+")+1);
				info=com.egurkha.util.StringUtils.replace(info, "+", "|plus|");

				Vector dialChartAttributes=new Vector();
				dialChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");  // To avoid drilldown url problem in Doublebyte. We have to create one HIDDEN element and the url to be stored there
				dialChartAttributes.add("fillAngle='60'");
				dialChartAttributes.add("majorTMNumber='6'");
				dialChartAttributes.add("majorTMHeight='8'");
				dialChartAttributes.add("majorTMColor='e5e5e5'");
				dialChartAttributes.add("minorTMColor='e5e5e5'");
				dialChartAttributes.add("minorTMHeight='4'");
				dialChartAttributes.add("minorTMNumber='6'");
				dialChartAttributes.add("majorTMThickness='1'");
				dialChartAttributes.add("markerRadius='30'");
				dialChartAttributes.add("showGaugeBorder='0'");
				dialChartAttributes.add("gaugeOuterRadius='"+gauageOuterRadius+"'");
				dialChartAttributes.add("gaugeOriginX='"+gaugeXPos+"'");
				dialChartAttributes.add("gaugeOriginY='"+gaugeYPos+"'");
				dialChartAttributes.add("gaugeInnerRadius='0'");
				dialChartAttributes.add("formatNumberScale='0'");
				dialChartAttributes.add("displayValueDistance='0'");
				dialChartAttributes.add("decimalPrecision='2'");
				dialChartAttributes.add("tickMarkDecimalPrecision='2'");
				dialChartAttributes.add("tickValueDistance='14'");
				dialChartAttributes.add("pivotRadius='6'");
				dialChartAttributes.add("showPivotBorder='1'");
				dialChartAttributes.add("pivotBorderColor='000000'");
				dialChartAttributes.add("pivotBorderThickness='5'");
				dialChartAttributes.add("pivotFillMix='FFFFFF,000000'");
				dialChartAttributes.add("paletteThemeColor='ffffff'");
				dialChartAttributes.add("pivotFillType='linear'");
				dialChartAttributes.add("showToolTip='1'");
				dialChartAttributes.add("chartLeftMargin='0'");
				dialChartAttributes.add("chartRightMargin='0'");
				dialChartAttributes.add("chartBottomMargin='0'");
				//dialChartAttributes.add("chartTopMargin='0'");
				dialChartAttributes.add("baseFontColor='000000'");
				dialChartAttributes.add("adjustTM='0'");
				dialChartAttributes.add("chartTopMargin='0'");
				dialChartAttributes.add("borderAlpha='0'");
				dialChartAttributes.add("bgAlpha='_alpha'");

				dialChartAttributes.add("showToolTipShadow='1'");
				dialChartAttributes.add("toolTipBgColor='ffffff'");
				dialChartAttributes.add("toolTipBorderColor='555555'");
				dialChartAttributes.add("exportEnabled='0'");
				dialChartAttributes.add("exportAction='download'");
				dialChartAttributes.add("exportAtClient='0'");
				dialChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
				String dialXMLData="";
				if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
				{
					dialXMLData=fusionChart.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,dialChartAttributes,"000000",true,dialGraphWidth,dialGraphHeight,defaultDialGraphWidth,defaultDialGraphHeight);
				}
				else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
				{
					Vector jvmChartAttributes=new Vector();
					jvmChartAttributes.add("clickURL='javascript:dialOnclick(&apos;dialUrl"+dialChartCount+"&apos;)'");
					jvmChartAttributes.add("upperLimit='100'");
					jvmChartAttributes.add("bgColor='99CCFF,FFFFFF'");
					jvmChartAttributes.add("bgAlpha='0,0'");
					jvmChartAttributes.add("showBorder='0'");
					jvmChartAttributes.add("adjustTM='0'");
					jvmChartAttributes.add("lowerLimit='0'");
					jvmChartAttributes.add("decimals='2'");
					jvmChartAttributes.add("showValue='0'");
					jvmChartAttributes.add("majorTMNumber='5'");
					//jvmChartAttributes.add("baseFontSize='8'");
					jvmChartAttributes.add("majorTMColor='000000'");
					jvmChartAttributes.add("majorTMHeight='5'");
					jvmChartAttributes.add("minorTMNumber='2'");
					jvmChartAttributes.add("minorTMColor='000000'");
					jvmChartAttributes.add("minorTMHeight='2'");
					jvmChartAttributes.add("majorTMThickness='1'");
					jvmChartAttributes.add("decimalPrecision='0'");
					jvmChartAttributes.add("ledGap='"+ledGap+"'");
					jvmChartAttributes.add("ledSize='"+ledSize+"'");
					jvmChartAttributes.add("tickValueDistance='2'");
					jvmChartAttributes.add("tickMarkDistance='1'");
					jvmChartAttributes.add("tickValueStep='1'");
					jvmChartAttributes.add("tickValueDecimals='8'");
					jvmChartAttributes.add("chartLeftMargin='"+chartLeftMargin+"'");
					jvmChartAttributes.add("chartRightMargin='"+chartRightMargin+"'");
					jvmChartAttributes.add("chartTopMargin='21'");
					jvmChartAttributes.add("chartBottomMargin='20'");
					jvmChartAttributes.add("baseFontSize ='9'");
					jvmChartAttributes.add("showToolTip='1'");
					jvmChartAttributes.add("baseFontColor  ='000000'");
					jvmChartAttributes.add("annRenderDelay='1.7'");
					jvmChartAttributes.add("exportEnabled='0'");
					jvmChartAttributes.add("exportAction='download'");
					jvmChartAttributes.add("exportAtClient='0'");
					jvmChartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

					dialXMLData=fusionChart.getXMLDataForDial(d_test,d_measure,compType,hostName,portNo,msmtHost,"NULL",sid,isThresholdNeed,jvmChartAttributes,"000000",true,ledGraphWidth,ledGraphHeight,defaultLedGraphWidth,defaultLedGraphHeight);
				}
				if(dialXMLData !=null && !dialXMLData.equals(""))
				{
					String layerName=dashboardDAO.getLayerForTest(compType,d_test,d_measure);

					String compTypeForAlarm=compType;
					if(layerName!=null && (layerName.equalsIgnoreCase("HOST") || layerName.equalsIgnoreCase("NETWORK") || layerName.equalsIgnoreCase("TCP")))
						compTypeForAlarm="Host_system";

					String measureState=model.getTestMeasureState(compName,compTypeForAlarm,layerName,d_test+"-"+info,d_measure);

					String layerPageUrl=response.encodeURL("/final/monitor/egDashBoardLayers.jsp?")+"qctr=2&fromPage=componentList&host="+EgURLEncoder.encode(compName,"UTF-8")+"&comptype="+compType+"&layer="+layerName+"&site="+site+"&test="+d_test+"-"+info+"&tstate="+measureState+"&msmt_host=";

					String moreDescriptorUrl=response.encodeURL("/final/monitor/EgMoreInfosDial.jsp?")+"hostName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+d_test+"&measure="+d_measure+"&msmtHost="+EgURLEncoder.encode(msmtHost,"UTF-8")+"&tab="+tab;
					
%>

				<div style="margin-left:10px;float:left;border:0px blue solid;padding:4px;width:<%=dialGraphWidth%>" align="center">
					<table border="0" cellspacing="0" cellpadding="0" class="vm  border" >
						<tr>
							<td align="center" height="16px" class="eg_75bold jvm_he  ader" valign="top" title="<%=tooltip%>(<%=unit%>)"><%=dial_measureMapping%>(<%=unit%>)
<%
					if(isFullView)
					{
%>
								<a class="mouse eg_monlink" onclick="javascript:showMaximizedView('<%=moreDescriptorUrl%>',event,'loadPageForDial');" title="More" ><img  border="0" src="/final/monitor/eg_images/icon-newwindow_o.gif"/></a>
<%
					}
%>
							</td>
						</tr>
						<tr>
							<td align="right">
<%
					if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("Yes"))
					{
%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/AngularGauge.swf" />
								<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=dialGraphWidth%>&chartHeight=<%=dialGraphHeight%>">
								<param name="quality" value="high" />
								<param name="WMode" value="Transparent">
								<embed wmode="transparent" src="/final/FusionCharts/swf/AngularGauge.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=dialGraphWidth%>" height="<%=dialGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->
								<div id="AngularGaugeContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myAngularGaugeChartId<%=i%>" ) )
											FusionCharts( "myAngularGaugeChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/AngularGauge.swf","myAngularGaugeChartId<%=i%>", "<%=dialGraphWidth%>", "<%=dialGraphHeight%>","0","1");
									myChart.setXMLData("<%=dialXMLData%>");
									myChart.setTransparent(true);
									myChart.render("AngularGaugeContainer<%=i%>");
								</script>

<%
					} 
					else if(isDialNeeded!=null && isDialNeeded.equalsIgnoreCase("No"))
					{
%>
								<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" id="StackedColumn3D" >
								<param name="movie" value="/final/FusionCharts/swf/VLED.swf" />
								<param name="FlashVars" value="&dataXML=<%=dialXMLData%>&chartWidth=<%=ledGraphWidth%>&chartHeight=<%=ledGraphHeight%>">
								<param name="quality" value="high" />
								<param name="WMode" value="transparent" />
								<embed wmode="transparent" src="/final/FusionCharts/swf/VLED.swf" flashVars="&dataXML=<%=dialXMLData%>" quality="high" width="<%=ledGraphWidth%>" height="<%=ledGraphHeight%>" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object> -->

								<div id="VLEDContainer<%=i%>"  style="height:100%;"></div>
								<script type="text/javascript">
									if  ( FusionCharts( "myVLEDChartId<%=i%>" ) )
											FusionCharts( "myVLEDChartId<%=i%>" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/VLED.swf","myVLEDChartId<%=i%>", "<%=ledGraphWidth%>", "<%=ledGraphHeight%>","0","1");
									myChart.setXMLData("<%=dialXMLData%>");
									myChart.setTransparent(true);
									myChart.render("VLEDContainer<%=i%>");
								</script>
<%
					}
%>
							</td>
						</tr>
					</table>
					<input type="hidden" id="dialUrl<%=dialChartCount%>" value="<%=layerPageUrl%>"/>
				</div>
<%
					dialChartCount++;
					
				}
				else
				{
					
						dialmeasuresNAList.add(dial_measureMapping+"#"+unit+"$"+tooltip);
				}
				i++;
			}
			for (int na=1;na < dialmeasuresNAList.size()+1;na++)
			{
				if(dialmeasuresNAList.size()==i)
				{
					String NAlistdata = (String)dialmeasuresNAList.get(na-1);
					String dial_measureMapping = NAlistdata.substring(0,NAlistdata.indexOf("#"));
					String unit = NAlistdata.substring(NAlistdata.indexOf("#")+1,NAlistdata.indexOf("$"));
					String tooltip = NAlistdata.substring(NAlistdata.indexOf("$")+1);
					int temCount=(++dialChartCount)%5;
					dialChartCount--;
%>
					<table border="0" cellspacing="0" cellpadding="0" class="vm  border" width="100%">
						<tr>
							<td align="center" height="16px"  class="eg_75bold" valign="top" ><egui:intnl text="monitor.dashboard.Dial Graph"/>
							</td>
						</tr>
						<tr>
							<td align="center" valign="middle" height="<%=dialGraphHeight%>">
								<img src="/final/monitor/eg_images/<%=monitor_Skin%>/exclamation-icon.gif"> <br> <egui:intnl text="monitor.dashboard.No Measures Available"/>!
							</td>
						</tr>
					</table>
<%
					dialChartNoMeasuresCount++;
					int tempCount=(++dialChartCount)%5;
					dialChartCount--;
					break;
				}
			}
		}
%>
			</div>
		</div>
	</div>
<%
		double defaultTableWidth=950;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);
%>
	<div class="clr eg_blankspace" style="height:1px" >&nbsp;</div>
	<div id="ciscoOverViewTableDataDiv" style="overflow:hidden;border:0px solid orange;display:block;padding:0px 6px 6px 6px">


<%
	String interfaceEntries = iniobj.getValue(compType,"Cisco_Interface");
	if(interfaceEntries!=null && interfaceEntries.length() > 0)
	{
		StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
		StringBuffer infosToAreaChart=new StringBuffer();
		Map mapData=new HashMap();
		ArrayList units=new ArrayList();
		units.add("-");
		String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
		StringBuffer measureColumn=new StringBuffer();
		String fullviewTest="";
		String fullviewMsmtHost="";
		String interfaceCount_fullview="";

		int imgcnt=0;
		int stColPos=1;
		int endColPos=5;
		//String header[]={"Interface","Availability","Data Received Rate","Data transmit Rate","BandWidth Used"};
		List headers=new ArrayList();
		headers.add("Interface");
		while(stoken.hasMoreTokens())
		{
			String testMeasure=stoken.nextToken();
			String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
			String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
			String measureForDB=dbInfo.getColumnForMeasure(interface_test,interface_measure);
			String msmthost=(String)allMsmtHosts.get(interface_test);
			String excludedInfos=iniobj.getValue("INFOS_TO_BE_OMITTED",testMeasure);
			String interfaces_Count=iniobj.getValue("Interfaces","MaxInterfaces");
			String iniheader=iniobj.getValue(compType,testMeasure);
			headers.add(iniheader);
			fullviewTest=interface_test;
			fullviewMsmtHost=msmthost;
			interfaceCount_fullview=interfaces_Count;
			measureColumn.append(measureForDB);
			if(stoken.hasMoreTokens())
				measureColumn.append(",");
			//newly added
			
			StringTokenizer infos=new StringTokenizer(excludedInfos,",");
			Vector excluded_infos=new Vector();
			
			if(enabledTests!=null && !enabledTests.contains(interface_test))
				continue;
			while(infos.hasMoreTokens())
			{
					excluded_infos.add("+"+infos.nextToken());
			}
			Vector filtered_infos=new Vector();
			Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,interfaces_Count);//newly added

			String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
			String defaultInfo="";
			String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
			
			units.add(unit);

			if(currentValues!=null && currentValues.size()>0)
			{
				for(int i=0;i<currentValues.size();i=i+2)
				{
					String interfaceInfo=(String)currentValues.get(i);
					String value=(String)currentValues.get(i+1);
					if(!excluded_infos.contains(interfaceInfo))
					{
							filtered_infos.add(interfaceInfo);
							filtered_infos.add(value);
					}
				}
			}
			if(filtered_infos!=null && filtered_infos.size()>0)
			{
				for(int i=0;i<filtered_infos.size();i=i+2)
				{
					String interfaceInfo=(String)filtered_infos.get(i);
					String value=(String)filtered_infos.get(i+1);
					if(mapData!=null && mapData.containsKey(interfaceInfo))
					{
						ArrayList existingList=(ArrayList)mapData.get(interfaceInfo);
						existingList.add(value);
						mapData.put(interfaceInfo,existingList);
					}
					else
					{
						ArrayList valueList=new ArrayList();
						valueList.add(value);
						mapData.put(interfaceInfo,valueList);
					}
				}
			}
		}

		//List headerList=Arrays.asList(header);
		comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn.toString()+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=true&headerList="+headers+"&inilookup=Cisco_Interface";
%>
		<div class="ciscoDataTableDiv linesquare" style="margin:0px;padding:0px;valign:top;display:none;" >
			<div class="eg_medium" style="display:block;visibility:visible;height:20px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.title.Top Interfaces"/></div>

				<div style="text-align:center;padding:2px 10px 2px 4px;float:right"><img src="/final/images/<%=monitor_Skin%>/icon_areachart.png" class="mouse minimize6" title="click to view area chart"></div>

				<div style="text-align:center;padding:2px 10px 2px 4px;float:right">
<%
	if(adminPermission==true)
	{
%>
					<a  href="javascript:void(0);" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','CiscoComparisionTable');"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" border="0"></a>

<%
	}
	else
	{
%>
					<a href="javascript:void(0);" onclick="javascript:showMaximizedView('<%=comparisonTableFullViewURL%>','event','CiscoComparisionTable');"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" border="0"></a>
<%
	}
%>
				</div>
			</div>

			<div class="ciscoDataTableDivScroll div_scroll" style="clear:both;height:120px;">
<%
	if(mapData!=null && !mapData.isEmpty())
	{
%>
				<table cellpadding="4" cellspacing="0" class="" border="0" width="100%" id="ciscoDataTable">
					<thead>
						<tr>
<%
		endColPos=headers.size();
		for(int j=0;j<headers.size();j++)
		{
			String h_unit=(String)units.get(j);
			if(h_unit.equals("-"))
				h_unit="";
%>
							<th class="layer_headbg" style='<%= ((j==0))?"border-bottom-width:0px;border-right-width:0px;border-left-width:0px;":"border-bottom-width:0px;border-right-width:0px;"%>'>
								<table cellspacing="0" cellpadding="0"   border="0" width="100%">
									<tr>
<%
			if(j==0)
			{
%>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortCiscoTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','','');"><span class="eg_75bold"><%=(String)headers.get(j)%> </a></span></td>
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortCiscoTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','','');" style="display:none"/></td>
<%
			}
			else
			{
%>
										<td ><a class="eg_monlink" href="" onclick="this.blur();return sortCiscoTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','','');"><span class="eg_75bold"><%=(String)headers.get(j)%> (<%=h_unit%>)</a></span></td>
										<td style="width:15px" ><img id="imgdd<%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortCiscoTable('rsTable0',<%=j%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','','');" style="display:none"/></td>
<%
			}
%>
									</tr>
								</table>
							</th>
<%
			imgcnt++;
		}
%>
						</tr>
					</thead>
					<tbody name="rsTable0" id="rsTable0">
<%
		
			Iterator itr=mapData.keySet().iterator();
			endColPos=5;

			int k=0;
			while(itr.hasNext())
			{
				String info=(String)itr.next();
				infosToAreaChart.append(info);
				if(itr.hasNext())
					infosToAreaChart.append(",");
				
%>
						<tr id="ciscoDataTable<%=k%>">
							<td valign="top"  align="left"><%=com.egurkha.util.StringUtils.replace(info, "+", "")%></td>
<%
				ArrayList values=(ArrayList)mapData.get(info);
				if(values!=null && values.size()>0)
				{
					for(int i=0;i<values.size();i++)
					{
						String val=(String)values.get(i);
						if(val.startsWith("-"))
							val="-";
						if(i==0)
						{
							String measVal = dbInfo.formatValue(val);
							String img="";
							if(measVal.equals("100"))
							{
								img = "mes_GOOD.gif";
							}
							else
							{
								img="mes_HIGH.gif";
							}
%>
							<td valign="top"  align="left"> <img src="/final/monitor/eg_images/<%=img%>"> </td>
<%
							
						}
						else
						{
%>
							<td valign="top"  align="left" > <%=val%> </td>
<%	
						}
					}
				}
%>
						</tr>
<%
			k++;
			}
%>
					</tbody>
				</table>
<%
		}
		else
		{
%>
				<table border="0" cellpadding="4" cellspacing="0" width="100%" height="100%" class="eg_whitebg">
					<tr>
						<td align="center" valign="middle" >
							<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />!
						</td>
					</tr>
				</table>
<%
		}
		String passingInfo=infosToAreaChart.toString();
		String url="/final/monitor/EgCiscoDashHelper.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&mappingName=abc&blockType=areaChart&infosToArea="+infosToAreaChart;
%>

							<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortCiscoTable('rsTable0',4,1,5,5,'','');" style="visibility:hidden;display:none;">
			</div>
		</div>

		<div class="ciscoBayStackGraphDiv linesquare" style="margin:0px;padding:0px;valign:top;display:block;" >
			<div class="eg_medium gra  dientBgVmTab" style="display:block;visibility:visible;height:20px;width:100%;">
				<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="monitor.title.Top Interfaces"/></div>

				<div style="text-align:center;padding:2px 10px 2px 4px;float:right"><img src="/final/images/<%=monitor_Skin%>/icon_table.png" class="mouse minimize7" title="click to view interface table"></div>

				<div style="text-align:center;padding:2px 10px 2px 4px;float:right">
					<table cellpadding="0" cellspacing="0"  border="0" width="100%">
						<tr>
							<td class="eg_8bold" align="right" width="89%"><egui:intnl text="monitor.common.TimeLine"/>&nbsp;:&nbsp;</td>
							<td align="left" width="11%">
								<select width="100%" id="timeSelect" name="timeSelect" onchange="javascript:infoOnclick('<%=url%>');">
<%
		String[] dateChoice={"1 hour","3 hours","6 hours","9 hours","12 hours","15 hours","18 hours","24 hours","2 days","3 days","4 days","5 days","6 days","1 week","2 weeks","3 weeks ","4 weeks","1 month"};
		List datelist=Arrays.asList(dateChoice);
		for(int i=0;i<datelist.size();i++)
		{
			String element=(String)datelist.get(i);
			String selected="";
			if(element.equals("1 hour"))
				selected="selected";

%>
									<option value="<%=element%>" <%=selected%>><%=element%></option>
<%
		}
		
%>
								</select>
							</td>
						</tr>
					</table>
				</div>
			</div>
			<div style="clear:both;display:block;height:180px;valign:top;border:0px solid red" class="ciscoBayStackGraphDivScroll div_scroll white_bg;">
				<div id="graphDivAreaChart">
					<jsp:include page="<%="EgCiscoDashHelper.jsp?hostName="+compName+"&compType="+compType+"&tab="+tab+"&screenWidth="+screenWidth+"&screenHeight="+screenHeight+"&blockType=areaChart&infosToArea="+infosToAreaChart+"&ciscoSelectedType="+ciscoSelectedType%>" />
				</div>
			</div>
		</div>
	</div>
<!-- </div> -->

	<div id="protocolDiv" class="ciscoProtocolDiv div_scroll" style="visibility:hidden;display:none;border:0px solid orange;" >
		<div  style="display:block;visibility:visible;padding:6px 6px 6px 6px;">
			<div class="eg_medium gradi  entBgVmTab" style="display:block;visibility:visible;height:22px;width:100%;border-top:0px;border-right:0px;border-left:0px;">
				<div class="eg_8bold" style="float:left;padding:4px"><egui:intnl text="Top interfaces by portion of current traffic"/></div>
			</div>
			<div class="linesquare eg_whitebg" style="display:block;" >

			<p align="center" style="padding:0px;margin:0px">
				<table cellpadding="0" cellspacing="0" border="0">
					<tr>
<%
		
		String iniVal=(String)iniobj.getValue(compType,"Cisco_Protocol_piechart");
		if(iniVal!=null )
		{
			double defaultPieGraphWidth=450;  // default dial graph width for calculation
			double defaultPieGraphHeight=350;  // default dial graph height for calculation
			double pieGraphWidth=450;  
			double pieGraphHeight=350;

			double pieGraphWidthTo1024PxInPercent=defaultPieGraphWidth/1024;
			double pieGraphHeightToDefaultWidthInPercent=defaultPieGraphHeight/defaultPieGraphWidth;

			pieGraphWidth=screenWidthInDouble*pieGraphWidthTo1024PxInPercent;
			pieGraphWidth=MathUtils.round(pieGraphWidth,0);
			StringTokenizer sto=new StringTokenizer(iniVal,",");
			while(sto.hasMoreTokens())
			{
				String testWithMeasure=sto.nextToken();
				String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));

				String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
				String msmthost=(String)allMsmtHosts.get(s_test);

				if(enabledTests!=null && enabledTests.contains(s_test))
				{

					Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,s_measure,msmthost,"",true,"");
					
					Map valuesMap=new HashMap();

					if(currentValues!=null && currentValues.size()>0)
					{
						for(int i=0;i<currentValues.size();i=i+2)
						{
							String infoWithProtocol=(String)currentValues.get(i);
							String info=infoWithProtocol.substring(0,infoWithProtocol.indexOf(":"));
							String protocol=infoWithProtocol.substring(infoWithProtocol.indexOf(":")+1);
							String value=(String)currentValues.get(i+1);
							if(valuesMap!=null && valuesMap.containsKey(info))
							{
								List existingList=(ArrayList)valuesMap.get(info);
								existingList.add(protocol);
								existingList.add(value);
								valuesMap.put(info,existingList);
							}
							else
							{
								List valueList=new ArrayList();
								valueList.add(protocol);
								valueList.add(value);
								valuesMap.put(info,valueList);
								
							}
						}
					}
					int tableSize=0;
					tableSize=valuesMap.size();
					String align=(tableSize==1)?"center":"center";
					String width=(tableSize==1)?"700":"350";
					String pieRadious=(tableSize==1)?"68":"42";

					if(valuesMap!=null && !valuesMap.isEmpty())
					{
						Iterator itr=valuesMap.keySet().iterator();
						int count=0;
						while(itr.hasNext())
						{
							if(count > 3 )
								break;
							String key=(String)itr.next();
							Vector chartAttributes=new Vector();
							//caption="Sales Per Employee for year 1996" palette="2" animation="1" formatNumberScale="0" numberPrefix="$" pieSliceDepth="30" startingAngle="125"
							//chartAttributes.add("caption='"+key+"'");
							chartAttributes.add("decimals='2'");
							chartAttributes.add("enableRotation='1'");
							chartAttributes.add("bgColor='99CCFF,FFFFFF'");
							chartAttributes.add("bgAlpha='0,0'");
							//chartAttributes.add("bgRatio='0,100'");
							chartAttributes.add("bgAngle='360'");
							chartAttributes.add("showBorder='0'");
							chartAttributes.add("startingAngle='80'");
							//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
							chartAttributes.add("chartLeftMargin ='0'");
							chartAttributes.add("chartTopMargin ='0'");
							chartAttributes.add("chartBottomMargin ='0'");
							chartAttributes.add("chartRightMargin ='0'");
							chartAttributes.add("showToolTipShadow ='1'");
							chartAttributes.add("pieSliceDepth='7'");
							chartAttributes.add("numberSuffix='%'");
							chartAttributes.add("showToolTipShadow ='1'");
							chartAttributes.add("pieOuterFaceAlpha  ='75'");
							chartAttributes.add("pieInnerFaceAlpha  ='100'");
							chartAttributes.add("pieYScale  ='65'");
							chartAttributes.add("smartLineColor  ='000000'");
							chartAttributes.add("smartLabelClearance  ='2'");
							chartAttributes.add("captionPadding  ='0'");
							chartAttributes.add("bgSWFAlpha  ='0'");
							chartAttributes.add("enableSmartLabels='1'");
							chartAttributes.add("pieRadius='"+pieRadious+"'");
							chartAttributes.add("labelDistance='6'");
							chartAttributes.add("isSmartLineSlanted='1'");
							chartAttributes.add("exportEnabled='0'");
							chartAttributes.add("exportAction='download'");
							chartAttributes.add("exportAtClient='0'");
							chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");

							String xml=(String)fusionChart.getXMLtoProtocol(key,valuesMap,chartAttributes);
							if(xml!=null && !xml.equals(""))
							{
%>
						<td align="<%=align%>">
							<table cellpadding="4" cellspacing="0" align="<%=align%>" border="0">
								<tr>
									<td class="eg_75bold" align="center"> <%=com.egurkha.util.StringUtils.replace(key, "+", "")%> </td>
								</tr>
								<tr>
									<td>
										<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=pieGraphWidth%>" height="180" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
											<param name="FlashVars" value="&dataXML=<%=xml%>&chartWidth=<%=pieGraphWidth%>&chartHeight=180">
											<param name="quality" value="high" />
											<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
											<param name="WMode" value="Transparent">
											<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xml%>" quality="high" width="<%=pieGraphWidth%>" height="180" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
										</object> -->

										<div id="Pie3DContainer<%=count%>"  style="height:100%;"></div>
										<script type="text/javascript">
											if  ( FusionCharts( "myPie3DChartId<%=count%>" ) )
													FusionCharts( "myPie3DChartId<%=count%>" ).dispose();
											var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPie3DChartId<%=count%>", "<%=pieGraphWidth%>", "180","0","1");
											myChart.setXMLData("<%=xml%>");
											myChart.setTransparent(true);
											myChart.render("Pie3DContainer<%=count%>");
										</script>
									</td>
								</tr>
							</table>
						</td>
<%
						}
						else
						{
%>
						<td align="<%=align%>">
							<table cellpadding="0" cellspacing="0" style="padding-top:15px;" align="<%=align%>" border="0">
								<tr>
									<td class="eg_75bold" align="center">
										<%=com.egurkha.util.StringUtils.replace(key, "+", "")%>
									</td>
								</tr>
								<tr>
									<td>
										<div class="eg_8bold" align="center">
											<table border="0" cellpadding="0" cellspacing="0">
												</tr>
													<td align="center">
														<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
													</td>
												</tr>
											</table>
										</div>
									</td>
								</tr>
							</table>
						</td>
									
<%
							}
							count++;
						}
					}
					else
					{
%>
						<td>
							<div class="eg_8bold" align="center" >
								<table border="0" cellpadding="0" cellspacing="0"  align="center" height="180px">
									<tr>
										<td align="center" valign="middle">
											<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No measures Available" />!
										</td>
									</tr>
								</table>
							</div>
						</td>
<%
					}
				}
				else
				{
%>
						<td>
							<table border="0" cellpadding="0" cellspacing="0" width="100%" height="180px">
								<tr>
									<td align="center" valign="middle">
										<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.The test has been disabled" />
									</td>
								</tr>
							</table>
						</td>
<%
				}
			}
		}
%>
					</tr>
				</table></p>
			</div>
		</div>
		<div id="ciscoProtocolAreaChartDiv" style="border:0px solid orange;visibility:visible;display:block;position:relative;">
		</div>
	</div>

	<div id="flowsDiv" class="ciscoFlowsDiv div_scroll" style="visibility:hidden;display:none;border:0px solid orange;" >
		Flows Page
	</div>
<%

	}
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType=overview");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
%>
</div>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>

