<%@ page contentType="text/html;charset-UTF8" language="java" pageEncoding="UTF-8" %>
<%@ page errorPage="EgProbsM.jsp" %>
<%@ include file="EgLoginTracker.jsp" %>
<%@ taglib uri="../WEB-INF/eg-taglib.tld" prefix="egui" %>

<%@ page import="java.text.SimpleDateFormat" %>
<%@ page import="com.egurkha.monitor.MonitorDAOFactory" %>
<%@ page import="com.egurkha.monitor.EgServerDashBoardDAO" %>
<%@ page import="com.eg.EgDbInfo" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateTimeTokenizer" %>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "com.egurkha.monitor.*"%>
<%@ page import="com.eg.EgTablesInfo" %>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.egurkha.util.MathUtils"%>
<%@ page import="com.egurkha.monitor.EgFusionChartUtil" %>

<%
	response.setHeader("Cache-Control","no-Store");
	response.setHeader("Pragma","no-Cache");
	response.setDateHeader("Expires",-1);
%>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<%
try
{
	String compName=request.getParameter("hostName");
	String compType=request.getParameter("compType");
	String tab=request.getParameter("tab");
	String blockType=request.getParameter("blockType");
	String ciscoSelectedType=request.getParameter("ciscoSelectedType");
	String test=request.getParameter("testName");
	String measure=request.getParameter("measureName");
	String defaultInfo=request.getParameter("defaultInfo");
	String selectedDate=request.getParameter("selectedDate");
	String selectedInterface=request.getParameter("selectedInterface");

	String screenWidth=request.getParameter("screenWidth");
	String screenHeight=request.getParameter("screenHeight");
	double screenWidthInDouble=1024.0;
	double screenHeightInDouble=768.0;
	if(screenWidth!=null && !screenWidth.equals(""))
	{
		screenWidthInDouble=Double.parseDouble(screenWidth);
	}
	if(screenHeight!=null && !screenHeight.equals(""))
	{
		screenHeightInDouble=Double.parseDouble(screenHeight);
	}

	EgDbInfo dbinfo=new EgDbInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo=new EgTablesInfo("manager");
	EgDateInfo edi = new EgDateInfo();
	String s_iniFile_dir=EgInstallInfo.getInstallDir()+"/manager/config/";
	IniFile iniobj=new IniFile(s_iniFile_dir+"eg_serverdashboard.ini");
	MonitorDAOFactory factory=MonitorDAOFactory.getInstance();
	EgServerDashBoardDAO dashboardDAO=factory.getServerDashBoardDAO();
	EgFusionChartUtil fusionChart=new EgFusionChartUtil(trackerLanguage);
	EgSummaryChartUtil summaryChart=new EgSummaryChartUtil();

	EgUserRole userRole = u_ser.getUserRole();
	long perm = EgUserPermission.ADMIN;
	boolean adminPermission = userRole.hasAdminRole(perm);
	String defaultMGraphDuration=iniobj.getValue("Default_MeasureGraph_Duration","duration");
	String FullViewPriority="TOP+-+10";
	String hostName="";
	String portNo="";
	String sid="";
	if(compName!=null && !compName.equals(""))
	{
		StringTokenizer st=new StringTokenizer(compName,":");
		if(st.hasMoreTokens())
			hostName=st.nextToken();

		if(st.hasMoreTokens())
		{
			portNo=st.nextToken();
		}

		if(st.hasMoreTokens())
			sid=st.nextToken();
	}

	Hashtable allMsmtHosts=dashboardDAO.getMsmtHostForAllTest(compName,compType,tab);
	Hashtable allTestInfos=dashboardDAO.getDescriptorsForAllTest(compName,compType,tab);
	ArrayList enabledTests=specsInfo.getEnabledTests(compType,false);

	if(blockType!=null && blockType.equals("areaChart"))
	{
	SimpleDateFormat sdf=new SimpleDateFormat("MM/dd/yyyy HH:mm");
	int[] timeFormat={1000*60*60,1000*60*60*24*7,1000*60*60*24*30};
	int passValue=1000*60*60;
	String title="";
	String startDateTime="";
	String endDateTime="";
	String s_en_time="";
	String s_st_time="";
	String s_st_hr = "";
	String s_en_hr="";
	String timeSelect="";
	if(selectedDate!=null && !selectedDate.equals(""))
	{
		selectedDate=selectedDate.toLowerCase();
		timeSelect=selectedDate.toLowerCase();
		int blankSpaceIndex = selectedDate.indexOf(DateTimeTokenizer.BLANK_SPACE);
		if (blankSpaceIndex > 0)
		{
			String titletmp=selectedDate;
			java.util.Date today = edi.egetRealDate();
			endDateTime=sdf.format(today);
			int value = Integer.parseInt(selectedDate.substring(0, blankSpaceIndex));
			String timelineUnit = selectedDate.substring(blankSpaceIndex+1).toLowerCase();
			if (timelineUnit.startsWith("h"))
			{//hours
				value *= 3600;
				title=titletmp;
			}
			else if (timelineUnit.startsWith("d"))
			{//days
				value *= (24 * 3600);
				title=titletmp;
			}
			else if (timelineUnit.startsWith("w"))
			{//weeks
				value *= (7 * 24 * 3600);
				title=titletmp;
			}
			else if (timelineUnit.startsWith("mo"))
			{//months
				//value *= (30 * 24 * 3600);
				value *=(24*(ErUtils.getMaxDaysInMonth()) * 3600);
				title=titletmp;
			}
			long longValue=value;
			java.util.Date start = edi.egetRealDate();
			start.setTime(today.getTime() - (longValue * 1000));
			startDateTime = sdf.format(start);
			if ((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
		}
	}
	else
	{
			timeSelect="1 hour";
			java.util.Date endDate=edi.egetRealDate();
			endDateTime=sdf.format(endDate);
			java.util.Date startDate=edi.egetRealDate();
			startDate.setTime(endDate.getTime() - (3600 * 1000));
			startDateTime=sdf.format(startDate);
			if ((startDateTime != null) && (endDateTime != null))
			{
				int shr = Integer.parseInt(startDateTime.substring(startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, startDateTime.indexOf(":")));  
				int en_hr = Integer.parseInt(endDateTime.substring(endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE)+1, endDateTime.indexOf(":")));
				s_en_time=endDateTime.substring(0, endDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_time=startDateTime.substring(0, startDateTime.indexOf(DateTimeTokenizer.BLANK_SPACE));
				s_st_hr = String.valueOf(shr);
				s_en_hr = String.valueOf(en_hr);
			}
			title="1 hour";
	}
	String interfaceEntries = iniobj.getValue(compType,"Cisco_Interface");
	if(interfaceEntries!=null && interfaceEntries.length() > 0)
	{
		String infosToArea=request.getParameter("infosToArea");
		StringBuffer tmpBuffer=new StringBuffer();
		if(infosToArea!=null && !infosToArea.equals(""))
		{
			StringTokenizer stt=new StringTokenizer(infosToArea,",");
			
			while(stt.hasMoreTokens())
			{
				String tok=stt.nextToken();
				tok=tok.trim();
				tok="+"+tok;
				tmpBuffer.append("'");
				tmpBuffer.append(tok);
				tmpBuffer.append("'");
				if(stt.hasMoreTokens())
					tmpBuffer.append(",");

			}
		}
		infosToArea=tmpBuffer.toString();
		StringTokenizer stoken=new StringTokenizer(interfaceEntries,",");
		double defaultTableWidth=940;
		double tableWidth=910;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		int cnt=0; 
		boolean isFullView=false;
		boolean isDisabled=false;
		ArrayList pieChartNAList = new ArrayList();
		while(stoken.hasMoreTokens())
		{
			String testMeasure=stoken.nextToken();
			String interface_test=testMeasure.substring(0,testMeasure.indexOf(":"));
			String interface_measure=testMeasure.substring(testMeasure.indexOf(":")+1);
			if(interface_measure.equals("Availability"))
				continue;
			if(enabledTests!=null && enabledTests.contains(interface_test))
			{
				
				String measureForDB=dbinfo.getColumnForMeasure(interface_test,interface_measure);
				String msmthost=(String)allMsmtHosts.get(interface_test);
				Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,interface_test,measureForDB,msmthost,"",true,"");
				String info="";
				if(currentValues!=null && currentValues.size() >0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String currentInfo=(String)currentValues.get(i);
						currentInfo=com.egurkha.util.StringUtils.replace(currentInfo, "+", "*");
						if(currentValues.size()>1)
							info+=currentInfo+",";
						String value=(String)currentValues.get(0);
					}
				}
				String tableName = iniobj.getValue("Dashboard_GraphTitle_Mapping",testMeasure);
				String unit=tablesInfo.getUnitForMeasure(interface_test,interface_measure);
			
				String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testMeasure);

				if(mappingName!=null && mappingName.equals(""))
				{
					mappingName="Band Width Usage";
				}
				String s_layer=dashboardDAO.getLayerForTest(compType,interface_test,interface_measure);
				String width="440";
				String height="180";

			if(unit.equals("%"))
				unit="percent";
				
				Vector Infos=(Vector)allTestInfos.get(interface_test);
				String cisInfo="";
				if(Infos!=null && Infos.size()>0)
				{
					if(interface_test.equals("SystemTest") && Infos.contains("+Summary"))
					{
						cisInfo="+Summary";
					}
					else
					{
						cisInfo=(String)Infos.get(0);
					}
				}
				String cisGraphUrlLarge="";

			Vector chartAttributes=new Vector();
			chartAttributes.add("caption='"+mappingName+" ("+unit+")'");
//			chartAttributes.add("xAxisName='Time in  HH : mm'");

			chartAttributes.add("showValues='0'");
			chartAttributes.add("palette='0'");
			chartAttributes.add("bgColor='#FFFFFF'");
			chartAttributes.add("showBorder='0'");
			chartAttributes.add("staggerLines='3'");
			chartAttributes.add("numVDivLines='10'");
			chartAttributes.add("plotGradientColor=''");
			chartAttributes.add("numDivLines='10'");
			chartAttributes.add("adjustDiv='1'");
			chartAttributes.add("vDivLineIsDashed='1'");
			chartAttributes.add("legendShadow='1'");
			chartAttributes.add("vDivLineDashGap='10px'");
			chartAttributes.add("dashed='1'");
			chartAttributes.add("divLineIsDashed='1'");
			chartAttributes.add("legendPosition='RIGHT'");
			chartAttributes.add("plotFillAlpha='70'");
			chartAttributes.add("reverseLegend='1'");
			chartAttributes.add("interactiveLegend='1'");
			//chartAttributes.add("clickURL='javascript:areaChartOnClick(&apos;fusion"+cnt+"&apos;);'");
				String xml=fusionChart.getXMLDataForAreaChart(timeSelect,interface_test,interface_measure,mappingName,hostName,msmthost,chartAttributes,"5",infosToArea,isFullView);
				int legendInfo_count=fusionChart.getInfoCountForLegend();
				if(infosToArea!=null && infosToArea.length()>0 && infosToArea.contains("+"))
				{
					String infosToChart= infosToArea.replace("+","plus ");
					cisGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+interface_test+"&measure="+interface_measure+"&module="+tab+"&width=880&height=320&from=fullview&timeSelect="+timeSelect+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&unit="+unit+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&infosToArea="+infosToChart+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=true&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
				}
				else
				{
					cisGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+interface_test+"&measure="+interface_measure+"&module="+tab+"&width=880&height=220&from=fullview&timeSelect="+timeSelect+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&infosToArea="+infosToArea+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=true&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
				}
				if(xml!=null && !xml.equals(""))
				{

%>
						<div class="eg_8bold eg_whitebg" align="center" style="display:inline-block;padding:4px;">
							<div style="float:left;">
							<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tableWidth%>" height="280" id="StackedColumn3D" >
							<param name="movie" value="/final/FusionCharts/swf/MSArea.swf" />
							<param name="FlashVars" value="&dataXML=<%=xml%>&chartWidth=<%=tableWidth%>&chartHeight=280">
							<param name="quality" value="high" />
							<param name="WMode" value="Transparent">
							<embed wmode="transparent" src="/final/FusionCharts/swf/MSArea.swf" flashVars="&dataXML=<%=xml%>" quality="high" width="<%=tableWidth%>" height="280" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
							</object> -->
							<div id="MSAreaContainer<%=cnt%>"  style="height:100%;"></div>
							<script type="text/javascript">
								if  ( FusionCharts( "myMSAreaChartId<%=cnt%>" ) )
										FusionCharts( "myMSAreaChartId<%=cnt%>" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/MSArea.swf","myMSAreaChartId<%=cnt%>", "<%=tableWidth%>", "280","0","1");
								myChart.setXMLData("<%=xml%>");
								myChart.setTransparent(true);
								myChart.render("MSAreaContainer<%=cnt%>");
							</script>
							</div>
							<div style="float:right;" valign="top">
							<a  onclick="javascript:areaChartOnClick('fusion<%=cnt%>');" href="javascript:void(0);"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" border="0" /></a>
							</div>
						</div>
						<div class="clr eg_blankspace" style="height:10px">&nbsp;</div>

<%
				}
				else
				{
					pieChartNAList.add(mappingName+" ("+unit+")");
				}
%>
				<input type="Hidden" id="fusion<%=cnt%>" value="<%=cisGraphUrlLarge%>"/>		
<%
			}
			else
			{
				isDisabled=true;
%>
				
						
							<table border="0" cellpadding="0" height="100%"  cellspacing="0" width="100%" align="center" height="100%">
								</tr>
									<td align="center" valign="middle">
										<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.The test has been disabled" />!
									</td>
								</tr>
							</table>
						
<%
				break;
			}
			cnt++;
		}
		if(!isDisabled && pieChartNAList.size()==cnt)
		{
%>
						
				<table width="100%" height="100%" border="0"  cellspacing="0px">
					<tr>
						<td align="center" valign="middle" class="eg_whitebg">
							<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
						</td>
					</tr>
				</table>
<%
		}
	}
%>

<%
	}
	else if(blockType!=null && blockType.equals("Protocols"))
	{
		double defaultTableWidth=940;
		double tableWidth=910;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);
%>
<div style="margin:0px;padding:0px 6px 6px 6px;valign:top;display:block;border:0px solid red" >

<%
	String iniData=(String)iniobj.getValue(compType,"Cisco_Protocol");
	//newly added
				String infosToArea=request.getParameter("infosToArea");
			StringBuffer tmpBuffer=new StringBuffer();
			if(infosToArea!=null && !infosToArea.equals(""))
			{
				StringTokenizer stt=new StringTokenizer(infosToArea,",");
				
				while(stt.hasMoreTokens())
				{
					String tok=stt.nextToken();
					tok=tok.trim();
					tok="+"+tok;
					tmpBuffer.append("'");
					tmpBuffer.append(tok);
					tmpBuffer.append("'");
					if(stt.hasMoreTokens())
						tmpBuffer.append(",");

				}
			}
			infosToArea=tmpBuffer.toString();
	if(iniData!=null)
	{
		StringTokenizer st=new StringTokenizer(iniData,",");
		while(st.hasMoreTokens())
		{
			String testWithMeasure=st.nextToken();
			String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));
			String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1);
			String measureForDB=dbinfo.getColumnForMeasure(s_test,s_measure);

			if(enabledTests!=null && enabledTests.contains(s_test))
			{
				String msmthost=(String)allMsmtHosts.get(s_test);
				Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,measureForDB,msmthost,"",true,"");
				String defaultInterface="";
				Map map=new HashMap();
				if(currentValues!=null && currentValues.size()>0)
				{
					for(int i=0;i<currentValues.size();i=i+2)
					{
						String info=(String)currentValues.get(i);
						String interFace=info.substring(0,info.indexOf(":"));
						String protocol=info.substring(info.indexOf(":")+1);
						String value=(String)currentValues.get(i+1);
						defaultInterface=interFace;
						if(map!=null && map.containsKey(interFace))
						{
							List existingList=(ArrayList)map.get(interFace);
							existingList.add(protocol);
							existingList.add(value);
							map.put(interFace,existingList);
						}
						else
						{
							List innerList=new ArrayList();
							innerList.add(protocol);
							innerList.add(value);
							map.put(interFace,innerList);
						}
					}
				
				String url="/final/monitor/EgCiscoDashHelper.jsp?tab="+tab+"&hostName="+hostName+"&compType="+compType+"&subsystem=Overview&blockType=Protocols";
%>
	<div class="eg_medium grad  ientBgVmTab" style="display:block;visibility:visible;height:20px;width:100%;">
		<div class="eg_8bold" style="float:left;padding:2px;"><egui:intnl text="Protocol distribution by bandwidth usage "/></div>

		<div style="text-align:center;padding:2px 10px 2px 4px;float:right;">
			<table cellpadding="0" cellspacing="0" border="0">
				<tr>
					<td class="eg_8bold" align="right"><egui:intnl text="monitor.common.Interface"/>&nbsp;:&nbsp;</td>
					<td align="left">
						<select id="interfaceSelect" name="interfaceSelect" width="100%" onchange="javascript:loadAreachart();">
<%
				if(map!=null && !map.isEmpty())
				{
					Iterator itr=map.keySet().iterator();
					int j=0;
					while(itr.hasNext())
					{
						if(j>3)
							continue;
						String interFaceName=com.egurkha.util.StringUtils.replace((String)itr.next(), "+", "");
						String selected="";
						if(selectedInterface!=null && selectedInterface.equals(interFaceName))
						{
							selected="selected";
							selectedInterface="+"+selectedInterface;
							defaultInterface=selectedInterface;
						}
%>
							<option value="<%=interFaceName%>" <%=selected%>><%=interFaceName%></option>
<%
					j++;
					}
				}
%>
						</select>
					</td>
				</tr>
			</table>
		</div>
	</div>

	<div id="chartDiv" name="chartDiv" class="linesquare">
<%
				String mappingName = iniobj.getValue("Dashboard_TableColumn_mapping",testWithMeasure);
				int cnt=4;
				String Title="Protocol distribution by bandwidth usage ";
				String defaultTime="24 hours";
				Vector Infos=(Vector)allTestInfos.get(s_test);
				String ddinfo="";
				if(Infos!=null && Infos.size()>0)
				{
					if(s_test.equals("SystemTest") && Infos.contains("+Summary"))
					{
						ddinfo="+Summary";
					}
					else
					{
						ddinfo=(String)Infos.get(0);
					}
				}
				String areaGraphUrlLarge="";

				Vector chartAttributes=new Vector();
				chartAttributes.add("caption='"+mappingName+"'");
	//			chartAttributes.add("xAxisName='Time in  HH : mm'");
				chartAttributes.add("showValues='0'");
				chartAttributes.add("palette='0'");
				chartAttributes.add("bgColor='#FFFFFF'");
				chartAttributes.add("showBorder='0'");
				chartAttributes.add("staggerLines='3'");
				chartAttributes.add("plotGradientColor=''");
				chartAttributes.add("numVDivLines='15'");
				chartAttributes.add("numDivLines='15'");
				chartAttributes.add("adjustDiv='1'");
				chartAttributes.add("vDivLineIsDashed='1'");
				chartAttributes.add("legendShadow='1'");
				chartAttributes.add("vDivLineDashGap='10px'");
				chartAttributes.add("dashed='1'");
				chartAttributes.add("divLineIsDashed='1'");
				chartAttributes.add("legendPosition='RIGHT'");
				chartAttributes.add("reverseLegend='1'");
				chartAttributes.add("interactiveLegend='1'");
				//chartAttributes.add("clickURL='javascript:areaChartOnClick(&apos;fusion"+cnt+"&apos;);'");

				String xml=fusionChart.getXMLDataForAreaChart("24 hour",s_test,s_measure,mappingName,hostName,msmthost,chartAttributes,defaultInterface,"10","");
				int legendInfo_count=fusionChart.getInfoCountForLegend();

				if(defaultInterface!=null && defaultInterface.length()>0 && defaultInterface.contains("+"))
				{
					String select_Interface= defaultInterface.replace("+","plus ");
					areaGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"isFullView=true"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+s_test+"&measure="+s_measure+"&module="+tab+"&width=880&height=320&from=fullview&timeSelect="+defaultTime+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&defaultInterface="+select_Interface+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=false&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
				}
				else
				{
					areaGraphUrlLarge=response.encodeURL("/final/monitor/egDashBoardDDData.jsp?")+"isFullView=true"+"&host="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&test="+s_test+"&measure="+s_measure+"&module="+tab+"&width=880&height=220&from=fullview&timeSelect="+defaultTime+"&mode=3D&monitorSkin="+monitor_Skin+"&blockType="+blockType+"&mappingName="+mappingName+"&msmt_host="+msmthost+"&fullview=true&priority="+FullViewPriority+"&defaultInterface="+defaultInterface+"&infosToArea="+infosToArea+"&legendInfoCount="+legendInfo_count+"&display=false&fromInterface=false&screenWidth="+screenWidth+"&screenHeight="+screenHeight;
				}	
				if(xml!=null && !xml.equals(""))
				{
%>
		<div class="eg_8bold eg_whitebg" align="center" style="display:inline-block;padding:4px;">

					<div style="float:left;" class="eg_8bold" align="left" >
						<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="<%=tableWidth%>" height="270" id="StackedColumn3D" >
						<param name="movie" value="/final/FusionCharts/swf/MSArea.swf" />
						<param name="FlashVars" value="&dataXML=<%=xml%>&chartWidth=<%=tableWidth%>&chartHeight=270">
						<param name="quality" value="high" />
						<param name="WMode" value="Transparent">
						<embed wmode="transparent" src="/final/FusionCharts/swf/MSArea.swf" flashVars="&dataXML=<%=xml%>" quality="high" width="<%=tableWidth%>" height="270" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
						</object>
					</div>
					<div style="float:right;" valign="top">
					<a  onclick="javascript:areaChartOnClick('fusion<%=cnt%>');" href="javascript:void(0);"><img src="/final/monitor/eg_images/<%=monitor_Skin%>/icon_maximize_div.png" border="0" /></a>
					</div>
		</div>
<%
				}
				else
				{
%>
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td>
					<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
				</td>
			</tr>
		</table>
<%
				}
%>
								<input type="Hidden" id="fusion<%=cnt%>" value="<%=areaGraphUrlLarge%>"/>
<%
				}
				else
				{
%>
	<div class="eg_medium grad  ientBgVmTab" style="display:block;visibility:visible;height:22px;width:100%;">
		<div class="eg_8bold" style="float:left;padding:4px;"><egui:intnl text="Protocol distribution by bandwidth usage "/></div>
	</div>
	<div>
		<table border="0" cellpadding="0" cellspacing="0" height="270px" width="100%" class="linesquare eg_whitebg">
			<tr>
				<td align="center" valign="middle">
					<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
				</td>
			</tr>
		</table>
	</div>
<%
				}
%>
	</div>
<%
			}
			else
			{
%>

	<div class="eg_medium grad  ientBgVmTab" style="display:block;visibility:visible;height:22px;width:100%;">
		<div class="eg_8bold" style="float:left;padding:4px;"><egui:intnl text="Protocol distribution by bandwidth usage "/></div>
	</div>
	<div>
		<table border="0" cellpadding="0" cellspacing="0" height="270px" width="100%" class="linesquare eg_whitebg">
			</tr>
				<td align="center" valign="middle">
					<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.The test has been disabled" />
				</td>
			</tr>
		</table>
	</div>

<%
			}
		}
	}
%>
</div>
<%
	}
	else if(blockType!=null && blockType.equals("Flows"))
	{
		double defaultTableWidth=920;
		double tableWidth=920;
		double tableWidth1024PxInPercent=defaultTableWidth/1024;
		tableWidth=screenWidthInDouble*tableWidth1024PxInPercent;
		tableWidth=MathUtils.round(tableWidth,0);
		String tblWidth=Double.toString(tableWidth);

		double defaultChartWidth=200;
		double chartWidth=200;
		double chartWith1024PxInPercent=defaultTableWidth/1024;
		chartWidth=screenWidthInDouble*chartWith1024PxInPercent;
		chartWidth=MathUtils.round(chartWidth,0);
%>

<%
		String iniVal=(String)iniobj.getValue(compType,"Cisco_Flows_piechart");
		if(iniVal!=null )
		{
			StringTokenizer stoken=new StringTokenizer(iniVal,",");
			int j=0;
			Map tableData=new HashMap();
			String align="left";
			String px="padding-left:20px;";
			while(stoken.hasMoreTokens())
			{
				
				String testWithMeasure=stoken.nextToken();
				String s_test=testWithMeasure.substring(0,testWithMeasure.indexOf(":"));

				if(enabledTests!=null && enabledTests.contains(s_test))
				{

					String tableTitle=(String)iniobj.getValue("Dashboard_Comparison_TableTitle",s_test);
					String s_measure=testWithMeasure.substring(testWithMeasure.indexOf(":")+1,testWithMeasure.indexOf("$"));
					String tableId=testWithMeasure.substring(testWithMeasure.indexOf("$")+1);
					String msmthost=(String)allMsmtHosts.get(s_test);
					Vector currentValues=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,s_test,s_measure,msmthost,"",true,"10");
					int size=0;
					if(currentValues!=null && currentValues.size()>0)
					{
						for(int i=0;i<currentValues.size();i=i+2)
						{
							size++;
						}
					}
					StringBuffer sb=new StringBuffer();
					sb.append("Top ");
					sb.append(" ");
					sb.append(tableTitle);
					
					Vector chartAttributes=new Vector();
					//caption="Sales Per Employee for year 1996" palette="2" animation="1" formatNumberScale="0" numberPrefix="$" pieSliceDepth="30" startingAngle="125"
					//chartAttributes.add("caption='"+sb.toString()+"'");
					chartAttributes.add("decimals='2'");
					chartAttributes.add("enableRotation='1'");
					chartAttributes.add("bgColor='99CCFF,FFFFFF'");
					chartAttributes.add("bgAlpha='0,0'");
					//chartAttributes.add("bgRatio='0,100'");
					chartAttributes.add("bgAngle='360'");
					chartAttributes.add("showBorder='0'");
					chartAttributes.add("startingAngle='80'");
					//healthChartAttributes.add("baseFontColor ='545454'");//this one add in java for check the condition
					chartAttributes.add("chartLeftMargin ='0'");
					chartAttributes.add("chartTopMargin ='0'");
					chartAttributes.add("chartBottomMargin ='0'");
					chartAttributes.add("chartRightMargin ='0'");
					chartAttributes.add("showToolTipShadow ='1'");
					chartAttributes.add("pieSliceDepth='7'");
					chartAttributes.add("numberSuffix='%'");
					chartAttributes.add("showToolTipShadow ='1'");
					chartAttributes.add("pieOuterFaceAlpha  ='75'");
					chartAttributes.add("pieInnerFaceAlpha  ='100'");
					chartAttributes.add("pieYScale  ='49'");
					chartAttributes.add("smartLineColor  ='BABABA'");
					chartAttributes.add("smartLabelClearance  ='2'");
					chartAttributes.add("captionPadding  ='0'");
					chartAttributes.add("bgSWFAlpha  ='0'");
					chartAttributes.add("enableSmartLabels='1'");
					chartAttributes.add("pieRadius='80'");
					chartAttributes.add("labelDistance='3'");
					chartAttributes.add("isSmartLineSlanted='1'");
					chartAttributes.add("exportEnabled='0'");
					chartAttributes.add("exportAction='download'");
					chartAttributes.add("exportAtClient='0'");
					chartAttributes.add("showPlotBorder='1'");
					chartAttributes.add("plotBorderColor='000000'");
					chartAttributes.add("skipOverlapLabels='0'");

					chartAttributes.add("legendPosition='RIGHT'");
					chartAttributes.add("exportHandler='/final/FusionCharts/jsp/FCExporter.jsp'");
					String xml=(String)fusionChart.getXMLtoProtocol(currentValues,chartAttributes);
%>
<div style="margin:0px;padding:6px 6px 6px 6px;valign:top;display:block;">
	<div class="flowsPieChartDiv linesquare" id="flows" style="overflow:auto;display:block;">
<%

					if(xml!=null && !xml.equals(""))
					{
%>
		<div class="eg_medium grad  ientBgVmTab" style="display:block;visibility:visible;height:20px;width:100%;">
			<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="<%=sb.toString()%>"/></div>
		</div>
		<div style="clear:both;display:block;">
			<table cellpadding="4" cellspacing="0" border="0" width="100%">
				<tr>
					<td valign="top" border="0" align="center">
						<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="970" height="140" id="StackedColumn3D" flashVars="&dataXML=<chart><set value='1'/><set value='2'/></chart>" >
						<param name="FlashVars" value="&dataXML=<%=xml%>&chartWidth=970&chartHeight=140">
						<param name="quality" value="high" />
						<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
						<param name="WMode" value="Transparent">
						<embed wmode="transparent" src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xml%>" quality="high" width="970" height="140" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
						</object>
					</td>
				</tr>
			</table>
		</div>
<%
			String iniTables=(String)iniobj.getValue(compType,"Cisco_Flows_"+tableId);

			if(iniTables!=null && iniTables.length()>0)
			{
				Vector table=new Vector();
				Vector header=new Vector();
				Vector units=new Vector();
				StringTokenizer st=new StringTokenizer(iniTables,",");
				String[] names={"Sources","Destination","Conversation"};
				units.add("-");
				String comparisonTableFullViewURL=response.encodeURL("/final/monitor/egCustomDashboardp.jsp")+"?"+"compName="+EgURLEncoder.encode(compName,"UTF-8")+"&compType="+compType+"&blockType=CiscoComparisionTable&tab=Network";
				StringBuffer measureColumn=new StringBuffer();
				String fullviewTest="";
				String fullviewMsmtHost="";
				String interfaceCount_fullview="";
				int tableCount=0;
				int headerCount=0;
				while(st.hasMoreTokens())
				{
					String testMeasures=(String)st.nextToken();
					String headerName=(String)iniobj.getValue("Dashboard_TableColumn_mapping",testMeasures);
					String flows_Count=iniobj.getValue("Interfaces","flows");
					String testname=testMeasures.substring(0,testMeasures.indexOf(":"));
					String measurename=testMeasures.substring(testMeasures.indexOf(":")+1);
					String measureForDB=dbinfo.getColumnForMeasure(testname,measurename);
					String unit=tablesInfo.getUnitForMeasure(testname,measurename);
					String msmt_host=(String)allMsmtHosts.get(testname);
				
					fullviewTest=testname;
					fullviewMsmtHost=msmt_host;
					interfaceCount_fullview=flows_Count;
					measureColumn.append(measureForDB);
					if(st.hasMoreTokens())
						measureColumn.append(",");
					//newly added
					
					Vector currentValues1=(Vector)dashboardDAO.getCurrentForAllInfos(hostName,portNo,testname,measureForDB,msmt_host,"",true,flows_Count);
					String key="table"+j;
					table.add(currentValues1);
					if(tableCount==0)
					{
						header.add(names[j]);
					}

					header.add(headerName);
					units.add(unit);
					tableCount++;
					headerCount++;
				}
				int imgcnt=0;
				int stColPos=1;
				int endColPos=5;
				if(j<=1)
				{
					endColPos=4;
				}
				String rsTableName="rsTableflows"+j;
				comparisonTableFullViewURL+="&test="+fullviewTest+"&measure="+measureColumn+"&msmtHost="+fullviewMsmtHost+"&interfaces_Count="+interfaceCount_fullview+"&fromInterface=false&headerList="+header+"&inilookup=Cisco_Flows_"+tableId;
%>

		<div style="clear:both;display:block;" id="flowsTableDiv">
			<table cellpadding="0" cellspacing="0" border="0" valign="top" width="100%">
				<tr>
					<td class="space10" width="100%"> 
						<table cellpadding="0" cellspacing="0" border="0" valign="top" width="100%" class="linesquare">
							<tr>
								<td width="100%" valign="top" class="gradient_header" style="border-left-width:0px;border-right-width:0px;border-bottom-width:1px;">
									<table border="0" cellspacing="0" cellpadding="0"  width="100%" height="100%" >
										<tr>
											<td class="eg_75bold" height="20px" style="padding-left:4px;border-right-width:0px">
												<egui:intnl text="Details"/>
											</td>


										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td style="padding:0px" width="100%" >
									<table cellspacing="0" cellpadding="4" class="tableborder_jvm flowsDivClass"  border="0" width="100%" id="flowsTable<%=j%>">
										<thead>
											<tr>
<%
		for(int k=0;k<header.size();k++)
		{
			String h_unit=(String)units.get(k);
			if(h_unit.equals("-"))
				h_unit="";
%>
<%
			if(k==0)
			{
%>
												<td class="eg_75bold tdborder2_jvm" wrap><div style="float:left"> <a class="eg_monlink" href="" onclick="this.blur();return sortCiscoTable('<%=rsTableName%>',<%=k%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','flows','<%=j%>');"><span class="eg_75bold"><%=(String)header.get(k)%> <%=h_unit%></a></span></div>
												<div style="float:left;padding:2px 2px 2px 4px">
												<img id="imgdd<%=j%><%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortCiscoTable('<%=rsTableName%>',<%=k%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','flows','<%=j%>');" style="display:none"/> </div></td>
<%
			}
			else
			{
%>
												<td class="eg_75bold tdborder2_jvm" wrap><div style="float:left"> <a class="eg_monlink" href="" onclick="this.blur();return sortCiscoTable('<%=rsTableName%>',<%=k%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','flows','<%=j%>');"><span class="eg_75bold"><%=(String)header.get(k)%> (<%=h_unit%>)</a></span></div>
												<div style="float:left;padding:2px 2px 2px 4px">
												<img id="imgdd<%=j%><%=(imgcnt+1)%>" src="/final/monitor/eg_images/arrow_down_black_small.gif" onclick="this.blur();return sortCiscoTable('<%=rsTableName%>',<%=k%>,<%=stColPos%>,<%=endColPos%>,'<%=(imgcnt+1)%>','flows','<%=j%>');" style="display:none"/> </div></td>
<%
			}
%>
												

<%
			imgcnt++;
		}
%>
											</tr>
										</thead>
										<tbody name="<%=rsTableName%>" id="<%=rsTableName%>">
<%
		if(table!=null && table.size()>0)
		{
			Map map=new HashMap();
			for(int i=0;i<table.size();i++)
			{
				Vector measureVector=(Vector)table.get(i);
				
				if(measureVector!=null && measureVector.size()>0)
				{
					for(int m=0;m<measureVector.size();m=m+2)
					{
						String info=(String)measureVector.get(m);
						String value=(String)measureVector.get(m+1);
						if(map!=null && map.containsKey(info))
						{
							List existingList=(ArrayList)map.get(info);
							existingList.add(value);
							map.put(info,existingList);
						}
						else
						{
							List list=new ArrayList();
							list.add(value);
							map.put(info,list);
						}
					}
				}
			}
			
			if(map!=null && !map.isEmpty())
			{
				Iterator itr=map.keySet().iterator();
				int m=0;
				while(itr.hasNext())
				{
					String infos=(String)itr.next();
%>
											<tr id="selectedflowsTable<%=j%>tr<%=m%>">
												<td valign="top"  align="left" style="border-left-width:1px;border-right-width:0px;" wrap> <%=com.egurkha.util.StringUtils.replace(infos, "+", "")%> </td>
<%
					List valueList=(ArrayList)map.get(infos);
					if(valueList!=null && valueList.size()>0)
					{
						for(int i=0;i<valueList.size();i++)
						{
							String val=(String)valueList.get(i);
							if(val.startsWith("-"))
								val="-";
%>
												<td valign="top"  align="left"  style="border-left-width:1px;border-right-width:0px;" wrap><%=val%></td>
<%
						}
					}
					m++;
%>
											</tr>
<%
				}
			}
		}
%>
										</tbody>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</div>
		<img src="/final/monitor/eg_images/spacer.gif" height="0px" width="0px" border="0px" onload="this.blur();return sortCiscoTable('<%=rsTableName%>',0,1,5,4,'flows','<%=j%>');" style="visibility:hidden;display:none;">
<%
		}
%>

<%
					}
					else
					{
%>
		<div class="eg_medium grad  ientBgVmTab" style="display:block;visibility:visible;height:20px;width:100%;">
			<div class="eg_8bold" style="float:left;padding:2px"><egui:intnl text="<%=sb.toString()%>"/></div>
		</div>
		<div class="eg_8bold" align="center">
			<table border="0" cellpadding="0" cellspacing="0" height="130px">
				<tr>
					<td align="center" valign="middle">
						<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.No Measures Available" />
					</td>
				</tr>
			</table>
		</div>
			
<%
					}
%>
	
</div>
</div>
<%

				}
				else
				{
%>
<div class="eg_8bold" align="center">
	<table border="0" cellpadding="0" cellspacing="0" height="100%">
		<tr>
			<td align="center" valign="middle">
				<img src="/final/monitor/eg_images/exclamation-icon.gif"><br><egui:intnl text="monitor.common.The test has been disabled" />
			</td>
		</tr>
	</table>
</div>
<%
					break;
				}
			j++;
			}
		}
	}
	if(request.getQueryString()!=null)
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&"+request.getQueryString()+"&comptype="+request.getParameter("compType")+"&host="+request.getParameter("hostName")+"&tab="+tab+"&graphType=&toDashBoardLayer=true");
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
	else
	{
		if(session!=null)
		{
			session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgDashboardController?from=list&tab="+tab+"&toDashBoardLayer=true&ciscoSelectedType="+ciscoSelectedType);
			session.setAttribute("monitorDashBrdLastCompName",request.getParameter("hostName"));
		}
	}
}
catch(Exception e)
{
	e.printStackTrace();
}
%>

