<%
/**
 *	File name		: eGBTMSummary.jsp
 *	Purpose			: This page shows the call graph of a web request in HTML Table Tree view
 *	Version			: eG 6.0
 *	Creation Date	: 30-Apr-2014
 *	Author			: Mr.R and Mr.Balraj
 */
%>
<%@ include file= "EgMonitorTracker.jsp"%> 
<%@ page import="com.eg.*"%>
<%@ page import="com.eg.EgDiscInfo"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.util.EgSorter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import="net.sf.json.*" %>
<%@ page import="java.util.*"%>
<%@ page import="java.lang.*"%>
<%@ page import="java.sql.*"%>
<%@ page import = "java.text.*" %>
<%@ page import="com.egurkha.*"%>
<%@ page import = "java.math.*"%>
<%@ page import = "com.egurkha.monitor.VMDesktopBean" %>
<%@ page import = "com.egurkha.monitor.alarms.AlarmPriorities" %>

<%
	EgAPMInfo apm = new EgAPMInfo("manager");
	String testName = request.getParameter("testName");
	String apmType = apm.getAPMType(testName);
%>
 <%!
	// String Constants
	String asyncThreadStr = "asyncThread";
	String summaryTabStr = "Summary";
	String hotSpotTabStr = "HotSpot";
	String externalDetailsTabStr = "ExternalDetails";
	String errorDetailsTabStr = "ErrorDetails";
	String popupDetailsClickStr = "HttpWebJms";
	String userExperienceHealthyStr = "Healthy";
	String userExperienceSlowStr = "Slow";
	String userExperienceStalledStr = "Stalled";
	String userExperienceErrorStr = "Error";
	String seperatorHash = "#";
	//String seperatoratAtTheRate = "@";
	//String seperatorEquals = "=";
	String seperatorHyphen = "-";
	String seperatorTilt = "~";
	String sessionExternalData = "ExternalData";
	String sessionSummaryData = "SummaryData";
	EgDiscInfo discInfo = new EgDiscInfo("manager");
	String managedDbNickName = "-";

	private Hashtable getLdapDetailsTable(ArrayList temp, ArrayList ldapDetails, Hashtable ldapDataTable, double totalResTime, DecimalFormat dft, int ldapMethodCount) {
		try {
			String methodDetails = (String)temp.get(6);
	
			if (ldapDataTable.containsKey(methodDetails)){
				ldapDetails = (ArrayList)ldapDataTable.get(methodDetails);
				if (ldapDetails != null && ldapDetails.size() > 0){
					String methodName = (String)ldapDetails.get(0);
					int methodTotCount = (Integer)ldapDetails.get(1);
					int methodTime = ((BigDecimal)ldapDetails.get(2)).intValue();
					methodTime = methodTime + ((BigDecimal)temp.get(7)).intValue();
					//double methodPercent = (Double)ldapDetails.get(3); 
					//Not going to do anything with else part percent. In if part itself, calculating percent.
					double timeInPercent = 0.0;
					try {
						timeInPercent = Double.parseDouble (dft.format((methodTime/totalResTime)*100));
					} catch(Exception ex){
						System.err.println("Exception While parsing String to Double for LDAP call type "+ex.getMessage());
					}

					ldapMethodCount = methodTotCount + 1;
					BigDecimal methodTimeInBigDecimal = new BigDecimal(methodTime);
					ldapDetails.clear();
					ldapDetails.add(methodName);
					ldapDetails.add(ldapMethodCount);
					ldapDetails.add(methodTimeInBigDecimal);
					ldapDetails.add(timeInPercent);
					ldapDataTable.put(methodDetails, ldapDetails);
				}
			} else{
				ldapMethodCount = 1;
				ldapDetails = new ArrayList();
				ldapDetails.add(methodDetails);
				ldapDetails.add(ldapMethodCount);
				ldapDetails.add(temp.get(7));//time
				double percent = 0.0;
				try {
					percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
				}
				catch (Exception ex){
					System.err.println("Exception While parsing String to Double for LDAP call type "+ex.getMessage());
					//ex.printStackTrace();
				}
				ldapDetails.add(percent);//percent
				ldapDataTable.put(methodDetails, ldapDetails);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return ldapDataTable;
	}
	
	public  Boolean isComponentManaged(String dbname,String ip,String port,String sid)
	{
		if(dbname == null){
			return false;
		}
		Boolean result = false;
		Vector componentDetails = discInfo.getAllManagedComponents();
		if(componentDetails != null && componentDetails.size()>0)
		{
			try
			{
				Iterator it = componentDetails.iterator();
				while(it.hasNext()) 
				{
					String Components = (String)it.next();
					if(Components != null && Components.contains(dbname))
					{
						String[] managedComponents = Components.split(",");
						if(managedComponents != null && managedComponents.length == 5)
						{
							if((dbname.equals(managedComponents[0])) && (ip.equals(managedComponents[1])) && (port.equals(managedComponents[3])) && (sid.equals(managedComponents[4]))){
								managedDbNickName = managedComponents[2];
								result = true;
								break;
							}
						}
						else if(managedComponents != null && managedComponents.length == 4)
						{
							if((dbname.equals(managedComponents[0])) && (ip.equals(managedComponents[1])) && (port.equals(managedComponents[3]))){
								managedDbNickName = managedComponents[2];
								result = true;
								break;
							}
						}
					}
				}
			}
			catch (Exception e)
			{
				System.err.println("Exception in eGBTMSummary.jsp : "+e.getMessage());
				//e.printStackTrace();
			}
		}
		return result;
	}

	/*public String escapeHTML (String string) {
		String escapedTxt = "";
		char tmp = ' ';
		for(int i = 0; i < string.length(); i++) {
			tmp = string.charAt(i);
			switch (tmp) {
				case '<':
					escapedTxt += "&lt;";
					break;
				case '>':
					escapedTxt += "&gt;";
					break;
				case '"':
					escapedTxt += "&quot;";
					break;
				case '\'':
					escapedTxt += "&#x27;";
					break;
				case '/':
					escapedTxt += "&#x2F;";
					break;
				default:
					escapedTxt += tmp;
			}
		}
		return escapedTxt;
	}*/

	public String escapeHTML(String value) {
		if (value == null) return null;

		int length = value.length();
		String encoded;

		for (int i = 0; i < length; i++) {
			char c = value.charAt(i);

			if (c <= 62 && (encoded = getHtmlEntity(c)) != null) {
				// We found a character to encode, so we need to start from here and buffer the encoded string.
				StringBuilder sb = new StringBuilder((int) (length * 1.25));
				sb.append(value.substring(0, i));
				sb.append(encoded);

				i++;

				for (; i < length; i++) {
					c = value.charAt(i);

					if (c <= 62 && (encoded = getHtmlEntity(c)) != null) {
						sb.append(encoded);
					} else {
						sb.append(c);
					}
				}

				value = sb.toString();
				break;
			}
		}
		value = BTMHelper.decodeUrlString(value);
		return value;
	}

	private static String getHtmlEntity(char c) {
		switch (c) {
			case '\'': return "&#x27;";
			case '"': return "&quot;";
			case '<': return "&lt;";
			case '>': return "&gt;";
			case '/': return "&#x2F;";
			default: return null;
		}
	}
	public double getDoubleFromBigDecimalValue(Object value) 
	{
		double tempValueToBeReturned = 0.0;
		try{
				tempValueToBeReturned = ((BigDecimal)value).doubleValue();
		}catch(Exception e)
		{
			System.out.println("Exception while parsing the value "+e);
		}
		return tempValueToBeReturned ;
	}

	public double getDoubleValue(Object value)
	{
		double tempValueToBeReturned = 0.0;
		try{
				tempValueToBeReturned = Double.parseDouble(value.toString());
		}
		catch(Exception e)
		{
			System.out.println("Exception while parsing the value "+e);
		}
		return tempValueToBeReturned ;
	}
%>

<%

	DecimalFormat df = new DecimalFormat(seperatorHash);
	DecimalFormat dft = new DecimalFormat("#.##");
	//EgDiscInfo discInfo = new EgDiscInfo("manager");
	//String businessTransTest = "BusinessTransTest";
	String trgt_Host = null ; 
	String portNo = null ;
	String url = null ; 
	String lbl_Healthy = mappingInfo.getTextDescription("monitor.apmtopology.Healthy");
	String lbl_Slow = mappingInfo.getTextDescription("monitor.apmtopology.Slow");
	String lbl_Stalled = mappingInfo.getTextDescription("monitor.apmtopology.Stalled");
	String lbl_Error = mappingInfo.getTextDescription("monitor.apmtopology.Error");

	String uiFile = "eg_ui.ini";
	String apmFile = "eg_apm.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	IniFile egApm = new IniFile(s_iniFile_dir + apmFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String buttonClicked = request.getParameter("buttonClicked");
	String guidString = request.getParameter("EG_GUID");
	String asyncGuid = request.getParameter("asyncGuid");
	String nodeOrder = request.getParameter("nodeOrder");
	String requestType = request.getParameter("requestType");
	String isAsyncThread = request.getParameter("isAsyncThread");
	String timeString = request.getParameter("timeString");
	String allColumns = egApm.getValue("SUMMARY_DATA_FOR_TEST","ALL_COLUMNS_LIST");
	ArrayList allColumnList = StringUtils.egTokenizer(allColumns,",");
	ArrayList summaryDataList = (ArrayList) session.getAttribute(sessionSummaryData);
	Hashtable summaryDataDetails = new Hashtable() ; 
	String keys = guidString+seperatorHash+nodeOrder;
	ArrayList summaryWholeData = null ; 
	if(summaryDataList != null && summaryDataList.size()>0)
	{
		summaryDataDetails = (Hashtable) summaryDataList.get(0);
		summaryWholeData = (ArrayList) summaryDataDetails.get(keys);
		trgt_Host = (String) summaryWholeData.get(allColumnList.indexOf("TRGT_HOST"));
		portNo = (String) summaryWholeData.get(allColumnList.indexOf("PORT_NO"));
		url = (String) summaryWholeData.get(allColumnList.indexOf("URL"));
	}
	String jvmComp = trgt_Host+":"+portNo;
	String compType=discInfo.getServerTypesForComponentNamePort(jvmComp);
	String compName = mappingInfo.getComponentTypeDescription(compType);
	response.setContentType("text/html;charset=UTF-8");
	JSONObject rootJson = new JSONObject();
	BTMHelper btmHelperObj = new BTMHelper();
	try
	{
		if(buttonClicked != null)
		{
			// For Summary Tab Clicked
			if(buttonClicked.equalsIgnoreCase(summaryTabStr))
			{
				
				if(summaryDataList != null && summaryDataList.size()>0)
				{
					String overAllExperience = (String) summaryDataList.get(4);
					if(overAllExperience.equalsIgnoreCase(userExperienceErrorStr))
						overAllExperience = lbl_Error;
					else if(overAllExperience.equalsIgnoreCase(userExperienceStalledStr))
						overAllExperience = lbl_Stalled;
					else if(overAllExperience.equalsIgnoreCase(userExperienceSlowStr))
						overAllExperience = lbl_Slow;
					else if(overAllExperience.equalsIgnoreCase(userExperienceHealthyStr))
						overAllExperience = lbl_Healthy;
					String transName = "";
					
					if(summaryDataDetails != null)
					{
						if(summaryWholeData != null && summaryWholeData.size()>0)
						{
							int thisNodeSelfTime = 0;
							
							if(timeString != null && timeString.length()>0)
							{
								StringTokenizer slfTimeTokenizer = new StringTokenizer(timeString,seperatorTilt);
								while(slfTimeTokenizer.hasMoreTokens())
								{
									String nodeOrderWithValue = slfTimeTokenizer.nextToken();
									if(nodeOrderWithValue != null && nodeOrderWithValue.indexOf(seperatorHyphen)>-1)
									{
										String tknzrNode = nodeOrderWithValue.substring(0,nodeOrderWithValue.indexOf(seperatorHyphen));
										if(tknzrNode != null && tknzrNode.equals(nodeOrder))
										{
											String thisstrNodeSelfTime = nodeOrderWithValue.substring(nodeOrderWithValue.indexOf(seperatorHyphen)+1);
											thisNodeSelfTime = Integer.parseInt(thisstrNodeSelfTime);
											break;
										}
									}
								}
							}
							double resTime = 0.0;
							
							String apmIdentifier = (String) summaryWholeData.get(allColumnList.indexOf("TEST_NAME"));
							String apmColumns = egApm.getValue("SUMMARY_DATA_FOR_TEST",apmIdentifier.toUpperCase());
							ArrayList apmColumnList = StringUtils.egTokenizer(apmColumns,",");
							String threadDetail = (String) summaryWholeData.get(allColumnList.indexOf("Thread ID"));
							String info = "-";
							String threadName = "-";
							String threadId = threadDetail;
							String title = "";
							boolean isJava = apmType.equalsIgnoreCase("Java");
							/*  This code written for specific logic common to Both the tests */
							 if(isJava)
							{
								threadName = threadDetail.substring(0, threadDetail.lastIndexOf("["));
								threadId = threadDetail.substring(threadDetail.lastIndexOf("["));
							}
							double slowUrlThreshold = getDoubleFromBigDecimalValue(summaryWholeData.get(allColumnList.indexOf("SLOW_URL_THRESHOLD")));
							double stalledUrlThreshold =getDoubleFromBigDecimalValue(summaryWholeData.get(allColumnList.indexOf("STALLED_URL_THRESHOLD"))); 
							//Summay Page Grid Table data preparation starts here
							String compTypeFromNickPort = discInfo.getServerTypesForComponentNamePort(trgt_Host+":"+portNo);
							JSONObject tmpObj = new JSONObject();
							JSONArray gridData = new JSONArray();
							
							for(int i = 0 ; i< apmColumnList.size() ; i++)
							{
								String valueToBeAddedInJsonObject = "-";
								String dataTobeInserted  = (String)apmColumnList.get(i) ;
;								int indexToBeFetchedFromAllColums = allColumnList.indexOf(dataTobeInserted);
								String keyForJson = mappingInfo.getTextDescription("monitor.apmtopology."+dataTobeInserted ); 
								if(indexToBeFetchedFromAllColums > -1)
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+summaryWholeData.get(indexToBeFetchedFromAllColums)+"</span>" ;
								if(dataTobeInserted.equalsIgnoreCase("URL"))
								{
									if(isAsyncThread != null && isAsyncThread.equals(asyncThreadStr))
									{
										valueToBeAddedInJsonObject = "<span class='font_bold11'>Async Call from "+summaryWholeData.get(indexToBeFetchedFromAllColums)+"</span>";
									}
								}
								else if(dataTobeInserted.equalsIgnoreCase("Request Time"))
								{
									String managerTimeFormat = DateUtil.changeDateFormat(summaryWholeData.get(indexToBeFetchedFromAllColums).toString(),"yyyy-MM-dd HH:mm:ss",currentDateFormat+" HH:mm:ss");
									String timeZone = (String) summaryWholeData.get(allColumnList.indexOf("TIME_ZONE"));
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+managerTimeFormat+" "+timeZone+"</span>";
								}
								else if(dataTobeInserted.equalsIgnoreCase("Business Transaction"))
								{
									int infoIndex = allColumnList.indexOf(dataTobeInserted);
									info = (String) summaryWholeData.get(infoIndex);
									if(nodeOrder != "1")
									{
										summaryDataDetails = (Hashtable) summaryDataList.get(0);
										if(summaryDataDetails.containsKey(guidString+"#1"))
										{
											ArrayList startNode = (ArrayList) summaryDataDetails.get(guidString+"#1");
											if(startNode != null)
											{
												info = startNode.get(infoIndex).toString();
											}
										}
									}
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+info.substring(1)+"</span>" ;
								}
								else if(dataTobeInserted.equalsIgnoreCase("User Experience (Overall)"))
								{
									String userExpIconOverall = "BTM_transaction_state_"+overAllExperience;
									if(overAllExperience.equals(userExperienceHealthyStr))
										userExpIconOverall = "BTM_transaction_state_Normal";
									valueToBeAddedInJsonObject = "<div style='float:left;height:20px;padding-top:1px';class='btmDisplayFieldCompValueEllipsis' data-qclass='yellowTip para' data-qtip="+overAllExperience+"><img src='../images/Light/"+overAllExperience.toLowerCase()+".png'></div>";
									if(monitor_Skin.equals("Dark"))
									{
										valueToBeAddedInJsonObject = "<div style='float:left;height:20px;padding-top:1px';class='btmDisplayFieldCompValueEllipsis' data-qclass='yellowTip para' data-qtip="+overAllExperience+"><img src='../images/Dark/"+overAllExperience.toLowerCase()+".png'></div>";
									}
								}
								else if(dataTobeInserted.equalsIgnoreCase("APM_TYPE"))
								{
									transName = "";
									String thisNodeHealth = null;
									String tmp = mappingInfo.getTextDescription("monitor.apmtopology.Processing Status on ");
									String trghost = trgt_Host+":"+portNo;
									if(portNo != null && portNo.equals("NULL"))
									{
										 trghost = trgt_Host;
									}
									keyForJson = mappingInfo.getTextDescription("monitor.apmtopology."+apmType)+" "+tmp+" "+trghost;
									if (testName != null)
										thisNodeHealth = mappingInfo.getMeasureDescription(testName , summaryWholeData.get(allColumnList.indexOf("Business Transaction")).toString());
									if(thisNodeHealth != null && thisNodeHealth.equals("Error transactions"))
									{
										transName = lbl_Error;
									}
									else
									{
										transName = (thisNodeSelfTime>slowUrlThreshold)?((thisNodeSelfTime>stalledUrlThreshold)?lbl_Stalled:lbl_Slow):lbl_Healthy;
									}
									valueToBeAddedInJsonObject =  "<div style='float:left;height:20px;padding-top:1px';class='btmDisplayFieldCompValueEllipsis' data-qclass='yellowTip para' data-qtip="+transName+"><img src='../images/Light/"+transName.toLowerCase()+".png'></div>";

									
									if(monitor_Skin.equals("Dark"))
									{
										valueToBeAddedInJsonObject = "<div style='float:left;height:20px;padding-top:1px';class='btmDisplayFieldCompValueEllipsis' data-qclass='yellowTip para' data-qtip="+transName+"><img src='../images/Dark/"+transName.toLowerCase()+".png'></div>";
									}
								}
								else if(dataTobeInserted.equalsIgnoreCase("Total Processing Time"))
								{
									resTime = getDoubleValue(summaryWholeData.get(indexToBeFetchedFromAllColums));
									valueToBeAddedInJsonObject = (resTime>stalledUrlThreshold)? "<span class='font_bold11'>"+df.format(resTime)+" ms (Transaction was slower than the stalled threshold of "+df.format(summaryWholeData.get(allColumnList.indexOf("STALLED_URL_THRESHOLD")))+" ms)</span>" : (resTime>slowUrlThreshold)? "<span class='font_bold11'>"+df.format(resTime)+" ms (Transaction was slower than the slow threshold of "+df.format(summaryWholeData.get(allColumnList.indexOf("SLOW_URL_THRESHOLD")))+" ms)</span>" : "<span class='font_bold11'>"+df.format(resTime)+" ms (Transaction was executed within the slow/stalled threshold of "+df.format(summaryWholeData.get(allColumnList.indexOf("SLOW_URL_THRESHOLD")))+"/"+df.format(summaryWholeData.get(allColumnList.indexOf("STALLED_URL_THRESHOLD")))+" ms respectively)</span>" ; 

								}
								else if(dataTobeInserted.equalsIgnoreCase("Component"))
								{
									title = "Call Drill Down for "+url+ " on "+trgt_Host+":"+portNo;
									valueToBeAddedInJsonObject="<span class='font_bold11'>"+trgt_Host+":"+portNo+"</span>";
									rootJson.put("componentLookupData","<div style='float:left'>"+"Component"+" : </div><div style='float:left;width:80%'; class='btmDisplayFieldCompValueEllipsis' data-qclass='yellowTip para' data-qtip='"+trgt_Host+":"+portNo+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")"+"'>"+trgt_Host+":"+portNo+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")"+"</div>");
									
									if(portNo != null && portNo.equals("NULL"))
									{
										title = "Call Drill Down for "+url+ " on "+trgt_Host;
										valueToBeAddedInJsonObject="<span class='font_bold11'>"+trgt_Host+"</span>";
										rootJson.put("componentLookupData","<div style='float:left'>"+"Component"+" : </div><div style='float:left;width:80%'; class='btmDisplayFieldCompValueEllipsis'  data-qclass='yellowTip para' data-qtip='"+trgt_Host+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")"+"'>"+trgt_Host+" ("+mappingInfo.getComponentTypeDescription(compTypeFromNickPort)+")"+"</div>");
									}
								}
								else if(dataTobeInserted.equalsIgnoreCase("Query String"))
								{
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+ BTMHelper.decodeUrlString(summaryWholeData.get(indexToBeFetchedFromAllColums).toString())+"</span>";
								}
								else if(dataTobeInserted.equalsIgnoreCase("Thread Name"))
								{
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+threadName+"</span>";
								}
								else if(dataTobeInserted.equalsIgnoreCase("Thread ID"))
								{
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+threadId+"</span>";
								}
								else if(dataTobeInserted.equalsIgnoreCase("Transaction Threshold"))
								{
									valueToBeAddedInJsonObject =  "<span class='font_bold11' >"+df.format(summaryWholeData.get(allColumnList.indexOf("SLOW_URL_THRESHOLD")))+" ms</span>" ; 
								}
								else if(dataTobeInserted.equalsIgnoreCase("Request GUID"))
								{
									valueToBeAddedInJsonObject = "<span class='font_bold11' >"+guidString+"</span>" ;
								}
								else if(dataTobeInserted.equalsIgnoreCase("CPU_TIME"))
								{
									double  cpuPercentage = 0.0;
									try 
									{
										valueToBeAddedInJsonObject  = "<span class='font_bold11'>"+"-"+"</span>";
										double tmpTiming = Double.parseDouble(summaryWholeData.get(indexToBeFetchedFromAllColums).toString());
										if(tmpTiming >=0 && resTime>0)
										{
											cpuPercentage = ((Double.parseDouble(summaryWholeData.get(indexToBeFetchedFromAllColums).toString()))/resTime)*100;
											valueToBeAddedInJsonObject  = "<span class='font_bold11'>"+df.format(tmpTiming)+" ms ("+dft.format(cpuPercentage)+" %)</span>";
										}
									}
									catch (Exception ex)
									{
										System.out.println("Exception occured while parsing the value ");
									}
								}else if(dataTobeInserted.equalsIgnoreCase("BLOCK_TIME") || dataTobeInserted.equalsIgnoreCase("WAIT_TIME"))
								{
									try
									{
										valueToBeAddedInJsonObject  = "<span class='font_bold11'>"+"-"+"</span>";
										double tmpTiming = Double.parseDouble(summaryWholeData.get(indexToBeFetchedFromAllColums).toString());
										if(tmpTiming>=0.0)
											valueToBeAddedInJsonObject = "<span class='font_bold11'>"+df.format(tmpTiming)+" ms</span>";
									}catch(Exception e)
									{
										System.out.println("Exception occured while parsing the value ");
										
									}
								}
								else if(dataTobeInserted.equalsIgnoreCase("Pre Processing Time"))
								{
									double preProcessingTime = getDoubleFromBigDecimalValue(summaryWholeData.get(indexToBeFetchedFromAllColums)); 
									valueToBeAddedInJsonObject = "<span class='font_bold11'>"+df.format(preProcessingTime)+" ms</span>" ;
								}

								tmpObj.put("A",keyForJson);
								tmpObj.put("B",valueToBeAddedInJsonObject);
								gridData.add(tmpObj);
								tmpObj = new JSONObject();
							}
							String topologyWindowTitle = mappingInfo.getMeasureDescription(testName , summaryWholeData.get(2).toString()+":"+info.substring(1));
							rootJson.put("gridData",gridData);
							rootJson.put("title",title+"^%^"+topologyWindowTitle);
							rootJson.put("SummaryDataPresence", "yes");
							//Summay Page Grid Table data preparation ends here
							//Summary Page Top LHS panel data starts
							rootJson.put("totalProcessTimeLookupData","<div style='float:left'>"+"Total Processing time"+" : </div><div style='float:left'><span class='btmDisplayFieldValue' >"+df.format(resTime)+" ms</span></div>");

							rootJson.put("urlLookupData","<div style='float:left;'>"+"URL"+" : </div><div style='float:left;width:350px' class='btmDisplayFieldURLValueEllipsis' data-qclass='yellowTip para' data-qtip='"+url+"'>"+url+"</div>");

							String javaExecString = "<p style='white-space:nowrap;text-overflow:ellipsis;overflow: hidden;'>"+ mappingInfo.getTextDescription("monitor.apmtopology."+apmType) +" (this node) </p><p class='value1'>"+thisNodeSelfTime+"<span class='ms1'> ms </span></p>";
							rootJson.put("javaExecTimeData",javaExecString);

							String ExternalExecString = "<p style='white-space:nowrap;text-overflow:ellipsis;overflow: hidden;'>Remote Calls (database, others)</p><p class='value2'>"+((int)resTime-thisNodeSelfTime)+"  <span class='ms2'> ms </span></p>";
							rootJson.put("externalExecTimeData",ExternalExecString);
							//Summary Page Top LHS panel data ends


							// Pie Chart Json Formation Starts Here

							JSONObject pieDatarootJson = new JSONObject();

							JSONObject chartDataObj = new JSONObject();
							JSONObject chartDataObj2 = new JSONObject();
							JSONObject chartDataObj3 = new JSONObject();
							ArrayList arlistObj = new ArrayList();
							arlistObj.add(3);
							arlistObj.add(0);
							arlistObj.add(32);
							arlistObj.add(0);
							chartDataObj.put("type","pie");
							chartDataObj.put("plotBackgroundColor",null);
							chartDataObj.put("plotBorderWidth",null);
							chartDataObj.put("plotShadow",false);
							chartDataObj.put("backgroundColor","transparent");
							chartDataObj.put("margin",arlistObj);
							chartDataObj.put("reflow",true);
							pieDatarootJson.put("chart",chartDataObj);
							chartDataObj = new JSONObject();

							chartDataObj.put("text","");
							chartDataObj2.put("color", "#5e5e5e");
							chartDataObj2.put("fontWeight", "bold");
							chartDataObj2.put("font-size", "13px");
							chartDataObj2.put("font-family", "LucidaGrandeBold !important");
							chartDataObj.put("style",chartDataObj2);
							pieDatarootJson.put("title",chartDataObj);
							chartDataObj = new JSONObject();
							chartDataObj2 = new JSONObject();

							chartDataObj.put("enabled",false);
							pieDatarootJson.put("credits",chartDataObj);
							chartDataObj = new JSONObject();

							chartDataObj.put("enabled",false);
							pieDatarootJson.put("exporting",chartDataObj);
							chartDataObj = new JSONObject();

							chartDataObj.put("allowPointSelect", true);
							chartDataObj.put("cursor", "pointer");
							chartDataObj2.put("enabled",true);
							chartDataObj2.put("distance",15);
							chartDataObj2.put("format","{point.percentage:.0f}%");
							if(monitor_Skin.equals("Dark"))
								chartDataObj2.put("color","#c6c6c6");
							chartDataObj.put("dataLabels", chartDataObj2);
							chartDataObj.put("showInLegend",true);
							chartDataObj2 = new JSONObject();

							//chartDataObj2.put("legendItemClick", "function(e){e.preventDefault();}");
							chartDataObj2.put("legendItemClick", "function(){this.select();chart.tooltip.refresh(this); return false;}");
							chartDataObj3.put("events",chartDataObj2);
							chartDataObj.put("point",chartDataObj3);
							chartDataObj3 = new JSONObject();

							chartDataObj.put("startAngle",90);
							if(monitor_Skin.equals("Dark"))
								chartDataObj.put("borderColor","#444444");
							chartDataObj3.put("pie",chartDataObj);
							pieDatarootJson.put("plotOptions",chartDataObj3);
							chartDataObj = new JSONObject();
							chartDataObj2 = new JSONObject();
							chartDataObj3 = new JSONObject();

							chartDataObj.put("enabled",true);
							chartDataObj.put("layout","horizontal");
							chartDataObj.put("x",-10);
							chartDataObj.put("y",-5);
							chartDataObj.put("symbolWidth",10);
							chartDataObj.put("symbolHeight",10);

							chartDataObj2.put("font","normal 11px LucidaGrandeRegular !important");
							if(monitor_Skin.equals("Dark"))
							{
								chartDataObj2.put("color","#c6c6c6");
								chartDataObj.put("itemHoverStyle",chartDataObj2);
							}
							chartDataObj.put("itemStyle",chartDataObj2);
							chartDataObj.put("labelFormatter","function() { return this.name.length>15?this.name.slice(0, 15)+'..':this.name}");
							pieDatarootJson.put("legend",chartDataObj);
							chartDataObj = new JSONObject();
							chartDataObj2 = new JSONObject();

							chartDataObj.put("pointFormat", "<b>{point.y} ms</b>({point.percentage:.2f}%)<br/>");
							pieDatarootJson.put("tooltip",chartDataObj);
							chartDataObj = new JSONObject();

							ArrayList seriesHolder = new ArrayList();
							ArrayList tempDataList = new ArrayList();
							if(portNo != null && portNo.equals("NULL"))
								chartDataObj2.put("name", summaryWholeData.get(0));
							else
								chartDataObj2.put("name", summaryWholeData.get(0)+":"+portNo);
							chartDataObj2.put("y", thisNodeSelfTime);
							chartDataObj2.put("color", "#115fa6");
							tempDataList.add(chartDataObj2);
							chartDataObj3.put("name", "Others");
							chartDataObj3.put("y", (int)resTime-thisNodeSelfTime);
							chartDataObj3.put("color", "#e9a645");
							tempDataList.add(chartDataObj3);
							chartDataObj.put("data",tempDataList);
							seriesHolder.add(chartDataObj);
							pieDatarootJson.put("series",seriesHolder);
							chartDataObj = new JSONObject();
							chartDataObj2 = new JSONObject();
							chartDataObj3 = new JSONObject();

							rootJson.put("pieDatarootJson",pieDatarootJson);
							//System.out.println("PIE Chart RootJson : "+pieDatarootJson);
							// Pie Chart Json Formation Ends Here

						}
						else
						{
							rootJson.put("SummaryDataPresence", "no");
						}
						out.println(rootJson.toString());
					}
				}
			}
			// HotSpot Tab data preparation starts here
			else if(buttonClicked.equals(hotSpotTabStr))
			{
				ArrayList hotSpotDetails = (ArrayList) session.getAttribute("HotSpotData"+seperatorHash+nodeOrder);
				ArrayList traceDetails = (ArrayList) session.getAttribute("TraceData"+seperatorHash+nodeOrder);
				boolean isPartialGraph = false;
				if(traceDetails != null && traceDetails.size()>0)
				{
					String rootNode = (String) traceDetails.get(0);
					if(rootNode.startsWith("0#="))
					{
						isPartialGraph = false;
					}
					else
					{
						isPartialGraph = true;
					}
				}
				double totalDuration = 0.00;
				double totalPercentage = 0.00;
				JSONArray gridData = new JSONArray();
				if(hotSpotDetails != null && hotSpotDetails.size()>0 && !isPartialGraph)
				{
					EgSorter egSort = new EgSorter(hotSpotDetails,4);
					hotSpotDetails = (ArrayList)egSort.sort(3,"Double","desc");

					for(int i=0; i<hotSpotDetails.size(); i++)
					{
						ArrayList temp  = (ArrayList) hotSpotDetails.get(i);
						JSONObject tmpObj = new JSONObject();
						String methodDetail = temp.get(0).toString();
						if(methodDetail.indexOf("[ASYNC]")>0)
							methodDetail = methodDetail.substring(0,methodDetail.indexOf("[ASYNC]"));
						
						tmpObj.put("MethodDetail",methodDetail);
						tmpObj.put("Count",(Integer)temp.get(1));
						tmpObj.put("Duration",Integer.valueOf(df.format(temp.get(2))));
						tmpObj.put("Percentage",Double.parseDouble(dft.format(temp.get(3))));
						gridData.add(tmpObj);
					}
					rootJson.put("gridData", gridData);
					rootJson.put("hotSpotPresence", "yes");
				}
				else
				{
					rootJson.put("nickName",trgt_Host+":"+portNo);
					rootJson.put("url",url);
					rootJson.put("compName",compName);
					rootJson.put("hotSpotPresence", "no");
				}
				out.println(rootJson.toString());
			}
			//HotSpot Data preparation ends here

			//Error Detail Data preparation starts
			else if(buttonClicked.equals(errorDetailsTabStr))
			{
				boolean expPresence = false;
				String nodeId = request.getParameter("index");
				if(nodeId == null)
					nodeId = "-1";

				Hashtable nodeIdTable = new Hashtable();
				String mainKey = guidString+seperatorHash+nodeOrder+seperatorHash+requestType;
				Hashtable errList = new Hashtable();
				errList = (Hashtable) session.getAttribute(sessionExternalData);

				if(errList != null && errList.size() >0)
				{
					nodeIdTable = (Hashtable) errList.get(mainKey);
				}

				StringBuffer sbf = new StringBuffer();
				if(nodeIdTable != null && nodeIdTable.size()>0)
				{
					if(nodeId.equals("-1"))
					{
						Enumeration e = nodeIdTable.keys();
						
						sbf.append("<table style='width:100%;' class='btmErrorData'>");
						while (e.hasMoreElements()) 
						{
							String key = (String) e.nextElement();
							ArrayList keyValue = (ArrayList) nodeIdTable.get(key);
							if(keyValue != null && keyValue.size()>0)
							{
								String type = (String) keyValue.get(1);
								if(!type.equals("EXCEPTION"))
									continue;
								String wholeExceptionData = (String)keyValue.get(8);
								if(wholeExceptionData.length()>0 /*&& wholeExceptionData.indexOf("?^?")>0*/)
								{
									expPresence = true;
									StringTokenizer stk = new StringTokenizer(wholeExceptionData, "?^?");
									boolean flag = true;
									sbf.append("<tr class='alternateColor'><td class='btmErrorDataBorderTopBottom'><table style='width:100%;border:0px solid red !important' >");
									while(stk.hasMoreTokens())
									{
										String expSingleLine = stk.nextToken();
										if(expSingleLine.indexOf("Caused by:")>-1)
											flag = true;
										if(flag)
										{
											flag = false;
											sbf.append("<tr><td class='font_bold11'>"+escapeHTML(expSingleLine)+"</td></tr><tr><td valign='top' style='padding-left:30px'>");
										}
										else
										{
											sbf.append("" +escapeHTML(expSingleLine)+"</br>");
										}
									}
									sbf.append("</td></tr></table></td></tr>");
								} 
							}
						}
						sbf.append("</table>");
					}
					else
					{
						ArrayList singleNodeIdData = (ArrayList) nodeIdTable.get(nodeId);
						if(singleNodeIdData != null && singleNodeIdData.size()>0)
						{
							String wholeExceptionData = (String) singleNodeIdData.get(8);
							if(wholeExceptionData.length()>0 /*&& wholeExceptionData.indexOf("?^?")>0*/)
							{
								expPresence = true;
								StringTokenizer stk = new StringTokenizer(wholeExceptionData, "?^?");
								boolean flag = true;
								sbf.append("<table class='btmErrorDataPopup' style='width:100%'>");
								while(stk.hasMoreTokens())
								{
									String expSingleLine = stk.nextToken();
									if(expSingleLine.indexOf("Caused by:")>-1)
										flag = true;

									if(flag)
									{
										flag = false;
										sbf.append("<tr><td >"+escapeHTML(expSingleLine)+"</td></tr><tr><td valign='top' style='padding-left:30px'>");
									}
									else
									{
										sbf.append("" +escapeHTML(expSingleLine)+"</br>");
									}
								}
								sbf.append("</td></tr></table>");
							}
						}
					}
				}
				
				if(expPresence)
				{
					rootJson.put("errorPresence","yes");
					rootJson.put("errorData",sbf.toString());
					out.println(rootJson.toString());
				}
				else
				{
					rootJson.put("errorPresence","no");
					rootJson.put("nickName",trgt_Host+":"+portNo);
					rootJson.put("url",url);
					rootJson.put("compName",compName);
					out.println(rootJson.toString());
				}
			}
			// ErrorDetails data preparation ends

			// SQL tab data preparation starts 
			else if(buttonClicked.equals("SQLCalls"))
			{
				double responseTime = 0.0000;
				String index = request.getParameter("index");
				if(index == null)
					index = "-1";
				ArrayList summaryData = (ArrayList) session.getAttribute(sessionSummaryData);
				if(summaryDataList != null && summaryDataList.size()>0)
				{
					/*if(isAsyncThread != null && isAsyncThread.equals(asyncThreadStr))
						summaryDataDetails = (Hashtable) summaryData.get(2);*/
					if(summaryDataDetails != null)
					{
						String key = guidString+seperatorHash+nodeOrder;
						if(summaryWholeData != null && summaryWholeData.size()>0)
						{
							try {
								responseTime = Double.parseDouble(summaryWholeData.get(11).toString());
							}
							catch (Exception ex)
							{
								System.err.println("Exception While parsing in preparing sql data "+ex.getMessage());
								//ex.printStackTrace();
							}
						}
					}
				}
				JSONArray gridData = new JSONArray();
				Hashtable nodeIdTable = new Hashtable();
				String mainKey = guidString+seperatorHash+nodeOrder+seperatorHash+requestType;
				Hashtable sqlList = new Hashtable();
				sqlList = (Hashtable) session.getAttribute(sessionExternalData);
				if(sqlList != null && sqlList.size()>0)
				{
					nodeIdTable = (Hashtable) sqlList.get(mainKey);
				}

				Hashtable dbdetailsQueryMap = new Hashtable();
				ArrayList allKeys = new ArrayList();
				String ip = null;
				String port = null;
				String dbtype = null;
				String sid = null;
				ArrayList dataToShow;

				EgExternalInfo externalInfo = new EgExternalInfo("manager");
				EgVirtualComponentInfo virCompInfo =new EgVirtualComponentInfo("manager");
				Vector cloudServerComp = externalInfo.getCloudServers();
				Vector virtualServerComp=externalInfo.getVirtualServers();
				Vector user_comps = new Vector();
				user_comps.addAll(u_ser.getServers(false));
				String vmcomp_type = "", vmhost = "";
				boolean isSlowQueryPresent = false;
				boolean isFastQueryPresent = false;
				int fastQryExecTime = 0;
				int fastQueryCount = 0;
				if(nodeIdTable != null && nodeIdTable.size()>0)
				{
					if(index.equals("-1"))
					{
						Enumeration en = nodeIdTable.keys();
						long count = 0L;
						while (en.hasMoreElements()) 
						{
							String key = (String) en.nextElement();
							ArrayList keyValue = (ArrayList) nodeIdTable.get(key);
							if(keyValue != null && keyValue.size()>0)
							{
								String type = (String)keyValue.get(1);
								if(type.equals("SQL"))
								{
									ArrayList query = new ArrayList();
									ip = (String)keyValue.get(2);
									port = (String)keyValue.get(3);
									dbtype = (String)keyValue.get(4);
									sid = (String)keyValue.get(5);
									
									//String dbDetails = keyValue.get(2)+" - "+keyValue.get(3)+" - "+keyValue.get(4)+" - "+keyValue.get(5);
									String dbDetails = null ;
									if(ip.startsWith("jdbc") ||  ip.indexOf(",") > -1)
									{
										dbDetails = ip+" - "+mappingInfo.getComponentTypeDescription(dbtype);
									}else
									{
										dbDetails = ip+" - "+port+" - "+mappingInfo.getComponentTypeDescription(dbtype)+" - "+sid;
									}
									dbDetails = BTMHelper.decodeUrlString(dbDetails);

									String queryType = keyValue.get(9).toString();
									query.add(queryType);
									query.add(((BigDecimal)keyValue.get(7)).intValue());
									query.add(keyValue.get(8));
									query.add(keyValue.get(10));
									
									if(key.startsWith("FASTQUERY"))
									{
										isFastQueryPresent = true;
										int tempFastQryExecTime = ((BigDecimal)keyValue.get(7)).intValue();
										fastQryExecTime = tempFastQryExecTime +fastQryExecTime;
										fastQueryCount = fastQueryCount + Integer.parseInt((String) keyValue.get(8));
										continue;
									}
									else
									{
										isSlowQueryPresent = true;
									}

									if(dbdetailsQueryMap.containsKey(dbDetails))
									{
										dataToShow = (ArrayList) dbdetailsQueryMap.get(dbDetails);
										dataToShow.add(query);
										dbdetailsQueryMap.put(dbDetails,dataToShow);
									}
									else
									{
										dataToShow = new ArrayList();
										dataToShow.add(query);
										dbdetailsQueryMap.put(dbDetails,dataToShow);
									}
									count++;
								}
							}
						}
						boolean isManageFlag = isComponentManaged(dbtype,ip,port,sid);
						AlarmPriorities ap = AlarmPriorities.getInstance();
						boolean vmfound = false;
						Hashtable vmht_virtualCompMap=null;
						vmht_virtualCompMap = virCompInfo.getVirtualComponentsMap();
						if(virtualServerComp != null && dbtype!=null && virtualServerComp.contains(dbtype))
						{
							vmhost=managedDbNickName+":"+port;
							if(dbtype.indexOf("Oracle_server")>-1  && sid!=null && sid.trim().length()>0)
								vmhost=managedDbNickName+":"+port+":"+sid;
							vmcomp_type=dbtype;
							String component=vmcomp_type+":"+vmhost;
							if(vmht_virtualCompMap!=null && vmht_virtualCompMap.size() > 0 && vmht_virtualCompMap.containsValue(component) && user_comps!=null && user_comps.contains(component))
							{
								vmfound = true;
							}
						}
						else
						{
							if(vmht_virtualCompMap!=null && vmht_virtualCompMap.size() > 0 && dbtype!=null)
							{
								String vmcheck = dbtype+":"+managedDbNickName;
								if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
									vmcheck=dbtype+":"+managedDbNickName+":"+port+":"+sid;
								String vmvirtualComp=(String)vmht_virtualCompMap.get(vmcheck);
								if (vmvirtualComp != null)
								{
									StringTokenizer vmst=new StringTokenizer(vmvirtualComp,":");
									if (vmst.countTokens()>2)
									{
										vmcomp_type=vmst.nextToken();
										vmhost=vmst.nextToken()+":"+vmst.nextToken();
										String component=vmcomp_type+":"+vmhost;
										if(user_comps!=null && user_comps.contains(component))
										{
											vmfound = true;
										}
									}
								}
							}
						}
						boolean cloudfound = false;
						Hashtable vmht_cloudCompMap = null;
						vmht_cloudCompMap = virCompInfo.getCloudComponentsMap();
						if (cloudServerComp !=null && dbtype!=null && cloudServerComp.contains(dbtype))
						{
							vmhost=managedDbNickName+":"+port;
							if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
								vmhost=managedDbNickName+":"+port+":"+sid;
							vmcomp_type=dbtype;
							String component=vmcomp_type+":"+vmhost;
							if(vmht_cloudCompMap!=null && vmht_cloudCompMap.size() > 0 && vmht_cloudCompMap.containsValue(component) && user_comps!=null && user_comps.contains(component))
							{
								cloudfound = true;
							}
						}
						else
						{
							if(vmht_cloudCompMap!=null && vmht_cloudCompMap.size() > 0 && dbtype!=null)
							{
								String vmcheck = dbtype+":"+managedDbNickName;
								if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
									vmcheck=dbtype+":"+managedDbNickName+":"+port+":"+sid;
								String vmvirtualComp=(String)vmht_cloudCompMap.get(vmcheck);
								if (vmvirtualComp != null)
								{
									StringTokenizer vmst=new StringTokenizer(vmvirtualComp,":");
									if (vmst.countTokens()>2)
									{
										vmcomp_type=vmst.nextToken();
										vmhost=vmst.nextToken()+":"+vmst.nextToken();
										String component=vmcomp_type+":"+vmhost;
										if(user_comps!=null && user_comps.contains(component))
										{
											cloudfound = true;
										}
									}
								}
							}
						}

						boolean vm_warePresent=false;
						VMDesktopBean vm_DesktopBean=null;
						if (vmfound || cloudfound)
						{
							List vm_managedcomp = u_ser.getServers(false);
							String vmstart = vmcomp_type+":";
							String vmend = ":"+vmhost;
							for (int i=0;i<vm_managedcomp.size();i++)
							{
								String vmcomp=(String)vm_managedcomp.get(i);
								if (vmcomp.startsWith(vmstart) &&  vmcomp.endsWith(vmend))
								{
									vm_warePresent=true;
									vm_DesktopBean = new VMDesktopBean(request);
									break;
								}
							}
						}

						if (isFastQueryPresent && isSlowQueryPresent)
						{
							if (dbdetailsQueryMap != null && dbdetailsQueryMap.size()>0)
							{
								JSONArray singleGridData = new JSONArray();
								Enumeration e = dbdetailsQueryMap.keys();
								double totalExecutionTime = 0.0;
								while (e.hasMoreElements())
								{
									String key = (String) e.nextElement();
									allKeys.add(key);
									ArrayList type = (ArrayList) dbdetailsQueryMap.get(key);
									EgSorter egSort = new EgSorter(type,4);
									type = (ArrayList)egSort.sort(2,"Integer","desc");
									for(int i=0; i<type.size(); i++)
									{
										ArrayList singleRowData = (ArrayList) type.get(i);
										if(singleRowData != null && singleRowData.size()>0)
										{
											double result = 0.0;
											double thisExecutionTime = 0.0;
											try 
											{
												thisExecutionTime = Double.parseDouble(singleRowData.get(1).toString());
												totalExecutionTime += thisExecutionTime;
												result = (thisExecutionTime/responseTime)*100;
											}
											catch (Exception ex)
											{
												System.err.println("Exception While parsing String to Double for ExternalDetails data "+ex.getMessage());
												//ex.printStackTrace();
											}
											JSONObject dataObj = new JSONObject();
											dataObj.put("Query_Type",singleRowData.get(0));
											dataObj.put("Query_Details",escapeHTML(singleRowData.get(2).toString()));
											dataObj.put("Execution_Time",thisExecutionTime);
											dataObj.put("Progress",Double.parseDouble(dft.format(result)));
											dataObj.put("Error",singleRowData.get(3));

											//boolean isManageFlag = isComponentManaged(dbtype,ip,port,sid);
											//String linkUrl = "/final/monitor/alarmsList.jsp?compName="+EgURLEncoder.encode(dbtype+":"+managedDbNickName+":"+port,"UTF-8")+"&site=null";
											String vm_port="";
											String vmhostState="";
											String linkUrl = null;
											if(vm_warePresent && (vmhost!=null && !vmhost.equals(" ")))
											{
												vmhostState=vm_DesktopBean.getVmhostState(vmcomp_type+":"+vmhost);
												int vmindex = vmhost.indexOf(":");
												if(vmindex>0)
												{
													vm_port =vmhost.substring(vmindex+1);
													if(vm_port!=null && vm_port.indexOf(":")>-1 && dbtype.indexOf("Oracle_server")>-1)
													{
														vm_port=vm_port.substring(0,vmindex);
													}
													vmhost = vmhost.substring(0,vmindex);
												}
												linkUrl="EgVmwareCompGraphApp.jsp?Vmhost="+EgURLEncoder.encode(vmhost,"UTF-8")+"&vmcomp_type="+vmcomp_type+"&state="+vmhostState+"&port="+vm_port+"&fromPage=LayerModel";
											}
											else
											{
												vmhost=managedDbNickName+":"+port;
												if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
												{
													vmhost=managedDbNickName+":"+port+":"+sid;
												}
												if(user_comps!=null && user_comps.contains(dbtype+":"+vmhost))
													linkUrl = "/final/servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&host="+EgURLEncoder.encode(vmhost,"UTF-8")+"&comptype="+dbtype+"&comeFrom=topology&tab=LayerModel&toDashBoardLayer=true";
											}

											if(isManageFlag && linkUrl!=null && linkUrl.trim().length()>0)
											{
												String comp_name = managedDbNickName+":"+port;
												if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
												{
													comp_name=managedDbNickName+":"+port+":"+sid;
												}
												String thisState = ap.getAlarmPriority(Server.getServerName(dbtype+":"+comp_name), dbtype);
												dataObj.put("Database_Details","<span style='text-decoration:underline;' data-qclass='yellowTip' data-qtip='"+comp_name+"'><img style='display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf state_"+thisState+"'><a href='javascript:void(0);' onclick=UrlFrame(\'"+linkUrl+"\')>"+comp_name+"</a></span>");
											}
											else
											{
												dataObj.put("Database_Details","<span data-qclass='yellowTip' data-qtip='"+key+"'>"+key+"</span>");
											}
											singleGridData.add(dataObj);
										}
									}
									rootJson.put("TotalSqlCalls", count);
									rootJson.put("SQlPresence", "yes");
								}
								double fastAndSlowExecutionTime = 0.0;
								fastAndSlowExecutionTime = totalExecutionTime + fastQryExecTime;
								rootJson.put("totalExecutionTime",fastAndSlowExecutionTime);
								//rootJson.put("totalExecutionTime",totalExecutionTime);
								rootJson.put("gridData", singleGridData);
							}
							rootJson.put("FastSQLCount", fastQueryCount);
							//rootJson.put("FastSQLTime", fastQryExecTime);
						}
						else if(isSlowQueryPresent)
						{
							if(dbdetailsQueryMap != null && dbdetailsQueryMap.size()>0)
							{
								JSONArray singleGridData = new JSONArray();
								Enumeration e = dbdetailsQueryMap.keys();
								double totalExecutionTime = 0.0;
								while (e.hasMoreElements())
								{
									String key = (String) e.nextElement();
									allKeys.add(key);
									ArrayList type = (ArrayList) dbdetailsQueryMap.get(key);
									EgSorter egSort = new EgSorter(type,4);
									type = (ArrayList)egSort.sort(2,"Integer","desc");
									for(int i=0; i<type.size(); i++)
									{
										ArrayList singleRowData = (ArrayList) type.get(i);
										if(singleRowData != null && singleRowData.size()>0)
										{
											double result = 0.0;
											double thisExecutionTime = 0.0;
											try 
											{
												thisExecutionTime = Double.parseDouble(singleRowData.get(1).toString());
												totalExecutionTime += thisExecutionTime;
												result = (thisExecutionTime/responseTime)*100;
											}
											catch (Exception ex)
											{
												System.err.println("Exception While parsing String to Double for ExternalDetails data "+ex.getMessage());
												//ex.printStackTrace();
											}
											JSONObject dataObj = new JSONObject();
											dataObj.put("Query_Type",singleRowData.get(0));
											dataObj.put("Query_Details",escapeHTML(singleRowData.get(2).toString()));
											dataObj.put("Execution_Time",thisExecutionTime);
											dataObj.put("Progress",Double.parseDouble(dft.format(result)));
											dataObj.put("Error",singleRowData.get(3));

											/*boolean isManageFlag = isComponentManaged(dbtype,ip,port,sid);
											String linkUrl = "/final/monitor/alarmsList.jsp?compName="+EgURLEncoder.encode(dbtype+":"+managedDbNickName+":"+port,"UTF-8")+"&site=null";
											String linkUrl = "/final/servlet/com.eg.EgDashboardController?from=list&comesFrom=componentSelect&comptype="+EgURLEncoder.encode(dbtype,"UTF-8")+"&host="+EgURLEncoder.encode(managedDbNickName+":"+port,"UTF-8");
											if(dbtype.indexOf("Oracle_server")>-1)
											{
												linkUrl = "/final/servlet/com.eg.EgDashboardController?from=list&comesFrom=componentSelect&comptype="+EgURLEncoder.encode(dbtype,"UTF-8")+"&host="+EgURLEncoder.encode(managedDbNickName+":"+port+":"+sid,"UTF-8");
												isManageFlag = isComponentManaged(dbtype,ip,port,sid);
											}*/
										String vm_port="";
										String vmhostState="";
										String linkUrl = null;
										if(vm_warePresent && (vmhost!=null && !vmhost.equals(" ")))
										{
											vmhostState=vm_DesktopBean.getVmhostState(vmcomp_type+":"+vmhost);
											int vmindex = vmhost.indexOf(":");
											if(vmindex>0)
											{
												vm_port =vmhost.substring(vmindex+1);
												if(vm_port!=null && vm_port.indexOf(":")>-1 && dbtype.indexOf("Oracle_server")>-1)
												{
													vm_port=vm_port.substring(0,vmindex);
												}
												vmhost = vmhost.substring(0,vmindex);
											}
											linkUrl="EgVmwareCompGraphApp.jsp?Vmhost="+EgURLEncoder.encode(vmhost,"UTF-8")+"&vmcomp_type="+vmcomp_type+"&state="+vmhostState+"&port="+vm_port+"&fromPage=LayerModel";
										}
										else
										{
											vmhost=managedDbNickName+":"+port;
											if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
											{
												vmhost=managedDbNickName+":"+port+":"+sid;
											}
											if(user_comps!=null && user_comps.contains(dbtype+":"+vmhost))
												linkUrl = "/final/servlet/com.eg.EgDashboardController?from=list&site=NULL&qctr=0&host="+EgURLEncoder.encode(vmhost,"UTF-8")+"&comptype="+dbtype+"&comeFrom=topology&tab=LayerModel&toDashBoardLayer=true";
										}

											if(isManageFlag && linkUrl!=null && linkUrl.trim().length()>0)
											{
												String comp_name = managedDbNickName+":"+port;
												if(dbtype.indexOf("Oracle_server")>-1 && sid!=null && sid.trim().length()>0)
												{
													comp_name=managedDbNickName+":"+port+":"+sid;
												}
												String thisState = ap.getAlarmPriority(Server.getServerName(dbtype+":"+comp_name), dbtype);
												dataObj.put("Database_Details","<span style='text-decoration:underline;' data-qtip='"+comp_name+"'><img style='display:block;float:left;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tree-icon x-tree-icon-leaf state_"+thisState+"'><a href='javascript:void(0);' onclick=UrlFrame(\'"+linkUrl+"\')>"+comp_name+"</a></span>");
											}
											else
											{
												dataObj.put("Database_Details","<span data-qtip='"+key+"'>"+key+"</span>");
											}
											singleGridData.add(dataObj);
										}
									}
									rootJson.put("TotalSqlCalls", count);
									rootJson.put("SQlPresence", "yes");
								}
								rootJson.put("totalExecutionTime",totalExecutionTime);
								rootJson.put("gridData", singleGridData);
							}
						}
						else if(isFastQueryPresent) //if FastSQL, then dbdetailsQueryMap will be null
						{
							rootJson.put("SQlPresence", "fast");
							rootJson.put("FastSQLCount", fastQueryCount);
							rootJson.put("totalExecutionTime",fastQryExecTime);
							//rootJson.put("FastSQLTime", fastQryExecTime);
						}
						else
						{
							rootJson.put("SQlPresence", "no");
							rootJson.put("nickName",trgt_Host+":"+portNo);
							rootJson.put("dbdetail","None");
							rootJson.put("url",url);
							rootJson.put("compName",compName);
						}
					}
					else
					{
						ArrayList singleNodeIdData = (ArrayList) nodeIdTable.get(index);
						if(singleNodeIdData != null && singleNodeIdData.size()>0)
						{
							String type = (String) singleNodeIdData.get(4);
							String dbDetails = null ;
							String ipPort = (String)singleNodeIdData.get(2) ;
							String dbName = (String)singleNodeIdData.get(3) ; 
							String dbType = (String)singleNodeIdData.get(5) ; 
							dbDetails = (ipPort.startsWith("jdbc") || ipPort.indexOf(",") > -1)?ipPort+"-"+mappingInfo.getComponentTypeDescription(type):ipPort+" - "+dbName+" - "+mappingInfo.getComponentTypeDescription(type)+" - "+dbType;
							dbDetails = BTMHelper.decodeUrlString(dbDetails);
							JSONObject tmpObj = new JSONObject();
							double result = ((Double.parseDouble(singleNodeIdData.get(7).toString()))/responseTime)*100;
							String queryType = (String) singleNodeIdData.get(9);
							tmpObj.put("Query_Type",queryType);
							tmpObj.put("Query_Details",escapeHTML(singleNodeIdData.get(8).toString()));
							tmpObj.put("Execution_Time",(Double.parseDouble(singleNodeIdData.get(7).toString())));
							tmpObj.put("Progress",dft.format(result));
							tmpObj.put("Error",singleNodeIdData.get(10));

							gridData.add(tmpObj);

							rootJson.put("dbdetail", dbDetails);
							rootJson.put("gridData", gridData);
							rootJson.put("SQlPresence", "yes");
						}
						else
						{
							rootJson.put("SQlPresence", "no");
							rootJson.put("nickName",trgt_Host+":"+portNo);
							rootJson.put("url",url);
							rootJson.put("compName",compName);
						}
					}
					rootJson.put("keysList",allKeys);
				}
				else
				{
					rootJson.put("nickName",trgt_Host+":"+portNo);
					rootJson.put("url",url);
					rootJson.put("compName",compName);
					rootJson.put("SQlPresence", "no");
				}
				out.println(rootJson.toString());
			}
			// SQL tab data preparation ends here

			// DrillDown popup for HTTP/WS/JMS from Call Graph page starts
			else if(buttonClicked.equals(popupDetailsClickStr))
			{
				boolean isOtherPointCut = false;
				String drillDownPresent = "No";
				String nextData = null;
				String nodeId = request.getParameter("index");
				String type = request.getParameter("type");
				//String nodeCount = request.getParameter("nodeCount");
				//String nextNode = nodeOrder+"."+nodeCount;
				String connectedNodeOrder = null;
				Hashtable externalData = (Hashtable) session.getAttribute(sessionExternalData);
				Hashtable secondTable = (Hashtable) summaryDataList.get(1);
				//ArrayList webOrderList = new ArrayList();
				//ArrayList threadOrderList = new ArrayList();

				//if(requestDataList!=null && requestDataList.size() == 6)
				//{
					//ArrayList orderList = BTMHelper.getOrderedList(requestDataList);
					//webOrderList = (ArrayList)orderList.get(0);
					//threadOrderList = (ArrayList)orderList.get(1);
				//}
				/*if(webOrderList != null && webOrderList.size()>0)
				{
					int webOrderListSize = webOrderList.size();
					int currentPosition = webOrderList.indexOf(nodeOrder);

					if(webOrderListSize > currentPosition+1)
						nextData = (String) webOrderList.get(currentPosition+1);

					if(nextData != null && nextData.length()>0)
					{
						//drillDownPresent = "Yes";
						Hashtable firstTable = (Hashtable) requestDataList.get(0);
						ArrayList nextNodeDetails = (ArrayList) firstTable.get(guidString+seperatorHash+nextData);
						state = (String) nextNodeDetails.get(2);
						if(state.equals("Slow_percentage"))
							state = "BTM_transaction_state_Slow";
						else if(state.equals("Error_percentage"))
							state = "BTM_transaction_state_Error";
						else if(state.equals("Healthy_percentage"))
							state = "BTM_transaction_state_Normal";
						else if(state.equals("Stalled_percentage"))
							state = "BTM_transaction_state_Stalled";
					}
					else
					{
						drillDownPresent = "No";
					}
				}*/
				Hashtable nodeIdTable = new Hashtable();
				String mainKey = guidString+seperatorHash+nodeOrder+seperatorHash+requestType;
				Hashtable dataList = new Hashtable();
				dataList = (Hashtable) session.getAttribute("Http_Jms_Web"+"$"+mainKey);
				if(dataList != null && dataList.size() == 2)
				{
					nodeIdTable = (Hashtable) dataList.get(mainKey);
				}
				else
				{
					//String query = "select REQUEST_DATE, EG_GUID, REQUEST_TYPE, NODE_ORDER, DETAILS from EXTERNAL_SERVICE_DETAILS where EG_GUID = '"+guidString+"'  ORDER BY NODE_ORDER asc";

					//dataList = btmHelperObj.getExternalDetails(query);
					ArrayList nodeOrdersList = (ArrayList) summaryDataList.get(2);
					ArrayList webOrderList = (ArrayList) nodeOrdersList.get(0);

					dataList =  (Hashtable) session.getAttribute(sessionExternalData);
					session.setAttribute("Http_Jms_Web"+"$"+mainKey, dataList);
					nodeIdTable = (Hashtable) dataList.get(mainKey);
				}
				ArrayList singleNodeIdData = new ArrayList();
				if(nodeIdTable != null && nodeIdTable.size()>0)
				{
					singleNodeIdData = (ArrayList) nodeIdTable.get(nodeId);
				}

				String result = "";
				if(singleNodeIdData != null && singleNodeIdData.size()>0)
				{
					isOtherPointCut = apm.isPointCutInIni(testName,type);

					if(type.equals("http") || type.equals("webservice") || type.equals("jms"))
					{
						if(type.equals("http") || type.equals("webservice"))
						{
							connectedNodeOrder = (String) singleNodeIdData.get(9);
							if(secondTable.containsKey(guidString+"#"+connectedNodeOrder))
							{
								ArrayList connectedNodeDetails = (ArrayList) secondTable.get(guidString+"#"+connectedNodeOrder);
								String nickName = (String) connectedNodeDetails.get(0);
								String port = (String) connectedNodeDetails.get(1);

								List userCompDetails = (List) u_ser.getServers(true);
								if(userCompDetails.contains(nickName+":"+port))
									drillDownPresent = "Yes";
							}

							if(type.equals("http"))
							{
								
								/*EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
								EgDiscInfo discoverInfo = new EgDiscInfo("manager");
								ArrayList businessTransServerList = new ArrayList();
								ArrayList allDetails = new ArrayList();
								String[] allServerTypes = discoverInfo.getServerTypes();

								for(int k=0;k<allServerTypes.length;k++)
								{
									String singleServerType = allServerTypes[k];
									//if(specsInfo.isTestRelevantForServer(singleServerType, businessTransTest))
									if(specsInfo.isTestRelevantForServer(singleServerType, testName))
									{
										businessTransServerList.add(singleServerType);
									}
								}
								for(int j=0;j<businessTransServerList.size();j++)
								{
									String btmServerType = (String) businessTransServerList.get(j);
									ArrayList btmServerList = discoverInfo.getAllEntries(btmServerType);
									for(int i=0;i<btmServerList.size();i++)
									{
										String line = (String) btmServerList.get(i);
										if(line.startsWith("#Unmanage|"))
											continue;
										String rhsPart = line.substring(line.indexOf(seperatorEquals)+1);
										StringTokenizer st = new StringTokenizer(rhsPart , ",");
										int count = st.countTokens();

										String compType = st.nextToken();
										String hostIp = st.nextToken();
										String nickName = st.nextToken();
										String portNo = st.nextToken();
										
										List userCompDetails = (List) u_ser.getServers(true);
										if(singleNodeIdData.get(2).equals(hostIp) && singleNodeIdData.get(3).equals(portNo))
										{
											if(nextData != null && nextData.length()>0)
											{
												if(userCompDetails.contains(nickName+":"+portNo))
													drillDownPresent = "Yes";
											}
											break;
										}
									}
								}*/
								String ipandPort = (String) singleNodeIdData.get(4);
								if(ipandPort.lastIndexOf(":NULL")>-1)
									ipandPort = ipandPort.substring(0,ipandPort.lastIndexOf(":NULL"));

								String extInfoUrl =  ipandPort+""+singleNodeIdData.get(6);
								String extUrl = (String)singleNodeIdData.get(6);
								if(extUrl.equals("-"))
									extInfoUrl = ipandPort;

								if(extInfoUrl.indexOf("UNKNOWN_NODE_") > -1)
									result = "";
								else
									result = extInfoUrl + "*&*" + singleNodeIdData.get(5) + "*$*" + df.format(singleNodeIdData.get(7)) + " ms";
							}
							else if(type.equals("webservice"))
							{
								result = singleNodeIdData.get(4)+""+singleNodeIdData.get(6) + "*&*" + singleNodeIdData.get(5) + "*$*" + singleNodeIdData.get(4);
							}
						}
						else if(type.equals("jms"))
						{
							result = singleNodeIdData.get(4) + "*&*" + singleNodeIdData.get(5) + "*$*" + singleNodeIdData.get(8);
						}
					}
					else if(type.equals("sap jco"))
					{
						String idwithNo = (String)singleNodeIdData.get(3);
						String no = idwithNo.substring(0,idwithNo.indexOf(seperatorHash));
						String id = idwithNo.substring(idwithNo.indexOf(seperatorHash)+1);
						result = singleNodeIdData.get(6) + "*&*" + singleNodeIdData.get(2) + "*&*" + id+ "*&*" + no + "*&*" + singleNodeIdData.get(4)+"*&*" + singleNodeIdData.get(5);
					}
					else if(isOtherPointCut || type.equals("ejb")) //For RMI|JavaMail.
					{
						result = singleNodeIdData.get(6) + "*&*" + singleNodeIdData.get(8);
						if (type.equalsIgnoreCase("email") || type.equalsIgnoreCase("ldap") || type.equalsIgnoreCase("runtime")) {
							result = singleNodeIdData.get(6) + "*&*" + singleNodeIdData.get(7);
						}
					}
				}
				out.println(result+"#$#"+drillDownPresent.trim()+"&^&"+connectedNodeOrder);
			}
			// DrillDown popup for HTTP/WS/JMS from Call Graph page ends

			// External Details tab data preparation starts
			else if(buttonClicked.equals(externalDetailsTabStr))
			{
				boolean isOtherPointCut = false;
				Hashtable dataList = new Hashtable();
				Hashtable result = new Hashtable();
				ArrayList temp = new ArrayList();
				ArrayList wholeArrayListData = new ArrayList();
				
				String tmpStr = null;
				double totalResTime= 0.00;
				Hashtable externalData = (Hashtable) session.getAttribute(sessionExternalData);
				ArrayList summaryData = (ArrayList) session.getAttribute(sessionSummaryData);
				if(summaryData != null && summaryData.size()>0)
				{
					/*if(isAsyncThread != null && isAsyncThread.equals(asyncThreadStr))
					{
						summaryDataDetails = (Hashtable) summaryData.get(2);
					}*/
					if(summaryDataDetails != null)
					{
						if(summaryWholeData != null && summaryWholeData.size()>0)
						{
							try 
							{
								totalResTime = (Double.parseDouble(summaryWholeData.get(11).toString()));
							}
							catch (Exception ex)
							{
								System.err.println("Exception While parsing String to Double for ExternalDetails data "+ex.getMessage());
								//ex.printStackTrace();
							}
						}
					}
				}
				String mainKey = guidString+seperatorHash+nodeOrder+seperatorHash+requestType;
				JSONArray jsonArr = new JSONArray();
				boolean allow = false;
				ArrayList sortingArray = new ArrayList();
				if(externalData != null && externalData.size()>0)
				{
					dataList = (Hashtable) externalData.get(mainKey);
					if(dataList != null && dataList.size() > 0)
					{
						Set keySet = dataList.keySet();
						Iterator it = keySet.iterator();
						int actualLdapCount = 0;
						while(it.hasNext())
						{
							ArrayList PCDetailsList = (ArrayList) dataList.get(it.next());
							if (PCDetailsList != null){
								String tempCallType = (String)PCDetailsList.get(1);
								if (tempCallType != null && tempCallType.equalsIgnoreCase("LDAP")){
									actualLdapCount++;
								}
							}
							sortingArray.add(PCDetailsList);
						}
						int tempLdapCount = 0;
						if(sortingArray != null && sortingArray.size()>0)
						{
							EgSorter egSort = new EgSorter(sortingArray,12);
							sortingArray = (ArrayList)egSort.sort(8,"Double","desc");
							Hashtable ldapDataTable = new Hashtable();
							int ldapMethodCount = 1;
							int unknownHttpCount = 0;
							ArrayList ldapDetails = null;
							int sortingArraySize = sortingArray.size();
							for(int i=0;i<sortingArraySize;i++)
							{
								JSONArray gridData = new JSONArray();
								JSONObject tmpObj = new JSONObject();
								temp = (ArrayList) sortingArray.get(i);
								String callType = (String) temp.get(1);
								String childPointcut = apm.changeChildPointcutTime(callType);
								if (childPointcut != null && childPointcut.length() > 0)
									callType = childPointcut;

								isOtherPointCut = apm.isPointCutInIni(testName,callType);
								if(callType.equals("HTTP") || callType.equals("WEBSERVICE") || callType.equals("JMS") || callType.equals("SAP JCO") || isOtherPointCut || callType.equals("EJB"))
								{
									allow = true;
									if(callType.equals("HTTP"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));

										String ipandPort = (String) temp.get(4);
										if(ipandPort.lastIndexOf(":NULL")>-1)
											ipandPort = ipandPort.substring(0,ipandPort.lastIndexOf(":NULL"));

										String extUrl = (String) temp.get(6);
										if(extUrl.equals("-"))
										{
											if(ipandPort.indexOf("UNKNOWN_NODE_")>-1)
											{
												//tmpObj.put("Details","-");
												unknownHttpCount++;
												continue;
											}
											else 
											{
												tmpObj.put("Details",ipandPort);
											}
										}
										else
										{
											tmpObj.put("Details",ipandPort+""+temp.get(6));
										}

										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for Http call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");

										tmpObj.put("Method",temp.get(5));
										tmpObj.put("PercentValue",percent);
									}
									else if(callType.equals("WEBSERVICE"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));
										tmpObj.put("Details",temp.get(4)+""+temp.get(6));
										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for Webservice call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");
										tmpObj.put("Operation",temp.get(5));
										tmpObj.put("PercentValue",percent);
									}
									else if(callType.equals("JMS"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));
										tmpObj.put("Details",temp.get(5));
										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for JMS call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");
										tmpObj.put("PercentValue",percent);
									}
									else if(callType.equals("SAP JCO"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));
										tmpObj.put("AS Host",temp.get(2));
										String noWithId = (String) temp.get(3);
										String no = noWithId.substring(0,noWithId.indexOf(seperatorHash));
										String id = noWithId.substring(noWithId.indexOf(seperatorHash)+1);
										tmpObj.put("System No",no);
										tmpObj.put("System Id",id);
										tmpObj.put("Client",temp.get(5));
										tmpObj.put("User",temp.get(4));
										tmpObj.put("Function",temp.get(6));
										tmpObj.put("Time",temp.get(7));
									}
									else if(callType.equalsIgnoreCase("EJB"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));
										tmpObj.put("Details",temp.get(6));
										tmpObj.put("Target",temp.get(8));
										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for RMI call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");
										tmpObj.put("PercentValue",percent);
									}
									else if(callType.equalsIgnoreCase("RMI") || callType.equalsIgnoreCase("RUNTIME"))
									{
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+temp.get(1)));
										tmpObj.put("Details",temp.get(6));
										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for RMI call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");
										tmpObj.put("PercentValue",percent);
									}
									else if (callType.equalsIgnoreCase("EMAIL")){
										tmpObj.put("Type",mappingInfo.getTextDescription("monitor.apmtopology."+callType));
										String mailMethodName = (String)temp.get(6);
										tmpObj.put("Details",mailMethodName);
										tmpObj.put("Time",temp.get(7));
										double percent = 0.0;
										try {
											percent = Double.parseDouble (dft.format((Double.parseDouble(temp.get(7).toString())/totalResTime)*100));
										}
										catch (Exception ex)
										{
											System.err.println("Exception While parsing String to Double for RMI call type "+ex.getMessage());
											//ex.printStackTrace();
										}
										tmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+percent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+percent+"&nbsp;%</span> </div>");
										tmpObj.put("PercentValue",percent);
									}
									else if(callType.equalsIgnoreCase("LDAP"))
									{
										getLdapDetailsTable(temp, ldapDetails, ldapDataTable, totalResTime, dft, ldapMethodCount);
										tempLdapCount++;
										
										if (tempLdapCount == actualLdapCount){ // executing at the end of loop
											ArrayList sortedList = new ArrayList();
											Iterator tempItr = ldapDataTable.keySet().iterator();
											while (tempItr.hasNext()){
												String methodDetail = (String)tempItr.next();
												ArrayList tempDataList = (ArrayList)ldapDataTable.get(methodDetail);
												if (tempDataList != null){
													sortedList.add(tempDataList);
												}
											}
											if (sortedList != null && sortedList.size() > 0){
												egSort = new EgSorter(sortedList,12);
												sortedList = (ArrayList)egSort.sort(3,"Double","desc");
												for (int a=0 ; a<sortedList.size() ; a++){
													ArrayList ldapDataList = (ArrayList) sortedList.get(a);
													if (ldapDataList != null){
														JSONArray ldapGridData = new JSONArray();
														JSONObject ldapTmpObj = new JSONObject();
														ldapTmpObj.put("Type","LDAP");
														String methodName = (String)ldapDataList.get(0);
														ldapTmpObj.put("Details",methodName);
														int methodTotCount = (Integer)ldapDataList.get(1);
														BigDecimal methodTime = (BigDecimal)ldapDataList.get(2);
														ldapTmpObj.put("Time",methodTime);
														ldapTmpObj.put("Count",methodTotCount);
														double methodPercent = (Double)ldapDataList.get(3);
														ldapTmpObj.put("% Time", "<div class='btmGraphBg' ><div class='btmGraph' align='center' height='14' style='position:absolute;top:0px;left:0px;text-align:center;width:"+methodPercent+"%;height:14px;margin-left:0px;border:0px solid red;' ></div> <span style='position:absolute;top:0px;left:0px;text-align:center;margin:0 auto 0 0px;width:63px !important;' class='btmGraphValue' >"+methodPercent+"&nbsp;%</span> </div>");
														ldapTmpObj.put("PercentValue",methodPercent);
														ldapGridData.add(ldapTmpObj);
														jsonArr.add(ldapGridData);
													}
												}
											}
										}
									}
									if (!callType.equalsIgnoreCase("LDAP")) {
										gridData.add(tmpObj);
										jsonArr.add(gridData);
									}
								}
							}
							if(sortingArraySize == unknownHttpCount)
								allow = false;
						}
					}
				}
				if(allow)
				{
					rootJson.put("externalDetailsPresence", "yes");
					rootJson.put("gridData",jsonArr);
				}
				else
				{
					rootJson.put("nickName",trgt_Host+":"+portNo);
					rootJson.put("url",url);
					rootJson.put("compName",compName);
					rootJson.put("externalDetailsPresence", "no");
				}
				out.println(rootJson.toString());
			}
			//External Details tab data preparation ends here
		}
	}
	catch(Exception e)
	{
		//e.printStackTrace();
		System.err.println("Exception occured while handling the btm button request");
	}
%>

