<%
/**
 *	Displays alarms occurring currently, marked as critical/minor/warning/normal/unknown. Allows alarms to be 
 *	viewed based on the type - all/critical/critical & minor. Allows selected alarms to be deleted.
 *
 *	@author		Sandhya. K
 *	@created	09/05/2001
 *	@version	3.0
 *
 *	@modified	
 *		24-07-2001	Bala	Incorporate msmt_host virtual ip changes
 *		31-07-2001	kk		added a tstate param to the EgSiteInfraView query String.
 *		16-01-2002			check for New Fix in the code
 *		06-02-2003	Arun	Incorporate alarm deletion & filtering of priorities
 *		26-03-2003	Arun	Fixed the alarm deletion problem
 *		08-07-2003	Arun	Changed UserRegistry to use session ID instead of login ID
 *		08-09-2003	Arun	Changed description to show meaningful messages instead of measures
 *		19-09-2003	John	eG 3.0 Layout Modifications
 *		26-09-2003	John	Footer page included
 *		27-09-2003	Arun	Swapped Description and Service columns
 *		04-11-2003	Arun	Hide checkboxes and the DELETE button if alarm deletion is not allowed
 *		12-11-2003	Arun	Shows last measurement value if enabled in eg_services.ini
 *		19/11/2003	Arun	Removed usage of EgSessionCheck and fixed bug for displaying last measurement
 *					values (shown irrespective of the value set in eg_services.ini)
 *		20/12/2003	Arun	Fixed Alarm Refresh problem - null query string was set
 *		20/05/2004	Arun	Fixed bug that showed -1.0 for last measurement values
 *		07/07/2004	Arun	Uses configuration in eg_ui.ini to show alarms in a table 
 *							or when the mouse hovers over it.
 *		06-10-2004	Vijay - GUI Changes
 *		
 */
%>
<%@ include file="EgLoginTracker.jsp" %>
<%@ page errorPage = "EgProbsM.jsp" %>
<%@ page import = "com.eg.EgConfigInfo" %>
<%@ page import = "com.eg.EgDateInfo" %>
<%@ page import = "com.eg.EgDbInfo" %>
<%@ page import = "com.eg.EgDbAdapterTypeUI" %>
<%@ page import = "com.eg.EgDeletedAlarms" %>
<%@ page import = "com.eg.EgTablesInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.*" %>
<%@ page import = "com.egurkha.monitor.alarms.*" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.EgDbAdapterUI" %>
<%@ page import = "egurkha.EgSettingsTimeStamp" %>
<%@ page import = "java.io.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "java.util.*" %>
<%
	com.egurkha.ini.IniUI ui = (com.egurkha.ini.IniUI)com.egurkha.ini.IniUI.getInstance();
	String refreshTime = ui.getRefreshTime("EgAlarms");

	String[] options = {"All", 
	ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY)+" & "+ ui.getStateDisplayLabel(AlarmPriorities.MEDIUM_PRIORITY), ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY)};
	int[] priorities = {10, 2, 1};
	String[] colrs = {"r","o","p"};
	StringBuffer metaRefreshUrl = new StringBuffer(64);
	metaRefreshUrl.append("EgAlarms1.jsp");
	String queryString = request.getQueryString();
	if (queryString != null)
	{
		metaRefreshUrl.append("?");
		metaRefreshUrl.append(queryString);
	}

	boolean isInMainWin = "true".equalsIgnoreCase(request.getParameter("dispAtMainWin"));
	String s_topLeftImg= "TopLeft.gif";
	String s_topRightImg = "TopRight.gif";
	String s_topLeft2Img= "TopLeft2.gif";
	String s_topRight2Img = "TopRight2.gif";
	String s_sideLeftbg= "SideLeftBg.gif";
	String s_sideRightbg = "SideRightBg.gif";
	String s_dashbotLeft1= "DashBotLeft1.gif";
	String s_dashbotRight1 = "DashBotRight1.gif";
	if(isInMainWin)
	{
		s_topLeftImg= "TopLeftmain.gif";
		s_topRightImg = "TopRightmain.gif";
		s_topLeft2Img= "TopLeft2main.gif";
		s_topRight2Img = "TopRight2main.gif";
		s_sideLeftbg= "SideLeftBgmain.gif";
		s_sideRightbg = "SideRightBgmain.gif";
		s_dashbotLeft1= "DashBotLeft1main.gif";
		s_dashbotRight1 = "DashBotRight1main.gif";
	}
%>
<html>
<head>
<title> &nbsp; Alarms &nbsp; - &nbsp; eG Manager &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; </title>
<meta name="Author" content="John Williams" />
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<meta http-equiv="refresh" content="<%=refreshTime.trim()%>;url=<%=metaRefreshUrl.toString()%>">
<link rel="stylesheet" href="eg_styles/eg_monitorstyle.css" />
<script language="javascript">
n = (document.layers) ? 1:0
ie = (document.all) ? 1:0

function show(step)
{
	var layername="layer"+step;
	if(n) document.layers[layername].visibility = "show";
	if(ie) document.all[layername].style.visibility = "visible"
}

function hide(step)
{
	var layername="layer"+step;
	if(n) document.layers[layername].visibility = "hide"
	if(ie) document.all[layername].style.visibility = "hidden"
}
</script>
<script language="javascript">
isIE=document.all?true:false;
var isNS4=document.layers?true:false; 
var isNS6=navigator.userAgent.indexOf("Gecko")!=-1?true:false;
var eg_bC=new Array('#FFFFFF','#E6E6E6');
var eg_C=new Array('#000000','#000000');

var alarmSelectCount = 0;


function onSelectAlarmType()
{
	if (document.eGAlarms.deletealarms.selectedIndex != -1)
	{
		document.eGAlarms.submit();
	}
}

function eg_colorchange(_v)
{
	var eg_X=eval("document.eGAlarms.eg_deletebox"+_v+".checked?0:1");

	if(isIE)
	{
		eval("eg_tr"+_v+".style.backgroundColor=eg_bC[eg_X]");
		eval("eg_tr"+_v+".style.color=eg_C[eg_X]");
	}
	if(isNS6)
	{
		document.getElementById("eg_tr"+_v).style.backgroundColor=eg_bC[X];
		document.getElementById("eg_tr"+_v).style.color=eg_C[eg_X];
	}

	if (eg_X == 0)
	{//Alarm selected
		alarmSelectCount++;
	}
	else
	{//Alarm deselected
		alarmSelectCount--;
	}
}
</script>
<style>
	#alarmborder{border:1px #ffffff }
	#alarmborder td {border:1px #ffffff solid}
	a.alarm:link {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}
	a.alarm:active {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}
	a.alarm:visited {text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}
	a.alarm:hover {text-decoration: underline;color:#000000}
	.alarm{text-decoration:none ;font-family: Verdana, Arial; font-size: 12px; color: #4B4B4B;}
	
</style>
</head>
<body leftmargin="5" topmargin="5" marginheight="5" marginwidth="5" bgcolor="#FFFFFF">
<form name="eGAlarms" method="GET" action="/final/monitor/EgAlarms1.jsp">
<input type="hidden" name="delAlarmIDs" value="<%=System.currentTimeMillis()%>">
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	//If alarms were selected for deletion, do them here
	String result = request.getParameter("delAlarmIDs");
	String[] alarms = this.getSelectedAlarms(result, "#");
	if (alarms != null)
	{
		StringTokenizer st;
		EgDeletedAlarms eda = new EgDeletedAlarms();
		boolean alarmsDeleted = false;
		for (int a=0; a<alarms.length; a++)
		{
			st = new StringTokenizer(alarms[a], "@");

			if (st.countTokens() == 4)
			{
				String cName = st.nextToken();
				String cType = st.nextToken();
				String layer = st.nextToken();
				
				//Now comes the problem, in ways more than one
				String problem = st.nextToken();
				StringTokenizer commaTokenizer = new StringTokenizer(problem, ",");
				int commaCount = commaTokenizer.countTokens();
				for (int b=0; b<commaCount; b++)
				{
					//Now take out the pipes
					StringTokenizer pipeTokenizer = new StringTokenizer(commaTokenizer.nextToken(), "|");
					int pipeCount = pipeTokenizer.countTokens();
					String[] columns = new String[pipeCount];
					for (int c=0; c<pipeCount; c++)
					{
						columns[c] = pipeTokenizer.nextToken();
					}

					String mHost = columns[columns.length-1]; // or pipeCount - 1
					String site = columns[0];
					String desc = columns[1];
					String test = columns[2];
					String measure = columns[3];

					eda.addToDeletedAlarms(mHost, cName+desc, cType, site, layer, test, measure);
					if (!alarmsDeleted)
					{
						alarmsDeleted = true;
					}
				}
			}
		}
		//---Run a loop here to see if the file has been modified after the above loop
		if (alarmsDeleted)
		{
			while (!eda.isDeletionComplete())
			{
				try 
				{
					Thread.sleep(500);
				}
				catch(InterruptedException ie)
				{
					//session.putValue("ErrorMsg", ie.toString());
					throw (ie);
				}
			}
		}
	}
	int selectedPriority = 0;


%>
<table align="left" cellspacing="0" cellpadding="0" width="100%" height="100%" border="0">
	<tr>
		<td width="100%" valign="bottom" align="left" height="32">
			<table align="left" cellspacing="0" cellpadding="0" width="100%" height="32" border="0">
				<tr>
					<td width="36" height="32" nowrap><img src="eg_images/eg_layout/eg_window/<%=s_topLeftImg%>" width="36" height="32" border="0" /></td>
					<th width="100%" id="eg_whitecontent" background="eg_images/eg_layout/eg_window/TopBg.gif" align="left">Alarms</th>
					<th id="eg_calth" nowrap="nowrap" background="eg_images/eg_layout/eg_window/TopBg.gif" align="left">&nbsp;Show :&nbsp;</th>
					<td nowrap background="eg_images/eg_layout/eg_window/TopBg.gif" align="left">
						<select name="deletealarms" onChange="onSelectAlarmType()">
<%
	String selectedOption = request.getParameter("deletealarms");
	if (selectedOption == null)
	{
		selectedOption = options[0];
	}
	else
	{
		for (int a=0; a<options.length; a++)
		{
			if (selectedOption.equals(options[a]))
			{
				selectedPriority = a;
				break;
			}
		}
	}

	out.println(HtmlUtils.setSelectOptions(options, selectedOption));
%>
						</select>
					</td>
					<td width="36" height="32" nowrap><img src="eg_images/eg_layout/eg_window/<%=s_topRightImg%>" width="36" height="32" border="0" /></td>
				</tr>
			</table>
		</td>																									<!--FIRST ROW ENDS HERE-->
	</tr>
	<tr>
		<td width="100%" valign="bottom" align="left" height="100%">										<!--SECOND ROW STARTS HERE-->
			<table align="left" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<tr>
					<td rowspan="2" width="17" nowrap id="eg_blankspace" background="eg_images/eg_layout/eg_window/SideLeftBg.gif" valign="top">
						<img src="eg_images/eg_layout/eg_window/TopLeft2.gif" height="24" border="0" />
					</td>
					<td rowspan="2" width="100%" id="eg_cellbglight" valign="top" height="100%" align="center"><br>
<%
	//Local Variable declarations
	Hashtable ht = null;
	HashMap testKey = null; 
	String status="";
	String strName="";
	String strType="";
	String strLayer="";
	String strTime="";
	String strPriority="";
	String str_sql="";
	String strSite="";
	String strTest="";
	String strMeasure="";
	String strProblem="";
	String strproblem_desc="";
	Vector v_alarms = new Vector();
	String strtok="";
	String str_site = "";
	String str_test = "";

	//one of the new strings for vips
	String str_u_comp = "";
	Statement st=null;
	ResultSet rs=null;
	boolean b_state = false;
	boolean b_recordspresent = false;

	/*
	 * Increment values used for alarms DIV display. 
	 * DO NOT CHANGE IT UNLESS YOU KNOW WHAT YOU ARE DOING.
	 */
	int inc=122;

	int j;
	int k;
	int noalarms = 0;
	Vector v_ph,v_pi,v_pl;
	Vector v_h = new Vector();
	Vector v_i = new Vector();
	Vector v_l = new Vector();

	/*
	 * For showing last measurement value 
	 */
	boolean showLastMeasurementValue = false;
	IniFile servicesIni = new IniFile(new EgConfigInfo(EgConstants.MANAGER).getServicesFile());
	String mailLastValueStr = servicesIni.getValue("MISC_ARGS", "MailLastValue");
	showLastMeasurementValue = (mailLastValueStr != null) && ((mailLastValueStr.equalsIgnoreCase("yes")) || (mailLastValueStr.equalsIgnoreCase("yes")));

	
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	List siteNames = new LinkedList();
	siteNames.addAll(user.getSites());
	siteNames.addAll(user.getServices());

	boolean isDeleteAllowed = ui.isDeleteAlarmsEnabled(user.getLoginID());

	Vector v_user_comp = new Vector();
	v_user_comp.addAll(user.getServers(false));

	Vector v_user_comp_notype = new Vector();
	Map tests = null;
	if (!user.isSuperMonitor())
		tests = user.getTests();
		
	for(int x=0;x < v_user_comp.size();x++)
	{
		String s_tmp = (String)v_user_comp.elementAt(x);
		s_tmp = s_tmp.substring(s_tmp.indexOf(":") + 1);
		s_tmp = s_tmp.substring(0,s_tmp.indexOf(":"));
		s_tmp = s_tmp + ":NULL";
		v_user_comp_notype.add(s_tmp);
	}
	EgDbAdapterUI egDb=EgDbAdapterTypeUI.getObject();
	status=egDb.setConnection();
	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			String str_user_comp = null;
			String str_tmpcomp = null;
			String str_u_comp_type = null;
			
			StringBuffer sb = new StringBuffer(128);
			v_alarms.clear();

			rs = egDb.SelectAlarms();
			b_state=egDb.getState();
			while(rs.next())
			{
				sb = new StringBuffer(128);
				str_u_comp = rs.getString("COMP_NAME");
				str_u_comp_type = rs.getString("COMP_TYPE");
				str_user_comp = str_u_comp_type + ":" + str_u_comp;
				
				boolean bf = false;
				if(str_user_comp.startsWith("Host_system"))
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp,"/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp_notype.contains(str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp_notype.contains(str_u_comp))
					{
						bf = true;
					}
				}
				else
				{
					if(str_u_comp.indexOf("/") > 0)
					{
						StringTokenizer stc = new StringTokenizer(str_u_comp, "/");
						while(stc.hasMoreTokens())
						{
							str_tmpcomp = stc.nextToken();
							if(v_user_comp.contains(str_u_comp_type + ":" + str_tmpcomp))
							{
								bf = true;
								sb.append("/");
								sb.append(str_tmpcomp);
							}
						}
						if(sb != null && sb.length() > 1)
						{
							str_u_comp = sb.substring(1);
						}
					}
					else if(v_user_comp.contains(str_user_comp))
					{
						bf = true;
					}
				}
				if(bf)
				{
					String prob_desc = rs.getString("PROBLEM_DESC");
					boolean pd_flag = false;
					boolean isSuperMonitor = user.isSuperMonitor();
					if (user.isSuperMonitor())
						pd_flag = true;
					StringTokenizer st_tmp = new StringTokenizer(prob_desc, ",");
					prob_desc = "";
					str_site = "";
					str_test = "";
					StringTokenizer st_ftmp = null;
					int i_ctr;
					int i_tokens = st_tmp.countTokens();
					for(i_ctr=0;i_ctr < i_tokens; i_ctr++)
					{
						String tmp_sitestr = st_tmp.nextToken();
						if (isSuperMonitor)
						{
							prob_desc += ","+tmp_sitestr;
							continue;
						}
						st_ftmp = new StringTokenizer(tmp_sitestr,"|");
						str_site = st_ftmp.nextToken();
						String inf = st_ftmp.nextToken();
						String test = st_ftmp.nextToken();
						if(siteNames.contains(str_site) || str_site.equals("NULL"))
						{
							if (tests != null &&
								tests.containsKey(test))
							{
								prob_desc += "," + tmp_sitestr;
								pd_flag = true;
							}
						}
					}
					
					if(pd_flag)
					{
						b_recordspresent=true;
						v_alarms.add(str_u_comp);
						v_alarms.add(str_u_comp_type);
						v_alarms.add(rs.getString("LAYER_NAME"));
						v_alarms.add(rs.getString("MS_TIME"));
						v_alarms.add(rs.getString("PRIORITY"));
						v_alarms.add(prob_desc.substring(1,prob_desc.length()));
						v_alarms.add(rs.getString("ALARM_ID"));
						
					}
				}
			}
			if (rs != null)
			{
				try
				{
					rs.close();
				}
				catch (Exception bug123)
				{
				}
			}
			if(b_recordspresent==false)
			{
				noalarms = 1;
			}

			b_recordspresent=false;
		}
		egDb.releaseConnection(false);
	}
	catch(Exception e)
	{
		String s_errmsg = "";
		if(!status.equals("CONNECTED"))
		{
			s_errmsg = "Could not establish connection with the database";
		}
		else if(b_state == false)
		{
			s_errmsg = "Error in query due to invalid connection";
		}
		else
		{
			s_errmsg = e.toString();
		}
		if (rs != null)
		{
			try
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception ec)
		{
		}
		s_errmsg = "EgProbsM.jsp?msg=" + s_errmsg;
%>
		<jsp:forward page="<%=s_errmsg%>" />

<%
		return;
	}
	
	EgDbAdapterTypeUI.releaseObject(egDb);
%>
		<table  id="alarmborder" cellspacing="0" cellpadding="2" align="center" width="100%" height="19" border="0">
<%
	if (noalarms != 1)
	{
%>
							<tr>
								<td valign="middle" nowrap width="2%" height="19" id="eg_alarmlayerhead" align="center">&nbsp;</td>
								<td valign="middle" class="submenu" nowrap width="15%" height="19" id="eg_alarmlayerhead" align="center">START TIME </td>
								<td align="center" width="20%" height="19" id="eg_alarmlayerhead" > COMPONENT </td>
								<td id="eg_alarmlayerhead" width="23%" align="center">COMP TYPE</td>
								<td valign="middle" nowrap width="40%" height="19" id="eg_alarmlayerhead" align="center"> DESCRIPTION </td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center" height="323" id="eg_errorbig"><img src="eg_images/eg_layout/eg_error.gif" width="150" height="150" align="center" border="0" vspace="10" /><br>No alarms found</td>
							</tr>
<%

	}

	ht = (Hashtable) session.getAttribute("alarm_vects");
	if( ht != null)
	{
		v_ph = (Vector)ht.get("high");
		v_pi = (Vector)ht.get("inter");
		v_pl = (Vector)ht.get("low");
	}
	else
	{
		v_ph = new Vector();
		v_pi = new Vector();
		v_pl = new Vector();
	}

	k=0;

	DateTimeTokenizer dtt = new DateTimeTokenizer();
	dtt.setDateFormat(DateTimeTokenizer.MDY);
	dtt.setTimeFormat(DateTimeTokenizer.HMS);
	dtt.setYearAsYY(true);

	List forDivTag = new LinkedList();
	egDb = EgDbAdapterTypeUI.getObject();
	status=egDb.setConnection();

	EgTablesInfo tablesInfo = new EgTablesInfo(EgConstants.MANAGER);

	for(int v_ctr=0; v_ctr < v_alarms.size(); v_ctr=v_ctr + 7)
	{
		strName=(String) v_alarms.elementAt(v_ctr);
		strType=(String) v_alarms.elementAt(v_ctr + 1);
		strLayer=(String) v_alarms.elementAt(v_ctr + 2);
		//strTime=(String) v_alarms.elementAt(v_ctr + 3);
		dtt.setStartDateTime((String) v_alarms.elementAt(v_ctr + 3));
		strTime = dtt.getStartDateAsFormat(DateTimeTokenizer.MDY, DateTimeTokenizer.SLASH_SEPARATOR) + DateTimeTokenizer.BLANK_SPACE + dtt.getStartTimeAsFormat(DateTimeTokenizer.HM,DateTimeTokenizer.COLON_SEPARATOR);
		strPriority = (String) v_alarms.elementAt(v_ctr + 4);
		
		int priority = priorities[0];//At the moment equals 10
		String colr = colrs[0];
		if(strPriority.equalsIgnoreCase(AlarmPriorities.HIGH_PRIORITY))
		{
			priority = 2;
			colr = "r" ;
			v_h.add(v_alarms.elementAt(v_ctr+6));
		}
		else if(strPriority.equalsIgnoreCase(AlarmPriorities.MEDIUM_PRIORITY))
		{
			priority = 1;
			colr = "o" ;
			v_i.add(v_alarms.elementAt(v_ctr+6));
		}
		else
		{
			priority = 0;
			colr = "p" ;
			v_l.add(v_alarms.elementAt(v_ctr+6));
		}
		if (priority >= selectedPriority)
		{
			String[] compNameTokens = StringUtils.getTokens(strName, "/");
			str_u_comp = compNameTokens[0];

			strProblem = (String) v_alarms.elementAt(v_ctr + 5);
			StringTokenizer sta = new StringTokenizer(strProblem, ",");
			int index = -1;
			String mHost = null;
			int tokensCount = sta.countTokens();
			List row = new LinkedList();
			testKey = new HashMap();
			while (sta.hasMoreTokens())
			{
				String problemDesc = sta.nextToken();
				StringTokenizer st_ftmp = new StringTokenizer(problemDesc ,"|");
				str_site =st_ftmp.nextToken();
				String inf = st_ftmp.nextToken();
				String test = st_ftmp.nextToken();
				str_test = test + "-" + inf;
				String measure = st_ftmp.nextToken();

				if((!siteNames.contains(str_site)) && (!str_site.equals("NULL")))
				{
					continue;
				}

				String[] values;
				if (showLastMeasurementValue)
				{
					values = new String[6];
				}
				else
				{
					values = new String[5];
				}	

				values[0] = test;
				values[1] = measure;
				values[2] = str_site;
				values[3] = inf;
				String inf1 = " ";
				String inf11 = " ";
				String info = values[3].substring(1,values[3].length());
				StringBuffer str_inf = new StringBuffer();
				str_inf.append(values[0]);
				str_inf.append(":");
				str_inf.append(values[1]);
				StringBuffer sb =(StringBuffer) testKey.get(str_inf.toString());
				if (sb!=null)
				{
					if ((", " + sb.toString() + ",").indexOf(", " + info + ",") ==-1)
					{
						sb.append(", ");
						sb.append(info);
					}
					testKey.put(str_inf.toString(),sb);
					//inf11 = (String)testKey.get(str_inf.toString());
				}
				else
				{
					sb = new StringBuffer(info);
					testKey.put(str_inf.toString(),sb);
					//inf1 = (String)testKey.get(str_inf.toString());
				}
				
				values[4] = st_ftmp.nextToken();
				/*
				 * For clubbed alarms, the DispLayers page shows information for
				 * the first component. So use the measurement host of the first
				 * component only.
				 */
				if (mHost == null)
				{
					mHost = values[4];
				}


			}

%>
										
<%

			String displayString = StringUtils.replace(strName,":NULL"," ");
			//System.out.println("displayString : " + displayString);
/*			if (strName.length() > 50)
			{
				displayString = StringUtils.elipsis(strName, 50);
			}
*/			
%>

<%
					Iterator itr = testKey.keySet().iterator();
					while (itr.hasNext()) 
					{
						String s = (String) itr.next();

						String inn =  testKey.get(s).toString();
						StringTokenizer st_test = new StringTokenizer(s ,":");
						String tst = st_test.nextToken();
						String DispString = split(displayString,20);
%>
											<tr>
												<td width="2%" nowrap align="center" valign="middle" >
												<a class="alarm" href="EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=<%=str_u_comp%>&layer=<%=strLayer%>&site=<%=str_site%>&test=<%=str_test%>&comptype=<%=strType%>&tstate=<%=strPriority%>&msmt_host=<%=mHost%>" target="eg_operations"
												><img src="/final/reporter/images/<%=colr%>circle.gif" border="0"></a></td>

												<td align="center" id="eg_cellbglits" width="15%" nowrap><a  class="alarm" href="EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=<%=str_u_comp%>&layer=<%=strLayer%>&site=<%=str_site%>&test=<%=str_test%>&comptype=<%=strType%>&tstate=<%=strPriority%>&msmt_host=<%=mHost%>" target="eg_operations" 
												id="eg_alarmlink"><%=strTime%></a></td>

												<td align="left" id="eg_cellbglits" width="20%">&nbsp;<a class="alarm" href="EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=<%=str_u_comp%>&layer=<%=strLayer%>&site=<%=str_site%>&test=<%=str_test%>&comptype=<%=strType%>&tstate=<%=strPriority%>&msmt_host=<%=mHost%>" target="eg_operations" 
												id="eg_alarmlink"><%=DispString%></a></td>

												<td id="eg_cellbglits"  width="23%" nowrap align="center" valign="middle" >
												<a class="alarm"  href="EgSiteInfraView.jsp?qctr=2&fromalarm=1&host=<%=str_u_comp%>&layer=<%=strLayer%>&site=<%=str_site%>&test=<%=str_test%>&comptype=<%=strType%>&tstate=<%=strPriority%>&msmt_host=<%=mHost%>" target="eg_operations" id="eg_alarmlink"
												><%=strType%></a></td>        
												<td id="eg_cellbglits" nowrap class="alarm" width="40%" >&nbsp;
											<%
											if(inn.trim().length() > 0)inn="<b>" +inn +"</b>";	%><%=split(tablesInfo.getMeasureAlert(s,inn),50)	%> &nbsp;</td> 	
												</tr>
												
<%
		}	//**end of while loop**
%>
														

 <%
		}
	}
%>
		</table>

<%
	try
	{
		if(status != null && status.equals("CONNECTED"))
		{
			egDb.releaseConnection(false);
		}
	}
	catch(Exception e)
	{
		egDb.releaseConnection(true);
	}
	EgDbAdapterTypeUI.releaseObject(egDb);

%>

					</td>
				
				<td width="17" nowrap id="eg_blankspace" background="eg_images/eg_layout/eg_window/SideRightBg.gif" valign="top"><img src="eg_images/eg_layout/eg_window/TopRight2.gif" width="17" height="24" border="0" /></td>
		</tr>
		<tr>
				<td width="17" nowrap id="eg_blankspace" background="eg_images/eg_layout/eg_window/SideRightBg.gif" valign="bottom" align="right">
					<img src="eg_images/eg_layout/eg_window/BottomRight3.gif" width="17	" height="24" border="0" hspace="0" align="right"/>
				</td>
		</tr>
		</table>
		</td>
		<!--SECOND ROW ENDS HERE-->
	</tr>
	<tr>
		<td width="100%" height="34" valign="top" align="right">
		<!--THIRD ROW STARTS HERE-->

			<table align="left" cellspacing="0" cellpadding="0" width="100%" height="34" border="0">
					<tr>
					<td width="36" height="34" nowrap><img src="eg_images/eg_layout/eg_window/BottomLeft.gif" width="36" height="34" border="0"></td>
					<td width="100%" align="center" background="eg_images/eg_layout/eg_window/BottomBgLeft.gif"><jsp:include page="EgFooter.jsp" flush="true"/></td>
					<td width="70" height="34"><img src="eg_images/eg_layout/eg_window/BottomCurve.gif" width="70" height="34" border="0"></td>
					<td width="60" nowrap height="34" background="eg_images/eg_layout/eg_window/BottomBgRight.gif"><img src="eg_images/eg_layout/eg_window/HIGH.gif" width="46" alt="  <%=ui.getStateDisplayLabel(AlarmPriorities.HIGH_PRIORITY)%>  " height="34" border="0"></td>
					<td width="60" nowrap height="34" background="eg_images/eg_layout/eg_window/BottomBgRight.gif"><img src="eg_images/eg_layout/eg_window/INTERMEDIATE.gif" width="46" alt="  <%=ui.getStateDisplayLabel(AlarmPriorities.MEDIUM_PRIORITY)%>  " height="34" border="0"></td>
					<td width="60" nowrap height="34" background="eg_images/eg_layout/eg_window/BottomBgRight.gif"><img src="eg_images/eg_layout/eg_window/LOW.gif" width="46" alt="  <%=ui.getStateDisplayLabel(AlarmPriorities.LOW_PRIORITY)%>  " height="34" border="0"></td>
					<td width="60" nowrap height="34" background="eg_images/eg_layout/eg_window/BottomBgRight.gif"><img src="eg_images/eg_layout/eg_window/UNKNOWN.gif" width="46" alt="  <%=ui.getStateDisplayLabel(AlarmPriorities.UNKNOWN_STATE)%>  " height="34" border="0"></td>
					<td width="46" height="34" background="eg_images/eg_layout/eg_window/BottomBgRight.gif"><img src="eg_images/eg_layout/eg_window/GOOD.gif" width="46" alt="  <%=ui.getStateDisplayLabel(AlarmPriorities.GOOD_STATE)%>  " height="34" border="0"></td>
					<td width="36" height="34" nowrap><img src="eg_images/eg_layout/eg_window/BottomRight.gif" width="38" height="34" border="0"></td>
				</tr>
			</table>	
		</td>
		<!--THIRD ROW STARTS HERE-->
	</tr>
</table>
<!----- MAIN TABLE ENDS HERE ----->

<%
	v_alarms.clear();

	inc=0;
	String s_high_wav = "eg_waves/high.wav";
	String s_inter_wav = "eg_waves/medium.wav";
	String s_low_wav = "eg_waves/low.wav";
	if(v_h.size() > 0 || v_i.size() > 0 || v_l.size() > 0)
	{
		if(v_h.size() > v_ph.size())
		{
			out.println("<bgsound src='" + s_high_wav + "' loop='1'>");
		}
		else if(! v_h.equals(v_ph) && v_h.size() > 0)
		{
			out.println("<bgsound src='" + s_high_wav + "' loop='1'>");
		}
		else if(v_i.size() > v_pi.size())
		{
			out.println("<bgsound src='" + s_inter_wav + "' loop='1'>");
		}
		else if(! v_i.equals(v_pi) && v_i.size() > 0)
		{
			out.println("<bgsound src='" + s_inter_wav + "' loop='1'>");
		}
		else if(v_l.size() > v_pl.size())
		{
			out.println("<bgsound src='" + s_low_wav + "' loop='1'>");
		}
		else if(!v_l.equals(v_pl) && v_l.size() > 0)
		{
			out.println("<bgsound src='" + s_low_wav + "' loop='1'>");
		}
	}

	ht = new Hashtable();
	ht.put("high",v_h);
	ht.put("inter",v_i);
	ht.put("low",v_l);
	session.setAttribute("alarm_vects", ht);

%>

</form>
</body>
</html>
<%!
	String blank = "&nbsp;";
	public String checkForNULL(String str)
	{
		if(str.equals("NULL"))
		{
			return "NONE";
		}
		else
		{
			return str;
		}
	}

	public String[] getSelectedAlarms(String result, String alarmSeparator)
	{
		if (result != null)
		{
			String[] alarms = null;
			StringTokenizer st;
			if (result.indexOf(alarmSeparator) != -1)
			{
				st = new StringTokenizer(result, alarmSeparator);
				int count = st.countTokens();
				alarms = new String[count];
				for (int a=0; a<count; a++)
				{
					alarms[a] = st.nextToken();
				}
			}
			else
			{
				alarms = new String[1];
				alarms[0] = result;
			}
			return alarms;
		}
		return null;
	}

	private String split (String string, int width)
	{
		String breakStr = "<br>&nbsp;&nbsp;";
		StringBuffer splitStr = new StringBuffer();

		int times = string.length()/width;
		int start = 0;
		for (int a=0; a<times; a++)
		{
			splitStr.append(string.substring(start, start+width));
			splitStr.append(blank);
			start += width;
			splitStr.append(breakStr);
		}

		splitStr.append(string.substring(width*times));
		return splitStr.toString();
	}


%>






