<%
/*****************************************************************************
*	Name			:	EgAgentDebugMode.jsp
*	Purpose			:	To view the Log Files from the selected Agent 
******************************************************************************/
%>
<%@ page import = "java.io.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgDiscInfo"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgManagersIniForManager"%>
<%@ page import = "com.eg.EgControlInfo"%>
<%@ page import = "com.eg.PollingServlet"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean agentNotReporting = false;
	boolean fileNotCreated = true;
	Vector lines = new Vector();
	String agentID = request.getParameter("componentName");
	String fileNameToRead = request.getParameter("file");
	if(!StringUtils.isNull(fileNameToRead))
	{
		String sep = System.getProperty("file.separator");
		if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
		{
			agentID = agentID.substring(0,agentID.indexOf(":"));
		}
		boolean controlModeCheckNeeded = true;
		IniFile controlsDotIni_1 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		String idlePeriod = controlsDotIni_1.getValue("CONTROL_DEFAULTS","IdlePeriod");
		if(StringUtils.isNull(idlePeriod))
		{
			idlePeriod="300";//seconds
		}
		long idlePeriodMS = Integer.parseInt(idlePeriod) * 1000;
		// PLEASE REFER final/monitor/ConfigureControlAction.jsp PAGE IF ANY CLARIFICATION IS NEEDED.
		//set agent's CONTROL_SETTINGS to "true" in eg_controls.ini and wait until it is restet to false
		//get the hash from PollingServlet, parser the key if match found write value = false, else true
		Vector ipVec = null;
		boolean checkIni = false;
		String key="none";
		if(PollingServlet.agentID != null && PollingServlet.agentID.size() > 0)
		{
			EgControlInfo ctrlInfo = new EgControlInfo("manager");
			Enumeration e = PollingServlet.agentID.keys();
			//Get the valid IPSTR for this agent IP
			while(e.hasMoreElements())
			{
				String ip = (String) e.nextElement();
				/*ip = ctrlInfo.getAllNamesOf(ip);
				StringTokenizer st = new StringTokenizer(ip,":");
				ipVec = new Vector();
				while(st.hasMoreTokens())
				{
					ipVec.add(st.nextToken());
				}*/
				ArrayList ipAddrs=ctrlInfo.getAllNamesOf(ip);
				if(ipAddrs!=null && !ipAddrs.isEmpty())
				{
					ipVec=new Vector();
					ipVec.addAll(ipAddrs);
				}
				if(ipVec!=null && ipVec.contains(agentID))
				{
					checkIni = true;
					break;
				}
			}
			if(checkIni)
			{
				String ipArr[] = controlsDotIni_1.getVariables("CURRENT_CONTROLS");
				if(ipArr != null)
				{
					for(int i=0;i<ipArr.length;i++)
					{
						if(ipVec.contains(ipArr[i]) )
						{
							String flag = controlsDotIni_1.getValue("CURRENT_CONTROLS",ipArr[i]);
							if(flag != null )
							{
								if( flag.equals("false") )
								{
									key="control";
									break;
								}
								else if( flag.equals("true") )
								{
									key="waiting";
								}
								else
								{
									key="normal";
								}
							}
						}
					}
				}
				else
				{
					key="normal";
				}
				if(key.equalsIgnoreCase("control"))
				{
					controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"false");
				}
				else
				{
					controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
				}
			}
			else
			{
				controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
			}
		}
		else
		{
			controlsDotIni_1.setValue("CURRENT_CONTROLS",agentID,"true");
		}
		controlsDotIni_1.saveFile();

		boolean idleBreak = false;
		if(controlModeCheckNeeded)
		{
			long startTime = System.currentTimeMillis();
			long elapsedTime = 0;
			while(true)
			{
				IniFile controlsDotIni_2 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini");
				String temp = controlsDotIni_2.getValue("CURRENT_CONTROLS",agentID);
				if(elapsedTime>=idlePeriodMS || StringUtils.isNull(temp))
				{
					idleBreak = true;
					break;
				}
				else if(temp.equals("false"))
				{
					break;
				}
				Thread.sleep(5000);
				elapsedTime =  System.currentTimeMillis() - startTime;
			}
		}
		EgDiscInfo discInfo = new EgDiscInfo("manager");
		Hashtable nickIpMap = discInfo.getNickIpMap();
		String agentIp =(String) nickIpMap.get(agentID);
		String taskName = "ReadFile";
		String val = fileNameToRead + "@#@Y";
		IniFile controlsDotIni_3 = new IniFile(EgInstallInfo.getInstallDir()+sep+"manager"+sep+"config"+sep+"eg_controls.ini",true);
		String timeout = controlsDotIni_3.getValue("CONTROL_DEFAULTS","TimeOut");
		if(!idleBreak)
		{
			controlsDotIni_3.setValue(agentID,taskName+":"+session.getId(),val);
		}
		controlsDotIni_3.saveFile();

		//If the file is already Exists delete it ,
		String tmpFilePath = EgInstallInfo.getInstallDir()+sep+"tmp"+sep+agentID+"_"+session.getId()+"."+taskName;
		try{
			File tmpFile = new File(tmpFilePath);
			if(tmpFile!=null && tmpFile.exists())
			{
				tmpFile.delete();
			}
		}
		catch(Exception e){
		}

		long timeLapse=0;
		long totSleepTime=0;
		long sleepTime=1000;
		timeout = (timeout != null && !timeout.equals(""))? timeout : "60";
		if(timeout == null || timeout.equals(""))
		{
			totSleepTime = 10000;
		}
		else
		{
			try
			{
				totSleepTime = Long.parseLong(timeout)*1000;
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		while(!idleBreak)
		{
			File f = new File(tmpFilePath);
			if(f != null && f.exists())
			{
				lines = new Vector();
				fileNotCreated = false;
				BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f),"UTF-8"));
				String line = null;
				while((line=br.readLine()) != null)
				{
					if(!StringUtils.isNull(line))
					{
						lines.add(line.trim());
					}
				}
				br.close();
				f.delete();
				break;
			}
			else
			{
				if(timeLapse < totSleepTime)
				{
					timeLapse += sleepTime;
					Thread.currentThread().sleep(sleepTime);
				}
				else
				{
					agentNotReporting = true;
					break;
				}
			}
		}
	}
%>
<html>
<head>
<title>eG Agent Logs </title>
<egui:skin ui="admin"/>

</head>
<body style="overflow:auto" scrolling="yes">
<table cellspacing="0" cellpadding="0" border="0" bordercolor="red" width="100%" height="100%">
	<tr>
<%
	if(lines != null && lines.size()>0)
	{
%>
		<td align="center" width="100%" height="100%" class="eg_subcontentbg" valign="top">
		<div id="dispDiv" align="left"  name="dispDiv" style="display:block;padding:4px;border:0px solid red">
<%
		for(int i=0;i<lines.size();i++)
		{
			out.println("\t"+lines.get(i)+"<br>");
		}
%>
		</div>
		</td>
<%
	}
	else if(agentNotReporting || fileNotCreated)
	{
%>
		<td align="center" width="100%" height="100%" class="eg_subcontentbg" valign="middle">
			<table cellspacing="0" cellpadding="0" border="0" bordercolor="blue" width="100%" height="100%">
				<tr>
					<td align="center" width="100%">
						<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
							<b>Timed out</b></td>
				</tr>
			</table>
		</td>
<%
	}
	else
	{
%>
		<td align="center" width="100%" height="100%" class="eg_subcontentbg" valign="middle">

			<table cellspacing="0" cellpadding="0" border="0" bordercolor="blue" width="100%">
				<tr>
					<td align="center" width="100%" >
						<img src="/final/admin/eg_images/blue/exclamation-icon.gif"><br>
							<b>There is no <%=fileNameToRead%> file (or) data is empty </b></div>
					</td>
				</tr>
			</table>
		</td>
<%
	}
%>
	</tr>
</table>
<script type="text/javascript">
function hideLoadImage ()
{
	try
	{
		var loading_image = parent.document.getElementById("loading_image");
		if (loading_image != null){
			loading_image.style.display = "none";
		}
		parent.selectBoxDisable('false');
	}
	catch(e){
	}
}
window.onload = hideLoadImage;
</script>
</body>
</html>