<%
/**
 * Name			:	EgAHelpFrame.jsp
 * Purpose		:	This jsp displays the help for all admin pages
 * Author		:	Sasikala.M
 */
%>

<%@ page isThreadSafe="false" %>
<%@ page errorPage="EgAerr.html"%>
<%@ page import="java.util.*" %>
<%@ page import="java.io.*" %>
<%@ page import="com.eg.*" %>
<%@ page import="com.egurkha.*"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="application/json;charset=UTF-8;" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%!
	//This unit represents the number of maximum help pages + 1
	int i_maxpages = 8834;
	static String logDir = EgConfigInfo.optEgurkha + "/manager/logs/" ;
	public static synchronized void logToErrorFile(String module, String fileName, String id, String user)
	{
		PrintWriter logWriter;
		String log;
		EgDateInfo dateInfo = new EgDateInfo();
		String logDateAndTime = dateInfo.egetDate(false);
		File ff = new File(logDir + "eghelp");
		if (ff.length() >= 1000000)
		{
			EgInstallInfo.fileRename(logDir + "eghelp",logDir + "eghelp"+".1");
		}
		ff = null;
		try
		{
			//open log file for writing
			logWriter = new PrintWriter(new FileWriter(logDir + "eghelp", true));
		}
		catch(Exception e)
		{
			System.err.println("Cannot open log file ");
			return;
		}
		log=new String(logDateAndTime+" ["+module+" : "+fileName+" : "+id+"] " +user);
		logWriter.println(log);
		logWriter.close();
	}
%>

<%
	JSONObject rootJson = new JSONObject();
	IniFile uiFile = new IniFile(EgInstallInfo.getInstallDir()+ "/manager/config/eg_ui.ini");
	String flag = uiFile.getValue("DEBUG_MODE", "help");
	boolean debug = (flag != null && !flag.equals("") && flag.equalsIgnoreCase("yes"));
	HelpXMLFileReader egHelp = HelpParserThread.egHelp;

	int i_prev = 0;
	int i_next = 0;
	String s_page = "";
	boolean showSpecificTestConfigurationHelpPage = false;
	boolean showDefaultTestConfigurationHelpPage = false;
	boolean isICTest=false;
	boolean isAggregateTest=false;

	String s_id = request.getParameter("id");
	String s_test=request.getParameter("test");
	String from=request.getParameter("from");
	String page_temp = "";

	try
	{
		egHelp.setModule("APage");

		if (!StringUtils.isNull(s_id) && (s_test == null || s_test.equals("")))
		{
			s_test = egHelp.getTestForId(s_id.trim());
		}

		if (StringUtils.isNull(s_id))
		{
			String s_module = "";
			String s_path = (String)session.getAttribute("Page_IdentifierA");

			String tmp_path = s_path;
			if (s_path != null)
			{
				String s_qstring = "";
				int questionIndex = s_path.indexOf("?");
				if (questionIndex > -1)
				{
					s_qstring = s_path.substring(questionIndex+1);
					s_path = s_path.substring(0,questionIndex);
					if (s_path.indexOf(";") > -1)
					{
						s_path = s_path.substring(0,s_path.indexOf(";"));
					}
				}

				s_module = s_path.substring(0,s_path.lastIndexOf("/"));
				s_module = s_module.substring(s_module.lastIndexOf("/")+1);
				if (s_path.indexOf("AnyPeriod") == -1 && 
					s_path.indexOf("Script/Batch") == -1)
				{
					s_path = s_path.substring(s_path.lastIndexOf("/")+1);
				}

				String[] grpToks = StringUtils.getTokens(s_qstring,"&");
				ArrayList aListKeys = new ArrayList();
				ArrayList aListValues = new ArrayList();
				if (!s_qstring.equals("null"))
				{
					for (int i=0;i<grpToks.length ;i++ )
					{
						if (grpToks[i].equals("null"))
						{
							continue;
						}
						aListKeys.add(grpToks[i].substring(0,grpToks[i].indexOf("=")).trim());
						aListValues.add(grpToks[i].substring(grpToks[i].indexOf("=")+1).trim());
					}
				}
				
				String s_process = "";
				if (s_path.equals("egAlertOptionsJson.jsp")) //MailAlertSettings
				{
					int indexkey = aListKeys.indexOf("selectedNode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("mailalertpreferences"))
					{
						s_path = "egAlertOptions_MAP.jsp";
					}
					else if (s_process.equals("heartbeat"))
					{
						s_path = "egAlertOptions_HBT.jsp";
					}
					else if (s_process.equals("alarmescalation"))
					{
						s_path = "egAlertOptions_AE.jsp";
					}
					else if (s_process.equals("shiftperiods"))
					{
						s_path = "egAlertOptions_SP.jsp";
					}
					else if (s_process.equals("maillogdetails"))
					{
						s_path = "egAlertOptions_MLD.jsp";
					}
					else if (s_process.equals("filtermailsms"))
					{
						s_path = "egAlertOptions_FMS.jsp";
					}
					else if (s_process.equals("licenseusagemail"))
					{
						s_path = "egAlertOptions_LIC.jsp";
					}
					else if (s_process.equals("configMailSettings"))
					{
						s_path = "egAlertOptions_CMS.jsp";
					}
				}
				else if (s_path.equals("generalSettingsJSON.jsp") || s_path.equals("generalSettingsJSONp.jsp"))
				{
					s_path = "managerSettings1.jsp";
				}
				else if (s_path.equals("managerNotificationJSON.jsp") || s_path.equals("managerNotificationJSONp.jsp"))
				{
					s_path = "managerSettings2.jsp";
				}
				else if (s_path.equals("testConfigurationJSON.jsp") || s_path.equals("testConfigurationJSONp.jsp"))
				{
					s_path = "managerSettings3.jsp";
				}
				else if (s_path.equals("thresholdConfigurationJSON.jsp") || s_path.equals("thresholdConfigurationJSONp.jsp"))
				{
					s_path = "managerSettings4.jsp";
				}
				else if (s_path.equals("commandExecutionJSON.jsp") || s_path.equals("commandExecutionJSONp.jsp"))
				{
					s_path = "managerSettings5.jsp";
				}
				else if (s_path.equals("commonSettingsTTI_JSON.jsp") || s_path.equals("commonSettingsTTI_JSONp.jsp"))
				{
					s_path = "egttcommonsettingshelp.jsp";
				}
				else if (s_path.equals("mailSnmpTTI_JSON.jsp") || s_path.equals("mailSnmpTTI_JSONp.jsp"))
				{
					s_path = "managerSettingsMailSnmp.jsp";
				}
				else if (s_path.equals("cliTTI_JSON.jsp") || s_path.equals("cliTTI_JSONp.jsp"))
				{
					s_path = "managerSettings6.jsp";
				}
				else if (s_path.equals("webServicesTTI_JSON.jsp") || s_path.equals("webServicesTTI_JSONp.jsp"))
				{
					s_path = "uploadWrapperJSONp.jsp";
				}
				else if (s_path.equals("logSettingsJSON.jsp") || s_path.equals("logSettingsJSONp.jsp"))
				{
					s_path = "managerSettings7.jsp";
				}
				else if (s_path.equals("auditingJSON.jsp") || s_path.equals("auditingJSONp.jsp"))
				{
					s_path = "managerSettings8.jsp";
				}
				else if (s_path.equals("advanceSettingsJSON.jsp") || s_path.equals("advanceSettingsJSONp.jsp"))
				{
					s_path = "managerSettings9.jsp";
				}
				else if (s_path.equals("capacityPlanningJSON.jsp") || s_path.equals("capacityPlanningJSONp.jsp"))
				{
					s_path = "managerSettings10.jsp";
				}
				else if (s_path.equals("virtualTopologyJSON.jsp") || s_path.equals("virtualTopologyJSONp.jsp"))
				{
					s_path = "managerSettings11.jsp";
				}
				else if (s_path.equals("accountLockoutJSON.jsp") || s_path.equals("accountLockoutJSONp.jsp"))
				{
					s_path = "managerSettings12.jsp";
				}
				else if (s_path.equals("passwordPolicyJSON.jsp") || s_path.equals("passwordPolicyJSONp.jsp"))
				{
					s_path = "managerSettings13.jsp";
				}
				else if (s_path.equals("eguiJSON.jsp") || 
						s_path.equals("eguiJSONp.jsp")) //MonitorSettings
				{
					int indexkey = aListKeys.indexOf("process");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("alarms"))
					{
						s_path = "egui2.jsp";
					}
					else if (s_process.equals("graphs"))
					{
						s_path = "egui3.jsp";
					}
					else if (s_process.equals("othersettings"))
					{
						s_path = "egui4.jsp";
					}
				}
				else if (s_path.equals("EgConfigLogoMsgJSON.jsp") || 
						s_path.equals("EgconfiglogomsgJSONp.jsp")) //LogoMessages
				{
					int indexkey = aListKeys.indexOf("process");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("loginscreen"))
					{
						s_path = "EgConfigLogoMsgJSON.jsp";
					}
					else if (s_process.equals("monitorinterface"))
					{
						s_path = "EgConfigLogoMsg_MI.jsp";
					}
					else if (s_process.equals("reporterinterface"))
					{
						s_path = "EgConfigLogoMsg_RI.jsp";
					}
					else if (s_process.equals("configmanageinterface"))
					{
						s_path = "EgConfigLogoMsg_CI.jsp";
					}
					else if (s_process.equals("audiblealerts"))
					{
						s_path = "EgConfigLogoMsg_AA.jsp";
					}
					else if (s_process.equals("messages"))
					{
						s_path = "EgConfigLogoMsg_MSG.jsp";
					}
				}
				else if(s_path.equals("uedConfigJSON.jsp"))
				{
					Object val = session.getAttribute("Source");
					if(val != null)
					{
						s_path=s_path+"?"+(String)val;
						//s_id = egHelp.getId(s_path+"?"+(String)val);
					}
				}
				else if (s_path.equals("EgChangePortsJson.jsp") || 
						s_path.equals("EgchangeportspJson.jsp") || 
						s_path.equals("EgRHEVDiscoveryJson.jsp") || 
						s_path.equals("EgRHEVdiscoverypJson.jsp") ||
						s_path.equals("EgAssignRemoteAgentsList.jsp")) //Discovery
				{
					int indexkey = aListKeys.indexOf("selectedNode");
					if(indexkey == -1)
						indexkey = aListKeys.indexOf("vCenter");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("node1"))
					{
						s_path = "EgChangePorts1.jsp";
					}
					else if (s_process.equals("node2") || s_process.equals("all"))
					{
						s_path = "EgChangePorts2.jsp";
					}
					else if (s_process.equals("node3"))
					{
						s_path = "EgChangePorts3.jsp";
					}
					else if (s_process.equals("node4"))
					{
						s_path = "EgConfigEnvJson.jsp";
					}
					else if (s_process.equals("node10"))
					{
						s_path = "EgChangePorts4.jsp";
					}
					else if (s_process.equals("popUp"))
					{
						s_path = "EgChangePorts_pop.jsp";
					}
				}
				else if (s_path.equals("EgAgentDiscoverJson.jsp") || 
						s_path.equals("EgAgentDiscoverpJson.jsp")) //AgentDiscoveryAction
				{
					int indexkey = aListKeys.indexOf("selectedNode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("node8"))
					{
						s_path = "EgAgentDiscoverJson.jsp";
					}
					else if (s_process.equals("node9"))
					{
						s_path = "EgAgentDiscover_ED.jsp";
					}
				}
				else if (s_path.equals("msshelpJson.jsp") || 
						s_path.equals("sendMailAlertJson.jsp") ||
						s_path.equals("EgBackupMailServerpJson.jsp"))//MailServerSettings
				{
					int indexkey = aListKeys.indexOf("activeTabId");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("mailsmssettings"))
					{
						s_path = "EgMailServerSettingsJson.jsp";
					}
					else if (s_process.equals("bckmailsettings"))
					{
						s_path = "EgBackupMailServerpJson.jsp";
					}
				}
				else if (s_path.equals("EgManageAgentsJson.jsp") || //Upgrade-Settings
					s_path.equals("EgmanageagentspJson.jsp"))
				{
					int indexkey = aListKeys.indexOf("node");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1"))
					{
						s_path = "EgManageAgentsJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgManageAgentsJson_US.jsp";
					}
					else if (s_process.equals("tab3"))
					{
						s_path = "EgManageAgentsJson_UN.jsp";
					}
				}
				else if (s_path.equals("EgSnmpTrapReceiverConfigJson.jsp") || //Receviers and Settings
						s_path.equals("Egsnmpconfigp.jsp"))
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("addsnmp") || s_process.equals("1004"))
					{
						s_path = "EgSnmpConfig_ADD.jsp";
					}
					else if (s_process.equals("modifysnmp"))
					{
						s_path = "EgSnmpConfig_MOD.jsp";
					}
					else if (s_process.equals("deletesnmp"))
					{
						s_path = "EgSnmpConfig_DEL.jsp";
					}
					else if (s_process.equals("viewsnmp"))
					{
						s_path = "EgSnmpConfig_VIEW.jsp";
					}
					else if (s_process.equals("settingsnmp"))
					{
						s_path = "EgSnmpConfigSettingsJson.jsp";
					}
				}
				else if (s_path.equals("viewroleshelpJson.jsp") || //Roles
						s_path.equals("EgViewRolesJson.jsp"))
				{
					int indexkey = aListKeys.indexOf("selectedTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1") )
					{
						s_path = "EgViewRolesJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgViewRoles_UDR.jsp";
					}
				}
				else if (s_path.equals("licensehelpJson.jsp")) //License
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1") )
					{
						s_path = "EgLicenseInfoJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgLicenseInfoJson_Usage.jsp";
					}
					else if (s_process.equals("tab3"))
					{
						s_path = "EgLicenseInfoJson_User.jsp";
					}
					else if (s_process.equals("tab4"))
					{
						s_path = "EgLicenseInfoJson_Zone.jsp";
					}
				}
				else if (s_path.equals("reportcustomsettingshelpJson.jsp"))//Capacity Planning Report
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("ConfigurePercentilePolicy") )
					{
						s_path = "EgReportSysSettingJSON.jsp";
					}
					else if (s_process.equals("ConfigureTests"))
					{
						s_path = "EgReportSettingJSON.jsp";
					}
					else if (s_process.equals("ConfigureSystemReports"))
					{
						s_path = "EgReportSysSetting.jsp";
					}
				}
				else if (s_path.equals("agentupgradestatushelpJson.jsp"))//Upgrade-Status
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1") )
					{
						s_path = "EgUpgradeStatusJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgUpgradeStatusJson_OS.jsp";
					}
				}
				else if (s_path.equals("egadduserhelpJson.jsp"))//AddUser
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1") )
					{
						s_path = "EgAddUserJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgAddUserJson_UP.jsp";
					}
				}
				else if (s_path.equals("changeusrprofilehelpJson.jsp"))//Modify User
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("tab1") )
					{
						s_path = "EgChangeUserProfileJson.jsp";
					}
					else if (s_process.equals("tab2"))
					{
						s_path = "EgChangeUserProfileJson_2.jsp";
					}
					else if (s_process.equals("tab3"))
					{
						s_path = "EgUserSiteServersJson.jsp";
					}
					else if (s_process.equals("tab4"))
					{
						s_path = "EgMailAlertSuppressJson.jsp";
					}
				}
				else if (s_path.equals("ictesthelpJson.jsp"))//Test
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("addtest") )
					{
						s_path = "EgAddUDTestJson.jsp";
					}
					else if (s_process.equals("addParamTab"))
					{
						s_path = "EgAddUDTestJson_PAR.jsp";
					}
					else if (s_process.equals("addMeasureTab"))
					{
						int testTypeKey = aListKeys.indexOf("testType");
						String s_processVal = (String) aListValues.get(testTypeKey);
						if (s_processVal.equals("Custom"))
						{
							s_path = "EgConfigTestMeasureJson.jsp";
						}
						else if (s_processVal.equals("ScriptBatchFile"))
						{
							s_path = "EgConfigScriptMeasureJson.jsp";
						}
						else if (s_processVal.equals("SqlQuery"))
						{
							s_path = "EgConfigSqlMeasureJson.jsp";
						}
						else if (s_processVal.equals("Perfmon"))
						{
							s_path = "EgConfigPerfmonMeasureJson.jsp";
						}
						else if (s_processVal.equals("Snmp"))
						{
							s_path = "EgConfigSnmpMeasureJson.jsp";
						}
						else if (s_processVal.equals("Jmx"))
						{
							s_path = "EgMBeanDiscoveryJson.jsp";
						}
					}
					else if (s_process.equals("generateCntnr"))
					{
						int testTypeKey = aListKeys.indexOf("testType");
						String s_processVal = (String) aListValues.get(testTypeKey);
						if (s_processVal.equals("Custom"))
						{
							s_path = "EgConfigTestMeasureJson_GEN.jsp";
						}
						else if (s_processVal.equals("ScriptBatchFile"))
						{
							s_path = "EgConfigScriptMeasure_GEN.jsp";
						}
						else if (s_processVal.equals("SqlQuery"))
						{
							s_path = "EgConfigSqlMeasure_GEN.jsp";
						}
						else if (s_processVal.equals("Perfmon"))
						{
							s_path = "EgConfigPerfmonMeasure_GEN.jsp";
						}
						else if (s_processVal.equals("Snmp"))
						{
							s_path = "EgConfigSnmpMeasure_GEN.jsp";
						}
						else if (s_processVal.equals("Jmx"))
						{
							s_path = "EgMBeanDiscovery_GEN.jsp";
						}
					}
					else if (s_process.equals("tab6Help"))
					{
						s_path = "EgTemplateUpload.jsp";
					}
					else if (s_process.equals("ddgenerateCntnr"))
					{
						s_path = "EgDiagnosisFormatJson.jsp";
					}
				}
				else if (s_path.equals("EgconfigtestparampJson.jsp") ||
						s_path.equals("EgConfigTestParamJson.jsp")) //Test
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("test"))
					{
						s_path = "EgAddUDTestJson.jsp";
					}
					else if (s_process.equals("paramTab"))
					{
						s_path = "EgAddUDTestJson_PAR.jsp";
					}
				}
				else if (s_path.equals("EgModifyMeasuresJson.jsp"))//Test
				{
					int testTypeKey = aListKeys.indexOf("testType");
					String s_processVal = (String) aListValues.get(testTypeKey);
					if (s_processVal.equals("Custom"))
					{
						s_path = "EgConfigTestMeasureJson.jsp";
					}
					else if (s_processVal.equals("ScriptBatchFile"))
					{
						s_path = "EgConfigScriptMeasureJson.jsp";
					}
					else if (s_processVal.equals("SqlQuery"))
					{
						s_path = "EgConfigSqlMeasureJson.jsp";
					}
					else if (s_processVal.equals("Perfmon"))
					{
						s_path = "EgConfigPerfmonMeasureJson.jsp";
					}
					else if (s_processVal.equals("Snmp"))
					{
						s_path = "EgConfigSnmpMeasureJson.jsp";
					}
					else if (s_processVal.equals("Jmx"))
					{
						s_path = "EgMBeanDiscoveryJson.jsp";
					}
				}
				else if (s_path.equals("EgConfigGroupsJson.jsp"))//Groups
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("add") )
					{
						s_path = "EgAddGroup.jsp";
					}
					else if (s_process.equals("modify"))
					{
						s_path = "EgConfigGroupsJson.jsp";
					}
				}
				else if (s_path.equals("agentsettingshelpJson.jsp"))//Settings-RemoteCOntrol
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("addTab") )
					{
						s_path = "EgManageCommandsRCJson.jsp";
					}
					else if (s_process.equals("modifyTab"))
					{
						s_path = "EgManageCommandsRCJson_MOD.jsp";
					}
					else if (s_process.equals("deleteTab"))
					{
						s_path = "EgManageCommandsRCJson_DEL.jsp";
					}
				}
				else if (s_path.equals("EgManageCommandsRCpJson.jsp"))//Settings-RemoteControl
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("add") )
					{
						s_path = "EgManageCommandsRCJson.jsp";
					}
					else if (s_process.equals("modify"))
					{
						s_path = "EgManageCommandsRCJson_MOD.jsp";
					}
					else if (s_process.equals("delete"))
					{
						s_path = "EgManageCommandsRCJson_DEL.jsp";
					}
				}
				else if (s_path.equals("EgSSLCertificateUploaderJson.jsp"))//Domains
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("install") )
					{
						s_path = "EgSSLCertificateUploaderJson.jsp";
					}
					else if (s_process.equals("uninstall"))
					{
						s_path = "EgSSLCertificateUploaderJson2.jsp";
					}
					else if (s_process.equals("view"))
					{
						s_path = "EgSSLCertificateUploaderJson3.jsp";
					}
				}
				else if (s_path.equals("EgDefaultReportsJSON.jsp") || //DefaultReport
						s_path.equals("EgdefaultreportsJSONp.jsp"))
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgDefaultReportsJSON.jsp";
					}
					else if (s_process.equals("addnew"))
					{
						s_path = "EgDefaultReportsJSON_2.jsp";
					}
				}
				else if (s_path.equals("EgSpecificReportsJSON.jsp") || //SpecificReport
						s_path.equals("EgspecificreportsJSONp.jsp"))
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgSpecificReportsJSON.jsp";
					}
					else if (s_process.equals("addnew"))
					{
						s_path = "EgSpecificReportsJSON_2.jsp";
					}
				}
				else if (s_path.equals("EgUserReportsJSON.jsp") || //UserReport
						s_path.equals("EguserreportsJSONp.jsp"))
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgUserReportsJSON.jsp";
					}
					else if (s_process.equals("addnew"))
					{
						s_path = "EgUserReportsJSON_2.jsp";
					}
				}
				else if (s_path.equals("EgExternalMonitorsJSON.jsp"))//ExternalMonitors
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgExternalMonitorsJSON.jsp";
					}
					else if (s_process.equals("modify"))
					{
						s_path = "EgAddModifyExtrnlMonitorsJSON.jsp";
					}
				}
				else if (s_path.equals("EgConfigTransJson.jsp"))//Servicxes-Transaction
				{
					int indexkey = aListKeys.indexOf("comeFrom");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("resultPage"))
					{
						s_path = "EgDispSiteTransJson.jsp";
					}
					else if (s_process.equals("main"))
					{
						s_path = "EgConfigTransJson.jsp";
					}
				}
				else if (s_path.equals("EgCommonPrintPage.jsp"))//PrintPage
				{
					int indexkey = aListKeys.indexOf("from");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("EgMiscReports"))
					{
						s_path = "EgMiscReportsJson.jsp";
					}
					else if (s_process.equals("UserRegReport"))
					{
						s_path = "EgUserRegReportJson.jsp";
					}
				}
				else if (s_path.equals("LogonsPrint.jsp"))//PrintPage
				{
					int indexkey = aListKeys.indexOf("frmPage");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("failedLogons"))
					{
						s_path = "failedLogons.jsp";
					}
					else if (s_process.equals("logons"))
					{
						s_path = "logons.jsp";
					}
				}
				else if (s_path.equals("EgAddDeleteSuperMgrJSON.jsp"))//SuperManager Settings
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgAddDeleteSuperMgrJSON_LIST.jsp";
					}
					else if (s_process.equals("add"))
					{
						s_path = "EgAddDeleteSuperMgrJSON.jsp";
					}
				}
				else if (s_path.equals("minmaxConfigJSON.jsp"))//Monitor Settings
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "minmaxConfigJSON.jsp";
					}
					else if (s_process.equals("add"))
					{
						s_path = "minmaxConfigJSON_ADD.jsp";
					}
				}
				else if (s_path.equals("EgPercentileOperationsJSON.jsp"))//CapacityPlanning
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgReportSysSettingJSON.jsp";
					}
					else if (s_process.equals("add"))
					{
						s_path = "EgPercentileOperationsJSON.jsp";
					}
				}
				else if (s_path.equals("deletegroupsremotepJson.jsp"))//RUMCollector
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("RUM"))
					{
						s_path = "DeleteRUMCollectorsJson.jsp";
					}
					else if (s_process.equals("Remote"))
					{
						s_path = "deletegroupsremotepJson.jsp";
					}
				}
				else if (s_path.equals("EgAutoManagePageJson.jsp"))//DiscoverySegements
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("manageall"))
					{
						s_path = "EgAutoManagePageJson.jsp";
					}
					else if (s_process.equals("savetopo"))
					{
						s_path = "EgAutoManagePageJson_SAVE.jsp";
					}
				}
				else if (s_path.equals("EgAutoTopologyMainPageExt.jsp"))//DiscoverySegements
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("addandassign"))
					{
						s_path = "EgAutoTopologyMainPageExt_ADD.jsp";
					}
					else if (s_process.equals("main"))
					{
						s_path = "EgAutoTopologyMainPageExt.jsp";
					}
					else if (s_process.equals("Uses"))
					{
						s_path = "EgAutoTopologyMainPageExt_USES.jsp";
					}
					else if (s_process.equals("Connects"))
					{
						s_path = "MainPageCompNamesJson_CON.jsp";
					}
					else if (s_process.equals("group"))
					{
						s_path = "EgAutoTopologyGroupJson.jsp";
					}
				}
				else if (s_path.equals("MainPageCompNamesJson.jsp"))//DiscoverySegements
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("Uses"))
					{
						s_path = "EgAutoTopologyMainPageExt_USES.jsp";
					}
					else if (s_process.equals("Connects"))
					{
						s_path = "MainPageCompNamesJson_CON.jsp";
					}
				}
				else if (s_path.equals("EgTopologyGroupDetailsJson.jsp"))
				{
					int indexkey = aListKeys.indexOf("index");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("group"))
					{
						s_path = "EgAutoTopologyGroupJson.jsp";
					}
					else if (s_process.equals("details"))
					{
						s_path = "EgTopologyGroupDetailsJson.jsp";
					}
				}
				else if (s_path.equals("EgAgentRestartJson.jsp"))//Agent Status
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("main"))
					{
						s_path = "EgAgentRestartJson.jsp";
					}
					else if (s_process.equals("info"))
					{
						s_path = "EgAgentInfoJson.jsp";
					}
				}
				else if (s_path.equals("EgDispServerJson.jsp"))//Aggregate
				{
					if (tmp_path.indexOf("AggregateComponent") > -1)
					{
						s_path = "EgDispServer_aggregate.jsp";
					}
					else
					{
						s_path = "EgDispServerJson.jsp";
					}
				}
				else if (s_path.equals("EgNewServerJson.jsp") || 
						s_path.equals("EgnewserverpJson.jsp"))//Add new Aggregate
				{
					if (tmp_path.indexOf("AggregateNewComponent") > -1)
					{
						s_path = "EgNewServer_aggregate.jsp";
					}
					else
					{
						s_path = "EgNewServerJson.jsp";
					}
				}
				else if (s_path.equals("EgConfigEnvJson.jsp"))//ManageUnmanage aggregate components
				{
					if (tmp_path.indexOf("AggregateManageUnmanageComponents") > -1)
					{
						s_path = "EgConfigEnv_aggregate.jsp";
					}
					else
					{
						s_path = "EgConfigEnvJson.jsp";
					}
				}
				else if (!EgInstallInfo.isSuperManager && (s_path.equals("EgItInfrastructureJson.jsp") || //view aggregates
						s_path.equals("EgInfraComponentsJson.jsp")))
				{
					if (tmp_path.indexOf("AggregateItInfrastructure") > -1 || 
						tmp_path.indexOf("AggregateInfraComponents") > -1)
					{
						s_path = "EgItInfrastructure_aggregate.jsp";
					}
					else
					{
						s_path = "EgItInfrastructureJson.jsp";
					}
				}
				else if (s_path.equals("EgInfraCompDetailsJson.jsp")) //view aggregates
				{
					if (tmp_path.indexOf("AggregateInfraCompDetails") > -1)
					{
						s_path = "EgInfraCompDetailsJson_aggregate.jsp";
					}
					else
					{
						s_path = "EgInfraCompDetailsJson.jsp";
					}
				}
				else if (s_path.equals("defaulttesthelpJson.jsp") ||
					s_path.equals("specifictesthelpJson.jsp")) //Test Configuration
				{
					int indexkey = aListKeys.indexOf("mode");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("egvcconfig"))
					{
						s_path = "VirtualCenter.jsp";
					}
					else if (s_process.equals("egrhevconfig"))
					{
						s_path = "RHEVMGRHost.jsp";
					}
					else if (s_process.equals("egconfiguremultipleusers"))
					{
						s_path = "ConfigMultipleUser.jsp";
					}
					else if (s_process.equals("egconfigureurlandcredentials"))
					{
						s_path = "ConfigURLCredentials.jsp";
					}
					else if (s_process.equals("egconfigurenamepattern"))
					{
						s_path = "ConfigNamePattern.jsp";
					}
					else if (s_process.equals("egconfigurewinsharedfolders"))
					{
						s_path = "WinSharedFolders.jsp";
					}
					else if (s_process.equals("egconfigurewsdlurlandcredentials"))
					{
						s_path = "ConfigWsURL.jsp";
					}
					else if (s_process.equals("vmgusers"))
					{
						s_path = "VMGUsers.jsp";
					}
					else if (s_process.equals("egdbusercreation"))
					{
						s_path = "EgDbUserCreation.jsp";
					}
					else if (s_process.equals("winservicesconfiguration"))
					{
						s_path = "WINServiceConfig.jsp";
					}
					else if (s_process.equals("processconfiguration"))
					{
						s_path = "ProcessConfiguration.jsp";
					}
					else if (s_process.equals("eghmcconfig"))
					{
						s_path = "HMCConfiguration.jsp";
					}
					else if (s_process.equals("egconfigejb"))
					{
						s_path = "ConfigureEJBs.jsp";
					}
					else if (s_process.equals("egconfiginfos"))
					{
						s_path = "ConfigureInfos.jsp";
					}
				}
				else if (s_path.equals("exportimporthelpJson.jsp"))//ExportandImport
				{
					int indexkey = aListKeys.indexOf("selectTab");
					s_process = (String) aListValues.get(indexkey);
					if (s_process.equals("exportTab"))
					{
						s_path = "EgExportConfigureFilesJson.jsp";
					}
					else if (s_process.equals("importTab"))
					{
						s_path = "EgImportConfigureFilesJson.jsp";
					}
					else if (s_process.equals("icCompExportTab"))
					{
						s_path = "EgIcExportCompTypeJson.jsp";
					}
					else if (s_process.equals("icCompImportTab"))
					{
						s_path = "EgICImportCompTypeFilesJson.jsp";
					}
					else if (s_process.equals("icTestExportTab"))
					{
						s_path = "EgIcExportConfigureFilesJson.jsp";
					}
					else if (s_process.equals("icTestImportTab"))
					{
						s_path = "EgICImportConfigureFilesJson.jsp";
					}
				}
				else if (EgInstallInfo.isSuperManager)
				{
					String operation=null;
					int indexkey = aListKeys.indexOf("operation");
					if(indexkey>-1)
					{
						operation = (String) aListValues.get(indexkey);
					}
					if(s_path.equals("displayManagers.jsp"))
					{
						if(operation != null)
						{
							if(operation.equalsIgnoreCase("addNewManager"))
							{
								s_path = "displayManagers_add.jsp";
							}
							else if(operation.equalsIgnoreCase("modifyManager"))
							{
								s_path = "displayManagers_modify.jsp";
							}
						}
					}
					else if(s_path.equals("EgItInfrastructureJson.jsp"))
					{
						s_path = "EgItInfrastructureJson_sm.jsp";
					}
					else if (s_path.equals("LogonsPrint.jsp"))//PrintPage
					{
						s_process = (String) aListValues.get(indexkey);
						if (s_process.equals("failedLogons"))
						{
							s_path = "failedLogons_sm.jsp";
						}
						else if (s_process.equals("logons"))
						{
							s_path = "logons_sm.jsp";
						}
					}
					else if(s_path.equals("logons.jsp"))
					{
						s_path = "logons_sm.jsp";
					}
					else if(s_path.equals("failedLogons.jsp"))
					{
						s_path = "failedLogons_sm.jsp";
					}
					else
					{
						String val2 = ((String)aListValues.get(1));
						if(val2.equalsIgnoreCase("Admin"))
						{
							s_path = "auditlog_admin_sm.jsp";
						}
						else if(val2.equalsIgnoreCase("Monitor"))
						{
							s_path = "auditlog_monitor_sm.jsp";
						}
					}
				}
				String s_server = "";
				if (s_path.equalsIgnoreCase("EgConfigureComponentTestsJson.jsp") || 
					s_path.equalsIgnoreCase("EgConfigureDefaultTestParamsJson.jsp"))
				{
					String strFromMainPage = null;
					StringTokenizer st = new StringTokenizer(s_qstring,"&");
					while (st.hasMoreTokens())
					{
						String temp = st.nextToken();
						if (temp.indexOf("cType_HelpPage=") > -1)
						{
							//query from test configured page
							s_server = temp.substring(temp.indexOf("=")+1);
						}
						else if (temp.indexOf("componentType=") > -1)
						{
							//query from unconfigured test page
							s_server = temp.substring(temp.indexOf("=")+1);
						}
						else if (temp.indexOf("tName_HelpPage=") > -1)
						{
							s_test = temp.substring(temp.indexOf("=")+1);
						}
						else if (temp.indexOf("testName=") > -1)
						{
							s_test = temp.substring(temp.indexOf("=")+1);
						}
					}
				}
				else if (s_path.equalsIgnoreCase("EgUnconfiguredTestsSummary.jsp"))
				{
					String fromPage = null;
					String tempComponentType = null;
					StringTokenizer st = new StringTokenizer(s_qstring,"&");
					while (st.hasMoreTokens())
					{
						String temp = st.nextToken();
						if (temp.indexOf("fromPage=") > -1)
						{
							fromPage = temp.substring(temp.indexOf("=")+1);
						}
						else if (temp.indexOf("componentType=") > -1)
						{
							tempComponentType = temp.substring(temp.indexOf("=")+1);
						}

						if (fromPage != null && tempComponentType != null)
						{
							break;
						}
					}

					if (fromPage != null && fromPage.equalsIgnoreCase("testConfiguration"))
					{
						showSpecificTestConfigurationHelpPage = true;
					}
				}

				if(s_test!=null && s_test.endsWith("_ex"))
				{
					isICTest=true;
				}
				else if(s_test!=null && (s_test.endsWith("_ag") || s_test.endsWith("_agx")))
				{
					isAggregateTest = true;
					if(s_path.equalsIgnoreCase("EgConfigureComponentTestsJson.jsp"))
					{
						showSpecificTestConfigurationHelpPage = true;
					}
					else
					{
						showDefaultTestConfigurationHelpPage = true;
					}
				}

				if (!isICTest && !isAggregateTest)
				{
					if (s_path.equalsIgnoreCase("EgConfigureComponentTestsJson.jsp") && 
						(s_test == null || s_test.equals("")))
					{
						showSpecificTestConfigurationHelpPage = true;
					}
					else if (s_path.equalsIgnoreCase("EgConfigureDefaultTestParamsJson.jsp") && 
						(s_test == null || s_test.equals("")|| s_test.equals("-1")))
					{
						showDefaultTestConfigurationHelpPage = true;
					}
					if(!(s_test != null && s_test.equals("")) && !(s_server != null && s_server.equals("")))
					{
						s_id = egHelp.getId(s_path,s_server,s_test);
						if (s_id.equals("NOT_FOUND"))
						{
							s_id = egHelp.getIdForTest(s_path, s_test);
						}
					}
					else if(!(s_server != null && s_server.equals("")))
					{
						s_id = egHelp.getId(s_path,s_server);
					}
					else
					{
						s_id = egHelp.getId(s_path.trim());
					}
				}
			}
			else
			{
				s_page = "EgAerr.html";
				i_next = i_maxpages;
			}

			if (debug)
			{
				UserRegistry reg = UserRegistry.getInstance();
				User usr = reg.getUser(session.getId());
				logToErrorFile(s_module, s_path, s_id, usr.getLoginID());
			}
		}

		if(isAggregateTest)
		{
			if(showSpecificTestConfigurationHelpPage)
			{
				s_page = "SpecificAggregateTestConfiguration.html";
			}
			else
			{
				s_page = "DefaultAggregateTestConfiguration.html";
			}
		}
		else if (showSpecificTestConfigurationHelpPage)
		{
			s_page = "EgSpecificTestConfiguration.html";
		}
		else if (showDefaultTestConfigurationHelpPage)
		{
			s_page = "EgDefaultTestConfiguration.html";
		}
		else if (s_id != null 
			&& !(s_id.equals("NOT_FOUND")) 
			&& !(s_id.equals("")))
		{
			i_prev = new Integer(s_id).intValue();
			i_prev--;

			i_next = new Integer(s_id).intValue();
			i_next++;
			
			if (s_test != null)
			{
				s_page = "EgA"+ s_id + ".html?test="+s_test+"&from=admin";//meant for HelpFilter.
				page_temp = "EgA"+ s_id + ".html";
			}
			else
			{
				s_page = "EgA"+ s_id + ".html";
				page_temp = s_page;
			}
		}
		else
		{
			s_page = "EgAerr.html";
			i_next = i_maxpages;
		}

		File helpPageObj = new File(EgInstallInfo.getInstallDir() +"/manager/tomcat/webapps/final/eghelp/"+page_temp);
		
		if (!helpPageObj.exists())
		{
			s_page = "EgAerr1.html";
		}

		if (isICTest)
		{
			String strHelpPagePath = application.getRealPath("/eghelp/"+s_test+ "_Admin.html");
			File file = new File(strHelpPagePath);
			if(!file.exists())
				s_page="EgTemplateHelp.html";
			else
				s_page =s_test+ "_Admin.html";
		}
	}
	catch(Exception e)
	{
		out.println("ERR in Admin Help" + e.getMessage());
		s_page = "EgAerr.html";
		i_next = i_maxpages;
	}
	rootJson.put("PAGE_ID", s_id);
	rootJson.put("PAGE_URL", "/final/eghelp/"+s_page);
	out.println(rootJson.toString());
%>



