<%
/*
 *   File			:	ecTopNAvailability.jsp
 *   Purpose		:	Display TopN softwares/services/hotfixes for the selected operating system
 *   Creation Date	:	01-08-2006
 *   Author			:	Balasigamani
 *   UI Design		:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import ="com.egurkha.User"%>
<%@ page import ="com.egurkha.UserRegistry"%>
<%@ page import ="com.eg.EgConfigTestsInfo"%>
<%@ page import ="com.eg.EgConfigConstants"%>
<%@ page import ="egurkha.config.ConfigDbSetting"%>
<%@ page import ="egurkha.config.EcProcessData"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import ="com.eg.EgURLEncoder"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	int sysCountTemp = 0;
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	EcProcessData processData=new EcProcessData();
	EcUtils ecUtils = new EcUtils();

	// Ini Value
	String defTestName = configTestsInfo.getServerDisplayValue("TOPN_AVAILABILITY","TestName");
	String topNShowCount=configTestsInfo.getServerDisplayValue("TOPN_AVAILABILITY","ViewCount");
	String defSelection=configTestsInfo.getServerDisplayValue("TOPN_AVAILABILITY","OSName");
	String osName=request.getParameter("osName");
	String testName=request.getParameter("testName");

	int showCountValue=0;
	Map finalData=new TreeMap();
	Map countData=new TreeMap();
	ArrayList softwareCount=new ArrayList();

	// Get data for process
	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);
	Map resultData = (TreeMap)processData.getOSDetails("Availability");
	String strOSCount = "0";

	Map dashboardSetting=(Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
	Map userCommonSetting=(Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);

	Vector osNameList=processData.getAllOsName();

	String tempCount=(String)dashboardSetting.get(EgConfigConstants.SHOW_TOP);
	if(tempCount!=null)
	{
		topNShowCount=tempCount;
		showCountValue=Integer.parseInt(topNShowCount);
	}
	else
	{
		showCountValue=Integer.parseInt(topNShowCount);
	}
	
	if(osNameList!=null && osNameList.size()>0)
	{
		if(osName==null)
		{
			String osNameSetting=(String)userCommonSetting.get(EgConfigConstants.OS_NAME);
			if(osNameSetting!=null && osNameList.contains(osNameSetting))
				osName=osNameSetting;
			else if(defSelection!=null &&osNameList.contains(defSelection))
				osName=defSelection;
			else
				osName=(String)osNameList.get(0);
		}
	
		if(testName==null)
		{
			String testNameSetting=(String)dashboardSetting.get(EgConfigConstants.AVAILABILITY_STATUS);
			if(testNameSetting==null)
				testName=defTestName;
			else
				testName=testNameSetting;
		}

		osNameList.remove("Unknown");

		//if(testName != null && testName.equalsIgnoreCase("hotfix_cf"))
		//{
		//	osNameList.remove("Linux");
		//	if (osName.equalsIgnoreCase("Linux"))
		//	{
		//		osName = (String)osNameList.get(0);
		//	}
		//}
	}

	if(testName!=null && osName!=null)
	{
		finalData=(TreeMap)processData.getServerInformations(testName,osName);
		countData=(TreeMap)processData.getCountByInfo(finalData);
		Iterator citerate=countData.keySet().iterator();
		while(citerate.hasNext())
		{
			Integer count=(Integer)citerate.next();
			softwareCount.add(count);
		}

		Hashtable htableSystems = (Hashtable)resultData.get(osName);
		if (htableSystems != null)
		{
			strOSCount = "" + htableSystems.size();
		}
	}

	String ec_criteria = request.getParameter("ec_criteria");
	String ec_userOption = request.getParameter("ec_userOption");
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.dashboard.TopN Software/HotFix Information" />
</title>
<egui:skin ui="config"/>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow: hidden" bgcolor="#FFFFFF">
	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" id="innertable">

<%
	String selectName = "hotfix";
	if (testName != null)
	{
		if(testName.equalsIgnoreCase("SoftwareList_cf"))
			selectName = "software";
	}
	String request_from = "";
	if (selectName.equals("software"))
	{
		request_from = "Software";
	}
	else
	{
		request_from = "Hotfix";
	}

	if (selectName.equalsIgnoreCase("software"))
	{
%>
		<tr>
			<td>
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<td class="tdbackcolortop pLeft4" nowrap><a href="../servlet/com.eg.EcConfigurationServlet?cmd=Availability&softwareName=All&osName=<%=osName%>&view=<%=selectName%>&viewCount=<%=topNShowCount%>&request_from=HomePage&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Top"/>&nbsp;<%=topNShowCount%>&nbsp;<egui:intnl text="configmgmt.dashboard.Installed"/>&nbsp;<egui:intnl text="configmgmt.dashboard.Software"/></b></a>
<%
		if (osName == null || osName.equals("-1") || osName.equalsIgnoreCase("Unknown"))
		{
%>
							<b><egui:intnl text="configmgmt.dashboard.in" /></b>&nbsp;
<%
		}
		else
		{
			sysCountTemp = Integer.parseInt(strOSCount);
%>
							<b><egui:intnl text="configmgmt.dashboard.in" />&nbsp;<%=strOSCount%></b>&nbsp;
<%
		}
%>
						</td>
						<td class="tdbackcolortop" align="right" nowrap>
							<select name="ec_os_sw" onChange="javascript:getTopNSoftwareInstalls()" style="width:250px">
								<%=ecUtils.fillSelectBox(osNameList,"config","",osName)%>
							</select>
						<td>
						<td class="tdbackcolortop" align="right" nowrap>
<%
		if (sysCountTemp > 1)
		{
%>
								&nbsp;<b><egui:intnl text="configmgmt.dashboard.Systems"/></b>&nbsp;&nbsp;
<%
		}
		else if (sysCountTemp == 1)
		{
%>
								&nbsp;<b><egui:intnl text="configmgmt.dashboard.System"/></b>&nbsp;&nbsp;
<%
		}
%>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
	else if (selectName.equalsIgnoreCase("hotfix"))
	{
%>
		<tr>
			<td  height="20" valign="top">
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<td class="tdbackcolortop pLeft4" nowrap><a href="../servlet/com.eg.EcConfigurationServlet?cmd=Availability&softwareName=All&osName=<%=osName%>&view=<%=selectName%>&viewCount=<%=topNShowCount%>&request_from=HomePage&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_headlink_white"><b><egui:intnl text="configmgmt.dashboard.Top"/>&nbsp;<%=topNShowCount%>&nbsp;<egui:intnl text="configmgmt.dashboard.Installed"/>&nbsp;<egui:intnl text="configmgmt.dashboard.Hotfixes"/></b></a>
<%
		if (osName == null || osName.equals("-1") || osName.equalsIgnoreCase("Unknown"))
		{
%>
							<b><egui:intnl text="configmgmt.dashboard.in" /></b>&nbsp;
<%
		}
		else
		{
			sysCountTemp = Integer.parseInt(strOSCount);
%>
							<b><egui:intnl text="configmgmt.dashboard.in" />&nbsp;<%=strOSCount%></b>&nbsp;
<%
		}
%>
						</td>
						<td class="tdbackcolortop" align="right" nowrap>
							<select name="ec_os_hf" onChange="javascript:getTopNHotfixInstalls()" style="width:250px">
								<%=ecUtils.fillSelectBox(osNameList,"config","",osName)%>
							</select>
						<td>
						<td class="tdbackcolortop" align="right" nowrap>
<%
		if (sysCountTemp > 1)
		{
%>
								&nbsp;<b><egui:intnl text="configmgmt.dashboard.Systems"/></b>&nbsp;&nbsp;
<%
		}
		else if (sysCountTemp == 1)
		{
%>
								&nbsp;<b><egui:intnl text="configmgmt.dashboard.System"/></b>&nbsp;&nbsp;
<%
		}
%>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
%>

		<tr>
			<td valign="top">
<%
	if (selectName.equalsIgnoreCase("software"))
	{
%>
				<div id="div_scroll" style="width:100%;height:154px;border:0px solid #000000">
<%
	}
	else if (selectName.equalsIgnoreCase("hotfix"))
	{
%>
				<div id="div_scroll" style="width:100%;height:100%;border:0px solid #000000">
<%
	}
%>
				<table width="100%" cellpadding="0" cellspacing="0" class="body_text" border="0">
<%
	if(finalData!=null && finalData.size()>0)
	{
%>
					<tr>
						<td align="center" class="table_header_dash" width="85%" height="20px">
							<egui:intnl text="configmgmt.dashboard.Name" />
						</td>
						<td align="center" class="table_header_dash" width="15%" height="20px" style="border-right-width:0px">
							<egui:intnl text="configmgmt.dashboard.Installs" />
						</td>
					</tr>
<%
		int selCount=0;
		boolean skip=false;
		for(int n=0;n<softwareCount.size();n++)
		{
			Integer count=(Integer)softwareCount.get(n);
			ArrayList infoName=(ArrayList)countData.get(count);
			Collections.sort(infoName,String.CASE_INSENSITIVE_ORDER);
			for(int n1=0;n1<infoName.size();n1++)
			{
				String info=(String)infoName.get(n1);
				info=info.substring(1).trim();
				if(showCountValue==selCount)
				{
					skip=true;
					break;
				}
				selCount++;
%>
					<tr>
						<td align="left" width="85%" class="cell_border" id="tdbacklightcolor2" wrap style="padding:2px;">&nbsp;<a href="../servlet/com.eg.EcConfigurationServlet?cmd=Availability&softwareName=<%=EgURLEncoder.encode(info,"UTF-8")%>&osName=<%=URLEncoder.encode(osName)%>&view=<%=URLEncoder.encode(selectName)%>&request_from=<%=request_from%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="" class="eg_monlink"><egui:display name="<%=info%>" length="55" /></a>
						</td>
						<td nowrap align="center" width="15%" class="cell_border"  style="border-right-width:0px" style="padding:2px">
							<%=count.intValue()%>
						</td>
					</tr>
<%
			}
			if(skip)
				break;
		}
	}
	else
	{
%>
					<tr>
<%
		if (selectName.equalsIgnoreCase("software"))
		{
%>
						<td align="center" height="150px" valign="middle">
<%
		}
		else
		{
%>
						<td align="center" height="100%" valign="middle">
<%
		}
%>
							<table border="0" cellspacing="0" cellpadding="0" class="body_text">
								<tr>
									<td align="center" height="80" valign="bottom">
										<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'>
									</td>
								</tr>
								<tr>
									<td align="center" valign="top" height="60">
										<egui:intnl text="configmgmt.common.No data available" />
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
	}
%>
				</table>
				</div>
			</td>
		</tr>
	</table>
<!-- </form> -->
</body>
</html>



