<%
/*
 *   File			:	ecShowComponentChanges.jsp
 *   Purpose		:	Displays changes in a component
 *   Creation Date	:	28/02/2007
 *   Author			:	Krishnamurthi
 *   UI Design		:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@page import="com.eg.EgConfigConstants"%>
<%@ page errorPage="EcProbs.jsp"%>
<%@page import="egurkha.config.EcProcessChangeData"%>
<%@page import="egurkha.config.EcPrintData"%>
<%@page import="java.util.*"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.eg.EgThresholdInfo"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] userOptions = {"Component Name","Component Type","All Components"};
	EcProcessChangeData processChangeData = new EcProcessChangeData();

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}

	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	EgTimeZoneConverter timeZoneConverter = null;
	String startDateAndTime = null;
	String endDateAndTime = null;
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgDbInfo dbInfo = new EgDbInfo("manager");
	EcUtils ecUtils = new EcUtils();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	// Date format
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	//end date format

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_option1 = "";
	String ec_option2 = "";
	String ec_timeline = "";
	String ec_prevtimeline = "";
	String s_start_time = "";
	String s_end_time = "";
	String ec_stdate = "";
	String sHour = "";
	String sMinute = "";
	String ec_enddate = "";
	String eHour = "";
	String eMinute = "";
	String ec_changetype = "";
	String s_viewchange = "";
	String s_maxpageitems = "";
	String displayNameForChangeType = "";
	String selectedTests = "";
	String configSkin = user.getConfigSkin();

	EcPrintData ecData = (EcPrintData)session.getAttribute("CHANGE_COMPONENT_DATA");
	String request_from = request.getParameter("request_from");
	String request_start = request.getParameter("request_start");

	String searchCompValue = request.getParameter("searchCompValue");
	String searchTestValue = request.getParameter("searchTestValue");
	String searchDescValue = request.getParameter("searchDescValue");

	String componentName = request.getParameter("componentName");
	String userName = (String)session.getAttribute("sess_auserid");
	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	ec_option1 = ecData.getOptionOne();
	ec_option2 = ecData.getOptionTwo();
	ec_timeline = ecData.getTimeLine();
	ec_prevtimeline = ecData.getPreviousTimeLine();

	s_start_time = ecData.getStartTime();
	s_end_time = ecData.getEndTime();
	ec_stdate = ecData.getStartDate();
	
	String ec_sthr = ecData.getStartHour();
	if (ec_sthr != null)
	{
		if (ec_sthr.length() == 1)
			sHour = "0" + ec_sthr;
		else
			sHour = ec_sthr;
	}

	String ec_startmin = ecData.getStartMinute();
	if (ec_startmin != null)
	{
		if (ec_startmin.length() == 1)
			sMinute = "0" + ec_startmin;
		else
			sMinute = ec_startmin;
	}
	ec_enddate = ecData.getEndDate();

	String ec_endhr = ecData.getEndHour();
	if (ec_endhr != null)
	{
		if (ec_endhr.length() == 1)
			eHour = "0" + ec_endhr;
		else
			eHour = ec_endhr;
	}
	String ec_endmin = ecData.getEndMinute();

	if (ec_endmin != null)
	{
		if (ec_endmin.length() == 1)
			eMinute = "0" + ec_endmin;
		else
			eMinute = ec_endmin;
	}

	ec_changetype = ecData.getChangeType();
	if (ec_changetype != null)
	{
		if (ec_changetype.equalsIgnoreCase("Latest"))
		{
			displayNameForChangeType = "Recent";
		}
		else
		{
			displayNameForChangeType = "All";
		}
	}

	s_viewchange = ecData.getViewChange();
	s_maxpageitems = ecData.getMaxPageItem();
	selectedTests = ecData.getTestName();

	String selectedDate = ecData.getSelectedDate();
	String selectedHour = ecData.getSelectedHour();

	TreeMap tmap_changeConfigDetails = ecData.getChangeData();

	tmap_changeConfigDetails = processChangeData.getChangeSummary(tmap_changeConfigDetails,searchCompValue,searchTestValue,searchDescValue,userLanguage);

	boolean requestFromSearch = false;
	if (request_start != null && request_from != null)
	{
		if ((request_start.equalsIgnoreCase("CSForDashboard") && request_from.equalsIgnoreCase("CSForDashboard")) || 
			(request_start.equalsIgnoreCase("DCDSForDashboard") && request_from.equalsIgnoreCase("DCDSForDashboard")) || 
			(request_start.equalsIgnoreCase("DCDS") && request_from.equalsIgnoreCase("DCDS")) || 
			(request_start.equalsIgnoreCase("CS") && request_from.equalsIgnoreCase("CS")) || 
			(request_start.equalsIgnoreCase("Dashboard") && request_from.equalsIgnoreCase("DCDSForDashboard")) ||
			(request_start.equalsIgnoreCase("DCDS") && request_from.equalsIgnoreCase("ACO")))
		{
			requestFromSearch = true;
		}
	}

	boolean requestForCType = false;
	if (request_start == null && request_from != null && request_from.equalsIgnoreCase("ACO"))
	{
		requestForCType = true;
	}

	boolean requestFromDashboard = ecData.isRequestFromDashboard();
	boolean requestToChange = false;
	if (request_start != null && request_from != null && 
		request_from.equalsIgnoreCase("AllComponentsOption") && 
		request_start.equalsIgnoreCase("AllComponentsOption"))
	{
		requestToChange = true;
	}
	
	boolean requestHomePage = false;
	if (request_from != null)
	{
		if ("DCDSForDashboard".equalsIgnoreCase(request_from) || 
			"CAAGForDashboard".equalsIgnoreCase(request_from) || 
			"CSForDashboard".equalsIgnoreCase(request_from) || 
			"DCDS".equalsIgnoreCase(request_from) || 
			"ACO".equalsIgnoreCase(request_from))
		{
			requestHomePage = true;
		}
	}

	int topN = ecData.getTopNChanges();

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_userOption = (String)session.getAttribute("ec_userOption");

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	HashMap treeValues = new HashMap();
	String testNamesforDiff[] = configTestsInfo.getVariables("SHOW_DIFFERENCES");
	for (int i=0;i<testNamesforDiff.length;i++)
	{
		HashMap lengthinMeasure = new HashMap();
		String strTestname = testNamesforDiff[i];
		String measureValues = configTestsInfo.getValue("SHOW_DIFFERENCES",strTestname);
		StringTokenizer st = new StringTokenizer(measureValues,",");
		while (st.hasMoreTokens())
		{
			String stTokenValues = st.nextToken();
			if (stTokenValues.indexOf(":") != -1)
			{
				StringTokenizer stinColon = new StringTokenizer(stTokenValues,":");
				String strMeasure = stinColon.nextToken();
				String strLength = stinColon.nextToken();
				String uiDesc = (String)mappingInfo.getMeasureDescription(strTestname,strMeasure);
				lengthinMeasure.put(uiDesc,strLength);
				treeValues.put(strTestname,lengthinMeasure);
			}
			else
			{
				String uiDesc = (String)mappingInfo.getMeasureDescription(strTestname,stTokenValues);
				lengthinMeasure.put(uiDesc,"0");
				treeValues.put(strTestname,lengthinMeasure);
			}
		}
	}
%>

<html>
<head>
	<title><egui:intnl text="configmgmt.changes.detailed.eG Change Management" /></title>
	<meta name="Author" content="Krishnamurthi">
	<!-- <link rel=stylesheet href="../config/styles/ec_style_green.css" type="text/css"> -->
	<egui:skin ui="config"/>
	<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
	<script  src="/final/jquery/jquery.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
	<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
	<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
	<script language="JavaScript1.2">

		var has_element = document.documentElement && document.documentElement.clientWidth;
		var has_inner = typeof(window.innerWidth) == 'number';

		var startX=0;
		var startY=0;
		var dragStarted=false;
		var dragDiv;

		var $j = jQuery.noConflict();

		function printData()
		{
<%
	StringBuffer printQS = new StringBuffer();
	printQS.append("componentName="+EgURLEncoder.encode(componentName,"UTF-8"));
	printQS.append("&ec_type=ShowComponentChanges");
	printQS.append("&ec_trgttype=Configuration_Report");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
	printQS.append("&searchCompValue="+searchCompValue);
	printQS.append("&searchTestValue="+searchTestValue);
	printQS.append("&searchDescValue="+searchDescValue);
%>
			var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
			print(s_qryString);
		}

		function goToChange()
		{
			var thisForm = document.forms[0];
			thisForm.action = '../servlet/com.eg.EcConfigurationServlet?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			thisForm.submit();
		}

		function savePdf()
		{
<%
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ChangeConfiguration");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
			getPdf('<%=configSkin%>');
		}

		function mail()
		{
			sendMail();
		}

		function goSearch()
		{
			thisForm = document.showChanges;
			thisForm.action = '../config/EcChangeConfiguration.jsp?request_start=<%=request_start%>&request_from=<%=request_from%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&timeZone=<%=selectedHour%>&selectDate=<%=selectedDate%>';
			thisForm.submit();
		}

		function goToCType()
		{
			thisForm = document.showChanges;
			thisForm.action = '../config/EcChangeConfiguration.jsp?request_start=DCDS&request_from=<%=request_from%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&timeZone=<%=selectedHour%>&selectDate=<%=selectedDate%>';
			thisForm.submit();
		}

		function goChange()
		{
			thisForm = document.showChanges;
			thisForm.action = '../config/EcChangeConfiguration.jsp?componentName=<%=componentName%>&request_start=<%=request_start%>&request_from=<%=request_from%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			thisForm.submit();
		}

		function csv()
		{
			thisForm = document.forms[0];
			thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			thisForm.submit();
		}

		function center_box(box, width, height)
		{
			cleft = has_inner? pageXOffset + (window.innerWidth - width)/2 : has_element ? document.documentElement.scrollLeft +(document.documentElement.clientWidth - width)/2: document.body.scrollLeft + (document.body.clientWidth - width)/2;  
			ctop = has_inner? pageYOffset + (window.innerHeight - height)/2 : has_element ? document.documentElement.scrollTop +(document.documentElement.clientHeight - height)/2 : document.body.scrollTop +(document.body.clientHeight - height)/2;
			box.style.left = cleft > 0 ? cleft + 'px' : '0px';
			box.style.top = ctop > 0 ? ctop + 'px' : '0px';
		}

		function loadChange(previousValue,presentValue,compValue,testValue,descValue,measureValue,obj)
		{
			xmlhttp = null;
			var box = document.getElementById('valuechangesDiv');
			if (window.XMLHttpRequest)
			{
				xmlhttp=new XMLHttpRequest();
			}
			else if (window.ActiveXObject)
			{
				xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
			}
			if (xmlhttp != null)
			{
				var params = "previousValue="+previousValue+"&presentValue="+presentValue+"&componentName="+compValue+"&testName="+testValue+"&descriptor="+descValue+"&measureName="+measureValue;
				var url = "/final/config/ecShowDifference.jsp";
				xmlhttp.onreadystatechange = state_Change2;
				xmlhttp.open('POST',url,true);
				xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
				xmlhttp.setRequestHeader('Content-length',params.length);
				xmlhttp.setRequestHeader('Connection','close');
				xmlhttp.send(params);
				var bHeight = box.style.height;
				var bWidth = box.style.width;
				center_box(box,400,250);
			}
			else
			{
				alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
			}
		}

		function state_Change2()
		{
			var changesDiv = document.getElementById("changesDiv");
			if (xmlhttp.readyState == 4)
			{
				try
				{
					if (xmlhttp.status == 200)
					{
						val = xmlhttp.responseText;
						changesDiv.innerHTML = val;
						changesDiv.style.visibility = "visible";
						changesDiv.style.display = "block";
						var myvalue = document.getElementById('changesDiv');
						var width = myvalue.offsetWidth;
						var height = myvalue.offsetHeight;
						document.getElementById('valuechangesDiv').style.display="block";
					}
				}
				catch (error)
				{
					//error
				}
			}
		}

		function hideChanges()
		{
			document.getElementById('valuechangesDiv').style.display = 'none';
			document.getElementById('changesDiv').style.display = 'none';
		}

		$j(document).ready(function(){
		/*   JQuery Drag & Drop Functionality  (Begin)   */
		$j.globalVars = {
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
		};

		$j( "#valuechangesDiv" ).draggable({ 
		cursor: "move",
		scroll: false,
		containment: "parent"
		});
		/*   JQuery Drag & Drop Functionality  (End)   */
		});

	</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0"  onLoad="javascript:void(0);" onUnLoad="javascript:void(0)">
<form name="showChanges" method="post" style="margin:0px">

	<input type="hidden" name="ec_rtype" value="Change">
	<input type="hidden" name="ec_option1" value="<%=ec_option1%>">
	<input type="hidden" name="ec_option2" value="<%=ec_option2%>">
	<input type="hidden" name="ec_timeline" value="<%=ec_timeline%>">
	<input type="hidden" name="ec_prevtimeline" value="<%=ec_prevtimeline%>">
	<input type="hidden" name="ec_stdate_h" value="<%=ec_stdate%>">
	<input type="hidden" name="ec_sthr_h" value="<%=ec_sthr%>">
	<input type="hidden" name="ec_startmin_h" value="<%=ec_startmin%>">
	<input type="hidden" name="ec_enddate_h" value="<%=ec_enddate%>">
	<input type="hidden" name="ec_endhr_h" value="<%=ec_endhr%>">
	<input type="hidden" name="ec_endmin_h" value="<%=ec_endmin%>">
	<input type="hidden" name="ec_changetype" value="<%=ec_changetype%>">
	<input type="hidden" name="ec_viewchange" value="<%=s_viewchange%>">
	<input type="hidden" name="ec_maxpageitems" value="<%=s_maxpageitems%>">
	<input type="hidden" name="ec_test" value="<%=selectedTests%>">

	<div id="valuechangesDiv" name="valuechangesDiv" style="display:none;position:absolute;border:0px solid #ff0000;z-index:500;height:225px;" class="ui-widget-content" >
		<table border="0" cellpadding="0" cellspacing="0">
			<tr>
				<td colspan="3">
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td width="5" height="50" class="panel_top_left"><img src="/final/monitor/eg_images/spacer.gif" width="5" height="22" border="0"></td>
							<td class="panel_top_bg whitefont" height="22px" width="100%"><egui:intnl text='configmgmt.changes.detailed.Difference' /></td>
							<td class="panel_top_bg whitefont" height="50px" width="100%">
							<td align="right" class="panel_top_bg" style="padding-top:2px"><img src="/final/monitor/eg_images/green/popup_close.png" onclick="javascript:hideChanges();" border="0" class="mouse" title="close"></td>
							<td width="9" height="22" class="panel_top_right"><img src="/final/monitor/eg_images/spacer.gif" width="9" height="22" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
				<td align="center" valign="top" style="padding:8px 4px 4px 4px;" class="panelbg">
					<table border="0" cellpadding="0" cellspacing="0" width="100%" align="center" class="quickViewBorder">
						<tr>
							<td id="changesDiv"></td>
						</tr>
					</table>
				<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
			</tr>
			<tr>
				<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
				<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
				<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
			</tr>
		</table>
	</div>

	<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" valign="top" height="100%">

		<tr>
			<td align="right" valign="middle" id="layer_headbg" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
				<div style="border:0px blue solid;">
					<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGES" />&nbsp;:&nbsp;<egui:intnl text="configmgmt.changes.detailed.DETAILED" /></b>
					</div>
					<div style="border:0px solid red;float:right">
						<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
							<table cellspacing="0" cellpadding="0" border="0" height="20">
								<tr>
									<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

									<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

									<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()"></td>

									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

									<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"></td>

									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

									<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

									<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

									<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

								</tr>
							</table>
						</div>
						<div style="border:0px solid;float:right;padding:5px">
<%
	if (requestFromSearch)
	{
%>
							<a id='mouse' onClick="javascript:goSearch();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;</a>
<%
	}
	else if (requestForCType)
	{
%>
							<a id='mouse' onClick="javascript:goToCType();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;</a>
<%
	}
	else if (requestToChange)
	{
%>
							<a id='mouse' onClick="javascript:goChange();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;</a>
<%
	}
	else if (requestFromDashboard)
	{
%>
							<a id='mouse' onClick="javascript:history.back();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;</a>
<%
	}
	else
	{
%>
							<a id='mouse' onClick="javascript:goToChange();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;</a>
<%
	}
%>
						</div>
					</div>
				</div>
			</td>
		</tr>

		<tr>
			<td valign="top" height="100%" id="padding5" class="bgmedium">
				<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;">
				<table border="0" cellspacing="0" cellpadding="0" width="100%" id="bottomtable" height="100%"><tr><td valign="top" height="100%">
<%
	//For New Pdf Framework - Krishnamurthi
	ArrayList aListPdfData = new ArrayList();
	ArrayList aListTestNamesForCSV = new ArrayList();
	EgPdfData pdfData = new EgPdfData();
	EgReportAttributes reportAttributes = new EgReportAttributes();

	String pdfTitle = "";
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CHANGE CONFIGURATION REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}
	else
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CHANGE CONFIGURATION REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}
	pdfTitle = pdfTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGES") + " : " + mappingInfo.getTextDescription("configmgmt.changes.detailed.DETAILED");
	reportAttributes.setMainTitle(pdfTitle);
	reportAttributes.setReportName("DetailedConfigurationChanges");
	reportAttributes.setModule("CONFIG");

	String subTitle = ""; //For PDF

	String component = componentName.substring(0,componentName.lastIndexOf(':'));
	if (component.endsWith(":NULL"))
		component = component.substring(0,component.lastIndexOf(':'));

	String comp_type = componentName.substring(componentName.lastIndexOf(':')+1);

	subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name") + " : " + component + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(comp_type) + "\n";
%>
				<table border="0" align="center" width="100%" class="bgdark">
					<tr>
						<td align="left" id="whitefont" height="20">&nbsp;<egui:intnl text="configmgmt.changes.detailed.Component Name" /> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(componentName.substring(componentName.lastIndexOf(':')+1))%>]</td>
						<td align="right" id="whitefont">
<%
	if (ec_timeline != null && !ec_timeline.equalsIgnoreCase("Any"))
	{
		/* Added by Prakash.K starts */
		timeZoneConverter = new EgTimeZoneConverter(s_start_time,user);
		startDateAndTime = timeZoneConverter.getDateTime();
		timeZoneConverter = new EgTimeZoneConverter(s_end_time,user);
		endDateAndTime = timeZoneConverter.getDateTime();
		/* Added by Prakash.K ends */

		subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
		<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
	}
	else
	{
		/* Added by Prakash.K starts */
		timeZoneConverter = new EgTimeZoneConverter(ec_stdate+" "+sHour+":"+sMinute,user);
		startDateAndTime = timeZoneConverter.getDateTime();
		timeZoneConverter = new EgTimeZoneConverter(ec_enddate+" "+eHour+":"+eMinute,user);
		endDateAndTime = timeZoneConverter.getDateTime();
		/* Added by Prakash.K ends */

		subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
		<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
	}
%>
						&nbsp;</td>
					</tr>
				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
	//For PDF
	EgTableAttributes egTableAttributes = new EgTableAttributes();
	ArrayList aListColumnNames = new ArrayList();
	ArrayList aListData = new ArrayList();

	aListColumnNames.add("C0");

	TreeMap tmapChanges = processChangeData.getComponentSummary(componentName,tmap_changeConfigDetails,selectedDate,selectedHour);
	Iterator changeCountKeys = tmapChanges.keySet().iterator();
	int totalCount=0;
	int maxCount=0;
	ArrayList aList = new ArrayList();
	while (changeCountKeys.hasNext())
	{
		Integer changeCount = (Integer)changeCountKeys.next();
		aList.add(changeCount);
		maxCount=Math.max(maxCount,changeCount.intValue());
	}
	Collections.reverse(aList);

	StringBuffer strBufferTestnames = new StringBuffer(); //for bar chart label
	StringBuffer strBufferChangeCounts = new StringBuffer();//for bar chart label count
	StringBuffer strBufferColors = new StringBuffer();//for bar chart color
	ArrayList aListTestnames = new ArrayList();
	ArrayList aListChangeCount = new ArrayList();
	String yAxisMaxValue = " ";
	ArrayList aListCount = new ArrayList();
	int i_totalChangeCount = 0;
	
	for (int a=0; a<aList.size(); a++)
	{
		Integer changeCount = (Integer)aList.get(a);
		ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

		aListTestnames.addAll(aListTemp);

		for (int i=0; i<aListTemp.size(); i++)
		{
			aListChangeCount.add(changeCount);
			i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
		}
	}

	//Build graph for TopN items
	boolean topNFlag = false;
	int indexCount = 0;
	if (aListTestnames.size() < topN)
	{
		indexCount = aListTestnames.size();
	}
	else
	{
		indexCount = topN;
		topNFlag = true;
	}

	for (int b=0; b<indexCount; b++)
	{
		String testname = (String)aListTestnames.get(b);
		Integer changeCount = (Integer)aListChangeCount.get(b);
		if (!aListCount.contains(changeCount))
		{
			aListCount.add(changeCount);
		}
		if (b == 0)
		{
			strBufferTestnames.append(mappingInfo.getTestDescription(testname));
			strBufferChangeCounts.append(changeCount.intValue());
			strBufferColors.append(barColor);
		}
		else
		{
			strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
			strBufferChangeCounts.append(","+changeCount.intValue());
			strBufferColors.append(","+barColor);
		}
		totalCount = totalCount + changeCount.intValue();
	}
	String barLabels = strBufferTestnames.toString();
	String barValues = strBufferChangeCounts.toString();
	String barColors = strBufferColors.toString();

	boolean flagEqualsOne = true;
	for (int i=1; i<aListCount.size(); i++)
	{
		Integer count_Value = (Integer)aListCount.get(i);
		if (count_Value.intValue() > 1)
		{
			flagEqualsOne = false;
			break;
		}
	}
	if (flagEqualsOne)
	{
		yAxisMaxValue = "5";
	}
	else
	{
		yAxisMaxValue = "0";
	}

	//Fusion Bar chart Data starts--Rekha
	HashMap mapChartAttributes = new HashMap();//map for chart attributes
	mapChartAttributes.put("bgcolor","FFFFFF");
	mapChartAttributes.put("yAxisName","Number of changes");
	mapChartAttributes.put("showToolTip","1");
	mapChartAttributes.put("showValues","1");
	mapChartAttributes.put("showBorder","0");
	mapChartAttributes.put("showShadow","0");
	mapChartAttributes.put("alpha","0");
	mapChartAttributes.put("canvasBgColor","F2F2F2");
	mapChartAttributes.put("canvasBgAlpha","60");
	mapChartAttributes.put("canvasBorderColor","000000");
	mapChartAttributes.put("canvasBorderThickness","1");
	mapChartAttributes.put("canvasBorderAlpha","30");
	mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
	mapChartAttributes.put("maxBarHeight","40");

	HashMap mapChartData = new HashMap();//map for chart data
	mapChartData.put("barLabels",barLabels);
	mapChartData.put("barValues",barValues);
	mapChartData.put("barColors",barColors);
	
	HashMap mapProperties = new HashMap();//map for misc properties
	mapProperties.put("showColors","true");
	mapProperties.put("enableLinks","false");

	EcFusionChartBean chartbean = new EcFusionChartBean();
	String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
	//Fusion Bar Chart Data ends

	String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
	maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
	String maximumRange = ""+maxCount;
	String chartTitle = titleName;
	if (topNFlag)
	{
		titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "  " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//pdf
		chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + "&nbsp;(" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + "&nbsp;" + indexCount + ") : " + totalCount + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//chart
	}

	aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range="+URLEncoder.encode(maximumRange)+"&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(strBufferChangeCounts.toString())+"&barLabels="+EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

	aListTestNamesForCSV.add("");

	EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
	egTableAttributes.setImageData(true);

	EgTable egTable = new EgTable();
	egTable.setModel(egTableModel);
	egTable.setAttributes(egTableAttributes);

	aListPdfData.add(egTable);
	reportAttributes.setSubTitle(subTitle);
%>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

				<table border="0" align="center" width="99%" class="body_text">
<%
	boolean flag = false;
	if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
	{
		flag = true;
	}
	if (flag)
	{
%>
						<tr>&nbsp;
							<td align="center" width="100%"><b><%=chartTitle%></b></td>
						</tr>
						<tr>
							<td align="center" width="100%" bgcolor="white"  nowrap>
								<!--
								<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
									<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
									<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
									<param name="quality" value="high" />
									<param name="wmode" value="transparent" />
									<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="650" height="250" name="StackedBar3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object>
								-->
								<div id="StackedBarShow3DContainer"  style="height:100%;"></div>
								<script type="text/javascript">
								if  ( FusionCharts( "StackedBarShow3D" ) )
								FusionCharts( "StackedBarShow3D" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf", "StackedBarShow3D","650", "250","0","1");
								myChart.setXMLData("<%=xmlString%>");
								myChart.setTransparent(true);
								myChart.render("StackedBarShow3DContainer");
								</script>
							</td>
						</tr>
<%
	}
	else
	{
%>
						<tr>&nbsp;
							<td align="center" width="100%"><b><%=chartTitle%></b></td>
						</tr>
						<tr>
							<td align="center" width="100%" bgcolor="white"  nowrap>
								<!--
								<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
									<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
									<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
									<param name="quality" value="high" />
									<param name="wmode" value="transparent" />
									<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="650" height="200" name="StackedBar2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
								</object>
								-->
								<div id="StackedBarShow2DContainer"  style="height:100%;"></div>
								<script type="text/javascript">
								if  ( FusionCharts( "StackedBarShow2D" ) )
								FusionCharts( "StackedBarShow2D" ).dispose();
								var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf", "StackedBarShow2D","650", "250","0","1");
								myChart.setXMLData("<%=xmlString%>");
								myChart.setTransparent(true);
								myChart.render("StackedBarShow2DContainer");
								</script>
							</td>
						</tr>
<%
	}
%>
				</table>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
	if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byInformation"))
	{
		//Display changes information-wise(testname)
		TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(componentName);
		tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,selectedHour);
		for (int c=0; c<aListTestnames.size(); c++)
		{
			String key_testname = (String)aListTestnames.get(c);
			Integer changeCount = (Integer)aListChangeCount.get(c);
			TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
			Iterator info_keys = temp_tmap_Data.keySet().iterator();
			aListTestNamesForCSV.add(key_testname);

			HashMap testinDiff = (HashMap)treeValues.get(key_testname);

			egTableAttributes = new EgTableAttributes();
			aListColumnNames = new ArrayList();
			aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
			ArrayList fieldWidths = new ArrayList();

			egTableAttributes.setTitle(mappingInfo.getTestDescription(key_testname) + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " : " + changeCount + ")");

			boolean isDynamicMeasureTest = false;
			String firstKey = (String)temp_tmap_Data.firstKey();
			int idx_M = firstKey.indexOf("~M~");
			if (idx_M != -1)
			{
				isDynamicMeasureTest = true;
			}

			ArrayList aListInfoHeadings = null;
			if (isDynamicMeasureTest)
			{
				aListInfoHeadings = new ArrayList();
				String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
				if (infoHeadings != null && infoHeadings.length() > 0)
				{
					StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
					while (strTokensTemp.hasMoreTokens())
					{
						String str_temp = strTokensTemp.nextToken();
						aListInfoHeadings.add(str_temp);
					}
				}
			}

			String str_colspan = "4";
			if (!firstKey.equals("+") && !(ecUtils.getInfoForDisplay(firstKey).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(firstKey).equals(EgConfigConstants.CF_EMPTY)))
			{
				str_colspan = "5";
			}

			String measuresTemp = "";
			EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
			String[] testMeasures = thresholdInfo.getMeasurementsForTest(key_testname);
			ArrayList measuresListTemp = new ArrayList();
			if (testMeasures != null && testMeasures.length > 0)
			{
				measuresListTemp.addAll(Arrays.asList(testMeasures));
			}
			for(int i=0;i< measuresListTemp.size();i++)
			{
				measuresTemp = (String)measuresListTemp.get(i);
			}
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable" class="body_text">
					<tr>
						<td class="table_header" id="white_content" style="padding:3px" colspan="<%=str_colspan%>">
							<b><egui:intnl test="<%=key_testname%>" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.changes.detailed.Changes" /> : <%=changeCount%>)</b>
						</td>
					</tr>
					<!-- <tr>
						<td>
							<table cellspacing="0" cellpadding="0" border="0" align="center" width="100%" class="body_text"> -->
<%


			boolean heading_flag = false;
			while (info_keys.hasNext())
			{
%>
					<tr>
<%
				String key_info = (String)info_keys.next();
				if (!heading_flag)
				{
					if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
					{
						aListColumnNames.add("C0");
						aListColumnNames.add("C1");
						aListColumnNames.add("C2");
						aListColumnNames.add("C3");
						aListColumnNames.add("C4");

						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

						//Landscape - 830
						fieldWidths.add("0");
						fieldWidths.add("140");
						fieldWidths.add("140");
						fieldWidths.add("275");
						fieldWidths.add("275");

						egTableAttributes.setDataGrouping(true);
						egTableAttributes.setDataGroupingField(0);
						egTableAttributes.setFieldWidths(fieldWidths);
%>
						<td width="20%" id="cell_header"><egui:intnl text="configmgmt.changes.detailed.Descriptor" /></td>
<%
					}
					else
					{
						aListColumnNames.add("C0");
						aListColumnNames.add("C1");
						aListColumnNames.add("C2");
						aListColumnNames.add("C3");

						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
						userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

						//Landscape
						fieldWidths.add("140");
						fieldWidths.add("140");
						fieldWidths.add("275");
						fieldWidths.add("275");

						egTableAttributes.setFieldWidths(fieldWidths);
					}
%>
						<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Measure" /></td>
						<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Date" /></td>
						<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Previous Value" /></td>
						<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Present Value" /></td>
<%
					heading_flag = true;
				}
%>
					</tr>
<%

				TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
				Iterator measure_keys = tmap_Data.keySet().iterator();

				boolean newInfoFlag = false;
				int idx_NI = key_info.indexOf("~NEW-INFO~");
				if (idx_NI != -1)
				{
					newInfoFlag = true;
					key_info = key_info.substring(idx_NI+10);
				}

				String strDataForPDF = "";
				if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
				{
%>
					<tr>
						<td id="bglightlight" align="left" class="body_text" height="20" colspan="<%=str_colspan%>">
<%
					if (!isDynamicMeasureTest)
					{
%>
						<b style="font-size:7.5pt">&nbsp;<%=ecUtils.getInfoForDisplay(key_info)%></b>
<%
					}
					else
					{
						ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
						int aListTokensSize = aListTokens.size();
						String strData = "";
						for (int x=0;x<aListTokensSize;x++)
						{
							String infoHeading = (String)aListInfoHeadings.get(x);
							String strTemp = (String)aListTokens.get(x);
							if (x == aListTokensSize-1)
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
							}
							else
							{
								strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
							}
						}
						out.println("&nbsp;"+strData);
					}

					if (newInfoFlag)
					{
%>
						<img src="/final/config/images/new_info.gif" border="0">
<%
					}
%>
						</td>
					</tr>
<%
				}

				boolean isMeasure = false;
				String testDescr = mappingInfo.getTestDescription(key_testname);

				measure_keys = tmap_Data.keySet().iterator();
				while (measure_keys.hasNext())
				{
					String key_measure = (String)measure_keys.next();
					ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);

					String lengthinDiff = "0";
					if (testinDiff != null)
					{
						isMeasure = testinDiff.containsKey(key_measure);
						if (isMeasure)
						{
							lengthinDiff = (String)testinDiff.get(key_measure);
						}
					}
					int lengthinMeasureInt = Integer.parseInt(lengthinDiff);

					boolean measureFlag = false;

					for(int y=0;y<al_data.size();y++)
					{
						ArrayList arraylist_temp = (ArrayList)al_data.get(y);

						String previous_measurevalue = (String)arraylist_temp.get(1);
						String present_measurevalue = (String)arraylist_temp.get(2);

						if (!isDynamicMeasureTest)
						{
							if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase("##R##") && !present_measurevalue.equalsIgnoreCase("##R##"))
							{
%>
					<div><tr>
<%
								if (!key_info.equals("+"))
								{
									if (newInfoFlag)
									{
										aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + ecUtils.getInfoForDisplay(key_info) + " [NEW]");
									}
									else
									{
										aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + ecUtils.getInfoForDisplay(key_info));
									}
%>
						<td width="20%" id="cell_bg2">&nbsp;</td>
<%
								}

								if (!measureFlag)
								{
									aListData.add(key_measure);
%>
									<td width="20%" nowrap id="cell_bg2" valign="top"><%=key_measure%></td>
<%
									measureFlag = true;
								}
								else
								{
									aListData.add(" ");
%>
						<td width="20%" nowrap id="cell_bg2">&nbsp;</td>
<%
								}

								String strDateTime = (String)arraylist_temp.get(0);
								String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
								String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
								String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);
								
								/* Added by Prakash.K starts */
								timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
								startDateAndTime = timeZoneConverter.getDateTime();
								/* Added by Prakash.K ends */
								String tempDisplayDate = "";
								if (startDateAndTime.indexOf(",") != -1)
								{
									tempDisplayDate = StringUtils.replace(startDateAndTime,",","");
								}
								else
								{
									tempDisplayDate = startDateAndTime;
								}
								aListData.add(tempDisplayDate);
%>
						<td width="20%" nowrap id="cell_bg2" valign="top">
							<%=startDateAndTime%>
						</td>
<%
								if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
						<td width="20%" id="cell_bg2" valign="top"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
								}
								else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.common.No"));
%>
						<td width="20%" id="cell_bg2" valign="top"><egui:intnl text="configmgmt.common.No" /></td>
<%
								}
								else
								{
									if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
									{
										previous_measurevalue = "[NPV]";
									}

									aListData.add(previous_measurevalue);
									if (previous_measurevalue.startsWith("<?configuration?>"))
									{
										//previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
						<td width="20%" id="cell_bg2" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=key_testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=key_info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"/><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;</td>
<%
									}
									else
									{
										if (previous_measurevalue.length()<=25)
										{
											previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
						<td width="20%" id="cell_bg2" valign="top"><div><%=previous_measurevalue%>&nbsp;</div></td>
<%
										}
										else
										{
%>
						<td width="20%" id="cell_bg2" valign="top"><div>
<%
											ArrayList aListStrValues = breakString(previous_measurevalue,25);
											for (int r=0;r<aListStrValues.size();r++)
											{
												String str_value = (String)aListStrValues.get(r);
												str_value = EcUtils.replaceTags(str_value);
												out.print(str_value+"<br>");
											}
%>
						</div></td>
<%
										}
									}
								}

								if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
						<td width="20%" id="cell_bg2" valign="top"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
								}
								else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.common.No"));
%>
						<td width="20%" id="cell_bg2" valign="top"><egui:intnl text="configmgmt.common.No" /></td>
<%
								}
								else
								{
									aListData.add(present_measurevalue);
									if (present_measurevalue.startsWith("<?configuration?>"))
									{
										//present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
						<td width="20%" id="cell_bg2" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=key_testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=key_info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"/><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;
<%
											if (!previous_measurevalue.equals("-") && 
												!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
												!present_measurevalue.equals("-"))
											{
												if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
												{
%>
													<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
												}
											}
%>
						</td>
<%
									}
									else
									{
										if (present_measurevalue.length()<=25)
										{
											present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
						<td width="20%" id="cell_bg2" valign="top"><div><%=present_measurevalue%>&nbsp;
<%
											if (!previous_measurevalue.equals("-") && 
												!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
												!present_measurevalue.equals("-"))
											{
												if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
												{
%>
													<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
												}
											}
%>
						</div></td>
<%
										}
										else
										{
%>
						<td width="20%" id="cell_bg2" valign="top"><div>
<%
											ArrayList aListStrValues = breakString(present_measurevalue,25);
											for (int r=0;r<aListStrValues.size();r++)
											{
												String str_value = (String)aListStrValues.get(r);
												str_value = EcUtils.replaceTags(str_value);
												out.print(str_value+"<br>");
											}

											if (!previous_measurevalue.equals("-") && 
												!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
												!present_measurevalue.equals("-"))
											{
												if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
												{
%>
													<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
												}
											}
%>
						</div></td>
<%
										}
									}
								}
%>
					</tr>
<%
							}
						}
						else
						{
%>
					<tr>
<%
							if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
							{
								if (newInfoFlag)
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + strDataForPDF + " [NEW]");
								}
								else
								{
									aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + strDataForPDF);
								}
%>
						<td width="20%" id="cell_bg2">&nbsp;</td>
<%
							}

							boolean newMeasureFlag = false;
							boolean deletedMeasureFlag = false;
							if (!newInfoFlag)
							{
								if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
									previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
									previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									newMeasureFlag = true;
								}
								else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
								{
									deletedMeasureFlag = true;
								}
							}

							if (newMeasureFlag)
							{
								aListData.add(key_measure + " [NEW]");
%>
						<td width="20%" nowrap id="cell_bg2" valign="top"><%=key_measure%>&nbsp;<img src="/final/config/images/new_info.png" border="0"></td>
<%
							}
							else if (deletedMeasureFlag)
							{
								aListData.add(key_measure + " [REMOVED]");
%>
						<td width="20%" nowrap id="cell_bg2" valign="top"><%=key_measure%>&nbsp;<img src="/final/config/images/removed_info.png" border="0"></td>
<%
							}
							else
							{
								aListData.add(key_measure);
%>
						<td width="20%" nowrap id="cell_bg2" valign="top"><%=key_measure%></td>
<%
							}

							String strDateTime = (String)arraylist_temp.get(0);
							String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
							String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
							String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
							startDateAndTime = timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */
							String tempDisplayDate = "";
							if (startDateAndTime.indexOf(",") != -1)
							{
								tempDisplayDate = StringUtils.replace(startDateAndTime,",","");
							}
							else
							{
								tempDisplayDate = startDateAndTime;
							}
							aListData.add(tempDisplayDate);
%>
						<td width="20%" nowrap id="cell_bg2" valign="top">
							<%=startDateAndTime%>
						</td>
<%
							if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
							{
								previous_measurevalue = "[N/PV]";
							}
							else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								previous_measurevalue = "[N/A]";
							}

							aListData.add(previous_measurevalue);
							if (previous_measurevalue.length()<=28)
							{
								previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
						<td width="20%" id="cell_bg2" valign="top"><div><%=previous_measurevalue%>&nbsp;</div></td>
<%
							}
							else
							{
%>
						<td width="20%" id="cell_bg2" valign="top"><div>
<%
								ArrayList aListStrValues = breakString(previous_measurevalue,28);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.print(str_value+"<br>");
								}
%>
						</div></td>
<%
							}

							if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								present_measurevalue = "[N/A]";
							}

							aListData.add(present_measurevalue);
							if (present_measurevalue.length()<=28)
							{
								present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
						<td width="20%" id="cell_bg2" valign="top"><div><%=present_measurevalue%>&nbsp;
<%
								if (!previous_measurevalue.equals("-") && 
									!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
									!previous_measurevalue.equalsIgnoreCase("[N/A]") && 
									!present_measurevalue.equals("-") && 
									!present_measurevalue.equalsIgnoreCase("[N/A]"))
								{
									if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
									{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
									}
								}
%>
						</div></td>
<%
							}
							else
							{
%>
						<td width="20%" id="cell_bg2" valign="top"><div>
<%
								ArrayList aListStrValues = breakString(present_measurevalue,28);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.print(str_value+"<br>");
								}

								if (!previous_measurevalue.equals("-") && 
									!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
									!previous_measurevalue.equalsIgnoreCase("[N/A]") && 
									!present_measurevalue.equals("-") && 
									!present_measurevalue.equalsIgnoreCase("[N/A]"))
								{
									if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
									{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
									}
								}
%>
						</div></td>
<%
							}
%>
					</tr>
<%
						}
					}
				}
			}

			egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTableAttributes.setColumnNames(userColumnNames);

			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
%>

				</table>

				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
		}
	}
	else
	{
		ArrayList aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

		if ((searchCompValue != null && !searchCompValue.equals("")) || 
			(searchTestValue != null && !searchTestValue.equals("")) || 
			(searchDescValue != null && !searchDescValue.equals("")))
		{
			aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,componentName,searchCompValue,searchTestValue,searchDescValue,userLanguage);
		}
		else
		{
			aListChangesDatewise = processChangeData.getDatewiseChangeDataForComponent(aListChangesDatewise,componentName,selectedDate,selectedHour);
		}

		if (requestHomePage)
		{
			//Code for restricting the data to the selected date
			aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,selectedHour);
		}

		int aListChangesDatewiseSize = aListChangesDatewise.size();

		//For PDF
		egTableAttributes = new EgTableAttributes();
		aListColumnNames = new ArrayList();
		aListData = new ArrayList();
		aListTestNamesForCSV = new ArrayList();
		ArrayList userColumnNames = new ArrayList();
		ArrayList fieldWidths = new ArrayList();

		aListColumnNames.add("C0");
		aListColumnNames.add("C1");
		aListColumnNames.add("C2");
		aListColumnNames.add("C3");
		aListColumnNames.add("C4");
		aListColumnNames.add("C5");

		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date"));
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Information"));
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

		fieldWidths.add("0");
		fieldWidths.add("100");
		fieldWidths.add("160");
		fieldWidths.add("140");
		fieldWidths.add("215");
		fieldWidths.add("215");

		//For PDF - Start
		for (int i=0;i<aListChangesDatewiseSize;i++)
		{
			ArrayList al = (ArrayList)aListChangesDatewise.get(i);

			String strDateTime = (String)al.get(0);
			String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
			String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
			String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(displayDate+" "+strTime,user);
			startDateAndTime = timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */

			String testname = (String)al.get(2);
			String info = (String)al.get(3);
			Object measure_obj = al.get(4);
			Object previous_obj = al.get(5);
			Object present_obj = al.get(6);
			String tempDisplayDate = "";
			if (startDateAndTime.indexOf(",") != -1)
			{
				tempDisplayDate = StringUtils.replace(startDateAndTime,",","");
			}
			else
			{
				tempDisplayDate = startDateAndTime;
			}
			aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date") + " : " + tempDisplayDate);
			aListData.add(mappingInfo.getTestDescription(testname));

			aListTestNamesForCSV.add(testname);
			aListTestNamesForCSV.add(testname);

			boolean isDynamicMeasureTest = false;
			int idx_M = info.indexOf("~M~");
			if (idx_M != -1)
			{
				isDynamicMeasureTest = true;
			}

			ArrayList aListInfoHeadings = null;
			if (isDynamicMeasureTest)
			{
				aListInfoHeadings = new ArrayList();
				String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
				if (infoHeadings != null && infoHeadings.length() > 0)
				{
					StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
					while (strTokensTemp.hasMoreTokens())
					{
						String str_temp = strTokensTemp.nextToken();
						aListInfoHeadings.add(str_temp);
					}
				}
			}

			boolean newInfoFlag = false;
			if (measure_obj instanceof ArrayList)
			{
				newInfoFlag = true;
			}

			if (!isDynamicMeasureTest)
			{
				if (info.length() == 1)
				{
					aListData.add("N/A");
					aListTestNamesForCSV.add(testname);
				}
				else
				{
					if (newInfoFlag)
					{
						aListData.add(ecUtils.getInfoForDisplay(info)+" [NEW]");
					}
					else
					{
						aListData.add(ecUtils.getInfoForDisplay(info));
					}
					aListTestNamesForCSV.add(testname);
				}
			}
			else
			{
				if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
				{
					aListData.add("N/A");
					aListTestNamesForCSV.add(testname);
				}
				else
				{
					ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
					int aListTokensSize = aListTokens.size();
					String strDataForPDF = "";
					for (int x=0;x<aListTokensSize;x++)
					{
						String infoHeading = (String)aListInfoHeadings.get(x);
						String strTemp = (String)aListTokens.get(x);
						if (x == aListTokensSize-1)
						{
							strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
						}
						else
						{
							strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
						}
					}

					if (newInfoFlag)
					{
						aListData.add(strDataForPDF + " [NEW]");
					}
					else
					{
						aListData.add(strDataForPDF);
					}
					aListTestNamesForCSV.add(testname);
				}
			}

			if (measure_obj instanceof String)
			{
				String previous_value = (String)previous_obj;
				String present_value = (String)present_obj;

				boolean newMeasureFlag = false;
				boolean deletedMeasureFlag = false;
				if (isDynamicMeasureTest && !newInfoFlag)
				{
					if (previous_value.equalsIgnoreCase("##NEW##") || 
						previous_value.equalsIgnoreCase("##NEW-INFO##") || 
						previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						newMeasureFlag = true;
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						deletedMeasureFlag = true;
					}
				}

				if (newMeasureFlag)
				{
					aListData.add((String)measure_obj + " [NEW]");
				}
				else if (deletedMeasureFlag)
				{
					aListData.add((String)measure_obj + " [REMOVED]");
				}
				else
				{
					aListData.add((String)measure_obj);
				}
				aListTestNamesForCSV.add(testname);

				if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
				{
					previous_value = "[N/PV]";
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
				{
					previous_value = "[N/A]";
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
				{
					previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
				{
					previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
				}
				aListData.add(previous_value);
				aListTestNamesForCSV.add(testname);

				if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
				{
					present_value = "[N/A]";
				}
				else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
				{
					present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
				}
				else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
				{
					present_value = mappingInfo.getTextDescription("configmgmt.common.No");
				}
				aListData.add(present_value);
				aListTestNamesForCSV.add(testname);
			}
			else
			{
				ArrayList mn = (ArrayList)measure_obj;
				ArrayList prev = (ArrayList)previous_obj;
				ArrayList pres = (ArrayList)present_obj;
				for (int z=0;z<mn.size();z++)
				{
					String measure = (String)mn.get(z);
					String prevValue = (String)prev.get(z);
					String presValue = (String)pres.get(z);

					if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
					{
						prevValue = "[N/PV]";
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						prevValue = "[N/A]";
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						presValue = "[N/A]";
					}
					else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						presValue = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (z == 0)
					{
						aListData.add(measure);
						aListData.add(prevValue);
						aListData.add(presValue);

						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
					}
					else
					{
						aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date") + " : " + tempDisplayDate);
						aListData.add(" ");
						aListData.add(" ");
						aListData.add(measure);
						aListData.add(prevValue);
						aListData.add(presValue);

						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
						aListTestNamesForCSV.add(testname);
					}
				}
			}
		}
		//For PDF - End

		egTableModel = new EgTableModel(aListData,aListColumnNames);
		egTableAttributes.setColumnNames(userColumnNames);
		egTableAttributes.setDataGrouping(true);
		egTableAttributes.setDataGroupingField(0);
		egTableAttributes.setFieldWidths(fieldWidths);

		egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")+" : "+aListChangesDatewiseSize);
%>
				<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable" class="body_text">
<%
		boolean heading_flag = false;
		for(int i=0; i<aListChangesDatewiseSize; i++)
		{
			ArrayList al = (ArrayList)aListChangesDatewise.get(i);
			if (!heading_flag)
			{
%>
					<tr>
						<td>
							<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text">
								<tr>
									<td class="table_header" id="white_content" height="20" width="5%" style="padding-left:4px">
										<egui:intnl text="configmgmt.changes.detailed.Change Date" />
									</td>
									<td class="table_header" id="white_content" height="20" width="15%" style="padding-left:4px">
										<egui:intnl text="configmgmt.changes.detailed.Information" />
									</td>
									<td class="table_header" id="white_content" height="20" width="20%" style="padding-left:4px">
										<egui:intnl text="configmgmt.changes.detailed.Descriptor" />
									</td>
									<td valign="top" height="20" width="60%">
										<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text" height="100%">
											<tr>
												<td class="table_header" id="white_content" height="20" width="33%" style="padding-left:4px">
													<egui:intnl text="configmgmt.changes.detailed.Measure" />
												</td>
												<td class="table_header" id="white_content" height="20" width="33%" style="padding-left:4px">
													<egui:intnl text="configmgmt.changes.detailed.Previous Value" />
												</td>
												<td class="table_header" id="white_content" height="20" width="33%" style="padding-left:4px">
													<egui:intnl text="configmgmt.changes.detailed.Present Value" />
												</td>
											</tr>
										</table>
									</td>
								</tr>
<%
				heading_flag = true;
			}

			String strDateTime = (String)al.get(0);
			String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
			String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
			String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

			/* Added by Prakash.K starts */
			timeZoneConverter = new EgTimeZoneConverter(displayDate+" "+strTime,user);
			startDateAndTime = timeZoneConverter.getDateTime();
			/* Added by Prakash.K ends */

			String testname = (String)al.get(2);
			String info = (String)al.get(3);
			Object measure_obj = al.get(4);
			Object previous_obj = al.get(5);
			Object present_obj = al.get(6);

			String measuresTemp = "";

			EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
			String[] testMeasures = thresholdInfo.getMeasurementsForTest(testname);
			ArrayList measuresListTemp = new ArrayList();
			if (testMeasures != null && testMeasures.length > 0)
			{
				measuresListTemp.addAll(Arrays.asList(testMeasures));
			}
			for(int h=0;h< measuresListTemp.size();h++)
			{
				measuresTemp = (String)measuresListTemp.get(h);
			}

			HashMap testinDiff = (HashMap)treeValues.get(testname);
			boolean isMeasure = false;
			int lengthinMeasureInt = 0;
			String testDescr = mappingInfo.getTestDescription(testname);
			String lengthinDiff = "";
%>
								<tr>
									<td id="cell_bg1" valign="top" wrap width="5%">
										<%=startDateAndTime%>
									</td>
									<td id="cell_bg1" valign="top" wrap width="15%">
										<%=mappingInfo.getTestDescription(testname)%>
									</td>
<%
			boolean isDynamicMeasureTest = false;
			int idx_M = info.indexOf("~M~");
			if (idx_M != -1)
			{
				isDynamicMeasureTest = true;
			}

			ArrayList aListInfoHeadings = null;
			if (isDynamicMeasureTest)
			{
				aListInfoHeadings = new ArrayList();
				String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
				if (infoHeadings != null && infoHeadings.length() > 0)
				{
					StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
					while (strTokensTemp.hasMoreTokens())
					{
						String str_temp = strTokensTemp.nextToken();
						aListInfoHeadings.add(str_temp);
					}
				}
			}

			boolean newInfoFlag = false;
			if (measure_obj instanceof ArrayList)
			{
				newInfoFlag = true;
			}
%>
									<td width="20%" id="cell_bg1" valign="top">
<%
			if (!isDynamicMeasureTest)
			{
				info = ecUtils.getInfoForDisplay(info);
				if (!info.equals("+"))
				{
					if (info.length()<=25)
					{
						out.println(info);
					}
					else
					{
						ArrayList aListStrValues = breakString(info,25);
						for (int r=0;r<aListStrValues.size();r++)
						{
							String str_value = (String)aListStrValues.get(r);
							out.println(str_value+"<br>");
						}
					}
				}
				else
				{
					out.println("");
				}
			}
			else
			{
				if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
				{
					out.println("");
				}
				else
				{
					ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
					int aListTokensSize = aListTokens.size();
					String strData = "";
					for (int x=0;x<aListTokensSize;x++)
					{
						String infoHeading = (String)aListInfoHeadings.get(x);
						String strTemp = (String)aListTokens.get(x);
						if (x == aListTokensSize-1)
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
						}
						else
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
						}
					}
					out.println(strData);
				}
			}

			if (newInfoFlag)
			{
%>
				<img src="/final/config/images/new_info.gif" border="0">
<%
			}
%>
									&nbsp;</td>
<%
			if (measure_obj instanceof String)
			{
				String measureStr = (String)measure_obj;
				if (testinDiff != null)
				{
					isMeasure = testinDiff.containsKey(measure_obj);
					if (isMeasure)
					{
						lengthinDiff = (String)testinDiff.get(measure_obj);
						lengthinMeasureInt = Integer.parseInt(lengthinDiff);
					}
				}

				String previous_value = (String)previous_obj;
				String present_value = (String)present_obj;

				if (EcUtils.isUTF8(previous_value.getBytes()))
				{
					previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
				}
				if (EcUtils.isUTF8(present_value.getBytes()))
				{
					present_value = EcUtils.printSkippedBomString(present_value.getBytes());
				}

				boolean newMeasureFlag = false;
				boolean deletedMeasureFlag = false;
				if (isDynamicMeasureTest && !newInfoFlag)
				{
					if (previous_value.equalsIgnoreCase("##NEW##") || 
						previous_value.equalsIgnoreCase("##NEW-INFO##") || 
						previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						newMeasureFlag = true;
					}
					else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						deletedMeasureFlag = true;
					}
				}
%>
									<td valign="top" width="60%" height="20">
										<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text" height="100%">
											<tr>
<%
				if (newMeasureFlag)
				{
%>
												<td width="33%" id="cell_bg1" valign="top" wrap><%=measure_obj%><br><img src="/final/config/images/new_info.png" border="0"></td>
<%
				}
				else if (deletedMeasureFlag)
				{
%>
												<td width="33%" id="cell_bg1" valign="top" wrap><%=measure_obj%><br><img src="/final/config/images/removed_info.png" border="0"></td>
<%
				}
				else
				{
%>
												<td width="33%" id="cell_bg1" valign="top" wrap><%=measure_obj%></td>
<%
				}

				if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
				{
					previous_value = "[N/PV]";
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
				{
					previous_value = "[N/A]";
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
				{
					previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
				}
				else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
				{
					previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
				}

				if (previous_value.startsWith("<?configuration?>"))
				{
					//previous_value = StringUtils.replace(previous_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
													<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;</td>
<%
				}
				else
				{
					if (previous_value.length()<=20)
					{
						previous_value = EcUtils.replaceTags(previous_value);
%>
													<td width="33%" id="cell_bg1" valign="top"><%=previous_value%>&nbsp;</td>
<%
					}
					else
					{
%>
													<td width="33%" id="cell_bg1" valign="top">
<%
						ArrayList aListStrValues = breakString(previous_value,20);
						for (int r=0;r<aListStrValues.size();r++)
						{
							String str_value = (String)aListStrValues.get(r);
							str_value = EcUtils.replaceTags(str_value);
							out.println(str_value+"<br>");
						}
%>
													</td>
<%
					}
				}

				if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
				{
					present_value = "[N/A]";
				}
				else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
				{
					present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
				}
				else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
				{
					present_value = mappingInfo.getTextDescription("configmgmt.common.No");
				}

				if (present_value.startsWith("<?configuration?>"))
				{
					//present_value = StringUtils.replace(present_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
													<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;
<%
						if (!previous_value.equals("-") && 
							!previous_value.equalsIgnoreCase("[N/PV]") && 
							!previous_value.equalsIgnoreCase("[N/A]") && 
							!present_value.equals("-") && 
							!present_value.equalsIgnoreCase("[N/A]"))
						{
							if ((present_value.length() > lengthinMeasureInt) && isMeasure)
							{
%>
								<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
							}
						}
%>
													</td>
<%
				}
				else
				{
					if (present_value.length()<=20)
					{
						present_value = EcUtils.replaceTags(present_value);
%>
													<td width="33%" id="cell_bg1" valign="top"><%=present_value%>&nbsp;
<%
						if (!previous_value.equals("-") && 
							!previous_value.equalsIgnoreCase("[N/PV]") && 
							!previous_value.equalsIgnoreCase("[N/A]") && 
							!present_value.equals("-") && 
							!present_value.equalsIgnoreCase("[N/A]"))
						{
							if ((present_value.length() > lengthinMeasureInt) && isMeasure)
							{
%>
								<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
							}
						}
%>
													</td>
<%
					}
					else
					{
%>
													<td width="33%" id="cell_bg1" valign="top">
<%
						ArrayList aListStrValues = breakString(present_value,20);
						for (int r=0;r<aListStrValues.size();r++)
						{
							String str_value = (String)aListStrValues.get(r);
							str_value = EcUtils.replaceTags(str_value);
							out.println(str_value+"<br>");
						}

						if (!previous_value.equals("-") && 
							!previous_value.equalsIgnoreCase("[N/PV]") && 
							!previous_value.equalsIgnoreCase("[N/A]") && 
							!present_value.equals("-") && 
							!present_value.equalsIgnoreCase("[N/A]"))
						{
							if ((present_value.length() > lengthinMeasureInt) && isMeasure)
							{
%>
								<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
							}
						}
%>
													</td>
<%
					}
				}
%>
											</tr>
										</table>
									</td>
<%
			}
			else
			{
				ArrayList mn = (ArrayList)measure_obj;
				ArrayList prev = (ArrayList)previous_obj;
				ArrayList pres = (ArrayList)present_obj;
%>
									<td valign="top" width="60%" height="100%">
										<table border="0" cellspacing="0" cellpadding="0" height="100%" align="center" width="100%" class="body_text">
<%
				for (int z=0;z<mn.size();z++)
				{
					String measure = (String)mn.get(z);
					String prevValue = (String)prev.get(z);
					String presValue = (String)pres.get(z);

					if (!prevValue.startsWith("<?configuration?>"))
					{
						if (EcUtils.isUTF8(prevValue.getBytes()))
						{
							prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
						}
					}

					if (!presValue.startsWith("<?configuration?>"))
					{
						if (EcUtils.isUTF8(presValue.getBytes()))
						{
							presValue = EcUtils.printSkippedBomString(presValue.getBytes());
						}
					}

					if (testinDiff != null)
					{
						isMeasure = testinDiff.containsKey(measure);
						if (isMeasure)
						{
							lengthinDiff = (String)testinDiff.get(measure);
							lengthinMeasureInt = Integer.parseInt(lengthinDiff);
						}
					}
%>
											<tr>
												<td width="33%" id="cell_bg1" valign="top"><%=measure%></td>
<%
					if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
					{
						prevValue = "[N/PV]";
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						prevValue = "[N/A]";
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (prevValue.startsWith("<?configuration?>"))
					{
						//prevValue = StringUtils.replace(prevValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
													<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;</td>
<%
					}
					else
					{
						if (prevValue.length()<=20)
						{
							prevValue = EcUtils.replaceTags(prevValue);
%>
													<td width="33%" id="cell_bg1" valign="top"><%=prevValue%>&nbsp;</td>
<%
						}
						else
						{
%>
													<td width="33%" id="cell_bg1" valign="top">
<%
							ArrayList aListStrValues = breakString(prevValue,20);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}
%>
													</td>
<%
						}
					}

					if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
					{
						presValue = "[N/A]";
					}
					else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
					{
						presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
					}
					else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
					{
						presValue = mappingInfo.getTextDescription("configmgmt.common.No");
					}

					if (presValue.startsWith("<?configuration?>"))
					{
						//presValue = StringUtils.replace(presValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
													<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=ec_changetype%>&ec_component=<%=componentName%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOption%>&ec_timeline=<%=ec_timeline%>&ec_prevtimeline=<%=ec_prevtimeline%>&ec_enddate_h=<%=ec_enddate%>&ec_endhr_h=<%=eHour%>&ec_endmin_h=<%=eMinute%>&ec_stdate_h=<%=ec_stdate%>&ec_sthr_h=<%=sHour%>&ec_startmin_h=<%=sMinute%>&ec_option1=<%=ec_option1%>&ec_option2=<%=ec_option2%>&ec_test=<%=testname%>&changeConfigSelTest=<%=selectedTests%>&ec_viewchange=<%=s_viewchange%>&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&request_from=Change&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;
<%
							if (!prevValue.equals("-") && 
								!prevValue.equalsIgnoreCase("[N/PV]") && 
								!prevValue.equalsIgnoreCase("[N/A]") && 
								!presValue.equals("-") && 
								!presValue.equalsIgnoreCase("[N/A]"))
							{
								if ((presValue.length() > lengthinMeasureInt) && isMeasure)
								{
%>
									<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
								}
							}
%>
													</td>
<%
					}
					else
					{
						if (presValue.length()<=20)
						{
							presValue = EcUtils.replaceTags(presValue);
%>
													<td width="33%" id="cell_bg1" valign="top"><%=presValue%>&nbsp;
<%
							if (!prevValue.equals("-") && 
								!prevValue.equalsIgnoreCase("[N/PV]") && 
								!prevValue.equalsIgnoreCase("[N/A]") && 
								!presValue.equals("-") && 
								!presValue.equalsIgnoreCase("[N/A]"))
							{
								if ((presValue.length() > lengthinMeasureInt) && isMeasure)
								{
%>
									<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
								}
							}
%>
													</td>
<%
						}
						else
						{
%>
													<td width="33%" id="cell_bg1" valign="top">
<%
							ArrayList aListStrValues = breakString(presValue,20);
							for (int r=0;r<aListStrValues.size();r++)
							{
								String str_value = (String)aListStrValues.get(r);
								str_value = EcUtils.replaceTags(str_value);
								out.println(str_value+"<br>");
							}

							if (!prevValue.equals("-") && 
								!prevValue.equalsIgnoreCase("[N/PV]") && 
								!prevValue.equalsIgnoreCase("[N/A]") && 
								!presValue.equals("-") && 
								!presValue.equalsIgnoreCase("[N/A]"))
							{
								if ((presValue.length() > lengthinMeasureInt) && isMeasure)
								{
%>
									<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
								}
							}
%>
													</td>
<%
						}
					}
%>
											</tr>
<%
				}
%>
										</table>
									</td>
<%
			}
%>
								</tr>
<%
		}
%>
							</table>
						</td>
					</tr>
				</table>
				<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
	}

	pdfData.setAttributes(reportAttributes);
	pdfData.setData(aListPdfData);
	pdfData.setTest(aListTestNamesForCSV);
	pdfData.setViewBy(s_viewchange);
	session.setAttribute("pdfData",pdfData);
%>
				</td></tr></table>
				</div>
			</td>
		</tr>
	</table>

</form>
</body>
</html>



