<%
/*
	File				:	ecServiceStatus.jsp
	Purpose				:	Display the list of services with status
	Creation Date		:	18-01-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import ="com.eg.EgConfigTestsInfo"%>
<%@ page import="egurkha.config.EcServiceResult"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EcServiceResult serviceResult=(EcServiceResult)request.getAttribute("Result");
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	EcUtils ecUtils = new EcUtils();
	EcPrintData printData=new EcPrintData();

	String configSkin = user.getConfigSkin();
	String osName=serviceResult.getOsName();
	String request_from = request.getParameter("request_from");
	String searchName=request.getParameter("searchName");
	String searchCriteria=request.getParameter("searchCriteria");
	String selectedServiceName=request.getParameter("serviceName");
	String isOSOnly=request.getParameter("osOnly");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	String strBackRequest = request.getParameter("back_request");
	String criteriaRequest = request.getParameter("criteriaReq");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig"))
	{
		String[] osNameArr = (String[]) request.getAttribute("os");
		osName = osNameArr[0];
		String[] searchNameArr = (String[]) request.getAttribute("searchName");
		searchName = searchNameArr[0];
		String[] searchCriteriaArr = (String[]) request.getAttribute("searchCriteria");
		searchCriteria = searchCriteriaArr[0];
	}

	if(searchName==null)
		searchName="";
	if(searchCriteria==null)
		searchCriteria="contain";

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		osName = (String)scheduleDetails.get("os");
		searchName = (String)scheduleDetails.get("searchName");
		searchCriteria = (String)scheduleDetails.get("searchCriteria");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		selectedServiceName = (String)scheduleDetails.get("serviceName");
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	Vector osNameList=serviceResult.getOsList();
	if(osNameList!=null && osNameList.size()>0)
		osNameList.remove("Unknown");

	Map servicesData=(TreeMap)serviceResult.getServiceData();
	ArrayList displayServicesName=serviceResult.getServicesName();
	Vector allServicesName=serviceResult.getAllServiceName();

	boolean goBack = false;
	boolean requestFromService = false;
	String scheduleBack = (String) request.getAttribute("schedule");
	if (request_from != null && !request_from.equalsIgnoreCase("HomePage") && !"null".equalsIgnoreCase(request_from))
	{
		goBack = true;
		requestFromService = true;
	}
	
	if (scheduleBack != null && scheduleBack.equalsIgnoreCase("scheduleBack"))
	{
		requestFromService = false;
		submitOrNot = "true";
	}
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		goBack = false;
		requestFromService = false;
		submitOrNot = "false";
	}
	if (request_from != null && request_from.equalsIgnoreCase("ServiceStatus"))
	{
		requestFromService = false;
	}
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
	}
	if (criteriaRequest != null && criteriaRequest.equalsIgnoreCase("change"))
	{
		submitOrNot = "false";
	}

	String userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>

<html>
<head>
<script language="JavaScript1.2" src="/final/config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<egui:skin ui="config"/>
</head>

<script language="JavaScript1.2">
	function showStatus()
	{
		var thisForm = document.ecServiceStatus;
		var osname = thisForm.os.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var srhName=thisForm.searchName.value;
		var searchCriteria;
		var serviceName;
		var sub =true;
		if(srhName!=""){
			sub= checkspecial(thisForm.searchName,"`~@$%^&*={}[]|\\;\"\'<>,?");
		}

		for (i=0; i<thisForm.searchCriteria.length; i++)
		{
			if(thisForm.searchCriteria[i].checked)
				searchCriteria= thisForm.searchCriteria[i].value
		}

		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.servicestatus.Please select an operating system" />');
			return;
		}
		else if(!sub)
		{
			thisForm.searchName.focus();
			return 
		}

		if((searchCriteria=="equals"))
		{
			serviceName=thisForm.serviceName.value;
			if(serviceName=="" || serviceName==-1 )
			{
				alert('<egui:intnl text="configmgmt.inventory.servicestatus.Please select a service name" />');
			}
		}
		else
		{
			if(!(searchCriteria=="contain"))
			{
				if(srhName=="")
				{
					alert('<egui:intnl text="configmgmt.inventory.servicestatus.Please enter the service name" />');
					thisForm.searchName.focus();
					return;
				}
			}
		}

		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		serviceName=encodeURIComponent(serviceName);
		window.location.href= "../servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=MenuServices&osName="+osname+"&searchCriteria="+searchCriteria+"&serviceName="+serviceName+"&searchName="+encodeURIComponent(srhName)+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
		document.ecServiceStatus.secsubmt.value='<egui:intnl text="configmgmt.common.Loading"/>'+'...';
		document.ecServiceStatus.secsubmt.disabled=true;
	}

	function validateforSchedule()
	{
		var thisForm = document.ecServiceStatus;
		var osname = thisForm.os.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var srhName=thisForm.searchName.value;
		var searchCriteria;
		var serviceName;
		var sub =true;
		if(srhName!=""){
			sub= checkspecial(thisForm.searchName,"`~@$%^&*={}[]|\\;\"\'<>,?");
		}

		for (i=0; i<thisForm.searchCriteria.length; i++)
		{
			if(thisForm.searchCriteria[i].checked)
				searchCriteria= thisForm.searchCriteria[i].value
		}

		if(osname== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.servicestatus.Please select an operating system" />');
			return false;
		}
		else if(!sub)
		{
			thisForm.searchName.focus();
			return false 
		}

		if((searchCriteria=="equals"))
		{
			serviceName=thisForm.serviceName.value;
			if(serviceName=="" || serviceName==-1 )
			{
				alert('<egui:intnl text="configmgmt.inventory.servicestatus.Please select a service name" />');
			}
		}
	}
	
	function osSelectionServiceName()
	{
		var thisForm = document.ecServiceStatus;

		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		var osname = thisForm.os.value;
		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=MenuServices&osName="+osname+"&osOnly=Yes"+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function showServiceName(sname)
	{
		if(sname=="equals")
		{
			document.getElementById("textBox").style.display="none";
			document.getElementById("listBox").style.display="block";
			document.getElementById("serviceName").style.width="280";
		}
		else
		{
			document.getElementById("listBox").style.display="none";
			document.getElementById("textBox").style.display="block";
			document.getElementById("searchName").style.width="280";
		}
	}

	function printData()
	{
<%
		if(displayServicesName == null || displayServicesName.size()==0 || (isOSOnly != null && isOSOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=SERVICE_STATUS");
		printQS.append("&printPageTitle=INVENTORY_REPORT_BY_SERVICE_STATUS");
		printQS.append("&Page=OS");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(displayServicesName == null || displayServicesName.size()==0 || (isOSOnly != null && isOSOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByServiceStatus");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (displayServicesName == null || displayServicesName.size() == 0 || (isOSOnly != null && isOSOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.ecServiceStatus;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";
		var request_from = "<%=request_from%>";
		var id = "<%=id%>";
		
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		window.location.href = "../servlet/com.eg.EcConfigurationServlet?cmd=ServiceDisplay&flagValue=MenuServices&osOnly=Yes&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from="+request_from+"&id="+id+"&criteriaReq=change";
	}

	function csv()
	{
<%
		if(displayServicesName == null || displayServicesName.size()==0 || (isOSOnly != null && isOSOnly.equalsIgnoreCase("Yes")))
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.ecServiceStatus;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=ServiceStatus";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:auto" onLoad="bigScreen();">
<form name="ecServiceStatus" method="POST" style="margin:0px">
<input type="hidden" name="ec_rtype" value="ServiceStatus">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="isSubmit" value="true">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
					&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.INVENTORY" /> : <egui:intnl text="configmgmt.inventory.servicestatus.SERVICE STATUS" /></b>
				</div>
				<div style="border:0px solid red;float:right;height:22px;">
<%
	if(requestFromService)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

								<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (goBack)
	{
%>
						<a id='mouse' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>

<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

<%
	if(requestFromService)
	{
%>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
	</tr>
<%
	}
%>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
<%
	if (!requestFromService)
	{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
								<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
		}
		else
		{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="100"><col width="180"><col width="10"><col width="350"><col width="180">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.servicestatus.Operating system"/> </td>
											<td  align="center">:</td>
											<td align="left"  nowrap>&nbsp;<select name="os" onChange="javascript:osSelectionServiceName();"> <%=ecUtils.fillSelectBox(osNameList,"config","",osName)%> </select> </td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.servicestatus.Search for service"/> </td>
											<td  align="center">:</td>
											<td align="left"  nowrap >
<%
		if(searchCriteria==null || searchCriteria.equals("contain"))
		{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td><input type="radio" value="contain" name="searchCriteria" checked onClick="javascript:showServiceName('contain');" id="eg_input" ></td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Containing"/> </td>
														<td> <input type="radio" value="start" name="searchCriteria" onClick="javascript:showServiceName('start');" id="eg_input"></td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Starting with"/> </td>
														<td> <input type="radio" value="end" name="searchCriteria" onClick="javascript:showServiceName('end');" id="eg_input"> </td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Ending with"/> </td>
														<td> <input type="radio" value="equals" name="searchCriteria" onClick="javascript:showServiceName('equals');" id="eg_input"> </td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Equals"/> </td>
													</tr>
												</table>
<%
		}
		else if(searchCriteria.equals("start"))
		{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input type="radio" value="contain" name="searchCriteria" onClick="javascript:showServiceName('contain');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Containing"/> </td>
														<td> <input type="radio" value="start" name="searchCriteria" checked onClick="javascript:showServiceName('start');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Starting with"/></td>
														<td> <input type="radio" value="end" name="searchCriteria" onClick="javascript:showServiceName('end');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Ending with"/></td>
														<td> <input type="radio" value="equals" name="searchCriteria"  onClick="javascript:showServiceName('equals');" id="eg_input"> </td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Equals"/> </td>
													</tr>
												</table>
<%
		}
		else if(searchCriteria.equals("end"))
		{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input type="radio" value="contain" name="searchCriteria" onClick="javascript:showServiceName('contain');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Containing"/></td>
														<td> <input type="radio" value="start" name="searchCriteria" onClick="javascript:showServiceName('start');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Starting with"/></td>
														<td> <input type="radio" value="end" name="searchCriteria" checked onClick="javascript:showServiceName('end');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Ending with"/></td>
														<td> <input type="radio" value="equals" name="searchCriteria" onClick="javascript:showServiceName('equals');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Equals"/> </td>
													</tr>
												</table>
<%
		}
		else
		{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td><input type="radio" value="contain" name="searchCriteria"  	onClick="javascript:showServiceName('contain');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Containing"/> </td>
														<td> <input type="radio" value="start" name="searchCriteria" onClick="javascript:showServiceName('start');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Starting with"/></td>
														<td> <input type="radio" value="end" name="searchCriteria" onClick="javascript:showServiceName('end');" id="eg_input"></td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Ending with"/></td>
														<td> <input type="radio" value="equals" name="searchCriteria" checked onClick="javascript:showServiceName('equals');" id="eg_input"> </td>
														<td><egui:intnl text="configmgmt.inventory.servicestatus.Equals"/> </td>
													</tr>
												</table>
<%
		}
%>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td  align="center" height="22">&nbsp;</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.servicestatus.Service Name"/></td>
											<td  align="center">:</td>
											<td align="left" nowrap >
<%
		if(searchCriteria!=null && !searchCriteria.equalsIgnoreCase("equals"))
		{
%>
						<div id="textBox" style="display:block;">&nbsp;<input type="text" id="searchName" name="searchName" value="<%=searchName%>" style="width:280px"></div>
						<div id="listBox" style="display:none;">
							&nbsp;<select name="serviceName" id="serviceName">
								<%=ecUtils.fillSelectBox(allServicesName,"",selectedServiceName)%>
							</select>
						</div>
<%
		}
		else
		{
%>
						<div id="textBox" style="display:none;">&nbsp;<input type="text" id="searchName" name="searchName" value="<%=searchName%>" style="width:280px"></div>
						<div id="listBox" style="display:block;">
							&nbsp;<select name="serviceName" id="serviceName" style="width:280px">
								<%=ecUtils.fillSelectBox(allServicesName,"",selectedServiceName)%>
							</select>
						</div>
<%
		}
%>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td align="center" >&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20">
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
<%
		}
		else
		{
%>
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showStatus();">
<%
		}
%>
											</td>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>

				<tr>
					<td  id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if(osName!=null && isOSOnly==null && displayServicesName!=null && !displayServicesName.isEmpty() && submitOrNot.equals("true"))
	{
%>
							<tr>
								<td width="100%" align="center" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
											<td height="20" class="tdbackcolortop" id="white_content">
												&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Service status in" />&nbsp;<%=osName%>&nbsp;<egui:intnl text="configmgmt.inventory.servicestatus.Systems" /></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
							<tr>
								<td valign="top" width="100%" align="center" height="100%">
								<!-- <div id="div_scroll" style="width:100%;height:375px;border:0px solid #000000"> -->
									<table width="100%" cellpadding="0" cellspacing="0" class="body_text" border="0">
										<tr>
											<td  height="5" id="blank">&nbsp; </td>
										</tr>
<%
	if(displayServicesName!=null && displayServicesName.size()>0 && isOSOnly==null && submitOrNot.equals("true"))
	{
		//Start to assign print data
		printData.setOsName(osName);
		printData.setSearchValue(searchName);
		printData.setSearchCriteria(searchCriteria);
		printData.setMapData(servicesData);
		printData.setListData(displayServicesName);
		printData.setAvailableName(selectedServiceName);
		session.setAttribute("SERVICE_STATUS",printData);
		//End to assign print data

		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();
		EgReportAttributes reportAttributes = new EgReportAttributes();
		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SERVICE STATUS") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SERVICE STATUS") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String reportSubTitle = "";
		if (searchName.length() > 0)
		{
			reportSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Service names containing ") + " " + "\"" + searchName + "\"" + " IN " + osName+" "+mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Systems");
		}
		else
		{
			reportSubTitle = mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Service status in")+" "+osName+" "+mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Systems");
		}
		reportAttributes.setSubTitle(reportSubTitle);

		reportAttributes.setReportName("ServiceStatusByOS");

		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		for(int s=0;s<displayServicesName.size();s++)
		{
			String serviceName=(String)displayServicesName.get(s); 
			Hashtable infoStatusList=(Hashtable)servicesData.get(serviceName);
			String running=(String)infoStatusList.get("Running");
			String stopped=(String)infoStatusList.get("Stopped");
			String unavailable=(String)infoStatusList.get("UNAVAILABLE");

			//pdf work
			ArrayList aListData = new ArrayList();
			ArrayList aListColumnNames = new ArrayList();
			ArrayList userColumnNames = new ArrayList();

			aListColumnNames.add("C1");
			aListColumnNames.add("C2");

			userColumnNames.add("");
			userColumnNames.add(serviceName);

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			//egTableAttributes.setTitle(serviceName);
			egTableAttributes.setStartX(0);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTableAttributes.setColumnNames(userColumnNames);
%>
										<tr>
											<td align="center" width="100%" valign="top" >
												<table border="0" width="99%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable">
													<tr>
														<td class="bgdarkimg"  height="20"><b><%=serviceName%></b></td>
													</tr>
													<tr>
														<td align="center" id="padding3">
															<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
<%
			if(running!=null)
			{
				StringTokenizer st=new StringTokenizer(running,"#");
				int count=st.countTokens();

				//pdf work
				String temp = null;
				if(count > 1){
					temp = "Systems";
				}else temp = "System";

				aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Running on")+" "+st.countTokens()+" "+mappingInfo.getTextDescription("configmgmt.inventory.servicestatus."+temp));
%>
																<tr>
																	<td id="tdbacklightcolor3"  align="left" width="16%" height="15">&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Running on" />&nbsp;<%=st.countTokens()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.servicestatus."+temp%>' /></b></td>
																	<td height="15" id="tdbacklightcolor3" ><!-- <img src="/final/config/images/cell_corner_green.gif"> --></td>
																</tr>

																<tr>
																	<td class="cell_border" align="left" colspan="2" style="border-left-width:1px;border-top-width:1px" id="cell_bg1" wrap>
<%
				String systemNamePdf = null;
				while(st.hasMoreElements())
				{
					String systemName=(String)st.nextElement();
					//pdf work
					if(systemNamePdf == null){
						systemNamePdf = systemName;
					}else{
						systemNamePdf = systemNamePdf + "," + systemName;
					}

					if(count>1)
					{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>,
<%
					}
					else
					{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>
<%
					}
					count--;
				}
%>
																	</td>
																</tr>
																
<%
				//pdf work
				aListData.add(systemNamePdf);
			}

			if(stopped!=null)
			{
				StringTokenizer st=new StringTokenizer(stopped,"#");
				int count=st.countTokens();

				//pdf work
				String temp = null;
				if(count > 1){
					temp = "Systems";
				}else temp = "System";
				aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.servicestatus.Stopped on")+" "+st.countTokens()+" "+mappingInfo.getTextDescription("configmgmt.inventory.servicestatus."+temp));
%>
																<tr>
																	<td id="tdbacklightcolor3"  align="left" width="16%" height="15">&nbsp;<b><egui:intnl text="configmgmt.inventory.servicestatus.Stopped on" />&nbsp;<%=st.countTokens()%>&nbsp;<egui:intnl text='<%="configmgmt.inventory.servicestatus."+temp%>' /></b></td>
																	<td height="15" id="tdbacklightcolor3"><!-- <img src="/final/config/images/cell_corner_green.gif"> --></td>
																</tr>
																<tr>
																	<td class="cell_border" id="cell_bg1" align="left" colspan="2" style="border-left-width:1px;border-top-width:1px" wrap>
<%
				String systemNamePdf = null;
				while(st.hasMoreElements())
				{
					String systemName=(String)st.nextElement();
					//pdf work
					if(systemNamePdf == null){
						systemNamePdf = systemName;
					}else{
						systemNamePdf = systemNamePdf + "," + systemName;
					}

					if(count>1)
					{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>,
<%
					}
					else
					{
%>
												<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"><%=systemName%></a>
<%
					}
					count--;
				}
%>
																	</td>
																</tr>
																
<%
				//pdf work
				aListData.add(systemNamePdf);
			}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="10" id="blank">&nbsp; </td>
										</tr>
<%
			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (osName != null && isOSOnly == null && !osName.equals("-1") && submitOrNot.equals("true"))
	{
%>
										<tr>
											<td align="center" valign="middle" >
												<table border="0" align="center" width="100%"  height="100%" cellpadding="0" cellspacing="0">
													<tr>
														<td align="center" height="350" valign="middle">
															<table border="0" align="center" width="100%" class="body_text" cellpadding="0" cellspacing="0">
																<tr>
																	<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
																</tr>
																<tr>
																	<td align="center"><b><egui:intnl text="configmgmt.inventory.servicestatus.No service found for the search pattern" /></b></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	}
%>
									</table>
								<!-- </div> -->
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



