<%
/*
	File				:	ecPrinterInfo.jsp
	Purpose				:	Display the system printer details
	Creation Date		:	21-02-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import="egurkha.config.EcPrinterResult"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	//langugae support
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);
	String request_from = request.getParameter("request_from");
	
	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */
	
	String id = request.getParameter("id");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	String configSkin = user.getConfigSkin();
	EcUtils ecUtils=new EcUtils();
	EcPrintData printData=new EcPrintData();
	EcPrinterResult result=(EcPrinterResult)request.getAttribute("Result");
	Map data=(Hashtable)result.getResultData();
	ArrayList contentList=result.getContentName();
	Vector selectionList=new Vector();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	if (aListAssociatedComponents != null && !aListAssociatedComponents.isEmpty())
	{
		selectionList.add("System");
		selectionList.add("Printer");
	}

	//request parameter
	String choice=request.getParameter("choice");
	String printerDefault=request.getParameter("defaultPrinter");
	String searchValue=request.getParameter("searchValue");
	String showOutput=request.getParameter("showOutput");
	searchValue = (searchValue==null || searchValue.equals(""))?"":searchValue.trim();

	String userName = (String)session.getAttribute("sess_auserid");

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		choice = (String)scheduleDetails.get("choice");
		printerDefault = (String)scheduleDetails.get("defaultPrinter");
		searchValue = (String)scheduleDetails.get("searchValue");
		showOutput = (String)scheduleDetails.get("showOutput");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		submitOrNot = "false";
	}
	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
%>

<html>
<head>
<!-- <link rel="stylesheet" href="../config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script type="text/javascript" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
	
	function showDetails()
	{
		var thisForm = document.PrinterInfo;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var printerDefault="False";
		var showOutput;
		var choice= thisForm.choice.value;
		var searchValue=thisForm.searchValue.value;
		
		var sub = checkspecial(thisForm.searchValue,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
		if(!sub)
		{
			thisForm.searchValue.focus();
			return;
		}

		if(document.PrinterInfo.printerDefault.checked==true)
			printerDefault="True";
		
		for (i=0; i<thisForm.showOutput.length; i++)
		{
			if(thisForm.showOutput[i].checked)
				showOutput= thisForm.showOutput[i].value
		}

		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=Printer&choice="+choice+"&showOutput="+showOutput+"&searchValue="+searchValue+"&defaultPrinter="+printerDefault+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);

		document.PrinterInfo.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
		document.PrinterInfo.secsubmt.disabled=true;
	}

	function validateforSchedule()
	{
		var thisForm = document.PrinterInfo;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var choiceValue;
		if (thisForm.choice != null && thisForm.choice != undefined)
		{
			choiceValue = thisForm.choice.value;
		}
		if (choiceValue != null && choiceValue != undefined && choiceValue == -1)
		{
			alert('<egui:intnl text="configmgmt.common.Please select" />' + " '" + '<egui:intnl text="configmgmt.common.Search by" />' + "'");
			return false;
		}

		var searchValue=thisForm.searchValue.value;
		var sub = checkspecial(thisForm.searchValue,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
		if(!sub)
		{
			thisForm.searchValue.focus();
			return false;
		}
	}

	function printData()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=PrinterInfo");
		printQS.append("&printPageTitle=CONFIGURED_PRINTERS_REPORT");
		printQS.append("&Page=AuditReport");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","ConfiguredPrintersReport");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (data == null || data.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.PrinterInfo;
		var showOutput;
		var choice= thisForm.choice.value;
		for (i=0; i<thisForm.showOutput.length; i++)
		{
			if(thisForm.showOutput[i].checked)
				showOutput= thisForm.showOutput[i].value
		}
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					choice = "Printer";
				}
			}
			else
			{
				choice = "Printer";
			}
		}

		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=Printer&choice="+choice+"&showOutput="+showOutput+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
<%
		if (data == null || data.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.PrinterInfo;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=Printer";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onLoad="bigScreen();">
<form name="PrinterInfo" method="POST" style="margin:0px">
<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
<input type="hidden" name="ec_rtype" value="Printer">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">
<input type="hidden" name="isSubmit" value="true">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.inventory.printers.CONFIGURED PRINTERS" /></b>
					</td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>

				</tr>
			</table>
		</td>
	</tr>
	
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="130"><col width="100"><col width="10"><col width="100"><col width="200"><col width="100"><col width="170">
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.printers.Search by" /> </td>
											<td align="center" >:</td>
											<td align="left"  nowrap>
												<select name="choice">
<%//=ecUtils.fillSelectBox(selectionList,"config","",choice)%>
<%
	if (selectionList != null && !selectionList.isEmpty())
	{
		for (int i=0;i<selectionList.size();i++)
		{
			String selected = "";
			String strSelection = (String)selectionList.get(i);
			if(choice != null && choice.equals(strSelection))
			{
				selected = "selected";
			}
%>
													<option value="<%=strSelection%>" <%=selected%>>
														<egui:intnl text='<%="configmgmt.inventory.printers."+strSelection%>' />
													</option>
<%
		
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="left"  nowrap> <input type="text" name="searchValue" value="<%=searchValue%>" style="width:200px" > </td>
<%
	if(printerDefault!=null && printerDefault.equalsIgnoreCase("True"))
	{
%>
											<td align="left"  nowrap > <input type="checkbox" name="printerDefault"  style="vertical-align:middle" checked id="eg_input"><egui:intnl text="configmgmt.inventory.printers.Default Printer" /> </td>
<%
	}
	else
	{
%>
											<td align="left"  nowrap  > <input type="checkbox"  name="printerDefault" style="vertical-align:middle" id="eg_input">&nbsp;<egui:intnl text="configmgmt.inventory.printers.Default Printer"/> </td>
<%
	}
%>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="right"  nowrap> <egui:intnl text="configmgmt.inventory.printers.Output" /> </td>
											<td align="center"> : </td>
											<td colspan="3" align="left" width="80%" nowrap>
<%
	if(showOutput==null || showOutput.equalsIgnoreCase("byPrinter"))
	{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input type="radio" value="bySystem" name="showOutput" id="eg_input"></td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.printers.By System" /> </td>
														<td>&nbsp;<input type="radio" value="byPrinter" name="showOutput" checked id="eg_input"></td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.printers.By Printer" /> </td>
													</tr>
												</table>
<%
	}
	else
	{
%>
												<table border="0" cellpadding="0" cellspacing="0">
													<tr>
														<td> <input type="radio" value="bySystem" name="showOutput" checked id="eg_input"></td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.printers.By System" /> </td>
														<td> <input type="radio" value="byPrinter" name="showOutput" id="eg_input"> </td>
														<td>&nbsp;<egui:intnl text="configmgmt.inventory.printers.By Printer" /> </td>
													</tr>
												</table>
<%
	}
%>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
											<td align="center">&nbsp;</td>
											<td align="center" colspan="5" valign="middle" height="20">
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>

											<td  align="center">&nbsp;</td>
											<td align="center" colspan="5" valign="middle" height="20"> 
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showDetails();">
											</td>
<%
	}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2px" > </td>

														<td width="19" align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13px" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13px"> </td>

														<td width="19" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13px"> </td>

														<td width="19" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13px"></td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="6" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	//start print data here
	printData.setSearchCriteria(choice);
	printData.setSearchValue(searchValue);
	printData.setPrinterName(printerDefault);
	printData.setShowCount(showOutput);
	printData.setMapData(data);
	printData.setListData(contentList);
	session.setAttribute("PrinterInfo",printData);
	//end print data here

	//pdf work
	ArrayList aListPdfData = new ArrayList();
	EgTable egTable = new EgTable();
	EgPdfData pdfData = new EgPdfData();
	EgReportAttributes reportAttributes = new EgReportAttributes();

	String pdfTitle = "";
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY CONFIGURED PRINTERS") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}
	else
	{
		pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY CONFIGURED PRINTERS") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
	}
	reportAttributes.setMainTitle(pdfTitle);
	reportAttributes.setReportName("ConfiguredPrinters");
	reportAttributes.setModule("CONFIG");
	reportAttributes.setPortrait(true);
	pdfData.setAttributes(reportAttributes);
%>
							<tr>
								<td align="center" valign="top">
								<!-- <div id="div_scroll" style="width:100%;height:415px;border:0px solid #000000"> -->
									<table width="100%" border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td width="100%" align="left">
												<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" >
													<tr>
<%
	if (data != null && data.size() > 0 && submitOrNot.equals("true") && isDisplay)
	{
%>
														<td width="85%" class="tdbackcolortop" id="white_content">&nbsp;<b><egui:intnl text="configmgmt.inventory.printers.Printers" /></b></td>
<%
	}
	if (data!=null && data.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
%>
														<td width="15%" align="right" class="tdbackcolortop">
															<table border="0" cellspacing="0" cellpadding="0" width="100%" >
																<tr>
																	<td align="center"  height="22"> <img src="../config/images/default_printer.gif" border="0"></td>
																	<td id="white_content"><egui:intnl text="configmgmt.inventory.printers.Default Printer" />&nbsp;&nbsp;
																	</td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td width="100%" align="center">
<%
		if(showOutput!=null && showOutput.equalsIgnoreCase("byPrinter"))
		{
			//pdf work
			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.printers.Distribution of Systems by Printer"));

			ArrayList aListData = new ArrayList();

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("Printers");
			aListColumnNames.add("System1");
			aListColumnNames.add("System2");
			aListColumnNames.add("System3");

			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("");
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.printers.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.printers.Printers") + " (* - " + mappingInfo.getTextDescription("configmgmt.inventory.printers.Default Printer") + ")");

			for(int n=0;n<contentList.size();n++)
			{
				String name=(String)contentList.get(n);
				Hashtable systemList=(Hashtable)data.get(name);
				if(systemList==null || systemList.size()==0)
					continue;
				Object[] kSet=systemList.keySet().toArray();
				
%>
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
													<tr>
														<td height="20" width="100%" id="bgdarkimg">
															<b><%=name.substring(1)%> <egui:intnl text="configmgmt.inventory.printers.Printer" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.printers.Count" />&nbsp;:&nbsp;<%=systemList.size()%>)</b>
														</td>
													</tr>
													<tr>
														<td width="100%" align="center" colspan="2">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
<%
				int count = kSet.length;
				int j=0;
				if (count <=3)
				{
					count = 3;
				}
				else if(count % 3 != 0)
				{
					count = count+3 - count % 3;
				}

				String printerNamePdf = name.substring(1) + " " + mappingInfo.getTextDescription("configmgmt.inventory.printers.Printer") + "  (" + mappingInfo.getTextDescription("configmgmt.inventory.printers.Count") + " : " + systemList.size() + ")";

				for (j=0; (j<kSet.length || j < count); j++)
				{
					if (j%3 == 0)
					{
						//pdf work
						aListData.add(printerNamePdf);
%>
																<tr>
<%
					}
					if ( j <kSet.length)
					{
						String systemName=(String)kSet[j];
						ArrayList valueList=(ArrayList)systemList.get(systemName);
						String type=(String)valueList.get(0);
						String defalt=(String)valueList.get(1);

						//pdf work
						if(defalt.equalsIgnoreCase("True"))
							aListData.add(systemName+" ("+type+")*");
						else aListData.add(systemName+" ("+type+")");
%>
																	<td width="30%" id="cell_bg1"> <a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"> &nbsp;<%=systemName%>&nbsp;(<%=type%>) </a>
<%
						if(defalt.equalsIgnoreCase("True"))
						{
%>
							<img src="../config/images/default_printer.gif" title='<egui:intnl text="configmgmt.inventory.printers.Default Printer" />' border="0" style= "vertical-align:bottom">
<%
						}
%>
																	</td>
<%
					}
					else
					{
						//pdf work
						aListData.add("");
%>
																	<td width="30%" id="cell_bg1">&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																</tr>
<%
					}
				}
%>
															</table>
														</td>
													</tr>
												</table>
												<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>
<%
			}
			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
		else //systemName && associated printer information
		{
			//pdf work

			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.printers.Distribution of Printers by System"));

			ArrayList aListData = new ArrayList();

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("Systems");
			aListColumnNames.add("Printer1");
			aListColumnNames.add("Printer2");

			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("");
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.printers.Configured Printers"));
			userColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);
			egTableAttributes.setColumnNames(userColumnNames);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.inventory.printers.Printers") + " (* - " + mappingInfo.getTextDescription("configmgmt.inventory.printers.Default Printer") + ")");
%>
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
													<tr>
														<td width="25%" height="20" align="left" class="body_text" id="tdbacklightcolor3"> &nbsp;<b><egui:intnl text="configmgmt.inventory.printers.System Name" /></b> </td>
														<td width="75%" height="20" align="center" class="body_text" id="tdbacklightcolor3"> <b><egui:intnl text="configmgmt.inventory.printers.Configured Printers" /></b> </td>
													</tr>
<%
			for(int n=0;n<contentList.size();n++)
			{
				String systemName=(String)contentList.get(n);
				Hashtable printerList=(Hashtable)data.get(systemName);
				if(printerList==null || printerList.size()==0)
					continue;
				Set setObject=printerList.keySet();
				Object[] kSet=setObject.toArray();
%>
													<tr>
														<td width="25%" id="cell_bg1" valign="top">
															<a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink">
																&nbsp;<%=systemName%>
															</a>
														</td>
														<td width="75%">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text">
<%
				int count = kSet.length;
				int j=0;

				for (j=0; (j < count); j++)
				{
%>
																<tr>
<%
					String printer=(String)kSet[j];
					ArrayList valueList=(ArrayList)printerList.get(printer);
					String type=(String)valueList.get(0);
					String defalt=(String)valueList.get(1);

					//pdf work
					if(defalt.equalsIgnoreCase("True"))
						aListData.add(printer.substring(1)+" ("+type+")*");
					else aListData.add(printer.substring(1)+" ("+type+")");
%>
																	<td width="50%" id="cell_bg2" style="padding:4px"><%=printer.substring(1)%>&nbsp;(<%=type%>)
<%
					if(defalt.equalsIgnoreCase("True"))
					{
%>
							<img src="../config/images/default_printer.gif"  style= "vertical-align:bottom" title='<egui:intnl text="configmgmt.inventory.printers.Default Printer" />' border="0">
<%
					}
%>
																	</td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
<%
			}
%>
												</table>
												<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>
<%
			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
%>
											</td>
										</tr>
									</table>
									<!-- </div> -->
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else 
	{
		if (ec_userOption != null && submitOrNot.equals("true") && isDisplay)
		{
%>
	<tr>
		<td height="180" id="blank">&nbsp;</td>
	</tr>
	<tr>
		<td align="center" valign="middle">
			<table border="0" align="center" width="100%"  height="100%">
				<tr>
					<td align="center">
						<table border="0" align="center" width="100%" class="body_text" >
							<tr>
								<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
							</tr>
							<tr>
								<td align="center"> <b><egui:intnl text="configmgmt.inventory.printers.No result found for the current selection" /></b> </td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else if (!submitOrNot.equals("true") || !isDisplay)
		{
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" height="100%">
				<tr>
					<td align="center">
						<table border="0" align="center" width="100%" class="body_text">
							<tr>
								<td align="center">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
		else
		{
%>
	<tr>
		<td align="center">
			<table border="0" align="center" width="100%" height="100%">
				<tr>
					<td align="center">
						<table border="0" align="center" width="100%" class="body_text">
							<tr>
								<td align="center">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
<%
		}
	}
%>
</table>
</form>
</body>
</html>



