<%
/*
	File				:	ecIPAddress.jsp
	Purpose				:	Display the static & dynamic ip address details
	Creation Date		:	11-02-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import="egurkha.config.EcIPAddressResult"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	//language support
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String request_from = request.getParameter("request_from");
	String id = request.getParameter("id");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String configSkin = user.getConfigSkin();
	String userName = (String)session.getAttribute("sess_auserid");
	EcUtils ecUtils=new EcUtils();
	EcPrintData printData=new EcPrintData();
	EcIPAddressResult result=(EcIPAddressResult)request.getAttribute("Result");
	String osName=result.getOsName();
	Vector osList=result.getOsList();
	Hashtable data=result.getResultData();
	String addressList[]={"NO","YES"};

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		osName = (String)scheduleDetails.get("osName");
		submitOrNot = "false";
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
%>

<html>
<head>
<!-- <link rel="stylesheet" href="../config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
	function showDetails()
	{
		var thisForm = document.IPAddress;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var osName= thisForm.osName.value;
		if(osName== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select an operating system" />');
			return;
		}
		else
		{
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
			}
			if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
			}

			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=IPAddress&osName="+osName+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
			document.IPAddress.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.IPAddress.secsubmt.disabled=true;
		}
	}

	function validateforSchedule()
	{
		var thisForm = document.IPAddress;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var osName= thisForm.osName.value;
		if(osName== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select an operating system" />');
			return false;
		}
	}

	function printData()
	{
<%
		if (data == null || data.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=IPAddress_Audit");
		printQS.append("&printPageTitle=DISTRIBUTION_REPORT_OF_STATIC_AND_DYNAMIC_IP_ADDRESS_ALLOCATED_SYSTEMS");
		printQS.append("&Page=AuditReport");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByIPAddress");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
}

	function mail()
	{
<%
		if (data == null || data .size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.IPAddress;
		var osName = thisForm.osName.value;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					osName = "";
				}
			}
			else
			{
				osName = "";
			}
		}

		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=IPAddress&osName="+osName+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.IPAddress;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=IPAddress";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onLoad="bigScreen();">
<form name="IPAddress" method="POST" style="margin:0px">
<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
<input type="hidden" name="ec_rtype" value="IPAddress">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">
<input type="hidden" name="isSubmit" value="true">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap height="24px">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.system.MANAGED SYSTEMS WITH STATIC AND DYNAMIC IP ADDRESS ALLOCATION" /></b>
					</td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"><col width="200"><col width="150"><col width="10"><col width="300"><col width="200">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr height="20">
											<td align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.system.Operating System" /></td>
											<td align="center">:</td>
											<td>
												<select name="osName">
<%//=ecUtils.fillSelectBox(osList,"config","",osName)%>
<%
	if (osList != null && !osList.isEmpty())
	{
		for(int i=0; i<osList.size(); i++)
		{
			String selected = "";
			String strOSName = (String)osList.get(i);
			if(strOSName != null && strOSName.equals(osName))
			{
				selected = "selected";
			}
%>
													<option value="<%=strOSName%>" <%=selected%>>
<%
			if (strOSName.equalsIgnoreCase("All"))
			{
%>
											<egui:intnl text="configmgmt.inventory.system.All" />
<%
			}
			else
			{
%>
														<%=strOSName%>
<%
			}
%>
													</option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.system.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td  align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
											<td align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20">
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>

											<td align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20"> 
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showDetails()"></td>
<%
	}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (data!=null && data.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		ArrayList fixedIPAddress=(ArrayList)data.get("NO");
		ArrayList dynamicIPAddress=(ArrayList)data.get("YES");
		//printData start here
		printData.setOsName(osName);
		printData.setMapData(data);
		//printData end here

		// Pdf work
		EgTable egTable1 = new EgTable();
		ArrayList aListData1 = new ArrayList();
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY IP ADDRESS ALLOCATION") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS BY IP ADDRESS ALLOCATION") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String reportSubTitle = "";
		reportAttributes.setSubTitle(reportSubTitle);
		reportAttributes.setReportName("SystemsByIpAddress");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);

		if (osName != null && !osName.equalsIgnoreCase("All"))
		{
%>
							<tr align="center">
								<td width="100%" align="center" valign="top">
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
										<tr>
											<td>
												<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
													<tr>
														<td id="bgdark" height="20" class="whitefont"  width="100%">&nbsp;<b><%=osName%></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
%>

							<tr>
								<td align="center" valign="top" height="100%">
								<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;">
									<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
<%
		if(osName!=null && osName.equalsIgnoreCase("All"))
		{
			String chartTitle =mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By IP Address Allocation");
			String sampleValue="";
			String barLabels="";
			int check=0;
			int maxCount=0;
			String yAxisMaxValue = " ";
			ArrayList aListCount = new ArrayList();
			for(int n=0;n<addressList.length;n++)
			{
				String addressSystem=(String)addressList[n];
				ArrayList systemList=(ArrayList)data.get(addressSystem);
				if(systemList==null || systemList.size()==0)
					continue;
				int size=systemList.size();
				
				if (!aListCount.contains(new Integer(size)))
				{
					aListCount.add(new Integer(size));
				}

				if(check==0)
				{
					if(addressSystem.equalsIgnoreCase("NO"))
						barLabels=mappingInfo.getTextDescription("configmgmt.inventory.system.Static");
					else
						barLabels=mappingInfo.getTextDescription("configmgmt.inventory.system.Dynamic");
					sampleValue=""+size;
				}
				else
				{
					barLabels=barLabels+","+mappingInfo.getTextDescription("configmgmt.inventory.system.Dynamic");
					sampleValue=sampleValue+","+size;
				}
				maxCount=Math.max(size,maxCount);
				check++;
			}

			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Column Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("xAxisName","IP Address Allocation");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","1");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("maxColWidth","40");
			mapChartAttributes.put("labelDisplay","ROTATE");
			mapChartAttributes.put("slantLabels","1");
			mapChartAttributes.put("placeValuesInside","1");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("columnLabels",barLabels);
			mapChartData.put("columnValues",sampleValue);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","false");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForColumnChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Column Chart Data ends

			printData.setBarLabel(barLabels);
			printData.setSampleValue(sampleValue);
			printData.setMaxRange(String.valueOf(maxCount));

			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
										<!-- Column3D chart starts-->
										<tr>
											<td colspan="2" align="center" width="100%">
											<b><%=chartTitle%></b>
											</td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column3D">
													<param name="movie" value="/final/FusionCharts/swf/Column3D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
													<param name="quality" value="high" />
													<param name="wmode" value="transparent" />
													<embed src="/final/FusionCharts/swf/Column3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" wmode="transparent" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartColumnIP3DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myColumnIP3DChartId" ) )
															FusionCharts( "myColumnIP3DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/Column3D.swf","myColumnIP3DChartId", "90%", "280","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartColumnIP3DContainer");
												</script>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
											<td colspan="2" align="center" width="100%">
											<b><%=chartTitle%></b>
											</td>
										</tr>
										<tr>
											<td align="center" width="100%" bgcolor="white" nowrap>
												<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column2D">
													<param name="movie" value="/final/FusionCharts/swf/Column2D.swf" />
													<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
													<param name="quality" value="high" />
													<param name="wmode" value="transparent" />
													<embed src="/final/FusionCharts/swf/Column2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" wmode="transparent" name="Column2D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
												</object> -->
												<div id="chartColumnIP2DContainer"  style="height:100%;"></div>
												<script type="text/javascript">
													if  ( FusionCharts( "myColumnIP2DChartId" ) )
															FusionCharts( "myColumnIP2DChartId" ).dispose();
													var myChart = new FusionCharts( "/final/FusionCharts/swf/Column2D.swf","myColumnIP2DChartId", "90%", "280","0","1");
													myChart.setXMLData("<%=xmlString%>");
													myChart.setTransparent(true);
													myChart.render("chartColumnIP2DContainer");
												</script>
											</td>
										</tr>
										<!-- Column3D chart ends-->
<%
			}

			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
			
			ArrayList aListData = new ArrayList();
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=IPADDRESS_ALLOCATION&chartType=bar&height=260&width=550&chartTitle="+EgURLEncoder.encode(chartTitle,"UTF-8")+"&sampleValues="+URLEncoder.encode(sampleValue)+"&barLabels="+URLEncoder.encode(barLabels)+"&barLabelAngle=360&range="+maxCount+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			
			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
		else
		{
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("");
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			String title = osName;
			egTableAttributes.setTitle(title);
			egTableAttributes.setStartX(0);
			egTableAttributes.setDataGrouping(true);
			egTableAttributes.setDataGroupingField(0);
			egTableAttributes.setColumnNames(userColumnNames);
			egTable1.setAttributes(egTableAttributes);
		}

		session.setAttribute("IpAddressAudit",printData);
		if(fixedIPAddress!=null && fixedIPAddress.size()>0)
		{
%>
										<tr>
											<td height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td valign="top">
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable" valign="top">
													<tr>
<%
			if(osName!=null && osName.equalsIgnoreCase("All"))
			{
%>
														<td id="bgdarkimg" width="100%" valign="top" height="20"><b><egui:intnl text="configmgmt.inventory.system.Static IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=fixedIPAddress.size()%>)</b></td>
<%
			}
			else
			{
%>
														<td id="tdbacklightcolor3" align="left" width="100%" height="15" valign="top">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Static IP address allocation" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=fixedIPAddress.size()%>)</b></td>
<%
			}
%>
													</tr>
<%
			Collections.sort(fixedIPAddress);
			int count = fixedIPAddress.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count +3- count % 3;
			}
%>
													<tr>
														<td width="99%">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
<%
			if (fixedIPAddress!= null)
			{
				// pdf work
				ArrayList aListData = new ArrayList();

				for (j=0; (j<fixedIPAddress.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
						//pdf work
						aListData1.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Static IP address allocation")+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+fixedIPAddress.size()+")");
%>
																<tr>
<%
					}
					if ( j <fixedIPAddress.size())
					{
						String systemName=(String)fixedIPAddress.get(j);

						// pdf work
						aListData.add(systemName);
						aListData1.add(systemName);
%>
																	<td width="30%" id="cell_bg1"><a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink">&nbsp;<%=systemName%></a></td>
<%
					}
					else
					{
						// pdf work
						aListData.add("");
						aListData1.add("");
%>
																	<td width="30%" id="cell_bg1">&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																</tr>
<%
					}
				}

				// pdf work
				if(osName!=null && osName.equalsIgnoreCase("All"))
				{
					ArrayList aListColumnNames = new ArrayList();
					aListColumnNames.add("C1");
					aListColumnNames.add("C2");
					aListColumnNames.add("C3");

					ArrayList userColumnNames = new ArrayList();
					userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
					userColumnNames.add("");
					userColumnNames.add("");

					EgTableAttributes egTableAttributes = new EgTableAttributes();
					String title = mappingInfo.getTextDescription("configmgmt.inventory.system.Static IP address allocation")+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+fixedIPAddress.size()+")";
					egTableAttributes.setTitle(title);
					egTableAttributes.setStartX(0);
					egTableAttributes.setColumnNames(userColumnNames);

					EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

					EgTable egTable = new EgTable();
					egTable.setModel(egTableModel);
					egTable.setAttributes(egTableAttributes);

					aListPdfData.add(egTable);
				}
			}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="5" id="blank">&nbsp;</td>
										</tr>
<%
		}
		
		if(dynamicIPAddress!=null && dynamicIPAddress.size()>0)
		{
%>
										<tr>
											<td  height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td>
												<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
													<tr>
<%
			if(osName!=null && osName.equalsIgnoreCase("All"))
			{
%>
														<td id="bgdarkimg" width="100%"><b><egui:intnl text="configmgmt.inventory.system.Dynamic IP address allocation" />&nbsp;&nbsp; (<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp; <%=dynamicIPAddress.size()%>)</b> </td>
<%
			}
			else
			{
%>
														<td id="tdbacklightcolor3" height="20" align="left" width="100%" height="15">&nbsp;<b><egui:intnl text="configmgmt.inventory.system.Dynamic IP address allocation" />&nbsp;&nbsp; (<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=dynamicIPAddress.size()%>)</b></td>
<%
			}
%>
													</tr>
<%
			Collections.sort(dynamicIPAddress);
			int count = dynamicIPAddress.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count +3- count % 3;
			}
%>
													<tr>
														<td width="100%">
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
<%
			if (dynamicIPAddress!= null)
			{
				// pdf work
				ArrayList aListData = new ArrayList();

				for (j=0; (j<dynamicIPAddress.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
						// pdf work
						aListData1.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Dynamic IP address allocation")+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+dynamicIPAddress.size()+")");
%>
																<tr>
<%
					}
					if ( j <dynamicIPAddress.size())
					{
						String systemName=(String)dynamicIPAddress.get(j);

						// pdf work
						aListData.add(systemName);
						aListData1.add(systemName);
%>
																	<td width="30%" id="cell_bg1"><a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"> &nbsp;<%=systemName%> </a></td>
<%
					}
					else
					{
						// pdf work
						aListData.add("");
						aListData1.add("");
%>
																	<td width="30%" id="cell_bg1">&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																</tr>
<%
					}
				}
				
				// pdf work
				if(osName!=null && osName.equalsIgnoreCase("All"))
				{
					ArrayList aListColumnNames = new ArrayList();
					aListColumnNames.add("C1");
					aListColumnNames.add("C2");
					aListColumnNames.add("C3");

					ArrayList userColumnNames = new ArrayList();
					userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
					userColumnNames.add("");
					userColumnNames.add("");

					EgTableAttributes egTableAttributes = new EgTableAttributes();
					String title = mappingInfo.getTextDescription("configmgmt.inventory.system.Dynamic IP address allocation")+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+dynamicIPAddress.size()+")";
					egTableAttributes.setTitle(title);
					egTableAttributes.setStartX(0);
					egTableAttributes.setColumnNames(userColumnNames);

					EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

					EgTable egTable = new EgTable();
					egTable.setModel(egTableModel);
					egTable.setAttributes(egTableAttributes);

					aListPdfData.add(egTable);
				}
			}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td  height="5" id="blank">&nbsp;</td>
										</tr>
<%
		}
%>
									</table>
									</div>
								</td>
							</tr>
<%
		//pdf work
		if(osName!=null && !osName.equalsIgnoreCase("All"))
		{
			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");
			aListColumnNames.add("C4");

			EgTableModel egTableModel = new EgTableModel(aListData1,aListColumnNames);

			egTable1.setModel(egTableModel);
			aListPdfData.add(egTable1);
		}

		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if(osName != null && !osName.equals("-1") && submitOrNot.equals("true") && isDisplay)
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"><img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.inventory.system.No result found for the current selection" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else if (!submitOrNot.equals("true") || !isDisplay)
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



