<%
/*
	File				:	ecDefaultGateway.jsp
	Purpose				:	Display the gateway ip address details
	Creation Date		:	13-02-2007
	Author				:	Balasigamani
	UI Design			:	Krishnamurthi
	UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import ="egurkha.config.EcUtils"%>
<%@ page import="egurkha.config.EcDefaultGatewayResult"%>
<%@ page import="egurkha.config.EcPrintData"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	//language support
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");

	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String configSkin = user.getConfigSkin();
	String userName = (String)session.getAttribute("sess_auserid");
	EcUtils ecUtils=new EcUtils();
	EcPrintData printData=new EcPrintData();
	EcDefaultGatewayResult result=(EcDefaultGatewayResult)request.getAttribute("Result");
	String ipAddress=result.getIPAddressName();
	Vector ipList=result.getIPAddressList();
	Hashtable data=result.getResultData();
	String request_from = request.getParameter("request_from");
	String id = request.getParameter("id");
	String submitOrNot = (String) request.getAttribute("isSubmit");

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	ArrayList displayListData=new ArrayList();
	if(data!=null && data.size()>0)
	{
		Iterator iterat=data.keySet().iterator();
		while(iterat.hasNext())
		{
			String ip=(String)iterat.next();
			displayListData.add(ip);
		}
		Collections.sort(displayListData);
	}

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
		ipAddress = (String)scheduleDetails.get("ipAddress");
		submitOrNot = "false";
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
%>

<html>
<head>
<egui:skin ui="config"/>
<script language="JavaScript1.2" type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2">
	
	function showDetails()
	{
		var thisForm = document.Gateway;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var ipAddress= thisForm.ipAddress.value;
		if(ipAddress== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select IP address" />');
			return;
		}
		else
		{
			var tempCriteriaPrevious = "";
			var tempUserOptionPrevious = "";

			if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
			{
				tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
			}
			if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
			{
				tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
			}

			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=DefaultGateway&ipAddress="+ipAddress+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious);
			document.Gateway.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.Gateway.secsubmt.disabled=true;
		}
	}

	function validateforSchedule()
	{
		var thisForm = document.Gateway;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var ipAddress= thisForm.ipAddress.value;
		if(ipAddress== -1)
		{
			alert('<egui:intnl text="configmgmt.inventory.system.Please select IP address" />');
			return false;
		}
	}

	function printData()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=Gateway_Audit");
		printQS.append("&printPageTitle=DISTRIBUTION_REPORT_OF_MANAGED_SYSTEMS_CONFIGURED_WITH_NETWORK_GATEWAY_ROUTERS");
		printQS.append("&Page=AuditReport");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(data == null || data.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByDefaultGateway");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (data == null || data.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.Gateway;
		var ipAddress= thisForm.ipAddress.value;
		var tempCriteria = "";
		var tempUserOption = "";
		var tempCriteriaPrevious = "";
		var tempUserOptionPrevious = "";

		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}

		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					ipAddress = "All";
				}
			}
			else
			{
					ipAddress = "All";
			}
		}

		window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=DefaultGateway&ipAddress="+ipAddress+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>";
	}

	function csv()
	{
		thisForm = document.forms[0];
<%
		if (data == null || data.size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
		var checkFlag = validateforSchedule();
		if(checkFlag == false) return;
		var thisForm = document.Gateway;
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=DefaultGateway";
<%
			}
%>
		}
		else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

</script>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" >
<form name="Gateway" method="POST" style="margin:0px">
<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%">
<input type="hidden" name="ec_rtype" value="DefaultGateway">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="97%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.inventory.system.MANAGED SYSTEMS CONFIGURED WITH NETWORK GATEWAY ROUTERS" /></b>
					</td>
					<td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
					<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="250"><col width="150"><col width="10"><col width="150"><col width="250">
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right" ><egui:intnl text="configmgmt.inventory.system.Gateway IP Address" />
											<td align="center">:</td>
											<td align="left">
												<select name="ipAddress" style="width:150px">
<%//=ecUtils.fillSelectBox(ipList,"",ipAddress)%>
<%
	if (ipList != null && !ipList.isEmpty())
	{
		for(int i=0; i<ipList.size(); i++)
		{
			String selected = "";
			String strIP = (String)ipList.get(i);
			if(strIP != null && strIP.equals(ipAddress))
			{
				selected = "selected";
			}
%>
													<option value="<%=strIP%>" <%=selected%>>
<%
			if (strIP.equalsIgnoreCase("All"))
			{
%>
											<egui:intnl text="configmgmt.inventory.system.All" />
<%
			}
			else
			{
%>
														<%=strIP%>
<%
			}
%>
													</option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.system.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="center" >&nbsp;</td>
										</tr>
										<tr>
											<td colspan="5" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
											<td align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20">
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>
											<td  align="center">&nbsp;</td>
											<td align="center" colspan="3" valign="middle" height="20"> 
											<input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showDetails()">
											</td>
<%
	}
%>
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" ></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="4" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
					<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (data!=null && data.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		printData.setRangeOption(ipAddress);
		printData.setListData(displayListData);
		printData.setMapData(data);

		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();

		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS CONFIGURED WITH NETWORK GATEWAY ROUTERS") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.DISTRIBUTION REPORT OF MANAGED SYSTEMS CONFIGURED WITH NETWORK GATEWAY ROUTERS") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String reportSubTitle = "";
		reportAttributes.setSubTitle(reportSubTitle);

		reportAttributes.setReportName("SystemsWithGateway");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);

		pdfData.setAttributes(reportAttributes);
%>
							<tr>
								<td align="center" valign="top">
									<table width="100%" border="0" cellpadding="0" cellspacing="0">
										<tr>
											<td  height="5" id="blank">&nbsp;</td>
										</tr>
										<tr align="center">
											<td width="100%" align="center" valign="top">
												<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
<%
		if(ipAddress!=null && ipAddress.equalsIgnoreCase("All"))
		{
			String sampleValue="";
			String barLabels="";
			String barLabelAngle="360";
			int maxCount=0;
			String yAxisMaxValue = " ";
			ArrayList aListCount = new ArrayList();
			for(int n=0;n<displayListData.size();n++)
			{
				String ip=(String)displayListData.get(n);
				ArrayList systemList=(ArrayList)data.get(ip);
				if(systemList==null || systemList.size()==0)
					continue;
				int size=systemList.size();

				if (!aListCount.contains(new Integer(size)))
				{
					aListCount.add(new Integer(size));
				}

				if(n==0)
				{
					barLabels=ip;
					sampleValue=""+size;
				}
				else
				{
					barLabels=barLabels+","+ip;
					sampleValue=sampleValue+","+size;
				}
				maxCount=Math.max(size,maxCount);
			}

			boolean flagEqualsOne = true;
			for (int i=1; i<aListCount.size(); i++)
			{
				Integer count_Value = (Integer)aListCount.get(i);
				if (count_Value.intValue() > 1)
				{
					flagEqualsOne = false;
					break;
				}
			}
			if (flagEqualsOne)
			{
				yAxisMaxValue = "5";
			}
			else
			{
				yAxisMaxValue = "0";
			}

			//Fusion Column Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("yAxisName","Number of systems");
			mapChartAttributes.put("xAxisName","Gateway IP Address");
			mapChartAttributes.put("showToolTip","1");
			mapChartAttributes.put("showValues","1");
			mapChartAttributes.put("showBorder","0");
			mapChartAttributes.put("showShadow","1");
			mapChartAttributes.put("alpha","0");
			mapChartAttributes.put("canvasBgColor","F2F2F2");
			mapChartAttributes.put("canvasBgAlpha","60");
			mapChartAttributes.put("canvasBorderColor","000000");
			mapChartAttributes.put("canvasBorderThickness","1");
			mapChartAttributes.put("canvasBorderAlpha","30");
			mapChartAttributes.put("maxColWidth","40");
			mapChartAttributes.put("labelDisplay","ROTATE");
			mapChartAttributes.put("slantLabels","1");
			mapChartAttributes.put("placeValuesInside","1");
			mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("columnLabels",barLabels);
			mapChartData.put("columnValues",sampleValue);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showColors","false");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForColumnChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Column Chart Data ends

			if(displayListData.size()>3)
				barLabelAngle="310";

			printData.setBarLabel(barLabels);
			printData.setSampleValue(sampleValue);
			printData.setSampleAxisLabel(barLabelAngle);//using this method for barLabelAngle
			printData.setMaxRange(String.valueOf(maxCount));

			String chartTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.Distribution of Systems By Gateway IP Address");
%>
													<tr>
														<td>
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
																<tr>
																	<td height="5" id="blank">&nbsp;</td>
																</tr>
<%
			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
																<!-- Column3D chart starts-->
																<tr>
																	<td align="center" width="100%"><b><%=chartTitle%></b></td>
																</tr>
																<tr>
																	<td align="center" width="100%" bgcolor="white" nowrap>
																		<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column3D">
																			<param name="movie" value="/final/FusionCharts/swf/Column3D.swf" />
																			<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
																			<param name="quality" value="high" />
																			<embed src="/final/FusionCharts/swf/Column3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="Column3D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																		</object> -->
																		<div id="chartColumnGateway3DContainer"  style="height:100%;"></div>
																		<script type="text/javascript">
																			if  ( FusionCharts( "myColumnGateway3DChartId" ) )
																					FusionCharts( "myColumnGateway3DChartId" ).dispose();
																			var myChart = new FusionCharts( "/final/FusionCharts/swf/Column3D.swf","myColumnGateway3DChartId", "90%", "280","0","1");
																			myChart.setXMLData("<%=xmlString%>");
																			myChart.setTransparent(true);
																			myChart.render("chartColumnGateway3DContainer");
																		</script>
																	</td>
																</tr>
<%
			}
			else
			{
%>
																<tr>
																	<td align="center" width="100%"><b><%=chartTitle%></b></td>
																</tr>
																<tr>
																	<td align="center" width="100%" bgcolor="white" nowrap>
																		<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="280" id="Column2D">
																			<param name="movie" value="/final/FusionCharts/swf/Column2D.swf" />
																			<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" />
																			<param name="quality" value="high" />
																			<embed src="/final/FusionCharts/swf/Column2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=280" quality="high" width="90%" height="280" name="Column2D" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																		</object> -->
																		<div id="chartColumnGateway2DContainer"  style="height:100%;"></div>
																		<script type="text/javascript">
																			if  ( FusionCharts( "myColumnGateway2DChartId" ) )
																					FusionCharts( "myColumnGateway2DChartId" ).dispose();
																			var myChart = new FusionCharts( "/final/FusionCharts/swf/Column2D.swf","myColumnGateway2DChartId", "90%", "280","0","1");
																			myChart.setXMLData("<%=xmlString%>");
																			myChart.setTransparent(true);
																			myChart.render("chartColumnGateway2DContainer");
																		</script>
																	</td>
																</tr>
																<!-- Column3D chart ends-->
<%
			}
%>
																<tr>
																	<td height="5" id="blank">&nbsp;</td>
																</tr>
															</table>
														</td>
													</tr>
<%
			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
				
			ArrayList aListData = new ArrayList();

			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=GATEWAY_REPORT&chartType=bar&height=260&width=550&chartTitle="+EgURLEncoder.encode(chartTitle,"UTF-8")+"&sampleValues="+URLEncoder.encode(sampleValue)+"&barLabels="+URLEncoder.encode(barLabels)+"&barLabelAngle="+barLabelAngle+"&range="+maxCount+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
%>
													<tr>
														<td>
															<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center">
<%
		session.setAttribute("defaultGateway_Audit",printData);
		for(int n=0;n<displayListData.size();n++)
		{
			String gatwayIPAddress=(String)displayListData.get(n);
			ArrayList ip=(ArrayList)data.get(gatwayIPAddress);
			if(ip==null || ip.size()==0)
				continue;

			//pdf work
			ArrayList aListData = new ArrayList();

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("C1");
			aListColumnNames.add("C2");
			aListColumnNames.add("C3");

			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.system.Systems"));
			userColumnNames.add("");
			userColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);
			String tableTitle = mappingInfo.getTextDescription("configmgmt.inventory.system.Gateway")+" "+gatwayIPAddress+"  ("+mappingInfo.getTextDescription("configmgmt.inventory.system.Count")+" : "+ip.size()+")";
			egTableAttributes.setTitle(tableTitle);
			egTableAttributes.setColumnNames(userColumnNames);
%>
																<tr>
																	<td>
																		<table width="99%" border="0" cellpadding="0" cellspacing="0" class="body_text" align="center" id="bottomtable">
																			<tr>
																				<td id="bgdarkimg" width="100%" height="20"><b><egui:intnl text="configmgmt.inventory.system.Gateway" />&nbsp;<%=gatwayIPAddress%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.system.Count" />&nbsp;:&nbsp;<%=ip.size()%>)</b></td>
																			</tr>
<%
			int count = ip.size();
			int j=0;
			if (count <=3)
			{
				count = 3;
			}
			else if(count % 3 != 0)
			{
				count = count + 3 - count % 3;
			}
%>
																			<tr>
																				<td width="100%">
																					<table width="100%" border="0" cellpadding="0" cellspacing="0" class="body_text" >
<%
			if (ip!= null)
			{
				for (j=0; (j<ip.size() || j < count); j++)
				{
					if (j%3 == 0)
					{
%>
																						<tr>
<%
					}
					if ( j <ip.size())
					{
						String systemName=(String)ip.get(j);

						//pdf work
						aListData.add(systemName);
%>
																							<td width="30%" id="cell_bg1"> <a href="../servlet/com.eg.EcConfigurationServlet?request_from=HomePage&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink"> &nbsp;<%=systemName%></a>
																							</td>
<%
					}
					else
					{
						//pdf work
						aListData.add("");
%>
																							<td width="30%" id="cell_bg1">&nbsp;</td>
<%
					}
					if (j%3 == 2)
					{
%>
																						</tr>
<%
					}
				}
			}
%>
																					</table>
																				</td>
																			</tr>
																		</table>
																	</td>
																</tr>
																<tr>
																	<td height="10" id="blank">&nbsp;</td>
																</tr>
<%
			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else if(ipAddress != null && !ipAddress.equals("-1") && submitOrNot.equals("true") && isDisplay)
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"><img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.inventory.system.No result found for the current selection" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else if (!submitOrNot.equals("true") || !isDisplay)
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
						</div>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



