<%
/*
	File			:	ecDaywiseChangeDistributionSummary.jsp
	Purpose			:	Display the list of changes daywise for the selected component type
	Creation Date	:	26-01-2009
	Author			:	Krishnamurthi
	UI Design		:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.config.TimeLineBean"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "egurkha.config.*"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] duration = {"1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};

	String[] criterias = {"Zone","Service","Segment","Component"};

	private TreeMap getTreeMap(ArrayList al_components)
	{
		TreeMap tmap = null;
		if (al_components != null && !al_components.isEmpty())
		{
			tmap = new TreeMap();
			for(int i=0;i<al_components.size();i++)
			{
				String s_component = (String)al_components.get(i);
				String component_type = s_component.substring(s_component.lastIndexOf(":")+1);
				String component_name;

				if (component_type.equals("Oracle_server"))
				{
					StringTokenizer strTokens = new StringTokenizer(s_component,":");
					component_name = strTokens.nextToken() + ":" + strTokens.nextToken();
					component_type = strTokens.nextToken() + ":" + strTokens.nextToken();
				}
				else
					component_name = s_component.substring(0,s_component.lastIndexOf(":"));

				if (tmap.containsKey(component_type))
				{
					ArrayList al_temp = (ArrayList)tmap.get(component_type);
					al_temp.add(component_name);
				}
				else
				{
					ArrayList al_temp = new ArrayList();
					al_temp.add(component_name);
					tmap.put(component_type,al_temp);
				}
			}
		}
		return tmap;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires",-1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgDateInfo egDateInfo = new EgDateInfo();
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	EcUtils ecUtils = new EcUtils();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
	String configSkin = user.getConfigSkin();
	String userName = user.getLoginID();

	String componentType = request.getParameter("componentType");
	String strRequestFrom = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
	{
		componentType = (String)scheduleDetails.get("componentType");
	}
	String selectionOption = "";
	if (componentType == null || componentType.equalsIgnoreCase("All"))
	{
		componentType = "All";
		selectionOption = "All Components";
	}
	else
	{
		selectionOption = "Component Type";
	}

	String defaultDuration = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","DaywiseChangeDistribution");
	String selectedDuration = request.getParameter("duration");
	if (selectedDuration == null)
	{
		Map dashboardDaySetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
		String daySetting = (String)dashboardDaySetting.get(EgConfigConstants.DAYWISE_CHANGE_DISTRIBUTION);
		if (daySetting == null)
		{
			selectedDuration = defaultDuration;
		}
		else
		{
			selectedDuration = daySetting;
		}
	}

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","BarChartColor");
	String barColorCode = (String)dashboardSetting.get(EgConfigConstants.BAR_COLOR);
	if (barColorCode != null)
	{
		if (barColorCode.indexOf("#") == -1)
			barColor = "#" + barColorCode;
		else
			barColor = barColorCode;
	}

	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	ArrayList aListComponentTypes = new ArrayList();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	for(int i=0;i<aListAssociatedComponents.size();i++)
	{
		String s_component = (String)aListAssociatedComponents.get(i);
		String component_type = s_component.substring(0,s_component.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!aListComponentTypes.contains(component_type))
		{
			aListComponentTypes.add(component_type);
		}
	}
	if (aListComponentTypes.contains("Host_system"))
	{
		aListComponentTypes.remove("Host_system");
	}

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConvertertemp = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConvertertemp.getDateTime();
	/* Added by Prakash.K Ends */

	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("Default"))
	{
		userDateFormat = currentDateFormat;
	}

	String tempStartDate = "";
	String startHour = "";
	String startMinute = "";
	String tempEndDate = "";
	String endHour = "";
	String endMinute = "";

	String actualStartDate = "";
	String actualEndDate = "";

	String str_ec_timeline = request.getParameter("ec_timeline");
	String str_ec_prevtimeline = request.getParameter("ec_stdate");

	if (scheduleDetails != null && strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		str_ec_timeline = (String)scheduleDetails.get("ec_timeline");
		str_ec_prevtimeline = (String)scheduleDetails.get("ec_stdate");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (str_ec_timeline == null)
	{
		str_ec_timeline = selectedDuration;
	}

	Map paramMapTemp = new HashMap();
	paramMapTemp.put("ec_timeline",new String[]{str_ec_timeline});
	paramMapTemp.put("ec_prevtimeline",new String[]{str_ec_timeline});
	TimeLineBean timeLineBean = new TimeLineBean(paramMapTemp);

	String strStartDate = timeLineBean.getStartDate();
	String strEndDate = timeLineBean.getEndDate();
	startHour = timeLineBean.getStartHour();
	endHour = timeLineBean.getEndHour();
	startMinute = timeLineBean.getStartMinute();
	endMinute = timeLineBean.getEndMinute();

	if (!str_ec_timeline.equalsIgnoreCase("Any") && scheduleDetails == null)
	{
		if (strStartDate != null && strEndDate != null)
		{
			actualStartDate = new String(strStartDate);
			actualEndDate = new String(strEndDate);

			tempStartDate = DateUtil.changeDateFormat(strStartDate,"MM/dd/yyyy",currentDateFormat);
			tempEndDate = DateUtil.changeDateFormat(strEndDate,"MM/dd/yyyy",currentDateFormat);
		}
	}
	else if (scheduleDetails == null)
	{
		String ec_st_date = request.getParameter("ec_stdate_h");
		String ec_st_hr = request.getParameter("ec_sthr_h");
		String ec_start_min = request.getParameter("ec_startmin_h");
		String ec_end_date = request.getParameter("ec_enddate_h");
		String ec_end_hr = request.getParameter("ec_endhr_h");
		String ec_end_min = request.getParameter("ec_endmin_h");

		if (ec_st_hr == null)
		{
			ec_st_hr = startHour;
		}
		if (ec_start_min == null)
		{
			ec_start_min = startMinute;
		}
		if (ec_end_hr == null)
		{
			ec_end_hr = endHour;
		}
		if (ec_end_min == null)
		{
			ec_end_min = endMinute;
		}

		tempStartDate = new String(ec_st_date);
		tempEndDate = new String(ec_end_date);
		startHour = new String(ec_st_hr);
		endHour = new String(ec_end_hr);
		startMinute = new String(ec_start_min);
		endMinute = new String(ec_end_min);

		actualStartDate = new String(DateUtil.changeDateFormat(ec_st_date,currentDateFormat,"MM/dd/yyyy"));
		actualEndDate = new String(DateUtil.changeDateFormat(ec_end_date,currentDateFormat,"MM/dd/yyyy"));
	}

	if (scheduleDetails != null && strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
	{
		str_ec_timeline = (String)scheduleDetails.get("ec_timeline");
		submitOrNot = "false";
		if (!str_ec_timeline.equalsIgnoreCase("Any"))
		{
			if (strStartDate != null && strEndDate != null)
			{
				actualStartDate = new String(strStartDate);
				actualEndDate = new String(strEndDate);

				tempStartDate = DateUtil.changeDateFormat(strStartDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(strEndDate,"MM/dd/yyyy",currentDateFormat);
			}
		}
		else
		{
			String ec_st_date = (String)scheduleDetails.get("ec_stdate_h");
			String ec_st_hr = (String)scheduleDetails.get("ec_sthr_h");
			String ec_start_min = (String)scheduleDetails.get("ec_startmin_h");
			String ec_end_date = (String)scheduleDetails.get("ec_enddate_h");
			String ec_end_hr = (String)scheduleDetails.get("ec_endhr_h");
			String ec_end_min = (String)scheduleDetails.get("ec_endmin_h");

			if (ec_st_hr == null)
			{
				ec_st_hr = startHour;
			}
			if (ec_start_min == null)
			{
				ec_start_min = startMinute;
			}
			if (ec_end_hr == null)
			{
				ec_end_hr = endHour;
			}
			if (ec_end_min == null)
			{
				ec_end_min = endMinute;
			}

			tempStartDate = new String(ec_st_date);
			tempEndDate = new String(ec_end_date);
			startHour = new String(ec_st_hr);
			endHour = new String(ec_end_hr);
			startMinute = new String(ec_start_min);
			endMinute = new String(ec_end_min);

			actualStartDate = new String(DateUtil.changeDateFormat(ec_st_date,currentDateFormat,"MM/dd/yyyy"));
			actualEndDate = new String(DateUtil.changeDateFormat(ec_end_date,currentDateFormat,"MM/dd/yyyy"));
		}
	}

	boolean isDisplay = true;
	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	String id = request.getParameter("id");
	String strRequestStart = request.getParameter("request_start");

	if (scheduleDetails == null && strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}
	if (scheduleDetails != null && strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}
	if (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}
	if (strRequestStart == null)
	{
		strRequestStart = request.getParameter("request_from");
	}

	String strChangeType = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","ShowChanges");

	TreeMap tmap_changeConfigDetails = null;
	if (strRequestFrom == null || !strRequestFrom.equalsIgnoreCase("Timeline"))
	{
		//Parameters - Start
		String option1[] = new String[]{selectionOption};
		String timeline[] = new String[]{"Any"};
		String prevtimeline[] = new String[]{"Any"};

		String ec_stdate[] = new String[]{tempStartDate};
		String ec_sthr[] =  new String[]{startHour};
		String ec_startmin[] =  new String[]{startMinute};
		String ec_enddate[] =  new String[]{tempEndDate};
		String ec_endhr[] =  new String[]{endHour};
		String ec_endmin[] =  new String[]{endMinute};

		if (strChangeType == null || strChangeType.length() == 0)
		{
			strChangeType = "All";
		}
		if (strChangeType.equalsIgnoreCase("Recent"))
		{
			strChangeType = "Latest";
		}
		else
		{
			strChangeType = "All";
		}

		String changeType[] = new String[]{strChangeType};
		String viewChange[] = new String[]{"byDate"};

		Map params = new HashMap();
		params.put("ec_option1",option1);
		params.put("ec_timeline",timeline);
		params.put("ec_prevtimeline",prevtimeline);
		params.put("ec_stdate_h",ec_stdate);
		params.put("ec_sthr_h",ec_sthr);
		params.put("ec_startmin_h",ec_startmin);
		params.put("ec_enddate_h",ec_enddate);
		params.put("ec_endhr_h",ec_endhr);
		params.put("ec_endmin_h",ec_endmin);
		params.put("ec_changetype",changeType);
		params.put("ec_viewchange",viewChange);
		params.put("user_language",new String[]{userLanguage});
		//Parameters - End

		ArrayList al_temp = new ArrayList();
		ArrayList al_components = new ArrayList();
		if (selectionOption.equals("Component Type"))
		{
			ArrayList aListTemp = user.getServersForType(componentType);
			for (int k=0;k<aListTemp.size();k++)
			{
				String strComp = (String)aListTemp.get(k);
				if (!aListAssociatedComponents.contains(strComp)) continue;
				al_temp.add(strComp);
			}
		}
		else
		{
			al_temp.addAll(aListAssociatedComponents);
		}
		for(int i=0;i<al_temp.size();i++)
		{
			String s_component = (String)al_temp.get(i);
			String component_type = s_component.substring(0,s_component.indexOf(":"));
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if(!isConfigTestEnabled)
				continue;
			String component_name = s_component.substring(s_component.indexOf(":")+1);
			al_components.add(component_name+":"+component_type);
		}
		TreeMap tmap_components = getTreeMap(al_components);

		Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");

		EcChangeConfigurationBean ccbean = new EcChangeConfigurationBean(params,hasAllComponentAccess);
		ccbean.setTreeMap(tmap_components);
		ccbean.setHostAgentsMapping(hostAgentsMapping);
		tmap_changeConfigDetails = ccbean.getChangeConfigurationData();
	}

	String tempStartHour = "";
	if (startHour != null)
	{
		if (startHour.length() == 1)
			tempStartHour = "0" + startHour;
		else
			tempStartHour = startHour;
	}

	String tempStartMinute = "";
	if (startMinute != null)
	{
		if (startMinute.length() == 1)
			tempStartMinute = "0" + startMinute;
		else
			tempStartMinute = startMinute;
	}

	String tempEndHour = "";
	if (endHour != null)
	{
		if (endHour.length() == 1)
			tempEndHour = "0" + endHour;
		else
			tempEndHour = endHour;
	}

	String tempEndMinute = "";
	if (endMinute != null)
	{
		if (endMinute.length() == 1)
			tempEndMinute = "0" + endMinute;
		else
			tempEndMinute = endMinute;
	}

	String strDateDiff = DateUtil.getDateDifference(actualStartDate+" "+startHour+":"+startMinute,actualEndDate+" "+endHour+":"+endMinute,"days");

	if (strRequestFrom == null)
	{
		strRequestFrom = request.getParameter("request_start");
	}

	String sampleValues = "";
	String barLabels = "";
	int maxCount = 0;
	String chartTitle = "";

	String linkUrl = " ";
	ArrayList aListLinks = new ArrayList();
	ArrayList aListColors = new ArrayList();
	String aListLinkStr = " ";
	String aListColorStr = " ";
	String yAxisMaxValue = " ";
	ArrayList aListCount = new ArrayList();

	String format = DateUtil.getDateFormatForTimeLinechart(userDateFormat);
	String sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Days") + " (" + format + ")";

	TreeMap tmapStart = new TreeMap();
	TreeMap tmapEnd = new TreeMap();

	ArrayList aListDates = new ArrayList();
	ArrayList aListChangeCount = new ArrayList();

	ArrayList aListChangesDatewiseTemp = null;
	ArrayList aListData = new ArrayList();
	ArrayList aListChangesDatewise = new ArrayList();
	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
	{
		aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

		chartTitle = mappingInfo.getTextDescription("configmgmt.dashboard.Total Changes") + " : " + aListChangesDatewise.size();

		TreeMap tmapChanges = new TreeMap();
		if (str_ec_timeline.equalsIgnoreCase("1 day") || 
			strDateDiff.equals("0") || 
			(str_ec_timeline.equalsIgnoreCase("Any") && strDateDiff.equals("1")))
		{
			String sDate = new String(actualStartDate);
			String eDate = new String(actualEndDate);

			if (!sDate.equals(eDate))
			{
				for (int x=0; x<aListChangesDatewise.size(); x++)
				{
					ArrayList aList_A = (ArrayList)aListChangesDatewise.get(x);

					String strDateTime = (String)aList_A.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(" "));
					String strTime = strDateTime.substring(strDateTime.indexOf(" ")+1);
					String strHour = strTime.substring(0,strTime.indexOf(":"));

					if (sDate.equals(strDate))
					{
						Integer hourObject = new Integer(strHour.trim());
						Integer intObject = (Integer)tmapStart.get(hourObject);
						if (intObject == null)
						{
							tmapStart.put(hourObject,new Integer(1));
						}
						else
						{
							int value = intObject.intValue() + 1;
							tmapStart.put(hourObject,new Integer(value));
						}
					}
					else
					{
						Integer hourObject = new Integer(strHour.trim());
						Integer intObject = (Integer)tmapEnd.get(hourObject);
						if (intObject == null)
						{
							tmapEnd.put(hourObject,new Integer(1));
						}
						else
						{
							int value = intObject.intValue() + 1;
							tmapEnd.put(hourObject,new Integer(value));
						}
					}
				}
			}
			else
			{
				for (int x=0; x<aListChangesDatewise.size(); x++)
				{
					ArrayList aList_A = (ArrayList)aListChangesDatewise.get(x);

					String strDateTime = (String)aList_A.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(" "));
					String strTime = strDateTime.substring(strDateTime.indexOf(" ")+1);
					String strHour = strTime.substring(0,strTime.indexOf(":"));

					Integer hourObject = new Integer(strHour.trim());
					Integer intObject = (Integer)tmapEnd.get(hourObject);
					if (intObject == null)
					{
						tmapEnd.put(hourObject,new Integer(1));
					}
					else
					{
						int value = intObject.intValue() + 1;
						tmapEnd.put(hourObject,new Integer(value));
					}
				}
			}

			if (!sDate.equals(eDate))
			{
				for (int i=Integer.parseInt(startHour);i<=23;i++)
				{
					Integer key_hour = new Integer(i);
					Integer changeCount = (Integer)tmapStart.get(key_hour);

					if (!aListCount.contains(changeCount))
					{
						aListCount.add(changeCount);
					}

					if (changeCount != null)
					{
						linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDS&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline+"&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(sDate)+"&ec_viewchange=byDate&timeZone="+key_hour+"&selectedDuration="+selectedDuration+"&request_start=DCDS&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
					}
					aListLinks.add(linkUrl);
					aListColors.add(barColor);

					if (changeCount == null)
					{
						sampleValues = sampleValues + ",x";
					}
					else
					{
						sampleValues = sampleValues + "," + changeCount.intValue();
					}
					barLabels = barLabels + "," + key_hour.intValue();

					aListData.add(key_hour.toString());
					if (changeCount == null)
					{
						aListData.add("0");
					}
					else
					{
						aListData.add(changeCount.toString());
					}

					if (changeCount == null)
					{
						maxCount = Math.max(maxCount,0);
					}
					else
					{
						maxCount = Math.max(maxCount,changeCount.intValue());
					}
				}

				for (int j=0;j<=Integer.parseInt(endHour);j++)
				{
					Integer key_hour = new Integer(j);
					Integer changeCount = (Integer)tmapEnd.get(key_hour);

					if (!aListCount.contains(changeCount))
					{
						aListCount.add(changeCount);
					}

					if (changeCount != null)
					{
						linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDS&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline+"&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(eDate)+"&ec_viewchange=byDate&timeZone="+key_hour+"&selectedDuration="+selectedDuration+"&request_start=DCDS&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
					}
					aListLinks.add(linkUrl);
					aListColors.add(barColor);

					if (changeCount == null)
					{
						sampleValues = sampleValues + ",x";
					}
					else
					{
						sampleValues = sampleValues + "," + changeCount.intValue();
					}
					barLabels = barLabels + "," + key_hour.intValue();

					aListData.add(key_hour.toString());
					if (changeCount == null)
					{
						aListData.add("0");
					}
					else
					{
						aListData.add(changeCount.toString());
					}
					if (changeCount == null)
					{
						maxCount = Math.max(maxCount,0);
					}
					else
					{
						maxCount = Math.max(maxCount,changeCount.intValue());
					}
				}
			}
			else
			{
				for (int j=Integer.parseInt(startHour);j<=Integer.parseInt(endHour);j++)
				{
					Integer key_hour = new Integer(j);
					Integer changeCount = (Integer)tmapEnd.get(key_hour);

					if (!aListCount.contains(changeCount))
					{
						aListCount.add(changeCount);
					}

					if (changeCount != null)
					{
						linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDS&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline+"&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(eDate)+"&ec_viewchange=byDate&timeZone="+key_hour+"&selectedDuration="+selectedDuration+"&request_start=DCDS&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
					}
					aListLinks.add(linkUrl);
					aListColors.add(barColor);

					if (changeCount == null)
					{
						sampleValues = sampleValues + ",x";
					}
					else
					{
						sampleValues = sampleValues + "," + changeCount.intValue();
					}
					barLabels = barLabels + "," + key_hour.intValue();

					aListData.add(key_hour.toString());
					if (changeCount == null)
					{
						aListData.add("0");
					}
					else
					{
						aListData.add(changeCount.toString());
					}
					if (changeCount == null)
					{
						maxCount = Math.max(maxCount,0);
					}
					else
					{
						maxCount = Math.max(maxCount,changeCount.intValue());
					}
				}
			}

			sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Hours");
		}
		else
		{
			String strSelectedDuration = null;
			if (!str_ec_timeline.equalsIgnoreCase("Any"))
			{
				strSelectedDuration = new String(str_ec_timeline);
			}
			else
			{
				strSelectedDuration = new String(strDateDiff+" days");
			}

			SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
			Date today = new Date(egDateInfo.egetUTCDate());
			String strToday = sdf.format(today);

			String selectedDurationTemp = new String(strSelectedDuration);
			selectedDurationTemp = selectedDurationTemp.substring(0,selectedDurationTemp.indexOf(" "));
			int idxDays = Integer.parseInt(selectedDurationTemp);

			if (actualEndDate.equals(strToday))
			{
				if (strSelectedDuration.indexOf("week") > -1)
				{
					idxDays = idxDays * 7;
				}
				else if (strSelectedDuration.indexOf("month") > -1)
				{
					idxDays = ecUtils.getDaysforOneMonth();
				}

				for (int i=idxDays;i>0;i--)
				{
					Map paramMapTemp_A = new HashMap();
					if (i == 1)
					{
						paramMapTemp_A.put("ec_timeline",new String[]{i+" day"});
						paramMapTemp_A.put("ec_prevtimeline",new String[]{i+" day"});
					}
					else
					{
						paramMapTemp_A.put("ec_timeline",new String[]{i+" days"});
						paramMapTemp_A.put("ec_prevtimeline",new String[]{i+" days"});
					}
					TimeLineBean timeLineBean_A = new TimeLineBean(paramMapTemp_A);

					aListDates.add(timeLineBean_A.getStartDate());
					if (i == 1)
					{
						aListDates.add(timeLineBean_A.getEndDate());
					}
				}
			}
			else
			{
				aListDates.add(actualStartDate);

				for (int i=1;i<=idxDays;i++)
				{
					Date s_start_date = egDateInfo.egetDateUS(actualStartDate);
					s_start_date.setTime(s_start_date.getTime() + ((i * 24 * 3600) * 1000L));
					String strDateTemp = sdf.format(s_start_date);
					aListDates.add(strDateTemp);
				}
			}

			for (int j=0;j<aListDates.size();j++)
			{
				String tempDate = (String)aListDates.get(j);
				int changeCount = 0;
				for (int x=0; x<aListChangesDatewise.size(); x++)
				{
					ArrayList aList_A = (ArrayList)aListChangesDatewise.get(x);
					String strDateTime = (String)aList_A.get(0);
					if (strDateTime.startsWith(tempDate))
					{
						changeCount++;
					}
				}
				aListChangeCount.add(""+changeCount);

				if (!aListCount.contains(new Integer(changeCount)))
				{
					aListCount.add(new Integer(changeCount));
				}

				if (changeCount > 0)
				{
					linkUrl = "../servlet/com.eg.EcConfigurationServlet?request_from=DCDS&ec_rtype=Change&ec_option1="+URLEncoder.encode(selectionOption)+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_timeline="+str_ec_timeline+"&ec_prevtimeline="+str_ec_timeline+"&ec_stdate_h="+URLEncoder.encode(tempStartDate)+"&ec_enddate_h="+URLEncoder.encode(tempEndDate)+"&ec_sthr_h="+startHour+"&ec_endhr_h="+endHour+"&ec_startmin_h="+startMinute+"&ec_endmin_h="+endMinute+"&ec_changetype="+strChangeType+"&selectDate="+URLEncoder.encode(tempDate)+"&ec_viewchange=byDate&timeZone=&selectedDuration="+selectedDuration+"&request_start=DCDS&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"");
				}
				aListLinks.add(linkUrl);
				aListColors.add(barColor);

				if (changeCount == 0)
				{
					sampleValues = sampleValues + ",x";
				}
				else
				{
					sampleValues = sampleValues + "," + changeCount;
				}
				barLabels = barLabels + "," + StringUtils.replace(DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",format),",","");


				String csvValues = StringUtils.replace(DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",format),",","");
				aListData.add(csvValues);
				if (changeCount == 0)
				{
					aListData.add("0");
				}
				else
				{
					aListData.add(Integer.toString(changeCount));
				}
				maxCount = Math.max(maxCount,changeCount);
			}
		}

		StringBuffer linkStrBuffer = new StringBuffer();
		StringBuffer linkStrBufferColors = new StringBuffer();
		if (aListLinks != null && aListLinks.size() > 0)
		{
			linkStrBuffer.append((String)aListLinks.get(0));
			linkStrBufferColors.append((String)aListColors.get(0));
			for (int i=1; i<aListLinks.size(); i++)
			{
				linkStrBuffer.append(",");
				linkStrBuffer.append(aListLinks.get(i));
				linkStrBufferColors.append(",");
				linkStrBufferColors.append(aListColors.get(i));
			}
		}
		aListLinkStr = linkStrBuffer.toString();
		aListColorStr = linkStrBufferColors.toString();

		maxCount = (maxCount == 0) ? maxCount + 2 : maxCount + 1;
		sampleValues = sampleValues.substring(1);
		barLabels = barLabels.substring(1);
	}

	ArrayList aListPdfData = new ArrayList();
	EgPdfData pdfData = new EgPdfData();
	EgTableAttributes egTableAttributes = new EgTableAttributes();
	ArrayList aListColumnNames = new ArrayList();
	ArrayList userColumnNames = new ArrayList();

	aListColumnNames.add("C0");
	aListColumnNames.add("C1");

	if (str_ec_timeline.equalsIgnoreCase("1 day") || 
			strDateDiff.equals("0") || 
			(str_ec_timeline.equalsIgnoreCase("Any") && strDateDiff.equals("1")))
	{
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.daywise.Hours"));
	}
	else
	{
		userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.daywise.Days") + " (" + format + ")");
	}
	userColumnNames.add(mappingInfo.getTextDescription("configmgmt.configuration.Changes"));

	egTableAttributes.setColumnNames(userColumnNames);
	egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.dashboard.Total Changes") + " : " + aListChangesDatewise.size());

	EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

	EgTable egTable = new EgTable();
	egTable.setModel(egTableModel);
	egTable.setAttributes(egTableAttributes);

	aListPdfData.add(egTable);

	boolean flagEqualsOne = true;
	for (int i=1; i<aListCount.size(); i++)
	{
		Integer count_Value = (Integer)aListCount.get(i);
		if (count_Value != null && count_Value.intValue() > 1)
		{
			flagEqualsOne = false;
			break;
		}
	}
	if (flagEqualsOne)
	{
		yAxisMaxValue = "5";
	}
	else
	{
		yAxisMaxValue = "0";
	}

	//Fusion Column Chart Data starts--Rekha
	HashMap mapChartAttributes = new HashMap();//map for chart attributes
	mapChartAttributes.put("bgcolor","FFFFFF");
	mapChartAttributes.put("yAxisName","Changes");
	mapChartAttributes.put("xAxisName",sampleAxisLabel);
	mapChartAttributes.put("showToolTip","1");
	mapChartAttributes.put("showValues","1");
	mapChartAttributes.put("showBorder","0");
	mapChartAttributes.put("showShadow","1");
	mapChartAttributes.put("alpha","0");
	mapChartAttributes.put("canvasBgColor","F2F2F2");
	mapChartAttributes.put("canvasBgAlpha","60");
	mapChartAttributes.put("canvasBorderColor","000000");
	mapChartAttributes.put("canvasBorderThickness","1");
	mapChartAttributes.put("canvasBorderAlpha","30");
	mapChartAttributes.put("maxColWidth","40");
	mapChartAttributes.put("labelDisplay","ROTATE");
	mapChartAttributes.put("placeValuesInside","1");
	mapChartAttributes.put("rotateValues","1");
	mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
	mapChartAttributes.put("unescapeLinks","0");

	HashMap mapChartData = new HashMap();//map for chart data
	mapChartData.put("columnLabels",barLabels);
	mapChartData.put("columnValues",sampleValues);
	mapChartData.put("columnLinks",aListLinkStr);
	mapChartData.put("columnColors",aListColorStr);

	HashMap mapProperties = new HashMap();//map for misc properties
	mapProperties.put("showColors","true");
	mapProperties.put("enableLinks","true");

	EcFusionChartBean chartbean = new EcFusionChartBean();
	String xmlString = chartbean.getXMLDataForColumnChart(mapChartAttributes,mapChartData,mapProperties);
	//Fusion Column Chart Data ends

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_date.js"></script>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="javascript1.2">
function showDetails()
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var selectedComponentType = thisForm.componentType.options[thisForm.componentType.options.selectedIndex].value;
	if (selectedComponentType == -1)
	{
		alert('<egui:intnl text="configmgmt.changes.daywise.Please select a component type" />');
		return false;
	}

	var timeStart = thisForm.ec_stdate_h;
	var timeEnd = thisForm.ec_enddate_h;

	if (timeStart != "" && timeEnd != "")
	{
		var startHr = thisForm.ec_sthr.options[thisForm.ec_sthr.selectedIndex];
		var startMin = thisForm.ec_startmin.options[thisForm.ec_startmin.selectedIndex];

		var startHr_h = thisForm.ec_sthr_h.value;
		var startMin_h = thisForm.ec_startmin_h.value;

		var endHr = thisForm.ec_endhr.options[thisForm.ec_endhr.selectedIndex];
		var endMin = thisForm.ec_endmin.options[thisForm.ec_endmin.selectedIndex];

		var endHr_h = thisForm.ec_endhr_h.value;
		var endMin_h = thisForm.ec_endmin_h.value;

		//Convert to original format(i.e., to MM/dd/yyyy)
		var startDate = formatDate(new Date(getDateFromFormat(timeStart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var endDate = formatDate(new Date(getDateFromFormat(timeEnd.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

		if(!validateDateTime(startDate,endDate,startHr_h,endHr_h,startMin_h,endMin_h))
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Start date should be less than the End date" />');
			return false;
		}
	}

	thisForm.secsubmt.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
	thisForm.secsubmt.disabled = true;
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=DaywiseChangeDistribution&request_start=<%=strRequestStart%>&componentType="+selectedComponentType;
	thisForm.submit();
}

function componentSearch()
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var selectedComponentType = thisForm.componentType.options[thisForm.componentType.options.selectedIndex].value;
	if (selectedComponentType == -1)
	{
		alert('<egui:intnl text="configmgmt.changes.daywise.Please select a component type" />');
		return false;
	}

	var timeStart = thisForm.ec_stdate_h;
	var timeEnd = thisForm.ec_enddate_h;

	if (timeStart != "" && timeEnd != "")
	{
		var startHr = thisForm.ec_sthr.options[thisForm.ec_sthr.selectedIndex];
		var startMin = thisForm.ec_startmin.options[thisForm.ec_startmin.selectedIndex];

		var startHr_h = thisForm.ec_sthr_h.value;
		var startMin_h = thisForm.ec_startmin_h.value;
		
		var endHr = thisForm.ec_endhr.options[thisForm.ec_endhr.selectedIndex];
		var endMin = thisForm.ec_endmin.options[thisForm.ec_endmin.selectedIndex];

		var endHr_h = thisForm.ec_endhr_h.value;
		var endMin_h = thisForm.ec_endmin_h.value;
		
		//Convert to original format(i.e., to MM/dd/yyyy)
		var startDate = formatDate(new Date(getDateFromFormat(timeStart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		var endDate = formatDate(new Date(getDateFromFormat(timeEnd.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

		if(!validateDateTime(startDate,endDate,startHr_h,endHr_h,startMin_h,endMin_h))
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Start date should be less than the End date" />');
			return false;
		}
	}
}

function printData()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("printType=DAYWISE_CHANGE_DISTRIBUTION_DATA");
	printQS.append("&Page=daywise");		//Decide file to display for print in the controller
	printQS.append("&printPageTitle=TIMELINE_OF_CHANGES");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
	var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
	print(s_qryString);
}

function savePdf()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","DaywiseChangeDistributionSummary");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
	getPdf('<%=configSkin%>');
}

function mail()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
%>
	sendMail();
}

function goTo(type)
{
	switch (type)
	{
		case "jsp":
			document.forms[0].action = '../config/ecDaywiseChangeDistributionSummary.jsp?request_from=Timeline&request_start=<%=strRequestStart%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=ec_userOption%>&id=<%=id%>';
			document.forms[0].submit();
	}
}

var screenname='';
var ev='';
var def='';
var def_h='';
var datefv='';
function checkwindow1(datef,datef_h,event,sname,frmField)
{
	event=event?event:window.event;
	document.forms[0].fromField.value = frmField;
	try
	{
		datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	}
	catch(e)
	{
		datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
	}
	screenname=sname;
	ev=event;
	def=datef;
	def_h=datef_h;
	try
	{
		setTimeout("callcalendar4(def,def_h,datefv,ev,screenname)",0);
	}
	catch(e)
	{
		alert(e);
	}
}

function getInformations()
{
	var thisForm = document.daywisechanges;
	var componentType = thisForm.componentType.value;
	var str_ec_timeline = "";
	var tempCriteria ="";
	var tempCriteriaPrevious ="";
	var tempUserOption ="";
	var tempUserOptionPrevious ="";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}
	if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
	{
		tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
	}
	if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
	{
		tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
	}

	if (tempCriteria != "" && tempCriteriaPrevious != "")
	{
		if (tempCriteria == tempCriteriaPrevious)
		{
			if (tempUserOption != tempUserOptionPrevious)
			{
				componentType = "All";
				str_ec_timeline = "1 day";
			}
		}
		else
		{
			componentType = "All";
			str_ec_timeline = "1 day";
		}
	}
	thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=DaywiseChangeDistribution&componentType="+componentType+"&ec_timeline="+str_ec_timeline+"&request_start=<%=strRequestStart%>&id=<%=id%>&request_from=<%=strRequestFrom%>";
	thisForm.submit();
}

function csv()
{
<%
	if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	thisForm = document.forms[0];
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function schedule(op)
{
	var checkFlag = componentSearch();
	if(checkFlag == false) return;
	var thisForm = document.daywisechanges;
	if (op == "schedule")
	{
<%
		if (strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule") || strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule"))
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
		}
		else
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=DaywiseChanges";
<%
		}
%>
	}
	else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
	else
	{
		alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
		return;
	}
	thisForm.submit();
}

function goBackToSaveSchedule()
{
	var thisForm = document.forms[0];
	thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=strRequestFrom%>&id=<%=id%>";
	thisForm.submit();
}

</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<form name="daywisechanges" method="post" style="margin:0px">
<input type="hidden" name="fromField" id="fromField" value="from">
<input type="hidden" name="ec_rtype" value="DaywiseChanges">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap height="24px">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE" /> : <egui:intnl text="configmgmt.changes.daywise.TIMELINE OF CHANGES" /></b></td>
					<td>
<%
	if ((strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule")) || (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule")))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					
					</td>

				</tr>
			</table>
		</td>
	</tr>
	
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
			<!-- new tab start here -->
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
									</select>
								</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
								<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
	}
	else
	{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->
				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold">
										<col width="20"><col width="130"><col width="10"><col width="250"><col width="100"><col width="10"><col width="200"><col width="160">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center">&nbsp;</td>
											<td align="right" valign="top" style="padding-top:3px"><egui:intnl text="configmgmt.changes.detailed.Component Type"/></td>
											<td align="center" valign="top" style="padding-top:3px">:</td>
											<td align="left" valign="top">
												<select name="componentType" style="width:250px;" onChange="javascript:goTo('jsp')">
<%
	if (aListComponentTypes != null && !aListComponentTypes.isEmpty())
	{
		if (aListComponentTypes.size() > 1)
		{
%>
			<option value='<%="All"%>' <%=(componentType != null && componentType.equals("All"))?"selected":""%>>
				<egui:intnl text="configmgmt.changes.daywise.All" />
			</option>
<%
		}
		ArrayList serverList = sorter.getSortedCompTypeList(aListComponentTypes);
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();

			String selected = "";
			if (componentType != null && componentType.equals(actualName))
				selected = "selected";
%>
			<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.changes.daywise.Not Applicable" />
			</option>
<%
	}
%>
												</select>
											</td>
											<td align="right" valign="top" style="padding-top:3px"><egui:intnl text="configmgmt.changes.detailed.Timeline"/></td>
											<td align="center" valign="top" style="padding-top:3px">:</td>
											<td align="left" colspan="2"><%@ include file="EcTimeLineLiteNew.jsp"%></td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" colspan="2">&nbsp;</td>
<%
	if ((strRequestFrom != null && strRequestFrom.equalsIgnoreCase("saveSchedule")) || (strRequestStart != null && strRequestStart.equalsIgnoreCase("saveSchedule")))
	{
%>
											<td align="center" colspan="5" valign="middle" height="20"> 
											<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
											</td>
<%
	}
	else
	{
%>
											<td align="center" colspan="5" valign="middle" height="20"><input type="button" name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:showDetails()"></td>
<%
	}
%>
											<td align="right" rowspan="2" style="height:20" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20">
													<tr>
														<td width="50" align="center" id="leftcurve"><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
														<td width="2" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="2" ></td>
														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"></td>
														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"></td>
														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"></td>
														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"></td>
														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>
														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"></td>
														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>
                                                                                                                <td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13"></td>
														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>														
														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if ((strRequestFrom == null || !strRequestFrom.equalsIgnoreCase("Timeline")) && submitOrNot.equalsIgnoreCase("true") && isDisplay)
	{
		if (!tmap_changeConfigDetails.isEmpty() && componentType != null)
		{
			String startTime = tempStartDate + " " + tempStartHour + ":" + tempStartMinute;
			String endTime = tempEndDate + " " + tempEndHour + ":" + tempEndMinute;

			/* Added by Prakash.K starts */
			EgTimeZoneConverter startDateTime = new EgTimeZoneConverter(startTime,user);
			EgTimeZoneConverter endDateTime = new EgTimeZoneConverter(endTime,user);
			/* Added by Prakash.K ends */
%>
							<tr>
								<td align="center" width="100%" height="5%" valign="top" class="bgwhite">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
											<td align="center" width="80%" class="tdbackcolortop" id="white_content"><b><egui:intnl text="configmgmt.changes.daywise.StartDate"/>&nbsp:&nbsp;<%=startDateTime.getDateTime()%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="configmgmt.changes.daywise.End Date"/>&nbsp;:&nbsp<%=endDateTime.getDateTime()%></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
<%
		}
		else
		{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												&nbsp;
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
		}
	}
	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty() && submitOrNot.equalsIgnoreCase("true") && isDisplay)
	{
		boolean flag = false;
		if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
		{
			flag = true;
		}
		if (flag)
		{
%>
							<tr>
								<td align="center" width="100%">
									<b><%=chartTitle%></b>
								</td>
							</tr>
							<tr>
								<td align="center" width="100%" bgcolor="white"  nowrap>
									<!--
									<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="350" id="Column3D">
										<param name="movie" value="/final/FusionCharts/swf/Column3D.swf" />
										<param name="FlashVars"value="&dataXML=<%=xmlString%>&chartWidth=800&chartHeight=350" />
										<param name="quality" value="high" />
										<param name="wmode" value="transparent"/>
										<embed src="/final/FusionCharts/swf/Column3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=800&chartHeight=350" quality="high" width="90%" height="350" name="Column3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object>
									-->
									<div id="chartColumnDaywise3DContainer"  style="height:100%;"></div>
									<script type="text/javascript">
									if  ( FusionCharts( "myColumnDaywise3DChartId" ) )
										FusionCharts( "myColumnDaywise3DChartId" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/Column3D.swf","myColumnDaywise3DChartId", "800", "340","0","1");
									myChart.setXMLData("<%=xmlString%>");
									myChart.setTransparent(true);
									myChart.render("chartColumnDaywise3DContainer");
								</script>
								</td>
							</tr>
<%
		}
		else
		{
%>
							<tr>
								<td align="center" width="100%">
									<b><%=chartTitle%></b>
								</td>
							</tr>
							<tr>
								<td align="center" width="100%" bgcolor="white"  nowrap>
									<!--
									<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="350" id="Column2D">
										<param name="movie" value="/final/FusionCharts/swf/Column2D.swf" />
										<param name="FlashVars"value="&dataXML=<%=xmlString%>&chartWidth=800&chartHeight=350" />
										<param name="quality" value="high" />
										<param name="wmode" value="transparent"/>
										<embed src="/final/FusionCharts/swf/Column2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=800&chartHeight=350" quality="high" width="90%" height="350" name="Column2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
									</object>
									-->
									<div id="chartColumnDaywise2DContainer"  style="height:100%;"></div>
									<script type="text/javascript">
									if  ( FusionCharts( "myColumnDaywise2DChartId" ) )
										FusionCharts( "myColumnDaywise2DChartId" ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/Column2D.swf","myColumnDaywise2DChartId", "800", "350","0","1");
									myChart.setXMLData("<%=xmlString%>");
									myChart.setTransparent(true);
									myChart.render("chartColumnDaywise2DContainer");
								</script>
								</td>
							</tr>
<%
		}

		//For print - Start
		EcPrintData printData = new EcPrintData();
		printData.setChartTitle(chartTitle);
		printData.setStartDate(tempStartDate+" "+tempStartHour+":"+tempStartMinute);
		printData.setEndDate(tempEndDate+" "+tempEndHour+":"+tempEndMinute);
		printData.setSampleValue(sampleValues);
		printData.setSampleAxisLabel(sampleAxisLabel);
		printData.setBarLabel(barLabels);
		printData.setMaxRange(String.valueOf(maxCount));
		printData.setComponent(componentType);
		printData.setBarLabelAngle("360");
		printData.setSelectedDuration(selectedDuration);
		session.setAttribute("DAYWISE_CHANGE_DISTRIBUTION_DATA",printData);
		//For print - End

		//For PDF - Start
		//ArrayList aListPdfData = new ArrayList();
		//EgPdfData pdfData = new EgPdfData();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.TIMELINE OF CHANGES") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.TIMELINE OF CHANGES") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String subTitle = "";
		if (!componentType.equalsIgnoreCase("All"))
		{
			subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(componentType);
		}
		else
		{
			subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.All Components");
		}

		/*Added by Prakash.K Starts*/
		EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(tempStartDate+" "+tempStartHour+":"+tempStartMinute,user);
		String startDateTime = timeZoneConverter.getDateTime();
		timeZoneConverter = new EgTimeZoneConverter(tempEndDate+" "+tempEndHour+":"+tempEndMinute,user);
		String endDateTime = timeZoneConverter.getDateTime();
		/*Added by Prakash.K Ends*/

		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.summary.Between") + " " + startDateTime+ " " + mappingInfo.getTextDescription("configmgmt.changes.summary.and") + " " + endDateTime ;
		reportAttributes.setSubTitle(subTitle);

		reportAttributes.setReportName("DaywiseChangeDistribution");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(false);

		pdfData.setAttributes(reportAttributes);

		//EgTableAttributes egTableAttributes = new EgTableAttributes();
		//egTableAttributes.setImageData(true);

		//ArrayList aListColumnNames = new ArrayList();
		//ArrayList userColumnNames = new ArrayList();
		//ArrayList aListData = new ArrayList();

		//aListColumnNames.add("C0");
		//aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=DAYWISE_DISTRIBUTION&chartType=bar&height=435&width=780&chartTitle="+EgURLEncoder.encode(chartTitle,"UTF-8")+"&sampleValues="+URLEncoder.encode(sampleValues)+"&barLabels="+URLEncoder.encode(barLabels)+"&range="+URLEncoder.encode(String.valueOf(maxCount))+"&barLabelAngle=360&sampleAxisLabel="+EgURLEncoder.encode(sampleAxisLabel,"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8")+"&selectedDuration="+URLEncoder.encode(selectedDuration));

		//EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

		//EgTable egTable = new EgTable();
		//egTable.setModel(egTableModel);
		//egTable.setAttributes(egTableAttributes);

		//aListPdfData.add(egTable);


		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
		//For PDF - End
	}
	else if (tmap_changeConfigDetails != null && tmap_changeConfigDetails.isEmpty() && !aListComponentTypes.isEmpty() && submitOrNot.equalsIgnoreCase("true") && isDisplay)
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
													</tr>
													<tr>
														<td align="center"><b><egui:intnl text="configmgmt.changes.detailed.There were no configuration changes in the selected timeline" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												&nbsp;
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>

</table>

</form>
</body>
</html>



