<%
/*
 *		File			:	ecComponentChanges.jsp
 *		Purpose			:	Display all the changes for the user associated configuration component
 *		Creation Date	:	15-08-2006
 *		Author			:	Balasigamani
 *		Layout Design	:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.EgDateInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "egurkha.config.ConfigDbSetting"%>
<%@ page import = "egurkha.config.EcCurrentAlertBean"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.egurkha.util.DateUtil"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%
	int displayLength = 18;

	// Bean Object
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	EgDateInfo egDt=new EgDateInfo();
	EcCurrentAlertBean currentBean=new EcCurrentAlertBean();
	EcUtils ecutils=new EcUtils();

	//Ini File data
	String defaultHours=configTestsInfo.getRefreshValue("ComponentNameNChanges");
	String svalue=configTestsInfo.getServerDisplayValue("DASHBOARD_COUNT_SORT","ComponentNameNChanges");
	boolean sorting =svalue.equalsIgnoreCase("true")?true:false;
	String hourSelection=request.getParameter("NHour");
	Map dashboardSetting=(Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);
	String hourSetting=(String)dashboardSetting.get(EgConfigConstants.NAME_CHANGE_DURATION);

	// Variables
	Map finalResult=new TreeMap();
	Hashtable storeData=new Hashtable();
	ArrayList nameValue=new ArrayList();
	ArrayList countValue=new ArrayList();
	Map compNameWithTest=new TreeMap();

	long msecsPerHour = (long) 1000 * 60 * 60;
	int timeCount=0;
	//String hours="";
	String edate="";
	String sdate="";
	String startHour="";
	String endHour="";
	String startMinit="";
	String endMinit="";

	//Request Data
	StringTokenizer st=new StringTokenizer(defaultHours,",");
	if(hourSelection==null)
	{
		if(hourSetting==null)
			hourSelection=st.nextToken();
		else
			hourSelection=hourSetting;
	}

	currentBean.setUserObject(user);
	currentBean.initialize(hourSelection,"HOURS");
	finalResult=(TreeMap)currentBean.getFinalProcessData();

	// Date for UI purpose
	Date dt_temp = new Date(egDt.egetUTCDate());
	Calendar cal_temp = new GregorianCalendar();
	cal_temp.setTime(dt_temp);
	Date dt_temp1 = cal_temp.getTime();
	long l_temp = dt_temp1.getTime();
	edate = egDt.egetDate(l_temp);

	int num = Integer.parseInt(hourSelection);
	int start_time = num;

	sdate = egDt.egetDate(l_temp -(long)(start_time* msecsPerHour));
	sdate = sdate.substring(0,sdate.lastIndexOf(":")+1) + "00";
	edate = edate.substring(0,edate.lastIndexOf(":")+1) + "00";

	String startDate=sdate.substring(0,sdate.indexOf(' '));
	String endDate=edate.substring(0,edate.indexOf(' '));
	startDate = startDate.substring(startDate.indexOf('/')+1,startDate.lastIndexOf('/'))+"/"+startDate.substring(0,startDate.indexOf('/'))+"/"+startDate.substring(startDate.lastIndexOf('/')+1);
	endDate=endDate.substring(endDate.indexOf('/')+1,endDate.lastIndexOf('/'))+"/"+endDate.substring(0,endDate.indexOf('/'))+"/"+endDate.substring(endDate.lastIndexOf('/')+1);

	if(timeCount==0)
	{
		timeCount++;
		String SHours = sdate.substring(sdate.indexOf(' ')+1);
		String EHours = edate.substring(edate.indexOf(' ')+1);
		StringTokenizer startTimeToken = new StringTokenizer(SHours,":");
		StringTokenizer endTimeToken = new StringTokenizer(EHours,":");

		startHour = startTimeToken.nextToken();
		startMinit = startTimeToken.nextToken();
		String startSeconds = startTimeToken.nextToken();
		endHour = endTimeToken.nextToken();
		endMinit = endTimeToken.nextToken();
		String endSeconds = endTimeToken.nextToken();
	}

	//For Unicode support
	Vector vecTimelineText = new Vector();
	Vector vecTimelineValue = new Vector(); //in hours

	StringTokenizer strTokens = new StringTokenizer(defaultHours,",");
	while (strTokens.hasMoreTokens())
	{
		String hour = strTokens.nextToken().trim();
		int h = Integer.parseInt(hour);

		if (h == 1)
		{
			vecTimelineValue.add("1");
			vecTimelineText.add("1 hour");
		}
		else
		{
			vecTimelineValue.add(""+h);
			vecTimelineText.add(h+" hours");
		}
	}

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	String tempStartDate = DateUtil.changeDateFormat(startDate,"MM/dd/yyyy",currentDateFormat);
	String tempEndDate = DateUtil.changeDateFormat(endDate,"MM/dd/yyyy",currentDateFormat);
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.dashboard.Component Changes At-A-Glance" />
</title>
<egui:skin ui="config"/>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="overflow:hidden" bgcolor="#FFFFFF">
<div id="name">
<!-- <form name="NHour"> -->

	<table border="0" cellspacing="0" cellpadding="0" width="100%" height="100%" style="table-layout:fixed" id="innertable">
		<tr>
			<td height="20" colspan="3">
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr>
						<td class="tdbackcolortop" width="70%">
							<span align="left">&nbsp;
							<a href="/final/config/ecComponentChangeSummary.jsp?NHour=<%=URLEncoder.encode(hourSelection)%>&request_from=Dashboard" class="eg_headlink_white">
							<b><egui:intnl text="configmgmt.dashboard.Changes At-A-Glance"/></b> </a>
							</span>
						</td>
						<td align="right" width="30%" class="tdbackcolortop">
							<select name="Hour" onChange="javascript:goto3()">
<%//=ecutils.fillNHourSelectBox(defaultHours,hourSelection)%>
<%
	for (int u=0;u<vecTimelineValue.size();u++)
	{
		String strTimelineText = (String)vecTimelineText.get(u);
		String strTimelineValue = (String)vecTimelineValue.get(u);

		String selected = "";
		if (strTimelineValue.equals(hourSelection))
			selected = "selected";

		String strValue = strTimelineText.substring(0,strTimelineText.indexOf(" "));
		String strText = strTimelineText.substring(strTimelineText.indexOf(" ")+1);
%>
							<option value="<%=strTimelineValue%>" <%=selected%> >
							<%=strValue%> <egui:intnl text='<%="configmgmt.common."+strText%>' />
							</option>
<%
	}
%>
							</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	if(finalResult!=null && finalResult.size()>0)
	{
		Map type=new TreeMap();
		Iterator ie2=finalResult.keySet().iterator();
		int totalChanges=0;
		while (ie2.hasNext())
		{
			try
			{
				int count=0;
				String serverName=(String)ie2.next(); //GenericService and Krishna
				Map gloServerName=(TreeMap)finalResult.get(serverName);
				Iterator ie3=gloServerName.keySet().iterator();
				String serverTypes=serverName.substring(serverName.lastIndexOf(':')+1);
				String compName=serverName.substring(0,serverName.lastIndexOf(':'));
				ArrayList meas=new ArrayList();
				while (ie3.hasNext())
				{
					String test_name=(String)ie3.next();
					ArrayList c_value=(ArrayList)gloServerName.get(test_name);
					//String displayName = configTestsInfo.getDisplayNameForTest(test_name); 
					meas.add(test_name);
					TreeMap tmapTemp = new TreeMap();
					for (int d=0;d<c_value.size();d++)
					{
						String strValue = (String)c_value.get(d);
						String strInfo = strValue.substring(0,strValue.indexOf("@"));
						String strData = strValue.substring(strValue.indexOf("@")+1);
						ArrayList aListTemp = (ArrayList)tmapTemp.get(strInfo);
						if (aListTemp == null)
						{
							aListTemp = new ArrayList();
							aListTemp.add(strData);
							tmapTemp.put(strInfo,aListTemp);
						}
						else
						{
							aListTemp.add(strData);
						}
					}
					Iterator infoAsKeys = tmapTemp.keySet().iterator();
					while (infoAsKeys.hasNext())
					{
						String keyInfo = (String)infoAsKeys.next();
						ArrayList infoValues = (ArrayList)tmapTemp.get(keyInfo);
						for (int d=0;d<infoValues.size();d++)
						{
							String strValue = (String)infoValues.get(d);
							if (strValue.indexOf("##NEW##") != -1)
							{
								count++;
								break;
							}
							count++;
						}
					}
				}
				compNameWithTest.put(compName,meas);
				totalChanges=totalChanges+count;
					
				Map type_name=(TreeMap)type.get(serverTypes);
				if(type_name==null)
				{
					type_name=new TreeMap();
					type_name.put(compName,new Integer(count));
					type.put(serverTypes,(TreeMap)type_name);
				}
				else
				{
					type_name.put(compName,new Integer(count));
					type.put(serverTypes,(TreeMap)type_name);
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}

		// Iterator type Wise
		Iterator itrat=type.keySet().iterator();
		while(itrat.hasNext())
		{
			String sTypes=(String)itrat.next();
			Map hTypes=(TreeMap)type.get(sTypes);
			Iterator itr=hTypes.keySet().iterator();
			int comCount=0;
			while(itr.hasNext())
			{
				String cName=(String)itr.next();
				int cout=((Integer)hTypes.get(cName)).intValue();
				storeData.put(cName+":"+sTypes,new Integer(cout));
				nameValue.add(cName+":"+sTypes);
				countValue.add(new Integer(cout));
			}
		}
		Object[] keySet2 = storeData.keySet().toArray();
		if (keySet2.length > 0)
		{
			Arrays.sort(keySet2);
		}
		if(sorting)
		{
			Object [] tmpArray = countValue.toArray();
			int [] valueArray = new int[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Integer)tmpArray[i]).intValue();
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = countValue.indexOf(new Integer(valueArray[i]));
				tmpArray[i] = (String)nameValue.get(thisIndex);
				keySet2[valueArray.length-1-i] = tmpArray[i];
				nameValue.remove(tmpArray[i]);
				countValue.remove(new Integer(valueArray[i]));
			}
		}
%>
		<tr>
			<td align="center" width="100%" height="18" colspan="3" id="tdbacklightcolor3" class="text_bold">
				<egui:intnl text="configmgmt.dashboard.Total Changes" />&nbsp;:&nbsp;<%=totalChanges%>
			</td>
		</tr>

		<tr>
			<td colspan="3" valign="top" height="100%">
				<div id="div_scroll" style="width:100%;height:145px;border:0px solid #000000">
				<table width="100%" id="body_text" cellspacing="0" cellpadding="0" border="0" align="center" style="table-layout:fixed"><col width="31%"><col width="15%"><col width="54%">
					<tr>
						<td nowrap height="20" align="left"  class="table_header_dash">
							&nbsp;<egui:intnl text="configmgmt.dashboard.Component Name" />
						</td>
						<td align="left" height="20"  class="table_header_dash">
							&nbsp;<egui:intnl text="configmgmt.dashboard.Changes" />
						</td>
						<td nowrap align="center" height="20" class="table_header_dash" style="border-right-width:0px">
							&nbsp;<egui:intnl text="configmgmt.dashboard.Changes in" />
						</td>
					</tr>
<%
		for(int n=0;n<keySet2.length;n++)
		{
			boolean isMouseOver=false;
			String selectedServerName=(String)keySet2[n];
			String displayName=selectedServerName.substring(0,selectedServerName.lastIndexOf(':'));
			String secondDisplayName="";
			if(displayName.endsWith("NULL"))
				secondDisplayName=displayName.substring(0,displayName.lastIndexOf(':'));
			else 
				secondDisplayName=displayName;
			ArrayList measurementName=(ArrayList)compNameWithTest.get(displayName);
			String mName="";
			for(int s=0;s<measurementName.size();s++)
			{
				String temp = (String)measurementName.get(s);
				temp = mappingInfo.getTestDescription(temp);

				if(s==0)
					mName=temp;
				else
					mName=mName+", "+temp;
			}
			if(mName.length()>=37)
				isMouseOver=true;

			if(startHour.indexOf('0')>-1 && !startHour.equals("0") && !startHour.equals("10") && !startHour.equals("20"))
				startHour =startHour.substring(startHour.indexOf('0')+1);

			if(endHour.indexOf('0')>-1 && !endHour.equals("0") && !endHour.equals("10") && !endHour.equals("20"))
				endHour =endHour.substring(endHour.indexOf('0')+1);
%>
					<tr>
						<td valign="top" colspan="3">
							<table cellspacing="0" cellpadding="2" align="center" border="0" id="body_text"  width="100%" style="table-layout:fixed;"><col width="31%"><col width="15%"><col width="54%">
								<tr>
									<td nowrap class="cell_border" id="tdbacklightcolor2">
<%
			if (secondDisplayName.length() > displayLength)
			{
%>
										&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=URLEncoder.encode(startHour)%>&ec_endhr=<%=URLEncoder.encode(endHour)%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=URLEncoder.encode(selectedServerName)%>&ec_startmin=<%=URLEncoder.encode(startMinit)%>&ec_endmin=<%=URLEncoder.encode(endMinit)%>&ec_changetype=Latest&ec_viewchange=byInformation" class="eg_monlink" title="<%=secondDisplayName%>"><egui:display name="<%=secondDisplayName%>" length='<%=displayLength+""%>'/></a>
<%
			}
			else
			{
%>
										&nbsp;<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=URLEncoder.encode(startHour)%>&ec_endhr=<%=URLEncoder.encode(endHour)%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=URLEncoder.encode(selectedServerName)%>&ec_startmin=<%=URLEncoder.encode(startMinit)%>&ec_endmin=<%=URLEncoder.encode(endMinit)%>&ec_changetype=Latest&ec_viewchange=byInformation" class="eg_monlink"><%=secondDisplayName%></a>
<%
			}
%>
									</td>
									<td align="center" class="cell_border" target=""><a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=URLEncoder.encode(startHour)%>&ec_endhr=<%=URLEncoder.encode(endHour)%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=URLEncoder.encode(selectedServerName)%>&ec_startmin=<%=URLEncoder.encode(startMinit)%>&ec_endmin=<%=URLEncoder.encode(endMinit)%>&ec_changetype=Latest&ec_viewchange=byInformation" class="eg_monlink"><%=storeData.get(selectedServerName)%></a>
									</td>
<%
			if(isMouseOver)
			{
%>
									<td wrap  align="left" style="padding-left:4px"  id="tdbacklightcolor2" style="border-right-width:0px">
										<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=URLEncoder.encode(startHour)%>&ec_endhr=<%=URLEncoder.encode(endHour)%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=URLEncoder.encode(selectedServerName)%>&ec_startmin=<%=URLEncoder.encode(startMinit)%>&ec_endmin=<%=URLEncoder.encode(endMinit)%>&ec_changetype=Latest&ec_viewchange=byInformation" class="eg_monlink" onMouseOver="if(!arr['<%=n%>'])show('<%=n%>')" onMouseOut="if(!arr['<%=n%>'])hide('<%=n%>')">
											<%=(mName.length()>=37)?mName.substring(0,37)+"...":mName%>
										</a><br>
										<div id="layer<%=n%>" align="center" style="position:absolute;display:none;width:240px;visibility:hidden;overflow:hidden; border:1px solid #000000">
											<table cellspacing="1" cellpadding="1" id="tdbacklightcolor3" align="center" border="0" width="100%" >
												<tr>
													<td class="text75" style="padding-left:4px"><%=mName%></td>
												</tr>
											</table>
											<script language="javascript">arr[<%=n%>]=false;</script>
										</div>
									</td>
<%
			}
			else
			{
%>
									<td wrap width="55%" align="left" style="padding-left:4px"  id="tdbacklightcolor2" style="border-right-width:0px">
										<a href="/final/servlet/com.eg.EcConfigurationServlet?request_from=HomePage&ec_rtype=Change&ec_option1=Component Name&ec_timeline=Any&ec_prevtimeline=Any&ec_sthr=<%=URLEncoder.encode(startHour)%>&ec_endhr=<%=URLEncoder.encode(endHour)%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_option2=<%=URLEncoder.encode(selectedServerName)%>&ec_startmin=<%=URLEncoder.encode(startMinit)%>&ec_endmin=<%=URLEncoder.encode(endMinit)%>&ec_changetype=Latest&ec_viewchange=byInformation" class="eg_monlink">
											<%=mName%>
										</a>
									</td>
<%
			}
%>
								</tr>
							</table>
						</td>
					</tr>
<%
		}
%>
				</table>
				</div>
			</td>
		</tr>
<%
	}
	else
	{
%>
		<tr>
			<td align="center" colspan="3" height="160" valign="middle">
				<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
					<tr>
						<td align="center" height="85" valign="bottom">
							<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />' >
						</td>
					</tr>
					<tr>
						<td align="center" valign="top" height="75">
							<egui:intnl text="configmgmt.dashboard.No configuration changes have been found"/>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
%>
	</table>
<!-- </form> -->
</div>
</body>
</html>



