<%
/*
	File			:	EcWeeklyChanges.jsp
	Purpose			:	Display the list of changes daywise for the selected component type
	Creation Date	:	10-08-2006
	Author			:	Balasigamani
	UI Design		:	Jaiwin
*/
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="egurkha.config.EcUtils"%>	
<%@ page import="egurkha.config.ConfigDbSetting"%>
<%@ page import="egurkha.config.EcPrintData" %>
<%@ page import="egurkha.config.EcCurrentAlertBean"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import	= "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] options = {"1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	// Bean Object
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());

	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();

	String configSkin = user.getConfigSkin();
	String userName = user.getLoginID();
	EgConfigTestsInfo configtestsinfo = new EgConfigTestsInfo("manager");
	EgDateInfo egDt = new EgDateInfo();
	EcUtils ecUtils=new EcUtils();
	EcCurrentAlertBean currentBean=new EcCurrentAlertBean();
	EcPrintData printData=new EcPrintData();
	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);

	//Request data
	String defaultDuration=configtestsinfo.getServerDisplayValue("DISPLAY_DATACHANGES","DayChanges");
	String barColor=configtestsinfo.getServerDisplayValue("MISC_ARGS","BarChartColor");
	String countWeek = request.getParameter("selectionDuration");
	String server=request.getParameter("serverTypes");
	String barColorCode=(String)dashboardSetting.get(EgConfigConstants.BAR_COLOR);
	if(barColorCode!=null)
	{
		if(barColorCode.indexOf("#")==-1)
			barColor="#"+barColorCode;
		else
			barColor=barColorCode;
	}

	// Variables
	Map finalData=new TreeMap();
	ArrayList dateCount=new ArrayList();
	long msecsPerDays= (long) 1000 * 60 * 60 * 24;
	String hours="";
	String minutes="";
	String shours="";
	String sminutes="";
	String sampleValues="";
	String barLabels="";
	//String barLabelColors="";

	String sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Days") + " (" + currentDateFormat + ")";

	String selectionOption="";
	String sDate="";
	String changeStartDate="";
	String changeEndDate="";
	String eDate="";
	int qcount=0;
	int sel=0;
	String lastDayDate="";

	// Start to get changes data
	currentBean.setUserObject(user);
	Vector serverTypes=currentBean.getUserConfigComponent();
	if(serverTypes!=null && serverTypes.size()>0)
	{
		if(server==null||server.equalsIgnoreCase("All"))
		{
			server = "All";
			selectionOption="All Components";
		}
		else
			selectionOption="Component Type";

		if(countWeek==null)
		{
			Map dashboardDaySetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);

			String daySetting=(String)dashboardDaySetting.get(EgConfigConstants.DAYWISE_CHANGE_DISTRIBUTION);
			
			if(daySetting==null)
				countWeek=defaultDuration;
			else
				countWeek=daySetting;
		}

		currentBean.setAllComponents(selectionOption);
		currentBean.initialize(countWeek,"DAYS");
		if(!server.equalsIgnoreCase("All"))
			currentBean.setSelectedServer(server,"TYPE");
		if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
			finalData=(TreeMap)currentBean.getHourCount();
		else
			finalData=(TreeMap)currentBean.getDaysCount();

		if(countWeek.indexOf("day")>-1)
		{
			int tempDay=Integer.parseInt(countWeek.substring(0,countWeek.indexOf(' ')));
			sel=tempDay;
		}
		else
		{
			int tempDay=Integer.parseInt(countWeek.substring(0,countWeek.indexOf(' ')));
			sel=tempDay*7;
		}

		if(countWeek!=null && !countWeek.equalsIgnoreCase("1 day"))
		{
			for(int s=sel;s>=0;s--)
			{
				Date dt_temp = new Date(egDt.egetDateUS());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				String sdate = egDt.egetDateUS(l_temp -(long)(s* msecsPerDays));
				String stime=sdate.substring(sdate.indexOf(' ')+1);
				sdate=sdate.substring(0,sdate.indexOf(' '));

				Integer value=(Integer)finalData.get(sdate);
				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();
				if(s==sel)
				{
					lastDayDate=month+"/"+day+"/"+year;
					finalData.remove(sdate);
					continue;
				}

				if(qcount==0)
				{
					qcount++;
					StringTokenizer timetoken=new StringTokenizer(stime,":");
					hours=timetoken.nextToken();
					minutes=timetoken.nextToken();
					String seconds=timetoken.nextToken();
					shours="0";
					sminutes="0";
					changeStartDate=month+"/"+day+"/"+year+" 00:00";
				}
				else
					changeEndDate=month+"/"+day+"/"+year+" "+hours+":"+minutes;

				dateCount.add(month+"/"+day+"/"+year);
		
				String st="";
				if (value==null)
					st="0";
				else
					st=value.toString();
				
				//sdate=sdate.substring(0,sdate.lastIndexOf('/'));
				sdate=DateUtil.changeDateFormat(sdate,"MM/dd/yyyy",currentDateFormat);
				sdate=sdate.replace(',',' ');
				if (s==sel-1)
				{
					sampleValues=""+st;
					barLabels=sdate;
				}
				else
				{
					sampleValues=sampleValues+","+st;
					barLabels=barLabels+","+sdate;
				}
			}
		}
		else
		{ // if day is one
			for(int s=1;s>=0;s--)
			{
				Date dt_temp = new Date(egDt.egetDateUS());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				String sdate = egDt.egetDateUS(l_temp -(long)(s* msecsPerDays));
				String stime=sdate.substring(sdate.indexOf(' ')+1);
				sdate=sdate.substring(0,sdate.indexOf(' '));
				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();
				if (s==0)
				{
					StringTokenizer timetoken=new StringTokenizer(stime,":");
					hours=timetoken.nextToken();
					minutes=timetoken.nextToken();
					eDate=month+"/"+day+"/"+year;
					changeEndDate=eDate+" "+hours+":"+minutes;

				}
				else
				{
					StringTokenizer timetoken=new StringTokenizer(stime,":");
					hours=timetoken.nextToken();
					minutes=timetoken.nextToken();
					sDate=month+"/"+day+"/"+year;
					changeStartDate=sDate+" "+hours+":"+minutes;
				}
				
				shours=hours;
				sminutes=minutes;
			}
			
			Iterator hourCount=finalData.keySet().iterator();
			while(hourCount.hasNext())
			{
				String dateWithHour=(String)hourCount.next();
				Integer count=(Integer)finalData.get(dateWithHour);
				String stime=dateWithHour.substring(dateWithHour.indexOf('$')+1);
				String sdate=dateWithHour.substring(0,dateWithHour.indexOf('$'));
				Integer itValue=new Integer(stime);
				int timeHour=itValue.intValue();

				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();
				
				dateCount.add(month+"/"+day+"/"+year+"$"+stime);
				sdate=sdate.substring(0,sdate.lastIndexOf('/'));
				if (qcount==0)
				{
					qcount++;
					sampleValues=""+count.toString();
					/*if(timeHour==23)
						barLabels=sdate+" "+stime+":00 - "+timeHour+":59";
					else
						barLabels=sdate+" "+stime+":00 - "+(timeHour+1)+":00";*/
					barLabels=stime;
				}
				else
				{
					sampleValues=sampleValues+","+count.toString();
					/*if(timeHour==23)
						barLabels=sdate+" "+stime+":00 - "+timeHour+":59";
					else
						barLabels=barLabels+","+sdate+" "+stime+":00 - "+(timeHour+1)+":00";*/
					barLabels=barLabels+","+stime;
				}
			}
			sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Hourly Changes");
		}
	}
	
	int totalCount=0;
	Object[] keySet2 =finalData.keySet().toArray();
	int maxCount=0;
	for (int z=0; z<keySet2.length; z++)
	{
		String dateValue= (String)keySet2[z];
		if(dateValue.equalsIgnoreCase(lastDayDate))
			continue;
		Integer states = (Integer)finalData.get(dateValue);		//Individual states
		int size=states.intValue();
		totalCount=totalCount+size;
		maxCount = Math.max(maxCount, size);
	}

	String chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + totalCount;

	boolean goBack = false;
	if (request.getParameter("request_from")!=null)
	{
		goBack = true;
	}
%>

<html>
<head>
<!-- <link rel="stylesheet" href="/final/config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript">
	function goTo()
	{
		var thisForm=document.weekChanges;
		var serverType = thisForm.serverTypes.options[thisForm.serverTypes.options.selectedIndex].value;
		var days= thisForm.durationDays.options[thisForm.durationDays.options.selectedIndex].value;
		if(serverType!=-1)
		{
			window.location.href="/final/config/EcWeeklyChanges.jsp?serverTypes="+serverType+"&selectionDuration="+days;
			document.weekChanges.submt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.weekChanges.submt.disabled=true;
		}
		else
		{
			alert('<egui:intnl text="configmgmt.changes.daywise.Please select a component type" />');
			return;
		}
	}

	function print()
	{
<%
	if (finalData == null || finalData.size() == 0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("printType=DAYWISE_DISTRIBUTION");
	printQS.append("&Page=daywise");		//Decide file to display for print in the controller
	printQS.append("&printPageTitle="+mappingInfo.getTextDescription("configmgmt.changes.daywise.Daywise Change Distribution"));
	printQS.append("&printData=yes");
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>";
		printwin = parent.openWindow(s_qryString,"PrintWindow","width=792,height=464,left=0,top=85,scrollbars=1,scrollbars=yes,resizable");
	}

	function savePdf()
	{
<%
	if (finalData == null || finalData.size() == 0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
	if (finalData == null || finalData.size() == 0)
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
		sendMail();
	}

</script>

</head>
<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" >
<form name="weekChanges" style="margin:0px">

<table width="100%" align="center" border="0" cellpadding="0" cellspacing="0" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGES" /> : <egui:intnl text="configmgmt.changes.daywise.DAYWISE DISTRIBUTION" /></b>
					</td>
<%
	if (goBack)
	{
%>
					<td class="body_text" align="right" width="5%">
						<a id='mouse' onClick="javascript:history.back();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
					</td>
<%
	}
%>
				</tr>
			</table>
		</td>
	</tr>
	
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="table-layout:fixed" id="text_bold"> <col width="150"><col width="150"><col width="10"><col width="200"><col width="100"><col width="10"><col width="150"><col width="150">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp;</td>
										</tr>
										<tr height="20"> 
											<td  align="center">&nbsp;</td>
											<td align="right" ><egui:intnl text="configmgmt.changes.detailed.Component Type"/></td>
											<td  align="center">:</td>
											<td >
												<select name="serverTypes">
<%//=ecUtils.fillSelectBox(serverTypes,"",server)%> 
<%
	if (serverTypes != null && !serverTypes.isEmpty())
	{
		for(int i=0; i<serverTypes.size(); i++)
		{
			String componentTypeTmp = (String)serverTypes.get(i);
			if (componentTypeTmp.equalsIgnoreCase("All"))
			{
%>
														<option value="<%=componentTypeTmp%>" <%=(server != null && componentTypeTmp.equals(server))?"selected":""%>>
														<egui:intnl text="configmgmt.changes.daywise.All" />
														</option>
<%
			}
			else
			{
				serverList.add(componentTypeTmp);
			}
		}
		serverList = sorter.getSortedCompTypeList(serverList);
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();
			String selected = "";
			if(server != null && actualName.equals(server))
			{
				selected = "selected";
			}
%>
														<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.changes.daywise.Not Applicable" />
													</option>
<%
	}
%>
												</select>
											</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.changes.detailed.Timeline"/></td>
											<td align="center">:</td>
											<td>
												<select name="durationDays">
<%//=ecUtils.fillDashboardSelectZoom(countWeek)%>
<%
	for (int u=0;u<options.length;u++)
	{
		String strOption = options[u];

		String selected = "";
		if (strOption.equals(countWeek))
			selected = "selected";
		
		String strValue = strOption.substring(0,strOption.indexOf(" "));
		String strText = strOption.substring(strOption.indexOf(" ")+1);
%>
					<option value="<%=options[u]%>" <%=selected%>>
						<%=strValue%> <egui:intnl text='<%="configmgmt.common."+strText%>' />
					</option>
<%
	}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td  align="center">&nbsp;</td>
											<td align="center" colspan="6" valign="middle" height="20"> 
											<input type="button" name="submt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height:20px;" onClick="javascript:goTo()">
											<td align="right"  colspan="1" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:print()"> </td>

														<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

														<td width="13" align="center" id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

														<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>

<%
	String tempTime = null;
	String tempDate = null;
	//date format for start date
	if(changeStartDate != null && !changeStartDate.equals(""))
	{
		tempDate = changeStartDate.substring(0,changeStartDate.lastIndexOf(" "));
		tempTime = changeStartDate.substring(changeStartDate.lastIndexOf(" ")+1);
	}
	if(tempDate != null)
	{
		changeStartDate = DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",currentDateFormat);
		changeStartDate = changeStartDate +" " + tempTime;
	}

	//date format for end date
	tempTime = null;
	tempDate = null;
	if(changeEndDate != null && !changeEndDate.equals(""))
	{
		tempDate = changeEndDate.substring(0,changeEndDate.lastIndexOf(" "));
		tempTime = changeEndDate.substring(changeEndDate.lastIndexOf(" ")+1);
	}
	if(tempDate != null){
		changeEndDate = DateUtil.changeDateFormat(tempDate,"MM/dd/yyyy",currentDateFormat);
		changeEndDate = changeEndDate +" " + tempTime;
	}
%>
				
				<tr>
					<td id="padding6" height="100%" width="100%" style="padding-top:0px">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if(changeStartDate != null && !changeStartDate.equals(""))
	{
%>
							<tr>
								<td align="center" width="100%" height="5%" valign="top" class="bgwhite">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
											<td align="center" width="80%" class="tdbackcolortop" id="white_content"><b><egui:intnl text="configmgmt.changes.daywise.Start Date" />&nbsp:&nbsp;<%=changeStartDate != null ? changeStartDate : ""%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="configmgmt.changes.daywise.End Date" />&nbsp;:&nbsp;<%=changeEndDate != null ? changeEndDate : ""%></b>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}

	if ((finalData!=null && finalData.size()>0)&& serverTypes!=null && serverTypes.size()>0)
	{
		String barWidth="0.3";
		String barLabelAngle="290";
		if(sel<7 && !countWeek.equalsIgnoreCase("1 day"))
		{
			barWidth="0.2";
			barLabelAngle="360";
		}
		//start print information
		printData.setChartTitle(chartTitle);
		printData.setStartDate(changeStartDate);
		printData.setEndDate(changeEndDate);
		printData.setSampleValue(sampleValues);
		printData.setSampleAxisLabel(sampleAxisLabel);
		printData.setBarLabel(barLabels);
		printData.setMaxRange(String.valueOf(maxCount));
		printData.setComponent(server);
		printData.setBarLabelAngle(barLabelAngle);
		//printData.setBarWidth(barWidth);
		session.setAttribute("DAYWISE_DISTRIBUTION",printData);
		// end print information
%>
							<tr>
								<td width="100%" align="center">
				<applet code="com.objectplanet.chart.ChartApplet" width="825" height="380" align="center" codebase="/final/reporter" archive="chart.jar">
					<param name="chart" value="bar">
					<param name="chartTitle" value="<%=chartTitle%>">
					<param name=titleFont value="verdana,bold,10">
					<param name="sampleValues" value="<%=sampleValues%>">
					<param name="sampleColors" value="<%=barColor%>">
					<param name="sampleLabelStyle" value="inside">
					<param name="valueLabelsOn" value="true">
					<param name="valueLabelstyle" value="outside">
					<param name="valueLabelFont" value="verdana,bold,11">
					<param name="barLabels" value="<%=barLabels%>">
					<param name="AutoLabelsSpacingon" value="true">
					<param name="barLabelsOn" value="true">
					<param name="barLabelAngle" value="<%=barLabelAngle%>">
					<param name="barLabelFont" value="verdana,normal,11">
					<param name="zoomon" VALUE="true">
					<param name="3DModeOn" value="true">
					<param name=3DDepth value="10">
					<param name=multiSeriesOn value="true">
					<param name="range" value="<%=maxCount%>">
					<param name="lowerrange" value="0">
					<param name="autoLabelSpacingOn" value="true">
					<param name=rangeAdjusterOn value="true">
					<param name = "sampleScrollerOn" value="true">
<%
		StringTokenizer strTokens = new StringTokenizer(sampleValues,",");
		ArrayList aListSampleValues = new ArrayList();
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken();
			aListSampleValues.add(strToken);
		}

		for (int s=0;s<dateCount.size();s++)
		{
			int countDisp=dateCount.size()-1;
			String dateValue=(String)dateCount.get(s);
			String timeZone="";
			String changeCount = (String)aListSampleValues.get(s);
			String tempStartDate = "";
			String tempEndDate = "";
			if(s==dateCount.size()-1)
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminutes)%>&ec_endmin=<%=URLEncoder.encode(minutes)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&ec_viewchange=byDate&selectDate=<%=URLEncoder.encode(dateValue)%>&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="_self">
<%
				}
			}
			else if(s==0)
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminutes)%>&ec_endmin=<%=URLEncoder.encode(minutes)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&ec_viewchange=byDate&selectDate=<%=URLEncoder.encode(dateValue)%>&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="_self"> 
<%
				}
			}
			else
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminutes)%>&ec_endmin=<%=URLEncoder.encode(minutes)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&ec_viewchange=byDate&selectDate=<%=URLEncoder.encode(dateValue)%>&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="_self"> 
<%
				}
			}
		}
%>
					<param name="sampleAxisLabel" value="<%=sampleAxisLabel%>">
					<param name="sampleAxisLabelFont" value="verdana,normal,11">
					<param name="rangeAxisLabel" value='<egui:intnl text="configmgmt.changes.daywise.No of changes" />'>
					<param name="rangeAxisLabelFont" value="verdana,normal,11">
					<!-- <param name="samplelabelspacingon" value="true"> -->
					<param name="barOutlineOff" value="true">
					<param name="bartype" value="stacked">
					<param name="rangeAxisLabelAngle" value="270">
					<!-- <param name="seriescount" value="2"> -->
					<param name="valueLinesOn" value="true">
					<param name="depth" value="0.3">
					<param name="barwidth" value="<%=barWidth%>">
					<param name="singleClickURLOn" value="true">
					<param name="background" value="white">
				</applet>
								</td>
							</tr>
<%
		//For New Pdf Framework - Krishnamurthi
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String mainTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGES");
		mainTitle = mainTitle + " - " + mappingInfo.getTextDescription("configmgmt.changes.daywise.DAYWISE DISTRIBUTION");
		reportAttributes.setMainTitle(mainTitle);

		String subTitle = "";
		if (!server.equalsIgnoreCase("All"))
		{
			subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(server);
		}
		else
		{
			subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.All Components");
		}
		subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.summary.Between") + " " + changeStartDate + " " + mappingInfo.getTextDescription("configmgmt.changes.summary.and") + " " + changeEndDate;
		reportAttributes.setSubTitle(subTitle);

		reportAttributes.setReportName("DaywiseChangeDistribution");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(false);
		
		pdfData.setAttributes(reportAttributes);

		EgTableAttributes egTableAttributes = new EgTableAttributes();
		egTableAttributes.setImageData(true);

		ArrayList aListColumnNames = new ArrayList();
		ArrayList aListData = new ArrayList();

		aListColumnNames.add("C0");
		aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=DAYWISE_DISTRIBUTION&chartType=bar&height=435&width=780&chartTitle="+URLEncoder.encode(chartTitle)+"&sampleValues="+URLEncoder.encode(sampleValues)+"&barLabels="+URLEncoder.encode(barLabels)+"&range="+URLEncoder.encode(String.valueOf(maxCount))+"&barLabelAngle="+URLEncoder.encode(barLabelAngle)+"&sampleAxisLabel="+URLEncoder.encode(sampleAxisLabel)+"&userName="+URLEncoder.encode(userName));

		EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);

		EgTable egTable = new EgTable();
		egTable.setModel(egTableModel);
		egTable.setAttributes(egTableAttributes);

		aListPdfData.add(egTable);

		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if(server!=null)
	{
%>
							<tr>
								<td align="center" valign="middle" width="100%" height="400">
									<table border="0" align="center" width="100%"  height="100%" cellpadding="0" cellspacing="0">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"> <b><egui:intnl text="configmgmt.changes.detailed.There were no configuration changes in the selected timeline" /></b></td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<tr>
								<td align="center" valign="middle" width="100%" height="400">
									<table border="0" align="center" width="100%" height="100%" cellpadding="0" cellspacing="0">
										<tr>
											<td align="center">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>

</form>
</body>
</html>



