<%
/*
 *   File				:	EcSaveSchedule.jsp
 *   Purpose			:	to save scheduling details
 *   Creation Date		:	22/06/2006
 *   Author				:	Balasigamani, Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage = "EcProbs.jsp"%>
<%@page import="egurkha.config.*"%>
<%@page import="java.util.*"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgName"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	private String encodeParameters(String queryString)
	{
		HashMap hmapParams = new HashMap();

		HashMap hashMapParameters = EcUtils.parseQueryString(queryString);
		Iterator parameter_keys = hashMapParameters.keySet().iterator();
		while (parameter_keys.hasNext())
		{
			String key_parameter = (String)parameter_keys.next();
			Object temp = (Object)hashMapParameters.get(key_parameter);
			if (key_parameter != null && key_parameter.equals("ec_component"))
			{
				String components[] = null;
				if (temp instanceof String)
				{
					components = new String[]{(String)temp};
				}
				else if (temp instanceof String[])
				{
					components = (String[])temp;
				}

				int compsLength = components.length;
				String[] strArray = new String[compsLength];

				for (int i=0;i<compsLength;i++)
				{
					String strComp = components[i];
					try
					{
						strComp = EgURLEncoder.encode(strComp,"UTF-8");
					}
					catch (Exception e)
					{
					}
					strArray[i] = strComp;
				}
				hmapParams.put(key_parameter,strArray);
			}
			else if (key_parameter != null && 
					(key_parameter.equals("ec_option2") || 
					key_parameter.equals("ec_userOption") || 
					key_parameter.equals("ec_userOptionPrevious") || key_parameter.equals("userName")))
			{
				String strComponent = (String)temp;
				try
				{
					strComponent = EgURLEncoder.encode(strComponent,"UTF-8");
				}
				catch (Exception e)
				{
				}
				hmapParams.put(key_parameter,strComponent);
			}
			else
			{
				hmapParams.put(key_parameter,temp);
			}
		}

		String strQueryString = EcUtils.prepareQueryString(hmapParams);
		return strQueryString;
	}
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String schedulePrintFlag = configTestsInfo.getMiscArgsValue("EnableSchedulePrint");
	boolean isSchedulePrintEnabled = false;
	if (schedulePrintFlag != null)
	{
		if (schedulePrintFlag.equalsIgnoreCase("true") || schedulePrintFlag.equalsIgnoreCase("yes"))
		{
			isSchedulePrintEnabled = true;
		}
	}

	long sch_id = 0;
	String sch_name = "";
	String sch_mailFreq = "None";
	String sch_printFreq ="None";
	String sch_mail_id="";
	java.util.Map sch_details = null;

	String [] hours1 = {"00","01","02","03","04","05","06","07","08","09","10","11","12","13","14","15","16","17","18","19","20","21","22","23"};
	String [] minutes1 =  {"00","05","10","15","20","25","30","35","40","45","50","55"};
	String strHours = "0";
	String strMin = "00";
	String sch_mailon = "";
	String sch_printon = "";
	String schedule_on = "";

	String request_from = request.getParameter("request_from");

	EcScheduleTask task = (EcScheduleTask) request.getAttribute("ScheduleTask");
	if(task != null)
	{
		sch_id = task.getScheduleId();
		sch_name = task.getName();
		sch_mailFreq = task.getMailFrequency();
		sch_printFreq = task.getPrintFrequency();
		sch_mail_id = (task.getMailId()==null)?"":task.getMailId();
		sch_mailon = task.getMailDay();
		sch_printon = task.getPrintDay();
		schedule_on = task.getScheduleType();
		strHours = task.getScheduleRunAtHr();
		strMin = task.getScheduleRunAtMin();
		
		if(sch_printon==null)
			sch_printon="";

		if(sch_printFreq.indexOf("#")>-1)
			sch_printFreq=sch_printFreq.substring(0,sch_printFreq.indexOf("#"));

		if (sch_mailFreq.indexOf("#")>-1)
			sch_mailFreq=sch_mailFreq.substring(0,sch_mailFreq.indexOf("#"));


		//sch_details = task.getDetails();
		Map schDet = task.getDetails();
		sch_details = new HashMap(schDet);
	}
	else
	{
		//sch_details = request.getParameterMap();
		Map schDet = request.getParameterMap();
		sch_details = new HashMap(schDet);

		//to show schedule details when click on add to schedules icon when button is in save mode
		String temp_Schid = request.getParameter("id");
		if (temp_Schid != null && !temp_Schid.equalsIgnoreCase("null") && temp_Schid.length() > 0)
		{
			long tempsch_id = Long.parseLong(temp_Schid);
			EcScheduleTask temp_task = EcScheduleTask.getScheduleTask(tempsch_id);
			sch_id = temp_task.getScheduleId();
			sch_name = temp_task.getName();
			sch_mailFreq = temp_task.getMailFrequency();
			sch_printFreq = temp_task.getPrintFrequency();
			sch_mail_id = (temp_task.getMailId() == null)?"":temp_task.getMailId();
			sch_mailon = temp_task.getMailDay();
			sch_printon = temp_task.getPrintDay();
			schedule_on = temp_task.getScheduleType();
			strHours = temp_task.getScheduleRunAtHr();
			strMin = temp_task.getScheduleRunAtMin();
			if (temp_Schid != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
				sch_details = temp_task.getDetails();
			}
		}
		//ends

		String typeName[]=(String[])schDet.get("ec_rtype");
		if("Change".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

			String option1[] = (String[])schDet.get("ec_option1");
			if (option1[0].equals("Component Type") || option1[0].equals("All Components"))
			{
				ArrayList al_temp = new ArrayList();

				if (option1[0].equals("Component Type"))
				{
					String[] option2 = (String[])schDet.get("ec_option2");
					ArrayList aListTemp = user.getServersForType(option2[0]);
					for (int k=0;k<aListTemp.size();k++)
					{
						String strComp = (String)aListTemp.get(k);
						if (!aListAssociatedComponents.contains(strComp)) continue;
						al_temp.add(strComp);
					}
				}
				else
				{
					al_temp.addAll(aListAssociatedComponents);
				}

				for(int i=0;i<al_temp.size();i++)
				{
					String s_component = (String)al_temp.get(i);
					String component_type = s_component.substring(0,s_component.indexOf(":"));
					boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
					if(!isConfigTestEnabled) continue;
					String component_name = s_component.substring(s_component.indexOf(":")+1);
					vList.add(component_name+":"+component_type);
				}
			}
			else if (option1[0].equals("Component Name"))
			{
				String[] option2 = (String[])schDet.get("ec_option2");
				vList.add(option2[0]);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("OSInventory".equalsIgnoreCase(typeName[0]) || "BoxView".equalsIgnoreCase(typeName[0]) || "compsView".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("SoftwareAvailability".equalsIgnoreCase(typeName[0]) || "ServiceAvailability".equalsIgnoreCase(typeName[0]) || "HotfixAvailability".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("ServiceStatus".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("DiskCapacity".equalsIgnoreCase(typeName[0]) || "RAMCapacity".equalsIgnoreCase(typeName[0]) || "ServicePack".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("SystemManufacturer".equalsIgnoreCase(typeName[0]) || "Processor".equalsIgnoreCase(typeName[0]) || "IPAddress".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("DefaultGateway".equalsIgnoreCase(typeName[0]) || "Printer".equalsIgnoreCase(typeName[0]) || "DaywiseChanges".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("ChangesByComponentName".equalsIgnoreCase(typeName[0]) || "ChangesByComponentType".equalsIgnoreCase(typeName[0]) || "Consolidated".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("ec_component",mappingComponent);
		}
		else if("CitrixApplicationsAndUsers".equalsIgnoreCase(typeName[0]))
		{
			String[] mappingComponent = null;
			List vList = new Vector();
			ArrayList al_temp = new ArrayList();

			ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
			al_temp.addAll(aListAssociatedComponents);

			for(int i=0;i<al_temp.size();i++)
			{
				String s_component = (String)al_temp.get(i);
				String component_type = s_component.substring(0,s_component.indexOf(":"));
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if(!isConfigTestEnabled) continue;
				String component_name = s_component.substring(s_component.indexOf(":")+1);
				vList.add(component_type+":"+component_name);
				//vList.add(component_name+":"+component_type);
			}

			mappingComponent = new String[vList.size()];
			mappingComponent = (String[])vList.toArray(new String[0]);
			sch_details.put("associatedComponents",mappingComponent);
		}

		if (temp_Schid == null || temp_Schid.equalsIgnoreCase("null") || temp_Schid.length() == 0)
		{
			String tmpMailId = EcScheduleTask.getMailID(urs);
			if(tmpMailId != null && tmpMailId.trim().length() != 0)
			{
				StringTokenizer st=new StringTokenizer(tmpMailId,",",false);
				StringBuffer sb_sch_mail_id=new StringBuffer();
				while(st.hasMoreTokens())
				{
					String s=st.nextToken();

					if (s.toLowerCase().startsWith("cc:") || s.toLowerCase().startsWith("bcc:"))
					{
						continue;
					}
					else if (s.toLowerCase().startsWith("to:"))
					{
						s =  s.substring(3);
					}

					if(s.indexOf("@")>-1)
					{
						sb_sch_mail_id.append(s).append(",");
					}
				}
				if(sb_sch_mail_id.length()>0)
				{
					sch_mail_id=sb_sch_mail_id.deleteCharAt(sb_sch_mail_id.length()-1).toString();
				}
			}
		}
	}

	if(schedule_on == null || schedule_on.length()==0)
	{
		schedule_on = "DayEnd";
	}

	sch_details.put("user_language",userLanguage);
	
	EcReportParam ecReportParam = new EcReportParam(sch_details);
	Vector detail = ecReportParam.getSelectionDetails();

	String reportType = ecReportParam.getReportType();

	boolean showModifyLink = false;
	if (sch_id > 0)
	{
		showModifyLink = true;
	}

	String strQueryString = EcUtils.prepareQueryString(sch_details);
	strQueryString = encodeParameters(strQueryString);
	String osName = "";

	boolean isSoftware = false;
	if ("SoftwareAvailability".equalsIgnoreCase(request_from) || "Software Availability/UnAvailability".equalsIgnoreCase(reportType))
	{
		isSoftware = true;
		if ("ViewSchedulePage".equalsIgnoreCase(request_from) || "saveSchedule".equalsIgnoreCase(request_from))
		{
			osName = (String) sch_details.get("osName");
		}
		sch_details.put("view","Software");
	}

	boolean isService = false;
	if ("ServiceAvailability".equalsIgnoreCase(request_from) || "Service Availability/UnAvailability".equalsIgnoreCase(reportType))
	{
		isService = true;
		if ("ViewSchedulePage".equalsIgnoreCase(request_from) || "saveSchedule".equalsIgnoreCase(request_from))
		{
			osName = (String) sch_details.get("osName");
		}
		sch_details.put("view","Service");
	}

	boolean isHotfix = false;
	if ("HotfixAvailability".equalsIgnoreCase(request_from) || "Hotfix/Patch Availability/UnAvailability".equalsIgnoreCase(reportType))
	{
		isHotfix = true;
		if ("ViewSchedulePage".equalsIgnoreCase(request_from) || "saveSchedule".equalsIgnoreCase(request_from))
		{
			osName = (String) sch_details.get("osName");
		}
		sch_details.put("view","Hotfix");
	}

	boolean isServiceStatus = false;
	if ("ServiceStatus".equalsIgnoreCase(request_from) || "Inventory by service status".equalsIgnoreCase(reportType))
	{
		isServiceStatus = true;
		osName = (String) request.getParameter("os");
	}

	boolean isDiskCapacity = false;
	String rangeOption = "";
	String startRange = "";
	String endRange = "";
	if (("DiskCapacity".equalsIgnoreCase(request_from) || "Distribution of managed systems by hard disk capacity".equalsIgnoreCase(reportType) || "RAMCapacity".equalsIgnoreCase(request_from) || "Distribution of managed systems By RAM size".equalsIgnoreCase(reportType)) && !"ViewSchedulePage".equalsIgnoreCase(request_from))
	{
		rangeOption = (String) request.getParameter("limit");
		startRange = (String) request.getParameter("start");
		endRange = (String) request.getParameter("end");
		isDiskCapacity = true;
		sch_details.put("startRange",startRange);
		sch_details.put("endRange",endRange);
	}
	if ("FromModify".equalsIgnoreCase(request_from))
	{
		rangeOption = (String) request.getParameter("limit");
		startRange = (String) request.getParameter("start");
		endRange = (String) request.getParameter("end");
		isDiskCapacity = true;
		sch_details.put("startRange",startRange);
		sch_details.put("endRange",endRange);
	}
	if ("ViewSchedulePage".equalsIgnoreCase(request_from))
	{
		rangeOption = (String) sch_details.get("rangeOption");
		startRange = (String) sch_details.get("startRange");
		endRange = (String) sch_details.get("endRange");
		isDiskCapacity = true;
		sch_details.put("startRange",startRange);
		sch_details.put("endRange",endRange);
	}

	boolean isIPAllocation = false;
	if ("IPAddress".equalsIgnoreCase(request_from) || "Managed systems with static and dynamic IP address allocation".equalsIgnoreCase(reportType))
	{
		isIPAllocation = true;
		osName = request.getParameter("osName");
	}

	boolean isdefaultGateway = false;
	String ipAddress = "";
	if ("DefaultGateway".equalsIgnoreCase(request_from) || "Managed systems configured with gateway routers".equalsIgnoreCase(reportType))
	{
		isdefaultGateway = true;
		ipAddress = request.getParameter("ipAddress");
	}

	boolean isconfiguredPrinter = false;
	String showOutput = "";
	String printerDefault = "";
	String defaultPrinter = "";
	if ("Printer".equalsIgnoreCase(request_from) || "Configured Printers".equalsIgnoreCase(reportType))
	{
		isconfiguredPrinter = true;
		showOutput = request.getParameter("showOutput");
		printerDefault = request.getParameter("printerDefault");
		if(printerDefault != null && printerDefault.equalsIgnoreCase("ON"))
		{
			defaultPrinter = "True";
		}
		else
		{
			defaultPrinter = "False";
		}
		sch_details.put("defaultPrinter",defaultPrinter);
	}
	
%>

<html>
<title><egui:intnl text="configmgmt.schedule.Schedule" /></title>
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="/final/config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/final/monitor/eg_scripts/ajaxutils.js"></script>
<script language="JavaScript">
	function goTo()
	{
		var thisform = document.Ecschedule;
		var schName=thisform.sch_name.value;
		if(!validateTextBox(thisform.sch_name))
		{
			thisform.sch_name.focus();
			return;
		}
		//else if(schName.lastIndexOf("_cf")==-1)
		//{
		//	alert('<egui:intnl text="configmgmt.schedule.Schedule name should end with _cf" />');
		//	thisform.sch_name.focus();
		//	return;
		//}
		else if(thisform.mail_freq.value != "None")
		{
			if(!checkmultiplemailid(thisform.mail_id))
			{
				thisform.mail_id.focus();
				return;
			}
		}
		else if(thisform.print_freq == null && thisform.mail_freq.value == "None")
		{
			alert('<egui:intnl text="configmgmt.schedule.Select Mail option" />');
			return;
		}
		else if(thisform.print_freq.value == "None")
		{
			alert('<egui:intnl text="configmgmt.schedule.Select Mail or Print" />');
			thisform.mail_freq.focus();
			return;
		}
		thisform.submit();
		thisform.ec_select.value='<egui:intnl text="configmgmt.schedule.Saving" />'+'...';
		thisform.ec_select.disabled=true;
	}

	function load()
	{
		goTo2();
		document.Ecschedule.sch_name.focus();
	}

	function scheduleOn()
	{
		var thisForm = document.Ecschedule;
		if(thisForm!=null)
		{
			var val = thisForm.schedule_held_on.value;
			var mail_freq = thisForm.mail_freq.value;
		}
		document.getElementById("timescale").style.display = "none";
		var tdObj1  = document.getElementById("scheduleTd1");
		var tdObj2  = document.getElementById("scheduleTd2");
		var tdObj3  = document.getElementById("scheduleTd3");

		if(val == "AnyTime")
		{
			if (bw.ie6 || bw.ie7)
			{
				document.getElementById("timescale").style.display = "block";
			}
			else
			{
				document.getElementById("timescale").style.display = "table-row";
			}
			tdObj1.className = "cell_border";
			tdObj2.className = "cell_border";
			tdObj3.className = "cell_border";
		}
		else
		{
			tdObj1.className = "";
			tdObj2.className = "";
			tdObj3.className = "";
		}
	}

	function goTo2(selctionObj)
	{
		if (selctionObj != null)
		{
			document.Ecschedule.mail_id.disabled=selctionObj.value=='None';
		}
		var thisform = document.Ecschedule;
	
		if (thisform.mail_freq.value=="Weekly")
		{
			
			if (bw.ie6 || bw.ie7)
			{
				document.getElementById("mail_on").style.display="block";
			}
			else
			{
				document.getElementById("mail_on").style.display="table-row";
			}
		}
		else
		{
			document.getElementById("mail_on").style.display="none";
		}
		var isPrintEnb = "<%=isSchedulePrintEnabled%>";
		if(isPrintEnb == "true")
		{
			var tdObj1  = document.getElementById("printTd1");
			var tdObj2  = document.getElementById("printTd2");
			var tdObj3  = document.getElementById("printTd3");

			if (thisform.print_freq.value=="Weekly")
			{
				if (bw.ie6 || bw.ie7)
				{
					document.getElementById("print_on").style.display="block";
				}
				else
				{
					document.getElementById("print_on").style.display="table-row";
				}
				tdObj1.className = "cell_border";
				tdObj2.className = "cell_border";
				tdObj3.className = "cell_border";
			}
			else
			{
				document.getElementById("print_on").style.display="none";
				tdObj1.className = "";
				tdObj2.className = "";
				tdObj3.className = "";
			}
		}
		scheduleOn();
	}

	function modifyDetails(sch_id,reportType) // to modify the details
	{
		var thisForm = document.Ecschedule;
		thisForm.action = "../servlet/com.eg.EcSchedulerC?cmd=Show&id="+sch_id+"&reportType="+encodeURIComponent(reportType);
		thisForm.submit();
	}

	function goBackToViewSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcViewSchedule.jsp";
		thisForm.submit();
	}

	function goBack()
	{
		var thisForm = document.forms[0];
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?<%=strQueryString%>&back_request=ScheduleConfig";
		thisForm.submit();
	}

</script>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0"  onLoad="load()">
<form name="Ecschedule" action="/final/servlet/com.eg.EcSchedulerC?cmd=Save" method="Post" onSubmit="return false;" style="margin:0px">
<%
	if (isSoftware)
	{
%>
	<input type="hidden" name="osName" value="<%=osName%>">
	<input type="hidden" name="view" value="Software" >
<%
	}
	if (isService)
	{
%>
	<input type="hidden" name="osName" value="<%=osName%>">
	<input type="hidden" name="view" value="Service" >
<%
	}
	if (isHotfix)
	{
%>
	<input type="hidden" name="osName" value="<%=osName%>">
	<input type="hidden" name="view" value="Hotfix" >
<%
	}
	if (isServiceStatus)
	{
%>
	<input type="hidden" name="flagValue" value="MenuServices" >
	<input type="hidden" name="osName" value="<%=osName%>">
<%
	}
	if (isDiskCapacity)
	{
%>
	<input type="hidden" name="rangeOption" value="<%=rangeOption%>">
	<input type="hidden" name="startRange" value="<%=startRange%>">
	<input type="hidden" name="endRange" value="<%=endRange%>">
<%
	}
	if (isIPAllocation)
	{
%>
	<input type="hidden" name="osName" value="<%=osName%>">
<%
	}
	if (isdefaultGateway)
	{
%>
	<input type="hidden" name="ipAddress" value="<%=ipAddress%>">
<%
	}
	if (isconfiguredPrinter)
	{
%>
	<input type="hidden" name="showOutput" value="<%=showOutput%>">
	<input type="hidden" name="printerDefault" value="<%=printerDefault%>">
	<input type="hidden" name="defaultPrinter" value="<%=defaultPrinter%>">
<%
	}
%>
<input type="hidden" name="details" 
value="<%=egurkha.config.EcUtils.prepareQueryString(sch_details)%>">
<input type="hidden" name="id" value="<%=sch_id%>" >
<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" class="cellborder" id="body_text" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="padding5">
				<tr>
					<td align="left" id="main_head_top" width="95%" nowrap>
						&nbsp;<b><egui:intnl text="configmgmt.schedule.SAVE SCHEDULES" /></b>
					</td>
<%
	if (request_from != null && request_from.equalsIgnoreCase("ViewSchedulePage"))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:history.back();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
					<td class="body_text" align="right" width="7%">
						<a id='mouse' onClick="javascript:goBackToViewSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
					</td>
<%
	}
	else if (request_from != null && 
			(request_from.equalsIgnoreCase("Current") || request_from.equalsIgnoreCase("Change")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("OSInventory") || request_from.equalsIgnoreCase("BoxView") || request_from.equalsIgnoreCase("compsView")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("SoftwareAvailability") || request_from.equalsIgnoreCase("ServiceAvailability") || request_from.equalsIgnoreCase("HotfixAvailability") || request_from.equalsIgnoreCase("ServiceStatus")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("DiskCapacity") || request_from.equalsIgnoreCase("RAMCapacity") || request_from.equalsIgnoreCase("ServicePack")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("SystemManufacturer") || request_from.equalsIgnoreCase("Processor") || request_from.equalsIgnoreCase("IPAddress")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("DefaultGateway") || request_from.equalsIgnoreCase("Printer") || request_from.equalsIgnoreCase("DaywiseChanges")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("ChangesByComponentName") || request_from.equalsIgnoreCase("ChangesByComponentType")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
	else if (request_from != null && (request_from.equalsIgnoreCase("Consolidated") || request_from.equalsIgnoreCase("CitrixApplicationsAndUsers")  || request_from.equalsIgnoreCase("currentConfig")))
	{
%>
					<td  align="right" width="5%"><a id='mouse' onClick="javascript:goBack();"><img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp; </a>
					</td>
<%
	}
%>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td valign="top" id="" class="bglight" width="100%" >
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" >
				<tr>
					<td align="center" class="padding6" valign="top">
						<table width="100%" border="0" height="100%" cellpadding="0" cellspacing="0" class="body_text" id="toptable" >
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
							<tr>
								<td align="center"  valign="top">
									<table width="50%" border="0"  cellpadding="6" cellspacing="0" >
										<tr>
											<td >
												<table width="100%" border="0"  cellpadding="0" cellspacing="0" class="body_text bglightlight">
<%
	String s_error = (String)request.getAttribute("ERROR");
	if(s_error!=null)
	{
%>
													<tr height="26" id="blackcontent" class="cellbg">
														<td colspan="3" style="color:red;font-size:12">
															<img src = "/final/config/images/warning.gif" align = "left">&nbsp;
															<div valign="middle" ><%=s_error%></div>&nbsp;
														</td>
													</tr>
<%
	}
	if (sch_name != null && sch_name.length() > 3)
	{
		sch_name = sch_name.substring(0,sch_name.length() - 3);
	}
%>
										
													<tr height="26" >
														<td class="cell_border" width="30%" style="border-right-width:0px;padding-left:10px">&nbsp;<egui:intnl text="configmgmt.schedule.Schedule Name" /></td>
														<td class="cell_border" style="border-right-width:0px" width="3%">:</td>
														<td class="cell_border" style="border-right-width:0px">
															<input type="text" name="sch_name"  id="er_name1" value="<%=sch_name%>" style="width: 200px;" maxlength="29" >
														</td>
													</tr>
													<tr height="26" id="blackcontent" class="cellbg">
														<td class="cell_border" style="border-right-width:0px;padding-left:10px" width="20%" >&nbsp;<egui:intnl text="configmgmt.schedule.Mail" /></td>
														<td class="cell_border" style="border-right-width:0px" width="3%">:</td>
														<td class="cell_border" style="border-right-width:0px">
															<select name="mail_freq" style="width: 125px; " onChange="goTo2(this)" >
																<option value='None' <%=sch_mailFreq.equalsIgnoreCase("None")?"selected":""%>><egui:intnl text="configmgmt.schedule.None" /></option>
																<option value='Daily' <%=sch_mailFreq.equalsIgnoreCase("Daily")?"selected":""%>><egui:intnl text="configmgmt.schedule.Daily" /></option>
																<option value='Weekly' <%=sch_mailFreq.equalsIgnoreCase("Weekly")?"selected":""%>><egui:intnl text="configmgmt.schedule.Weekly" /></option>
																<option value='WeekEnd' <%=sch_mailFreq.equalsIgnoreCase("WeekEnd")?"selected":""%>><egui:intnl text="configmgmt.schedule.WeekEnd" /></option>
																<option value='Monthly' <%=sch_mailFreq.equalsIgnoreCase("Monthly")?"selected":""%>><egui:intnl text="configmgmt.schedule.Monthly" /></option>
																<option value='MonthEnd' <%=sch_mailFreq.equalsIgnoreCase("MonthEnd")?"selected":""%>><egui:intnl text="configmgmt.schedule.MonthEnd" /></option>
															</select>
														</td>
														<input type="hidden" name="$_mail_freq" value="<%=sch_mailFreq%>">
													</tr>
													<tr height="26" id="mail_on" class="cellbg" style="display:none">
														<td class="cell_border" style="border-right-width:0px;padding-left:10px" width="20%" >&nbsp;<egui:intnl text="configmgmt.schedule.Mail On" /></td>
														<td class="cell_border" style="border-right-width:0px" width="3%">:</td>
														<td class="cell_border" style="border-right-width:0px">
															<Select name="mail_on" style="width: 125px;">
																<option value='Sunday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Sunday"))?"Selected":""%>><egui:intnl text="reporter.common.Sunday "/></option>
																<option value='Monday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Monday"))?"Selected":""%>><egui:intnl text="reporter.common.Monday "/> </option>
																<option value='Tuesday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Tuesday"))?"Selected":""%>><egui:intnl text="reporter.common.Tuesday"/> </option>
																<option value='Wednesday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Wednesday"))?"Selected":""%>><egui:intnl text="reporter.common.Wednesday"/> </option>
																<option value='Thursday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Thursday"))?"Selected":""%>><egui:intnl text="reporter.common.Thursday"/> </option>
																<option value='Friday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Friday"))?"Selected":""%>><egui:intnl text="reporter.common.Friday"/> </option>
																<option value='Saturday' <%=(sch_mailon!=null && sch_mailon.equalsIgnoreCase("Saturday"))?"Selected":""%>><egui:intnl text="reporter.common.Saturday"/> </option>
														</td>
														<input type="hidden" name="$_mail_on" value="<%=sch_mailon%>">
													</tr>
													<!-- <tr>
														<td colspan="3"  height="1" id="blank">&nbsp;</td>
													</tr> -->
													<tr height="26" id="blackcontent" class="cellbg">
														<td  style="padding-left:10px" width="30%" >&nbsp;<egui:intnl text="configmgmt.schedule.Mail Id" /></td>
														<td  width="3%">:</td>
														<td >
															<input type="text" name="mail_id"  id="er_name1" value="<%=sch_mail_id%>"  <%=sch_mailFreq.equalsIgnoreCase("None")?"disabled":""%> style="width: 200px;" maxlength="256">
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
	if (isSchedulePrintEnabled)
	{
%>
										<tr>
											<td>
												<table width="100%" border="0"  cellpadding="0" cellspacing="0" class="body_text bglightlight">
													<tr height="26" id="blackcontent" class="cellbg">
														<td style="border-right-width:0px;padding-left:10px" width="30%"  id="printTd1">&nbsp;<egui:intnl text="configmgmt.schedule.Print" /></td>
														<td id="printTd2" style="border-right-width:0px" width="3%">:</td>
														<td id="printTd3" style="border-right-width:0px">
															<select style="width: 125px;" name = "print_freq" onChange="goTo2(this);">
																<option value='None' <%=sch_printFreq.equalsIgnoreCase("None")?"selected":""%>>
																	<egui:intnl text="configmgmt.schedule.None" />
																</option>
																<option value='Daily' <%=sch_printFreq.equalsIgnoreCase("Daily")?"selected":""%>>	<egui:intnl text="configmgmt.schedule.Daily" />
																</option>
																<option value='Weekly' <%=sch_printFreq.equalsIgnoreCase("Weekly")?"selected":""%>>
																	<egui:intnl text="configmgmt.schedule.Weekly" />
																</option>
																<option value='WeekEnd' <%=sch_printFreq.equalsIgnoreCase("WeekEnd")?"selected":""%>>
																	<egui:intnl text="configmgmt.schedule.WeekEnd" />
																</option>
																<option value='Monthly' <%=sch_printFreq.equalsIgnoreCase("Monthly")?"selected":""%>><egui:intnl text="configmgmt.schedule.Monthly" /></option>
																<option value='MonthEnd' <%=sch_printFreq.equalsIgnoreCase("MonthEnd")?"selected":""%>><egui:intnl text="configmgmt.schedule.MonthEnd" /></option>
															</select>
														</td>
														<input type="hidden" name="$_print_freq" value="<%=sch_printFreq%>">
													</tr>
													<tr height="26" id="print_on" class="cellbg" style="display:none">
														<td style="padding-left:10px" width="20%" >&nbsp;<egui:intnl text="configmgmt.schedule.Print On" /></td>
														<td  width="3%">:</td>
														<td >
															<Select name="print_on" style="width: 125px;">
																<option value='Sunday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Sunday"))?"Selected":""%>><egui:intnl text="reporter.common.Sunday "/></option>
																<option value='Monday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Monday"))?"Selected":""%>><egui:intnl text="reporter.common.Monday "/> </option>
																<option value='Tuesday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Tuesday"))?"Selected":""%>><egui:intnl text="reporter.common.Tuesday"/> </option>
																<option value='Wednesday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Wednesday"))?"Selected":""%>><egui:intnl text="reporter.common.Wednesday"/> </option>
																<option value='Thursday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Thursday"))?"Selected":""%>><egui:intnl text="reporter.common.Thursday"/> </option>
																<option value='Friday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Friday"))?"Selected":""%>><egui:intnl text="reporter.common.Friday"/> </option>
																<option value='Saturday' <%=(sch_printon!=null && sch_printon.equalsIgnoreCase("Saturday"))?"Selected":""%>><egui:intnl text="reporter.common.Saturday"/> </option>
														</td>
														<input type="hidden" name="$_print_on" value="<%=sch_printon%>">
													</tr>
												</table>
											</td>
										</tr>
<%
	}
%>
										<tr>
											<td>
												<table width="100%" border="0"  cellpadding="0" cellspacing="0" class="body_text bglightlight">
													<tr height="26" id="blackcontent" class="cellbg">
														<td id="scheduleTd1" style="border-right-width:0px;padding-left:10px" width="30%">&nbsp;<egui:intnl text="configmgmt.schedule.Schedule type" /></td>
														<td id="scheduleTd2" style="border-right-width:0px" width="3%">:</td>
														<td id="scheduleTd3" style="border-right-width:0px">
															<select  style="width: 125px;" onChange="scheduleOn();" name = "schedule_held_on">
																<option value='DayEnd' <%=schedule_on.equalsIgnoreCase("DayEnd")?"Selected":""%>><egui:intnl text="configmgmt.schedule.Day end"/></option>
																<option value='AnyTime' <%=schedule_on.equalsIgnoreCase("AnyTime")?"Selected":""%>><egui:intnl text="configmgmt.schedule.Any time"/></option>
															</select>
														</td>
														<input type="hidden" name="$_schedule_type" value="<%=schedule_on%>">
														<input type="hidden" name="$_schedule_at" value="<%=strHours+":"+strMin%>">
													</tr>
													<tr height="26" id="timescale" class="cellbg" style="display:none">
														<td style="padding-left:10px" width="30%" >&nbsp;<egui:intnl text="configmgmt.schedule.Schedule at" /></td>
														<td width="3%">:</td>
														<td >
															<table cellspacing="0" cellpadding="4" height="22" width="90%"  border="0">
																<tr>
																	<td width="5%" class="blackcontent" style="padding-left:0px">
																		<select id="fromHours" name="fromHours">
<%
	for(int f=0;f<hours1.length;f++)
	{
		if(strHours!=null && strHours.equalsIgnoreCase(hours1[f]))
		{
					out.println("<option name="+hours1[f]+" value="+hours1[f]+" selected>"+hours1[f]+"</option>");
		}
		else
		{
					out.println("<option name="+hours1[f]+" value="+hours1[f]+">"+hours1[f]+"</option>");
		}
	}
%>
																		</select>
																	</td>
																	<td width="3%" class="blackcontent"><egui:intnl text="reporter.common.Hrs"/>&nbsp;
																	<td width="3%" class="blackcontent">
																		<select name="fromMinutes" id="fromMinutes">
<%
	for(int f=0;f<minutes1.length;f++)
	{
		if(strMin!=null && strMin.equalsIgnoreCase(minutes1[f]))
		{
			out.println("<option name="+minutes1[f]+" value="+minutes1[f]+" selected >"+minutes1[f]+"</option>");
		}
		else
		{
			out.println("<option name="+minutes1[f]+" value="+minutes1[f]+">"+minutes1[f]+"</option>");
		}
	}
%>
																		</select>
																	</td>
																	<td style="width:25px" class="blackcontent">&nbsp;<egui:intnl text="reporter.common.Mins"/></td>
																</tr>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td height="5" id="blank">&nbsp;</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td align="center" class="padding6" valign="top" height="100%">
						<table width="100%" border="0" height="20" cellpadding="0" cellspacing="0" class="body_text" id="bottomtable" >
							<tr>
								<td class="tdbackcolortop" style="padding-left:10px"><b><egui:intnl text="configmgmt.schedule.Selection Details" /></b></td>
							</tr>
							<tr>
								<td height="3" id="blank"><img src="/final/config/images/spacer.gif" height="3px"></td>
							</tr>
							<tr>
								<td>
									<table border="0" width="100%" id="body_text">
<%
	if (showModifyLink)
	{
%>
										<tr>
											<td align="center" width="100%" colspan="3" height="23"><a href="#" class="alarmlink" onClick="javascript:modifyDetails('<%=sch_id%>','<%=reportType%>')"><egui:intnl text="configmgmt.schedule.Click here to modify your selection"/></a>
											</td>
										</tr>
<%
	}
%>
										<tr>
											<td height="3" id="blank" colspan="3"><img src="/final/config/images/spacer.gif" height="3px"></td>
										</tr>
										<tr>
											<td>
												<table border="0" width="100%" id="body_text" cellpadding="4" cellspacing="0">
<%
	for (int k=0;k<detail.size();k++)
	{
		String seldet = detail.get(k).toString();
		StringTokenizer st = new StringTokenizer(seldet,"##@##",false);
		String strFirstToken = st.nextToken();
		String strSecondToken = st.nextToken();
		boolean isEmpty = false;
		if ("Selected Nothing".equals(strFirstToken.trim()))
		{
			isEmpty = true;
		}
%>
										<tr height="23" id="blackcontent" class="cellbg">
											<td width="30%"align="left" WRAP style="padding-left:10px" valign="top">
<%
	if (!isEmpty)
	{
%>												
										<egui:intnl text='<%="configmgmt.schedule."+strFirstToken%>' />
<%
	}
%>
											</td>
<% 
	if (!isEmpty)
	{
%>
											<td width="3%" valign="top" WRAP>:</td>
<%
	}
%>
<%
		if (strFirstToken.equalsIgnoreCase("Report Name"))
		{
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<egui:intnl text='<%="configmgmt.schedule."+strSecondToken%>' />
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Component") || strFirstToken.equalsIgnoreCase("Selected Component Name"))
		{
			if (strSecondToken.equalsIgnoreCase("All Components"))
			{
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<egui:intnl text="configmgmt.schedule.All Components" />
											</td>
<%
			}
			else
			{
				String componentName = strSecondToken.substring(0,strSecondToken.lastIndexOf(":"));
				String componentType = strSecondToken.substring(strSecondToken.lastIndexOf(":")+1);
				if (componentName.endsWith(":NULL"))
					componentName = componentName.substring(0,componentName.indexOf(":"));
				componentType = mappingInfo.getComponentTypeDescription(componentType);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=componentName+":"+componentType%>
											</td>
<%
			}
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Component Type"))
		{
			String componentType = mappingInfo.getComponentTypeDescription(strSecondToken);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=componentType%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Information(s)"))
		{
			if (reportType.equalsIgnoreCase("Current"))
			{
				StringTokenizer strTokens = new StringTokenizer(strSecondToken,",");
				StringBuffer strBuffer = new StringBuffer();
				while (strTokens.hasMoreTokens())
				{
					String strToken = strTokens.nextToken().trim();
					strBuffer.append(mappingInfo.getTextDescription("configmgmt.configuration."+strToken));
					strBuffer.append(", ");
				}
				String selectedInformations = strBuffer.toString();
				selectedInformations = selectedInformations.substring(0,selectedInformations.length()-2);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=selectedInformations%>
											</td>
<%
			}
			else if (reportType.equalsIgnoreCase("Change"))
			{
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strSecondToken%>
											</td>
<%
			}
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Timeline"))
		{
			if (reportType.equalsIgnoreCase("Configuration Change : Timeline of Changes") || reportType.equalsIgnoreCase("Configuration Change : Summary by Component Name") || reportType.equalsIgnoreCase("Configuration Change : Summary by Component Type"))
			{
				String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
			}
			else
			{
				String strValue = strSecondToken.substring(0,strSecondToken.indexOf(" "));
				String strUnit = strSecondToken.substring(strSecondToken.indexOf(" ")+1);
				strUnit = mappingInfo.getTextDescription("configmgmt.common."+strUnit);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue+" "+strUnit%>
											</td>
<%
			}
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Show changes"))
		{
			String strValue = strSecondToken.substring(0,strSecondToken.indexOf(" "));
			String strUnit = strSecondToken.substring(strSecondToken.indexOf(" ")+1);
			strUnit = mappingInfo.getTextDescription("configmgmt.common."+strUnit);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue+" "+strUnit%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Arrange changes by"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Operating System") || strFirstToken.equalsIgnoreCase("Selected Count") || strFirstToken.equalsIgnoreCase("Selected Software Name") || strFirstToken.equalsIgnoreCase("Selected Service Name") || strFirstToken.equalsIgnoreCase("Selected Hotfix/Patch Name"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Operating System") || 
		strFirstToken.equalsIgnoreCase("Selected Search") || strFirstToken.equalsIgnoreCase("Selected System"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Search Criteria"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Capacity Limit") || strFirstToken.equalsIgnoreCase("Selected Service Pack Version"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if ("Distribution of managed systems by hard disk capacity".equalsIgnoreCase(reportType) && (strFirstToken.equalsIgnoreCase("Selected Start") || strFirstToken.equalsIgnoreCase("Selected End")))
		{
			String strValue = strSecondToken + " " + "GB";
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Start"))
		{
			int startLimit = Integer.parseInt(strSecondToken);
			String strValue = "";
			if (startLimit > 512)
			{
				startLimit = startLimit/1024;
				strValue = (new Integer(startLimit)).toString() + " " + "GB";
			}
			else
			{
				strValue = strSecondToken + " " + "MB";
			}
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected End"))
		{
			int endLimit = Integer.parseInt(strSecondToken);
			String strValue = "";
			if (endLimit > 512)
			{
				endLimit = endLimit/1024;
				strValue = (new Integer(endLimit)).toString() + " " + "GB";
			}
			else
			{
				strValue = strSecondToken + " " + "MB";
			}
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected System Manufacturer") || strFirstToken.equalsIgnoreCase("Selected Processor Family") || strFirstToken.equalsIgnoreCase("Selected Gateway IP Address"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Search By") || strFirstToken.equalsIgnoreCase("Selected Search Value") || strFirstToken.equalsIgnoreCase("Selected Output"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Start Date") || strFirstToken.equalsIgnoreCase("Selected End Date"))
		{
			String strChangedDateFor = DateUtil.changeDateFormat(strSecondToken,"MM/dd/yyyy","MMM dd, yyyy");
			String strValue = strChangedDateFor;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Components"))
		{
			StringBuffer strBuffer = new StringBuffer();
			StringTokenizer stOne = new StringTokenizer(strSecondToken,",");
			while (stOne.hasMoreTokens())
			{
				String aToken = (String) stOne.nextToken();
				String componentName = aToken.substring(0,aToken.indexOf(":"));
				strBuffer.append(componentName);
				strBuffer.append(", ");
			}
			String components = strBuffer.toString();
			components = components.substring(0,components.length() - 2);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=components%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Test Name"))
		{
			String strTestName = mappingInfo.getTestDescription(strSecondToken);
			String strValue = strTestName;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Descriptor"))
		{
			StringBuffer strBuffer = new StringBuffer();
			StringTokenizer stOne = new StringTokenizer(strSecondToken,",");
			while (stOne.hasMoreTokens())
			{
				String aToken = (String) stOne.nextToken();
				strBuffer.append(aToken);
				strBuffer.append(", ");
			}
			String descriptors = strBuffer.toString();
			descriptors = descriptors.substring(0,descriptors.length() - 2);
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=descriptors%>
											</td>
<%
		}
		else if (strFirstToken.equalsIgnoreCase("Selected Component") || strFirstToken.equalsIgnoreCase("Selected Application"))
		{
			String strValue = strSecondToken;
%>
											<td class="alarmlink" align="left" valign="top" WRAP>
												<%=strValue%>
											</td>
<%
		}
%>
										</tr>
<%
	}
%>
									</table>
								</td>
							</tr>
							<tr>
								<td height="10" id="blank">&nbsp;</td>
							</tr>
							<tr height="30" id="blackcontent" class="cellbg" >
								<td align="center" > <input type="button" name="ec_select" value='<egui:intnl text="configmgmt.schedule.SAVE" />' id="er_submit" style="width: 75px; height: 20px;" class="darkbutton" onClick="javascript:goTo()">
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



