<%
/*
 *   File				:	EcOsBoxInformation.jsp
 *   Purpose			:	Shows distribution of systems across operating environments
 *   Creation Date		:	28-12-2006
 *   Author				:	Balasigamani
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.egurkha.User" %>
<%@ page import="com.egurkha.UserRegistry" %>
<%@ page import="java.util.*" %>
<%@ page import="egurkha.config.EcProcessData" %>
<%@ page import="egurkha.config.EcUtils" %>
<%@ page import="com.eg.EgConfigTestsInfo" %>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.eg.EgURLEncoder"%>
<%@ page import="egurkha.config.EcPrintData" %>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import="egurkha.config.EcFusionChartBean" %>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);

	String userName = user.getLoginID();
	EgConfigTestsInfo configTestsInfo=new EgConfigTestsInfo("manager");
	EcUtils ecUtils = new EcUtils();
	EcProcessData processData=new EcProcessData();
	EcPrintData printData=new EcPrintData();

	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	processData.setUserObject(user);
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	processData.setAssociatedComponents(aListAssociatedComponents);
	Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
	processData.setHostAgentsMapping(hostAgentsMapping);

	Vector osList=new Vector();
	String showVersion=null;
	int maxCount = 0;
	Map osCount = new TreeMap();
	ArrayList os_Name=new ArrayList();
	ArrayList countVal=new ArrayList();
	Map withVersionData=new TreeMap();
	Map resultData=new TreeMap();

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String configSkin = user.getConfigSkin();
	String searchValue = request.getParameter("searchValue");
	String osName = request.getParameter("osName");
	String selectedInformation[] = (String[]) request.getAttribute("Selected Informations");
	String searchValueArr[] = (String[]) request.getAttribute("searching");
	String scheduleRequest = (String) request.getAttribute("scheduleRequest");
	Map scheduleDetails = (Map) request.getAttribute("ScheduleDetails");
	if (selectedInformation != null)
	{
		osName = (String) selectedInformation[0];
	}
	if (searchValueArr != null)
	{
		searchValue = (String) searchValueArr[0];
	}
	String sort=configTestsInfo.getServerDisplayValue("SORT_BY_COUNT","InventoryByOperatingSystem");
	boolean sorting =sort.equalsIgnoreCase("true")?true:false;
	boolean goBack = false;
	boolean requestFromDashboard = false;
	String request_from = request.getParameter("request_from");
	String submitOrNot = (String) request.getAttribute("isSubmit");
	if (request_from != null && "OS".equalsIgnoreCase(request_from) || "OSVersion".equalsIgnoreCase(request_from))
	{
		requestFromDashboard = true;
		goBack = true;
	}
	if ("ScheduleConfig".equalsIgnoreCase(scheduleRequest))
	{
		requestFromDashboard = false;
		goBack = false;
	}
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	boolean isDisplay = true;
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		osName = (String) scheduleDetails.get("osSelect");
		searchValue = (String) scheduleDetails.get("searching");
		submitOrNot = "false";
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (submitOrNot == null || "null".equals(submitOrNot))
	{
		submitOrNot = "true";
		isDisplay = true;
	}

	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		isDisplay = false;
	}

	String strRequestFrom = "IBOS";
	if (requestFromDashboard)
	{
		strRequestFrom = "HomePage";
	}

	//Map osWithOutVersion=(TreeMap)processData.getOSDetails();		//Get with without os version name
	processData.setVersion(true);
	Map osWithVersion = (TreeMap)processData.getOSDetails("HomePage");			//Get with withos version name
	Vector tempOsNameList=processData.getAllOsName();

	if(osName!=null && osName.indexOf("#")>-1)
	{
		StringTokenizer st=new StringTokenizer(osName,"#");
		osName=st.nextToken();
		showVersion=st.nextToken();
	}
	if(tempOsNameList!=null && tempOsNameList.size()>0)
	{
		if(tempOsNameList.size()>1)
			osList.add("All");
		osList.addAll(tempOsNameList);
	}

	if (searchValue == null || searchValue.equals(""))
	{
		searchValue = "";
	}

	Object[] displayData=null;
	if(osList!=null && osList.size()>0)
	{
		if(osName==null)
		{
			if(osList.size()>2)
				osName="All";
			else
				osName=(String)osList.get(0);
		}

		withVersionData = (TreeMap)processData.getOsWithVersion(osWithVersion,osName);
		resultData = withVersionData;
		if (searchValue != null && !searchValue.equals(""))
		{
			resultData = (TreeMap)processData.getSearchComponentName(withVersionData,searchValue);
		}

		Object[] osKey= resultData.keySet().toArray();
		for (int a=0; a<osKey.length; a++)
		{
			String sysName = (String)osKey[a];
			Hashtable VersionStatus = (Hashtable)resultData.get(sysName);
			int size=0;
			Enumeration verElement=VersionStatus.keys();
			while(verElement.hasMoreElements())
			{
				String version=(String)verElement.nextElement();
				Hashtable systemList=(Hashtable)VersionStatus.get(version);
				size=size+systemList.size();
			}
			os_Name.add(sysName);
			countVal.add(new Integer(size));
			osCount.put(sysName,new Integer(size));
			maxCount = Math.max(maxCount, size);
		}

		displayData = resultData.keySet().toArray();
		if (displayData.length > 0)
		{
			Arrays.sort(displayData);
		}
		if(sorting)
		{
			Object [] tmpArray = countVal.toArray();
			int [] valueArray = new int[tmpArray.length];
			for (int i=0; i<tmpArray.length; i++)
			{
				valueArray[i] = ((Integer)tmpArray[i]).intValue();
			}
			Arrays.sort(valueArray);
			for (int i=valueArray.length-1; i>=0; i--)
			{
				int thisIndex = countVal.indexOf(new Integer(valueArray[i]));
				tmpArray[i] = (String)os_Name.get(thisIndex);
				displayData[valueArray.length-1-i] = tmpArray[i];
				os_Name.remove(tmpArray[i]);
				countVal.remove(new Integer(valueArray[i]));
			}
		}
	}

	//session.setAttribute("OS_DATA",resultData);
	//session.setAttribute("NO_VERSION",osWithOutVersion);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String strCategory = request.getParameter("category");
	String id = request.getParameter("id");

%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.inventory.view.System Distribution" />
</title>
<!-- <link rel="stylesheet" href="../config/styles/ec_style_green.css" /> -->
<egui:skin ui="config"/>
<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/../final/scripts/screen_display.js"></script>
<script language="JavaScript1.2">
	
	function componentSearch(path)
	{
		var thisForm = document.OSInventory;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var name = thisForm.searching.value;
		var osname = thisForm.osSelect.value;

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if(osname ==-1)
		{
			alert('<egui:intnl text="configmgmt.inventory.view.Please select an operating system" />');
			return;
		}
		var sub = checkspecial(thisForm.searching,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?\/");
		if(!sub)
		{
			thisForm.searching.focus();
			return;
		}
		if (path == "submit")
		{
			window.location.href="../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&osName="+osname+"&searchValue="+name+"&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&isSubmit=true";
			document.OSInventory.secsubmt.value='<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.OSInventory.secsubmt.disabled=true;
		}
	}

	function printData()
	{
<%
		if(resultData == null || resultData.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("printType=OS_INFORMATION");
		printQS.append("&printPageTitle=INVENTORY_REPORT_BY_OPERATING_SYSTEM");
		printQS.append("&Page=OS");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if(resultData == null || resultData.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","InventoryReportByOS");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (resultData == null || resultData .size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function getInformations()
	{
		var thisForm = document.OSInventory;
		var osName = thisForm.osSelect.value;
		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=OSInventory&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

	function goHome()
	{
		window.location.href = '../servlet/com.eg.EcConfigurationServlet?cmd=Home&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	}

	function csv()
	{
<%
		if (resultData == null || resultData .size() == 0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function schedule(op)
	{
<%
		if(resultData == null || resultData.size()==0)
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		var checkFlag = componentSearch('schedule');
		if(checkFlag == false) return;
		var thisForm = document.OSInventory;
		var request_from = "<%=request_from%>";
		if (op == "schedule")
		{
<%
			if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
			}
			else
			{
%>
				thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=OSInventory";
<%
			}
%>
		}
		else if (op =="favorite")
			thisForm.action = "/final/config/EcSaveFavorite.jsp";
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}
		thisForm.submit();
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}


</script>

</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" onLoad="bigScreen();">
<form name="OSInventory" method="POST" style="margin:0px">
<input type="hidden" name="ec_rtype" value="OSInventory">
<input type="hidden" name="ec_trgttype" value="Configuration_Report">
<input type="hidden" name="isSubmit" value="true">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">
<%
	if (submitOrNot.equals("true"))
	{
%>
	<input type="hidden" name="submitClicked" value="true">
<%
	}
%>

<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%">

	<tr>
		<td align="right" valign="middle" id="layer_headbg" height="18" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
			<div style="border:0px blue solid;height:24px">
				<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.view.INVENTORY BY OPERATING SYSTEM" /></b>
				</div>
				<div style="border:0px solid red;float:right;">
<%
	if (requestFromDashboard)
	{
%>
					<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
						<table cellspacing="0" cellpadding="0" border="0" height="20">
							<tr>
								<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

								<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

								<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

								<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

								<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

								<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
							</tr>
						</table>
					</div>
<%
	}
%>
					<div style="border:0px solid;float:right;padding:5px">
<%
	if (goBack)
	{
%>
						<a id='mouse' onClick="javascript:goHome();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
						</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
					</div>
				</div>
			</div>
		</td>
	</tr>

<%
	if (requestFromDashboard)
	{
%>
	<tr>
		<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
	</tr>
<%
	}
%>

	<tr>
		<td valign="top" id="bgmedium" width="100%" height="100%">
			<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
<%
	if (!requestFromDashboard)
	{
%>
				<tr>
					<td id="padding6" style="padding-bottom:0px">
						<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
							<col width="55"><col width="10"><col width="170">
							<col width="150"><col width="10"><col width="350">
							<tr>
								<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
								<td align="center"><b>:</b></td>
								<td valign="middle">
									<select name="ec_criteria" style="width:170px;" onChange='javascript:getInformations()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
									</select>
								</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
								<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
								</td>
								<td align="center"><b>:</b></td>
								<td>
									<select name="ec_userOption" style="width: 250px;" onChange='javascript:getInformations()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
									</select>
								</td>
<%
		}
		else
		{
%>
								<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
							</tr>
						</table>
					</td>
				</tr>
				<!-- new tab end here -->

				<tr>
					<td id="padding6">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable" >
							<tr>
								<td>
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0"  style="table-layout:fixed" id="text_bold"> <col width="20"><col width="145"><col width="10"><col width="220"><col width="120"><col width="10"><col width="310"><col width="20">
										<tr>
											<td colspan="8" height="5" id="blank">&nbsp; </td>
										</tr>
										<tr height="20">
											<td align="center">&nbsp;</td>
											<td align="right"><egui:intnl text="configmgmt.inventory.view.Search by System(s)" /></td>
											<td align="center">:</td>
											<td align="left">
												<table cellspacing="0" cellpadding="0" width="100%" border="0">
													<tr>
														<td style="width:200px"> <input type="text" name="searching" value="<%=searchValue%>" style="width:200px"></td>
														<td>&nbsp;<img class="mouse" src=" /final/config/images/gray/arrow_1.gif" title="<egui:intnl text='monitor.common.GO'/>"  onClick="javascript:componentSearch('submit')" border="0"></td>
													</tr>
												</table>
											</td>
											<td align="right" nowrap><egui:intnl text="configmgmt.inventory.view.Operating system" /></td>
											<td align="center">:</td>
											<td>
												<select name="osSelect">
<%
		if (osList != null && !osList.isEmpty())
		{
			for(int i=0; i<osList.size(); i++)
			{
				String selected = "";
				String strOS = (String)osList.get(i);
				if(osName != null && osName.equals(strOS))
				{
					selected = "selected";
				}
%>
													<option value="<%=strOS%>" <%=selected%>>
<%
				if (strOS.equalsIgnoreCase("All"))
				{
%>
														<egui:intnl text="configmgmt.inventory.view.All" />
<%
				}
				else
				{
					out.println(strOS);
				}
%>
													</option>
<%
			}
		}
		else
		{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.inventory.view.Not Applicable" />
													</option>
<%
		}
%>
												</select>
											</td>
											<td align="center">&nbsp;</td>
										</tr>
										<tr>
											<td colspan="8" height="10" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" colspan="1">&nbsp;</td>
												<td align="right" colspan="5" valign="middle" height="20"> 
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
													<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<%
		}
		else
		{
%>
													<input type="button"  name="secsubmt" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:componentSearch('submit')">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
<%
		}
%>
												</td>
											<td align="right"  colspan="2" rowspan="2" style="height:24" valign="bottom">
												<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
													<tr>
														<td width="50" align="center" id="leftcurve" ><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

														<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="2" ></td>

														<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="13" ></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

														<td width="13" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

														<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

														<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

														<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td colspan="7" height="5" id="blank">&nbsp;</td>
										</tr>
									</table>
								</td>
							</tr>
						</table>
					</td>
				</tr>
<%
	}
%>

				<tr>
					<td id="padding6" height="100%" width="90%" style="padding-top:0px" valign="top">
						<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" id="bottomtable">
<%
	if (resultData!=null && resultData.size()>0 && submitOrNot.equals("true") && isDisplay)
	{
		//print data start here
		printData.setMapCountData(osCount);
		printData.setMapData(resultData);
		printData.setDisplayData(displayData);
		printData.setOsVersion(showVersion);
		printData.setOsName(osName);
		printData.setSearchValue(searchValue);
		//print data end here

		//pdf work
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();
		EgTable egTable = new EgTable();
		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY OPERATING SYSTEM") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY OPERATING SYSTEM") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		if(osName != null && osName.equalsIgnoreCase("All"))
		{
			reportAttributes.setSubTitle(mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of systems across operating systems"));
		}
		else
		{
			reportAttributes.setSubTitle(osName + " " + mappingInfo.getTextDescription("configmgmt.inventory.view.Systems"));
		}

		reportAttributes.setReportName("InventoryByOS");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(true);
		pdfData.setAttributes(reportAttributes);
%>
							<input type="hidden" name="submitClicked" value="true">
							<tr>
								<td align="center" valign="top">
									<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text">
										<tr>
<%
		if(!osName.equalsIgnoreCase("All"))
		{
			Integer osCout=(Integer)osCount.get(osName);
%>
											<td height="20" class="tdbackcolortop" id="white_content"> &nbsp;<b><%=osName%>&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" />&nbsp;:&nbsp;<%=osCout.intValue()%>)</b>
											</td>
<%
		}
		else
		{
%>
											<td height="20" class="tdbackcolortop" id="white_content">
												&nbsp;&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Distribution of systems across operating systems" /></b>
											</td>
<%
		}
%>
										</tr>
									</table>
								</td>
							</tr>
	
							<tr>
								<td align="center" valign="top" height="100%">
								<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;"> 
									<table width="100%" border="0" cellpadding="0" cellspacing="0" border="0">
<%
		int i_max = 7;
		if(osName!=null && osName.equalsIgnoreCase("All"))  // Display Dashboard for all operating system
		{
			String countValue=null;		//os count
			String countName=null;		//os name
			String colorValue=null;		//os color
			int totalCount=0;
			ArrayList aListColors = new ArrayList();
			StringTokenizer stTokColors = new StringTokenizer(barColor,",");
			while (stTokColors.hasMoreTokens())
			{
				String chartColor = stTokColors.nextToken();
				aListColors.add(chartColor);
			}
			String strColors = " ";
			int colorIdx = 0;

			for(int n=0;n<displayData.length;n++)
			{
				String displayOsName="";
				int cout=0;
				String tempName=(String)displayData[n];
				Integer ct=(Integer)osCount.get(tempName);
				cout=ct.intValue();

				if (strCategory != null && strCategory.equalsIgnoreCase("Others"))
				{
					if (n < i_max) continue;
				}

				if(tempName.indexOf(',')>-1)
					displayOsName=tempName.replace(',',' ');
				else
					displayOsName=tempName;
		
				if(displayOsName.indexOf("Microsoft")>-1)
				{
					displayOsName=displayOsName.substring(displayOsName.indexOf(' ')+1);
				}

				String temp_getOsColor = configTestsInfo.getServerDisplayValue("DASHBOARD_OS_COLOR",tempName);
				if(countValue==null || countName==null)
				{
					countValue=""+cout;
					countName=displayOsName;
					if (temp_getOsColor == null || temp_getOsColor.length() == 0)
					{
						strColors = (String)aListColors.get(colorIdx);
						colorValue = strColors;
						colorIdx++;
						if (colorIdx >= aListColors.size())
						{
							colorIdx = 0;
						}
					}
					else
					{
						colorValue = temp_getOsColor;
					}
				}
				else
				{
					countValue=countValue+","+cout;
					countName=countName+","+displayOsName;
					if (temp_getOsColor == null || temp_getOsColor.length() == 0)
					{
						strColors = (String)aListColors.get(colorIdx);
						colorValue = colorValue + "," + strColors;
						colorIdx++;
						if (colorIdx >= aListColors.size())
						{
							colorIdx = 0;
						}
					}
					else
					{
						colorValue = colorValue + "," + temp_getOsColor;
					}
				}
				totalCount=totalCount+cout;
			}

			String titleName=mappingInfo.getTextDescription("configmgmt.inventory.view.Total systems")+" : "+totalCount;

			ArrayList pieDataList = new ArrayList();//for legend
			ArrayList piecolorList = new ArrayList(); //color list for legend
			String legendLabel = "";
			String legendColor = "";

			StringTokenizer strColor =  new StringTokenizer(colorValue,",");
			while (strColor.hasMoreTokens())
			{
				String temp_pieColor = strColor.nextToken();
				piecolorList.add(temp_pieColor.substring(temp_pieColor.indexOf("#")+1,temp_pieColor.length()));
			}

			StringTokenizer strToken = new StringTokenizer(countName,",");
			while (strToken.hasMoreTokens())
			{
				String strOs = strToken.nextToken();
				pieDataList.add(strOs);
			}

			//Fusion Pie Chart Data starts--Rekha
			HashMap mapChartAttributes = new HashMap();//map for chart attributes
			mapChartAttributes.put("bgcolor","FFFFFF");
			mapChartAttributes.put("enablesmartLabels","0");
			mapChartAttributes.put("showToolTip","0");
			mapChartAttributes.put("showPercentValues","0");
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				mapChartAttributes.put("pieRadius","90");
			}
			else
			{
				mapChartAttributes.put("pieRadius","60");
			}
			mapChartAttributes.put("showBorder","0");

			HashMap mapChartData = new HashMap();//map for chart data
			mapChartData.put("pieLabels",countName);
			mapChartData.put("pieValues",countValue);
			mapChartData.put("pieColors",colorValue);

			HashMap mapProperties = new HashMap();//map for misc properties
			mapProperties.put("showLabels","false");
			mapProperties.put("showColors","true");
			mapProperties.put("enableLinks","false");

			EcFusionChartBean chartbean = new EcFusionChartBean();
			String xmlString = chartbean.getXMLDataForPieChart(mapChartAttributes,mapChartData,mapProperties);
			//Fusion Pie Chart Data - ends

			//print data start
			printData.setChartTitle(titleName);
			printData.setSampleLabel(countName);
			printData.setSampleValue(countValue);
			printData.setSampleColor(colorValue);
			//print data end

			boolean flag = false;
			if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
			{
				flag = true;
			}
			if (flag)
			{
%>
										<tr>
											<td align="center" valign="top" height="265" class="white_bg">
												<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="265" bgcolor="#FFFFFF" valign="center">
													<tr>
														<td colspan="2" align="center" width="100%">
															<b><%=titleName%></b>
														</td>
													</tr>
													<tr>
														<td align="right" width="60%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="450" height="150" id="Pie3D">
																<param name="movie" value="/final/FusionCharts/swf/Pie3D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/Pie3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="450" height="150" name="Pie3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->

															<div id="chartPieOS3DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myPieOS3DChartId" ) )
																		FusionCharts( "myPieOS3DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie3D.swf","myPieOS3DChartId", "300", "300","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartPieOS3DContainer");
															</script>
														</td>
														<td width="40%" align="middle" valign="middle">
															<table border="0" width="100%"  cellspacing="0" cellpadding="0">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendColor = (String)piecolorList.get(k);
%>
																<tr>
																	<td>
																		<table cellpadding="0" cellspacing="0" border="0">
																			<tr>
																				<td height="6px" align="right" valign="middle" width="6px" class="border" style="background-color:<%=legendColor%>"></td>
																			</tr>
																		</table>
																	</td>
																	<td align="left" valign="middle" style="font-name:Verdana;font-size:9;font-weight:plain"><%=legendLabel%></td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
<%
			}
			else
			{
%>
										<tr>
											<td align="center" valign="top" height="265" class="white_bg">
												<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="265" bgcolor="#FFFFFF" valign="center">
													<tr>
														<td colspan="2" align="center" width="100%">
															<b><%=titleName%></b>
														</td>
													</tr>
													<tr>
														<td align="right" width="60%" bgcolor="white" nowrap>
															<!-- <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="450" height="150" id="Pie2D">
																<param name="movie" value="/final/FusionCharts/swf/Pie2D.swf" />
																<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" />
																<param name="quality" value="high" />
																<param name="wmode" value="transparent" />
																<embed src="/final/FusionCharts/swf/Pie2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=50&chartHeight=50" quality="high" width="450" height="150" name="Pie2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
															</object> -->

															<div id="chartPieOS2DContainer"  style="height:100%;"></div>
															<script type="text/javascript">
																if  ( FusionCharts( "myPieOS2DChartId" ) )
																		FusionCharts( "myPieOS2DChartId" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/Pie2D.swf","myPieOS2DChartId", "300", "300","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("chartPieOS2DContainer");
															</script>
														</td>
														<td width="40%" align="middle" valign="middle">
															<table border="0" width="100%"  cellspacing="0" cellpadding="0">
<%
				for( int k = 0;k < pieDataList.size();k++)
				{
					legendLabel = (String)pieDataList.get(k);
					legendColor = (String)piecolorList.get(k);
%>
																<tr>
																	<td>
																		<table cellpadding="0" cellspacing="0" border="0">
																			<tr>
																				<td height="6px" align="right" valign="middle" width="6px" class="border" style="background-color:<%=legendColor%>"></td>
																			</tr>
																		</table>
																	</td>
																	<td align="left" valign="middle" style="font-name:Verdana;font-size:9;font-weight:plain"><%=legendLabel%></td>
																</tr>
<%
				}
%>
															</table>
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr>
											<td height="10" id="blank">&nbsp;</td>
										</tr>
<%
			}

			// pdf work
			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setImageData(true);
			
			ArrayList aListData = new ArrayList();
			aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=DASHBOARD_OS&chartType=PieChart&height=150&width=400&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(countValue)+"&sampleLabels="+URLEncoder.encode(countName)+"&sampleColors="+URLEncoder.encode(colorValue)+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));
			
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Image");

			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);
			
			aListPdfData.add(egTable);
		}

		session.setAttribute("print_os_information",printData);
		for(int n=0;n<displayData.length;n++)
		{
			if (strCategory != null && strCategory.equalsIgnoreCase("Others"))
			{
				if (n < i_max) continue;
			}

			String selectedOsName =(String)displayData[n];
			Hashtable versionDetails = (Hashtable)resultData.get(selectedOsName);
			Integer osCout=(Integer)osCount.get(selectedOsName);

			//pdf work
			ArrayList aListData = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
			userColumnNames.add("Version");
			userColumnNames.add("System1");
			userColumnNames.add("System2");
			userColumnNames.add("System3");

			ArrayList aListColumnNames = new ArrayList();
			aListColumnNames.add("");
			aListColumnNames.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Systems"));
			aListColumnNames.add("");
			aListColumnNames.add("");

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			String tableTitle = selectedOsName+" ("+mappingInfo.getTextDescription("configmgmt.inventory.view.Count")+" : "+osCout+")";
			egTableAttributes.setTitle(tableTitle);
			egTableAttributes.setColumnNames(aListColumnNames);
			egTableAttributes.setStartX(0);
			egTableAttributes.setDataGrouping(true);

			egTableAttributes.setDataGroupingField(0);

			// Sorting the Version Order
			Object[] displayVersion = versionDetails.keySet().toArray();
			if (displayVersion.length > 0)
			{
				Arrays.sort(displayVersion);
			}
			if(osName.equalsIgnoreCase("All"))
			{
%>
										<tr>
											<td align="center" width="100%" valign="top">
												<table border="0" width="99%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable">
													<tr>
														<td class="bgdarkimg" height="20"><%=selectedOsName%>&nbsp;&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count" />&nbsp;:&nbsp;<%=osCout.intValue()%>)</td>
													</tr>
<%
			}
			else
			{
%>
										<tr>
											<td height="5" id="blank">&nbsp;</td>
										</tr>
										<tr>
											<td align="center" width="100%" valign="top">
												<table border="0" width="99%" cellspacing="0" cellpadding="0" class="body_text" id="bottomtable">
<%
			}
%>
													<tr>
														<td align="center">
															<table border="0" cellspacing="0" cellpadding="0" class="body_text" width="100%">
																<tr>
																	<td width="15%" id="tdbacklightcolor3" align="left" class="cell_border" height="20">&nbsp;<b><egui:intnl text="configmgmt.inventory.view.Version" /></b></td>
																	<td width="85%" id="tdbacklightcolor3" align="center" height="20" valign="top">
																		<table cellspacing="0" cellpadding="0" border="0" class="body_text">
																			<tr>
																				<td valign="top"> <b><egui:intnl text="configmgmt.inventory.view.Systems" /></b></td>
																			</tr>
																		</table>
																	</td>
																</tr>
															</table>
														</td>
													</tr>

													<tr>
														<td valign="top">
															<table border="0" cellspacing="0" cellpadding="0" width="100%" class="body_text">
<%
			Iterator verIterate = versionDetails.keySet().iterator();
			while (verIterate.hasNext())
			{
				String versionName = (String)verIterate.next();
				if(showVersion!=null)
				{
					if(!versionName.equalsIgnoreCase(showVersion))
						continue;
				}
				Hashtable nickName=(Hashtable)versionDetails.get(versionName);
				ArrayList component =getSystemNickName(nickName);
				Collections.sort(component);
				int count = component.size();
				int j=0;
				if (count <=3)
				{
					count = 3;
				}
				else if(count % 3 != 0)
				{
					count = count+3 -count % 3;
				}
%>
																<tr>
																	<td width="15%" align="left" valign="top" id="cell_bg1" style="padding-top:0px" nowrap> <%=versionName%> </td>
																	<td width="85%" valign="top">
																		<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%">
<%
				if (component!= null)
				{
					for (j=0; (j<component.size() || j < count); j++)
					{
						if (j%3 == 0)
						{
							//pdf work
							aListData.add(mappingInfo.getTextDescription("configmgmt.inventory.view.Version")+" : "+versionName);
%>
																			<tr>
<%
						}
						if ( j <component.size())
						{
							String systemName=(String)component.get(j);
							aListData.add(systemName);
%>
																				<td width="30%" id="cell_bg1" height="20" valign="top" style="padding-top:0px">
								<a href="../servlet/com.eg.EcConfigurationServlet?request_from=<%=strRequestFrom%>&cmd=BoxView&searchValue=&systemName=<%=EgURLEncoder.encode(systemName,"UTF-8")%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>" target="_self" class="eg_monlink">
									&nbsp;<%=systemName%>
								</a>
																				</td>
<%
						}
						else
						{
							aListData.add("");
%>
																				<td width="30%" id="cell_bg1">&nbsp; </td>
<%
						}
						if (j%3 == 2)
						{
%>
																			</tr>
<%
						}
					}
				}
%>
																		</table>
																	</td>
																</tr>
<%
			}
%>
															</table>
														</td>
													</tr>
<%
			//pdf work
			EgTableModel egTableModel = new EgTableModel(aListData,userColumnNames);
			egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
%>
												</table>
											</td>
										</tr>
<%
			//if(n<displayData.length-1)
			//{
%>
										<tr>
											<td height="10" id="blank">&nbsp;</td>
										</tr>
<%
			//}
		}

		//pdf work
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
%>
									</table>
									</div>
								</td>
							</tr>
							<!-- <tr>
								<td height="10" id="blank">&nbsp;</td>
							</tr> -->
<%
	}
	else if (osName != null && !osName.equals("null") && !osName.equals("-1") && submitOrNot.equals("true") && isDisplay)
	{
%>
							<tr>
								<td align="center">
									<table border="0" align="center" width="100%" height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text">
													<tr>
														<td align="center"> <img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'> </td>
													</tr>
													<tr>
														<td align="center"> <b><egui:intnl text="configmgmt.inventory.view.No systems found for the selected OS" /></b> </td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
	else
	{
%>
							<input type="hidden" name="submitClicked" value="false">
							<tr>
								<td align="center" >
									<table border="0" align="center" width="100%"  height="100%">
										<tr>
											<td align="center">
												<table border="0" align="center" width="100%" class="body_text" >
													<tr>
														<td align="center">&nbsp;</td>
													</tr>
												</table>
											</td>
										</tr>
									</table>
								</td>
							</tr>
<%
	}
%>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>

<%!
	private ArrayList getSystemNickName(Hashtable name)
	{
		ArrayList systemName=new ArrayList();
		Enumeration e=name.keys();
		while(e.hasMoreElements())
		{
			String nick=(String)e.nextElement();
			systemName.add(nick);
		}
		return systemName;
	}
%>



