<%
/*
 *   File				:	EcNWeekChanges.jsp
 *   Purpose			:	Display the list of changes daywise for the selected component type
 *   Creation Date		:	10-08-2006
 *   Author				:	Balasigamani
 *   UI Design			:   Jaiwin
 */
%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>
<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="java.util.*"%>
<%@ page import="java.net.URLEncoder"%>
<%@ page import="com.eg.EgDateInfo"%>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="egurkha.config.ConfigDbSetting"%>
<%@ page import="egurkha.config.EcCurrentAlertBean"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] options = {"1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader ("Expires", -1);
%>

<%
	// Bean Object
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();
	
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();

	//date format start here
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	//date format end here

	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	EgDateInfo egDt = new EgDateInfo();
	EcUtils ecUtils=new EcUtils();
	EcCurrentAlertBean currentBean=new EcCurrentAlertBean();
	Map dashboardSetting=(Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);

	//Request data
	String defaultDuration=configTestsInfo.getServerDisplayValue("DISPLAY_DATACHANGES","DayChanges");
	//String displayName=configTestsInfo.getServerDisplayValue("DASHBOARD_HEADINGS","NWEEK_CHANGES");
	String barColor=configTestsInfo.getServerDisplayValue("MISC_ARGS","BarChartColor");
	String countWeek = request.getParameter("selectionDuration");
	String server=request.getParameter("serverTypes");
	String barColorCode=(String)dashboardSetting.get(EgConfigConstants.BAR_COLOR);
	if(barColorCode!=null)
	{
		if(barColorCode.indexOf("#")==-1)
			barColor="#"+barColorCode;
		else
			barColor=barColorCode;
	}
	// Variables
	Map finalData=new TreeMap();
	ArrayList dateCount=new ArrayList();
	long msecsPerDays= (long) 1000 * 60 * 60 * 24;
	String hours="";
	String minites="";
	String sampleValues="";
	String sminites="";
	String shours="";
	String barLabels="";
	//String barLabelColors="";

	String sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Days") + " (" + currentDateFormat + ")";

	String selectionOption="";
	String sDate="";
	String eDate="";
	String lastDayDate="";
	int qcount=0;
	int sel=0;

	// Start to get changes data
	currentBean.setUserObject(user);
	Vector serverTypes=currentBean.getUserConfigComponent();
	if(serverTypes!=null && serverTypes.size()>0)
	{
		if(server==null	||server.equalsIgnoreCase("All"))
		{
			server = "All";
			selectionOption="All Components";
		}
		else
			selectionOption="Component Type";

		if(countWeek==null)
		{
			Map dashboardDaySetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.DASHBOARD_SETTING);

			String daySetting=(String)dashboardDaySetting.get(EgConfigConstants.DAYWISE_CHANGE_DISTRIBUTION);

			if(daySetting==null)
				countWeek=defaultDuration;
			else
				countWeek=daySetting;
		}

		currentBean.setAllComponents(selectionOption);
		currentBean.initialize(countWeek,"DAYS");
		if(!server.equalsIgnoreCase("All"))
			currentBean.setSelectedServer(server,"TYPE");
		if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
			finalData=(TreeMap)currentBean.getHourCount();
		else
			finalData=(TreeMap)currentBean.getDaysCount();

		if(countWeek.indexOf("day")>-1)
		{
			int tempDay=Integer.parseInt(countWeek.substring(0,countWeek.indexOf(' ')));
			sel=tempDay;
		}
		else
		{
			int tempDay=Integer.parseInt(countWeek.substring(0,countWeek.indexOf(' ')));
			sel=tempDay*7;
		}

		if(countWeek!=null && !countWeek.equalsIgnoreCase("1 day"))
		{
			for(int s=sel;s>=0;s--)
			{
				Date dt_temp = new Date(egDt.egetDateUS());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				String sdate = egDt.egetDateUS(l_temp -(long)(s* msecsPerDays));
				String stime=sdate.substring(sdate.indexOf(' ')+1);
				sdate=sdate.substring(0,sdate.indexOf(' '));

				Integer value=(Integer)finalData.get(sdate);
				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();
				if(s==sel)
				{
					lastDayDate=month+"/"+day+"/"+year;
					finalData.remove(sdate);
					continue;
				}
				if(qcount==0)
				{
					qcount++;
					StringTokenizer timetoken=new StringTokenizer(stime,":");
					hours=timetoken.nextToken();
					minites=timetoken.nextToken();
					String seconds=timetoken.nextToken();
					shours="0";
					sminites="0";
				}
				dateCount.add(month+"/"+day+"/"+year);

				String st="";
				if(value==null)
					st="0";
				else
					st=value.toString();
				sdate=DateUtil.changeDateFormat(sdate,"MM/dd/yyyy",currentDateFormat);//sdate.substring(0,sdate.lastIndexOf('/'));
				sdate=sdate.replace(',',' ');
				if(s==sel-1)
				{
					sampleValues=""+st;
					barLabels=sdate;
					//barLabelColors="#000000";
				}
				else
				{
					sampleValues=sampleValues+","+st;
					barLabels=barLabels+","+sdate;
					//barLabelColors=barLabelColors+",#000000";
				}
			}
		}
		else
		{ // if day is one
			for(int s=1;s>=0;s--)
			{
				Date dt_temp = new Date(egDt.egetDateUS());
				Calendar cal_temp = new GregorianCalendar();
				cal_temp.setTime(dt_temp);
				Date dt_temp1 = cal_temp.getTime();
				long l_temp = dt_temp1.getTime();
				String sdate = egDt.egetDateUS(l_temp -(long)(s* msecsPerDays));
				String stime=sdate.substring(sdate.indexOf(' ')+1);
				sdate=sdate.substring(0,sdate.indexOf(' '));

				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();
				if(s==0)
				{
					StringTokenizer timetoken=new StringTokenizer(stime,":");
					hours=timetoken.nextToken();
					minites=timetoken.nextToken();
					eDate=month+"/"+day+"/"+year;
				}
				else
					sDate=month+"/"+day+"/"+year;

				shours=hours;
				sminites=minites;
			}
			
			Iterator hourCount=finalData.keySet().iterator();
			while(hourCount.hasNext())
			{
				String dateWithHour=(String)hourCount.next();
				Integer count=(Integer)finalData.get(dateWithHour);
				String stime=dateWithHour.substring(dateWithHour.indexOf('$')+1);
				String sdate=dateWithHour.substring(0,dateWithHour.indexOf('$'));

				StringTokenizer datetoken=new StringTokenizer(sdate,"/");
				String month=datetoken.nextToken();
				String day=datetoken.nextToken();
				String year=datetoken.nextToken();

				dateCount.add(month+"/"+day+"/"+year+"$"+stime);
				sdate=sdate.substring(0,sdate.lastIndexOf('/'));
				if(qcount==0)
				{
					qcount++;
					sampleValues=""+count.toString();
					//barLabels=sdate+" - "+stime;
					barLabels=stime;
					//barLabelColors="#000000";
				}
				else
				{
					sampleValues=sampleValues+","+count.toString();
					//barLabels=barLabels+","+sdate+" - "+stime;
					barLabels=barLabels+","+stime;
					//barLabelColors=barLabelColors+",#000000";
				}
			}
			sampleAxisLabel = mappingInfo.getTextDescription("configmgmt.changes.daywise.Hourly Changes");
		}
	}
	int totalCount=0;
	Object[] keySet2 =finalData.keySet().toArray();
	int maxCount=0;
	for (int z=0; z<keySet2.length; z++)
	{
		String dateValue= (String)keySet2[z];
		if(dateValue.equalsIgnoreCase(lastDayDate))
			continue;
		Integer states = (Integer)finalData.get(dateValue);		//Individual states
		int size=states.intValue();
		totalCount=totalCount+size;
		maxCount = Math.max(maxCount, size);
	}
%>

<html>
<head>
<title>
	<egui:intnl text="configmgmt.dashboard.eG Configuration" /> : <egui:intnl text="configmgmt.dashboard.Daywise Change Distribution" />
</title>
<link rel="stylesheet" href="/final/config/styles/ec_style_green.css" />
<egui:skin ui="config"/>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0" style="over-flow:hidden" bgcolor="#FFFFFF">
<!-- <form name="weekChanges" method="POST"> -->
	<table width="100%" align="center" border="0" class="body_text" cellpadding="0" cellspacing="0" id="innertable" >
		<tr>
			<td height="20">
				<table cellspacing="0" cellpadding="0" border="0" width="100%">
					<tr height="20px">
						<td class="tdbackcolortop" width="45%" nowrap>&nbsp;
						<a href="/final/config/EcWeeklyChanges.jsp?request_from=Dashboard" class="eg_headlink_white">
						<b><egui:intnl text="configmgmt.dashboard.Daywise Change Distribution"/></b></a>
						</td>
						<td class="tdbackcolortop" align="right" width="35%" nowrap>
						<select name="serverTypes" onChange="javascript:goto1()">
<%//=ecUtils.fillSelectBox(serverTypes,"",server)%>
<%
	if (serverTypes != null && !serverTypes.isEmpty())
	{
		for(int i=0; i<serverTypes.size(); i++)
		{
			String componentType = (String)serverTypes.get(i);
			if (componentType.equalsIgnoreCase("All"))
			{
%>
						<option value="<%=componentType%>" <%=(server != null && server.equals(componentType))?"selected":""%>>
						<egui:intnl text="configmgmt.changes.daywise.All" />
						</option>
<%
			}
			else
			{
				serverList.add(componentType);
			}
		}
		serverList = sorter.getSortedCompTypeList(serverList);
		for (int j=0; j<serverList.size(); j++)
		{
			EgName nameObj = (EgName)serverList.get(j);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();

			String selected = "";
			if(server != null && server.equals(actualName))
				selected = "selected";
%>
						<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
						<option value="-1">
						<egui:intnl text="configmgmt.changes.daywise.Not Applicable" />
						</option>
<%
	}
%>
						</select>
						</td>
						<td class="tdbackcolortop" width="20%" align="right" nowrap>
						<select name="durationDays" onChange="javascript:goto1()">
<%//=ecUtils.fillDashboardSelectBox(countWeek)%>
<%
	for (int u=0;u<options.length;u++)
	{
		String strOption = options[u];

		String selected = "";
		if (strOption.equals(countWeek))
			selected = "selected";
		
		String strValue = strOption.substring(0,strOption.indexOf(" "));
		String strText = strOption.substring(strOption.indexOf(" ")+1);
%>
						<option value="<%=options[u]%>" <%=selected%>>
						<%=strValue%> <egui:intnl text='<%="configmgmt.common."+strText%>' />
						</option>
<%
	}
%>
						</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	if((finalData!=null && finalData.size()>0) && serverTypes!=null && serverTypes.size()>0)
	{
		String chartTitle = mappingInfo.getTextDescription("configmgmt.dashboard.Total Changes") + " : " + totalCount;
%>
		<tr>
			<td width="100%" align="center">
				<applet code="com.objectplanet.chart.ChartApplet" width="98%" height="136" align="center" codebase="/final/reporter" archive="chart.jar">
					<param name="chart" value="bar">
					<param name="chartTitle" value="<%=chartTitle%>">
					<param name=titleFont value="verdana,bold,10">
					<param name="sampleValues" value="<%=sampleValues%>">
					<param name="sampleColors" value="<%=barColor%>">
					<param name="sampleLabelStyle" value="inside">
					<param name="valueLabelsOn" value="true">
					<param name="valueLabelstyle" value="inside">
					<param name="valueLabelFont" value="Arial,bold,12">
					<param name="barLabels" value="<%=barLabels%>">
					<param name="AutoLabelsSpacingon" value="true">
					<param name="barLabelsOn" value="true">
					<param name="barLabelAngle" value="360">
					<param name="barLabelFont" value="Arial,normal,10">
					<param name="zoomon" VALUE="true">
					<param name="3DModeOn" value="true">
					<param name=3DDepth value="20">
					<param name=multiSeriesOn value="true">
					<param name="range" value="<%=maxCount%>">
					<param name="lowerrange" value="0">
					<param name="autoLabelSpacingOn" value="true">
					<param name=rangeAdjusterOn value="true">
					<param name = "sampleScrollerOn" value="true">
<%
		StringTokenizer strTokens = new StringTokenizer(sampleValues,",");
		ArrayList aListSampleValues = new ArrayList();
		while (strTokens.hasMoreTokens())
		{
			String strToken = strTokens.nextToken();
			aListSampleValues.add(strToken);
		}

		for(int s=0;s<dateCount.size();s++)
		{
			int countDisp=dateCount.size()-1;
			String dateValue=(String)dateCount.get(s);
			String changeCount = (String)aListSampleValues.get(s);
			String timeZone="";
			String tempStartDate = "";
			String tempEndDate = "";
			if(s==dateCount.size()-1)
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminites)%>&ec_endmin=<%=URLEncoder.encode(minites)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&selectDate=<%=URLEncoder.encode(dateValue)%>&ec_viewchange=byDate&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="">
<%
				}
			}
			else if(s==0)
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminites)%>&ec_endmin=<%=URLEncoder.encode(minites)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&selectDate=<%=URLEncoder.encode(dateValue)%>&ec_viewchange=byDate&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="">
<%
				}
			}
			else
			{
				if(countWeek!=null && countWeek.equalsIgnoreCase("1 day"))
				{
					timeZone = dateValue.substring(dateValue.indexOf('$')+1);
					if(timeZone.indexOf('0')>-1 && !timeZone.equals("0") && !timeZone.equals("10") && !timeZone.equals("20"))
						timeZone =timeZone.substring(timeZone.indexOf('0')+1);
					dateValue = dateValue.substring(0,dateValue.indexOf('$'));
				}
				else
				{
					sDate=(String)dateCount.get(0);
					eDate=(String)dateCount.get(countDisp);
				}

				tempStartDate = DateUtil.changeDateFormat(sDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDate = DateUtil.changeDateFormat(eDate,"MM/dd/yyyy",currentDateFormat);

				if (!changeCount.equals("0"))
				{
%>
					<param name="url_0_<%=s%>" value="/final/servlet/com.eg.EcConfigurationServlet?request_from=History&ec_rtype=<%=URLEncoder.encode("Change")%>&ec_option1=<%=URLEncoder.encode(selectionOption)%>&ec_option2=<%=URLEncoder.encode(server)%>&ec_timeline=<%=URLEncoder.encode("Any")%>&ec_prevtimeline=<%=URLEncoder.encode("Any")%>&ec_stdate=<%=URLEncoder.encode(tempStartDate)%>&ec_enddate=<%=URLEncoder.encode(tempEndDate)%>&ec_sthr=<%=URLEncoder.encode(shours)%>&ec_endhr=<%=URLEncoder.encode(hours)%>&ec_startmin=<%=URLEncoder.encode(sminites)%>&ec_endmin=<%=URLEncoder.encode(minites)%>&ec_changetype=<%=URLEncoder.encode("Latest")%>&selectDate=<%=URLEncoder.encode(dateValue)%>&ec_viewchange=byDate&timeZone=<%=timeZone%>">
					<param name="urltarget_0_<%=s%>" value="">
<%
				}
			}
		}
%>
					<param name="sampleAxisLabel" value="<%=sampleAxisLabel%>">
					<param name="sampleAxisLabelFont" value="Arial,normal,12">
					<param name="rangeAxisLabel" value='<egui:intnl text="configmgmt.changes.daywise.No of changes" />'>
					<param name="rangeAxisLabelFont" value="Arial,normal,11">
					<param name="samplelabelspacingon" value="true">
					<param name="barOutlineOff" value="true">
					<param name="bartype" value="stacked">
					<param name="rangeAxisLabelAngle" value="270">
					<param name="seriescount" value="2">
					<param name="valueLinesOn" value="true">
					<param name="depth" value="0.4">
					<param name="barwidth" value="0.3">
					<param name="singleClickURLOn" value="true">
					<param name="background" value="white">
				</applet>
			</td>
		</tr>
<%
	}
	else
	{
%>
		<tr>
			<td align="center" width="100%"  valign="middle">
				<table border="0" cellspacing="0" cellpadding="0" class="body_text" height="100%">
					<tr>
						<td  align="center" height="50%" valign="bottom">
							<img src="/final/config/images/unavailable-data.gif" alt='<egui:intnl text="configmgmt.common.No Data" />'>
						</td>
					</tr>
					<tr>
						<td align="center" valign="top">
							<egui:intnl text="configmgmt.dashboard.No configuration changes have been found" />
						</td>
					</tr>
				</table>
			</td>
		</tr>
<%
	}
%>
	</table>
<!-- </form> -->
</body>
</html>



