<%
/*
	File			:	EcConsolidateView.jsp
	Purpose			:	Consolidated view across test measures for infrastructure components
	Creation Date	:	11-10-2010
	Author			:	Krishnamurthi
	UI Design		:	Krishnamurthi & Jaiwin
*/
%>

<%@ include file="EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.User"%>
<%@ page import="com.egurkha.UserRegistry"%>
<%@ page import="java.util.*"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgName"%>
<%@ page import="com.eg.MappingNameSorter"%>
<%@ page import="egurkha.config.EcConsolidatedView"%>
<%@ page import="egurkha.config.EcUtils"%>
<%@ page import="com.eg.EgConfigConstants"%>
<%@ page import="com.eg.EgConfigTestsInfo"%>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="com.egurkha.pdfmaker.*"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>
<%@ page import = "com.egurkha.util.DateUtil"%>
<%@ page import = "com.eg.EgInstallInfo" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EcUtils ecUtils = new EcUtils();

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	String configSkin = user.getConfigSkin();

	String strsubmitClicked = request.getParameter("submitClicked");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */

	String componentType = request.getParameter("componentType");
	String o_componentType = request.getParameter("old_comptype");
	String[] s_selectedComponents = request.getParameterValues("components");
	String testName = request.getParameter("testName");
	String o_testName = request.getParameter("old_testname");
	String[] descriptor = request.getParameterValues("descriptor");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (ec_criteria != null && 
		ec_criteriaPrevious != null && 
		!ec_criteriaPrevious.equals(ec_criteria))
	{
		componentType = null;
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (ec_userOption != null && 
		ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && 
		ec_criteria != null && ec_criteriaPrevious != null)
	{
		componentType = null;
	}
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");

	String request_from = request.getParameter("request_from");
	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");

	Vector vecComponentTypes = new Vector();
	Vector vec_components = new Vector();
	Vector vec_ctypes = new Vector();
	vec_ctypes.addAll(aListAssociatedComponents);
	for (int i=0; i<vec_ctypes.size(); i++)
	{
		String str = (String) vec_ctypes.get(i);
		String component_type = str.substring(0,str.indexOf(":"));
		boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
		if (!isConfigTestEnabled) continue;
		if (!vecComponentTypes.contains(component_type))
		{
			vecComponentTypes.add(component_type);
		}
		String component_name = str.substring(str.indexOf(":")+1);
		vec_components.add(component_name+":"+component_type);
	}

	if (vecComponentTypes.contains("Host_system"))
	{
		vecComponentTypes.remove("Host_system");
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector) scheduleDetails.get("vecUserOptions");
		Object temp = (Object)scheduleDetails.get("descriptor");
		if (temp instanceof String)
		{
			descriptor = new String[]{(String)temp};
		}
		else if (temp instanceof String[])
		{
			descriptor = (String[])temp;
		}
		componentType = (String) scheduleDetails.get("componentType");
		Object comp = (Object)scheduleDetails.get("components");
		if (comp instanceof String)
		{
			s_selectedComponents = new String[]{(String)comp};
		}
		else if (comp instanceof String[])
		{
			s_selectedComponents = (String[])comp;
		}
		testName = (String) scheduleDetails.get("testName");
		o_componentType = (String) scheduleDetails.get("old_comptype");
		o_testName = (String) scheduleDetails.get("old_testname");
	}

	ArrayList al_components = null;
	if (componentType != null && !componentType.equals("-1"))
	{
		al_components = new ArrayList();
		for (int k=0;k<vec_components.size();k++)
		{
			String strComp = (String)vec_components.get(k);
			String component_Type = strComp.substring(strComp.lastIndexOf(":")+1);
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_Type);
			if (!isConfigTestEnabled) continue;
			if (componentType!=null && strComp.endsWith(componentType))
			{
				al_components.add(strComp);
			}
		}
	}

	ArrayList sortedTestList = new ArrayList();
	if (componentType != null && !componentType.equals("-1"))
	{
		ArrayList aListEnabledConfigTests = specsInfo.getEnabledTests(componentType,true);
		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	if (componentType != null && !componentType.equalsIgnoreCase(o_componentType))
	{
		s_selectedComponents = null;
		testName = "";
		descriptor = null;
	}

	List l_selectedComponents = null;
	if (s_selectedComponents != null && !s_selectedComponents[0].equals("-1"))
	{
		l_selectedComponents = Arrays.asList(s_selectedComponents);
	}

	if (testName != null && !testName.equalsIgnoreCase(o_testName))
	{
		descriptor = null;
	}

	Vector vecDescriptors = null;
	if (l_selectedComponents != null && !l_selectedComponents.isEmpty() && 
		testName != null && !testName.equals("-1"))
	{
		EcConsolidatedView ecConsolidatedView = new EcConsolidatedView();
		Map hostAgentsMapping = (Map)session.getAttribute("hostAgentsMapping");
		ecConsolidatedView.setHostAgentsMapping(hostAgentsMapping);
		vecDescriptors = ecConsolidatedView.getDescriptor(testName,componentType,s_selectedComponents);
	}

	List l_selectedDescriptors = null;
	if (descriptor != null && !descriptor[0].equals("-1"))
	{
		l_selectedDescriptors = Arrays.asList(descriptor);
	}
	else if (descriptor == null || descriptor[0].equals("-1"))
	{
		if (vecDescriptors != null && !vecDescriptors.isEmpty())
		{
			ArrayList aList_temp = new ArrayList();
			aList_temp.add((String)vecDescriptors.get(0));
			l_selectedDescriptors = aList_temp;
		}
	}

	ArrayList aListConsolidatedData = (ArrayList)request.getAttribute("aListConsolidatedData");
	session.setAttribute("ConsolidatedViewData",aListConsolidatedData);
	session.setAttribute("componentType",componentType);
	session.setAttribute("testName",testName);

	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String userName = (String)session.getAttribute("sess_auserid");

	String id = request.getParameter("id");

	if (strsubmitClicked == null)
	{
		strsubmitClicked = "false";
	}
	String submitOrNot = "true";
	String strBackRequest = request.getParameter("back_request");
	if (strBackRequest != null && strBackRequest.equalsIgnoreCase("ScheduleConfig") && strsubmitClicked != null && strsubmitClicked.equalsIgnoreCase("false"))
	{
		submitOrNot = "false";
	}
%>

<html>
<head>
<title></title>
<meta name="Author" content="Krishnamurthi">
<egui:skin ui="config"/>
<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
<script language="JavaScript1.2" src="/final/jquery/jquery.js"></script>
<script language="javaScript1.2">
//Screen width script starts here
documentView = {
	getObject: function()
	{
		if(typeof( window.innerWidth) == 'number')
		{//Firefox
			this.height = window.innerHeight;
			this.width = window.innerWidth-10;
			this.fireFox = true;
		}
		else if( document.documentElement && ( document.documentElement.clientWidth
			|| document.documentElement.clientHeight ))
		{//IE 6 + in 'standards compliant mode'
			this.height = document.documentElement.clientHeight;
			this.width = document.documentElement.clientWidth;
			this.ie = true;
		}
		else if(document.body && document.body.clientHeight)
		{ //IE 4 compatible
			this.height = document.body.clientHeight;
			this.width = document.body.clientWidth;
			this.ie = true;
		}
		this.screenHeight=window.screen.availHeight;
		this.screenWidth=window.screen.availWidth;
		return this;
	},
	getScreenHeight: function()
	{
		return this.getObject().screenHeight;
	},
	getScreenWidth: function()
	{
		return this.getObject().screenWidth;
	},
	getHeight: function()
	{
		return this.getObject().height;
	},
	getWidth: function()
	{
		return this.getObject().width;
	},
	isIE: function()
	{
		return this.getObject().ie;
	},
	isFireFox: function()
	{
		return this.getObject().fireFox;
	}
};
var old_width=0;
function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}
	var selectEleObj = document.getElementsByTagName('select');
	if(selectEleObj!=null && selectEleObj!=undefined)
	{
		var countSelect=selectEleObj.length;
		for(var i=0;i<countSelect;i++)
		{
			var selectWidth = selectEleObj[i].offsetWidth;
			if(selectWidth!=null && selectWidth!=undefined)
			{
				var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
				selectEleObj[i].style.width=(newSelectWidth)+"px";
			}
		}
	}
	old_width=documentView.getWidth();
}

window.onresize = bigScreenPage;
</SCRIPT>

<!-- Screen width script end here -->
<script language="JavaScript1.2">
function get()
{
	var thisForm = document.forms[0];
	var idForSchedule = '<%=id%>';
	if (idForSchedule != 'null')
	{
		thisForm.action = "../config/EcConsolidatedView.jsp?id=<%=id%>&request_from=saveSchedule";
	}
	else
	{
		thisForm.action = "../config/EcConsolidatedView.jsp";
	}
	thisForm.submit();
}

function showDetails(path)
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption != undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var server = thisForm.componentType.value;
	if (server == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component type" />');
		return;
	}

	var comps = thisForm.components.value;
	if (comps == "-1" || comps == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one component for the chosen component type" />');
		return;
	}

	var test = thisForm.testName.value;
	if (test == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select a report type" />');
		return;
	}

	var desc = thisForm.descriptor.value;
	if (desc == "-1" || desc == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one valid descriptor" />');
		return;
	}

	if(path == "submit")
	{
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet";
		thisForm.submit();
		thisForm.x.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
		thisForm.x.disabled = true;
	}
}

function validateforSchedule()
{
	var thisForm = document.forms[0];

	var tempCriteria = "";
	var tempUserOption = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}

	if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
	{
		if (tempUserOption != null && tempUserOption != undefined && tempUserOption == -1)
		{
			if (tempCriteria == "Zone")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
				return false;
			}
			else if (tempCriteria == "Service")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
				return false;
			}
			else if (tempCriteria == "Segment")
			{
				alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
				return false;
			}
		}
	}

	var server = thisForm.componentType.value;
	if (server == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select a component type" />');
		return false;
	}

	var comps = thisForm.components.value;
	if (comps == "-1" || comps == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one component for the chosen component type" />');
		return false;
	}

	var test = thisForm.testName.value;
	if (test == "-1")
	{
		alert('<egui:intnl text="configmgmt.common.Please select a report type" />');
		return false;
	}

	var desc = thisForm.descriptor.value;
	if (desc == "-1" || desc == '')
	{
		alert('<egui:intnl text="configmgmt.common.Please select atleast one valid descriptor" />');
		return false;
	}
}

function printData()
{
<%
	if (aListConsolidatedData == null || aListConsolidatedData.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}

	StringBuffer printQS = new StringBuffer();
	printQS.append("ec_type=Consolidated_View");
	printQS.append("&ec_trgttype=REPORT");
	printQS.append("&printData=yes");
	printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
	printQS.append("&user_language="+userLanguage);
	printQS.append("&ec_criteria="+ec_criteria);
	printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
%>
	var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
	print(s_qryString);
}

function savePdf()
{
<%
	if (aListConsolidatedData == null || aListConsolidatedData.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
	session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
	session.setAttribute("REPORT_NAME","ConsolidatedView");
	session.setAttribute("REPORT_LAYOUT","Portrait");
	session.setAttribute("PAGE_WIDTH_PDF","1100");
	session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
	session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
	getPdf('<%=configSkin%>');
}

function mail()
{
<%
	if (aListConsolidatedData == null || aListConsolidatedData.isEmpty())
	{
%>
	alert('<egui:intnl text="configmgmt.common.No data available" />');
	return;
<%
	}
%>
	sendMail();
}

function getDetails()
{
	thisForm = document.ConsolidatedConfig;
	var tempCriteria = "";
	var tempUserOption = "";
	var tempCriteriaPrevious = "";
	var tempUserOptionPrevious = "";
	if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
	{
		tempCriteria = thisForm.ec_criteria.value;
	}
	if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
	{
		tempUserOption = thisForm.ec_userOption.value;
	}
	if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
	{
		tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
	}
	if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
	{
		tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
	}
	window.location.href = "../servlet/com.eg.EcConfigurationServlet?cmd=ConsolidatedView&ec_criteria="+tempCriteria+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&id=<%=id%>&request_from=<%=request_from%>";
}

function csv()
{
<%
	if (aListConsolidatedData == null || aListConsolidatedData.isEmpty())
	{
%>
		alert('<egui:intnl text="configmgmt.common.No data available" />');
		return;
<%
	}
%>
	thisForm = document.forms[0];
	thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
	thisForm.submit();
}

function schedule(op)
{
	var checkFlag = validateforSchedule();
	if(checkFlag == false) return;
	var thisForm = document.ConsolidatedConfig;
	if (op == "schedule")
	{
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
		}
		else
		{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=Consolidated";
<%
		}
%>
	}
	else if (op =="favorite")
		thisForm.action = "/final/config/EcSaveFavorite.jsp";
	else
	{
		alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
		return;
	}
	thisForm.submit();
}

function goBackToSaveSchedule()
{
	var thisForm = document.forms[0];
	thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
	thisForm.submit();
}

$(document).ready(function(){
	var selectionTableHeight = $('.selectionTable').height();
	$('.bottomHeight') .css({'height': (($(window).height()) - (selectionTableHeight+64))+'px'});
	$('.bottomHeight') .css({'width': (($(window).width()) - 14)+'px'});
});

$(window).resize(function(){
	var selectionTableHeight = $('.selectionTable').height();
	$('.bottomHeight') .css({'height': (($(window).height()) - (selectionTableHeight+64))+'px'});
	$('.bottomHeight') .css({'width': (($(window).width()) - 14)+'px'});
});
</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" scrolling="no" style="overflow:hidden" onLoad="bigScreenPage();">
<form name="ConsolidatedConfig" method="post" style="margin:0px;padding:0px;">
<input type="hidden" name="ec_rtype" value="Consolidated">
<input type="hidden" name="ec_trgttype" value="Configuration Report">
<input type="hidden" name="old_comptype" value="<%=componentType%>">
<input type="hidden" name="old_testname" value="<%=testName%>">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

	<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" class="bgmedium">

		<tr>
			<td align="right" valign="middle" id="layer_headbg" height="24" width="100%" style="padding:0px;border-left-width:0px;border-right-width:0px">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<td align="left" id="main_head_top" width="77%" nowrap>
							&nbsp;<b><egui:intnl text="configmgmt.consolidated.CONSOLIDATED VIEW" /></b>
						</td>
						<td align="right" id="main_head_top" width="77%" nowrap>
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
						<a id='mouse' onClick="goBackToSaveSchedule();">
							<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
						</a>
<%
	}
%>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr>
			<td valign="top" id="bgmedium" width="100%" height="100%">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
				<!-- new tab start here -->
					<tr>
						<td id="padding6" style="padding-bottom:0px">
							<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
								<col width="55"><col width="10"><col width="170">
								<col width="150"><col width="10"><col width="350">
								<tr>
									<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
									<td align="center"><b>:</b></td>
									<td valign="middle">
										<select name="ec_criteria" style="width:170px;" onChange='javascript:getDetails()'>
<%
	if (vecCriterias != null && !vecCriterias.isEmpty())
	{
		for(int i=0; i<vecCriterias.size(); i++)
		{
			String selected = "";
			String strCriteria = (String)vecCriterias.get(i);
			if(ec_criteria != null && strCriteria.equals(ec_criteria))
			{
				selected = "selected";
			}
%>
			<option value="<%=strCriteria%>" <%=selected%>>
				<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
			</option>
<%
		}
	}
	else
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Not Applicable" />
		</option>
<%
	}
%>
										</select>
									</td>
<%
	if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
	{
%>
									<td align="right" nowrap>
<%
		if (ec_criteria.equalsIgnoreCase(criterias[0]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
		}
		else if (ec_criteria.equalsIgnoreCase(criterias[1]))
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
		}
		else
		{
%>
			<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
		}
%>
									</td>
									<td align="center"><b>:</b></td>
									<td>
										<select name="ec_userOption" style="width: 250px;" onChange='javascript:getDetails()'>
<%
		if (vecUserOptions != null && !vecUserOptions.isEmpty())
		{
			for(int i=0; i<vecUserOptions.size(); i++)
			{
				String selected = "";
				String strUserOption = (String)vecUserOptions.get(i);
				if(ec_userOption != null && strUserOption.equals(ec_userOption))
				{
					selected = "selected";
				}
%>
				<option value="<%=strUserOption%>" <%=selected%>>
					<%=strUserOption%>
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
										</select>
									</td>
<%
	}
	else
	{
%>
									<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
	}
%>
								</tr>
							</table>
						</td>
					</tr>
					<!-- new tab end here -->
					<tr>
						<td width="100%" valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" class="selectionTable">
								<tr>
									<td id="padding6" valign="top">
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="30%"><col width="70%">
														<tr>
															<td  height="5" id="blank" colspan="2">&nbsp; </td>
														</tr>

														<tr>
															<td align="right">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.consolidated.Component Type" />&nbsp;:&nbsp;</b></td>
															<td align="left" colspan="3">
																<select name="componentType" onChange="javascript:get();" style="width:250px">
<%
	if (vecComponentTypes != null && !vecComponentTypes.isEmpty())
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Please choose a component type" />
													</option>
<%
		ArrayList serverList = sorter.getSortedCompTypeList(vecComponentTypes);
		for (int i=0; i<serverList.size(); i++)
		{
			EgName nameObj = (EgName)serverList.get(i);
			String actualName = nameObj.getActualName();
			String localName = nameObj.getLocalName();
			String selected = "";
			if (actualName.equals(componentType))
			{
				selected = "selected";
			}
%>
			<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
		}
	}
	else
	{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="30%"><col width="70%">
														<tr>
															<td align="right" valign="top">&nbsp;&nbsp;<b><egui:intnl text="configmgmt.consolidated.Components" />&nbsp;:&nbsp;</b></td>
															<td align="left">
																<select name="components" style="width: 300px;" size="6" multiple onChange="javascript:get();">
<%
	if (al_components != null)
	{
		for (int k=0;k<al_components.size();k++)
		{
			String strComponent = (String)al_components.get(k);
			String tempCompName = strComponent.substring(0,strComponent.lastIndexOf(":"));
			if (tempCompName.endsWith(":NULL"))
			{
				tempCompName = tempCompName.substring(0,tempCompName.indexOf(":"));
			}
			String selected = "";
			if (l_selectedComponents != null && l_selectedComponents.contains(strComponent))
			{
				selected = "selected";
			}
%>
			<option value="<%=strComponent%>" <%=selected%>><%=tempCompName%></option>
<%
		}
	}
	else
	{
%>
		<option value= "-1"><egui:intnl text="configmgmt.common.Not Applicable" /></option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="30%"><col width="70%">
														<tr>
															<td align="right" nowrap><b><egui:intnl text="configmgmt.consolidated.Report Type" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" valign="top">
																<select name="testName" onChange="javascript:get();" style="width:250px">
<%
	if (sortedTestList != null && sortedTestList.size() > 0)
	{
%>
		<option value="-1">
			<egui:intnl text="configmgmt.common.Please choose a report type" />
		</option>
<%
		for (int i=0;i<sortedTestList.size();i++)
		{
			EgName nameObj = (EgName)sortedTestList.get(i);
			String strTestName = nameObj.getActualName();
			String strDispName = nameObj.getLocalName();
			String selected = "";
			if (strTestName.equals(testName))
			{
				selected = "selected";
			}
%>
			<option VALUE="<%=strTestName%>" <%=selected%>><%=strDispName%></option>
<%
		}
	}
	else
	{
%>
		<option VALUE= "-1"><egui:intnl text="configmgmt.common.Not Applicable" /></option>
<%
	}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>
<%
	if (vecDescriptors != null && !vecDescriptors.isEmpty())
	{
		if (!vecDescriptors.contains("+") && 
			!vecDescriptors.contains(EgConfigConstants.CF_EMPTY_WITH_COLON+"~M~") && 
			!vecDescriptors.contains(EgConfigConstants.CF_EMPTY+"~M~"))
		{
%>
											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="30%"><col width="70%">
														<tr>
															<td align="right" valign="top" nowrap><b><egui:intnl text="configmgmt.consolidated.Descriptors" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" valign="top">
																<select name="descriptor" size="5" multiple style="width:250px">
<%
			for (int i=0;i<vecDescriptors.size();i++)
			{
				String strDescriptor = (String)vecDescriptors.get(i);
				String strDescriptorForDisplay = ecUtils.getInfoForDisplay(strDescriptor);
				String selected = "";
				if (l_selectedDescriptors != null && l_selectedDescriptors.contains(strDescriptor))
				{
					selected = "selected";
				}
%>
				<option VALUE="<%=strDescriptor%>" <%=selected%>><%=strDescriptorForDisplay%></option>
<%
			}
%>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>
<%
		}
		else
		{
%>
			<input type="hidden" name="descriptor" value="<%=(String)vecDescriptors.get(0)%>">
<%
		}
	}
	else
	{
%>
											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed">
														<col width="30%"><col width="70%">
														<tr>
															<td align="right" valign="top" nowrap><b><egui:intnl text="configmgmt.consolidated.Descriptors" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" valign="top">
																<select name="descriptor" size="5" multiple style="width:250px">
																	<option value="-1" selected><egui:intnl text="configmgmt.common.Not Applicable" /></option>
																</select>
															</td>
														</tr>
													</table>
												</td>
											</tr>
<%
	}
%>
											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td width="100%">
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><col width="86%"><col width="14%">
														<tr>
															<td align="center" height="20">
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
																<input type="button" name="btnsubmit" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="schedule('schedule');">
<%
	}
	else
	{
%>
																<input type="button" name="x" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:showDetails('submit')">
<%
	}
%>
															</td>
															<td align="right"  style="height:24" valign="bottom">
																<table align="right" cellspacing="0" cellpadding="0" border="0" height="20"> 
																	<tr>
																		<td width="50" align="center" id="leftcurve"><img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
																		<td width="2" align="center"  id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="2"></td>
																		<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()"> </td>
																		<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif" width="12"></td>
																		<td align="center" id="leftcurvebg"><img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>
																		<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
																		<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>
																		<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
																		<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"></td>
																		<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
																		<td align="center" id="leftcurvebg"><img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>
																		<td width="12" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="12"></td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>

					<tr>
						<td id="padding6" height="100%" width="100%" valign="top" style="padding-top:0px">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
								<tr>
									<td align="center">
										<table border="0" align="center" width="100%"  height="100%" id="bottomtable" cellspacing="0" cellpadding="0">
											<tr>
												<td align="center" valign="top">
												<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;">
<%
	if (aListConsolidatedData != null && !aListConsolidatedData.isEmpty() && submitOrNot.equalsIgnoreCase("true"))
	{
		ArrayList aListDistinctDescriptors = (ArrayList)aListConsolidatedData.get(0);
		ArrayList aListAllMeasures = (ArrayList)aListConsolidatedData.get(1);
		TreeMap tmapData = (TreeMap)aListConsolidatedData.get(2);
		int idx_msize = aListAllMeasures.size();

		//For New Pdf Framework
		ArrayList aListPdfData = new ArrayList();
		EgPdfData pdfData = new EgPdfData();

		EgReportAttributes reportAttributes = new EgReportAttributes();

		String pdfTitle = "";
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CONSOLIDATED VIEW REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		else
		{
			pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CONSOLIDATED VIEW REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
		}
		reportAttributes.setMainTitle(pdfTitle);

		String subTitle = mappingInfo.getTextDescription("configmgmt.consolidated.Component Type") + " : " + mappingInfo.getComponentTypeDescription(componentType) + "\n" + mappingInfo.getTextDescription("configmgmt.consolidated.Report Type") + " : " + mappingInfo.getTestDescription(testName);

		reportAttributes.setSubTitle(subTitle);
		reportAttributes.setReportName("ConsolidatedView");
		reportAttributes.setModule("CONFIG");
		reportAttributes.setPortrait(false);
		pdfData.setAttributes(reportAttributes);
%>
													<input type="hidden" name="submitClicked" value="true">
													<table border="0" align="center" width="100%" class="body_text" height="100%" cellspacing="0" cellpadding="4">
														<tr>
															<td valign="top">
<%
		for (int i=0;i<aListDistinctDescriptors.size();i++)
		{
			String strDescriptor = (String)aListDistinctDescriptors.get(i);
			ArrayList aListData = (ArrayList)tmapData.get(strDescriptor);
			int idx_dataSize = aListData.size();

			ArrayList aListInfoHeadings = null;
			boolean isDynamicMeasureTest = false;
			int idx_M = strDescriptor.indexOf("~M~");
			if (idx_M != -1)
			{
				isDynamicMeasureTest = true;

				aListInfoHeadings = new ArrayList();
				String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testName);
				if (infoHeadings != null && infoHeadings.length() > 0)
				{
					StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
					while (strTokensTemp.hasMoreTokens())
					{
						String str_temp = strTokensTemp.nextToken();
						aListInfoHeadings.add(str_temp);
					}
				}
			}

			EgTableAttributes egTableAttributes = new EgTableAttributes();
			egTableAttributes.setStartX(0);

			ArrayList aListColumnNames = new ArrayList();
			ArrayList aListData_A = new ArrayList();
			ArrayList userColumnNames = new ArrayList();
%>
																<table border="0" width="100%" class="body_text linesquare" cellspacing="0" cellpadding="0">
<%
			if (!strDescriptor.equals("+") && 
				!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) && 
				!ecUtils.getInfoForDisplay(strDescriptor).equals(EgConfigConstants.CF_EMPTY))
			{
				if (!isDynamicMeasureTest)
				{
%>
																	<tr>
																		<td colspan="<%=idx_msize%>" id="eg_calth" style="font-weight:bold;padding:2px"><%=ecUtils.getInfoForDisplay(strDescriptor)%></td>
																	</tr>
<%
					egTableAttributes.setTitle(ecUtils.getInfoForDisplay(strDescriptor));
				}
				else
				{
					ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(strDescriptor),"~M~");
					int aListTokensSize = aListTokens.size();
					String strData = "";
					for (int x=0;x<aListTokensSize;x++)
					{
						String infoHeading = (String)aListInfoHeadings.get(x);
						String strTemp = (String)aListTokens.get(x);
						if (x == aListTokensSize-1)
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
						}
						else
						{
							strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
						}
					}
					egTableAttributes.setTitle(strData);
%>
																	<tr>
																		<td colspan="<%=idx_msize%>" id="eg_calth" style="font-weight:bold;padding:2px"><%=strData%></td>
																	</tr>
<%
				}
			}
%>
																	<tr>
<%
			for (int j=0;j<idx_msize;j++)
			{
				aListColumnNames.add("C"+j);
				userColumnNames.add((String)aListAllMeasures.get(j));
%>
																		<td id="cell_header"><%=(String)aListAllMeasures.get(j)%></td>
<%
			}
%>
																	</tr>
<%
			boolean hasXMLData = false;
			if (aListData != null && aListData.size() > 0)
			{
				for (int k = 0; k < aListData.size(); k++)
				{
					String val = (String)aListData.get(k);
					if (val.startsWith("<?configuration?>"))
					{
						hasXMLData = true;
						break;
					}
				}
			}

			for (int m=0;m<idx_dataSize;m=m+idx_msize)
			{
%>
																	<tr>
<%
				for (int n=m;n<m+idx_msize;n++)
				{
					String strData = (String)aListData.get(n);
					if (!strData.startsWith("<?configuration?>"))
					{
						strData = EcUtils.replaceTags(strData);
					}

					if (hasXMLData)
					{
						// for UI
						strData = StringUtils.replace(strData,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");

						// for CSV
						String newStrData = StringUtils.replace(strData,"<?configuration?><config>","");
						newStrData = StringUtils.replace(newStrData,"</config>","");
						newStrData = StringUtils.replace(newStrData,"<ul>","");
						ArrayList tkns = StringUtils.myTokenizer(newStrData,"</ul>");
						int tknsSize = tkns.size();
						
						if ((n%2) == 1)
						{
							for (int c = 0; c < tknsSize; c++)
							{
								String strLine = (String)tkns.get(c);
								strLine = StringUtils.replace(strLine,"<ul>","");
								
								if (c == 0)
								{
									aListData_A.add(aListData.get(n-1)); // Columnname
								}
								else
								{
									aListData_A.add(""); // Columnname
								}

								if (strLine.equalsIgnoreCase("&nbsp;"))
								{
									aListData_A.add(""); // Columnvalue
								}
								else
								{
									aListData_A.add(strLine); // Columnvalue
								}
							}
						}
					}
					else
					{
						aListData_A.add(strData);
					}
%>
																		<td valign="top" id="cell_bg1"><%=strData%></td>
<%
				}
%>
																	</tr>
<%
			}
%>
																</table>
																<table>
																	<tr>
																		<td height="5" id="blank" colspan="<%=idx_msize%>">&nbsp;</td>
																	</tr>
																</table>
<%
			//For new Pdf Framework
			EgTableModel egTableModel = new EgTableModel(aListData_A,aListColumnNames);

			egTableAttributes.setColumnNames(userColumnNames);

			EgTable egTable = new EgTable();
			egTable.setModel(egTableModel);
			egTable.setAttributes(egTableAttributes);

			aListPdfData.add(egTable);
		}
%>
															</td>
														</tr>
													</table>
													</div>
<%
		//For new pdf framework
		pdfData.setData(aListPdfData);
		session.setAttribute("pdfData",pdfData);
	}
	else if (aListConsolidatedData != null && aListConsolidatedData.isEmpty())
	{
%>
													<table border="0" align="center" width="100%" height="100%">
														<tr>
															<td align="center">
																<table border="0" align="center" width="100%" class="body_text" >
																	<tr>
																		<td align="center"><img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'></td>
																	</tr>
																	<tr>
																		<td align="center"><b><egui:intnl text="configmgmt.common.No result found for current selection" /></b></td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
<%
	}
	else if (aListConsolidatedData == null)
	{
%>
													<table border="0" align="center" width="100%" height="100%">
														<tr>
															<td align="center">&nbsp;</td>
														</tr>
													</table>
<%
	}
%>
												</div>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
</form>
</body>
</html>



