<%
/*
	File		:	EcConfigPrint.jsp
	Purpose		:	Create print option for the components view page (Network devices and Virtual servers)
*/
%>

<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "egurkha.config.EcUtils" %>
<%@ page import = "egurkha.config.EcProcessData"%>
<%@ page import = "egurkha.config.EcPrintData"%>
<%@ page import = "egurkha.config.EcUserData"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgConfigTestsInfo" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.text.*"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld" %>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	String[] criterias = {"Zone","Service","Segment","Component"};
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");

	EgConfigTestsInfo  configTestsInfo=new EgConfigTestsInfo("manager");
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	IniUI iniUI = IniUI.getInstance();

	SimpleDateFormat formatter = new SimpleDateFormat (currentDateFormat+" " +"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConverter = new EgTimeZoneConverter(dateString,user);
	dateString = (String)timeZoneConverter.getDateTime();
	/* Added by Prakash.K Ends */
	
	String ec_userName = request.getParameter("userName");
	String ec_user_language = request.getParameter("user_language");

	//user language
	String userLanguage = null;
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	else if (user == null)
	{
		EcUserData ecUserData = new EcUserData(ec_userName,false);
		user = ecUserData.getUser(ec_userName);
		userLanguage = ec_user_language;
	}

	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgDbInfo dbInfo = new EgDbInfo("manager");

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	String ec_forPDF = request.getParameter("ec_forPDF");

	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		ec_criteria = request.getParameter("ec_criteria");
		ec_userOption = request.getParameter("ec_userOption");
	}

	String printPageTitle = request.getParameter("printPageTitle");
	String pageTitle = "";
	String tableTitle = "";
	if (printPageTitle.equals("Network_Devices"))
	{
		pageTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY NETWORK DEVICES");
		tableTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of Network Devices");
	}
	else if (printPageTitle.equals("Virtual_Platforms"))
	{
		pageTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY VIRTUAL PLATFORMS");
		tableTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of Virtual Platforms");
	}
	else if (printPageTitle.equals("Servers"))
	{
		pageTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.INVENTORY REPORT BY SERVERS");
		tableTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.Distribution of Servers");
	}

	String fontStyle = "";
	if ((dbInfo.doubleByteEnabled || !userLanguage.equals("en_US")) && 
		(ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes")))
	{
		fontStyle = "multi_font";
	}
%>

<html style="background:#ffffff!important">
<head>
<title><egui:intnl text="configmgmt.common.eG Configuration Report" /></title>
<egui:skin ui="config"/>

<script language="Javascript">
	window.print();

</script>
</head>

<body topmargin="0" marginheight="0" leftmargin="0" marginwidth="0">
<form name="printData">
<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
<input type="hidden" name="ec_userOptionPrevious" value="<%=ec_userOption%>">

<table width="99%" align="center" cellspacing="0" cellpadding="0" border="0">

<%
	if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("No"))
	{
%>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="5">
		</td>
	</tr>
	<tr>
		<td align="center">
			<table align="center" cellspacing="0" cellpadding="0" height="24" border="0" width="100%" class="body_text">
				<tr>
					<td align="center">
						<b><egui:intnl text="configmgmt.common.Generated on" />&nbsp;<%=dateString%></b>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td>
			<table width="100%" align="center" cellspacing="0" cellpadding="0" border="0" class="body_text">
				<tr>
					<td align="center" height="24" >
						<table align="center" cellspacing="0" cellpadding="5" height="24" border="0" width="100%" id="bottomtable">
							<tr>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
								<td width="95%"><b><%=pageTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></td>
<%
		}
		else
		{
%>
								<td width="95%"><b><%=pageTitle.toUpperCase()%></b></td>
<%
		}
%>
								<td align="center" width="5%" >
									<img class="mouse" src="../config/images/printer_print.jpg" border="0" onClick="javascript:print()">
								</td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table></td></tr>
<%
	}
	else if (ec_forPDF != null && ec_forPDF.equalsIgnoreCase("Yes"))
	{
		//String imageName = iniUI.getConfigHomeLogo();
		String imageName = user.getConfigLogo();
%>
	<tr>
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0">
				<tr>
					<td align="left" width="30%" valign="bottom"><img src="<%=imageName%>" border="0"></td>
					<td width="70%" align="right" valign="bottom">
						<table width="100%" border="0" cellspacing="0" cellpadding="0">
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
			ec_criteria = ec_criteria.toUpperCase();
			ec_userOption = ec_userOption.toUpperCase();
%>
							<tr>
								<td align="right" class="<%=fontStyle%>"><b><%=pageTitle.toUpperCase()%>&nbsp;<egui:intnl text="IN" />&nbsp;'<%=ec_userOption%>'&nbsp;<%=ec_criteria%></b></b></td>
							<tr>
<%
		}
		else
		{
%>
							<tr>
								<td align="right" class="<%=fontStyle%>"><b><%=pageTitle.toUpperCase()%></b></td>
							</tr>
<%
		}
%>
							<tr>
								<td>
									<img src="/final/config/images/spacer.gif" border="0">
								</td>
							</tr>
							<tr>
								<td align="right" valign="bottom" class="<%=fontStyle%>"><b><egui:intnl text="configmgmt.configuration.as on" />&nbsp;<%=dateString%></b></td>
							</tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td height="5">
			<img src="/final/config/images/spacer.gif" border="0" height="50">
		</td>
	</tr>
<%
	}

	String requestFrom = request.getParameter("requestFrom");
	EcPrintData printData = null;
	if (requestFrom != null && requestFrom.equals("Schedule"))
	{
		printData=(EcPrintData)request.getAttribute("print_comp_information");
	}
	else
	{
		printData=(EcPrintData)session.getAttribute("print_comp_information");
	}

	Map resultData=printData.getMapData();
	List resultList = new ArrayList(printData.getListData());
	String componentType=printData.getComponent();
	componentType = (componentType == null)?"":componentType;
%>
	<tr>
		<td align="center">
			<table border="0" width="100%" cellspacing="0" class="body_text" cellpadding="0">
<%
	if(!componentType.equalsIgnoreCase("All"))
	{
%>
				<tr>
					<td height="20" class="<%=fontStyle%>">
						&nbsp;<b><egui:intnl text="configmgmt.inventory.view.List of Components"/></b>
					</td>
				</tr>
<%
	}
	else
	{
%>
				<tr>
					<td height="20" id="linesquare" class="<%=fontStyle%>">
						&nbsp;<b><%=tableTitle%></b>
					</td>
				</tr>
<%
	}
%>
				<tr>
					<td colspan="2" align="center">
						<table width="100%" border="0" cellpadding="0" cellspacing="0">
<%
	if(componentType!=null && componentType.equals("All") && resultList.size() > 1)
	{
%>
							<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
							<tr>
								<td width="100%" align="center">
									<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="98%" >
										<tr>
											<td width="100%" align="center">
												<table cellspacing="0" cellpadding="0" border="0" class="body_text" width="100%" >
													<tr>
														<td width="100%" align="center">
<%
		String countName=printData.getSampleLabel();
		String countValue=printData.getSampleValue();
		String colorValue=printData.getSampleColor();
		String titleName=printData.getChartTitle();
%>
															<img src="../servlet/com.eg.EcChartController?view=GRAPH&pageName=DASHBOARD_OS&chartType=PieChart&height=160&width=430&chartTitle=<%=EgURLEncoder.encode(titleName,"UTF-8")%>&sampleValues=<%=EgURLEncoder.encode(countValue,"UTF-8")%>&sampleLabels=<%=EgURLEncoder.encode(countName,"UTF-8")%>&sampleColors=<%=EgURLEncoder.encode(colorValue,"UTF-8")%>&userName=<%=EgURLEncoder.encode(ec_userName,"UTF-8")%>" border="0" hspace="0">
														</td>
													</tr>
												</table>
											</td>
										</tr>
										<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
<%
	}

	Iterator it = resultData.keySet().iterator();
	for (int i=0; i<resultList.size(); i++)
	{
		Hashtable ht = (Hashtable)resultList.get(i);
		Iterator htIt = ht.keySet().iterator();
		String compType = "";
		if (htIt.hasNext())
		{
			compType = (String)htIt.next();
		}
		if (!componentType.equals("All") && !componentType.equals("Others") && !compType.equals(componentType))
		{
			continue;
		}
		ArrayList compList = (ArrayList)ht.get(compType);
%>
										<tr>
											<td width="100%" align="right">
												<table cellspacing="0" cellpadding="0" border="0" width="100%" id="bottomtable" style="border-bottom-width:0px">
													<tr>
														<td width="100%" align="left" id="linebottom" height="20" colspan="3" class="<%=fontStyle%>">&nbsp;<b><%=mappingInfo.getComponentTypeDescription(compType)%>&nbsp;(<egui:intnl text="configmgmt.inventory.view.Count"/>&nbsp;:&nbsp;<%=compList.size()%>)</b></td>
													</tr>
<%
		int count = compList.size();
		int j=0;
		if (count <=3)
		{
			count = 3;
		}
		else if(count %3 != 0)
		{
			count = count+3 - count % 3;
		}

		if (compList!= null)
		{
			for (j=0; (j<compList.size() || j < count); j++)
			{
				if (j%3 == 0)
				{
%>
													<tr>
<%
				}
				if ( j <compList.size())
				{
					String compName=(String)compList.get(j);
					compName = compName.substring(compName.indexOf(":")+1);
					if (compName.endsWith(":NULL"))
					{
						compName = compName.substring(0,compName.indexOf(":"));
					}
					if((j+1)%3==0)
					{
%>
														<td width="33%" id="linebottom" height="20px" valign="center" class="<%=fontStyle%>">&nbsp;<%=compName%></td>
<%
					}
					else
					{
%>
														<td width="33%" id="linebottomright" height="20px" valign="center" class="<%=fontStyle%>">&nbsp;<%=compName%></td>
<%
					}
				}
				else
				{
					if((j+1)%3==0)
					{
%>
														<td width="33%" id="linebottom" height="20px">&nbsp;</td>
<%
					}
					else
					{
%>
														<td width="33%" id="linebottomright" height="20px">&nbsp;</td>
<%
					}
				}
				if (j%3 == 2)
				{
%>
													</tr>
<%
				}
			}
		}
%>
												</table>
											</td>
										</tr>
										<tr>
											<td height="25" id="blank">&nbsp;</td>
										</tr>
<%
	}
%>
										<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
									</table>
								</td>
							</tr>
							<tr><td><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table></td></tr>
						</table>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</form>
</body>
</html>



