<%
/*
 *   File				:	EcChangeConfiguration.jsp
 *   Purpose			:	Displays the changes in a component, component type and all components
 *   Creation Date		:	19/05/2006
 *   Author				:	Krishnamurthi, Balasigamani
 *   UI Design			:	Krishnamurthi
 *   UI Design Changes	:	Jaiwin
*/
%>

<%@ include file = "EcTracker.jsp" %>
<%@ page errorPage="EcProbs.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgMappingInfo"%>
<%@ page import = "com.eg.EgConfigConstants"%>
<%@ page import = "com.eg.EgConfigTestsInfo"%>
<%@ page import = "com.egurkha.User"%>
<%@ page import = "com.egurkha.UserRegistry"%>
<%@ page import = "com.egurkha.EgUserRole"%>
<%@ page import = "com.egurkha.config.TimeLineBean"%>
<%@ page import = "egurkha.config.EcUtils"%>
<%@ page import = "egurkha.config.EcProcessChangeData"%>
<%@ page import = "egurkha.config.EcPrintData"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.egurkha.pdfmaker.*"%>
<%@ page import = "java.net.URLEncoder"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.EgTimeZoneConverter" %>
<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ taglib prefix="pg" uri="/WEB-INF/indexer-taglib.tld"%>
<%@ page import = "egurkha.config.EcFusionChartBean" %>
<%@ page import = "egurkha.config.ConfigDbSetting" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "java.text.*"%>
<%@ page import = "com.eg.EgURLDecoder" %>
<%@ page import = "com.eg.EgThresholdInfo"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	String[] userOptions = {"Component Name","Component Type","All Components"};
	String[] changesPerPage = {"5","10","20","25","30","40","50","75","100"};
	int topNView = 10;

	String[] criterias = {"Zone","Service","Segment","Component"};

	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile iniFile = new IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = iniFile.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	
	UserRegistry registry = UserRegistry.getInstance();
	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	EcUtils ecUtils = new EcUtils();
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EcProcessChangeData processChangeData = new EcProcessChangeData();
	EgConfigTestsInfo configTestsInfo = new EgConfigTestsInfo("manager");
	IniUI iniUI = IniUI.getInstance();
	//user language 
	String userLanguage = iniUI.getDefaultLanguage();
	if (user != null)
	{
		userLanguage = user.getLanguage();
	}
	String userDateFormat = user.getUserDateFormat();
	if (userDateFormat != null && userDateFormat.equalsIgnoreCase("default"))
	{
		userDateFormat = currentDateFormat;
	}

	SimpleDateFormat formatter = new SimpleDateFormat(currentDateFormat+" "+"HH:mm:ss");
	Date currentDateTime = new Date();
	String dateString = formatter.format(currentDateTime);

	/* Added by Prakash.K Starts */
	EgTimeZoneConverter timeZoneConvertertemp = new EgTimeZoneConverter(dateString,user);
	dateString = timeZoneConvertertemp.getDateTime();
	/* Added by Prakash.K Ends */

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	ArrayList serverList = new ArrayList();
	ArrayList sortedTestList = new ArrayList();
	//end user language

	EgTimeZoneConverter timeZoneConverter = null;
	String startDateAndTime = null;
	String endDateAndTime = null;

	String s_changetype = request.getParameter("ec_changetype");
	String userName = (String)session.getAttribute("sess_auserid");
	String configSkin = user.getConfigSkin();

	boolean goBack = false;
	boolean requestHomePage = false;
	boolean hourChanges = false;

	boolean requestFromDashboard = false;
	boolean requestFromAllComponentsOption = false;
	boolean requestFromACO = false;
	boolean requestFromIBCT = false;
	boolean requestFromCurrent = false;
	boolean requestFromBoxView = false;
	boolean requestForSearch = false;
	boolean requestFromMonitor = false;

	String request_from = request.getParameter("request_from");
	String fromPage = (String)session.getAttribute("fromPage");
	String request_start = (String)request.getParameter("request_start");
	String themeforConfigPop = (String)request.getParameter("theme");
	String fromMonitor = (String)request.getParameter("fromMonitor");
	if(fromMonitor != null && fromMonitor != "")
		requestFromMonitor = true;
	//getting map details
	Map scheduleDetails = (Map)request.getAttribute("ScheduleDetails");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		s_changetype = (String)scheduleDetails.get("ec_changetype");
	}
	String id = request.getParameter("id");

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isChrome = ( ua != null && ua.indexOf( "Chrome/" ) != -1 );

	String selectedDate = null;
	String timeZone = null;

	if (request_from != null && !request_from.equalsIgnoreCase("Current"))
	{
		if ("DCDSForDashboard".equalsIgnoreCase(request_from) || 
			"CAAGForDashboard".equalsIgnoreCase(request_from) || 
			"CSForDashboard".equalsIgnoreCase(request_from) || 
			"HomePage".equalsIgnoreCase(request_from) || 
			"HomePage".equalsIgnoreCase(request_start) || 
			"InventoryByCompType".equalsIgnoreCase(request_from) || 
			"compsView".equalsIgnoreCase(request_from))
		{
			goBack = true;
			requestHomePage = true;
			requestFromIBCT = true;
		}

		if ("DCDSForDashboard".equalsIgnoreCase(request_from) || "DCDS".equalsIgnoreCase(request_from) || "DCDS".equalsIgnoreCase(request_start))
		{
			requestHomePage = true;
			requestFromDashboard = true;

			selectedDate = request.getParameter("selectDate");
			timeZone = request.getParameter("timeZone");

			if (!timeZone.equals("") && timeZone.length()>0)
			{
				int hourValue = Integer.parseInt(timeZone);
				if (hourValue <= 9)
					timeZone = "0" + hourValue;
				hourChanges = true;
			}
		}

		if ("CAAGForDashboard".equalsIgnoreCase(request_from) || 
			"CAAG".equalsIgnoreCase(request_from) || 
			"CSForDashboard".equalsIgnoreCase(request_from) || 
			"CS".equalsIgnoreCase(request_from) || 
			"ACO".equalsIgnoreCase(request_from))
		{
			requestFromDashboard = true;
			requestFromACO = true;
		}
	}

	if (request_from != null && request_from.equalsIgnoreCase("AllComponentsOption"))
	{
		requestFromAllComponentsOption = true;
		goBack = false;
	}

	if (request_from != null && request_from.equalsIgnoreCase("Current"))
	{
		requestFromCurrent = true;
		goBack = false;
	}

	boolean requestFromSearch = false;
	boolean requestCompSearch = false;
	if (request_start != null && request_from != null)
	{
		if ((request_start.equalsIgnoreCase("CSForDashboard") && request_from.equalsIgnoreCase("CSForDashboard")) || 
			(request_start.equalsIgnoreCase("CAAGForDashboard") && request_from.equalsIgnoreCase("CAAGForDashboard")))
		{
			requestFromSearch = true;
			goBack = false;
		}

		if (request_start.equalsIgnoreCase("CAAGForDashboard") && request_from.equalsIgnoreCase("CAAGForDashboard") || request_start.equalsIgnoreCase("CAAG") && request_from.equalsIgnoreCase("CAAG"))
		{
			requestCompSearch = true;
		}
	}

	boolean requestFromDCDS = false;
	if (request_start != null && request_from != null && request_start.equalsIgnoreCase("DCDSForDashboard") && request_from.equalsIgnoreCase("DCDSForDashboard"))
	{
		requestFromDCDS = true;
		goBack = false;
	}

	boolean requestForHome = false;
	if (request_start == null && request_from != null && request_from.equalsIgnoreCase("DCDSForDashboard"))
	{
		requestForHome = true;
		goBack = false;
	}

	boolean requestForAllComp = false;
	if (request_start != null && request_from != null && request_start.equalsIgnoreCase("Dashboard") && request_from.equalsIgnoreCase("DCDSForDashboard"))
	{
		requestForAllComp = true;
		goBack = false;
	}

	if (request_from != null && request_from.equalsIgnoreCase("BoxView"))
	{
		requestFromBoxView = true;
		goBack = true;
	}

	Map dashboardSetting = (Hashtable)ConfigDbSetting.getDbSettingData(user.getLoginID(),EgConfigConstants.USER_COMMON_SETTING);
	String barColor = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartColor");
	String chartDataRepresentation = configTestsInfo.getServerDisplayValue("MISC_ARGS","ChartDataRepresentation");

	String searchCompValue = request.getParameter("searchCompValue");
	String searchTestValue = request.getParameter("searchTestValue");
	String searchDescValue = request.getParameter("searchDescValue");

	if (searchCompValue == null || searchCompValue.equals(""))
	{
		searchCompValue = "";
	}

	if (searchTestValue == null || searchTestValue.equals(""))
	{
		searchTestValue = "";
	}

	if (searchDescValue == null || searchDescValue.equals(""))
	{
		searchDescValue = "";
	}

	boolean hasAllComponentAccess = userRole.hasAllComponentAccess();
	TreeMap tmap_changeConfigDetails = (TreeMap)request.getAttribute("Change Configuration Details");

	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
	{
		session.setAttribute("Original Change Configuration Details",tmap_changeConfigDetails);
	}

	if (tmap_changeConfigDetails == null && request_start != null)
	{
		if ((searchCompValue != null && !searchCompValue.equals("")) && 
			(searchTestValue != null && !searchTestValue.equals("")) && 
			(searchDescValue != null && !searchDescValue.equals("")))
		{
			tmap_changeConfigDetails = (TreeMap)session.getAttribute("Change Configuration Details");
		}
		else
		{
			tmap_changeConfigDetails = (TreeMap)session.getAttribute("Original Change Configuration Details");
		}
	}

	if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
	{
		tmap_changeConfigDetails = processChangeData.getChangeSummary(tmap_changeConfigDetails,searchCompValue,searchTestValue,searchDescValue,userLanguage);
	}

	String lflag = "checked";
	String aflag = "";
	String displayNameForChangeType = "";

	if (s_changetype != null)
	{
		if (s_changetype.equalsIgnoreCase("Latest"))
		{
			lflag = "checked";
			aflag = "";
			displayNameForChangeType = "Recent";
		}
		else
		{
			lflag = "";
			aflag = "checked";
			displayNameForChangeType = "All";
		}
	}

	String option1 = request.getParameter("ec_option1");
	String option2 = request.getParameter("ec_option2");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		option1 = (String)scheduleDetails.get("ec_option1");
		option2 = (String)scheduleDetails.get("ec_option2");
	}

	if (option2 != null)
	{
		try
		{
			option2 = EgURLDecoder.decode(option2,"UTF-8");
		}
		catch (Exception e)
		{
		}
	}

	String ec_criteria = (String)session.getAttribute("ec_criteria");
	String ec_criteriaPrevious = request.getParameter("ec_criteriaPrevious");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		ec_criteria = (String)scheduleDetails.get("ec_criteria");
		ec_criteriaPrevious = (String)scheduleDetails.get("ec_criteriaPrevious");
	}

	if (ec_criteria == null)
	{
		ec_criteria = "Component";
		ec_criteriaPrevious = "Component";
	}

	Vector vecCriterias = new Vector();
	for (int g=0;g<criterias.length;g++)
	{
		String criteria = criterias[g];
		vecCriterias.add(criteria);
	}

	Vector vecUserOptions = (Vector)session.getAttribute("vecUserOptions");
	String ec_userOption = (String)session.getAttribute("ec_userOption");
	String ec_userOptionPrevious = request.getParameter("ec_userOptionPrevious");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		vecUserOptions = (Vector)scheduleDetails.get("vecUserOptions");
		ec_userOption = (String)scheduleDetails.get("ec_userOption");
		ec_userOptionPrevious = (String)scheduleDetails.get("ec_userOptionPrevious");
	}

	if (ec_userOption != null)
	{
		try
		{
			ec_userOption = EgURLDecoder.decode(ec_userOption,"UTF-8");
			ec_userOptionPrevious = EgURLDecoder.decode(ec_userOptionPrevious,"UTF-8");
		}
		catch (Exception e)
		{
		}
	}

	Vector vec_temp = new Vector();
	ArrayList aListAssociatedComponents = (ArrayList)session.getAttribute("associatedComponents");
	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		aListAssociatedComponents = (ArrayList)scheduleDetails.get("associatedComponents");
	}
	vec_temp.addAll(aListAssociatedComponents);

	Vector vec_options = new Vector();
	vec_options.addAll(Arrays.asList(userOptions));
	Vector v = null;
	
	if (option1 != null && !option1.equals("-1"))
	{
		if (option1.equalsIgnoreCase("Component Name"))
		{
			v = new Vector();
			for (int i=0;i<vec_temp.size();i++)
			{
				String str = (String) vec_temp.get(i);
				String component_type = str.substring(0,str.indexOf(":"));
				String component_name = str.substring(str.indexOf(":")+1);
				
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if (!isConfigTestEnabled) 
					continue;

				v.add(component_name+":"+component_type);
			}
			Collections.sort(v);
		}

		Vector vec_ctypes = new Vector();
		Vector vec_components = new Vector();
		vec_ctypes.addAll(aListAssociatedComponents);
		for (int i=0; i<vec_ctypes.size(); i++)
		{
			String str = (String) vec_ctypes.get(i);
			String component_type = str.substring(0,str.indexOf(":"));
			boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
			if (!isConfigTestEnabled) continue;
			String component_name = str.substring(str.indexOf(":")+1);
			vec_components.add(component_name+":"+component_type);
		}

		if (option1.equalsIgnoreCase("Component Type"))
		{
			v = new Vector();
			for (int k=0;k<vec_components.size();k++)
			{
				String strComp = (String)vec_components.get(k);
				String component_Type = strComp.substring(strComp.lastIndexOf(":")+1);
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_Type);
				if (!isConfigTestEnabled)
					continue;
				if (!v.contains(component_Type))
					v.add(component_Type);
			}
			if (v.contains("Host_system"))
				v.remove("Host_system");

			Collections.sort(v);
		}
	}

	//if (option1 != null && option1.equalsIgnoreCase("Component Name") || option1.equalsIgnoreCase("Component Type"))
	//{
		//if (ec_criteria != null && ec_criteriaPrevious != null && !ec_criteriaPrevious.equals(ec_criteria))
		//{
			//option2 = "";
		//}

		//if (ec_userOption != null && ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && ec_criteria != null && ec_criteriaPrevious != null)
		//{
			//option2 = "";
		//}
	//}

	String s_timeline = request.getParameter("ec_timeline");
	String s_prevtimeline = request.getParameter("ec_prevtimeline");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		s_timeline = (String)scheduleDetails.get("ec_timeline");
		s_prevtimeline = (String)scheduleDetails.get("ec_prevtimeline");
	}

	String s_stdate = request.getParameter("ec_stdate_h");
	String s_sthr = request.getParameter("ec_sthr_h");
	String s_startmin = request.getParameter("ec_startmin_h");
	String sMinute = null;
	String sHour = null;

	if (s_sthr != null)
	{
		if (s_sthr.length() == 1)
			sHour = "0" + s_sthr;
		else
			sHour = s_sthr;
	}

	if (s_startmin != null)
	{
		if (s_startmin.length() == 1)
			sMinute = "0" + s_startmin;
		else
			sMinute = s_startmin;
	}

	String s_enddate = request.getParameter("ec_enddate_h");
	String s_endhr = request.getParameter("ec_endhr_h");
	String s_endmin = request.getParameter("ec_endmin_h");
	String eMinute = null;
	String eHour = null;

	if (s_endhr != null)
	{
		if (s_endhr.length() == 1)
			eHour = "0" + s_endhr;
		else
			eHour = s_endhr;
	}

	if (s_endmin != null)
	{
		if (s_endmin.length() == 1)
			eMinute = "0" + s_endmin;
		else
			eMinute = s_endmin;
	}

	String s_start_time = null;
	String s_end_time = null;
	if (s_timeline != null && !s_timeline.equalsIgnoreCase("Any"))
	{
		Map map = request.getParameterMap();
		TimeLineBean timeLineBean = new TimeLineBean(map);
		s_start_time = timeLineBean.getStartDateTime();
		s_end_time = timeLineBean.getEndDateTime();
	}

	ArrayList aListEnabledConfigTests = null;

	if (option1 != null && !option1.equals("-1"))
	{
		if ((option1.equalsIgnoreCase("Component Name") || option1.equalsIgnoreCase("Component Type")) && option2 != null && !option2.equals("-1"))
		{
			String comptype = "";
			if (option1.equalsIgnoreCase("Component Name"))
				comptype = option2.substring(option2.lastIndexOf(':')+1);

			if (option1.equalsIgnoreCase("Component Type"))
				comptype = option2;

			if ((option1.equalsIgnoreCase("Component Name") && option2.indexOf(":") != -1) || 
				(option1.equalsIgnoreCase("Component Type") && option2.indexOf(":") == -1))
			{
				aListEnabledConfigTests = specsInfo.getEnabledTests(comptype,true);
			}
		}
		else if (option1.equalsIgnoreCase("All Components"))
		{
			Vector vecCompTypes = new Vector();
			vecCompTypes.addAll(user.getServerTypes());

			Vector temp = new Vector();
			for (int i=0; i<vecCompTypes.size(); i++)
			{
				String component_type = (String)vecCompTypes.get(i);
				boolean isConfigTestEnabled = specsInfo.isConfigTestEnabled(component_type);
				if (!isConfigTestEnabled) 
					continue;
				if (!temp.contains(component_type))
					temp.add(component_type);
			}

			if (temp.contains("Host_system"))
				temp.remove("Host_system");

			aListEnabledConfigTests = new ArrayList();
			for (int i=0; i<temp.size(); i++)
			{
				String comptype = (String)temp.get(i);
				ArrayList aList = specsInfo.getEnabledTests(comptype,true);
				for (int j=0;j<aList.size();j++)
				{
					String test = (String)aList.get(j);
					if (!aListEnabledConfigTests.contains(test))
						aListEnabledConfigTests.add(test);
				}
			}
		}

		if (aListEnabledConfigTests != null)
		{
			sortedTestList = sorter.getSortedTestList(aListEnabledConfigTests);
		}
	}

	String[] s_selectedInformations = null;

	if (request_from != null && !request_from.equalsIgnoreCase("Current"))
	{
		List listSelectedInformationsForDashboard = (ArrayList)request.getAttribute("ec_test");
		
		if (listSelectedInformationsForDashboard != null && listSelectedInformationsForDashboard.size() > 0)
		{
			s_selectedInformations = new String[listSelectedInformationsForDashboard.size()];
			for (int k=0; k<listSelectedInformationsForDashboard.size(); k++)
			{
				s_selectedInformations[k] = (String)listSelectedInformationsForDashboard.get(k);
			}
		}
		else
		{
			s_selectedInformations = request.getParameterValues("ec_test");
		}
	}
	else
	{
		s_selectedInformations = request.getParameterValues("ec_test");
	}

	if (option1 != null && option1.equalsIgnoreCase("All Components") || option1.equalsIgnoreCase("Component Name") || option1.equalsIgnoreCase("Component Type"))
	{
		if (ec_criteria != null && ec_criteriaPrevious != null && !ec_criteriaPrevious.equals(ec_criteria))
		{
			s_selectedInformations = null;
		}

		if (ec_userOption != null && ec_userOptionPrevious != null && !ec_userOptionPrevious.equals(ec_userOption) && ec_criteria != null && ec_criteriaPrevious != null)
		{
			s_selectedInformations = null;
		}
	}

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		String tests[] = null;
		Object temp = (Object)scheduleDetails.get("ec_test");
		if (temp instanceof String)
		{
			tests = new String[]{(String)temp};
		}
		else if (temp instanceof String[])
		{
			tests = (String[])temp;
		}
		s_selectedInformations = tests;
	}

	List l_selectedInformations = null;
	String selectedTests = null;
	String tempSelectedTests = null;

	if (s_selectedInformations != null && !s_selectedInformations[0].equals("-1"))
	{
		if (s_selectedInformations[0].indexOf(',') != -1) //Comma separated tests
		{
			StringTokenizer strTokensTemp = new StringTokenizer(s_selectedInformations[0],",");
			l_selectedInformations = new ArrayList();
			while (strTokensTemp.hasMoreTokens())
			{
				String str_temp = strTokensTemp.nextToken();
				l_selectedInformations.add(str_temp.trim());
			}
		}
		else
		{
			l_selectedInformations = Arrays.asList(s_selectedInformations);
		}

		if (l_selectedInformations != null)
		{
			String temp = l_selectedInformations.toString();
			selectedTests = temp.substring(1,temp.length()-1);
		}
	}

	if (selectedTests == null)
	{
		tempSelectedTests = "";
	}
	else
	{
		tempSelectedTests = new String(selectedTests);
	}

	String s_viewchange = request.getParameter("ec_viewchange");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		s_viewchange = (String)scheduleDetails.get("ec_viewchange");
	}

	String informationflag = "checked";
	String dateflag = "";
	if (s_viewchange != null)
	{
		if (s_viewchange.equalsIgnoreCase("byInformation"))
		{
			informationflag = "checked";
			dateflag = "";
		}
		else
		{
			informationflag = "";
			dateflag = "checked";
		}
	}

	//For indexer-taglib.jar
	String index = "center";
	int maxPageItems = 10;
	int maxIndexPages = 10;

	Vector vec_changesperpage = new Vector();
	vec_changesperpage.addAll(Arrays.asList(changesPerPage));

	String s_maxpageitems = request.getParameter("ec_maxpageitems");

	if (scheduleDetails != null && request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
		s_maxpageitems = (String)scheduleDetails.get("ec_maxpageitems");
	}

	if (s_maxpageitems != null)
	{
		try
		{
			maxPageItems = Integer.parseInt(s_maxpageitems.trim());
		}
		catch(NumberFormatException nfe)
		{
		}
	}
	else
	{
		s_maxpageitems = maxPageItems+"";
	}

	String topNChanges = configTestsInfo.getServerDisplayValue("CONFIGURATION_CHANGE","TopN");
	int topN = 0;
	try
	{
		topN = Integer.parseInt(topNChanges);
	}
	catch(Exception e1)
	{
		topN = topNView;
	}

	//Timeline - Not Any - Display Purpose
	String tempStartDateTime = null;
	String tempEndDateTime = null;

	//Timeline - Any - Display Purpose
	String tempStartDate = "";
	String tempEndDate = "";

	if (tmap_changeConfigDetails != null)
	{
		if (s_timeline != null)
		{
			if (!s_timeline.equalsIgnoreCase("Any"))
			{
				String tempDateTime = s_start_time.substring(0,s_start_time.lastIndexOf(':'));
				String tempSDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempSTime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempSDate = DateUtil.changeDateFormat(tempSDate,"MM/dd/yyyy",currentDateFormat);
				tempStartDateTime = tempSDate + " " + tempSTime;

				tempDateTime = s_end_time.substring(0,s_end_time.lastIndexOf(':'));
				String tempEDate = tempDateTime.substring(0,tempDateTime.lastIndexOf(" "));
				String tempETime = tempDateTime.substring(tempDateTime.lastIndexOf(" ")+1);
				tempEDate = DateUtil.changeDateFormat(tempEDate,"MM/dd/yyyy",currentDateFormat);
				tempEndDateTime = tempEDate + " " + tempETime;
			}
			else
			{
				tempStartDate = s_stdate;
				tempEndDate = s_enddate;
			}
		}

		EcPrintData ecData = new EcPrintData();
		ecData.setChangeData(tmap_changeConfigDetails);
		ecData.setRequestFrom(request_from);
		ecData.setOptionOne(option1);
		ecData.setOptionTwo(option2);
		ecData.setTestName(selectedTests);
		ecData.setTimeLine(s_timeline);
		ecData.setPreviousTimeLine(s_prevtimeline);
		ecData.setStartTime(tempStartDateTime);
		ecData.setEndTime(tempEndDateTime);
		ecData.setStartDate(tempStartDate);
		ecData.setStartHour(s_sthr);
		ecData.setStartMinute(s_startmin);
		ecData.setEndDate(tempEndDate);
		ecData.setEndHour(s_endhr);
		ecData.setEndMinute(s_endmin);
		ecData.setChangeType(s_changetype);
		ecData.setViewChange(s_viewchange);
		ecData.setMaxPageItem(s_maxpageitems);
		ecData.setSelectedDate(selectedDate);
		ecData.setSelectedHour(timeZone);
		ecData.setRequestFromDashboard(requestFromDashboard);
		ecData.setTopNChanges(topN);

		session.setAttribute("CHANGE_COMPONENT_DATA",ecData);
	}

	int totalChangeCount = 0;
	String mngrIProc = new IniFile(new EgConfigInfo("manager").getDbFile()).getValue("DB_PROPERTIES","ManagerUrl");

	String strRequestStart = "";
	if (request_start == null)
	{
		strRequestStart = (String)request.getParameter("request_from");
	}
	else
	{
		strRequestStart = (String)request.getParameter("request_start");
	}

	HashMap treeValues = new HashMap();
	String testNamesforDiff[] = configTestsInfo.getVariables("SHOW_DIFFERENCES");
	for (int i=0;i<testNamesforDiff.length;i++)
	{
		HashMap lengthinMeasure = new HashMap();
		String strTestname = testNamesforDiff[i];
		String measureValues = configTestsInfo.getValue("SHOW_DIFFERENCES",strTestname);
		StringTokenizer st = new StringTokenizer(measureValues,",");
		while (st.hasMoreTokens())
		{
			String stTokenValues = st.nextToken();
			if (stTokenValues.indexOf(":") != -1)
			{
				StringTokenizer stinColon = new StringTokenizer(stTokenValues,":");
				String strMeasure = stinColon.nextToken();
				String strLength = stinColon.nextToken();
				String uiDesc = (String)mappingInfo.getMeasureDescription(strTestname,strMeasure);
				lengthinMeasure.put(uiDesc,strLength);
				treeValues.put(strTestname,lengthinMeasure);
			}
			else
			{
				String uiDesc = (String)mappingInfo.getMeasureDescription(strTestname,stTokenValues);
				lengthinMeasure.put(uiDesc,"0");
				treeValues.put(strTestname,lengthinMeasure);
			}
		}
	}

	String monBottomTableVal = "";
	String monCellHeaderVal = "";
	String monCellHeaderfirstVal = "";
	String monCellHeaderlastVal = "";
	String montableBorderVal = "";
	String montable_headerVal = "";
	String monBgVal = "";
	String monCellbgVal = "";
	String cell_bg1Val = "";
	String cell_bg2Val = "";
	String paddingValue = "";
	String styleValue = "";
	String widthValue = "";

	if (!requestFromMonitor)
	{
		monBottomTableVal = "bottomtable";
		monCellHeaderVal = "cell_header";
		monCellHeaderfirstVal = "cell_header";
		monCellHeaderlastVal = "cell_header";
		montableBorderVal = "bottomtable body_text";
		montable_headerVal = "table_header";
		monBgVal = "bglightlight";
		monCellbgVal = "cell_bg2";
		cell_bg1Val = "cell_bg1";
		cell_bg2Val = "cell_bg2";
		paddingValue = "padding6";
		styleValue = "";
		widthValue = "99%";
%>
	<html >
<%
	}
	else if(requestFromMonitor && themeforConfigPop != null && themeforConfigPop.contains("Dark"))
	{
		monBottomTableVal = "monBottomTableD";
		monCellHeaderVal = "monCellHeaderD";
		monCellHeaderfirstVal = "monCellHeaderDF";
		monCellHeaderlastVal = "monCellHeaderDL";
		montableBorderVal = "montableBorderD";
		montable_headerVal = "montable_headerD";
		monBgVal = "monBgLightD";
		monCellbgVal = "monCellbgD2";
		cell_bg1Val = "cell_bgD1";
		cell_bg2Val = "cell_bgD2";
		paddingValue = "";
		styleValue = "margin:10px;table-layout:fit";
		widthValue = "98.4%";
%>
	<html style="background-color:#646464 !important;border:">
<%
	}
	else if(requestFromMonitor && themeforConfigPop != null && themeforConfigPop.contains("Light"))
	{
		monBottomTableVal = "monBottomTableL";
		monCellHeaderVal = "monCellHeaderL";
		monCellHeaderfirstVal = "monCellHeaderL";
		monCellHeaderlastVal = "monCellHeaderLL";
		montableBorderVal = "montableBorderL";
		montable_headerVal = "montable_headerL";
		monBgVal = "monBgLight";
		monCellbgVal = "monCellbg2";
		cell_bg1Val = "cell_bg1";
		cell_bg2Val = "cell_bg2";
		paddingValue = "";
		styleValue = "margin:10px;table-layout:fit";
		widthValue = "98.4%";
%>
	<html style="background-color:#e3e3e3 !important">
<%
	}
%>
	<head>
	<title><egui:intnl text="configmgmt.changes.detailed.eG Change Management" /></title>
	<meta name="Author" content="Krishnamurthi">
	<style>
	@page {size : landscape; margin : 0in }  
	@page :footer {content: none, "Macro Home" decimal(pageno), none;}  
	</style>
	<egui:skin ui="config"/>
	<script language="JavaScript1.2" src="../config/scripts/ec_validate.js"></script>
	<script language="JavaScript1.2" src="../config/scripts/ec_date.js"></script>
	<script  src="/final/jquery/jquery.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.core.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.widget.js"></script> 
	<script  src="/final/jquery/ui/jquery.ui.mouse.js"></script>
	<script  src="/final/jquery/ui/jquery.ui.draggable.js"></script>
	<script type="text/javascript" src="/final/FusionCharts/scripts/FusionCharts.js"></script>
	<script language="JavaScript1.2">
	
	var screenname='';
	var ev='';
	var def='';
	var def_h='';
	var datefv='';

	var has_element = document.documentElement && document.documentElement.clientWidth;
	var has_inner = typeof(window.innerWidth) == 'number';  

	var startX=0;
	var startY=0;
	var dragStarted=false;
	var dragDiv;

	var $j = jQuery.noConflict();

	function checkwindow1(datef,datef_h,event,sname,frmField)
	{
		event=event?event:window.event;
		document.forms[0].fromField.value = frmField;
		try
		{
			datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		}
		catch(e)
		{
			datefv = formatDate(new Date(getDateFromFormat(datef_h.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
		}
		screenname=sname;
		ev=event;
		def=datef;
		def_h=datef_h;
		try
		{
			// Saravanan.A put the change on 25-jan-2008 for IE && FF
			//callcalendar3(def,datefv,ev,screenname);
			setTimeout("callcalendar4(def,def_h,datefv,ev,screenname)",0);
		}
		catch(e)
		{
			alert(e);
		}
	}

	function goTo(type)
	{
		switch (type)
		{
			case "jsp":
				document.forms[0].action = "../config/EcChangeConfiguration.jsp?request_from=<%=request_from%>&id=<%=id%>";
				document.forms[0].submit();
		}
	}

	function get()
	{
		var thisForm = document.forms[0];

		for (var x=0;x<thisForm.ec_test.options.length;x++)
		{
			thisForm.ec_test.options[x].selected = false;
		}

		thisForm.action = "../config/EcChangeConfiguration.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

	function fetchData(path)
	{
		var thisForm = document.forms[0];

		var tempCriteria = "";
		var tempUserOption = "";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}

		if (tempCriteria != null && tempCriteria != undefined && tempCriteria != -1)
		{
			if (tempUserOption != null && tempUserOption !=undefined && tempUserOption == -1)
			{
				if (tempCriteria == "Zone")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Zone" />');
					return false;
				}
				else if (tempCriteria == "Service")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Service" />');
					return false;
				}
				else if (tempCriteria == "Segment")
				{
					alert('<egui:intnl text="configmgmt.common.Please select a Segment" />');
					return false;
				}
			}
		}

		var option1 = thisForm.ec_option1.value;

		if (option1 != "All Components")
		{
			var option2 = thisForm.ec_option2.value;
			
			if (option2 == "Please choose a component type")
			{
				alert('<egui:intnl text="configmgmt.changes.detailed.Please choose a component type" />');
				return false;
			}

			if (option2 == "Please choose a component")
			{
				alert('<egui:intnl text="configmgmt.changes.detailed.Please choose a component" />');
				return false;
			}
		}

		var information = thisForm.ec_test.value;
		if(information == "-1" || information == '')
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Please select atleast one Information for the choosen combination" />');
			return false;
		}

		var timeline = thisForm.ec_timeline.value;
		if (timeline == "Any" && path == "schedule")
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Selected timeline is not allowed" />');
			return false;
		}

		var timeStart = thisForm.ec_stdate_h;
		var timeEnd = thisForm.ec_enddate_h;

		if(timeStart!="" && timeEnd!="")
		{
			var startHr = thisForm.ec_sthr.options[thisForm.ec_sthr.selectedIndex];
			var startMin = thisForm.ec_startmin.options[thisForm.ec_startmin.selectedIndex];

			var startHr_h = thisForm.ec_sthr_h.value;
			var startMin_h = thisForm.ec_startmin_h.value;

			var endHr = thisForm.ec_endhr.options[thisForm.ec_endhr.selectedIndex];
			var endMin = thisForm.ec_endmin.options[thisForm.ec_endmin.selectedIndex];

			var endHr_h = thisForm.ec_endhr_h.value;
			var endMin_h = thisForm.ec_endmin_h.value;

			//Convert to original format(i.e., to MM/dd/yyyy)
			var startDate = formatDate(new Date(getDateFromFormat(timeStart.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");
			var endDate = formatDate(new Date(getDateFromFormat(timeEnd.value,'<%=currentDateFormat%>')),"MM/dd/yyyy");

			if(!validateDateTime(startDate,endDate,startHr_h,endHr_h,startMin_h,endMin_h))
			{
				alert('<egui:intnl text="configmgmt.changes.detailed.Start date should be less than the End date" />');
				return false;
			}
		}

		if (path == "submit")
		{
			document.forms[0].action = "../servlet/com.eg.EcConfigurationServlet";
			document.forms[0].submit();
			document.forms[0].x.value = '<egui:intnl text="configmgmt.common.Loading" />'+'...';
			document.forms[0].x.disabled = true;
		}
	}
	
	function printData()
	{
<%
		if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}

		StringBuffer printQS = new StringBuffer();
		printQS.append("ec_type=Change");
		printQS.append("&ec_trgttype=Configuration_Report");
		printQS.append("&printData=yes");
		printQS.append("&userName="+EgURLEncoder.encode(userName,"UTF-8"));
		printQS.append("&user_language="+userLanguage);
		printQS.append("&ec_criteria="+ec_criteria);
		printQS.append("&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):""));
		printQS.append("&searchCompValue="+searchCompValue);
		printQS.append("&searchTestValue="+searchTestValue);
		printQS.append("&searchDescValue="+searchDescValue);
%>
		var s_qryString = "../servlet/com.eg.EcRepoLiteC?<%=printQS.toString()%>&ec_forPDF=No";
		print(s_qryString);
	}

	function savePdf()
	{
<%
		if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
		session.setAttribute("PDF_URL",mngrIProc+"/final/servlet/com.eg.EcRepoLiteC;jsessionid="+session.getId()+"?"+printQS.toString()+"&ec_forPDF=Yes");
		session.setAttribute("REPORT_NAME","ChangeConfiguration");
		session.setAttribute("REPORT_LAYOUT","Portrait");
		session.setAttribute("PAGE_WIDTH_PDF","1100");
		session.setAttribute("PAGE_WIDTH_MAIL_IMAGE","1300");
		session.setAttribute("PAGE_HEIGHT_MAIL_IMAGE","768");
%>
		getPdf('<%=configSkin%>');
	}

	function mail()
	{
<%
		if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		sendMail();
	}

	function closeWin()
	{
		if(window.newwin !=null)
		{
			newwin.close();
		}
		if(window.datawin !=null)
		{
			datawin.close();
		}
		if(window.mailwin !=null)
		{
			mailwin.close();
		}
		if(window.statusWin!=null)
		{
			statusWin.close();
		}
	}

	function schedule(op)
	{
		var checkFlg = fetchData('schedule');
		if(checkFlg == false) return;

		var thisForm = document.CfMacro;
		
		if (op == "schedule")
		{
<%
	if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>";
<%
	}
	else
	{
%>
			thisForm.action = "/final/config/EcSaveSchedule.jsp?id=<%=id%>&request_from=Change";
<%
	}
%>
		}
		else
		{
			alert('<egui:intnl text="configmgmt.common.Illegal Access" />');
			return;
		}

		thisForm.submit();
	}

	function findPagerOffset(page)
	{
		var url = window.location.href;
		var index = url.indexOf("indexeroffset");
		var indextimeZone = url.indexOf("timeZone");

		if (index != -1)
		{
			var beforeStr = url.substr(0, index);
			var afterStr = url.substr(index);
			index = afterStr.indexOf("&");
			if (index == -1)
			{
				url = beforeStr + "indexeroffset=" + page;
			}
			else
			{
				afterStr = afterStr.substr(index);
				url = beforeStr + "indexeroffset=" + page + afterStr;
			}
		}
		else
		{
			if (indextimeZone == -1)
			{
<%
				String strOption2 = option2;
				if (strOption2 != null)
				{
					strOption2 = EgURLEncoder.encode(strOption2,"UTF-8");
				}
%>
				url += '?ec_rtype=Change&ec_option1=<%=option1%>&ec_option2=<%=strOption2%>&ec_changetype=<%=s_changetype%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_test=<%=selectedTests%>&indexeroffset='+page+'&ec_maxpageitems=<%=s_maxpageitems%>&ec_viewchange=<%=s_viewchange%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&request_start=<%=request_start%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
			}
			else
			{
				url += "&indexeroffset="+page;
			}
		}
		return url;
	}

	function onGoToPage(maxEntriesPerPage, totalEntries)
	{
		var page = document.forms[0].pageno.value;
		if (!isNaN(page))
		{
			var offset = (page-1) * maxEntriesPerPage;
			if ((offset > totalEntries) || (page < 1))
			{
				alert('<egui:intnl text="configmgmt.changes.detailed.Page" />'+' '+page+' '+'<egui:intnl text="configmgmt.changes.detailed.does not exist" />');
				document.forms[0].pageno.value = "";
			}
			else
			{
				window.location.href = findPagerOffset(offset);
			}
		}
		else
		{
			alert('<egui:intnl text="configmgmt.changes.detailed.Page" />'+' '+page+' '+'<egui:intnl text="configmgmt.changes.detailed.is invalid" />');
			document.forms[0].pageno.value = "";
		}
	}

	function goCurrent()
	{
		var thisForm = document.forms[0];
<%
		String comptype = null;
		String compName = (String)request.getParameter("ec_option2");
		if (compName != null)
		{
			comptype = compName.substring(compName.lastIndexOf(':')+1);
			compName = EgURLEncoder.encode(compName,"UTF-8");
		}
		String selectedInformations = (String)request.getAttribute("selectedInformationsInCurrent");
%>
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?ec_rtype=Current&ec_comptype=<%=comptype%>&ec_component=<%=compName%>&old_comptype=<%=comptype%>&ec_test=<%=selectedInformations%>&navigatingFrom=Change&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function goDCDS()
	{
		var thisForm = document.forms[0];
		thisForm.ec_rtype.value = "";
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=DaywiseChangeDistribution&request_start=<%=request_start%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function goCAAG()
	{
		var thisForm = document.forms[0];
		thisForm.ec_rtype.value = "";
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=ChangesAtAGlance&request_start=<%=request_start%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function goCS()
	{
		var thisForm = document.forms[0];
		thisForm.ec_rtype.value = "";
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?cmd=ChangeSummary&request_start=<%=request_start%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function show()
	{
<%
	if (!requestHomePage && !requestFromDashboard && !requestFromCurrent)
	{
%>
		var thisForm = document.forms[0];
		if (thisForm.ec_viewchange != null && thisForm.ec_viewchange != undefined)
		{
			if (thisForm.elements["ec_viewchange"][0].checked)
			{
				document.getElementById("mpiLabel").style.display = "none";
				document.getElementById("mpi").style.display = "none";
			}
			else
			{
				document.getElementById("mpiLabel").style.display = "block";
				document.getElementById("mpi").style.display = "block";
			}
		}
<%
	}
%>
	}

	function showComponentChanges(comp)
	{
		var thisForm = document.CfMacro;
		var compname = "";
		var descname = "";
		var testname = "";
		if (thisForm.compSearch != null && thisForm.compSearch != undefined)
		{
			compname = thisForm.compSearch.value;
		}
		if (thisForm.testSearch != null && thisForm.testSearch != undefined)
		{
			testname = thisForm.testSearch.value;
		}
		if (thisForm.descSearch != null && thisForm.descSearch != undefined)
		{
			descname = thisForm.descSearch.value;
		}
<%
		if(request_start ==null && request_from!= null && request_from.equalsIgnoreCase("AllComponentsOption"))
		{
			request_start = "AllComponentsOption";
		}
%>

		window.location.href = '../config/ecShowComponentChanges.jsp?componentName='+comp+'&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&request_from=<%=request_from%>&request_start=<%=request_start%>&searchCompValue='+encodeURIComponent(compname)+'&searchTestValue='+encodeURIComponent(testname)+'&searchDescValue='+encodeURIComponent(descname);
	}

	function goBackToSaveSchedule()
	{
		var thisForm = document.forms[0];
		thisForm.action = "/final/config/EcSaveSchedule.jsp?request_from=<%=request_from%>&id=<%=id%>";
		thisForm.submit();
	}

	function goAllComponents()
	{
		var thisForm = document.forms[0];
		thisForm.action = '/final/servlet/com.eg.EcConfigurationServlet?ec_rtype=Change&ec_option1=All Components&ec_changetype=<%=s_changetype%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_viewchange=<%=s_viewchange%>&ec_maxpageitems=<%=s_maxpageitems%>&ec_test=<%=selectedTests%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function getDetails()
	{
		thisForm = document.CfMacro;
		var s_timeline = thisForm.ec_timeline.value;
		var s_maxpageitems = thisForm.ec_maxpageitems.value;
		var s_viewchange = "";
		var s_changetype = "";
		var compname = "";
		var descname = "";
		var testname = "";
		if (thisForm.compSearch != null && thisForm.compSearch != undefined)
		{
			compname = thisForm.compSearch.value;
		}
		if (thisForm.testSearch != null && thisForm.testSearch != undefined)
		{
			testname = thisForm.testSearch.value;
		}
		if (thisForm.descSearch != null && thisForm.descSearch != undefined)
		{
			descname = thisForm.descSearch.value;
		}

		if (thisForm.elements["ec_changetype"][0].checked == true)
		{
			s_changetype = thisForm.elements["ec_changetype"][0].value;
		}
		else
		{
			s_changetype = thisForm.elements["ec_changetype"][1].value;
		}

		if (thisForm.elements["ec_viewchange"][0].checked == true)
		{
			s_viewchange = thisForm.elements["ec_viewchange"][0].value;
		}
		else
		{
			s_viewchange = thisForm.elements["ec_viewchange"][1].value;
		}

		var tempCriteria ="";
		var tempCriteriaPrevious ="";
		var tempUserOption ="";
		var tempUserOptionPrevious ="";
		if (thisForm.ec_criteria != null && thisForm.ec_criteria != undefined)
		{
			tempCriteria = thisForm.ec_criteria.value;
		}
		if (thisForm.ec_userOption != null && thisForm.ec_userOption != undefined)
		{
			tempUserOption = thisForm.ec_userOption.value;
		}
		if (thisForm.ec_criteriaPrevious != null && thisForm.ec_criteriaPrevious != undefined)
		{
			tempCriteriaPrevious = thisForm.ec_criteriaPrevious.value;
		}
		if (thisForm.ec_userOptionPrevious != null && thisForm.ec_userOptionPrevious != undefined)
		{
			tempUserOptionPrevious = thisForm.ec_userOptionPrevious.value;
		}
		if (tempCriteria != "" && tempCriteriaPrevious != "")
		{
			if (tempCriteria == tempCriteriaPrevious)
			{
				if (tempUserOption != tempUserOptionPrevious)
				{
					s_changetype = "Latest";
					s_viewchange = "byInformation";
					s_timeline = "1 day";
				}
			}
			else
			{
				s_changetype = "Latest";
				s_viewchange = "byInformation";
				s_timeline = "1 day";
			}
		}

		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?cmd=ChangeConfig&ec_viewchange="+s_viewchange+"&ec_changetype="+s_changetype+"&ec_timeline="+s_timeline+"&ec_criteria="+tempCriteria+"&ec_criteriaPrevious="+tempCriteriaPrevious+"&ec_userOption="+encodeURIComponent(tempUserOption)+"&ec_userOptionPrevious="+encodeURIComponent(tempUserOptionPrevious)+"&request_from=<%=request_from%>&id=<%=id%>&searchCompValue="+encodeURIComponent(compname)+"&searchTestValue="+encodeURIComponent(testname)+"&searchDescValue="+encodeURIComponent(descname);
		thisForm.submit();
	}

	function getSearchDetails()
	{
		thisForm = document.CfMacro;
		var compname = "";
		var descname = "";
		var testname = "";
		if (thisForm.compSearch != null && thisForm.compSearch != undefined)
		{
			compname = thisForm.compSearch.value;
		}
		if (thisForm.testSearch != null && thisForm.testSearch != undefined)
		{
			testname = thisForm.testSearch.value;
		}
		if (thisForm.descSearch != null && thisForm.descSearch != undefined)
		{
			descname = thisForm.descSearch.value;
		}
<%
		if (tmap_changeConfigDetails != null && !tmap_changeConfigDetails.isEmpty())
		{
			session.setAttribute("Change Configuration Details",tmap_changeConfigDetails);
		}
%>

		thisForm.action = 
		'../config/EcChangeConfiguration.jsp?request_from=<%=request_from%>&request_start=<%=strRequestStart%>&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&ec_changetype=<%=s_changetype%>&ec_viewchange=<%=s_viewchange%>&searchCompValue='+encodeURIComponent(compname)+'&searchTestValue='+encodeURIComponent(testname)+'&searchDescValue='+encodeURIComponent(descname)+'&timeZone=<%=timeZone%>&selectDate=<%=selectedDate%>';
		thisForm.submit();
	}

	function goHome()//with search to home for CS and CAAG
	{
		thisForm = document.CfMacro;
		thisForm.action = '../config/EcDashboard.jsp?&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function goAllComp()// to all comp from ctype(DCDSForDashboard)
	{
		var thisForm = document.forms[0];
		var compname = "";
		var descname = "";
		var testname = "";
		if (thisForm.compSearch != null && thisForm.compSearch != undefined)
		{
			compname = thisForm.compSearch.value;
		}
		if (thisForm.testSearch != null && thisForm.testSearch != undefined)
		{
			testname = thisForm.testSearch.value;
		}
		if (thisForm.descSearch != null && thisForm.descSearch != undefined)
		{
			descname = thisForm.descSearch.value;
		}
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?&ec_rtype=Change&request_from=DCDSForDashboard&request_start=DCDSForDashboard&ec_option1=All Components&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_changetype=<%=s_changetype%>&ec_viewchange=<%=s_viewchange%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&timeZone=<%=timeZone%>&selectDate=<%=selectedDate%>';
		thisForm.submit();
	}

	function goToAllComp()// to all comp from ctype(DCDS)
	{
		var thisForm = document.forms[0];
		var compname = "";
		var descname = "";
		var testname = "";
		if (thisForm.compSearch != null && thisForm.compSearch != undefined)
		{
			compname = thisForm.compSearch.value;
		}
		if (thisForm.testSearch != null && thisForm.testSearch != undefined)
		{
			testname = thisForm.testSearch.value;
		}
		if (thisForm.descSearch != null && thisForm.descSearch != undefined)
		{
			descname = thisForm.descSearch.value;
		}
		thisForm.action = '../servlet/com.eg.EcConfigurationServlet?&ec_rtype=Change&request_from=DCDS&request_start=DCDS&ec_option1=All Components&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_criteria=<%=ec_criteria%>&ec_changetype=<%=s_changetype%>&ec_viewchange=<%=s_viewchange%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&searchCompValue=<%=searchCompValue%>&searchTestValue=<%=searchTestValue%>&searchDescValue=<%=searchDescValue%>&timeZone=<%=timeZone%>&selectDate=<%=selectedDate%>';
		thisForm.submit();
	}

	function goDCDSForDB()//to home from ctype/all comp
	{
		var thisForm = document.forms[0];
		thisForm.action = '../config/EcDashboard.jsp?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function csv()
	{
<%
		if (tmap_changeConfigDetails == null || tmap_changeConfigDetails.isEmpty())
		{
%>
			alert('<egui:intnl text="configmgmt.common.No data available" />');
			return;
<%
		}
%>
		thisForm = document.forms[0];
		thisForm.action = '../servlet/com.eg.EcCSVController?ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>';
		thisForm.submit();
	}

	function center_box(box, width, height)
	{
		cleft = has_inner? pageXOffset + (window.innerWidth - width)/2 : has_element ? document.documentElement.scrollLeft +(document.documentElement.clientWidth - width)/2: document.body.scrollLeft + (document.body.clientWidth - width)/2;  
		ctop = has_inner? pageYOffset + (window.innerHeight - height)/2 : has_element ? document.documentElement.scrollTop +(document.documentElement.clientHeight - height)/2 : document.body.scrollTop +(document.body.clientHeight - height)/2;
		box.style.left = cleft > 0 ? cleft + 'px' : '0px';
		box.style.top = ctop > 0 ? ctop + 'px' : '0px';
	}

	function loadChange(previousValue,presentValue,compValue,testValue,descValue,measureValue,obj)
	{
		xmlhttp = null;
		var box = document.getElementById('valuechangesDiv');
		if (window.XMLHttpRequest)
		{
			xmlhttp=new XMLHttpRequest();
		}
		else if (window.ActiveXObject)
		{
			xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
		}
		if (xmlhttp != null)
		{
			var params = "previousValue="+previousValue+"&presentValue="+presentValue+"&componentName="+compValue+"&testName="+testValue+"&descriptor="+descValue+"&measureName="+measureValue;
			var url = "/final/config/ecShowDifference.jsp";
			xmlhttp.onreadystatechange = state_Change2;
			xmlhttp.open('POST',url,true);
			xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
			xmlhttp.setRequestHeader('Content-length',params.length);
			xmlhttp.setRequestHeader('Connection','close');
			xmlhttp.send(params);
			var bHeight = box.style.height;
			var bWidth = box.style.width;
			center_box(box,400,250);
		}
		else
		{
			alert('<egui:intnl text="admin.login.Your browser does not support XMLHTTP"/>');
		}
	}

	function state_Change2()
	{
		var changesDiv = document.getElementById("changesDiv");
		if (xmlhttp.readyState == 4)
		{
			try
			{
				if (xmlhttp.status == 200)
				{
					val = xmlhttp.responseText;
					changesDiv.innerHTML = val;
					changesDiv.style.visibility = "visible";
					changesDiv.style.display = "block";
					var myvalue = document.getElementById('changesDiv');
					var width = myvalue.offsetWidth;
					var height = myvalue.offsetHeight;
					document.getElementById('valuechangesDiv').style.display="block";
				}
			}
			catch (error)
			{
				//error
			}
		}
	}

	$j(document).ready(function(){
	/*   JQuery Drag & Drop Functionality  (Begin)   */
	$j.globalVars = {
		maxHeight: $j(window).height(),
		maxWidth:  $j(window).width()
	};

	$j( "#valuechangesDiv" ).draggable({
		cursor: "move",
		scroll: false,
		containment: "parent"
	});
	/*   JQuery Drag & Drop Functionality  (End)   */
	});

	function loadXMLDiff()
	{
		var thisForm = document.CfMacro;
		thisForm.action = "../servlet/com.eg.EcConfigurationServlet?requestFrom=EcchangeConfiguration&ec_rtype=FromChange&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_changetype=<%=s_changetype%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_stdate=<%=s_stdate%>&ec_sthr=<%=s_sthr%>&ec_startmin=<%=s_startmin%>&ec_enddate=<%=s_enddate%>&ec_endhr=<%=s_endhr%>&ec_endmin=<%=s_endmin%>&ec_viewchange=<%=s_viewchange%>&ec_maxpageitems=<%=s_maxpageitems%>&ec_test=<%=selectedTests%>&ec_criteria=<%=ec_criteria%>&ec_userOption=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>&ec_criteriaPrevious=<%=ec_criteriaPrevious%>&ec_userOptionPrevious=<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>";
		thisForm.submit();
	}
	</script>

<!-- Screen width script starts here -->
<SCRIPT LANGUAGE="JavaScript">
documentView = {
	getObject: function()
	{
		if(typeof( window.innerWidth) == 'number')
		{//Firefox
			this.height = window.innerHeight;
			this.width = window.innerWidth-10;
			this.fireFox = true;
		}
		else if( document.documentElement && ( document.documentElement.clientWidth
			|| document.documentElement.clientHeight ))
		{//IE 6 + in 'standards compliant mode'
			this.height = document.documentElement.clientHeight;
			this.width = document.documentElement.clientWidth;
			this.ie = true;
		}
		else if(document.body && document.body.clientHeight)
		{ //IE 4 compatible
			this.height = document.body.clientHeight;
			this.width = document.body.clientWidth;
			this.ie = true;
		}

		this.screenHeight=window.screen.availHeight;
		this.screenWidth=window.screen.availWidth;
		return this;
	},
	getScreenHeight: function()
	{
		return this.getObject().screenHeight;
	},
	getScreenWidth: function()
	{
		return this.getObject().screenWidth;
	},
	getHeight: function()
	{
		return this.getObject().height;
	},
	getWidth: function()
	{
		return this.getObject().width;
	},
	isIE: function()
	{
		return this.getObject().ie;
	},
	isFireFox: function()
	{
		return this.getObject().fireFox;
	}
};

var old_width=0;

function bigScreenPage()
{
	if(old_width==0)
	{
		old_width=1000;
	}

	var selectWidth1Obj = document.getElementById('selectWidth1');
	var selectWidth2Obj = document.getElementById('selectWidth2');
	var selectWidth3Obj = document.getElementById('selectWidth3');
	var selectWidth4Obj = document.getElementById('selectWidth4');
	var selectWidth5Obj = document.getElementById('selectWidth5');

	if(selectWidth1Obj!=null && selectWidth1Obj!=undefined)
	{
		var selectWidth = selectWidth1Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth1Obj.style.width=(newSelectWidth)+"px";
		}
	}

	if(selectWidth2Obj!=null && selectWidth2Obj!=undefined)
	{
		var selectWidth = selectWidth2Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth2Obj.style.width=(newSelectWidth)+"px";
		}
	}

	if(selectWidth3Obj!=null && selectWidth3Obj!=undefined)
	{
		var selectWidth = selectWidth3Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth3Obj.style.width=(newSelectWidth)+"px";
		}
	}

	if(selectWidth4Obj!=null && selectWidth4Obj!=undefined)
	{
		var selectWidth = selectWidth4Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth4Obj.style.width=(newSelectWidth)+"px";
		}
	}

	if(selectWidth5Obj!=null && selectWidth5Obj!=undefined)
	{
		var selectWidth = selectWidth5Obj.style.width;
		if(selectWidth!=null && selectWidth!=undefined)
		{
			var newSelectWidth=parseInt((parseInt(selectWidth)/old_width) * documentView.getWidth());
			selectWidth5Obj.style.width=(newSelectWidth)+"px";
		}
	}

	old_width=documentView.getWidth();
}

window.onresize = bigScreenPage;

function hideChanges()
{
	document.getElementById('valuechangesDiv').style.display = 'none';
	document.getElementById('changesDiv').style.display = 'none';
}

</script>

	</head>

	<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" onUnLoad="closeWin()" onLoad="show(); bigScreenPage();">
	<form name="CfMacro" method="post" style="margin:0px;padding:0px;">
	<input type="hidden" name="ec_rtype" value="Change">
	<input type="hidden" name="ec_trgttype" value="Configuration Report">
	<input type="hidden" name="ec_start_time" value="<%=s_start_time%>">
	<input type="hidden" name="ec_end_time" value="<%=s_end_time%>">
	<input type="hidden" name="ec_hasAllComponentAccess" value="<%=hasAllComponentAccess%>">
	<input type="hidden" name="user_language" value="<%=userLanguage%>">
	<input type="hidden" name="fromField" id="fromField" value="from">
	<input type="hidden" name="ec_topN" value="<%=topN%>">
	<input type="hidden" name="ec_criteriaPrevious" value="<%=ec_criteria%>">
	<input type="hidden" name="ec_userOptionPrevious" value="<%=((ec_userOption != null)?ec_userOption:"")%>">
	<input type="hidden" name="searchCompValue" value="<%=searchCompValue%>">
	<input type="hidden" name="searchTestValue" value="<%=searchTestValue%>">
	<input type="hidden" name="searchDescValue" value="<%=searchDescValue%>">

	<div id="valuechangesDiv" name="valuechangesDiv" style="display:none;position:absolute;border:0px solid #ff0000;z-index:500;height:225px;" class="ui-widget-content">
		<table border="0" cellpadding="0" cellspacing="0" >
			<tr>
				<td colspan="3">
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td width="5" height="50" class="panel_top_left"><img src="/final/monitor/eg_images/spacer.gif" width="5" height="22" border="0"></td>
							<td class="panel_top_bg whitefont" height="22px" width="100%"><egui:intnl text='configmgmt.changes.detailed.Difference' /></td>
							<td class="panel_top_bg whitefont" height="50px" width="100%">
							<td align="right" class="panel_top_bg" style="padding-top:2px"><img src="/final/monitor/eg_images/gray/popup_close.png" onclick="javascript:hideChanges();" border="0" class="mouse" title="close"></td>
							<td width="9" height="22" class="panel_top_right"><img src="/final/monitor/eg_images/spacer.gif" width="9" height="22" border="0"></td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="panel_left_bg eg_blankspace" width="5px"><img src="/final/admin/eg_images/spacer.gif"></td>
				<td align="center" valign="top" style="padding:8px 4px 4px 4px;" class="panelbg">
					<table border="0" cellpadding="0" cellspacing="0" width="100%" align="center" class="quickViewBorder">
						<tr>
							<td id="changesDiv"></td>
						</tr>
					</table>
				<td class="panel_right_bg" width="9px"><img src="/final/admin/eg_images/spacer.gif" width="9"></td>
			</tr>
			<tr>
				<td class="panel_bottom_left"><img src="/final/admin/eg_images/spacer.gif" width="5" height="10"></td>
				<td class="panel_bottom_bg" height="10"><img src="/final/admin/eg_images/spacer.gif"></td>
				<td class="panel_bottom_right"><img src="/final/admin/eg_images/spacer.gif" width="9" height="10"></td>
			</tr>
		</table>
	</div>

	<table align="center" cellspacing="0" cellpadding="0" border="0" width="100%" height="100%" class="bgmedium">
<%
	if(!requestFromMonitor)
	{
%>
		<tr>
			<td align="right" valign="middle" id="layer_headbg" style="padding:0px;border-left-width:0px;border-right-width:0px;">
				<div style="border:0px blue solid;height:24px">
					<div style="border:0px solid;float:left;padding:5px" class="main_head_top">
<%
	if (option1 != null && option1.equalsIgnoreCase("Component Name"))
	{
%>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE " />&nbsp;:&nbsp;<egui:intnl text="configmgmt.changes.detailed.DETAILED" />&nbsp;-&nbsp;<egui:intnl text="configmgmt.changes.detailed.COMPONENT NAME" /></b>
<%
	}
	else if (option1 != null && option1.equalsIgnoreCase("Component Type"))
	{
%>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE " />&nbsp;:&nbsp;<egui:intnl text="configmgmt.changes.detailed.DETAILED" />&nbsp;-&nbsp;<egui:intnl text="configmgmt.changes.detailed.COMPONENT TYPE" /> </b>
<%
	}
	else
	{
%>
						&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.CONFIGURATION CHANGE " />&nbsp;:&nbsp;<egui:intnl text="configmgmt.changes.detailed.DETAILED" />&nbsp;-&nbsp;<egui:intnl text="configmgmt.changes.detailed.ALL COMPONENTS" /> </b>
<%
	}
%>
					</div>
					<div style="border:0px solid red;float:right">
<%
	if (requestFromDashboard || requestHomePage || requestFromIBCT || requestFromCurrent || requestFromBoxView || requestFromAllComponentsOption)
	{
%>
						<div style="border:0px solid red;height:22px;float:right;position:relative;margin-top:2px">
							<table cellspacing="0" cellpadding="0" border="0" height="20">
								<tr>
									<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>
									<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>
									<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="printData()">  </td>
									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>
									<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>
									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
									<td width="13" align="center"  id="leftcurvebg" ><img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"></td>
									<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

									<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

									<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>
								</tr>
							</table>
						</div>
<%
	}
%>
						<div style="border:0px solid;float:right;padding:5px">
<%

	if (goBack)
	{
%>
							<a id='mouse' onClick="javascript:history.back();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (fromPage!=null && fromPage.equalsIgnoreCase("configChangeForLayerModel"))
	{
%>
							<a id='mouse' onClick="javascript:history.back();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (fromPage!=null && fromPage.equalsIgnoreCase("configChange"))
	{
		if(isFirefox || isChrome)
		{
%>
							<a id='mouse' onClick="javascript:history.go(-2);">
<%
		}
		else
		{
%>
							<a id='mouse' onClick="javascript:history.back();">
<%
		}
%>
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("Current"))
	{
%>
							<a id='mouse' onClick="javascript:goCurrent();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("DCDS"))
	{
%>
							<a id='mouse' onClick="javascript:goDCDS();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("CAAG"))
	{
%>
							<a id='mouse' onClick="javascript:goCAAG();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("CS"))
	{
%>
							<a id='mouse' onClick="javascript:goCS();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
	{
%>
							<a id='mouse' onClick="javascript:goBackToSaveSchedule();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;&nbsp;
							</a>
<%
	}
	else if (request_from != null && request_from.equalsIgnoreCase("AllComponentsOption"))
	{
%>
							<a id='mouse' onClick="javascript:goAllComponents();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (request_start != null && request_from != null && request_start.equalsIgnoreCase("DCDS") && request_from.equalsIgnoreCase("ACO"))
	{
%>
							<a id='mouse' onClick="javascript:history.back();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (requestFromSearch)
	{
%>
							<a id='mouse' onClick="javascript:goHome();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (requestForHome)
	{
%>
							<a id='mouse' onClick="javascript:goDCDSForDB();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (requestFromDCDS)
	{
%>
							<a id='mouse' onClick="javascript:goDCDSForDB();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
	else if (requestForAllComp)
	{
%>
							<a id='mouse' onClick="javascript:goAllComp();">
								<img src="/final/config/images/back-arrow.gif" />&nbsp;<b><egui:intnl text="configmgmt.common.Back"/></b>&nbsp;
							</a>
<%
	}
%>
						</div>
					</div>
				</div>
			</td>
		</tr>

<%
	if (requestFromDashboard || requestHomePage || requestFromIBCT || requestFromCurrent || requestFromBoxView || requestFromAllComponentsOption)
	{
%>
		<tr>
			<td valign="top" id="bgmedium" width="100%" height="5px" class="eg_blankspace">&nbsp;</td>
		</tr>
<%
		}
	}

	if (requestFromDashboard && !requestFromAllComponentsOption && !requestCompSearch)
	{
%>
		<tr>
			<td id="padding6" style="padding-bottom:0px;padding-top:0px;">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
					<tr>
						<td>
							<table border="0" align="center" width="100%" class="bgdark">
								<tr>
									<td align="left" id="whitefont" height="20"><b><egui:intnl text="configmgmt.inventory.view.Search" /></b></td>
								</tr>
							</table>
						</td>
					</tr>

					<tr>
						<td>
							<table border="0" align="center" width="100%" cellspacing="0" cellpadding="4">
								<tr>
									<td align="right"><b><egui:intnl text="configmgmt.inventory.view.Component" />&nbsp;:</b></td>
									<td nowrap align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td><input type="text" name="compSearch" value="<%=searchCompValue%>"></td>
											</tr>
										</table>
									</td>

									<td align="right"><b><egui:intnl text="configmgmt.inventory.view.Information" />&nbsp;:</b></td>
									<td nowrap align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td><input type="text" name="testSearch" value="<%=searchTestValue%>">
												</td>
											</tr>
										</table>
									</td>

									<td align="right"><b><egui:intnl text="configmgmt.inventory.view.Descriptor" />&nbsp;:</b></td>
									<td nowrap align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td><input type="text" name="descSearch" value="<%=searchDescValue%>">
												</td>
											</tr>
										</table>
									</td>

									<td align="center">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td>&nbsp;<img class="mouse" src=" /final/config/images/gray/arrow_1.gif" title="<egui:intnl text='monitor.common.GO'/>" onClick="javascript:getSearchDetails()" border="0">
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5" id="blank">&nbsp;</td>
		</tr>
<%
	}
	else if (requestFromDashboard && !requestFromAllComponentsOption && requestCompSearch)
	{
%>
		<tr>
			<td id="padding6" style="padding-bottom:0px;padding-top:0px;">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
					<tr>
						<td>
							<table border="0" align="center" width="100%" class="bgdark">
								<tr>
									<td align="left" id="whitefont" height="20"><b><egui:intnl text="configmgmt.inventory.view.Search" /></b></td>
								</tr>
							</table>
						</td>
					</tr>

					<tr>
						<td>
							<table border="0" align="center" width="100%" cellspacing="0" cellpadding="4">
								<tr>
									<td align="right"><b><egui:intnl text="configmgmt.inventory.view.Information" />&nbsp;:</b></td>
									<td nowrap align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td><input type="text" name="testSearch" value="<%=searchTestValue%>">
												</td>
											</tr>
										</table>
									</td>

									<td align="right"><b><egui:intnl text="configmgmt.inventory.view.Descriptor" />&nbsp;:</b></td>
									<td nowrap align="left">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td><input type="text" name="descSearch" value="<%=searchDescValue%>">
												</td>
											</tr>
										</table>
									</td>

									<td align="center">
										<table cellspacing="0" cellpadding="0" border="0">
											<tr>
												<td>&nbsp;<img class="mouse" src=" /final/config/images/gray/arrow_1.gif" title="<egui:intnl text='monitor.common.GO'/>" onClick="javascript:getSearchDetails()" border="0">
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td height="5" id="blank">&nbsp;</td>
		</tr>
<%
	}
%>

		<tr>
			<td valign="top" id="bgmedium" width="100%" height="100%">
				<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">

<%
	if (!requestFromDashboard && !requestHomePage && !requestFromACO && !requestFromIBCT && !requestFromCurrent && !requestFromBoxView && !requestFromAllComponentsOption && !requestFromMonitor)
	{
%>
				<!-- new tab start here -->
					<tr>
						<td id="padding6" style="padding-bottom:0px">
							<table align="center" cellspacing="0" cellpadding="4" width="100%" border="0" id="toptable" style="table-layout:fixed">
								<col width="55"><col width="10"><col width="210">
								<col width="150"><col width="10"><col width="350">
								<tr>
									<td align="right" nowrap><b><egui:intnl text="configmgmt.common.View By" /></b></td>
									<td align="center"><b>:</b></td>
									<td valign="middle">
										<select id="selectWidth1" name="ec_criteria" style="width:200px;" onChange='javascript:getDetails()'>
<%
		if (vecCriterias != null && !vecCriterias.isEmpty())
		{
			for(int i=0; i<vecCriterias.size(); i++)
			{
				String selected = "";
				String strCriteria = (String)vecCriterias.get(i);
				if(ec_criteria != null && strCriteria.equals(ec_criteria))
				{
					selected = "selected";
				}
%>
				<option value="<%=strCriteria%>" <%=selected%>>
					<egui:intnl text='<%="configmgmt.common."+strCriteria%>' />
				</option>
<%
			}
		}
		else
		{
%>
			<option value="-1">
				<egui:intnl text="configmgmt.common.Not Applicable" />
			</option>
<%
		}
%>
										</select>
									</td>
<%
		if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
		{
%>
									<td align="right" nowrap>
<%
			if (ec_criteria.equalsIgnoreCase(criterias[0]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[0]%>' /></b>
<%
			}
			else if (ec_criteria.equalsIgnoreCase(criterias[1]))
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[1]%>' /></b>
<%
			}
			else
			{
%>
				<b><egui:intnl text='<%="configmgmt.common."+criterias[2]%>' /></b>
<%
			}
%>
									</td>
									<td align="center"><b>:</b></td>
									<td>
										<select id="selectWidth2" name="ec_userOption" style="width:300px;" onChange='javascript:getDetails()'>
<%
			if (vecUserOptions != null && !vecUserOptions.isEmpty())
			{
				for(int i=0; i<vecUserOptions.size(); i++)
				{
					String selected = "";
					String strUserOption = (String)vecUserOptions.get(i);
					if(ec_userOption != null && strUserOption.equals(ec_userOption))
					{
						selected = "selected";
					}
%>
					<option value="<%=strUserOption%>" <%=selected%>>
						<%=strUserOption%>
					</option>
<%
				}
			}
			else
			{
%>
				<option value="-1">
					<egui:intnl text="configmgmt.common.Not Applicable" />
				</option>
<%
			}
%>
										</select>
									</td>
<%
		}
		else
		{
%>
									<td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td>
<%
		}
%>
								</tr>
							</table>
						</td>
					</tr>
					<!-- new tab end here -->
					<tr>
						<td width="100%" valign="top">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
								<tr>
									<td id="padding6" valign="top">
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" id="toptable">
											<tr>
												<td>
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text"  style=""><!-- <col width="17%"><col width="30%"><col width="15%"><col width="38%"> -->
														<tr>
															<td  height="5" id="blank" colspan="4">&nbsp; </td>
														</tr>
														<tr>
															<td align="right" nowrap height="26" width="17%"><b><egui:intnl text="configmgmt.changes.detailed.Change criteria" />&nbsp;:&nbsp;</b></td>
															<td colspan="3" align="left">
																<select id="selectWidth3" name="ec_option1" style="width:300px;" onChange="javascript:get();">
<%
		for (int i=0; i<vec_options.size();i++)
		{
			String changeOptions = (String)vec_options.get(i);
			String selected = "";
			if (changeOptions != null && changeOptions.equals(option1))
			{
				selected = "selected";
			}
%>
																	<option value="<%=changeOptions%>" <%=selected%>>
																		<egui:intnl text='<%="configmgmt.changes.detailed."+changeOptions%>' />
																	</option>
<%
		}
%>
																</select>
															</td>
														</tr>
<%
		if (v != null)
		{
			if (option1.equalsIgnoreCase("Component Name") || option1.equalsIgnoreCase("Component Type"))
			{
%>
														<tr>
															<td  height="5" id="blank" colspan="4">&nbsp; </td>
														</tr>
														<tr>
<%
				if (option1.equalsIgnoreCase("Component Name"))
				{
%>
															<td align="right" >&nbsp;&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Name" />&nbsp;:&nbsp;</b></td>
<%
				}
				if (option1.equalsIgnoreCase("Component Type"))
				{
%>
															<td align="right" >&nbsp;&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Type" />&nbsp;:&nbsp;</b></td>
<%
				}
%>
															<td align="left" colspan="3">
																<select id="selectWidth4" name="ec_option2" style="width:350px;" onChange="javascript:get();">
<%
				if( v != null && !v.isEmpty())
				{
					if (option1.equalsIgnoreCase("Component Name"))
					{
%>
															<option value="-1">
																<egui:intnl text="configmgmt.changes.detailed.Please choose a component Name" />
															</option>
<%
						for (int i=0; i<v.size(); i++)
						{
							String componentTemp = (String)v.get(i);
							String temp1 = "";
							String temp2 = "";
							String selected = "";
							if (componentTemp != null)
							{
								if (componentTemp.lastIndexOf(":") >= 0)
								{
									temp1 = componentTemp.substring(0,componentTemp.lastIndexOf(":"));
									if (temp1.endsWith(":NULL"))
										temp1 = temp1.substring(0,temp1.indexOf(":"));
									temp2 = componentTemp.substring(componentTemp.lastIndexOf(":")+1);
									//getting component type mapping name
									temp2 = mappingInfo.getComponentTypeDescription(temp2);
									temp1 = temp1 + ":"+ temp2;
								}
								else
								{
									temp1 = mappingInfo.getTextDescription("configmgmt.changes.detailed."+componentTemp);
								}
								if (componentTemp.equals(option2))
								{
									selected = "selected";
								}
							}
%>
																	<option value="<%=componentTemp%>" <%=selected%>>
																		<%=temp1%>
																	</option>
<%
						}
					}
					if (option1.equalsIgnoreCase("Component Type"))
					{
%>
															<option value="-1">
																<egui:intnl text="configmgmt.changes.detailed.Please choose a component Type" />
															</option>
<%
						String tmpChoose=(String)v.remove(0);
						serverList = sorter.getSortedCompTypeList(v);
%>
																	<option value="<%=tmpChoose%>" <%=(tmpChoose.equals(option2))?"selected":""%>><%=mappingInfo.getTextDescription("configmgmt.changes.detailed."+tmpChoose)%>
																	</option>
<%
						for (int i=0; i<serverList.size(); i++)
						{
							EgName nameObj = (EgName)serverList.get(i);
							String actualName = nameObj.getActualName();
							String localName = nameObj.getLocalName();
							String selected = "";
							if (actualName.equals(option2))
							{
								selected = "selected";
							}
%>
							<option value="<%=actualName%>" <%=selected%>><%=localName%></option>
<%
						}
					}
				}
				else
				{
%>
													<option value="-1">
														<egui:intnl text="configmgmt.common.Not Applicable" />
													</option>
<%
				}
%>
																</select>
															</td>
														</tr>
<%
			}
		}
%>
														
													</table>
												</td>
											</tr>
											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>
											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed"><col width="17%"><col width="33%"><col width="10%"><col width="40%">
														<tr>
															<td align="right" nowrap  valign="top"><b><egui:intnl text="configmgmt.changes.detailed.Show changes in" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" valign="top"><select id="selectWidth5" name="ec_test" style="width:300px;" size="6" multiple>
<%
		if (s_selectedInformations != null)
		{
			for (int i=0;i<sortedTestList.size();i++)
			{
				EgName nameObj = (EgName)sortedTestList.get(i);
				String strTestName = nameObj.getActualName();
				String strDispName = nameObj.getLocalName();
				String tmpSelectedStatus = "";

				if (l_selectedInformations.contains(strTestName))
					tmpSelectedStatus = "selected";
				else
					tmpSelectedStatus = "";
%>
																<option VALUE="<%=strTestName%>" <%=tmpSelectedStatus%>>
																<%=strDispName%>
																</option>
<%
			}
		}
		else
		{
			if (sortedTestList!=null && sortedTestList.size()>0)
			{
				for (int i=0;i<sortedTestList.size();i++)
				{
					EgName nameObj = (EgName)sortedTestList.get(i);
					String strTestName = nameObj.getActualName();
					String strDispName = nameObj.getLocalName();
%>
																<option VALUE="<%=strTestName%>" selected>
																<%=strDispName%>
																</option>
<%
				}
			}
			else
			{
%>
																<option VALUE= "-1"><egui:intnl text="configmgmt.common.Not Applicable" /></option>
<%
			}
		}
%>
															</select>
															</td>
															<td align="right" nowrap valign="top" style="padding-top:2px"><b><egui:intnl text="configmgmt.changes.detailed.Timeline" /></b>&nbsp;:&nbsp;</td>
															<td nowrap align="left" valign="top"><%@ include file="EcTimeLine.jsp"%>
															</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed"><col width="17%"><col width="13%"><col width="7%"><col width="14%"><col width="6%"><col width="43%">
														<tr>
															<td nowrap align="right" ><b><egui:intnl text="configmgmt.changes.detailed.Show" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left" >
																<table border="0" cellpadding="0" cellspacing="0">
																	<tr>
																		<td> <input id="eg_input" type="radio" name="ec_changetype" value="Latest" onClick="" <%=lflag%>> </td> 
																		<td>&nbsp;<egui:intnl text="configmgmt.changes.detailed.Recent changes" /> </td>
																	</tr>
																</table>
															</td>
															<td nowrap align="left" colspan="2">
																<table border="0" cellpadding="0" cellspacing="0">
																	<tr>
																		<td> 
																		<td nowrap align="left"> <input type="radio" id="eg_input" name="ec_changetype" value="All" onClick="" <%=aflag%>> </td>
																		<td>&nbsp;<egui:intnl text="configmgmt.changes.detailed.All changes" /> </td>
																	</tr>
																</table>
															</td>
															<td align="right" nowrap >&nbsp;</td>
															<td nowrap align="left" >&nbsp;</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" style="table-layout:fixed"><col width="17%"><col width="13%"><col width="7%"><col width="14%"><col width="6%"><col width="43%">
														<tr>
															<td nowrap align="right" ><b><egui:intnl text="configmgmt.changes.detailed.Arrange changes by" />&nbsp;:&nbsp;</b></td>
															<td nowrap align="left"> 
																<table border="0" cellpadding="0" cellspacing="0">
																	<tr>
																		<td> <input  type="radio" id="eg_input" name="ec_viewchange" value="byInformation" onClick="javascript:show();" <%=informationflag%>> </td>
																		<td>&nbsp;<egui:intnl text="configmgmt.configuration.Information" /></td>
																	</tr>
																</table>
															</td>
															<td nowrap align="left">
																<table border="0" cellpadding="0" cellspacing="0">
																	<tr>
																		<td> <input style="vertical-align:middle" type="radio" id="eg_input" name="ec_viewchange" value="byDate" onClick="javascript:show();" <%=dateflag%>> </td>
																		<td>&nbsp;<egui:intnl text="configmgmt.changes.detailed.Date" /> </td>
																	</tr>
																</table>
															</td>
															<td nowrap align="right" > <span id="mpiLabel" style="display:none"><b><egui:intnl text="configmgmt.changes.detailed.Changes per page" />&nbsp;:&nbsp;</b></span> </td>
															<td nowrap align="left" > <span id="mpi" style="display:none"> <select name="ec_maxpageitems" style="width:50px;"> <%=ecUtils.fillSelectBox(vec_changesperpage,"",s_maxpageitems)%> </select> </span> </td>
															<td nowrap align="left" >&nbsp;</td>
														</tr>
													</table>
												</td>
											</tr>

											<tr>
												<td height="5" id="blank">&nbsp;</td>
											</tr>

											<tr>
												<td align="center">
													<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="body_text" >
														<tr>
															<td align="center" width="15%">
																&nbsp;
															</td>
<%
		if (request_from != null && request_from.equalsIgnoreCase("saveSchedule"))
		{
%>
															<td align="center" width="70%"><input type="button" name="x" value='<egui:intnl text="configmgmt.common.SAVE" />' id="darkbutton" style="width: 75px; height: 20px;" href="" onClick="javascript:schedule('schedule');">
															</td>
<%
		}
		else
		{
%>
															<td align="center" width="70%"><input type="button" name="x" value='<egui:intnl text="configmgmt.common.SUBMIT" />' id="darkbutton" style="width: 75px; height: 20px;" onClick="javascript:fetchData('submit');">
															</td>
<%
		}
%>
															<td align="right"   rowspan="2" style="height:24" valign="bottom">
																<table align="right" cellspacing="0" cellpadding="0" border="0" height="20">
																	<tr>
																		<td width="50" align="center" id="leftcurve" > <img src="/final/config/images/spacer.gif" width="50px" height="20px"> </td>

																		<td width="2" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="2" > </td>

																		<td align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/print.gif" border="0" title='<egui:intnl text="configmgmt.common.PRINT" />' onClick="javascript:printData()">  </td>

																		<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif" width="13" > </td>

																		<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src= "../config/images/pdf.gif" border="0" title='<egui:intnl text="configmgmt.common.PDF" />' onClick="javascript:savePdf();"> </td>

																		<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

																		<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/mail.gif" border="0" title='<egui:intnl text="configmgmt.common.MAIL" />' onClick="javascript:mail()"> </td>

																		<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>

																		<td width="13" align="center" id="leftcurvebg"><img class="mouse" src="../config/images/csv.gif" border="0" title='<egui:intnl text="configmgmt.common.CSV" />' onClick="javascript:csv()"> </td>

																		<td width="13" align="center" id="leftcurvebg"><img src="/final/config/images/spacer.gif"  width="13"></td>

																		<td width="13" align="center"  id="leftcurvebg" > <img class="mouse" src="../config/images/schedules.gif" border="0" title='<egui:intnl text="configmgmt.common.ADD TO SCHEDULES" />' onClick="javascript:schedule('schedule')"> </td>

																		<td width="13" align="center"  id="leftcurvebg"> <img src="/final/config/images/spacer.gif"  width="13"> </td>
																	</tr>
																</table>
															</td>
														</tr>
														<tr>
															<td height="5" id="blank" colspan="2">&nbsp;</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							</table>
						</td>
					</tr>
<%
	}
%>
					<tr>
						<td id="<%=paddingValue%>" height="100%" width="100%" valign="top" style="padding-top:0px">
							<div class="div_scroll" style="border:0px solid #ff0000; height:100%; width:100%;">
							<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top" id="<%=monBottomTableVal%>">
								<tr>
									<td width="100%"  valign="top">
<%
	if (tmap_changeConfigDetails != null)
	{
%>
										<input type="hidden" name="submitClicked" value="true">
<%
		if (tmap_changeConfigDetails.isEmpty())
		{
%>
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%" valign="top">
											<tr>
												<td width="100%" height="100%">
													<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0" height="100%">
														<tr>
															<td align="center" height="100%" >
																<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
																	<tr>
																		<td align="center">
																			<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0">
																				<tr>
																					<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
																				</tr>
																				<tr>
																					<td align="center"> <b><egui:intnl text="configmgmt.changes.detailed.There were no configuration changes in the selected timeline" /></b></td>
																				</tr>
																			</table>
																		</td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
<%
		}
		else
		{
%>
										<table valign="top" cellspacing="0" cellpadding="0" width="100%" border="0">
											<tr>
												<td>
<%
			ArrayList aListComponents = new ArrayList();
			Iterator component_keys = tmap_changeConfigDetails.keySet().iterator();
			while (component_keys.hasNext())
			{
				String key_component = (String)component_keys.next();
				if (!key_component.equalsIgnoreCase("Change By Date"))
					aListComponents.add(key_component);
			}

			//For New Pdf Framework - Krishnamurthi
			ArrayList aListPdfData = new ArrayList();
			ArrayList aListTestNamesForCSV = new ArrayList(); 
			EgPdfData pdfData = new EgPdfData();
			
			EgReportAttributes reportAttributes = new EgReportAttributes();

			String pdfTitle = "";
			if (ec_criteria != null && !ec_criteria.equalsIgnoreCase(criterias[3]) && !ec_criteria.equals("-1"))
			{
				pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CHANGE CONFIGURATION REPORT") + " IN" + " '" + ec_userOption + "' "  +  ec_criteria + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
			}
			else
			{
				pdfTitle = mappingInfo.getTextDescription("configmgmt.inventory.view.CHANGE CONFIGURATION REPORT") + "  " + mappingInfo.getTextDescription("configmgmt.configuration.as on") + "  " + dateString;
			}
			//pdfTitle = pdfTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.CONFIGURATION CHANGES") + " : " + mappingInfo.getTextDescription("configmgmt.changes.detailed.DETAILED");

			reportAttributes.setMainTitle(pdfTitle);

			reportAttributes.setReportName("DetailedConfigurationChanges");
			reportAttributes.setModule("CONFIG");

			if (option1.equalsIgnoreCase(userOptions[2])) //Only for All Components
			{
				//For PDF
				String subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.All Components")+"\n";
%>
													<table border="0" align="center" width="100%" class="bgdark">
														<tr>
															<td align="left"  id="whitefont" height="20"><egui:intnl text='<%="configmgmt.changes.detailed."+option1%>' /></td>
															<td align="right" id="whitefont">
<%
				if (s_timeline != null && !s_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(tempStartDateTime,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(tempEndDateTime,user);
					endDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
					<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
				}
				else
				{
					startDateAndTime = tempStartDate + " " + sHour + ":" + sMinute;
					endDateAndTime = tempEndDate + " " + eHour + ":" + eMinute;

					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(tempStartDate + " " + sHour + ":" + sMinute,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(tempEndDate + " " + eHour + ":" + eMinute,user);
					endDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
					<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
				}
%>
															</td>
														</tr>
<%
				if (requestHomePage)
				{
					subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date") + " : " + DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",currentDateFormat);
%>
														<tr>
															<td  align="right" id="whitefont" colspan="2"><b><egui:intnl text="configmgmt.changes.detailed.Selected Date" /> : </b><%=DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",currentDateFormat)%>
<%
					if (!timeZone.equals(""))
					{
						subTitle = subTitle + "     " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour") + " : " + timeZone;
%>
							&nbsp;&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Selected Hour" /> : </b><%=timeZone%>
<%
					}
%>
															</td>
														</tr>
<%
				}
%>
													</table>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
				//For PDF
				EgTableAttributes egTableAttributes = new EgTableAttributes();
				ArrayList aListColumnNames = new ArrayList();
				ArrayList aListData = new ArrayList();

				aListColumnNames.add("C0");

				TreeMap tmapAllComponentChanges = processChangeData.getAllComponentSummary(tmap_changeConfigDetails,selectedDate,timeZone);
				Iterator changeCountKeys = tmapAllComponentChanges.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					if (changeCount.intValue() == -1) continue;
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				ArrayList aListChangedComponentTypes = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();
				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapAllComponentChanges.get(changeCount);
					aListChangedComponentTypes.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}
				totalChangeCount = totalCount;

				//Build graph for TopN items
				StringBuffer strBufferChangedComponentsTypes = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				StringBuffer strBufferColors = new StringBuffer();
				String yAxisMaxValue = " ";
				ArrayList aListLinks = new ArrayList();
				String aListLinkStr = " ";
				String linkUrl = " ";
				ArrayList aListCount = new ArrayList();
				int indexCount = 0;
				boolean topNFlag = false;

				if (aListChangedComponentTypes.size() < topN)
				{
					indexCount = aListChangedComponentTypes.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				String strQuery_A = "";
				if (request_from == null)
				{
					strQuery_A = "request_from=AllComponentsOption";
				}
				else if (request_from != null && request_from.equalsIgnoreCase("DCDSForDashboard"))
				{
					strQuery_A = "request_start=Dashboard&request_from=DCDSForDashboard";
				}
				else if (request_from != null && request_from.equalsIgnoreCase("DCDS"))
				{
					strQuery_A = "request_start=DCDS&request_from=ACO";
				}

				String strQuery_B = "&ec_test="+EgURLEncoder.encode(tempSelectedTests,"UTF-8");

				for (int b=0; b<indexCount; b++)
				{
					String componentType = (String)aListChangedComponentTypes.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);
					if (!aListCount.contains(changeCount))
					{
						aListCount.add(changeCount);
					}
					count = count + changeCount.intValue();
					if (b==0)
					{
						strBufferChangedComponentsTypes.append(mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(changeCount.intValue());
						strBufferColors.append(barColor);
					}
					else
					{
						strBufferChangedComponentsTypes.append(","+mappingInfo.getComponentTypeDescription(componentType));
						strBufferChangeCounts.append(","+changeCount.intValue());
						strBufferColors.append(","+barColor);
					}

					String strQuery_C = "/final/servlet/com.eg.EcConfigurationServlet?ec_rtype=Change&ec_option1="+URLEncoder.encode("Component Type")+"&ec_option2="+EgURLEncoder.encode(componentType,"UTF-8")+"&ec_changetype="+s_changetype+"&ec_timeline="+s_timeline+"&ec_prevtimeline="+s_prevtimeline+"&ec_stdate_h="+URLEncoder.encode(s_stdate)+"&ec_sthr_h="+s_sthr+"&ec_startmin_h="+s_startmin+"&ec_enddate_h="+URLEncoder.encode(s_enddate)+"&ec_endhr_h="+s_endhr+"&ec_endmin_h="+s_endmin+"&ec_maxpageitems="+s_maxpageitems+"&ec_viewchange="+s_viewchange+"&"+strQuery_A+"&timeZone="+timeZone+"&selectDate="+selectedDate+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")+"&searchCompValue="+searchCompValue+"&searchTestValue="+searchTestValue+"&searchDescValue="+searchDescValue;;

					if (request_from == null || request_from.equalsIgnoreCase("AllComponentsOption"))
					{
						linkUrl = strQuery_C + strQuery_B;
					}
					else if(request_from != null || request_from.equalsIgnoreCase("DCDSForDashboard") || request_from.equalsIgnoreCase("DCDS"))
					{
						linkUrl = strQuery_C;
					}

					aListLinks.add(linkUrl);
				}
				StringBuffer linkStrBuffer = new StringBuffer();
				if (aListLinks != null && aListLinks.size() > 0)
				{
					linkStrBuffer.append((String)aListLinks.get(0));
					for (int i=1; i<aListLinks.size(); i++)
					{
						linkStrBuffer.append(",");
						linkStrBuffer.append(aListLinks.get(i));
					}
				}
				aListLinkStr = linkStrBuffer.toString();

				String barLabels = strBufferChangedComponentsTypes.toString();
				String barValues = strBufferChangeCounts.toString();
				String barColors = strBufferColors.toString();

				boolean flagEqualsOne = true;
				for (int i=1; i<aListCount.size(); i++)
				{
					Integer count_Value = (Integer)aListCount.get(i);
					if (count_Value.intValue() > 1)
					{
						flagEqualsOne = false;
						break;
					}
				}
				if (flagEqualsOne)
				{
					yAxisMaxValue = "5";
				}
				else
				{
					yAxisMaxValue = "0";
				}

				//Fusion Bar chart Data for All components starts --Rekha
				HashMap mapChartAttributes = new HashMap();//map for chart attributes
				mapChartAttributes.put("bgcolor","FFFFFF");
				mapChartAttributes.put("yAxisName","Number of changes");
				mapChartAttributes.put("showToolTip","1");
				mapChartAttributes.put("showValues","1");
				mapChartAttributes.put("showBorder","0");
				mapChartAttributes.put("showShadow","0");
				mapChartAttributes.put("alpha","0");
				mapChartAttributes.put("canvasBgColor","F2F2F2");
				mapChartAttributes.put("canvasBgAlpha","60");
				mapChartAttributes.put("canvasBorderColor","000000");
				mapChartAttributes.put("canvasBorderThickness","1");
				mapChartAttributes.put("canvasBorderAlpha","30");
				mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
				mapChartAttributes.put("maxBarHeight","40");
				mapChartAttributes.put("unescapeLinks","0");

				HashMap mapChartData = new HashMap();//map for chart data
				mapChartData.put("barLabels",barLabels);
				mapChartData.put("barValues",barValues);
				mapChartData.put("barColors",barColors);
				mapChartData.put("barLinks",aListLinkStr);

				HashMap mapProperties = new HashMap();//map for misc properties
				mapProperties.put("showColors","true");
				mapProperties.put("enableLinks","true");

				EcFusionChartBean chartbean = new EcFusionChartBean();
				String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
				//Fusion Bar Chart Data ends

				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;
				String maximumRange = ""+maxCount;
				String chartTitle = titleName;
				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.component types with maximum changes") + "  " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;//pdf
					chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.component types with maximum changes") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + "&nbsp;(" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + "&nbsp;" + indexCount + ") : " + count + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;//chart
				}

				aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range="+URLEncoder.encode(maximumRange)+"&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(strBufferChangeCounts.toString())+"&barLabels="+EgURLEncoder.encode(strBufferChangedComponentsTypes.toString(),"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

				aListTestNamesForCSV.add(""); 

				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setImageData(true);

				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);

				reportAttributes.setSubTitle(subTitle);
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="6"></td></tr></table>
													<table border="0" align="center" width="99%" class="body_text">
<%
				boolean flag = false;
				if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
				{
					flag = true;
				}
				if (flag)
				{
%>
													<!-- Bar2D chart starts-->
														<tr>
															<td align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
																<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig3DContainer"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig3D" ) )
																	FusionCharts( "StackedBarConfig3D" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf", "StackedBarConfig3D","650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig3DContainer");
																</script>
															</td>
														</tr>
<%
				}
				else
				{
%>
														<tr>
															<td align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
															
															<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar2D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig2DContainer"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig2D" ) )
																	FusionCharts( "StackedBarConfig2D" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf", "StackedBarConfig2D","650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig2DContainer");
																</script>
															</td>
														</tr>
														<!-- Bar2D chart ends-->
<%
				}
%>
													</table>
<%
				TreeMap tmapChangedComponentsUnderType = (TreeMap)tmapAllComponentChanges.get(new Integer("-1"));

				TreeMap tmapFinal = new TreeMap();
				for (int j=0;j<aListChangedComponentTypes.size();j++)
				{
					String componentType = (String)aListChangedComponentTypes.get(j);
					ArrayList aListChangedComponents = (ArrayList)tmapChangedComponentsUnderType.get(componentType);

					TreeMap tmapChangeCount = new TreeMap();
					for (int i=0;i<aListChangedComponents.size();i++)
					{
						String component = (String)aListChangedComponents.get(i);
						String strCount = component.substring(component.indexOf("@")+1);
						Integer intObject = new Integer(strCount);
						ArrayList aListTemp = (ArrayList)tmapChangeCount.get(intObject);
						if (aListTemp == null)
						{
							aListTemp = new ArrayList();
							aListTemp.add(component);
							tmapChangeCount.put(intObject,aListTemp);
						}
						else
						{
							aListTemp.add(component);
						}
					}

					ArrayList aListComponents_T = new ArrayList();
					Iterator iter_changeCountKeys = tmapChangeCount.keySet().iterator();
					while (iter_changeCountKeys.hasNext())
					{
						Integer changeCount = (Integer)iter_changeCountKeys.next();
						ArrayList aListTemp = (ArrayList)tmapChangeCount.get(changeCount);
						for (int x=0;x<aListTemp.size();x++)
						{
							aListComponents_T.add((String)aListTemp.get(x));
						}
					}

					tmapFinal.put(componentType,aListComponents_T);
				}
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

													<table border="0" align="center" width="99%" class="body_text" cellspacing="0" cellpadding="0" id="bottomtable">
														<tr>
															<td class="table_header" id="white_content" colspan="3" height="25">
				<b>&nbsp;<egui:intnl text="configmgmt.changes.detailed.Changes by component type" /> (<egui:intnl text="configmgmt.changes.detailed.Click on a component to view its changes" />)</b>
															</td>
														</tr>
														<tr>
															<td width="100%" id="bgdarkimg" colspan="3" height="20" align="center" > <b><egui:intnl text="configmgmt.changes.detailed.Number of changed component types" /> : <%=aListChangedComponentTypes.size()%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="configmgmt.changes.detailed.Total Changes" /> : <%=totalCount%></b></td>
														</tr>
														<tr>
															<td width="20%" id="cell_header" >&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Component Type" /></b></td>
															<td width="5%" id="cell_header"><b style="text-align:center"><egui:intnl text="configmgmt.changes.detailed.Changes" /></b></td>
															<td width="75%" id="cell_header">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Changed components" /></b></td>
														</tr>
<%
				egTableAttributes = new EgTableAttributes();
				aListColumnNames = new ArrayList();
				aListData = new ArrayList();
				aListTestNamesForCSV = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				aListColumnNames.add("C0");
				aListColumnNames.add("C1");
				aListColumnNames.add("C2");

				userColumnNames.add("");
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components"));
				userColumnNames.add("");

				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes by component type")+"  [ "+mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed component types")+" : "+aListChangedComponentTypes.size()+"     "+mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")+" : "+totalCount+" ]");
				egTableAttributes.setColumnNames(userColumnNames);

				ArrayList aListChangedComponents = new ArrayList();

				for (int g=0; g<aListChangedComponentTypes.size(); g++)
				{
					String componentType = (String)aListChangedComponentTypes.get(g);
					Integer changes = (Integer)aListChangeCount.get(g);
%>
														<tr>
															<td id="<%=cell_bg1Val%>" valign="top" >&nbsp;<egui:intnl type="<%=componentType%>"/></td>
															<td id="<%=cell_bg1Val%>" valign="top" align="center"><%=changes%></td>
															<td align="left">
																<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
<%
					ArrayList aListTemp = (ArrayList)tmapFinal.get(componentType);
					for (int m=0; m<aListTemp.size(); m=m+2)
					{
						aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type")+" : "+mappingInfo.getComponentTypeDescription(componentType)+" ["+mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes")+" : "+changes+"]");
						aListTestNamesForCSV.add("");
%>
																	<tr>
<%
						for (int n=m; n<m+2; n++)
						{
							if (n<aListTemp.size())
							{
								String s1 = (String)aListTemp.get(n);

								String comp = s1.substring(0,s1.indexOf('@'));
								String changeCount = s1.substring(s1.indexOf('@')+1);

								aListChangedComponents.add(comp);
								String s_comp = new String(comp);
								s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));
								if (s_comp.endsWith(":NULL"))
									s_comp = s_comp.substring(0,s_comp.lastIndexOf(':'));

								aListData.add(s_comp+" ["+changeCount+"]");

								String tmpStr = s_comp;
								int displayLength = 28;
								String strCName = StringUtils.egSubString(tmpStr,displayLength);
%>
																		<td width="50%" valign="top" id="<%=cell_bg1Val%>"> <a href="javascript:void(0)" target="_self" class="eg_monlink" onClick="showComponentChanges('<%=EgURLEncoder.encode(comp,"UTF-8")%>')" title="<%=s_comp%>"><%=strCName%>&nbsp;[<%=changeCount%>]</a></td>
<%
							}
							else
							{
								aListData.add(" ");
%>
																		<td width="50%" id="<%=cell_bg1Val%>" valign="top">&nbsp;</td>
<%
							}
							aListTestNamesForCSV.add("");
						}
%>
																	</tr>
<%
					}
%>
																</table>
															</td>
														</tr>
<%
				}

				aListComponents = aListChangedComponents;

				egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setDataGrouping(true);
				egTableAttributes.setDataGroupingField(0);

				egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);
%>
													</table>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
			}

			if (option1.equalsIgnoreCase(userOptions[1])) //Only for Component Type
			{
				String componentType = option2;

				String subTitle = ""; //For PDF
				subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(componentType) + "\n";
%>
													<table border="0" align="center" width="100%" class="bgdark">
														<tr>
															<td align="left" id="whitefont" height="20"><egui:intnl text="configmgmt.changes.detailed.Component Type" /> : <egui:intnl type="<%=componentType%>" />
															</td>
															<td align="right" id="whitefont">
<%
				if (s_timeline != null && !s_timeline.equalsIgnoreCase("Any"))
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(tempStartDateTime,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(tempEndDateTime,user);
					endDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " +  startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
					<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
				}
				else
				{
					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(tempStartDate + " " + sHour + ":" + sMinute,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					timeZoneConverter = new EgTimeZoneConverter(tempEndDate + " " + eHour + ":" + eMinute,user);
					endDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
					<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%> </b>
<%
				}
%>
															</td>
														</tr>
<%
				if (requestHomePage && selectedDate != null && !selectedDate.equals(""))
				{
					subTitle = subTitle + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Date") + " : " + DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",currentDateFormat);
%>
														<tr>
															<td  align="right" id="whitefont" colspan="2"><b><egui:intnl text="configmgmt.changes.detailed.Selected Date" /> : </b><%=DateUtil.changeDateFormat(selectedDate,"MM/dd/yyyy",currentDateFormat)%>
<%
					if (timeZone != null && !timeZone.equals(""))
					{
						subTitle = subTitle + "     " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Selected Hour") + " : " + timeZone;
%>
							&nbsp;&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.Selected Hour" /> : </b><%=timeZone%>
<%
					}
%>
															</td>
														</tr>
<%
				}
%>
													</table>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
				//For PDF
				EgTableAttributes egTableAttributes = new EgTableAttributes();
				ArrayList aListColumnNames = new ArrayList();
				ArrayList aListData = new ArrayList();

				aListColumnNames.add("C0");

				TreeMap tmapChangedComponents = processChangeData.getSummary(tmap_changeConfigDetails,selectedDate,timeZone);
				Iterator changeCountKeys = tmapChangedComponents.keySet().iterator();
				int count = 0;
				int totalCount = 0;
				int maxCount = 0;

				ArrayList aList = new ArrayList();
				while (changeCountKeys.hasNext())
				{
					Integer changeCount = (Integer)changeCountKeys.next();
					aList.add(changeCount);
					maxCount = Math.max(maxCount,changeCount.intValue());
				}
				Collections.reverse(aList);

				StringBuffer strBufferChangedComponents = new StringBuffer();
				StringBuffer strBufferChangeCounts = new StringBuffer();
				StringBuffer strBufferColors = new StringBuffer();
				ArrayList aListChangedComponents = new ArrayList();
				ArrayList aListChangeCount = new ArrayList();
				ArrayList aListLinks = new ArrayList();
				String aListLinkStr = " ";
				String linkUrl = " ";
				String bar_comp = "";
				String yAxisMaxValue = " ";
				ArrayList aListCount = new ArrayList();
				for (int a=0; a<aList.size(); a++)
				{
					Integer changeCount = (Integer)aList.get(a);
					int countValue = changeCount.intValue();

					ArrayList aListTemp = (ArrayList)tmapChangedComponents.get(changeCount);
					aListChangedComponents.addAll(aListTemp);

					for (int i=0; i<aListTemp.size(); i++)
					{
						aListChangeCount.add(changeCount);
						totalCount = totalCount + countValue;
					}
				}
				totalChangeCount = totalCount;

				//Build graph for TopN items
				boolean topNFlag = false;
				int indexCount = 0;
				if (aListChangedComponents.size() < topN)
				{
					indexCount = aListChangedComponents.size();
				}
				else
				{
					indexCount = topN;
					topNFlag = true;
				}

				String strQuery_A = "";
				if (request_from != null && request_from.equalsIgnoreCase("CSForDashboard"))
				{
					strQuery_A = "request_start="+request_start;
				}
				else if (request_from != null && request_from.equalsIgnoreCase("DCDSForDashboard"))
				{
					strQuery_A = "request_start="+request_start;
				}
				else if (request_from != null && request_from.equalsIgnoreCase("DCDS"))
				{
					strQuery_A = "request_start=DCDS";
				}
				else if (request_from != null && request_from.equalsIgnoreCase("CS"))
				{
					strQuery_A = "request_start=CS";
				}
				else if (request_from != null && request_from.equalsIgnoreCase("AllComponentsOption"))
				{
					strQuery_A = "request_start=AllComponentsOption";
				}
				String strQuery_B = "&ec_test="+EgURLEncoder.encode(tempSelectedTests,"UTF-8");

				for (int b=0; b<indexCount; b++)
				{
					String comp = (String)aListChangedComponents.get(b);
					Integer changeCount = (Integer)aListChangeCount.get(b);
					if (!aListCount.contains(changeCount))
					{
						aListCount.add(changeCount);
					}
					count = count + changeCount.intValue();

					bar_comp = comp.substring(0,comp.lastIndexOf(':'));
					if (bar_comp.endsWith(":NULL"))
					{
						bar_comp = bar_comp.substring(0,bar_comp.lastIndexOf(':'));
					}

					if (b==0)
					{
						strBufferChangedComponents.append(bar_comp);
						strBufferChangeCounts.append(changeCount.intValue());
						strBufferColors.append(barColor);
					}
					else
					{
						strBufferChangedComponents.append(","+bar_comp);
						strBufferChangeCounts.append(","+changeCount.intValue());
						strBufferColors.append(","+barColor);
					}

					String strQuery_C = "../config/ecShowComponentChanges.jsp?componentName="+EgURLEncoder.encode(comp,"UTF-8")+"&ec_viewchange="+s_viewchange+"&ec_maxpageitems="+s_maxpageitems+"&ec_changetype="+s_changetype+"&ec_timeline="+s_timeline+"&ec_prevtimeline="+s_prevtimeline+"&ec_stdate_h="+URLEncoder.encode(s_stdate)+"&ec_sthr_h="+s_sthr+"&ec_startmin_h="+s_startmin+"&ec_enddate_h="+URLEncoder.encode(s_enddate)+"&ec_endhr_h="+s_endhr+"&ec_endmin_h="+s_endmin+"&request_from="+request_from+"&ec_criteria="+ec_criteria+"&ec_userOption="+((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")+"&"+strQuery_A+"&searchCompValue="+searchCompValue+"&searchTestValue="+searchTestValue+"&searchDescValue="+searchDescValue;

					if (request_from == null || request_from.equalsIgnoreCase("AllComponentsOption"))
					{
						linkUrl = strQuery_C + strQuery_B;
					}
					else if (request_from != null || request_from.equalsIgnoreCase("DCDSForDashboard") || request_from.equalsIgnoreCase("DCDS"))
					{
						linkUrl = strQuery_C;
					}

					aListLinks.add(linkUrl);
				}

				StringBuffer linkStrBuffer = new StringBuffer();
				if (aListLinks != null && aListLinks.size() > 0)
				{
					linkStrBuffer.append((String)aListLinks.get(0));
					for (int i=1; i<aListLinks.size(); i++)
					{
						linkStrBuffer.append(",");
						linkStrBuffer.append(aListLinks.get(i));
					}
				}
				aListLinkStr = linkStrBuffer.toString();

				aListComponents = aListChangedComponents;
				String barLabels = strBufferChangedComponents.toString();;
				String barValues = strBufferChangeCounts.toString();
				String barColors = strBufferColors.toString();

				boolean flagEqualsOne = true;
				for (int i=1; i<aListCount.size(); i++)
				{
					Integer count_Value = (Integer)aListCount.get(i);
					if (count_Value.intValue() > 1)
					{
						flagEqualsOne = false;
						break;
					}
				}
				if (flagEqualsOne)
				{
					yAxisMaxValue = "5";
				}
				else
				{
					yAxisMaxValue = "0";
				}

				//Fusion Bar chart Data for component type starts--Rekha
				HashMap mapChartAttributes = new HashMap();//map for chart attributes
				mapChartAttributes.put("bgcolor","FFFFFF");
				mapChartAttributes.put("yAxisName","Number of changes");
				mapChartAttributes.put("showToolTip","1");
				mapChartAttributes.put("showValues","1");
				mapChartAttributes.put("showBorder","0");
				mapChartAttributes.put("showShadow","0");
				mapChartAttributes.put("alpha","0");
				mapChartAttributes.put("canvasBgColor","F2F2F2");
				mapChartAttributes.put("canvasBgAlpha","60");
				mapChartAttributes.put("canvasBorderColor","000000");
				mapChartAttributes.put("canvasBorderThickness","1");
				mapChartAttributes.put("canvasBorderAlpha","30");
				mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
				mapChartAttributes.put("maxBarHeight","40");
				mapChartAttributes.put("unescapeLinks","0");

				HashMap mapChartData = new HashMap();//map for chart data
				mapChartData.put("barLabels",barLabels);
				mapChartData.put("barValues",barValues);
				mapChartData.put("barColors",barColors);
				mapChartData.put("barLinks",aListLinkStr);

				HashMap mapProperties = new HashMap();//map for misc properties
				mapProperties.put("showColors","true");
				mapProperties.put("enableLinks","true");
				EcFusionChartBean chartbean = new EcFusionChartBean();
				String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
				//Fusion Bar Chart Data ends
				String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;

				String maximumRange = ""+maxCount;
				String chartTitle = titleName;
				if (topNFlag)
				{
					titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.components with maximum changes") + "  " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + count + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;//pdf
					chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.components with maximum changes") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + "&nbsp;(" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + "&nbsp;" + indexCount + ") : " + count + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + totalCount;//chart
				}

				aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range="+URLEncoder.encode(maximumRange)+"&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(strBufferChangeCounts.toString())+"&barLabels="+EgURLEncoder.encode(strBufferChangedComponents.toString(),"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

				aListTestNamesForCSV.add("");

				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setImageData(true);

				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);

				reportAttributes.setSubTitle(subTitle);
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="6"></td></tr></table>
													<table border="0" align="center" width="99%" class="body_text">
<%
				boolean flag = false;
				if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
				{
					flag = true;
				}
				//for fusioncharts to get comp name
				String component_chart="";
				if (s_viewchange != null && (s_viewchange.equalsIgnoreCase("byInformation") || s_viewchange.equalsIgnoreCase("byDate")))
				{
					if(userOptions[0]!=null)
					{
						if (option1.equalsIgnoreCase(userOptions[0]))
						{
							String key_component = (String)aListComponents.get(0);
							component_chart = key_component.substring(0,key_component.lastIndexOf(':'));
							if (component_chart.endsWith(":NULL"))
							{
							component_chart = component_chart.substring(0,component_chart.lastIndexOf(':'));//comp name
							}
						}
					}
				}
				if (flag)
				{
					
%>
													<!-- Bar2D chart starts-->
														<tr>
															<td align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
															<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar3D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig3DContainer2<%=component_chart%>"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig3D2<%=component_chart%>" ) )
																FusionCharts( "StackedBarConfig3D2<%=component_chart%>").dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","StackedBarConfig3D2<%=component_chart%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig3DContainer2<%=component_chart%>");
																</script>
															</td>
														</tr>
<%
				}
				else
				{
%>
														<tr>
															<td align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
															<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar2D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig2DContainer2<%=component_chart%>"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig2D2<%=component_chart%>" ) )
																FusionCharts( "StackedBarConfig2D2<%=component_chart%>" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","StackedBarConfig2D2<%=component_chart%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig2DContainer2<%=component_chart%>");
																</script>
															</td>
														</tr>
													<!-- Bar2D chart ends-->
<%
				}
%>
													</table>

													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

													<table border="0" width="99%" cellspacing="0" cellpadding="0" align="center" class="body_text" >
														<tr>
															<td class="table_header" id="white_content" style="padding:3px" colspan="3">
																<b><egui:intnl text="configmgmt.changes.detailed.Changed components" /> (<egui:intnl text="configmgmt.changes.detailed.Click on a component to view its changes" />)</b>
															</td>
														</tr>
														<tr>
															<td width="100%" class="tdbackcolortop" id="white_content" colspan="3" align="center"><b><egui:intnl text="configmgmt.changes.detailed.Number of changed components" /> : <%=aListChangedComponents.size()%>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<egui:intnl text="configmgmt.changes.detailed.Total Changes" /> : <%=totalCount%></b></td>
														</tr>
<%
				egTableAttributes = new EgTableAttributes();
				aListColumnNames = new ArrayList();
				aListData = new ArrayList();
				aListTestNamesForCSV = new ArrayList();
				ArrayList userColumnNames = new ArrayList();

				aListColumnNames.add("C0");
				aListColumnNames.add("C1");
				aListColumnNames.add("C2");

				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changed components"));
				userColumnNames.add("");
				userColumnNames.add("");

				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Number of changed components")+" : "+aListChangedComponents.size()+"     "+mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")+" : "+totalCount);

				egTableAttributes.setColumnNames(userColumnNames);

				for (int d=0; d<aListChangedComponents.size(); d=d+3)
				{
%>
														<tr>
<%
					for (int e=d; e<d+3; e++)
					{
						if (e<aListChangedComponents.size())
						{
							String strComp = (String)aListChangedComponents.get(e);
							strComp = strComp.substring(0,strComp.lastIndexOf(':'));
							if (strComp.endsWith(":NULL"))
								strComp = strComp.substring(0,strComp.lastIndexOf(':'));

							aListData.add(strComp+" ["+aListChangeCount.get(e)+"]");
%>
															<td id="<%=cell_bg1Val%>" width="33%">
																<a href="javascript:void(0)" target="_self" class="eg_monlink" onClick="showComponentChanges('<%=EgURLEncoder.encode((String)aListChangedComponents.get(e),"UTF-8")%>')">
																	<%=strComp%>
																</a> [<%=aListChangeCount.get(e)%>]
															</td>
<%
						}
						else
						{
							aListData.add(" ");
%>
															<td id="<%=cell_bg1Val%>" width="33%">&nbsp;</td>
<%
						}
						aListTestNamesForCSV.add("");
					}
%>
														</tr>
<%
				}

				egTableModel = new EgTableModel(aListData,aListColumnNames);

				egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);
%>
													</table>

													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>
<%
			}

			if (s_viewchange != null && s_viewchange.equalsIgnoreCase("byDate"))
			{
				if (option1.equalsIgnoreCase(userOptions[0]))
				{
					String key_component = (String)aListComponents.get(0);

					String component = key_component.substring(0,key_component.lastIndexOf(':'));
					if (component.endsWith(":NULL"))
						component = component.substring(0,component.lastIndexOf(':'));

					String subTitle = ""; //For PDF
					subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name") + " : " + component + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(key_component.substring(key_component.lastIndexOf(':')+1)) + "\n";
%>
													<table border="0" align="center" width="100%" class="bgdark">
														<tr>
															<td align="left" id="whitefont" height="20">&nbsp;<egui:intnl text="configmgmt.changes.detailed.Component Name" /> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(key_component.substring(key_component.lastIndexOf(':')+1))%>]</td>
															<td align="right" id="whitefont">
<%
					if (s_timeline != null && !s_timeline.equalsIgnoreCase("Any"))
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(tempStartDateTime,user);
						startDateAndTime = timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(tempEndDateTime,user);
						endDateAndTime = timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */

						subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " +  startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
						<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
					}
					else
					{
						/* Added by Prakash.K starts */
						timeZoneConverter = new EgTimeZoneConverter(tempStartDate + " " + sHour + ":" + sMinute,user);
						startDateAndTime = timeZoneConverter.getDateTime();
						timeZoneConverter = new EgTimeZoneConverter(tempEndDate + " " + eHour + ":" + eMinute,user);
						endDateAndTime = timeZoneConverter.getDateTime();
						/* Added by Prakash.K ends */

						subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime+ " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
						<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%> </b>
<%
					}
%>
															&nbsp;</td>
														</tr>
													</table>

													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="15"></td></tr></table>

<%
					//For PDF
					EgTableAttributes egTableAttributes = new EgTableAttributes();
					ArrayList aListColumnNames = new ArrayList();
					ArrayList aListData = new ArrayList();

					aListColumnNames.add("C0");

					TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,timeZone);
					Iterator changeCountKeys = tmapChanges.keySet().iterator();
					int totalCount=0;
					int maxCount=0;
					ArrayList aList = new ArrayList();
					while (changeCountKeys.hasNext())
					{
						Integer changeCount = (Integer)changeCountKeys.next();
						aList.add(changeCount);
						maxCount=Math.max(maxCount,changeCount.intValue());
					}
					Collections.reverse(aList);

					ArrayList aListTestnames = new ArrayList();
					ArrayList aListChangeCount = new ArrayList();

					StringBuffer strBufferTestnames = new StringBuffer(); //for bar chart label
					StringBuffer strBufferChangeCounts = new StringBuffer();//for bar chart label count
					StringBuffer strBufferColors = new StringBuffer();//for bar chart color
					String yAxisMaxValue = " ";
					ArrayList aListCount = new ArrayList();

					int i_totalChangeCount = 0;
					for (int a=0; a<aList.size(); a++)
					{
						Integer changeCount = (Integer)aList.get(a);
						ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

						aListTestnames.addAll(aListTemp);

						for (int i=0; i<aListTemp.size(); i++)
						{
							aListChangeCount.add(changeCount);
							i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
						}
					}

					//Build graph for TopN items
					boolean topNFlag = false;
					int indexCount = 0;
					if (aListTestnames.size() < topN)
					{
						indexCount = aListTestnames.size();
					}
					else
					{
						indexCount = topN;
						topNFlag = true;
					}

					for (int b=0; b<indexCount; b++)
					{
						String testname = (String)aListTestnames.get(b);
						Integer changeCount = (Integer)aListChangeCount.get(b);
						if (!aListCount.contains(changeCount))
						{
							aListCount.add(changeCount);
						}
						if (b == 0)
						{
							strBufferTestnames.append(mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(changeCount.intValue());
							strBufferColors.append(barColor);
						}
						else
						{
							strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
							strBufferChangeCounts.append(","+changeCount.intValue());
							strBufferColors.append(","+barColor);
						}
						totalCount = totalCount + changeCount.intValue();
					}
					String barLabels = strBufferTestnames.toString();;
					String barValues = strBufferChangeCounts.toString();
					String barcolors = strBufferColors.toString();

					boolean flagEqualsOne = true;
					for (int i=1; i<aListCount.size(); i++)
					{
						Integer count_Value = (Integer)aListCount.get(i);
						if (count_Value.intValue() > 1)
						{
							flagEqualsOne = false;
							break;
						}
					}
					if (flagEqualsOne)
					{
						yAxisMaxValue = "5";
					}
					else
					{
						yAxisMaxValue = "0";
					}
					
					//Fusion Bar chart Data for component name(byDate) starts--Rekha
					HashMap mapChartAttributes = new HashMap();//map for chart attributes
					mapChartAttributes.put("bgcolor","FFFFFF");
					mapChartAttributes.put("yAxisName","Number of changes");
					mapChartAttributes.put("showToolTip","1");
					mapChartAttributes.put("showValues","1");
					mapChartAttributes.put("showBorder","0");
					mapChartAttributes.put("showShadow","0");
					mapChartAttributes.put("alpha","0");
					mapChartAttributes.put("canvasBgColor","F2F2F2");
					mapChartAttributes.put("canvasBgAlpha","60");
					mapChartAttributes.put("canvasBorderColor","000000");
					mapChartAttributes.put("canvasBorderThickness","1");
					mapChartAttributes.put("canvasBorderAlpha","30");
					mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
					mapChartAttributes.put("maxBarHeight","40");

					HashMap mapChartData = new HashMap();//map for chart data
					mapChartData.put("barLabels",barLabels);
					mapChartData.put("barValues",barValues);
					mapChartData.put("barColors",barcolors);
					HashMap mapProperties = new HashMap();//map for misc properties
					mapProperties.put("showColors","true");
					mapProperties.put("enableLinks","false");
					EcFusionChartBean chartbean = new EcFusionChartBean();
					String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
					//Fusion Bar Chart Data ends

					String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
					String maximumRange = ""+maxCount;

					String chartTitle = titleName;
					if (topNFlag)
					{
						titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "   " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//pdf
						chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + "&nbsp;(" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + "&nbsp;" + indexCount + ") : " + totalCount + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//chart
					}

					aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range="+URLEncoder.encode(maximumRange)+"&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(strBufferChangeCounts.toString())+"&barLabels="+EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

					EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
					egTableAttributes.setImageData(true);

					EgTable egTable = new EgTable();
					egTable.setModel(egTableModel);
					egTable.setAttributes(egTableAttributes);

					aListPdfData.add(egTable);

					reportAttributes.setSubTitle(subTitle);
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

													<table border="0" align="center" width="99%" class="body_text">
<%
					boolean flag = false;
					if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
					{
						flag = true;
					}
					if (flag)
					{
%>
														<!-- Bar2D chart starts-->
														<tr>
															<td colspan="2" align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
																<!---
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar3D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig3DContainer3<%=component%>" style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig3D3<%=component%>" ) )
																FusionCharts( "StackedBarConfig3D3<%=component%>").dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","StackedBarConfig3D3<%=component%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig3DContainer3<%=component%>");
																</script>
															</td>
														</tr>
<%
					}
					else
					{
%>
														<tr>
															<td colspan="2" align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
																<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=650&chartHeight=250" quality="high" width="90%" height="250" name="StackedBar2D"  wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig2DContainer3<%=component%>"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBar2D3<%=component%>" ) )
																FusionCharts( "StackedBarConfig2D3<%=component%>" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","StackedBarConfig2D3<%=component%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig2DContainer3<%=component%>");
																</script>
															</td>
														</tr>
														<!-- Bar2D chart ends-->
<%
					}
%>
													</table>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
				}

				ArrayList aListChangesDatewise = null;
				aListChangesDatewise = (ArrayList)tmap_changeConfigDetails.get("Change By Date");

				aListChangesDatewise = processChangeData.getChangeSummaryForDatewiseData(aListChangesDatewise,searchCompValue,searchTestValue,searchDescValue,userLanguage);

				if (requestHomePage)
				{
					//Code for restricting the data to the selected date
					aListChangesDatewise = processChangeData.getDataForSelectedDate(aListChangesDatewise,selectedDate,timeZone);
				}
				int aListChangesDatewiseSize = aListChangesDatewise.size();

				//For PDF
				EgTableAttributes egTableAttributes = new EgTableAttributes();
				ArrayList aListColumnNames = new ArrayList();
				ArrayList aListData = new ArrayList();
				aListTestNamesForCSV = new ArrayList();
				ArrayList userColumnNames = new ArrayList();
				ArrayList fieldWidths = new ArrayList();

				aListColumnNames.add("C0");
				if (!option1.equalsIgnoreCase(userOptions[0]))
				{
					aListColumnNames.add("C1");
				}
				aListColumnNames.add("C2");
				aListColumnNames.add("C3");
				aListColumnNames.add("C4");
				aListColumnNames.add("C5");
				aListColumnNames.add("C6");

				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date"));
				if (!option1.equalsIgnoreCase(userOptions[0]))
				{
					userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component"));
				}
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Information"));
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
				userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

				fieldWidths.add("0");
				if (option1.equalsIgnoreCase(userOptions[0]))
				{
					fieldWidths.add("97");
					fieldWidths.add("230");
					fieldWidths.add("93");
				}
				else
				{
					fieldWidths.add("66");
					fieldWidths.add("67");
					fieldWidths.add("200");
					fieldWidths.add("87");
				}
				fieldWidths.add("205");
				fieldWidths.add("205");

				//For PDF - Start
				for (int i=0;i<aListChangesDatewiseSize;i++)
				{
					ArrayList al = (ArrayList)aListChangesDatewise.get(i);

					String strDateTime = (String)al.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
					String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
					String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(displayDate+" "+strTime,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					String component = (String)al.get(1);
					String cname = component.substring(0,component.lastIndexOf(':'));
					if (cname.endsWith(":NULL"))
						cname = cname.substring(0,cname.lastIndexOf(':'));
					String ctype = component.substring(component.lastIndexOf(':')+1);
					String displayComponent = cname + ":" + mappingInfo.getComponentTypeDescription(ctype);

					String testname = (String)al.get(2);
					String info = (String)al.get(3);
					Object measure_obj = al.get(4);
					Object previous_obj = al.get(5);
					Object present_obj = al.get(6);
					String tempDisplayDate = "";
					if (startDateAndTime.indexOf(",") != -1)
					{
						tempDisplayDate = StringUtils.replace(startDateAndTime,",","");
					}
					else
					{
						tempDisplayDate = startDateAndTime;
					}
					aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date") + " : " + tempDisplayDate);
					aListTestNamesForCSV.add(testname);
					if (!option1.equalsIgnoreCase(userOptions[0]))
					{
						aListData.add(displayComponent);
						aListTestNamesForCSV.add(testname);
					}
					aListData.add(mappingInfo.getTestDescription(testname));
					aListTestNamesForCSV.add(testname);

					boolean isDynamicMeasureTest = false;
					int idx_M = info.indexOf("~M~");
					if (idx_M != -1)
					{
						isDynamicMeasureTest = true;
					}

					ArrayList aListInfoHeadings = null;
					if (isDynamicMeasureTest)
					{
						aListInfoHeadings = new ArrayList();
						String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
						if (infoHeadings != null && infoHeadings.length() > 0)
						{
							StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
							while (strTokensTemp.hasMoreTokens())
							{
								String str_temp = strTokensTemp.nextToken();
								aListInfoHeadings.add(str_temp);
							}
						}
					}

					boolean newInfoFlag = false;
					if (measure_obj instanceof ArrayList)
					{
						newInfoFlag = true;
					}

					if (!isDynamicMeasureTest)
					{
						if (info.length() == 1)
						{
							aListData.add("N/A");
							aListTestNamesForCSV.add(testname);
						}
						else
						{
							if (newInfoFlag)
							{
								aListData.add(ecUtils.getInfoForDisplay(info)+" [NEW]");
							}
							else
							{
								aListData.add(ecUtils.getInfoForDisplay(info));
							}
							aListTestNamesForCSV.add(testname);
						}
					}
					else
					{
						if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
						{
							aListData.add("N/A");
							aListTestNamesForCSV.add(testname);
						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strDataForPDF = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
								}
								else
								{
									strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
								}
							}

							if (newInfoFlag)
							{
								aListData.add(strDataForPDF + " [NEW]");
							}
							else
							{
								aListData.add(strDataForPDF);
							}
							aListTestNamesForCSV.add(testname);
						}
					}

					if (measure_obj instanceof String)
					{
						String previous_value = (String)previous_obj;
						String present_value = (String)present_obj;

						boolean newMeasureFlag = false;
						boolean deletedMeasureFlag = false;
						if (isDynamicMeasureTest && !newInfoFlag)
						{
							if (previous_value.equalsIgnoreCase("##NEW##") || 
								previous_value.equalsIgnoreCase("##NEW-INFO##") || 
								previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								newMeasureFlag = true;
							}
							else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								deletedMeasureFlag = true;
							}
						}

						if (newMeasureFlag)
						{
							aListData.add((String)measure_obj + " [NEW]");
						}
						else if (deletedMeasureFlag)
						{
							aListData.add((String)measure_obj + " [REMOVED]");
						}
						else
						{
							aListData.add((String)measure_obj);
						}
						aListTestNamesForCSV.add(testname);

						if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
						{
							previous_value = "[N/PV]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							previous_value = "[N/A]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}
						aListData.add(previous_value);
						aListTestNamesForCSV.add(testname);

						if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							present_value = "[N/A]";
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}
						aListData.add(present_value);
						aListTestNamesForCSV.add(testname);
					}
					else
					{
						ArrayList mn = (ArrayList)measure_obj;
						ArrayList prev = (ArrayList)previous_obj;
						ArrayList pres = (ArrayList)present_obj;
						for (int z=0;z<mn.size();z++)
						{
							String measure = (String)mn.get(z);
							String prevValue = (String)prev.get(z);
							String presValue = (String)pres.get(z);

							if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
							{
								prevValue = "[N/PV]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								prevValue = "[N/A]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								presValue = "[N/A]";
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (z == 0)
							{
								aListData.add(measure);
								aListData.add(prevValue);
								aListData.add(presValue);

								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
							}
							else
							{
								aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Date") + " : " + tempDisplayDate);
								aListTestNamesForCSV.add(testname);
								if (!option1.equalsIgnoreCase(userOptions[0]))
								{
									aListData.add(" ");
									aListTestNamesForCSV.add(testname);
								}
								aListData.add(" ");
								aListData.add(" ");
								aListData.add(measure);
								aListData.add(prevValue);
								aListData.add(presValue);

								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
								aListTestNamesForCSV.add(testname);
							}
						}
					}
				}
				//For PDF - End

				EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
				egTableAttributes.setColumnNames(userColumnNames);
				egTableAttributes.setDataGrouping(true);
				egTableAttributes.setDataGroupingField(0);
				egTableAttributes.setFieldWidths(fieldWidths);

				EgTable egTable = new EgTable();
				egTable.setModel(egTableModel);
				egTable.setAttributes(egTableAttributes);

				aListPdfData.add(egTable);

				egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes")+" : "+aListChangesDatewiseSize);
%>
				<pg:indexer
						url="../servlet/com.eg.EcConfigurationServlet"
						index="<%=index%>"
						items="<%=aListChangesDatewiseSize%>"
						isOffset="false"
						maxPageItems="<%=maxPageItems%>"
						maxIndexPages="<%=maxIndexPages%>"
						export="pageOffset,currentPageNumber=pageNumber"
						scope="request">

					<!-- Parameters for the request query string -->
					<pg:param name="ec_rtype" value="Change" />
					<pg:param name="ec_option1" value="<%=option1%>" />
					<pg:param name="ec_option2" value='<%=EgURLEncoder.encode((option2==null?"":option2),"UTF-8")%>' />
					<pg:param name="ec_changetype" value="<%=s_changetype%>" />
					<pg:param name="ec_timeline" value="<%=s_timeline%>" />
					<pg:param name="ec_prevtimeline" value="<%=s_prevtimeline%>" />
					<pg:param name="ec_stdate_h" value="<%=s_stdate%>" />
					<pg:param name="ec_sthr_h" value="<%=s_sthr%>" />
					<pg:param name="ec_startmin_h" value="<%=s_startmin%>" />
					<pg:param name="ec_enddate_h" value="<%=s_enddate%>" />
					<pg:param name="ec_endhr_h" value="<%=s_endhr%>" />
					<pg:param name="ec_endmin_h" value="<%=s_endmin%>" />
					<pg:param name="request_from" value="<%=request_from%>" />
					<pg:param name="selectDate" value="<%=selectedDate%>" />
					<pg:param name="timeZone" value="<%=timeZone%>" />
					<pg:param name="ec_test" value="<%=selectedTests%>" />
					<pg:param name="ec_maxpageitems" value="<%=s_maxpageitems%>" />
					<pg:param name="ec_viewchange" value="<%=s_viewchange%>" />
					<pg:param name="searchCompValue" value="<%=searchCompValue%>" />
					<pg:param name="searchTestValue" value="<%=searchTestValue%>" />
					<pg:param name="searchDescValue" value="<%=searchDescValue%>" />
					<pg:param name="request_start" value="<%=request_start%>" />
					<pg:param name="ec_criteria" value="<%=ec_criteria%>" />
					<pg:param name="ec_userOption" value='<%=((ec_userOption != null)?EgURLEncoder.encode(ec_userOption,"UTF-8"):"")%>' />
					<pg:param name="ec_userOptionPrevious" value='<%=((ec_userOptionPrevious != null)?EgURLEncoder.encode(ec_userOptionPrevious,"UTF-8"):"")%>' />
					<pg:param name="ec_criteriaPrevious" value="<%=ec_criteriaPrevious%>" />

													<table border="0" cellspacing="0" cellpadding="0" align="center" width="99%" id="bottomtable" class="body_text">
<%
				int start = pageOffset.intValue();
%>
														<tr>
															<td width="100%">
																<table width="100%" cellspacing="0" cellpadding="0" border="0">
																	<tr>
																		<td id="tab_dark_eg" height="20" style="text-align:left;font-size:9pt;font-family:Verdana" nowrap>&nbsp;<%=start+1%>&nbsp;<egui:intnl text="configmgmt.changes.detailed.to" />&nbsp;<%=Math.min(start+maxPageItems,aListChangesDatewiseSize)%>&nbsp;<egui:intnl text="configmgmt.changes.detailed.of" />&nbsp;<%=aListChangesDatewiseSize%>&nbsp;<egui:intnl text="configmgmt.changes.detailed.changes found" /> &nbsp;</td>
																	</tr>
																</table>
															</td>
														</tr>
<%
				selectedInformations = request.getParameter("ec_test");
				boolean heading_flag = false;
				for(int i=0; i<aListChangesDatewiseSize; i++)
				{
					ArrayList al = (ArrayList)aListChangesDatewise.get(i);
					if (!heading_flag)
					{
%>
														<tr>
															<td>
																<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text" height="100%">
																	<tr>
																		<td class="table_header" id="white_content" height="20" width="5%">
																			<egui:intnl text="configmgmt.changes.detailed.Change Date" />
																		</td>
<%
						if (!option1.equalsIgnoreCase(userOptions[0]))
						{
%>
																		<td class="table_header" id="white_content" height="20" width="20%">
																			&nbsp;<egui:intnl text="configmgmt.changes.detailed.Component" />
																		</td>

<%
						}
%>
																		<td class="table_header" id="white_content" height="20" width="15%">
																			&nbsp;<egui:intnl text="configmgmt.changes.detailed.Information" />
																		</td>
																		<td class="table_header" id="white_content" height="20" width="20%">
																			&nbsp;<egui:intnl text="configmgmt.changes.detailed.Descriptor" />
																		</td>
																		<td valign="top" height="100%" width="60%">
																			<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text" height="100%">
																				<tr>
																					<td class="table_header" id="white_content" height="20" width="33%">
																					&nbsp;<egui:intnl text="configmgmt.changes.detailed.Measure" />
																					</td>
																					<td class="table_header" id="white_content" height="20" width="33%">
																					&nbsp;<egui:intnl text="configmgmt.changes.detailed.Previous Value" />
																					</td>
																					<td class="table_header" id="white_content" height="20" width="33%">
																					&nbsp;<egui:intnl text="configmgmt.changes.detailed.Present Value" />
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
<%
						heading_flag = true;
					}

					String strDateTime = (String)al.get(0);
					String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
					String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
					String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

					/* Added by Prakash.K starts */
					timeZoneConverter = new EgTimeZoneConverter(displayDate+" "+strTime,user);
					startDateAndTime = timeZoneConverter.getDateTime();
					/* Added by Prakash.K ends */

					String component = (String)al.get(1);
					String cname = component.substring(0,component.lastIndexOf(':'));
					if (cname.endsWith(":NULL"))
						cname = cname.substring(0,cname.lastIndexOf(':'));
					String ctype = component.substring(component.lastIndexOf(':')+1);
					String displayComponent = cname + ":" + mappingInfo.getComponentTypeDescription(ctype);

					String testname = (String)al.get(2);
					String info = (String)al.get(3);
					Object measure_obj = al.get(4);
					Object previous_obj = al.get(5);
					Object present_obj = al.get(6);

					String measuresTemp = "";
					String selXMLTypeTest = testname;

					EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
					String[] testMeasures = thresholdInfo.getMeasurementsForTest(selXMLTypeTest);
					ArrayList measuresListTemp = new ArrayList();
					if (testMeasures != null && testMeasures.length > 0)
					{
						measuresListTemp.addAll(Arrays.asList(testMeasures));
					}
					for(int h=0;h< measuresListTemp.size();h++)
					{
						measuresTemp = (String)measuresListTemp.get(h);
					}

					HashMap testinDiff = (HashMap)treeValues.get(testname);
					boolean isMeasure = false;
					int lengthinMeasureInt = 0;
					String testDescr = mappingInfo.getTestDescription(testname);
					String lengthinDiff = "";
%>
								<pg:item>
																	<tr>
																		<td id="<%=cell_bg1Val%>" valign="top" wrap width="5%">
																			<%=startDateAndTime%>
																		</td>
<%
					if (!option1.equalsIgnoreCase(userOptions[0]))
					{
%>
																		<td id="<%=cell_bg1Val%>" valign="top" wrap width="20%">
																			<%=displayComponent%>
																		</td>
<%
					}
%>
																		<td id="<%=cell_bg1Val%>" valign="top" wrap width="15%">
																			<%=mappingInfo.getTestDescription(testname)%>
																		</td>
<%
					boolean isDynamicMeasureTest = false;
					int idx_M = info.indexOf("~M~");
					if (idx_M != -1)
					{
						isDynamicMeasureTest = true;
					}

					ArrayList aListInfoHeadings = null;
					if (isDynamicMeasureTest)
					{
						aListInfoHeadings = new ArrayList();
						String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",testname);
						if (infoHeadings != null && infoHeadings.length() > 0)
						{
							StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
							while (strTokensTemp.hasMoreTokens())
							{
								String str_temp = strTokensTemp.nextToken();
								aListInfoHeadings.add(str_temp);
							}
						}
					}

					boolean newInfoFlag = false;
					if (measure_obj instanceof ArrayList)
					{
						newInfoFlag = true;
					}
%>
																		<td width="20%" id="<%=cell_bg1Val%>" valign="top">
<%
					if (!isDynamicMeasureTest)
					{
						info = ecUtils.getInfoForDisplay(info);
						if (!info.equals("+"))
						{
							if (info.length()<=25)
							{
								out.println(info);
							}
							else
							{
								ArrayList aListStrValues = breakString(info,25);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									out.println(str_value+"<br>");
								}
							}
						}
						else
						{
							out.println("N/A");
						}
					}
					else
					{
						if (ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON) || ecUtils.getInfoForDisplay(info).equals(EgConfigConstants.CF_EMPTY))
						{
							out.println("N/A");
						}
						else
						{
							ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(info),"~M~");
							int aListTokensSize = aListTokens.size();
							String strData = "";
							for (int x=0;x<aListTokensSize;x++)
							{
								String infoHeading = (String)aListInfoHeadings.get(x);
								String strTemp = (String)aListTokens.get(x);
								if (x == aListTokensSize-1)
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
								}
								else
								{
									strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
								}
							}
							out.println(strData);
						}
					}

					if (newInfoFlag)
					{
%>
						<img src="/final/config/images/new_info.gif" border="0">
<%
					}
%>
																		&nbsp;</td>
<%
					if (measure_obj instanceof String)
					{
						String measureStr = (String)measure_obj;
						if (testinDiff != null)
						{
							isMeasure = testinDiff.containsKey(measure_obj);
							if (isMeasure)
							{
								lengthinDiff = (String)testinDiff.get(measure_obj);
								lengthinMeasureInt = Integer.parseInt(lengthinDiff);
							}
						}
%>
																		<td valign="top" width="60%" height="100%">
																			<table border="0" cellspacing="0" cellpadding="0" align="center" width="100%" class="body_text" height="100%">
																				<tr>
<%
						String previous_value = (String)previous_obj;
						String present_value = (String)present_obj;

						if (!previous_value.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(previous_value.getBytes()))
							{
								previous_value = EcUtils.printSkippedBomString(previous_value.getBytes());
							}
						}
						if (!present_value.startsWith("<?configuration?>"))
						{
							if (EcUtils.isUTF8(present_value.getBytes()))
							{
								present_value = EcUtils.printSkippedBomString(present_value.getBytes());
							}
						}

						boolean newMeasureFlag = false;
						boolean deletedMeasureFlag = false;
						if (isDynamicMeasureTest && !newInfoFlag)
						{
							if (previous_value.equalsIgnoreCase("##NEW##") || 
								previous_value.equalsIgnoreCase("##NEW-INFO##") || 
								previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								newMeasureFlag = true;
							}
							else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								deletedMeasureFlag = true;
							}
						}

						if (newMeasureFlag)
						{
%>
																		<td width="33%" id="<%=cell_bg1Val%>" valign="top" wrap><%=measure_obj%><br><img src="/final/config/images/new_info.png" border="0"></td>
<%
						}
						else if (deletedMeasureFlag)
						{
%>
																		<td width="33%" id="<%=cell_bg1Val%>" valign="top" wrap><%=measure_obj%><br><img src="/final/config/images/removed_info.png" border="0"></td>
<%
						}
						else
						{
%>
																		<td width="33%" id="<%=cell_bg1Val%>" valign="top" wrap><%=measure_obj%></td>
<%
						}

						if (previous_value.equalsIgnoreCase("##NEW##") || previous_value.equalsIgnoreCase("##NEW-INFO##"))
						{
							previous_value = "[N/PV]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							previous_value = "[N/A]";
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (previous_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							previous_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (previous_value.startsWith("<?configuration?>"))
						{
							//previous_value = StringUtils.replace(previous_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																						<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=s_changetype%>&ec_component=<%=component%>&ec_comptype=<%=URLEncoder.encode(ctype)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteriaPrevious%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOptionPrevious%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_test=<%=selXMLTypeTest%>&changeConfigSelTest=<%=selectedInformations%>&ec_viewchange=<%=s_viewchange%>&request_from=Change&fromField=from&old_comptype=<%=ctype%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;</td>
<%
						}
						else
						{
							if (previous_value.length()<=20)
							{
								previous_value = EcUtils.replaceTags(previous_value);
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top"><%=previous_value%>&nbsp;</td>
<%
							}
							else
							{
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top">
<%
								ArrayList aListStrValues = breakString(previous_value,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}
%>
																						</td>
<%
							}
						}

						if (present_value.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
						{
							present_value = "[N/A]";
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_YES))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.Yes");
						}
						else if (present_value.equalsIgnoreCase(EgConfigConstants.CF_NO))
						{
							present_value = mappingInfo.getTextDescription("configmgmt.common.No");
						}

						if (present_value.startsWith("<?configuration?>"))
						{
							//present_value = StringUtils.replace(present_value,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																					<td width="33%" id="cell_bg1" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=s_changetype%>&ec_component=<%=component%>&ec_comptype=<%=URLEncoder.encode(ctype)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteriaPrevious%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOptionPrevious%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_test=<%=selXMLTypeTest%>&changeConfigSelTest=<%=selectedInformations%>&ec_viewchange=<%=s_viewchange%>&request_from=Change&fromField=from&old_comptype=<%=ctype%>&ec_measure=<%=measuresTemp%>&descriptor=<%=info%>&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;
<%
								if (!previous_value.equals("-") && 
									!previous_value.equalsIgnoreCase("[N/PV]") && 
									!previous_value.equalsIgnoreCase("[N/A]") && 
									!present_value.equals("-") && 
									!present_value.equalsIgnoreCase("[N/A]"))
								{
									if ((present_value.length() > lengthinMeasureInt) && isMeasure)
									{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
									}
								}
%>
																					</td>
<%
						}
						else
						{
							if (present_value.length()<=20)
							{
								present_value = EcUtils.replaceTags(present_value);
%>
																				<td width="33%" id="<%=cell_bg1Val%>" valign="top"><%=present_value%>&nbsp;
<%
								if (!previous_value.equals("-") && 
									!previous_value.equalsIgnoreCase("[N/PV]") && 
									!previous_value.equalsIgnoreCase("[N/A]") && 
									!present_value.equals("-") && 
									!present_value.equalsIgnoreCase("[N/A]"))
								{
									if ((present_value.length() > lengthinMeasureInt) && isMeasure)
									{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
									}
								}
%>
																					</td>
<%
							}
							else
							{
%>
																				<td width="33%" id="<%=cell_bg1Val%>" valign="top">
<%
								ArrayList aListStrValues = breakString(present_value,18);
								for (int r=0;r<aListStrValues.size();r++)
								{
									String str_value = (String)aListStrValues.get(r);
									str_value = EcUtils.replaceTags(str_value);
									out.println(str_value+"<br>");
								}

								if (!previous_value.equals("-") && 
									!previous_value.equalsIgnoreCase("[N/PV]") && 
									!previous_value.equalsIgnoreCase("[N/A]") && 
									!present_value.equals("-") && 
									!present_value.equalsIgnoreCase("[N/A]"))
								{
									if ((present_value.length() > lengthinMeasureInt) && isMeasure)
									{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_value,"UTF-8")%>','<%=EgURLEncoder.encode(present_value,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>','<%=EgURLEncoder.encode(measureStr,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
									}
								}
%>
																					</td>
<%
							}
						}
%>
																				</tr>
																			</table>
																		</td>
<%
					}
					else
					{
						ArrayList mn = (ArrayList)measure_obj;
						ArrayList prev = (ArrayList)previous_obj;
						ArrayList pres = (ArrayList)present_obj;
%>
																		<td valign="top" width="60%" height="100%">
																			<table border="0" cellspacing="0" cellpadding="0" height="100%" align="center" width="100%" class="body_text">
<%
						for (int z=0;z<mn.size();z++)
						{
							String measure = (String)mn.get(z);
							String prevValue = (String)prev.get(z);
							String presValue = (String)pres.get(z);

							if (!prevValue.startsWith("<?configuration?>"))
							{
								if (EcUtils.isUTF8(prevValue.getBytes()))
								{
									prevValue = EcUtils.printSkippedBomString(prevValue.getBytes());
								}
							}
							if (!presValue.startsWith("<?configuration?>"))
							{
								if (EcUtils.isUTF8(presValue.getBytes()))
								{
									presValue = EcUtils.printSkippedBomString(presValue.getBytes());
								}
							}

							if (testinDiff != null)
							{
								isMeasure = testinDiff.containsKey(measure);
								if (isMeasure)
								{
									lengthinDiff = (String)testinDiff.get(measure);
									lengthinMeasureInt = Integer.parseInt(lengthinDiff);
								}
							}
%>
																				<tr>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top"><%=measure%></td>
<%
							if (prevValue.equalsIgnoreCase("##NEW##") || prevValue.equalsIgnoreCase("##NEW-INFO##"))
							{
								prevValue = "[N/PV]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								prevValue = "[N/A]";
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (prevValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								prevValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (prevValue.startsWith("<?configuration?>"))
							{
								prevValue = StringUtils.replace(prevValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																						<td width="33%" id="cell_bg1" valign="top"><%=prevValue%>&nbsp;</td>
<%
							}
							else
							{
								if (prevValue.length()<=20)
								{
									prevValue = EcUtils.replaceTags(prevValue);
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top"><%=prevValue%>&nbsp;</td>
<%
								}
								else
								{
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top">
<%
									ArrayList aListStrValues = breakString(prevValue,18);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.println(str_value+"<br>");
									}
%>
																						</td>
<%
								}
							}

							if (presValue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
							{
								presValue = "[N/A]";
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_YES))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.Yes");
							}
							else if (presValue.equalsIgnoreCase(EgConfigConstants.CF_NO))
							{
								presValue = mappingInfo.getTextDescription("configmgmt.common.No");
							}

							if (presValue.startsWith("<?configuration?>"))
							{
								presValue = StringUtils.replace(presValue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																						<td width="33%" id="cell_bg1" valign="top">
																						<%=presValue%>&nbsp;
<%
									if (!prevValue.equals("-") && 
										!prevValue.equalsIgnoreCase("[N/PV]") && 
										!prevValue.equalsIgnoreCase("[N/A]") && 
										!presValue.equals("-") && 
										!presValue.equalsIgnoreCase("[N/A]"))
									{
										if ((presValue.length() > lengthinMeasureInt) && isMeasure)
										{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
										}
									}
%>
																						</td>
<%
							}
							else
							{
								if (presValue.length()<=20)
								{
									presValue = EcUtils.replaceTags(presValue);
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top">
																						<%=presValue%>&nbsp;
<%
									if (!prevValue.equals("-") && 
										!prevValue.equalsIgnoreCase("[N/PV]") && 
										!prevValue.equalsIgnoreCase("[N/A]") && 
										!presValue.equals("-") && 
										!presValue.equalsIgnoreCase("[N/A]"))
									{
										if ((presValue.length() > lengthinMeasureInt) && isMeasure)
										{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
										}
									}
%>
																						</td>
<%
								}
								else
								{
%>
																					<td width="33%" id="<%=cell_bg1Val%>" valign="top">
<%
									ArrayList aListStrValues = breakString(presValue,18);
									for (int r=0;r<aListStrValues.size();r++)
									{
										String str_value = (String)aListStrValues.get(r);
										str_value = EcUtils.replaceTags(str_value);
										out.println(str_value+"<br>");
									}

									if (!prevValue.equals("-") && 
										!prevValue.equalsIgnoreCase("[N/PV]") && 
										!prevValue.equalsIgnoreCase("[N/A]") && 
										!presValue.equals("-") && 
										!presValue.equalsIgnoreCase("[N/A]"))
									{
										if ((presValue.length() > lengthinMeasureInt) && isMeasure)
										{
%>
										<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(prevValue,"UTF-8")%>','<%=EgURLEncoder.encode(presValue,"UTF-8")%>','<%=EgURLEncoder.encode(displayComponent,"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(info,"UTF-8")%>','<%=EgURLEncoder.encode(measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
										}
									}
%>
																						</td>
<%
								}
							}
%>
																				</tr>
<%
						}
%>
																			</table>
																		</td>
<%
					}
%>
																	</tr>
								</pg:item>
<%
				}
%>
																</table>
															</td>
														</tr>
													</table>
<%
				int fCount =0;
				if (aListChangesDatewiseSize > maxPageItems)
				{
%>
													<table align="center" width="99%" cellspacing="0" cellpadding="0"  border="0" id="bottomtable" class="body_text" style="border-top-width:0px">
													<pg:index>
														<tr>
															<td width="100%" id="cell_header">
																<table cellspacing="0" width="100%" cellpadding="0" style="table-layout:collapse" width="100%" border="0">
																	<tr>
																		<td style="width:100px" nowrap="nowrap">&nbsp;&nbsp;<egui:intnl text="configmgmt.changes.detailed.Go to page" /> # :&nbsp;</td>
																		<td nowrap style="width:25px"><input type="text" name="pageno" width="6" size="3" style="width: 35px; text-align: center;"></td>
																		<td nowrap style="width:30px;padding-left:4px"><img src="/final/config/images/gray/arrow_1.gif" name="gotopage" onClick="onGoToPage(<%=maxPageItems%>, <%=aListChangesDatewiseSize%>)" alt="<egui:intnl text='configmgmt.common.Go' />" title="<egui:intnl text='configmgmt.common.Go' />" id="eg_input" class="mouse"></td>
																		<td width="15%">&nbsp;</td>
<%
					if (!(String.valueOf(currentPageNumber)).equals("1") && fCount == 0)
					{
						fCount++;
%>
																		<td align="left" nowrap="nowrap" width="70px"><pg:first export="firstPageUrl=pageUrl"><a href="javascript:void(0)" id="eg_monlink" onClick='window.location.href="<%=firstPageUrl%>"' /><img src="/final/config/images/back-arrow.gif" border="0"><img src="/final/config/images/back-arrow.gif" border="0">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.FIRST"/></b></a></pg:first></td>
<%
					}
%>
																		<td align="center" nowrap width="90px"><pg:prev export="prevPageUrl=pageUrl"><a href="javascript:void(0)" id="eg_monlink" onClick='window.location.href="<%=prevPageUrl%>"' /><img src="/final/config/images/back-arrow.gif" border="0">&nbsp;<b><egui:intnl text="configmgmt.changes.detailed.PREV"/></b></a></pg:prev></td>
																		<td align="center" width="60%"><pg:pages>
<%
					if (pageNumber.equals(currentPageNumber))
					{
%>
						<span id="page_no"><%=pageNumber%></span>
<%
					}
					else
					{
%>
						&nbsp;<a href="<%=pageUrl%>&fromLink=true" id="eg_alarmlink"><%=pageNumber%></a>
<%
					}
%>
																		</pg:pages>&nbsp;&nbsp;</td>
																		<td align="center" nowrap width="80px"><pg:next export="nextPageUrl=pageUrl"><a href="javascript:void(0)" id="eg_monlink" onClick='window.location.href="<%=nextPageUrl%>"' /><b><egui:intnl text="configmgmt.changes.detailed.NEXT" /></b>&nbsp;<img src="/final/config/images/forward-arrow.gif" border="0"></a></pg:next></td>
<%
					if (Math.min(start+maxPageItems,aListChangesDatewiseSize) < aListChangesDatewiseSize)
					{
%>
																		<td align="center" nowrap="nowrap" width="80px"><pg:last export="lastPageUrl=pageUrl"><a href="javascript:void(0)" id="eg_monlink" onClick='window.location.href="<%=lastPageUrl%>"' /><b><egui:intnl text="configmgmt.changes.detailed.LAST"/></b>&nbsp;<img src="/final/config/images/forward-arrow.gif" border="0"><img src="/final/config/images/forward-arrow.gif" border="0"></a></pg:last></td>
<%
					}
%>
																	</tr>
																</table>
															</td>
														</tr>
														</pg:index>
													</table>
<%
				}
%>
											<br>
				</pg:indexer>
<%
			}
			else
			{
				//Display changes information-wise(testname)
				//if (option1.equalsIgnoreCase(userOptions[0]))
				//{
					selectedInformations = request.getParameter("ec_test");
					String subTitle = ""; //For PDF
					for (int g=0; g<aListComponents.size(); g++)
					{
						String key_component = (String)aListComponents.get(g);
						TreeMap tmap_ComponentData = (TreeMap)tmap_changeConfigDetails.get(key_component);

						String component = key_component.substring(0,key_component.lastIndexOf(':'));
						if (component.endsWith(":NULL"))
							component = component.substring(0,component.lastIndexOf(':'));

						String comp_type = key_component.substring(key_component.lastIndexOf(':')+1);
						if (comp_type.indexOf("@") != -1)
						{
							comp_type = comp_type.substring(0,comp_type.indexOf("@"));
						}
						if(!requestFromMonitor)
						{
						subTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name") + " : " + component + "\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type") + " : " + mappingInfo.getComponentTypeDescription(comp_type) + "\n";
%>
													<table border="0" align="center" width="100%" class="bgdark">
														<tr>
															<td align="left" id="whitefont" height="20">&nbsp;<egui:intnl text="configmgmt.changes.detailed.Component Name" /> : <%=component%> [<%=mappingInfo.getComponentTypeDescription(comp_type)%>]</td>
															<td align="right" id="whitefont">
<%
						if (s_timeline != null && !s_timeline.equalsIgnoreCase("Any"))
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(tempStartDateTime,user);
							startDateAndTime = timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(tempEndDateTime,user);
							endDateAndTime = timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */

							subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " +  startDateAndTime + " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
							<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
						}
						else
						{
							/* Added by Prakash.K starts */
							timeZoneConverter = new EgTimeZoneConverter(tempStartDate + " " + sHour + ":" + sMinute,user);
							startDateAndTime = timeZoneConverter.getDateTime();
							timeZoneConverter = new EgTimeZoneConverter(tempEndDate + " " + eHour + ":" + eMinute,user);
							endDateAndTime = timeZoneConverter.getDateTime();
							/* Added by Prakash.K ends */

							subTitle = subTitle + mappingInfo.getTextDescription("configmgmt.changes.detailed."+displayNameForChangeType+" changes") + " " + mappingInfo.getTextDescription("configmgmt.common.between") + " " + startDateAndTime+ " " + mappingInfo.getTextDescription("configmgmt.common.and") + " " + endDateAndTime;
%>
							<b><egui:intnl text='<%="configmgmt.changes.detailed."+displayNameForChangeType+" changes"%>' />&nbsp;<egui:intnl text="configmgmt.common.between" />&nbsp;<%=startDateAndTime%>&nbsp;<egui:intnl text="configmgmt.common.and" />&nbsp;<%=endDateAndTime%></b>
<%
						}
%>
															&nbsp;</td>
														</tr>
													</table>
<%
						//For each component - Heading purpose
						if (option1.equalsIgnoreCase(userOptions[1]) || option1.equalsIgnoreCase(userOptions[2]))
						{
							EgTableAttributes egTableAttributes = new EgTableAttributes();
							ArrayList aListColumnNames = new ArrayList();
							ArrayList aListData = new ArrayList();
							ArrayList userColumnNames = new ArrayList();
							ArrayList fieldWidths = new ArrayList();

							if (option1.equalsIgnoreCase(userOptions[1]))
							{
								aListColumnNames.add("C0");
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name"));
								fieldWidths.add("520");
								egTableAttributes.setStartX(300);
								aListData.add(component);
							}
							else
							{
								aListColumnNames.add("C0");
								aListColumnNames.add("C1");
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Name"));
								userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Component Type"));
								fieldWidths.add("360");
								fieldWidths.add("360");
								egTableAttributes.setStartX(100);
								aListData.add(component);
								aListData.add(mappingInfo.getComponentTypeDescription(key_component.substring(key_component.lastIndexOf(':')+1)));
							}

							EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
							egTableAttributes.setColumnNames(userColumnNames);
							egTableAttributes.setFieldWidths(fieldWidths);
							egTableAttributes.setTitle(mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes in"));

							EgTable egTable = new EgTable();
							egTable.setModel(egTableModel);
							egTable.setAttributes(egTableAttributes);

							aListPdfData.add(egTable);
						}
						}

						//For PDF
						EgTableAttributes egTableAttributes = new EgTableAttributes();
						ArrayList aListColumnNames = new ArrayList();
						ArrayList aListData = new ArrayList();
						ArrayList userColumnNames = new ArrayList();
						ArrayList fieldWidths = new ArrayList();

						aListColumnNames.add("C0");

						TreeMap tmapChanges = processChangeData.getComponentSummary(key_component,tmap_changeConfigDetails,selectedDate,timeZone);
						Iterator changeCountKeys = tmapChanges.keySet().iterator();
						int totalCount=0;
						int maxCount=0;
						ArrayList aList = new ArrayList();
						while (changeCountKeys.hasNext())
						{
							Integer changeCount = (Integer)changeCountKeys.next();
							aList.add(changeCount);
							maxCount=Math.max(maxCount,changeCount.intValue());
						}
						Collections.reverse(aList);

						StringBuffer strBufferTestnames = new StringBuffer();
						StringBuffer strBufferChangeCounts = new StringBuffer();
						StringBuffer strBufferColors = new StringBuffer();
						ArrayList aListTestnames = new ArrayList();
						ArrayList aListChangeCount = new ArrayList();
						String yAxisMaxValue = " ";
						ArrayList aListCount = new ArrayList();

						int i_totalChangeCount = 0;
						for (int a=0; a<aList.size(); a++)
						{
							Integer changeCount = (Integer)aList.get(a);
							ArrayList aListTemp = (ArrayList)tmapChanges.get(changeCount);

							aListTestnames.addAll(aListTemp);

							for (int i=0; i<aListTemp.size(); i++)
							{
								aListChangeCount.add(changeCount);
								i_totalChangeCount = i_totalChangeCount + changeCount.intValue();
							}
						}

						//Build graph for TopN items
						boolean topNFlag = false;
						int indexCount = 0;
						if (aListTestnames.size() < topN)
						{
							indexCount = aListTestnames.size();
						}
						else
						{
							indexCount = topN;
							topNFlag = true;
						}

						for (int b=0; b<indexCount; b++)
						{
							String testname = (String)aListTestnames.get(b);
							Integer changeCount = (Integer)aListChangeCount.get(b);
							if (!aListCount.contains(changeCount))
							{
								aListCount.add(changeCount);
							}
							if (b == 0)
							{
								strBufferTestnames.append(mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(changeCount.intValue());
								strBufferColors.append(barColor);
							}
							else
							{
								strBufferTestnames.append(","+mappingInfo.getTestDescription(testname));
								strBufferChangeCounts.append(","+changeCount.intValue());
								strBufferColors.append(","+barColor);
							}
							totalCount = totalCount + changeCount.intValue();
						}

						String barLabels = strBufferTestnames.toString();
						String barValues = strBufferChangeCounts.toString();
						String barColors = strBufferColors.toString();
						boolean flagEqualsOne = true;
						for (int i=1; i<aListCount.size(); i++)
						{
							Integer count_Value = (Integer)aListCount.get(i);
							if (count_Value.intValue() > 1)
							{
								flagEqualsOne = false;
								break;
							}
						}
						if (flagEqualsOne)
						{
							yAxisMaxValue = "5";
						}
						else
						{
							yAxisMaxValue = "0";
						}
						
						//Fusion Bar chart Data for component name(byInformation) starts--Rekha
						HashMap mapChartAttributes = new HashMap();//map for chart attributes
						mapChartAttributes.put("bgcolor","FFFFFF");
						mapChartAttributes.put("yAxisName","Number of changes");
						mapChartAttributes.put("showToolTip","1");
						mapChartAttributes.put("showValues","1");
						mapChartAttributes.put("showBorder","0");
						mapChartAttributes.put("showShadow","0");
						mapChartAttributes.put("alpha","0");
						mapChartAttributes.put("canvasBgColor","F2F2F2");
						mapChartAttributes.put("canvasBgAlpha","60");
						mapChartAttributes.put("canvasBorderColor","000000");
						mapChartAttributes.put("canvasBorderThickness","1");
						mapChartAttributes.put("canvasBorderAlpha","30");
						mapChartAttributes.put("yAxisMaxValue",yAxisMaxValue);
						mapChartAttributes.put("maxBarHeight","40");

						HashMap mapChartData = new HashMap();//map for chart data
						mapChartData.put("barLabels",barLabels);
						mapChartData.put("barValues",barValues);
						mapChartData.put("barColors",barColors);
						HashMap mapProperties = new HashMap();//map for misc properties
						mapProperties.put("showColors","true");
						mapProperties.put("enableLinks","false");
						EcFusionChartBean chartbean = new EcFusionChartBean();
						String xmlString = chartbean.getXMLDataForStackedBarChart(mapChartAttributes,mapChartData,mapProperties);
						//Fusion Bar Chart Data ends

						String titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Total Changes") + " : " + i_totalChangeCount;
						String maximumRange = ""+maxCount;

						String chartTitle = titleName;
						if (topNFlag)
						{
							titleName = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "   " + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + ") : " + totalCount + "\\n" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//pdf
							chartTitle = mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + " " + indexCount + " " + mappingInfo.getTextDescription("configmgmt.changes.detailed.testnames with maximum changes") + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + "&nbsp;(" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Top") + "&nbsp;" + indexCount + ") : " + totalCount + "&nbsp;&nbsp;&nbsp;&nbsp;" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Total changes") + " : " + i_totalChangeCount;//chart
						}

						aListData.add(request.getScheme()+"://"+request.getServerName()+":"+request.getServerPort()+"/final/servlet/com.eg.EcChartController?view=GRAPH&pageName=CHANGE&chartType=bar&height=250&width=550&range="+URLEncoder.encode(maximumRange)+"&chartTitle="+EgURLEncoder.encode(titleName,"UTF-8")+"&sampleValues="+URLEncoder.encode(strBufferChangeCounts.toString())+"&barLabels="+EgURLEncoder.encode(strBufferTestnames.toString(),"UTF-8")+"&userName="+EgURLEncoder.encode(userName,"UTF-8"));

						aListTestNamesForCSV.add("");

						EgTableModel egTableModel = new EgTableModel(aListData,aListColumnNames);
						egTableAttributes.setImageData(true);

						EgTable egTable = new EgTable();
						egTable.setModel(egTableModel);
						egTable.setAttributes(egTableAttributes);

						aListPdfData.add(egTable);
						if(!requestFromMonitor)
						{
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>

													<table border="0" align="center" width="99%" class="body_text">
<%
						boolean flag = false;
						if (chartDataRepresentation != null && chartDataRepresentation.equalsIgnoreCase("3D"))
						{
							flag = true;
						}
						if (flag)
						{
%>
													<!-- Bar2D chart starts-->
														<tr>
															<td colspan="2" align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
																<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar3D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar3D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=100&chartHeight=100" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar3D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=100&chartHeight=100" quality="high" width="90%" height="250" name="StackedBar3D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig3DContainer4<%=component%>" style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig3D4<%=component%>" ) )
																FusionCharts( "StackedBarConfig3D4<%=component%>" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar3D.swf","StackedBarConfig3D4<%=component%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig3DContainer4<%=component%>");
																</script>
															</td>
														</tr>
<%
						}
						else
						{
%>
														<tr>
															<td colspan="2" align="center" width="100%"><b><%=chartTitle%></b></td>
														</tr>
														<tr>
															<td align="center" width="100%" bgcolor="white"  nowrap>
																<!--
																<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="90%" height="250" id="StackedBar2D">
																	<param name="movie" value="/final/FusionCharts/swf/StackedBar2D.swf" />
																	<param name="FlashVars" value="&dataXML=<%=xmlString%>&chartWidth=100&chartHeight=100" />
																	<param name="quality" value="high" />
																	<param name="wmode" value="transparent" />
																	<embed src="/final/FusionCharts/swf/StackedBar2D.swf" flashVars="&dataXML=<%=xmlString%>&chartWidth=100&chartHeight=100" quality="high" width="90%" height="250" name="StackedBar2D" wmode="transparent" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />
																</object>
																-->
																<div id="StackedBarConfig2DContainer4<%=component%>"  style="height:100%;"></div>
																<script type="text/javascript">
																if  ( FusionCharts( "StackedBarConfig2D4<%=component%>" ) )
																FusionCharts( "StackedBarConfig2D4<%=component%>" ).dispose();
																var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedBar2D.swf","StackedBarConfig2D4<%=component%>", "650", "250","0","1");
																myChart.setXMLData("<%=xmlString%>");
																myChart.setTransparent(true);
																myChart.render("StackedBarConfig2DContainer4<%=component%>");
																</script>
															</td>
														</tr>
														<!-- Bar2D chart ends-->
<%
						}
%>
													</table>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
						}
						tmap_ComponentData = processChangeData.getComponentSummary(tmap_ComponentData,selectedDate,timeZone);

						if(requestFromMonitor)
						{
%>
													<table cellspacing="0" cellpadding="5" border="0" align="center" width="100%" class="body_text">
													<tr>
<%
							aListColumnNames.add("C0");
							aListColumnNames.add("C1");
							aListColumnNames.add("C2");
							aListColumnNames.add("C3");
							aListColumnNames.add("C4");

							userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
							userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
							userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Change Date"));
							userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
							userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

							//Landscape - 830
							fieldWidths.add("0");
							fieldWidths.add("140");
							fieldWidths.add("140");
							fieldWidths.add("275");
							fieldWidths.add("275");

							egTableAttributes.setDataGrouping(true);
							egTableAttributes.setDataGroupingField(0);
							egTableAttributes.setFieldWidths(fieldWidths);
%>
														<td width="20%" id="<%=monCellHeaderfirstVal%>"><egui:intnl text="configmgmt.changes.detailed.Descriptor" /></td>
														<td width="20%" id="<%=monCellHeaderVal%>" nowrap><egui:intnl text="configmgmt.changes.detailed.Measure" /></td>
														<td width="20%" id="<%=monCellHeaderVal%>" nowrap><egui:intnl text="configmgmt.changes.detailed.Change Date" /></td>
														<td width="20%" id="<%=monCellHeaderVal%>" nowrap><egui:intnl text="configmgmt.changes.detailed.Previous Value" /></td>
														<td width="20%" id="<%=monCellHeaderlastVal%>" nowrap><egui:intnl text="configmgmt.changes.detailed.Present Value" /></td>
												</tr>
												</table>
<%
						}

						for (int c=0; c<aListTestnames.size(); c++)
						{
							String key_testname = (String)aListTestnames.get(c);
							Integer changeCount = (Integer)aListChangeCount.get(c);
							TreeMap temp_tmap_Data = (TreeMap)tmap_ComponentData.get(key_testname);
							Iterator info_keys = temp_tmap_Data.keySet().iterator();
							aListTestNamesForCSV.add(key_testname);

							HashMap testinDiff = (HashMap)treeValues.get(key_testname);

							egTableAttributes = new EgTableAttributes();
							aListColumnNames = new ArrayList();
							aListData = new ArrayList();
							userColumnNames = new ArrayList();
							fieldWidths = new ArrayList();

							egTableAttributes.setTitle(mappingInfo.getTestDescription(key_testname) + " (" + mappingInfo.getTextDescription("configmgmt.changes.detailed.Changes") + " : " + changeCount + ")");

							boolean isDynamicMeasureTest = false;
							String firstKey = (String)temp_tmap_Data.firstKey();
							int idx_M = firstKey.indexOf("~M~");
							if (idx_M != -1)
							{
								isDynamicMeasureTest = true;
							}

							ArrayList aListInfoHeadings = null;
							if (isDynamicMeasureTest)
							{
								aListInfoHeadings = new ArrayList();
								String infoHeadings = configTestsInfo.getServerDisplayValue("DYNAMIC_MEASURES_TEST",key_testname);
								if (infoHeadings != null && infoHeadings.length() > 0)
								{
									StringTokenizer strTokensTemp = new StringTokenizer(infoHeadings,",");
									while (strTokensTemp.hasMoreTokens())
									{
										String str_temp = strTokensTemp.nextToken();
										aListInfoHeadings.add(str_temp);
									}
								}
							}

							String str_colspan = "4";
							if (!firstKey.equals("+") && !(ecUtils.getInfoForDisplay(firstKey).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(firstKey).equals(EgConfigConstants.CF_EMPTY)))
							{
								str_colspan = "5";
							}

							String selXMLTypeTest = key_testname;
							String measuresTemp = "";

							EgThresholdInfo thresholdInfo = new EgThresholdInfo("manager");
							String[] testMeasures = thresholdInfo.getMeasurementsForTest(selXMLTypeTest);
							ArrayList measuresListTemp = new ArrayList();
							if (testMeasures != null && testMeasures.length > 0)
							{
								measuresListTemp.addAll(Arrays.asList(testMeasures));
							}
							for(int i=0;i< measuresListTemp.size();i++)
							{
								measuresTemp = (String)measuresListTemp.get(i);
							}
%>
													<table style="<%=styleValue%>" border="0" cellspacing="0" cellpadding="0" align="center" width="<%=widthValue%>" class="<%=montableBorderVal%>">
														<tr>
															<td class="<%=montable_headerVal%>"  style="padding:3px" colspan="<%=str_colspan%>"><b><egui:intnl test="<%=key_testname%>" />&nbsp;&nbsp;(<egui:intnl text="configmgmt.changes.detailed.Changes" /> : <%=changeCount%>)</b></td>
														</tr>
<%
							boolean heading_flag = false;
							while (info_keys.hasNext())
							{
%>
														<tr>
<%
								String key_info = (String)info_keys.next();
								if (!heading_flag && !requestFromMonitor)
								{
									if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
									{
										aListColumnNames.add("C0");
										aListColumnNames.add("C1");
										aListColumnNames.add("C2");
										aListColumnNames.add("C3");
										aListColumnNames.add("C4");

										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Change Date"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

										//Portrait - 583
										//fieldWidths.add("0");
										//fieldWidths.add("100");
										//fieldWidths.add("100");
										//fieldWidths.add("191");
										//fieldWidths.add("191");

										//Landscape - 830
										fieldWidths.add("0");
										fieldWidths.add("140");
										fieldWidths.add("140");
										fieldWidths.add("275");
										fieldWidths.add("275");

										egTableAttributes.setDataGrouping(true);
										egTableAttributes.setDataGroupingField(0);
										egTableAttributes.setFieldWidths(fieldWidths);
%>
															<td width="20%" id="cell_header"><egui:intnl text="configmgmt.changes.detailed.Descriptor" /></td>
<%
									}
									else
									{
										aListColumnNames.add("C0");
										aListColumnNames.add("C1");
										aListColumnNames.add("C2");
										aListColumnNames.add("C3");

										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Measure"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Change Date"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Previous Value"));
										userColumnNames.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Present Value"));

										//Portrait
										//fieldWidths.add("100");
										//fieldWidths.add("100");
										//fieldWidths.add("191");
										//fieldWidths.add("191");

										//Landscape
										fieldWidths.add("140");
										fieldWidths.add("140");
										fieldWidths.add("275");
										fieldWidths.add("275");

										egTableAttributes.setFieldWidths(fieldWidths);
									}
%>
															<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Measure" /></td>
															<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Change Date" /></td>
															<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Previous Value" /></td>
															<td width="20%" id="cell_header" nowrap><egui:intnl text="configmgmt.changes.detailed.Present Value" /></td>
<%
									heading_flag = true;
								}
%>
														</tr>
<%
								TreeMap tmap_Data = (TreeMap)temp_tmap_Data.get(key_info);
								Iterator measure_keys = tmap_Data.keySet().iterator();

								boolean newInfoFlag = false;
								int idx_NI = key_info.indexOf("~NEW-INFO~");
								if (idx_NI != -1)
								{
									newInfoFlag = true;
									key_info = key_info.substring(idx_NI+10);
								}

								String strDataForPDF = "";
								if (!key_info.equals("+") && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
								{
%>
														<tr>
															<td id="<%=monBgVal%>" align="left" class="body_text" height="20" colspan="<%=str_colspan%>">
<%
									if (!isDynamicMeasureTest)
									{
										if (!requestFromMonitor)
										{
%>
																<b style="font-size:7.5pt">&nbsp;<%=ecUtils.getInfoForDisplay(key_info)%></b>
<%
										}
										else
										{
%>
											<%=ecUtils.getInfoForDisplay(key_info)%>
<%
										}
									}
									else
									{
										ArrayList aListTokens = StringUtils.myTokenizer(ecUtils.getInfoForDisplay(key_info),"~M~");
										int aListTokensSize = aListTokens.size();
										String strData = "";
										for (int x=0;x<aListTokensSize;x++)
										{
											String infoHeading = (String)aListInfoHeadings.get(x);
											String strTemp = (String)aListTokens.get(x);
											if (x == aListTokensSize-1)
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp;
												strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp;
											}
											else
											{
												strData = strData + "<b>" + infoHeading + "</b>: " + strTemp + ", ";
												strDataForPDF = strDataForPDF + infoHeading + ": " + strTemp + ", ";
											}
										}
										out.println("&nbsp;"+strData);
									}

									if (newInfoFlag)
									{
%>
										<img src="/final/config/images/new_info.gif" border="0">
<%
									}
%>
															</td>
														</tr>
<%
								}

								boolean isMeasure = false;
								String testDescr = mappingInfo.getTestDescription(key_testname);

								measure_keys = tmap_Data.keySet().iterator();
								while (measure_keys.hasNext())
								{
									String key_measure = (String)measure_keys.next();
									ArrayList al_data = (ArrayList)tmap_Data.get(key_measure);
									boolean measureFlag = false;

									String lengthinDiff = "0";
									if (testinDiff != null)
									{
										isMeasure = testinDiff.containsKey(key_measure);
										if (isMeasure)
										{
											lengthinDiff = (String)testinDiff.get(key_measure);
										}
									}
									int lengthinMeasureInt = Integer.parseInt(lengthinDiff);

									for(int y=0;y<al_data.size();y++)
									{
										ArrayList arraylist_temp = (ArrayList)al_data.get(y);

										String previous_measurevalue = (String)arraylist_temp.get(1);
										String present_measurevalue = (String)arraylist_temp.get(2);

										if (!isDynamicMeasureTest)
										{
											if (!present_measurevalue.equals(previous_measurevalue) && !previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED) && !present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
%>
														<div><tr>
<%
												if (!key_info.equals("+"))
												{
													if (newInfoFlag)
													{
														aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + ecUtils.getInfoForDisplay(key_info) + " [NEW]");
													}
													else
													{
														aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + ecUtils.getInfoForDisplay(key_info));
													}
%>
																<td width="20%" class="<%=monCellbgVal%>">&nbsp;</td>
<%
												}

												if (!measureFlag)
												{
													aListData.add(key_measure);
%>
																<td width="20%" wrap class="<%=monCellbgVal%>" valign="top"><%=key_measure%></td>
<%
													measureFlag = true;
												}
												else
												{
													aListData.add(" ");
%>
																<td width="20%" nowrap class="<%=monCellbgVal%>">&nbsp;</td>
<%
												}

												String strDateTime = (String)arraylist_temp.get(0);
												String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
												String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
												String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

												/* Added by Prakash.K starts */
												timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
												startDateAndTime = timeZoneConverter.getDateTime();
												/* Added by Prakash.K ends */
												String tempDisplayDate = "";
												if (startDateAndTime.indexOf(",") != -1)
												{
													tempDisplayDate = StringUtils.replace(startDateAndTime,",","");
												}
												else
												{
													tempDisplayDate = startDateAndTime;
												}
												aListData.add(tempDisplayDate);
%>
																<td width="20%" nowrap class="<%=monCellbgVal%>" valign="top"> 
																	<%=startDateAndTime%>
																</td>
<%
												if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
												}
												else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.No"));
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><egui:intnl text="configmgmt.common.No" /></td>
<%
												}
												else
												{
													if (previous_measurevalue.equalsIgnoreCase("##NEW##"))
													{
														previous_measurevalue = "[N/PV]";
													}

													aListData.add(previous_measurevalue);
													if (previous_measurevalue.startsWith("<?configuration?>"))
													{
														//previous_measurevalue = StringUtils.replace(previous_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																<td width="20%" class="monCellbg2" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=s_changetype%>&ec_component=<%=key_component%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteriaPrevious%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOptionPrevious%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_test=<%=selXMLTypeTest%>&changeConfigSelTest=<%=selectedInformations%>&ec_viewchange=<%=s_viewchange%>&request_from=Change&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=URLEncoder.encode(key_info)%>&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;</td>
<%
													}
													else
													{
														if (previous_measurevalue.length()<=28)
														{
															previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><div><%=previous_measurevalue%>&nbsp;</div></td>
<%
														}
														else
														{
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><div>
<%
															ArrayList aListStrValues = breakString(previous_measurevalue,40);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}
%>

																</div></td>
<%
														}
													}
												}

												if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_YES))
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.Yes"));
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><egui:intnl text="configmgmt.common.Yes" /></td>
<%
												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_NO))
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.common.No"));
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><egui:intnl text="configmgmt.common.No" /></td>
<%
												}
												else
												{
													aListData.add(present_measurevalue);
													if (present_measurevalue.startsWith("<?configuration?>"))
													{
														//present_measurevalue = StringUtils.replace(present_measurevalue,"<ul>&#xA;</ul>","<ul>&nbsp;</ul>");
%>
																<td width="20%" class="monCellbg2" valign="top"><a class="eg_monlink" href="/final/servlet/com.eg.EcConfigurationServlet?cmd=XmlMeasureUsingJs&ec_changetype=<%=s_changetype%>&ec_component=<%=key_component%>&ec_comptype=<%=URLEncoder.encode(comp_type)%>&ec_criteria=<%=ec_criteria%>&ec_criteriaPrevious=<%=ec_criteriaPrevious%>&ec_userOption=<%=ec_userOption%>&ec_userOptionPrevious=<%=ec_userOptionPrevious%>&ec_timeline=<%=s_timeline%>&ec_prevtimeline=<%=s_prevtimeline%>&ec_enddate_h=<%=s_enddate%>&ec_endhr_h=<%=s_endhr%>&ec_endmin_h=<%=s_endmin%>&ec_stdate_h=<%=s_stdate%>&ec_sthr_h=<%=s_sthr%>&ec_startmin_h=<%=s_startmin%>&ec_option1=<%=option1%>&ec_option2=<%=option2%>&ec_test=<%=selXMLTypeTest%>&changeConfigSelTest=<%=selectedInformations%>&ec_viewchange=<%=s_viewchange%>&request_from=Change&fromField=from&old_comptype=<%=comp_type%>&ec_measure=<%=measuresTemp%>&descriptor=<%=URLEncoder.encode(key_info)%>&ec_rtype=&ec_trgttype=Configuration_Report"><egui:intnl text="configmgmt.dashboard.Click here to see changes"/></a>&nbsp;
<%
															if (!previous_measurevalue.equals("-") && 
																!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
																!present_measurevalue.equals("-"))
															{
																if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
																{
%>
																	<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
																}
															}
%>
																</td>
<%
													}
													else
													{
														if (present_measurevalue.length()<=28)
														{
															present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><div><%=present_measurevalue%>&nbsp;
<%
															if (!previous_measurevalue.equals("-") && 
																!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
																!present_measurevalue.equals("-"))
															{
																if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
																{
%>
																	<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
																}
															}
%>
																</div></td>
<%
														}
														else
														{
%>
																<td width="20%" class="<%=monCellbgVal%>" valign="top"><div>
<%
															ArrayList aListStrValues = breakString(present_measurevalue,40);
															for (int r=0;r<aListStrValues.size();r++)
															{
																String str_value = (String)aListStrValues.get(r);
																str_value = EcUtils.replaceTags(str_value);
																out.print(str_value+"<br>");
															}

															if (!previous_measurevalue.equals("-") && 
																!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
																!present_measurevalue.equals("-"))
															{
																if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
																{
%>
																	<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
																}
															}
%>
																</div></td>
<%
														}
													}
												}
%>
														</tr></div>
<%
											}
										}
										else
										{
%>
														<div><tr>
<%
											if (!(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY_WITH_COLON)) && !(ecUtils.getInfoForDisplay(key_info).equals(EgConfigConstants.CF_EMPTY)))
											{
												if (newInfoFlag)
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + strDataForPDF + " [NEW]");
												}
												else
												{
													aListData.add(mappingInfo.getTextDescription("configmgmt.changes.detailed.Descriptor") + " : " + strDataForPDF);
												}
%>
															<td width="20%" class="<%=monCellbgVal%>">&nbsp;</td>
<%
											}

											boolean newMeasureFlag = false;
											boolean deletedMeasureFlag = false;
											if (!newInfoFlag)
											{
												if (previous_measurevalue.equalsIgnoreCase("##NEW##") || 
													previous_measurevalue.equalsIgnoreCase("##NEW-INFO##") || 
													previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													newMeasureFlag = true;
												}
												else if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
												{
													deletedMeasureFlag = true;
												}
											}

											if (newMeasureFlag)
											{
												aListData.add(key_measure + " [NEW]");
%>
															<td width="20%" nowrap class="<%=monCellbgVal%>" valign="top"><%=key_measure%>&nbsp;<img src="/final/config/images/new_info.png" border="0"></td>
<%
											}
											else if (deletedMeasureFlag)
											{
												aListData.add(key_measure + " [REMOVED]");
%>
															<td width="20%" nowrap class="<%=monCellbgVal%>" valign="top"><%=key_measure%>&nbsp;<img src="/final/config/images/removed_info.png" border="0"></td>
<%
											}
											else
											{
												aListData.add(key_measure);
%>
															<td width="20%" nowrap id="<%=cell_bg2Val%>" valign="top"><%=key_measure%></td>
<%
											}

											String strDateTime = (String)arraylist_temp.get(0);
											String strDate = strDateTime.substring(0,strDateTime.indexOf(' '));
											String strTime = strDateTime.substring(strDateTime.indexOf(' ')+1);
											String displayDate = DateUtil.changeDateFormat(strDate,"MM/dd/yyyy",currentDateFormat);

											/* Added by Prakash.K starts */
											timeZoneConverter = new EgTimeZoneConverter(displayDate + " " + strTime,user);
											startDateAndTime = timeZoneConverter.getDateTime();
											/* Added by Prakash.K ends */

											aListData.add(startDateAndTime);
%>
															<td width="20%" nowrap class="<%=monCellbgVal%>" valign="top"> 
																<%=startDateAndTime%>
															</td>
<%
											if (previous_measurevalue.equalsIgnoreCase("##NEW##") || previous_measurevalue.equalsIgnoreCase("##NEW-INFO##"))
											{
												previous_measurevalue = "[N/PV]";
											}
											else if (previous_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												previous_measurevalue = "[N/A]";
											}

											aListData.add(previous_measurevalue);
											if (previous_measurevalue.length()<=28)
											{
												previous_measurevalue = EcUtils.replaceTags(previous_measurevalue);
%>
															<td width="20%" class="<%=monCellbgVal%>" valign="top"><div><%=previous_measurevalue%>&nbsp;</div></td>
<%
											}
											else
											{
%>
															<td width="20%" class="<%=monCellbgVal%>" valign="top"><div>
<%
												ArrayList aListStrValues = breakString(previous_measurevalue,40);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}
%>
															</div></td>
<%
											}

											if (present_measurevalue.equalsIgnoreCase(EgConfigConstants.CF_REMOVED))
											{
												present_measurevalue = "[N/A]";
											}

											aListData.add(present_measurevalue);
											if (present_measurevalue.length()<=28)
											{
												present_measurevalue = EcUtils.replaceTags(present_measurevalue);
%>
															<td width="20%" id="<%=cell_bg2Val%>" valign="top"><div><%=present_measurevalue%>&nbsp;
<%
												if (!previous_measurevalue.equals("-") && 
													!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
													!previous_measurevalue.equalsIgnoreCase("[N/A]") && 
													!present_measurevalue.equals("-") && 
													!present_measurevalue.equalsIgnoreCase("[N/A]"))
												{
													if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
													{
%>
														<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
													}
												}
%>
															</div></td>
<%
											}
											else
											{
%>
															<td width="20%" id="<%=cell_bg2Val%>" valign="top"><div>
<%
												ArrayList aListStrValues = breakString(present_measurevalue,40);
												for (int r=0;r<aListStrValues.size();r++)
												{
													String str_value = (String)aListStrValues.get(r);
													str_value = EcUtils.replaceTags(str_value);
													out.println(str_value+"<br>");
												}
												if (!previous_measurevalue.equals("-") && 
													!previous_measurevalue.equalsIgnoreCase("[N/PV]") && 
													!previous_measurevalue.equalsIgnoreCase("[N/A]") && 
													!present_measurevalue.equals("-") && 
													!present_measurevalue.equalsIgnoreCase("[N/A]"))
												{
													if ((present_measurevalue.length() > lengthinMeasureInt) && isMeasure)
													{
%>
														<img id="valuechangesDiv" src="/final/config/images/diff.png" onclick="javascript:loadChange('<%=EgURLEncoder.encode(previous_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(present_measurevalue,"UTF-8")%>','<%=EgURLEncoder.encode(component+":"+mappingInfo.getComponentTypeDescription(comp_type),"UTF-8")%>','<%=EgURLEncoder.encode(testDescr,"UTF-8")%>','<%=EgURLEncoder.encode(key_info,"UTF-8")%>','<%=EgURLEncoder.encode(key_measure,"UTF-8")%>',this);" alt="Show the difference" class="mouse"/>
<%
													}
												}
%>
															</div></td>
<%
											}
%>
														</tr></div>
<%
										}
									}
								}
							}
%>
													</table>
<%
							if (!requestFromMonitor)
							{
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="5"></td></tr></table>
<%
							}

							egTableModel = new EgTableModel(aListData,aListColumnNames);
							egTableAttributes.setColumnNames(userColumnNames);

							egTable = new EgTable();
							egTable.setModel(egTableModel);
							egTable.setAttributes(egTableAttributes);

							aListPdfData.add(egTable);
						}

						if (g < aListComponents.size()-1)
						{
							if (!requestFromMonitor)
							{
%>
													<table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><td height="0"><img src="/final/config/images/spacer.gif" border="0" height="10"></td></tr></table>
<%
							}
						}
					}
					if (option1.equalsIgnoreCase(userOptions[0]))
					{
						reportAttributes.setSubTitle(subTitle);
					}
				//}
			}
%>
												</td>
											</tr>
										</table>
<%
			//For new pdf framework
			pdfData.setAttributes(reportAttributes);
			pdfData.setData(aListPdfData);
			pdfData.setTest(aListTestNamesForCSV);
			pdfData.setViewBy(s_viewchange);
			session.setAttribute("pdfData",pdfData);
		}
	}
	else if (tmap_changeConfigDetails == null && request_from != null && 
			(searchCompValue != null && !searchCompValue.equals("")) || 
			(searchTestValue != null && !searchTestValue.equals("")) || 
			(searchDescValue != null && !searchDescValue.equals("")))
	{
%>
										<input type="hidden" name="submitClicked" value="false">
										<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0" height="100%">
											<tr>
												<td align="center" height="100%" >
													<table border="0" align="center" width="100%" height="100%" cellspacing="0" cellpadding="0">
														<tr>
															<td align="center">
																<table border="0" align="center" width="100%" class="body_text"  cellspacing="0" cellpadding="0">
																	<tr>
																		<td align="center"> <img src="/final/config/images/unavailable-data.gif" title='<egui:intnl text="configmgmt.common.No Data" />'> </td>
																	</tr>
																	<tr>
																		<td align="center"> <b><egui:intnl text="configmgmt.changes.detailed.No changes found for the current search data" /></b></td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
<%
	}
	else
	{
%>
										<input type="hidden" name="submitClicked" value="false">
										<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" height="100%">
											<tr>
												<td width="100%" height="100%">
													<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0" height="100%">
														<tr>
															<td align="center"height="100%" >
																<table border="0" align="center" width="100%"  height="100%"  cellspacing="0" cellpadding="0">
																	<tr>
																		<td align="center">
																			<table border="0" align="center" width="100%" class="body_text" cellspacing="0" cellpadding="0">
																				<tr>
																					<td align="center">
																					&nbsp;
																					</td>
																				</tr>
																			</table>
																		</td>
																	</tr>
																</table>
															</td>
														</tr>
													</table>
												</td>
											</tr>
										</table>
<%
	}
%>
									</td>
								</tr>
							</table>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
	</table>
	</form>
	</body>
	</html>



