<%
/***********************************************************************************************************
*	Name			:	renamep.jsp
*	Purpose			:	Process page for rename.jsp
*	Version			:	5.5
*	CreationDate	:	17-Feb-2012
*	Author			:	James Thomas P
***********************************************************************************************************/
%>

<%@ include file="EgTrackerA.jsp"%>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgGroupInfo"%>
<%@ page import = "com.eg.EgStateZone"%>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgURLDecoder"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.egurkha.admin.Rename"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.*"%>

<%@ taglib prefix="egui" uri="../WEB-INF/eg-taglib.tld"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>

<%!
	boolean doesOldnameExist(String current_name[],String old_name,String new_name, Vector nameConflict)
	{
		boolean success = false;
		if(current_name != null && current_name.length>0)
		{
			for(int i=0;i<current_name.length;i++)
			{
				if(current_name[i].equals(old_name))
				{
					success = true;
				}
				if(current_name[i].equals(new_name))
				{
					nameConflict.add("true");
					return false;
				}
			}
		}
		return success;
	}
%>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String rename = request.getParameter("rename");
	String old_name = EgURLDecoder.decode(request.getParameter("old_name"),"UTF-8");
	String new_name = EgURLDecoder.decode(request.getParameter("new_name"),"UTF-8");

	if(StringUtils.isNull(old_name) || StringUtils.isNull(new_name) || StringUtils.isNull(rename))
	{
		Vector sess_vec = new Vector();
		if(StringUtils.isNull(rename))
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Admin Home Page"));
			sess_vec.addElement("EgAdminOperations.jsp");
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Rename"));
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Some error occurs")+". " + _mapping.getTextDescription("admin.error.Try again!"));
		}
		else
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Rename"));
			if(rename.equalsIgnoreCase("Group"))
			{
				sess_vec.addElement("EgDispGroups.jsp?reqfrom=navlink");
			}
			else if(rename.equalsIgnoreCase("Segment"))
			{
				sess_vec.addElement("EgDispSegments.jsp?reqfrom=navlink");
			}
			else if(rename.equalsIgnoreCase("Service"))
			{
				sess_vec.addElement("EgDispSites.jsp?reqfrom=navlink");
			}
			else if(rename.equalsIgnoreCase("Zone"))
			{
				sess_vec.addElement("EgDispZones.jsp?reqfrom=navlink");
			}
			else if(rename.equalsIgnoreCase("Service Group"))
			{
				sess_vec.addElement("EgDispServiceGroup.jsp?reqfrom=navlink");
			}
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming"));
			if(StringUtils.isNull(new_name))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.You can not proceed renaming as new name for the selected zone is null")+". ");
			}
			else
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.You can not proceed renaming as current name of the selected zone is null")+". ");
			}
		}
		session.setAttribute("vec_Errors",sess_vec);
%>
		<jsp:forward page="EgErrors.jsp"/>
<%
	}
	else
	{
		if(IniUI.isEgReservedKeyword(new_name))
		{
			Vector sess_vec = new Vector();
			if(rename.equalsIgnoreCase("Group"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a group"));
				sess_vec.addElement("rename.jsp?from=group&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a group"));
			}
			else if(rename.equalsIgnoreCase("Segment"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a segment"));
				sess_vec.addElement("rename.jsp?from=segment&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a segment"));
			}
			else if(rename.equalsIgnoreCase("Service"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a service"));
				sess_vec.addElement("rename.jsp?from=service&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a service"));
			}
			else if(rename.equalsIgnoreCase("Zone"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a zone"));
				sess_vec.addElement("rename.jsp?from=zone&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement (_mapping.getTextDescription("admin.error.Renaming a zone"));
			}
			else if(rename.equalsIgnoreCase("Service Group"))
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a service group"));
				sess_vec.addElement("rename.jsp?from=service group&old_name="+EgURLEncoder.encode(old_name,"UTF-8"));
				sess_vec.addElement(_mapping.getTextDescription("admin.error.Renaming a service group"));
			}
			sess_vec.addElement(_mapping.getTextDescription("admin.error.Possible reason")+":");
			sess_vec.addElement("'"+new_name.toUpperCase() +"' "+_mapping.getTextDescription("admin.error.is an eG defined keyword")+". "+_mapping.getTextDescription("admin.error.Choose another name"));
			session.setAttribute("vec_Errors",sess_vec);
%>
			<jsp:forward page="EgErrors.jsp"/>
<%
		}

		boolean oldNameExist = false;
		boolean isSite = false;
		String auditlogLabel = null;
		String nameConflictLabel = null;
		String update_msmt_table = request.getParameter("update_msmt_table");
		Vector nameConflict = new Vector();//dont add anything into this vector

		AuditLogThread auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Activity","Rename");

		String targetPageURL = null;
		if(rename.equalsIgnoreCase("Group"))
		{
			auditLogThread.setValue("Module","Component Groups");
			targetPageURL="EgDispGroups.jsp?reqfrom=navlink";
			oldNameExist = doesOldnameExist(new EgGroupInfo().getGroupNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a group with a name which is already assigned to some other group";
			auditlogLabel=old_name + " group can not be renamed to "+new_name +" as this is name already assigned to some to some other group";
		}
		else if(rename.equalsIgnoreCase("Segment"))
		{
			auditLogThread.setValue("Module","Segments");
			targetPageURL="EgDispSegments.jsp?reqfrom=navlink";
			oldNameExist = doesOldnameExist(new EgTopoInfo("manager").getSegmentNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a segment with a name which is already assigned to another segment";
			auditlogLabel=old_name + " segment can not be renamed to "+new_name +" as this is name already assigned to some to some other segment";
		}
		else if(rename.equalsIgnoreCase("Service"))
		{
			auditLogThread.setValue("Module","Services");
			targetPageURL="EgDispSites.jsp?reqfrom=navlink";
			EgTopoInfo egTopoInfo = new EgTopoInfo("manager");
			ArrayList serviceList = egTopoInfo.getAllServices();
			if(serviceList != null && serviceList.size()>0)
			{
				oldNameExist = doesOldnameExist((String[])serviceList.toArray(new String[serviceList.size()]),old_name,new_name,nameConflict);
			}
			if(oldNameExist)
			{
				isSite = !egTopoInfo.isSiteService(old_name);
			}
			egTopoInfo = null;
			serviceList=null;
			nameConflictLabel="admin.error.You are trying to rename a service with a name which is already assigned to another service";
			auditlogLabel=old_name + " service can not be renamed to "+new_name +" as this is name already assigned to some to some other service";
		}
		else if(rename.equalsIgnoreCase("Zone"))
		{
			auditLogThread.setValue("Module","Zones");
			targetPageURL="EgDispZones.jsp?reqfrom=navlink";
			oldNameExist = doesOldnameExist(new EgGroupInfo().getZoneNames(),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a zone with a name which is already assigned to another zone";
			auditlogLabel=old_name + " zone can not be renamed to "+new_name +" as this is name already assigned to some to some other zone";
		}
		else if(rename.equalsIgnoreCase("Service Group"))
		{
			auditLogThread.setValue("Module","Services Group");
			targetPageURL="EgDispServiceGroup.jsp?reqfrom=navlink";
			oldNameExist = doesOldnameExist(new EgGroupInfo().getVariables("LIST_OF_SERVICEGROUPS"),old_name,new_name,nameConflict);
			nameConflictLabel="admin.error.You are trying to rename a service group with a name which is already assigned to another service group";
			auditlogLabel=old_name + " service group can not be renamed to "+new_name +" as this is name already assigned to some to some other service group";
		}
		if(!nameConflict.isEmpty())
		{
			auditLogThread.setValue("Description",auditlogLabel);
			auditLogThread.sendItToDB();
			Vector errors = new Vector();
			errors.addElement(_mapping.getTextDescription("admin.error.Rename a " + rename));
			errors.addElement(targetPageURL);
			errors.addElement(_mapping.getTextDescription("admin.error.Possible Reason"));
			errors.addElement(_mapping.getTextDescription(nameConflictLabel)+".");
			session.putValue("vec_Errors", errors);
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
		if(oldNameExist)
		{
			boolean success = false;
			if(rename.equalsIgnoreCase("Group"))
			{
				success = true;
				IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
				IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
				groupSync.deleteValue("LIST_OF_GROUPS",old_name);
				groupSync.setValue("LIST_OF_GROUPS",new_name,new_name);
				Vector vars = groupsIni.getVariables("GROUP_DETAILS",true);
				Vector vals = groupsIni.getAllValues("GROUP_DETAILS");
				if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
				{
					for(int i=0;i<vals.size();i++)
					{
						if(vals.get(i).toString().equals(old_name))
						{
							groupSync.setValue("GROUP_DETAILS",vars.get(i).toString(),new_name);
						}
					}
				}
				vars = groupsIni.getVariables("ZONE_DETAILS",true);
				vals = groupsIni.getAllValues("ZONE_DETAILS");
				if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
				{
					for(int i=0;i<vars.size();i++)
					{
						String var = (String)vars.get(i);
						if(var.startsWith("Group:"+old_name+":NULL#"))
						{
							groupSync.deleteValue("ZONE_DETAILS",var);
							String val = (String)vals.get(i);
							var = "Group:"+new_name+":NULL#"+val;
							groupSync.setValue("ZONE_DETAILS",var,val);
							break;//single group can be associated to only one zone
						}
					}
				}
				groupsIni=null;
				groupSync.saveFile();
				EgConfigFilesSync.releaseInstance(groupSync);

				IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
				IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
				vars = topologyIni.getVariables("WEB_SITE_MAPPING",true);
				vals = topologyIni.getAllValues("WEB_SITE_MAPPING");
				Vector associated_segments = new Vector();
				if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
				{
					StringBuffer sb = new StringBuffer();
					for(int i=0;i<vals.size();i++)
					{
						String val = vals.get(i).toString();
						int idx = val.indexOf("Group:"+old_name+":NULL");
						if(idx>-1)
						{
							String var = (String)vars.get(i);
							associated_segments.add((var.substring(var.lastIndexOf(":")+1)));
							sb.append(val.substring(0,idx+6));
							sb.append(new_name);
							sb.append(val.substring(idx+6+old_name.length()));
							topologySync.deleteValue("WEB_SITE_MAPPING",var);
							topologySync.setValue("WEB_SITE_MAPPING",var,sb.toString());
							sb.setLength(0);
						}
					}
					for(int i=0;i<associated_segments.size();i++)
					{
						String subject = (String)associated_segments.get(i)+"_INDEPENDENT";
						vars = topologyIni.getVariables(subject,true);
						vals = topologyIni.getAllValues(subject);
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							for(int j=0;j<vars.size();j++)
							{
								String var = vars.get(j).toString();
								if(var.equals("Group:"+old_name+":NULL"))
								{
									topologySync.deleteValue(subject,var);
									var = "Group:"+new_name+":NULL";
									topologySync.setValue(subject,var,(String)vals.get(j));
									break;
								}
							}
						}
					}
				}
				String segments_array[] = topologyIni.getVariables("TOPOLOGY_SEGMENTS");
				if(segments_array != null && segments_array.length>0)// single group may be associated to many segments
				{
					for(int i=0;i<segments_array.length;i++)
					{
						String segment_name = segments_array[i];
						vars = topologyIni.getVariables(segment_name,true);
						vals = topologyIni.getAllValues(segment_name);
						if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
						{
							StringBuffer sb = new StringBuffer();
							for(int j=0;j<vars.size();j++)
							{
								String var = (String)vars.get(j);
								String val = (String)vals.get(j);
								if(var.equals("Group:"+old_name+":NULL"))
								{
									topologySync.deleteValue(segment_name,var);
									var = "Group:"+new_name+":NULL";
									topologySync.setValue(segment_name,var,(String)vals.get(j));
								}
								else
								{
									int idx = val.indexOf("Group:"+old_name+":NULL");
									if(idx>-1)
									{
										sb.append(val.substring(0,idx+6));
										sb.append(new_name);
										sb.append(val.substring(idx+6+old_name.length()));
										topologySync.setValue(segment_name,var,sb.toString());
										sb.setLength(0);
									}
								}
							}
						}
					}
				}
				vars = null;
				vals = null;
				topologyIni=null;
				topologySync.saveFile();
				EgConfigFilesSync.releaseInstance(topologySync);
				EgStateZone.updateZoneGroupStatus();

				session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
				session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
				session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
				session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

				auditLogThread.setPreviousValue("Group name",old_name);
				auditLogThread.setCurrentValue("Group name",new_name);
				auditLogThread.setValue("Description","Group has been renamed");
				auditLogThread.sendItToDB();
			}
			else if(rename.equalsIgnoreCase("Segment"))
			{
				Rename renameObj = new Rename(u_rs,"Segment",old_name,new_name,update_msmt_table,isSite);
				success = renameObj.executeDefaultQueries();
				if(!success)
				{
					auditLogThread.setPreviousValue("Segment name",old_name);
					auditLogThread.setCurrentValue("Segment name",new_name);
					auditLogThread.setValue("Description","Database tables have not been updated with new segment name");
					auditLogThread.sendItToDB();

					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement(targetPageURL);
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement("Problem while updating database tables. Please try again!");
					session.putValue("vec_Errors",sess_vec);
%>
					<jsp:forward page="EgErrors.jsp" />
<%
				}
				else
				{
					session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
					session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
					session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
					session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

					IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
					IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
					topologySync.deleteValue("TOPOLOGY_SEGMENTS",old_name);
					topologySync.setValue("TOPOLOGY_SEGMENTS",new_name,new_name);
					Vector vars = topologyIni.getVariables(old_name,true);
					Vector vals = topologyIni.getAllValues(old_name);
					topologySync.deleteSubject(old_name);
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							topologySync.setValue(new_name,(String)vars.get(i),(String)vals.get(i));
						}
					}
					vars = topologyIni.getVariables("WEB_SITE_SEGMENTS",true);
					vals = topologyIni.getAllValues("WEB_SITE_SEGMENTS");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vals.size();i++)
						{
							String val = (String)vals.get(i);
							String temp = ","+val+",";
							int index = temp.indexOf((","+old_name+","));
							if(index>-1)
							{
								String new_name_str = StringUtils.replace(temp,(","+old_name+","),(","+new_name+","));
								new_name_str=new_name_str.substring(1,new_name_str.length()-1);
								topologySync.setValue("WEB_SITE_SEGMENTS",(String)vars.get(i),new_name_str);
							}
						}
					}
					IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
					IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
					vars = groupsIni.getVariables("ZONE_DETAILS",true);
					vals = groupsIni.getAllValues("ZONE_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							if(vars.get(i).toString().startsWith("Segment:"+old_name+":NULL#"))
							{
								String var = vars.get(i).toString();
								String val = vals.get(i).toString();
								groupSync.deleteValue("ZONE_DETAILS",var);
								String associated_zone = var.substring(var.lastIndexOf("#")+1);
								var = "Segment:"+new_name+":NULL#"+associated_zone;
								groupSync.setValue("ZONE_DETAILS",var,val);
							}
						}
					}
					vars = null;
					vals = null;
					topologySync.saveFile();
					groupSync.saveFile();
					registry.updateAllUserMaps();
					EgStateZone.updateZoneGroupStatus();
					EgConfigFilesSync.releaseInstance(topologySync);
					EgConfigFilesSync.releaseInstance(groupSync);
					if(update_msmt_table != null && update_msmt_table.equals("true"))
					{
						success = renameObj.executeOtherQueries();
						if(!success)
						{
							auditLogThread.setPreviousValue("Segment name",old_name);
							auditLogThread.setCurrentValue("Segment name",new_name);
							auditLogThread.setValue("Description","Report and measurement tables have not been updated with new segment name");
							auditLogThread.sendItToDB();

							Vector sess_vec = new Vector();
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement(targetPageURL);
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement("Problem while updating report and measurement tables.");
							session.putValue("vec_Errors",sess_vec);
%>
						<jsp:forward page="EgErrors.jsp" />
<%
						}
					}
					auditLogThread.setPreviousValue("Segment name",old_name);
					auditLogThread.setCurrentValue("Segment name",new_name);
					auditLogThread.setValue("Description","Segment has been renamed");
					auditLogThread.sendItToDB();
				}
			}
			else if(rename.equalsIgnoreCase("Service"))
			{
				Rename renameObj = new Rename(u_rs,"Service",old_name,new_name,update_msmt_table,isSite);
				success = renameObj.executeDefaultQueries();
				if(!success)
				{
					auditLogThread.setPreviousValue("Service name",old_name);
					auditLogThread.setCurrentValue("Service name",new_name);
					auditLogThread.setValue("Description","Database tables have not been updated with new service name");
					auditLogThread.sendItToDB();

					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement(targetPageURL);
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement("Problem while updating database tables. Please try again!");
					session.putValue("vec_Errors",sess_vec);
%>
					<jsp:forward page="EgErrors.jsp" />
<%
				}
				else
				{
					session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
					session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
					session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
					session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

					IniFile topologyIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
					IniFile topologySync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_topology.ini");
					String old_value = topologyIni.getValue("SERVICE",old_name);
					topologySync.setValue("SERVICE",new_name,old_value);
					topologySync.deleteValue("SERVICE",old_name);
					Vector vars = topologyIni.getVariables(old_name+"_INDEPENDENT",true);
					Vector vals = topologyIni.getAllValues(old_name+"_INDEPENDENT");
					topologySync.deleteSubject(old_name+"_INDEPENDENT");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							topologySync.setValue(new_name+"_INDEPENDENT",(String)vars.get(i),(String)vals.get(i));
						}
					}
					vars = topologyIni.getVariables("LOGICAL_TOPOLOGY",true);
					vals = topologyIni.getAllValues("LOGICAL_TOPOLOGY");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							String var = (String)vars.get(i);
							if(var.equals("Web_site:"+old_name))
							{
								topologySync.deleteValue("LOGICAL_TOPOLOGY",var);
								topologySync.setValue("LOGICAL_TOPOLOGY","Web_site:"+new_name,(String)vals.get(i));
							}
						}
					}
					String var = "Web_site:"+old_name;
					String old_var = var;
					String val = topologyIni.getValue("WEB_SITE_MAPPING",var);
					var = "Web_site:"+new_name;
					topologySync.setValue("WEB_SITE_MAPPING",var,val);
					topologySync.deleteValue("WEB_SITE_MAPPING",old_var);

					var = "Web_site:"+old_name;
					old_var = var;
					val = topologyIni.getValue("WEB_SITE_SEGMENTS",var);
					var = "Web_site:"+new_name;
					topologySync.setValue("WEB_SITE_SEGMENTS",var,val);
					topologySync.deleteValue("WEB_SITE_SEGMENTS",old_var);

					IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
					IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
					vars = groupsIni.getVariables("ZONE_DETAILS",true);
					vals = groupsIni.getAllValues("ZONE_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							if(vars.get(i).toString().startsWith("Service:"+old_name+":NULL#"))
							{
								var = vars.get(i).toString();
								val = vals.get(i).toString();
								groupSync.deleteValue("ZONE_DETAILS",var);
								String associated_zone = var.substring(var.lastIndexOf("#")+1);
								var = "Service:"+new_name+":NULL#"+associated_zone;
								groupSync.setValue("ZONE_DETAILS",var,val);
							}
						}
					}
					vars = groupsIni.getVariables("SERVICEGROUPS_DETAILS",true);
					vals = groupsIni.getAllValues("SERVICEGROUPS_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							var = (String) vars.get(i);
							val = (String) vals.get(i);
							if(!StringUtils.isNull(var) && !StringUtils.isNull(val))
							{
								val = ","+val+",";
								int idx = val.indexOf((","+old_name+","));
								if(idx>-1)
								{
									val = val.substring(1,idx+1)+new_name+val.substring(idx+old_name.length()+1);
									val = val.substring(0,val.length()-1);
									groupSync.setValue("SERVICEGROUPS_DETAILS",var,val);
								}
							}
						}
					}
					vars = null;
					vals = null;
					topologySync.saveFile();
					groupSync.saveFile();
					registry.updateAllUserMaps();
					EgStateZone.updateZoneGroupStatus();
					EgConfigFilesSync.releaseInstance(topologySync);
					EgConfigFilesSync.releaseInstance(groupSync);
					if(update_msmt_table != null && update_msmt_table.equals("true"))
					{
						success = renameObj.executeOtherQueries();
						if(!success)
						{
							auditLogThread.setPreviousValue("Service name",old_name);
							auditLogThread.setCurrentValue("Service name",new_name);
							auditLogThread.setValue("Description","Report and measurement tables have not been updated with new service name");
							auditLogThread.sendItToDB();

							Vector sess_vec = new Vector();
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement(targetPageURL);
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement("Problem while updating report and measurement tables.");
							session.putValue("vec_Errors",sess_vec);
%>
						<jsp:forward page="EgErrors.jsp" />
<%
						}
					}
					auditLogThread.setPreviousValue("Service name",old_name);
					auditLogThread.setCurrentValue("Service name",new_name);
					auditLogThread.setValue("Description","Service has been renamed");
					auditLogThread.sendItToDB();
				}
			}
			else if(rename.equalsIgnoreCase("Zone"))
			{
				Rename renameObj = new Rename(u_rs,"Zone",old_name,new_name,update_msmt_table,isSite);
				success = renameObj.executeDefaultQueries();
				if(!success)
				{
					auditLogThread.setPreviousValue("Zone name",old_name);
					auditLogThread.setCurrentValue("Zone name",new_name);
					auditLogThread.setValue("Description","Database tables have not been updated with new zone name");
					auditLogThread.sendItToDB();

					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement(targetPageURL);
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement("Problem while updating database tables. Please try again!");
					session.putValue("vec_Errors",sess_vec);
%>
					<jsp:forward page="EgErrors.jsp" />
<%
				}
				else
				{
					session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
					session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
					session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
					session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

					IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
					IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
					Vector vars = groupsIni.getVariables("ZONE_ASSOCIATION",true);
					Vector vals = groupsIni.getAllValues("ZONE_ASSOCIATION");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							String old_var = vars.get(i).toString();
							if(old_var.equals(old_name))
							{
								groupSync.deleteValue("ZONE_ASSOCIATION",old_name);
								groupSync.setValue("ZONE_ASSOCIATION",new_name,(String)vals.get(i));
								break;
							}
						}
					}
					vars = groupsIni.getVariables("ZONE_LOCATION",true);
					vals = groupsIni.getAllValues("ZONE_LOCATION");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vars.size();i++)
						{
							String old_var = vars.get(i).toString();
							if(old_var.equals(old_name))
							{
								String old_val = vals.get(i).toString();
								groupSync.deleteValue("ZONE_LOCATION",old_name);
								groupSync.setValue("ZONE_LOCATION",new_name,old_val);
								break;
							}
						}
					}
					groupSync.deleteValue("LIST_OF_ZONES",old_name);
					groupSync.setValue("LIST_OF_ZONES",new_name,new_name);
					vars = groupsIni.getVariables("ZONE_DETAILS",true);
					vals = groupsIni.getAllValues("ZONE_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vars.size()>0)
					{
						for(int i=0;i<vals.size();i++)
						{
							String var = (String)vars.get(i);
							String val = (String)vals.get(i);
							if(val.equals(old_name))
							{
								groupSync.deleteValue("ZONE_DETAILS",var);
								var = var.substring(0,var.lastIndexOf("#")+1)+new_name;
								groupSync.setValue("ZONE_DETAILS",var,new_name);
							}
							else if(var.startsWith("Zone:"+old_name+":NULL#"))
							{
								groupSync.deleteValue("ZONE_DETAILS",var);
								String associated_zone = var.substring(var.lastIndexOf("#")+1);
								var = "Zone:"+new_name+":NULL#"+associated_zone;
								groupSync.setValue("ZONE_DETAILS",var,val);
							}
						}
					}
					vars = null;
					vals = null;
					groupSync.saveFile();
					registry.updateAllUserMaps();
					EgStateZone.updateZoneGroupStatus();
					EgConfigFilesSync.releaseInstance(groupSync);
					if(update_msmt_table != null && update_msmt_table.equals("true"))
					{
						success = renameObj.executeOtherQueries();
						if(!success)
						{
							auditLogThread.setPreviousValue("Zone name",old_name);
							auditLogThread.setCurrentValue("Zone name",new_name);
							auditLogThread.setValue("Description","Report and measurement tables have not been updated with new zone name");
							auditLogThread.sendItToDB();

							Vector sess_vec = new Vector();
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement(targetPageURL);
							sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
							sess_vec.addElement("Problem while updating report and measurement tables.");
							session.putValue("vec_Errors",sess_vec);
%>
						<jsp:forward page="EgErrors.jsp" />
<%
						}
					}
					auditLogThread.setPreviousValue("Zone name",old_name);
					auditLogThread.setCurrentValue("Zone name",new_name);
					auditLogThread.setValue("Description","Zone has been renamed");
					auditLogThread.sendItToDB();
				}
			}
			else if(rename.equalsIgnoreCase("Service Group"))
			{
				Rename renameObj = new Rename(u_rs,"Service Group",old_name,new_name,update_msmt_table,isSite);
				success = renameObj.executeDefaultQueries();
				if(!success)
				{
					auditLogThread.setPreviousValue("Service group",old_name);
					auditLogThread.setCurrentValue("Service group",new_name);
					auditLogThread.setValue("Description","Database tables have not been updated with new service group name");
					auditLogThread.sendItToDB();

					Vector sess_vec = new Vector();
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement(targetPageURL);
					sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
					sess_vec.addElement("Problem while updating database tables with new service group name. Please try again!");
					session.putValue("vec_Errors",sess_vec);
%>
					<jsp:forward page="EgErrors.jsp" />
<%
				}
				else
				{
					session.setAttribute("adminLastAccessedURL","/final/admin/EgAdminOperations.jsp");
					session.setAttribute("monitorLastSession","/final/servlet/com.eg.EgMonitorController?monCmd=dashboard");
					session.setAttribute("reportLastAccessedURL","/final/monitor/EgReporter.jsp");
					session.setAttribute("configLastAccessedURL","/final/servlet/com.eg.EcConfigurationServlet?cmd=Home");

					IniFile groupsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
					IniFile groupSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_group.ini");
					groupSync.setValue("LIST_OF_SERVICEGROUPS",new_name,new_name);
					groupSync.deleteValue("LIST_OF_SERVICEGROUPS",old_name);
					Vector vars = groupsIni.getVariables("SERVICEGROUPS_DETAILS",true);
					Vector vals = groupsIni.getAllValues("SERVICEGROUPS_DETAILS");
					if(vars != null && vars.size()>0 && vals != null && vals.size()>0)
					{
						for(int i=0;i<vals.size();i++)
						{
							String var = (String)vars.get(i);
							String val = (String)vals.get(i);
							if(!StringUtils.isNull(var) && !StringUtils.isNull(val) && var.equals(old_name))
							{
								groupSync.setValue("SERVICEGROUPS_DETAILS",new_name,val);
								groupSync.deleteValue("SERVICEGROUPS_DETAILS",old_name);
								break;
							}
						}
					}
					groupsIni=null;
					groupSync.saveFile();
					EgConfigFilesSync.releaseInstance(groupSync);
					groupSync.saveFile();
					EgConfigFilesSync.releaseInstance(groupSync);

					auditLogThread.setPreviousValue("Service group name",old_name);
					auditLogThread.setCurrentValue("Service group name",new_name);
					auditLogThread.setValue("Description","Service group has been renamed");
					auditLogThread.sendItToDB();
				}
			}

			String label = "admin.common."+rename.toLowerCase()+" has been renamed successfully to";
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(targetPageURL);
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(old_name + " " + _mapping.getTextDescription(label) + " " + new_name + ".");
			session.putValue("vec_Results",sess_vec);
%>
			<jsp:forward page="EgResults.jsp" />
<%
		}
		else
		{
			String errorLabel = rename + " name";
			auditLogThread.setPreviousValue(errorLabel,old_name);
			auditLogThread.setCurrentValue(errorLabel,new_name);
			auditLogThread.setValue("Description",rename+" was not renamed as it had already been deleted");
			auditLogThread.sendItToDB();

			String label = "admin.common."+rename.toLowerCase()+" was not renamed to";
			Vector sess_vec = new Vector();
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(targetPageURL);
			sess_vec.addElement(_mapping.getTextDescription("admin.user.Rename"));
			sess_vec.addElement(old_name + " " +_mapping.getTextDescription(label) + " " + new_name +".");
			session.putValue("vec_Errors",sess_vec);
%>
			<jsp:forward page="EgErrors.jsp" />
<%
		}
	}
%>
