<%
/**********************************************************************************
*	Name			:	EgDispZones.jsp
*	Purpose			:	Display Zones
*	Design Changes	:	Jaiwin
*	Last Modified	:	July-23-2007		N.Gokulanand	For zone map changes.
***********************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgGroupInfoAdmin" %>
<%@ page import="com.eg.IniFile" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.util.StringUtils"%>
<%@ page import="net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	 JSONObject rootJson = new JSONObject();
	 JSONObject screenLabels = new JSONObject();
	 JSONObject zoneObj = new JSONObject();
	 JSONArray zoneArr = new JSONArray();

	 

	//http://dev.sencha.com/deploy/ext-4.0.0/examples/window/gmap.html
	//http://technet.microsoft.com/en-us/library/ff686791(v=office.14).aspx

	/*session.setAttribute("egPageDesc","EgDispZones.jsp");
	session.setAttribute("egBackComplete","/final/admin/EgDispZones.jsp");
	//session.setAttribute("egTitlehref", "/final/admin/EgAddZone.jsp");
	session.setAttribute("egTitlehref", "/final/admin/EgComponentZones.jsp?mode=add");*/
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	String strVarArr[] = groupinfo.getZoneNames();
	if (strVarArr==null)
		strVarArr=new String[0];
	session.setAttribute("existing_names",strVarArr);
	String searchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =searchStr!=null&&!searchStr.equals("");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(searchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
	String reqfrom = request.getParameter("reqfrom");
	reqfrom = (reqfrom == null ?"":reqfrom);

	IniFile				topoIni		=	new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_group.ini");
	//String				strVarArr[]	=	groupinfo.getZoneNames();

	if(strVarArr.length > 0)
	//if (false)
	{
		Vector searchVec=new Vector();
		boolean searchItemFound = false;
		String thisZone="";
		for(int i=0;i<strVarArr.length;i++)
		{
			thisZone = strVarArr[i];
			if (isSearchResult && !doesExist(searchList, thisZone))
				continue;
			else
				searchVec.add(thisZone);
			searchItemFound=true;
		}
		int x=searchVec.size();
		String lastvalue="";
		String tdclass="form_border";
		if(x!=0)
		{
			lastvalue=(String)searchVec.get(x-1);
		}
		if(searchVec.size()!=0)
		{

		}
		List zoneList = new ArrayList();
		for(int i=0;i<strVarArr.length;i++)
		{
			thisZone = strVarArr[i];
			if (isSearchResult && !doesExist(searchList, thisZone))
				continue;
			zoneList.add(thisZone);
			searchItemFound=true;
		}
		Collections.sort(zoneList,String.CASE_INSENSITIVE_ORDER);
		int zoneListSize = zoneList.size();
		for(int i=0;i<zoneListSize;i++)
		{
			boolean border = (i+1)<zoneListSize;
			boolean spacing = (i+1)<zoneListSize;
			thisZone = (String)zoneList.get(i);
			String mainZone = groupinfo.getMainZone(thisZone);
			boolean isDisabled = (!(mainZone==null) && !(mainZone.equals("")));
			String disabledStr = isDisabled?"DISABLED":"";
			String thisTdClass=border?"form_border":"padding4";
			if(lastvalue.equalsIgnoreCase(thisZone))
			{
				tdclass="form_spacing";
			}
			zoneObj.put("Zonename",thisZone);
			// Get display image for this zone
			String imageValue = topoIni.getValue("ZONE_DISPLAY_IMAGE",thisZone);
			zoneObj.put("ImageName",imageValue);
			
			screenLabels.put("deleteConfirmMessage1",_mapping.getTextDescription("admin.zone.Are you sure you want to delete '"));
			screenLabels.put("deleteConfirmMessage2",_mapping.getTextDescription("admin.zone.' zone?"));
			String tmpStr = "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\" align=\"center\">";
			if(isDisabled)
			{
				//tmpStr=tmpStr+"<tr height='6'></tr><tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'><i>This zone is associated with the following</i></td></tr><tr height='5'></tr>";
			}
			else
			{
				tmpStr=tmpStr+"<tr><td width='100%' align='left' nowrap style='font-size:8pt;font-weight:normal;'>-</td></tr>";
				//tmpStr=tmpStr+" - ";
			}
			if (isDisabled)
			{
				zoneObj.put("isDisabled","true");
				if(mainZone!=null&&!mainZone.equals(""))
				{
					mainZone = StringUtils.replace(mainZone,"<br>",",");
					if(mainZone.endsWith(","))
						mainZone = mainZone.substring(0,mainZone.length()-1);
				}
				StringTokenizer stz= new StringTokenizer(mainZone,",");
				int tokCount = stz.countTokens();
				tmpStr = tmpStr + "<tr><td width='70' style='font-size:8pt;font-weight:normal;vertical-align:middle'><i>";
				if(tokCount>1)
					tmpStr = tmpStr + "Master Zones";
				else
					tmpStr = tmpStr + "Master Zone";
				tmpStr = tmpStr +"</i></td>";
				tmpStr = tmpStr+"<td width='5' class='eg_subcontent'>:</td><td>";
				tmpStr = tmpStr+"<table cellpadding='0'><tr>";
				int cc=0;
				
				while(stz.hasMoreTokens())
				{
					String zToken = stz.nextToken();
					tmpStr=tmpStr+"<td><a class='eg_monlink' href=\"/final/admin/EgComponentZones.jsp?qctr=0&zone="+EgURLEncoder.encode(zToken,"UTF-8")+"&mode=modify&returnToMain=true&mainUrl=EgComponentZones.jsp\" id='mouse' style='font-weight:normal;text-decoration:none;vertical-align:middle'>&nbsp;"+zToken+"</a></td>";
					if(cc!=(tokCount-1))
					{
						tmpStr = tmpStr +"<td class='eg_subcontent'>,</td>";
					}
					cc++;
				}
				tmpStr=tmpStr+"</tr></table>";
			}
			else
			{
				zoneObj.put("isDisabled","false");
			}
			tmpStr = tmpStr + "</td></tr><tr height='5'></tr></table>";
			zoneObj.put("associations",tmpStr);
			//System.out.println("tmpStr >>>>>> "+tmpStr);
			zoneArr.add(zoneObj);
		}
		if (!searchItemFound)
		{
			screenLabels.put("searchResult",_mapping.getTextDescription("admin.group.No zone(s) found for your current search"));
			screenLabels.put("searchKey",searchStr);
		}

		if(searchVec.size()!=0)
		{
		}
		rootJson.put("NoExtFound","false");
	}
	else
	{
		screenLabels.put("noZone",_mapping.getTextDescription("admin.group.There are no zones available currently"));	
		rootJson.put("NoExtFound","true");
	}
	session.removeAttribute("zoneMessage");

%>
		
<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>
<%
if(request.getQueryString()!=null)
session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentZones.jsp?"+request.getQueryString());
else session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentZones.jsp");

	screenLabels.put("deleteforSelectedMessage",_mapping.getTextDescription("admin.group.Are you sure you want to delete the selected zone(s)?"));
	screenLabels.put("no zone selected",_mapping.getTextDescription("admin.group.No zone(s) have been selected"));
	
	// Rename labels
	screenLabels.put("sameName",_mapping.getTextDescription("admin.zone.Zone names are identical")+". "+_mapping.getTextDescription("admin.zone.Please use different name for the zone"));
	screenLabels.put("admin.common.space not allowed",_mapping.getTextDescription("admin.common.Space is not allowed in Zone name "));
	screenLabels.put("admin.common.special characters not allowed",_mapping.getTextDescription("admin.common.Special characters are not allowed"));
	screenLabels.put("admin.common.field value cannot be blank",_mapping.getTextDescription("admin.common.Field value cannot be blank."));
	screenLabels.put("admin.common.DBL not allowed",_mapping.getTextDescription("admin.common.Zone name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte."));

	rootJson.put("screenLabels",screenLabels);
	rootJson.put("gridValues",zoneArr);
	rootJson.put("isDouble",EgDbInfo.doubleByteEnabled);	
	out.println(rootJson.toString());
%>

