<%@ include file="../../EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import ="com.egurkha.admin.EnableDisableTests" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="net.sf.json.JSONObject" %>
<%@ page import="net.sf.json.JSONArray" %>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
	
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgMgrUpgradeInfo egUpgrade = new EgMgrUpgradeInfo();
	String selectedCType = request.getParameter("selectedCType");
	String selectedTestTypes = request.getParameter("selectedTestTypes");
	String selNewTest = request.getParameter("newTestTypes"); 
	String selDelTest = request.getParameter("delTestTypes"); 

	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	boolean isConfig = false;
	HashMap testListMap = new HashMap();
	testListMap = egUpgrade.getUpgradeTestsDetails(selectedCType,selectedTestTypes);

	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	if(selectedTestTypes.equalsIgnoreCase("ConfigurationTest"))
	{
		isConfig = true;
	}

	ArrayList enabledTest = new ArrayList();
	enabledTest = specsInfo.getEnabledTests(selectedCType,isConfig);

	if (selNewTest != null && selNewTest != "")
	{
		String enableSelTest = "";
		int enableSelTestSize = enabledTest.size();
		for(int l =0 ; l< enableSelTestSize ; l++)
		{
			enableSelTest += (String)enabledTest.get(l) + ",";
		}

		enableSelTest += selNewTest;

		if (_user != null && isConfigSupported)
		{
			EgUserRole userRole = _user.getUserRole();
			isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
		}
		EnableDisableTests objEnabDisableTest = new EnableDisableTests(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId()) ;
		objEnabDisableTest.setConfigSupported(isConfigSupported);
		
		objEnabDisableTest.setParams(
			selectedCType,
			enableSelTest,
			selDelTest,
			selectedTestTypes
		);
		objEnabDisableTest.setReqFrom("upgrade");
		
		String updatedResult = objEnabDisableTest.doProcess();
		selNewTest = selNewTest.trim();
		StringTokenizer selNewTestTkns = new StringTokenizer(selNewTest, ",");
		String[] selNewTestArr = new String[selNewTestTkns.countTokens()];
		for (int i=0; i<selNewTestArr.length ; i++ )
		{
			if (selNewTestTkns.hasMoreTokens()){
				String newTkns = (String)selNewTestTkns.nextToken();
				selNewTestArr[i] = newTkns;
			}
		} 
		ArrayList selNewTestList = new ArrayList(Arrays.asList(selNewTestArr));
		egUpgrade.removeTests("NEW_TESTS",selectedCType,selNewTestList);
	}
	
	if(selDelTest!= null)
	{
		selDelTest = selDelTest.trim();
		StringTokenizer selDelTestTkns = new StringTokenizer(selDelTest, ",");
		String[]  selDelTestArr = new String[selDelTestTkns.countTokens()];
		for (int i=0; i<selDelTestArr.length ; i++ )
		{
			if (selDelTestTkns.hasMoreTokens()){
				String tkns = (String)selDelTestTkns.nextToken();
				selDelTestArr[i] = tkns;
			}
		}
		
		ArrayList selDelTestList = new ArrayList(Arrays.asList(selDelTestArr));
		EnableDisableTests objDeleteTest = new EnableDisableTests(_user.getLoginID(),_user.getUserIP(session.getId()),session.getId()) ;
		objDeleteTest.setConfigSupported(isConfigSupported);

		enabledTest.removeAll(selDelTestList);

		String enableSelTest = "";
		int enableSelTestSize = enabledTest.size();
		for(int l =0 ; l< enableSelTestSize ; l++)
		{
			if (l == (enableSelTestSize - 1))
				enableSelTest += (String)enabledTest.get(l);
			else
				enableSelTest += (String)enabledTest.get(l) + ",";
		}
		
		objDeleteTest.setParams(
			selectedCType,
			enableSelTest,
			selDelTest,
			selectedTestTypes
		);
		objDeleteTest.setReqFrom("upgrade");

		String updatedResult = objDeleteTest.doProcess();
		egUpgrade.updateIniFiles(selectedCType, selDelTestList);
		egUpgrade.removeTests("DELETED_TESTS",selectedCType,selDelTestList);
	}
	
	ArrayList serverList = null;

	JSONObject newTestObj = new JSONObject();
	JSONObject delTestObj = new JSONObject();
	
	JSONArray newTestArr = new JSONArray();
	JSONArray delTestArr = new JSONArray();

	Iterator it = testListMap.keySet().iterator();
	while (it.hasNext())
	{
		String compTypeSection = (String)it.next();
		if(compTypeSection.equalsIgnoreCase("NEW_TESTS"))
		{
			ArrayList test = (ArrayList)testListMap.get(compTypeSection);
			serverList = sorter.getSortedTestList(test);
			for (int j=0;j<serverList.size();j++)
				{
					EgName nameObj = (EgName)serverList.get(j);
					String tmpVal = nameObj.getActualName();
					String tmpDis = nameObj.getLocalName();

					newTestObj.put("displayField",tmpDis);
					newTestObj.put("valueField",tmpVal);
					newTestArr.add(newTestObj);
				}
		}
		else if(compTypeSection.equalsIgnoreCase("DELETED_TESTS"))
		{
			ArrayList delTestList = (ArrayList)testListMap.get(compTypeSection);
			serverList = sorter.getSortedTestList(delTestList);
			for (int j=0;j<serverList.size();j++)
			{
				EgName nameObj = (EgName)serverList.get(j);
				String tmpVal = nameObj.getActualName();
				String tmpDis = nameObj.getLocalName();

				delTestObj.put("displayField",tmpDis);
				delTestObj.put("valueField",tmpVal);
				delTestArr.add(delTestObj);
			}
		}
	}
	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.TESTS"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.The selected test has been enabled successfully")+".");
	resultMsg.put("message2",_mapping.getTextDescription("admin.test.The selected tests have been enabled successfully")+".");
	resultMsg.put("message3",_mapping.getTextDescription("admin.test.The selected test has been deleted successfully")+".");
	resultMsg.put("message4",_mapping.getTextDescription("admin.test.The selected tests have been deleted successfully")+".");
	rootJson.put("result",resultMsg);
	rootJson.put("newTestArr", newTestArr);
	rootJson.put("delTestArr", delTestArr);
	out.println(rootJson.toString());

%>
