
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.egurkha.admin.EgTestSpecification" %>
<%@ page import="com.eg.EgRoleInfo" %>
<%@ page import="java.util.*" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.eg.MappingNameSorter" %>
<%@ page import="com.eg.EgName" %>
<%@ page import="com.egurkha.admin.UpdateTestPeriod"%>

<%@ taglib prefix="egui" uri="../../../WEB-INF/eg-taglib.tld" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	//will sort the list containing unconfigured test to there maximum unconfigured params
	public ArrayList sortTestList(ArrayList aList,MappingNameSorter sorter)
	{
		ArrayList aListSortedTest = new ArrayList();
		TreeMap tmapTestCount = new TreeMap(Collections.reverseOrder());
		for (int i=0;i<aList.size();i++)
		{
			String str = ((String)aList.get(i)).trim();
			String strTest = str.substring(0,str.indexOf("#"));
			String strCount = str.substring(str.indexOf("#")+1,str.length());
			Integer tempIntObj = new Integer(strCount.trim());
			ArrayList aListStrTemp = (ArrayList)tmapTestCount.get(tempIntObj);
			if (aListStrTemp == null)
			{
				aListStrTemp = new ArrayList();
				aListStrTemp.add(strTest);
				tmapTestCount.put(tempIntObj,aListStrTemp);
			}
			else
			{
				aListStrTemp.add(strTest);
			}
		}

		Iterator itrTestCount = tmapTestCount.keySet().iterator();
		int tempCount = 0;
		int[] nums = new int[tmapTestCount.size()];
		while (itrTestCount.hasNext())
		{
			Integer tempInteger = (Integer)itrTestCount.next();
			nums[tempCount] = tempInteger.intValue();
			tempCount++;
		}

		for (int i=0;i<nums.length;i++)
		{
			Integer tempInteger = new Integer(nums[i]);
			ArrayList aListTempTest = (ArrayList)tmapTestCount.get(tempInteger);
			boolean isSorterNeeded = (aListTempTest.size() > 1);
			if (isSorterNeeded)
			{
				aListTempTest = sorter.getSortedTestList(aListTempTest);
				for (int j=0;j<aListTempTest.size();j++)
				{
					EgName nameObj = (EgName)aListTempTest.get(j);
					String strTest = nameObj.getActualName();
					aListSortedTest.add(strTest + "#" + nums[i]);
				}
			}
			else
			{
				String strTest = (String)aListTempTest.get(0);
				aListSortedTest.add(strTest + "#" + nums[i]);
			}
		}

		return aListSortedTest;
	}

	public TreeMap getSortedData(TreeMap tmap,MappingNameSorter sorter,String componentType)
	{
		//will contain tests in treemap in sorted order
		TreeMap tmapResultantUnconfigTest = new TreeMap();
		//contains unconfigured tests count as key and corresponding componentType as value.
		TreeMap tmapTestCount = new TreeMap(Collections.reverseOrder());

		Iterator itrCompTypeUnConfigTests = tmap.keySet().iterator();
		while (itrCompTypeUnConfigTests.hasNext())
		{
			String tempCompType = (String)itrCompTypeUnConfigTests.next();
			TreeMap tmapUnConfigComp = (TreeMap)tmap.get(tempCompType);
			Iterator itrUnConfigComp = tmapUnConfigComp.keySet().iterator();
			TreeMap tmapOrderedComponents = new TreeMap();
			int tempTestCount = 0;
			while (itrUnConfigComp.hasNext())
			{
				String tempCompName = (String)itrUnConfigComp.next();
				ArrayList aListUnConfigTests = (ArrayList)tmapUnConfigComp.get(tempCompName);
				ArrayList aListUnConfigPerTest = (ArrayList)aListUnConfigTests.get(0);
				if (!aListUnConfigPerTest.isEmpty())
				{
					tempTestCount = tempTestCount + aListUnConfigPerTest.size();
					aListUnConfigPerTest = sortTestList(aListUnConfigPerTest,sorter);
				}
				ArrayList aListUnConfigConTest = (ArrayList)aListUnConfigTests.get(1);
				if (!aListUnConfigConTest.isEmpty())
				{
					tempTestCount = tempTestCount + aListUnConfigConTest.size();
					aListUnConfigConTest = sortTestList(aListUnConfigConTest,sorter);
				}
				ArrayList aListOrderedTest = new ArrayList();
				aListOrderedTest.add(aListUnConfigPerTest);
				aListOrderedTest.add(aListUnConfigConTest);
				tmapOrderedComponents.put(tempCompName,aListOrderedTest);
			}
			tmapResultantUnconfigTest.put(tempCompType,tmapOrderedComponents);

			Integer intCountObj = new Integer(tempTestCount);
			ArrayList aListTempCompType = (ArrayList)tmapTestCount.get(intCountObj);
			if (aListTempCompType == null)
			{
				aListTempCompType = new ArrayList();
				aListTempCompType.add(tempCompType);
				tmapTestCount.put(intCountObj,aListTempCompType);
			}
			else
			{
				aListTempCompType.add(tempCompType);
			}
		}

		ArrayList aListOrderedCompTypes = new ArrayList();
		if (!componentType.equals(""))
		{
			aListOrderedCompTypes.add(componentType);
		}

		boolean isCompTypeFound = false;
		Iterator itrTestCount = tmapTestCount.keySet().iterator();
		while (itrTestCount.hasNext())
		{
			Integer tempCount = (Integer)itrTestCount.next();
			ArrayList aListTempCompTypes = (ArrayList)tmapTestCount.get(tempCount);

			if (!isCompTypeFound && !componentType.equals(""))
			{
				if (aListTempCompTypes.contains(componentType))
				{
					aListTempCompTypes.remove(componentType);
					isCompTypeFound = true;
				}
			}

			aListOrderedCompTypes.addAll(aListTempCompTypes);
		}

		TreeMap tmapResultant = new TreeMap();
		tmapResultant.put("aListOrderedCompTypes",aListOrderedCompTypes);
		tmapResultant.put("resultantUnconfigTest",tmapResultantUnconfigTest);
		return tmapResultant;
	}
%>

<%
	EgRoleInfo ri = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	IniUI iniUI = IniUI.getInstance();
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);
	List listManagedComponents = ri.getAllServers();
	EgTestSpecification egTestSpecification = new EgTestSpecification(listManagedComponents);
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;
	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
		egTestSpecification.setConfigSupported(isConfigSupported);
	}

	//variables for unConfiguredSummary - starts
	String componentType = null;
	String showTestType = null;
	//variables for unConfiguredSummary - ends

	//variables for testconfiguration - starts
	String componentName = null;
	//variables for testconfiguration - ends

	String fromPage = request.getParameter("fromPage");
	String showAggTestsStr = request.getParameter("showAggTests");
	boolean fromUnConfiguredSummary = false;
	boolean fromProceedingSignOut = false;
	boolean fromTestConfiguration = false;
	boolean fromLimitedCompAccess = false;
	boolean showAggTests = false;
	if (fromPage != null)
	{
		if (fromPage.equalsIgnoreCase("unConfiguredSummary"))
		{
			fromUnConfiguredSummary = true;
		}
		else if (fromPage.equalsIgnoreCase("proceedingSignout"))
		{
			fromProceedingSignOut = true;
		}
		else if (fromPage.equalsIgnoreCase("testConfiguration"))
		{
			fromTestConfiguration = true;
		}
		else if (fromPage.equalsIgnoreCase("limitedCompAccess"))
		{
			fromLimitedCompAccess = true;
		}
		if (showAggTestsStr != null && showAggTestsStr.equalsIgnoreCase("true"))
		{
			showAggTests = true;
		}
	}
	if (fromUnConfiguredSummary)
	{
		componentType = request.getParameter("componentType");
		showTestType = request.getParameter("showTestType");
	}
	else if (fromTestConfiguration)
	{
		componentType = request.getParameter("componentType");
		showTestType = request.getParameter("showTestType");
		componentName = request.getParameter("componentName");
		if (componentName == null)
		{
			componentName = "";
		}
		else if (componentName != null && componentName.equals("-1"))
		{
			componentName = "";
		}
	}

	if (componentType == null)
	{
		componentType = "";
	}
	else if (componentType != null && componentType.equals("-1"))
	{
		componentType = "";
	}

	if (showTestType == null)
	{
		showTestType = "";
	}
	else if (showTestType != null && showTestType.equals("-1"))
	{
		showTestType = "";
	}

	TreeMap tmapUnConfigTests = (TreeMap)egTestSpecification.getUnconfiguredTest();
	int totalTestCount = egTestSpecification.getTotalUnconfiguredTestsCount();
	TreeMap tmapResultant = getSortedData(tmapUnConfigTests,sorter,componentType);
	TreeMap tmapResultantUnconfigTests = (TreeMap)tmapResultant.get("resultantUnconfigTest");
	ArrayList aListOrderedCompType = (ArrayList)tmapResultant.get("aListOrderedCompTypes");

	Vector aggregateTestDetails = null;
	ArrayList aListAggTestCountsList = null;
	TreeMap tmapAggregateDetails = null;
	TreeMap tmapAggregareTestCounts = null;
	int aggregateTestCount = 0;
	if ((showAggTests || fromProceedingSignOut) && EgInstallInfo.isAggregationSupported())
	{
		boolean hasAggregateComponent = false;
		for (int i=0;i<listManagedComponents.size();i++)
		{
			String strComponent = (String)listManagedComponents.get(i);
			String strCompType = strComponent.substring(0,strComponent.indexOf(":"));
			if (strCompType.startsWith("Agg_"))
			{
				hasAggregateComponent = true;
				break;
			}
		}

		if (hasAggregateComponent)
		{
			aggregateTestDetails = new UpdateTestPeriod().getAggregateTestsWithoutRecommendedTestPeriod();
			aggregateTestCount = (aggregateTestDetails != null && aggregateTestDetails.size() > 0)?aggregateTestDetails.size():aggregateTestCount;
		}

		if (aggregateTestCount != 0)
		{
			aListAggTestCountsList = new ArrayList();
			tmapAggregateDetails = new TreeMap();
			tmapAggregareTestCounts = new TreeMap();

			for (int i=0;i<aggregateTestCount;i++)
			{
				String strAggTestDetail = (String)aggregateTestDetails.get(i);
				int idx = strAggTestDetail.indexOf(":");
				String strTest = strAggTestDetail.substring(0,idx);
				String strComponentDetails = strAggTestDetail.substring(idx+1);
				idx = strComponentDetails.indexOf(":");
				String strComponentType = strComponentDetails.substring(0,idx);
				String strComponent = strComponentDetails.substring(idx+1);

				TreeMap tmapAggregateComponents = (TreeMap)tmapAggregateDetails.get(strComponentType);
				if (tmapAggregateComponents == null)
				{
					tmapAggregateComponents = new TreeMap();
					ArrayList aListAggregateTests = new ArrayList();
					aListAggregateTests.add(strTest);
					tmapAggregateComponents.put(strComponent,aListAggregateTests);
					tmapAggregateDetails.put(strComponentType,tmapAggregateComponents);
				}
				else
				{
					ArrayList aListAggregateTests = (ArrayList)tmapAggregateComponents.get(strComponent);
					if (aListAggregateTests == null)
					{
						aListAggregateTests = new ArrayList();
						aListAggregateTests.add(strTest);
						tmapAggregateComponents.put(strComponent,aListAggregateTests);
					}
					else
					{
						aListAggregateTests.add(strTest);
					}
				}
			}
			totalTestCount = totalTestCount + aggregateTestCount;

			Iterator itrAggComponentType = tmapAggregateDetails.keySet().iterator();
			while (itrAggComponentType.hasNext())
			{
				String strAggComponentType = (String)itrAggComponentType.next();
				TreeMap tmapAggComponents = (TreeMap)tmapAggregateDetails.get(strAggComponentType);
				Iterator itrAggComponents = tmapAggComponents.keySet().iterator();
				int aggTestCount = 0;
				while (itrAggComponents.hasNext())
				{
					String strAggComponent = (String)itrAggComponents.next();
					ArrayList aListAggTests = (ArrayList)tmapAggComponents.get(strAggComponent);
					aggTestCount = aggTestCount + aListAggTests.size();
				}
				Integer intObj = new Integer(aggTestCount);
				if (!aListAggTestCountsList.contains(intObj))
				{
					aListAggTestCountsList.add(intObj);
				}
				ArrayList aListAggCompTypes = (ArrayList)tmapAggregareTestCounts.get(intObj);
				if (aListAggCompTypes == null)
				{
					aListAggCompTypes = new ArrayList();
					aListAggCompTypes.add(strAggComponentType);
					tmapAggregareTestCounts.put(intObj,aListAggCompTypes);
				}
				else
				{
					aListAggCompTypes.add(strAggComponentType);
				}
			}
			Collections.sort(aListAggTestCountsList);
			Collections.reverse(aListAggTestCountsList);
		}
	}
%>

<style>
.tableborder_ad table td{font-size:11px}
</style>
<form name="unconfigtest" style="margin:0px;width:100%">
<%
	if (fromProceedingSignOut)
	{
%>
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td width="100%" valign="top" align="right" class="fontSize13bold" style="padding-bottom:12px"><a class="body_link" href="EgLogoutA.jsp?proceed=yes" target="_parent"><egui:intnl text="admin.unconfig.Proceed to Signout"/>&nbsp;<img src="/final/admin/eg_images/arrow.gif" border="0"></a></td>
			</tr>
		</table>
<%
	}

	for (int z=0;z<aListOrderedCompType.size();z++)
	{
		String strCompType = (String)aListOrderedCompType.get(z);
		TreeMap tmapCompTypeUnConfigTest = (TreeMap)tmapResultantUnconfigTests.get(strCompType);
		if (tmapCompTypeUnConfigTest == null)
		{
			continue;
		}
%>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="tableborder_ad darkborder_monitor">
			<tr>
				<td valign="top">
					<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="eg_morelight ">
						<tr>
							<td width="100%" height="20" align="center" class="font_bold12 currentalarmlabel table_head"><egui:intnl text="admin.test.List of unconfigured tests for"/>&nbsp;'<%=_mapping.getComponentTypeDescription(strCompType)%>'</td>
						</tr>
					</table>
				</td>
			</tr>
<%
		ArrayList aListComponents = new ArrayList();
		Iterator itrCompTypeUnConfigTest = tmapCompTypeUnConfigTest.keySet().iterator();
		while (itrCompTypeUnConfigTest.hasNext())
		{
			String tempComponent = (String)itrCompTypeUnConfigTest.next();
			aListComponents.add(tempComponent);
		}

		for (int m=0;m<aListComponents.size();m++)
		{
			String tempComponent = (String)aListComponents.get(m);

			String displayComponentName = null;
			if (tempComponent.indexOf(":NULL") > -1)
			{
				displayComponentName = tempComponent.substring(0,tempComponent.indexOf(":"));
			}
			else
			{
				displayComponentName = tempComponent;
			}

			ArrayList aListUnconfiguredTestList = (ArrayList)tmapCompTypeUnConfigTest.get(tempComponent);
			if (strCompType.equals(componentType) && 
				tempComponent.equals(componentName) && 
				aListUnconfiguredTestList == null)
			{
				continue;
			}

			ArrayList aListPerformanceTests = (ArrayList)aListUnconfiguredTestList.get(0);
			ArrayList aListConfigurationTests = (ArrayList)aListUnconfiguredTestList.get(1);
			boolean isPerformanceTestsEmpty = aListPerformanceTests.isEmpty();
			boolean isConfigurationTestsEmpty = aListConfigurationTests.isEmpty();

			if (fromProceedingSignOut || fromLimitedCompAccess)
			{
				if (isConfigSupported)
				{
					if (!isPerformanceTestsEmpty && 
						!isConfigurationTestsEmpty)
					{
						showTestType = "perTestAndConTest";
					}
					else if (!isPerformanceTestsEmpty && 
							isConfigurationTestsEmpty)
					{
						showTestType = "perTest";
					}
					else if (isPerformanceTestsEmpty && 
							!isConfigurationTestsEmpty)
					{
						showTestType = "conTest";
					}
				}
				else
				{
					if (!isPerformanceTestsEmpty)
					{
						showTestType = "perTest";
					}
				}
			}

			if (!isPerformanceTestsEmpty)
			{
%>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td class="font_bold11 table_head configure_left" height="20" style="padding:4px">
								<div style="float:left">
<%
				if (isConfigSupported)
				{
%>
										&nbsp;<egui:intnl text="admin.test.Performance"/>
<%
				}
				else
				{
%>
										&nbsp;
<%
				}
%>
								</div>
								<div style="float:right"><%=displayComponentName%>&nbsp;</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>

			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table align="center" border="0" width="100%" class="tableborder_ad" cellpadding="4" cellspacing="0"><col width="33%"><col width="33%"><col width="34%">
<%
				for (int i=0;i<aListPerformanceTests.size();i=i+3)
				{
%>
						<tr class="configborder_solid">
<%
					for (int j=i;j<i+3;j++)
					{
						if (j < aListPerformanceTests.size())
						{
							String strTempTest = (String)aListPerformanceTests.get(j);
							strTempTest = strTempTest.substring(0,strTempTest.indexOf("#"));
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;<a class="eg_monlink" href="javascript:void(0)" onClick="callTcPage('EgSpecificTestConfiguration.jsp?reqfrom=UnconfigTests&componentType=<%=EgURLEncoder.encode(strCompType,"UTF-8")%>&testType=PerformanceTest&clickedFrom=configurebutton&testName=<%=EgURLEncoder.encode(strTempTest,"UTF-8")%>&componentName=<%=EgURLEncoder.encode(tempComponent,"UTF-8")%>&showTestType=<%=EgURLEncoder.encode(showTestType,"UTF-8")%>')" id="mouse" target="main"><%=_mapping.getTestDescription(strTempTest)%></a></td>
<%
						}
						else
						{
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;</td>
<%
						}
					}
%>
						</tr>
<%
				}
%>
					</table>
				</td>
			</tr>
<%
			}

			if (isConfigSupported && !isConfigurationTestsEmpty)
			{
%>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td class="font_bold11 table_head configure_left" height="20" style="padding:4px"><div style="float:left">&nbsp;<egui:intnl text="admin.test.Configuration"/></div><div style="float:right"><%=displayComponentName%>&nbsp;</div></td>
						</tr>
					</table>
				</td>
			</tr>

			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table border="0" class="tableborder_ad" style="border-bottom-width:0px" cellpadding="4" cellspacing="0" width="100%" align="center"><col width="33%"><col width="33%"><col width="34%">
<%
				for (int i=0;i<aListConfigurationTests.size();i=i+3)
				{
%>
						<tr class="configborder_solid">
<%
					for (int j=i;j<i+3;j++)
					{
						if (j < aListConfigurationTests.size())
						{
							String strTempTest = (String)aListConfigurationTests.get(j);
							strTempTest = strTempTest.substring(0,strTempTest.indexOf("#"));
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;<a class="eg_monlink" href="javascript:void(0)" onClick="callTcPage('EgSpecificTestConfiguration.jsp?reqfrom=UnconfigTests&componentType=<%=EgURLEncoder.encode(strCompType,"UTF-8")%>&testType=ConfigurationTest&clickedFrom=configurebutton&testName=<%=EgURLEncoder.encode(strTempTest,"UTF-8")%>&componentName=<%=EgURLEncoder.encode(tempComponent,"UTF-8")%>&showTestType=<%=EgURLEncoder.encode(showTestType,"UTF-8")%>')" id="mouse" target="main"><%=_mapping.getTestDescription(strTempTest)%></a></td>
<%
						}
						else
						{
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;</td>
<%
						}
					}
%>
						</tr>
<%
				}
%>
					</table>
				</td>
			</tr>
<%
			}
		}
%>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
		</table>
		<table>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
		</table>
<%
	}

	if ((showAggTests || fromProceedingSignOut) && aggregateTestCount != 0)
	{
		for (int i=0;i<aListAggTestCountsList.size();i++)
		{
			Integer intObj = (Integer)aListAggTestCountsList.get(i);
			ArrayList aListAggComponentTypes = (ArrayList)tmapAggregareTestCounts.get(intObj);
			for (int j=0;j<aListAggComponentTypes.size();j++)
			{
				String strAggComponentType = (String)aListAggComponentTypes.get(j);
%>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" class="tableborder_ad">
			<tr>
				<td valign="top" height="100%">
					<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
						<tr>
							<td valign="top">
								<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0" style="padding:0px">
									<tr>
										<td width="100%" height="20" align="center" class="font_bold12 currentalarmlabel table_head"><egui:intnl text="admin.unconfig.List of tests running below recommended test period for"/>&nbsp;'<%=_mapping.getComponentTypeDescription(strAggComponentType)%>'</td>
									</tr>
								</table>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
<%
				TreeMap tmapAggComponents = (TreeMap)tmapAggregateDetails.get(strAggComponentType);
				Iterator itrAggComponents = tmapAggComponents.keySet().iterator();
				while (itrAggComponents.hasNext())
				{
					String tempAggregateComponent = (String)itrAggComponents.next();
					String displayComponentName = null;
					if (tempAggregateComponent.indexOf(":NULL") > 1)
					{
						displayComponentName = tempAggregateComponent.substring(0,tempAggregateComponent.indexOf(":"));
					}
					else
					{
						displayComponentName = tempAggregateComponent;
					}

					ArrayList aListAggregateTests = (ArrayList)tmapAggComponents.get(tempAggregateComponent);
%>
			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table align="center" border="0" cellpadding="0" cellspacing="0" width="100%">
						<tr>
							<td class="font_bold11 table_head configure_left" height="20" style="padding:4px">
								<div style="float:left">
<%
					if (isConfigSupported)
					{
%>
											&nbsp;<egui:intnl text="admin.test.Performance"/>
<%
					}
					else
					{
%>
											&nbsp;
<%
					}
%>
								</div>
								<div style="float:right"><%=displayComponentName%></div>
							</td>
						</tr>
					</table>
				</td>
			</tr>

			<tr>
				<td style="padding:0px 20px 0px 20px">
					<table border="0" class="tableborder_ad" style="border-bottom-width:0px" cellpadding="4" cellspacing="0" width="100%" align="center"><col width="33%"><col width="33%"><col width="34%">
<%
					for (int m=0;m<aListAggregateTests.size();m=m+3)
					{
%>
						<tr class="configborder_solid">
<%
						for (int n=m;n<m+3;n++)
						{
							if (n < aListAggregateTests.size())
							{
								String strTempTest = (String)aListAggregateTests.get(n);
								String aggComponent = strAggComponentType + ":" + tempAggregateComponent;
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;<a class="eg_monlink" href="javascript:void(0)" onClick="callTcPage('aggUpdateTestPeriod.jsp?reqfrom=UnconfigTests&selectedServer=<%=strAggComponentType%>&selectedComponent=<%=EgURLEncoder.encode(aggComponent,"UTF-8")%>')" id="mouse" target="main"><%=_mapping.getTestDescription(strTempTest)%></a></td>
<%
							}
							else
							{
%>
							<td class="tdborder_ad" valign="top" style="width:250px">&nbsp;</td>
<%
							}
						}
%>
						</tr>
<%
					}
%>
					</table>
				</td>
			</tr>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
<%
				}
%>
		</table>
		<table>
			<tr>
				<td class="eg_blankspace" height="12">&nbsp;</td>
			</tr>
		</table>
<%
			}
		}
	}

	if (fromProceedingSignOut && totalTestCount > 30)
	{
%>
		<table width="100%" cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td width="100%" valign="top" align="right" class="fontSize13bold" style="padding-bottom:12px"><a class="body_link" href="EgLogoutA.jsp?proceed=yes" target="_parent"><egui:intnl text="admin.unconfig.Proceed to Signout"/>&nbsp;<img src="/final/admin/eg_images/arrow.gif" border="0"></a></td>
			</tr>
		</table>
<%
	}

	if (fromLimitedCompAccess && totalTestCount == 0)
	{
%>
		<table align="center" cellspacing="0" cellpadding="0" width="100%" border="0">
			<tr>
				<td width="100%" valign="top" height="100%">
					<table cellspacing="0" cellpadding="0" border="0" width="100%" height="400px">
						<tr>
<%
		if (listManagedComponents != null && listManagedComponents.size() > 0)
		{
%>
							<td align="center" valign="middle"><div class="iconInformation"></div><div class='commonErrorMsgText'><egui:intnl text="admin.unconfig.All tests are configured"/>.</div></td>
<%
		}
		else
		{
%>
							<td align="center" valign="middle"><div class="iconInformation"></div><div class='commonErrorMsgText'><egui:intnl text="admin.unconfig.No components have been assigned"/>.</div></td>
<%
		}
%>
						</tr>
					</table>
				</td>
			</tr>
		</table>
<%
	}
%>
</form>
</body>
</html>



