<%
/**********************************************************************************************************
*	Name			:	EgConfigTransJson.jsp
*	Purpose			:	To display transactions for a particular site.
*	Version			:	3.0
*	Creationdate	:	05/07/2000
*	Last Modified	:	05/11/2002	//Sandhya Kollath	-	Service
*							15/11/2003	//John Williams		-	eG 3.0 Layout Change
*	Author			:	Krishna Kumar.C
*	Design Changes	:	Jaiwin
******************************************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import ="egurkha.EgDbAdapterUI"%>
<%@ page import ="com.eg.EgDbAdapterTypeUI"%>
<%@ page import ="com.eg.EgTopoInfo"%>
<%@ page import ="com.eg.EgDbInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	EgDbAdapterUI egDb;
	boolean isDouble=EgDbInfo.doubleByteEnabled;
	rootJson.put("isDouble",isDouble);

	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult =egTitleSearchStr!=null&&!egTitleSearchStr.equals("");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
	public static ArrayList breakString(String givenString,int screenLen)
	{
		ArrayList aListResultant = new ArrayList();
		int strLen = givenString.length();
		int resLen = strLen/screenLen;
		int idx = 0;
		int k = 0;
		if (givenString.indexOf(" ")>-1)
		{
			for (int i=0;i<resLen;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				int s = res.length();
				if (res.charAt(s-1)==' ')
				{
					res = res.trim();
					aListResultant.add(res);
					idx = idx+screenLen;
				}
				else
				{
					k = res.lastIndexOf(" ");
					if (k==0 || k == -1)
					{
						aListResultant.add(res.substring(0));
						idx = idx+screenLen;
					}
					else
					{
						aListResultant.add(res.substring(0,k));
						String temp = res.substring(k);
						int m = temp.length();
						idx = idx+screenLen;
						idx = idx-m;
					}
				}
				if (i == resLen-1)
				{
					int lastLen = strLen-idx;
					if (lastLen > screenLen)
					{
						resLen = resLen+1;
					}
				}
			}
			String ss = givenString.substring(idx).trim();
			aListResultant.add(ss);
		}
		else
		{
			for (int i=0;i<resLen ;i++)
			{
				String res = givenString.substring(idx,idx+screenLen);
				aListResultant.add(res);
				idx = idx+screenLen;
			}
			aListResultant.add(givenString.substring(idx));
		}
		return aListResultant;
	}
%>

<%@ page import="java.util.*" %>
<%@ page import="java.sql.*" %>
<%
	String str_sitename="";
	String value1="";
	String mode="";
	String trans_name="";
	String sql_query="";
	ResultSet	rs=null;
	boolean b_state = false;
	String value="";
	String tempy="";
	String con_status="";
	String flag="";
	String str_filename="eg_topology.ini";
	String tran="";
	String tranlist="";
	int count=1;
	int trancount = 0;
	String str_trans="";
	EgTopoInfo topoinfo = new EgTopoInfo("manager");

	str_sitename=request.getParameter("site");
	//removal of physical topology
	//trans.createFile(str_filename);

	//removal of physical topology
	//String strVar[] = trans.getVariables("TRANSACTIONS");
	String strVar[] = topoinfo.getVariables("TRANSACTIONS");
	for(int i=0; i<strVar.length; i++)
	{
		strVar[i] = strVar[i].substring(0,strVar[i].lastIndexOf(":"));
		if(strVar[i].equals(str_sitename))
		{
			trancount++;
		}
	}

	session.setAttribute("title","TRANSACTION MANAGEMENT");
	JSONArray siteNameArray = new JSONArray();
	ArrayList aListStrValues = breakString(str_sitename,60);
	for (int m=0;m<aListStrValues.size();m++)
	{
		siteNameArray.add(aListStrValues.get(m));
	}
	rootJson.put("siteNameArray",siteNameArray);
	
	JSONArray transNameArray = new JSONArray();
	JSONObject transPageObject = new JSONObject();
	boolean searchItemFound = false;
	egDb=EgDbAdapterTypeUI.getObject();
	try
	{
		con_status=egDb.setConnection();
		if(con_status.equals("CONNECTED"))
		{
			sql_query="SELECT trans_name FROM egtransaction WHERE site_name='" + str_sitename + "' ORDER BY trans_name";
			rs=egDb.SelectExec(sql_query);
			b_state=egDb.getState();
			
			if(b_state==true)
			{
				str_trans="";
				if(rs!=null&&rs.isBeforeFirst())
				{
				
				}
				while(rs.next())
				{
					trans_name=rs.getString("TRANS_NAME");
					str_trans=str_trans + trans_name + ";";
					str_sitename = str_sitename.trim();
					tempy = str_sitename+ ":" + trans_name;
					value = topoinfo.getValue("TRANSACTIONS",tempy);
					boolean bordertd=true;
					String classtd="";
					if(bordertd)
					{
						classtd="form_spacing";
					}else
					{
						classtd="form_border";
					}
					//transNameArray.add(tempy);
					//transPageObject.put(tempy,value.replace('|',','));
					String deleteUrl = "Transactions/data/Egconfigtransp.jsp?site="+com.eg.EgURLEncoder.encode(str_sitename, "UTF-8")+"&trans="+com.eg.EgURLEncoder.encode(trans_name, "UTF-8")+"&mode=del";
					//transPageObject.put("transactionData",trans_name+":"+value.replace('|',','));
					//transPageObject.put("DeleteUrl",deleteUrl);
					
					if (isSearchResult && !doesExist(searchList, trans_name))
					{
						continue;
					}
					searchItemFound=true;

					transPageObject.put("Transactionname",trans_name);
					transPageObject.put("Pagesincluded",value.replace('|',','));
					transPageObject.put("DeleteUrl",deleteUrl);
					transNameArray.add(transPageObject);
					count=count+1;
				}//  while loop ends here
				if(rs!=null)
				{
				
				}
						rs.close();
						rs = null;
			}//if loop for b_state
		}// if(con_status.equals("CONNECTED")) ends here
		egDb.releaseConnection(false);
		EgDbAdapterTypeUI.releaseObject(egDb);
	} // End Of Try Block
	catch(Exception e)
	{
		e.printStackTrace();
		if(!con_status.equals("CONNECTED"))
		{
			out.println("Connection could not be established.");
		}
		else if(!(b_state==true))
		{
			out.println("Sql query exception.");
		}
		else
		{
			out.println("God's wish!");
		}
		out.println(e.getMessage());
		if (rs != null)
		{
			try 
			{
				rs.close();
			}
			catch (Exception bug123)
			{
			}
		}
		try
		{
			egDb.releaseConnection(true);
			EgDbAdapterTypeUI.releaseObject(egDb);
		}
		catch(Exception e1)
		{
		}
	}
	//rootJson.put("TransSiteNameArray",transNameArray);

	if (!searchItemFound&&egTitleSearchStr!=null&&!egTitleSearchStr.equals(""))
	{
		screenLabels.put("searchResult",_mapping.getTextDescription("admin.group.No Transaction found for your search"));
		screenLabels.put("searchKey",egTitleSearchStr);
	}
	// For panel
	screenLabels.put("panelHeader",_mapping.getTextDescription("admin.service.NEW TRANSACTION DETAILS"));
	screenLabels.put("shoppingImage","eg_images/"+admin_Skin+"/trans_shopping.gif");
	screenLabels.put("loginImage","eg_images/"+admin_Skin+"/trans_login.gif");
	screenLabels.put("searchImage","eg_images/"+admin_Skin+"/trans_search.gif");
	screenLabels.put("browseImage","eg_images/"+admin_Skin+"/trans_browse.gif");
	screenLabels.put("shippingImage","eg_images/"+admin_Skin+"/trans_shipping.gif");
	screenLabels.put("wmlImage","eg_images/"+admin_Skin+"/trans_wml.gif");
	screenLabels.put("imagesImage","eg_images/"+admin_Skin+"/trans_images.gif");
	screenLabels.put("businessImage","eg_images/"+admin_Skin+"/trans_business.gif");
	screenLabels.put("staticImage","eg_images/"+admin_Skin+"/trans_static.gif");
	screenLabels.put("dbtransferImage","eg_images/"+admin_Skin+"/trans_dbtransfer.gif");
	screenLabels.put("dbaccessImage","eg_images/"+admin_Skin+"/trans_dbaccess.gif");
	screenLabels.put("registerImage","eg_images/"+admin_Skin+"/trans_register.gif");
	screenLabels.put("paymentImage","eg_images/"+admin_Skin+"/trans_payment.gif");
	screenLabels.put("bidImage","eg_images/"+admin_Skin+"/trans_bid.gif");
	screenLabels.put("othersImage","eg_images/"+admin_Skin+"/trans_others.gif");

	JSONObject hiddenValues = new JSONObject();
	hiddenValues.put("site",str_sitename);
	hiddenValues.put("translist",str_trans);
	hiddenValues.put("trancount",trancount);
	rootJson.put("hiddenValues",hiddenValues);

	String queryString = request.getQueryString();
	String Qstring="";
	if(queryString!=null)
	{
		StringTokenizer strtok = new StringTokenizer(queryString,"&");
		while(strtok.hasMoreTokens())
		{
			String param = strtok.nextToken();
			int ind = param.indexOf("=");
			if (ind < 0)
				continue;
			String reqparam =param.substring(0,ind);
			String reqvalue = param.substring(ind+1);
			if(reqparam!=null&&reqparam.equals("site"))
			{
				reqvalue=com.eg.EgURLEncoder.encode(request.getParameter(reqparam), "UTF-8");
			}
			
			Qstring=Qstring+reqparam+"="+reqvalue+"&";
		}
	}
	/*if(Qstring!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentTransactions.jsp?"+Qstring);
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgComponentTransactions.jsp");
	}*/
		
	//Validation Msg
	screenLabels.put("admin.service.enter unique name",_mapping.getTextDescription("admin.service.Please enter unique transaction name"));
	screenLabels.put("admin.service.enter transaction name",_mapping.getTextDescription("admin.service.Please enter the transaction name"));
	screenLabels.put("admin.service.special characters not allowed",_mapping.getTextDescription("admin.service.Special characters are not allowed in transaction name"));
	screenLabels.put("admin.service.space not allowed",_mapping.getTextDescription("admin.service.Space is not allowed in transaction name"));
	screenLabels.put("admin.service.DBL not allowed",_mapping.getTextDescription("admin.ic.Transaction name is not allowed in DBL(Chinese,Korean,Japanese),since manager is SingleByte"));
	screenLabels.put("admin.service.enter pages associated",_mapping.getTextDescription("admin.service.Please enter the pages associated"));
	screenLabels.put("admin.service.pages included is not allowed in DBL",_mapping.getTextDescription("admin.service.Pages to be included is not allowed in DBL(Chinese,Korean,Japanese)"));
	screenLabels.put("admin.service.select image",_mapping.getTextDescription("admin.service.Please select the transaction image"));
	screenLabels.put("admin.service.transaction cannot exceed 15",_mapping.getTextDescription("admin.service.Maximum number of transactions for a website cannot exceed more than 15"));
	screenLabels.put("no transaction selected",_mapping.getTextDescription("admin.service.No transaction(s) have been selected"));
	screenLabels.put("admin.service.DeleteConfirmMessage",_mapping.getTextDescription("admin.service.Are you sure you want to delete the transaction"));
	screenLabels.put("admin.service.DeleteSelectedConfirmMessage",_mapping.getTextDescription("admin.service.Are you sure you want to delete the selected transaction(s)"));
	screenLabels.put("admin.service.successMsg",_mapping.getTextDescription("admin.service.Transaction has been added successfully"));
	screenLabels.put("admin.service.noComma",_mapping.getTextDescription("admin.service.Cannot have \',\' in consecutive positions"));
	screenLabels.put("admin.service.MaxPages",_mapping.getTextDescription("admin.service.Maximum number of pages associated with a transaction can only be 6"));
	screenLabels.put("admin.service.MaxPatterns",_mapping.getTextDescription("admin.service.Maximum number of patterns in a page can only be 6"));
	screenLabels.put("admin.service.unique page name",_mapping.getTextDescription("admin.service.Please enter unique page names"));
	screenLabels.put("admin.service.MaxLength",_mapping.getTextDescription("admin.transaction.Maximum length of a page associated with a transaction can only be 64 characters"));

	rootJson.put("GridValues",transNameArray);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
	System.out.println("rootJson.toString()_____ "+rootJson.toString());
%>


