<%
/**
 *	File name		:	EgTestConfigParameters.jsp
 *	Purpose			:	This page enables the administrator to view the test details pertaining to specific components and/or component types
**/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgRoleInfo"%>
<%@ page import = "com.eg.EgName"%>
<%@ page import = "com.egurkha.ini.IniUI"%>
<%@ page import = "com.eg.MappingNameSorter"%>
<%@ page import ="com.eg.EgSpecsInfo"%>
<%@ page import = "com.egurkha.util.EgStackForBackButton"%>
<%@ page import = "com.egurkha.util.DateUtil" %>
<%@ page import = "com.eg.EgConfigInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.egurkha.admin.TestConfigParameters"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	JSONObject rootJson = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%!
	public String removeNull(String component)
	{
		return (component.endsWith(":NULL"))?component.substring(0,component.indexOf(":NULL")):component;
	}
%>

<%
	EgRoleInfo egRoleInfo = EgRoleInfo.getInstance(session.getId(),(String)session.getAttribute("sess_userid"));
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	String userLanguage = _user.getLanguage();
	IniUI iniUI = IniUI.getInstance();
	if (userLanguage == null)
	{
		userLanguage = iniUI.getDefaultLanguage();
	}
	MappingNameSorter sorter = new MappingNameSorter(userLanguage);

	ArrayList aListComponentTypes = new ArrayList();
	String[] sTypes = egRoleInfo.getServerTypes();
	if (sTypes != null && sTypes.length > 0)
	{
		aListComponentTypes = new ArrayList();
		for (int st=0;st<sTypes.length;st++)
		{
			aListComponentTypes.add(sTypes[st]);
		}
	}
	String compType = request.getParameter("compType");
	String compName = request.getParameter("compName");

	if ((compType == null || compType.equals("-1")) && aListComponentTypes.size() == 1)
	{
		compType = (String) aListComponentTypes.get(0);
	}
	else if ((compType == null || compType.equals("-1")) && (aListComponentTypes.size() == 0 || aListComponentTypes.size() > 1))
	{
		compType = "All";
	}

	if (compName == null || compName.equals("-1") || compType.equals("All"))
	{
		compName = "All";
	}

	JSONArray CompType = new JSONArray();
	JSONObject compTypeObj = new JSONObject();
	if (aListComponentTypes != null && aListComponentTypes.size() > 0)
	{
		rootJson.put("hasCmp","Yes");
		if (aListComponentTypes.size() > 1)
		{
			compTypeObj.put("displayField",_mapping.getTextDescription("admin.common.All"));
			compTypeObj.put("valueField","-1");
			CompType.add(compTypeObj);
		}

		ArrayList serverList = new ArrayList();
		for (int as=0;as<aListComponentTypes.size();as++)
		{
			String strSrvType = (String)aListComponentTypes.get(as);
			if (strSrvType.equalsIgnoreCase("Site_servers")) continue;
			serverList.add(strSrvType);
		}
		serverList = sorter.getSortedCompTypeList(serverList);
		for (int j=0; j<serverList.size();j++)
		{
			EgName nameObj = (EgName)serverList .get(j);
			String tmpVal = nameObj.getActualName();
			String tmpDis = nameObj.getLocalName();
			compTypeObj.put("displayField",tmpDis);
			compTypeObj.put("valueField",tmpVal);
			CompType.add(compTypeObj);
		}
		rootJson.put("ComponentType",CompType);

		JSONArray CompName = new JSONArray();
		JSONObject compNameObj = new JSONObject();
		if (compType.equalsIgnoreCase("All"))
		{
			compNameObj.put("displayField",_mapping.getTextDescription("admin.common.All"));
			compNameObj.put("valueField","-1");
			CompName.add(compNameObj);
			rootJson.put("ComponentName",CompName);
		}
		else if (!compType.equalsIgnoreCase("All") )
		{
			String[] strComps = egRoleInfo.getAllServersOfType(compType);
			if (strComps.length > 1)
			{
				compNameObj.put("displayField",_mapping.getTextDescription("admin.common.All"));
				compNameObj.put("valueField","-1");
				CompName.add(compNameObj);
			}
			Arrays.sort(strComps,String.CASE_INSENSITIVE_ORDER);
			for (int i=0;i<strComps.length;i++)
			{
				String strComponent = strComps[i];
				strComponent = strComponent.substring(strComponent.indexOf(":")+1);
				String selected = "";
				String rmvdNullCmp = removeNull(strComponent);

				compNameObj.put("displayField",rmvdNullCmp);
				compNameObj.put("valueField",strComponent);
				CompName.add(compNameObj);
			}
			rootJson.put("ComponentName",CompName);
		}

		String tempoTableHtmlForm = "<table align='center' cellspacing='0' cellpadding='0' width='79%' border='0' valign='top'><tr><td id='eg_blankspace' height='10'>&nbsp;</td></tr><tr><td align='right' valign='middle' width='10%'  nowrap ><a class='head'><img class='mouse' src='../admin/eg_images/"+admin_Skin+"/save_audit.gif' border='0' title='SAVE' onClick='main.savePdf();'></a></td></tr></table>";
		rootJson.put("pdfUtilities",tempoTableHtmlForm);
	}
	else
	{
		rootJson.put("hasCmp","No");
	}

	if(request.getQueryString()!=null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestConfigParametersExt.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgTestConfigParametersExt.jsp");
	}

	System.out.println("rootJson_______"+rootJson);
	out.println(rootJson.toString());
%>



