<%
/*************************************************************************************************/
/*                 Name          : EgWebServiceRespone.jsp                                       */
/*                 Purpose       : Response page for a given request XML                         */
/*                 Version       : 5.7                                                           */
/*************************************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import ="com.eg.webservice.util.*"%>
<%@ page import ="com.eg.webservice.*"%>
<%@ page import ="javax.xml.namespace.QName"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<html>
<head>
<title>Web service Response</title>
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>

<script type="text/javascript">
var $j = jQuery.noConflict();

$j(document).ready(function(){
	
	centerScreen("#loading");

});
</script>
</head>
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	
	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	String componentName = request.getParameter("componentName");
	String selectedUrlValue = request.getParameter("selectedUrlValue");
	String selectedServiceValue = request.getParameter("selectedServiceValue");
	String selectedOperationValue = request.getParameter("selectedOperationValue");
	String requestMsg = request.getParameter("requestMsg");
	String credentialWithPattern = request.getParameter("credentialWithPattern");
	Hashtable credentPatternTable = new Hashtable();
	if(credentialWithPattern!=null && !credentialWithPattern.equals(""))
	{
		StringTokenizer sCreden = new StringTokenizer(credentialWithPattern,",");
		while(sCreden.hasMoreTokens())
		{
			String credenToken = (String)sCreden.nextToken();
			String cPattern = credenToken.substring(0,credenToken.indexOf(":"));
			String cUserPass = credenToken.substring(credenToken.indexOf(":")+1);
			if(!credentPatternTable.containsKey(cPattern))
				credentPatternTable.put(cPattern,cUserPass);
		}
	}

	String reqFrom = request.getParameter("reqFrom");
	String responseString="";
	String formatted="";
	String formattedResponseMsg="";

	ArrayList operationList=null;
	HashMap serviceMap=null;
	com.eg.webservice.EgWebServiceBase wsclient=null;
	if(selectedUrlValue !=null && !selectedUrlValue.equals(""))
	{
		String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
		String pattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));

		wsclient = (com.eg.webservice.EgWebServiceBase)session.getAttribute("webServiceObject");
		if(wsclient==null)
		{
			String username="";
			String passwd="";
			if(credentPatternTable.containsKey(pattern))
			{
				String credential = (String)credentPatternTable.get(pattern);
				username = credential.substring(0,credential.indexOf(":"));
				passwd = credential.substring(credential.indexOf(":")+1);
			}
			if(username=="") username="None";
			if(passwd=="") passwd="None";
			wsclient = new com.eg.webservice.EgWebServiceBase(urlOnly, username, passwd);
		}
		serviceMap = wsclient.getWsdlServices();
		Hashtable userInputTbl = (Hashtable)session.getAttribute("webServiceBaseTable");
		if(userInputTbl!=null && userInputTbl.size()>0)
		{
			Enumeration userKeys = userInputTbl.keys();
			while(userKeys.hasMoreElements())
			{
				String urlKey = (String)userKeys.nextElement();
				operationList = (ArrayList)userInputTbl.get(urlKey);
			}
		}
	}
	if(reqFrom!=null && !reqFrom.equals("") && reqFrom.equals("sendRequest"))
	{
		String targetURL="";
		String SoapActionURL="";
		if(serviceMap!=null && serviceMap.size()>0)
		{
			Iterator iter = serviceMap.keySet().iterator();
			while(iter.hasNext()) 
			{
				String key = (String)iter.next();
				HashMap val = (HashMap)serviceMap.get(key);

				ArrayList innerList = (ArrayList)val.get(key);
				HashMap innerMap = (HashMap)innerList.get(0);

				String soapURI = (String)innerMap.get("SOAP URI");
				targetURL = soapURI;
				if (!com.egurkha.util.StringUtils.isNull(targetURL))
				{
					if (!targetURL.endsWith("?wsdl") && !targetURL.endsWith("?WSDL"))
					{
						targetURL+="?wsdl";
					}
				}
			}
		}

		if(selectedOperationValue !=null && operationList!=null)
		{
			for (int k = 0; k < operationList.size(); ++k)
			{
				HashMap operation = (HashMap)operationList.get(k);
				String operationName = (String)operation.get("OperationName");
				if(operationName.equals(selectedOperationValue))
				{
					SoapActionURL = (String)operation.get("SOAPAction");
				}
			}
		}
		if(targetURL!=null && !targetURL.equals("") && requestMsg!=null && !requestMsg.equals(""))
		{
			if(SoapActionURL==null)
				SoapActionURL="";
			try
			{
				responseString =EgSOAPUtil.invokeOperation(requestMsg,SoapActionURL,targetURL);
			}
			catch(Exception e){
				System.out.println("Exception Occured...........................");
				e.printStackTrace();
			}
		}
		if(responseString==null || responseString.equals(""))
		{
			formattedResponseMsg = "Error occured while retrieving Response";
		}
		else
		{
			if(!responseString.equals("") && responseString!=null && !responseString.startsWith("<Error>")){
				formatted = EgSOAPUtil.formatXML(responseString);
			}
			else if(responseString.startsWith("<Error>")){
				formatted = responseString.substring(responseString.indexOf(">")+1,responseString.indexOf(":"));
			}
			if(formatted!=null || !formatted.equals(""))
				formattedResponseMsg=formatted;
		}
	}
%>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="eg_lightlight">
<div id ="loading" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle"> 
				<img src='/final/admin/eg_images/indicator_medium.gif'>
			</td>
		</tr>
	</table>
</div>
<table cellspacing="0" cellpadding="0" border="0" align="center" width="100%" height="100%">
	<tr>
		<td class="eg_subcontent" style="padding:0px">
			<textarea rows="16" cols="85" accept="xml" id="soapResponse" name="soapResponse" style="overflow:auto;">
				<%=formattedResponseMsg%>
			</textarea>
		</td>
	</tr>
</table>

</body>

<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
</html>