<%
/*************************************************************************************************/
/*                 Name          : EgWebServiceConfig.jsp                                        */
/*                 Purpose       : This is the main page to configure Web Services               */
/*                 Version       : 5.7                                                           */
/*************************************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page errorPage="EgProbs.jsp"%>
<%@ page import = "java.util.*"%>
<%@ page import = "java.io.*"%>
<%@ page import = "com.eg.EgControlInfo"%>
<%@ page import = "com.eg.PollingServlet"%>
<%@ page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgInstallInfo"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgStateManager" %>
<%@ page import="com.eg.EgLicenseInfo" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.monitor.remotecontrol.PreAgentInfo" %>
<%@ page import="com.eg.EgServerList" %>
<%@ page import="javax.xml.transform.dom.DOMSource"%>
<%@ page import ="javax.xml.parsers.DocumentBuilder"%>
<%@ page import ="javax.xml.parsers.DocumentBuilderFactory"%>
<%@ page import ="javax.xml.soap.MessageFactory"%>
<%@ page import ="org.w3c.dom.Document"%>
<%@ page import ="org.w3c.dom.Element"%>
<%@ page import ="org.xml.sax.InputSource"%>
<%@ page import ="org.w3c.dom.NodeList"%>
<%@ page import ="org.w3c.dom.Node"%>
<%@ page import="java.io.StringWriter"%>
<%@ page import="java.io.StringReader"%>
<%@ page import ="com.eg.webservice.util.*"%>
<%@ page import ="com.eg.webservice.*"%>
<%@ page import ="com.eg.*"%>
<%@ page import="com.egurkha.admin.EgWebServiceUtil" %>
<%@ taglib prefix ="egui" uri="../../../WEB-INF/eg-taglib.tld"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<html>
<head>
</style>
<title>Web service configuration</title>
<!-- egui:skin ui="adminindex"/> -->
	<link rel="stylesheet" href="../resources/css/ext-eg.css" />
	<link rel="stylesheet" href="../styles/ext-custom-com.css" />
	<link rel="stylesheet" href="../styles/egIcons.css" />
<script  src="/final/jquery/jquery.js"></script>
<script  src="/final/jquery/ui/jquery.ui.core.js"></script>

<script type="text/javascript">
var $j = jQuery.noConflict();
var webserviceConfigPage = '<%=response.encodeURL("/final/admin/EgWebServiceConfig.jsp?")%>';
var validatePage = '<%=response.encodeURL("/final/admin/EgConfigureComponentTests.jsp?")%>';

$j(document).ready(function(){
	$j("#inputTable").hide();
	$j("#WebServiceDiv").height(420);
	$j("#innerWebServiceDiv").height(300);
	$j("#save").attr('disabled',true);
	$j("#sendReq").attr('disabled',true);

});

function selectUrl(value)
{
	var wsdlUrl='';
	$j('#wsdlService').children('option:not(:first)').remove();
	$j('#wsdlOperation').empty();
	$j('#selectedOp').empty();
	
	$j("#inputTable").html("");
	$j('#soapRequest').val("");
	$j("#inputTable").hide();
	$j('#requestMsg').hide();
	$j("#WebServiceDiv").height(420);
	$j("#innerWebServiceDiv").height(300);
	$j("#buttonRow").hide();
	$j("#save").attr('disabled',true);
	$j("#sendReq").attr('disabled',true);

	showLoadingDiv();
	$j("#wsdlUrl").attr('disabled',true);
	$j("#agentListObj").attr('disabled',true);
	var configMode = $j('#agentListObj :selected').val();
	var wsdlUrl = $j('#wsdlUrl :selected').val();
	var componentName = $j("#componentName").attr("value");
	var wsdlMain = $j("#wsdl").attr("value");
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	var mainOperation = $j("#Operations").val();
	var reqFrom='selectUrl';
	$j.ajax({
		type: "POST",
		url: webserviceConfigPage,
		data: "selectedUrlValue="+encodeURI(wsdlUrl)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+ "&reqFrom="+encodeURI(reqFrom)+ "&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
		success: function(msg) { 
			
			var alertMsg = $j.trim($j(msg).find('#alertResultDiv').text());
			if(configMode!='EgManager')
			{
				if(alertMsg=='Failed to get required configuration information from agent' || alertMsg=='Agent not installed or not running')
				{
					$j('#alertResultDiv').text(alertMsg);
					$j('#alertDiv').show();
					$j("#wsdlUrl").attr('disabled',false);
					$j("#agentListObj").attr('disabled',false);
					$j('#loading_image').hide();
					$j('#selectedOp').html("");
					$j('#wsdlOperation').html("");
					$j('#requestMsg').hide();
					$j('#inputTable').hide();
					return;
				}
			}
			var serviceHtml = $j(msg).find('#wsdlService').html();
			if(serviceHtml!=null)
				$j('#wsdlService').html(serviceHtml);
			
			if($j('#wsdlService option').length == 1)
			{
				if(document.getElementById("wsdlUrl").selectedIndex == 0)
				{
					alert('<egui:intnl text="admin.test.Please select a Url"/>');
				}
				else
				{
					alert('<egui:intnl text="admin.test.No Service Available"/>');
				}
				$j("#wsdlUrl").attr('disabled',false);
				$j("#agentListObj").attr('disabled',false);
				$j('#loading_image').hide();
				$j('#selectedOp').html("");
				$j('#wsdlOperation').html("");
				$j('#requestMsg').hide();
				$j('#inputTable').hide();
				return;
			}
			if($j('#wsdlService option').length == 2)
			{
				var operationHtml = $j(msg).find('#wsdlOperation').html();
				var selectedOp  = $j(msg).find('#selectedOp').html();
				$j('#wsdlOperation').html(operationHtml);
				$j('#selectedOp').html(selectedOp);
				$j('#soapRequest').val("");
				$j('#inputTable').html("");
				$j("#wsdlUrl").attr('disabled',false);
				$j("#agentListObj").attr('disabled',false);
				$j('#loading_image').hide();
				$j("#wsdlService").val($j("#wsdlService option:eq(1)").val());
				if($j('#wsdlOperation option').length == 0 && $j('#selectedOp option').length == 0)
				{
					alert('<egui:intnl text="No Operation available"/>');
					return;
				}
			}
			else
				return;
			
		},
		error: function(xhr, status, errorThrown){
			alert("Error in SelectUrl:\n" + status);
		}
	});
}
function selectService(value)
{
	if(document.getElementById("wsdlService").selectedIndex == 0)
	{
		alert('<egui:intnl text="admin.test.Please select a Service"/>');
		$j("#wsdlUrl").attr('disabled',false);
		$j("#agentListObj").attr('disabled',false);
		$j('#loading_image').hide();
		$j('#selectedOp').html("");
		$j('#wsdlOperation').html("");
		$j('#requestMsg').hide();
		$j('#inputTable').hide();
		$j('#buttonRow').hide();
		$j("#WebServiceDiv").height(420);
		$j("#innerWebServiceDiv").height(300);
		return;
	}
	showLoadingDiv();
	var configMode = $j('#agentListObj :selected').val();
	var wsdlUrl = $j('#wsdlUrl :selected').val();
	var componentName = $j("#componentName").attr("value");
	var wsdlMain = $j("#wsdl").attr("value");
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	var mainOperation = $j("#Operations").val();
	var reqFrom='selectService';
	var selectedService = $j('#wsdlService :selected').val();
	$j.ajax({
		type: "POST",
		url: webserviceConfigPage,
		data: "selectedUrlValue="+encodeURI(wsdlUrl)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+ "&reqFrom="+encodeURI(reqFrom)+ "&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern)+ "&selectedServiceValue="+encodeURI(selectedService),
		success: function(msg) {

			var operationHtml = $j(msg).find('#wsdlOperation').html();
			var selectedOp  = $j(msg).find('#selectedOp').html();
			$j('#wsdlOperation').html(operationHtml);
			$j('#selectedOp').html(selectedOp);
			$j('#soapRequest').val("");
			$j('#inputTable').html("");
			$j("#wsdlUrl").attr('disabled',false);
			$j("#agentListObj").attr('disabled',false);
			$j('#loading_image').hide();
			if($j('#wsdlOperation option').length == 0 && $j('#selectedOp option').length == 0)
			{
				alert('<egui:intnl text="No Operation available"/>');
				return;
			}
		}
	});
}

function save()
{
	if(document.getElementById("wsdlService").selectedIndex == 0)
	{
		alert('<egui:intnl text="admin.test.Please select a Service"/>');
		return;
	}
	var option = $j("input[name='changeView']:checked").val();
	var keyValues='';
	var requestMsg='';
	if(option=='htmlview')
	{
		//to get the input parameters -- start
		var parameters = [];
		var text='';
		var mainkeys=[];

		$j("td[class='hiddentd']").each(function(){
			var txt = $j(this).text();
			//if(txt!='' && txt.indexOf("@#@")>-1)
				//txt = txt.substring(txt.lastIndexOf("@")+1);
			mainkeys.push(txt);
		});
		
		$j("td[class='parameterName']").each(function(){
				text=$j(this).text();
				if(text.indexOf("*")>-1)
				{
					text = text.substring(0,text.indexOf("*"));
				}
				parameters.push(text);
		});
		var inputs = [];
		$j("#inputTbl").find("#inputRow").each(function(i){

			var inputValue = '';
			inputValue = $j.trim($j(this).find("td:eq(2)").find("input#inputValue").val());
			if(inputValue=='' || inputValue=='undefined')
			{
				inputValue = $j.trim($j(this).find("td:eq(2)").find("select#selectValue").val());
			}
			if(inputValue!="undefined")
			{
				inputs.push(inputValue);
			}
		});
		$j(".linesquare").find("#subinputRow").each(function(){
			
			var inputValue = '';
			inputValue = $j.trim($j(this).find("td:eq(2)").find("input#inputValue").val());
			if(inputValue=='' || inputValue=='undefined')
			{
				inputValue = $j.trim($j(this).find("td:eq(2)").find("select#selectValue").val());
			}
			if(inputValue!="undefined")
			{
				inputs.push(inputValue);
			}
		});

		var your_obj = combine(mainkeys, parameters, inputs);//alert(your_obj);
		for(var y=0;y<your_obj.length;y++)
		{
			keyValues=keyValues+"~"+your_obj[y];
		}
		if(keyValues.startsWith("~"))
		{
			keyValues = keyValues.substring(keyValues.indexOf(",")+1);
		}
		//end
	}
	else if(option=='xmlview')
	{
		requestMsg = $j('#soapRequest').val();
	}

	var selectedOperation = $j('#selectedOp :selected').val();
	var operations='';
	var seloperation='';
	$j('#selectedOp').find('option').each(function() {
			if(selectedOperation == $j(this).val())
			{
				seloperation=$j(this).val();
			}
			operations=operations+","+$j(this).val();
	});
	if(operations.startsWith(","))
		operations = operations.substring(operations.indexOf(",")+1);
	
	var wsdlMain = $j("#wsdl").attr("value");
	var mainOperation = $j("#Operations").val();
	var componentName = $j("#componentName").attr("value");
	var wsdlurl = $j('#wsdlUrl :selected').val();
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	var selectedService = $j('#wsdlService :selected').val();
	var configMode = $j('#agentListObj :selected').val();
	var from = 'save';
	var associatedOp = operations;
	
	showLoadingDiv();
	$j.ajax({
		type:"POST",
		url:webserviceConfigPage,
		data: "selectedUrlValue="+encodeURI(wsdlurl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&associatedOp="+encodeURI(associatedOp)+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
		success: function(msg) { 
			
			var alertMsg = $j.trim($j(msg).find('#alertResultDiv').text());
			if(configMode!='EgManager' && option=='htmlview')
			{
				if(alertMsg=='Failed to get required configuration information from agent' || alertMsg=='Agent not installed or not running')
				{
					$j('#alertResultDiv').text(alertMsg);
					$j('#alertDiv').show();
				}
			}
			$j('#loading_image').hide();
			var operations = $j(msg).find('#operationResult').text();
			var opDiv = $j(msg).find('#op').html();
			if(operations==null || operations=='')
				$j('#Operations').val(mainOperation);
			else
				$j('#Operations').val(operations);
			var selectedop = $j(msg).find('#selectedOp').html();
			if(selectedop==null || selectedop=='')
				$j('#selectedOp').html(selectedOperation);
			else
				$j('#selectedOp').html(selectedop);
			$j("#inputTable").html("");
			$j('#soapRequest').val("");
			$j('#requestMsg').hide();
			$j("#inputTable").hide();
			$j('#buttonRow').hide();
			$j("#WebServiceDiv").height(420);
			$j("#innerWebServiceDiv").height(300);
		}
	});
}

function combine(mainkeys, keys, values)
{
	var l = Math.min(mainkeys.length,keys.length,values.length), ret = [], i;
	for( i=0; i<l; i++) ret.push(mainkeys[i]+":"+keys[i]+":"+values[i]);
	return ret;
}

function sendRequest()
{
	if(document.getElementById("wsdlService").selectedIndex == 0)
	{
		alert('<egui:intnl text="admin.test.Please select a Service"/>');
		return;
	}
	//to get the input parameters-- start
	var option = $j("input[name='changeView']:checked").val();
	var keyValues='';
	var requestMsg='';
	if(option=='htmlview')
	{
		var parameters = [];
		var text='';
		var mainkeys=[];

		$j("td[class='hiddentd']").each(function(){
			var txt = $j(this).text();
			//if(txt!='' && txt.indexOf("@#@")>-1)
				//txt = txt.substring(txt.lastIndexOf("@")+1);
			mainkeys.push(txt);
		});
		
		$j("td[class='parameterName']").each(function(){
				text=$j(this).text();
				if(text.indexOf("*")>-1)
				{
					text = text.substring(0,text.indexOf("*"));
				}
				parameters.push(text);
		});
		var inputs = [];
		$j("#inputTbl").find("#inputRow").each(function(){

			var inputValue = '';
			inputValue = $j.trim($j(this).find("td:eq(2)").find("input#inputValue").val());
			if(inputValue=='' || inputValue=='undefined')
			{
				inputValue = $j.trim($j(this).find("td:eq(2)").find("select#selectValue").val());
			}
			if(inputValue!="undefined")
			{
				inputs.push(inputValue);
			}
		});
		$j(".linesquare").find("#subinputRow").each(function(){
			
			var inputValue = '';
			inputValue = $j.trim($j(this).find("td:eq(2)").find("input#inputValue").val());
			if(inputValue=='' || inputValue=='undefined')
			{
				inputValue = $j.trim($j(this).find("td:eq(2)").find("select#selectValue").val());
			}
			if(inputValue!="undefined")
			{
				inputs.push(inputValue);
			}
		});

		var your_obj = combine(mainkeys, parameters, inputs);//alert(your_obj);
		for(var y=0;y<your_obj.length;y++)
		{
			keyValues=keyValues+"~"+your_obj[y];
		}
		if(keyValues.startsWith("~"))
		{
			keyValues = keyValues.substring(keyValues.indexOf("~")+1);
		}
	}
	else if(option=='xmlview')
	{
		requestMsg = $j('#soapRequest').val();
	}
	//end

	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	var wsdlMain = $j("#wsdl").attr("value");
	var mainOperation = $j("#Operations").val();
	var componentName = $j("#componentName").attr("value");
	var selectedUrl = $j('#wsdlUrl :selected').val();
	var selectedService = $j('#wsdlService :selected').val();
	var selectedOperation = $j('#selectedOp :selected').val();
	var configMode = $j('#agentListObj :selected').val();
	var from = 'sendRequest';
	var urlToDisplay='/final/admin/EgWebServiceResponse.jsp';
	$j("#wsdlUrl").attr('disabled',true);
	$j("#agentListObj").attr('disabled',true);

	if(option=='htmlview')
	{
		showLoadingDiv();
		$j.ajax({	
			type: "POST",
			url: webserviceConfigPage,
			data:"selectedUrlValue="+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom="+encodeURI(from)+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
			success: function(msg) { 

				var soapReqText = $j(msg).find('#soapRequest').text();
				if($j.trim($j('#soapRequest').val()) == "")
				{
					$j('#soapRequest').val(soapReqText);
				}
				else
				{
					$j('#soapRequest').val("");
					$j('#soapRequest').val(soapReqText);
				}

				var href = 'EgWebServiceResponse.jsp?selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(soapReqText)+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+"&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&credentialWithPattern="+encodeURI(credentialWithPattern);
				
				createAJAX();
				var idObj = document.getElementById("innerWebServiceResponseDiv");
				var params;
				var tempurl;
				if (href.indexOf("?")>-1)
				{
					params=href.substring(href.indexOf("?")+1);
					tempurl=href.substring(0,href.indexOf("?"));
				}
				xmlhttp.open('POST',tempurl,true);
				xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
				xmlhttp.setRequestHeader('Content-length',params.length);
				xmlhttp.setRequestHeader('Connection','close');
				xmlhttp.onreadystatechange = function ()
				{
					if(xmlhttp.readyState == 4)
					{
						if (xmlhttp.status == 200)
						{
							var response = xmlhttp.responseText;
							idObj.innerHTML = response;
							var maxInd = maxIndex();
							$j("#WebServiceResponseDiv").css({"z-index":maxInd+1});
							$j("#WebServiceResponseDiv").css({"display":"block" , "position":"absolute" });
							$j('#loading_image').hide();
						}
					}
				}
				xmlhttp.send(params);

				$j("#wsdlUrl").attr('disabled',false);
				$j("#agentListObj").attr('disabled',false);
			}
		});
	}
	else if(option=='xmlview')
	{
		showLoadingDiv();
		createAJAX();
		$j.ajax({	
			type: "POST",
			url: webserviceConfigPage,
			data:'selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom=sendRequestXml"+"&inputValues="+encodeURI(keyValues)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
			success: function(msg) { 
				var inputTable = $j(msg).find('#inputTable').html();
				$j('#inputTable').html(inputTable);
			}
		});
		
		
		var href = 'EgWebServiceResponse.jsp?selectedUrlValue='+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&requestMsg="+encodeURI(requestMsg)+ "&reqFrom="+encodeURI(from)+ "&componentName="+encodeURI(componentName)+"&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&credentialWithPattern="+encodeURI(credentialWithPattern);
		var idObj = document.getElementById("innerWebServiceResponseDiv");
		var params;
		var tempurl;
		if (href.indexOf("?")>-1)
		{
			params=href.substring(href.indexOf("?")+1);
			tempurl=href.substring(0,href.indexOf("?"));
		}
		xmlhttp.open('POST',tempurl,true);
		xmlhttp.setRequestHeader('Content-type','application/x-www-form-urlencoded');
		xmlhttp.setRequestHeader('Content-length',params.length);
		xmlhttp.setRequestHeader('Connection','close');
		xmlhttp.onreadystatechange = function ()
		{
			if(xmlhttp.readyState == 4)
			{
				if (xmlhttp.status == 200)
				{
					var response = xmlhttp.responseText;
					idObj.innerHTML = response;
					var maxInd = maxIndex();
					$j("#WebServiceResponseDiv").css({"z-index":maxInd+1});
					$j("#WebServiceResponseDiv").css({"display":"block" , "position":"absolute" });
					$j('#loading_image').hide();
				}
			}
		}
		xmlhttp.send(params);
		$j("#wsdlUrl").attr('disabled',false);
		$j("#agentListObj").attr('disabled',false);
	}
}

function createAJAX() 
{
	try {
		this.xmlhttp = new ActiveXObject("Msxml2.XMLHTTP");
	} catch (e) {
		try {
			this.xmlhttp = new ActiveXObject("Microsoft.XMLHTTP");
		} catch (err) {
			this.xmlhttp = null;
		}
	}
	if(!this.xmlhttp && typeof XMLHttpRequest != "undefined")
		this.xmlhttp = new XMLHttpRequest();
	if (!this.xmlhttp)
	{
		this.connectionEstablished = false; 
	}
}
function showLoadingDiv()
{
	$j("#loading_image").css({"display":"block" , "position":"absolute" });
	var maxInd = maxIndex();
	$j("#loading_image").css({"z-index":maxInd+1});
	$j("#loading_image").show('slow');
	centerScreen("#loading_image");
}
function centerScreen(selector) 
{
	var newTop =   $j("#innerWebServiceDiv").height() - $j(selector).height() / 2;
	var newLeft =  ($j("#innerWebServiceDiv").width()  - $j(selector).width()) / 2;
	$j(selector).css({
		'position': 'absolute',
		'left': newLeft,
		'top': newTop / 2 
	});
}
function showLoadingResponse()
{
	$j("#loading").css({"display":"block" , "position":"absolute" });
	var maxInd = maxIndex();
	$j("#loading").css({"z-index":maxInd+1});
	$j("#loading").show('slow');
	centerScreen("#loading");
}

// For associate and dissasociate
function changeelement(functionCall)
{
	if(document.getElementById("wsdlService").selectedIndex == 0)
	{
		alert('<egui:intnl text="admin.test.Please select a Service"/>');
		return;
	}

	$j("#save").attr('disabled',true);
	$j("#sendReq").attr('disabled',true);
	var selectedOpLen = document.getElementById('selectedOp').options.length;
	var wsdlOperationLen = document.getElementById('wsdlOperation').options.length;
	var wsdlOperationList = document.getElementById('wsdlOperation');
	var selectedOpList = document.getElementById('selectedOp');

	var p=0;
	var compAvlChoosen=0;
	var associatedOp = '';
	for (var i = 0 ; i < wsdlOperationList.options.length ; i++)
	{
		if (wsdlOperationList.options[i].selected == true)
		{
			var txt=wsdlOperationList.options[i].text;
			var val=wsdlOperationList.options[i].value;
			compAvlChoosen++;
			associatedOp = associatedOp+","+val;
		}
	}
	if (functionCall == 'associate' && compAvlChoosen == 0)
	{
		alert('<egui:intnl text="admin.common.Please choose a operation to associate"/>');
		return;
	}
	showLoadingDiv();
	if(associatedOp.startsWith(","))
		associatedOp = associatedOp.substring(associatedOp.indexOf(",")+1);

	var wsdlMain = $j("#wsdl").attr("value");
	var mainOperation = $j("#Operations").val();
	var componentName = $j("#componentName").attr("value");
	var selectedUrl = $j('#wsdlUrl :selected').val();
	var selectedService = $j('#wsdlService :selected').val();
	var configMode = $j('#agentListObj :selected').val();
	var selectedOperation = $j('#selectedOp :selected').val();
	var reqFrom = 'associate';
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	
	$j.ajax({	
		type: "POST",
		url: webserviceConfigPage,
		data:"selectedUrlValue="+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom="+encodeURI(reqFrom)+"&associatedOp="+encodeURI(associatedOp)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
		success: function(msg) { 
			
		alert(msg);
		console.log(msg);
			var alertMsg = $j.trim($j(msg).find('#alertResultDiv').text());
			alertMsg = 'Failed to get required configuration information from agent';
			var operations = $j(msg).find('#operationResult').text();
			var selectedop = $j(msg).find('#selectedOp').html();
			if(operations==null || operations=='')
				$j('#Operations').val(mainOperation);
			else
				$j('#Operations').val(operations);
			if(selectedop==null || selectedop=='')
				$j('#selectedOp').html(selectedOperation);
			else
				$j('#selectedOp').html(selectedop);
			
			if(operations==null || operations=='' || selectedop==null || selectedop=='')
			{
				if(configMode!='EgManager')
				{
					$j('#alertResultDiv').text(alertMsg);
					$j('#alertDiv').show();
					$j('#loading_image').hide();
					//return;
				}
			}
			else if(selectedop!=null && selectedop!='')
			{
				for (var x = wsdlOperationLen; x > 0 ; x--)
				{
					if (wsdlOperationList.options[x-1].selected == true )
					{
						wsdlOperationList.options[x-1] = null;
					}
				}
			}
			$j('#loading_image').hide();
		}
	});
}
function disassociate(functionCall)
{
	var groupLabel = $j("#selectedOp option").filter(":selected").parent("optgroup").attr("label");
	$j("#save").attr('disabled',true);
	$j("#sendReq").attr('disabled',true);
	var selectedOpLen = document.getElementById('selectedOp').options.length;
	var wsdlOperationLen = document.getElementById('wsdlOperation').options.length;
	var wsdlOperationList = document.getElementById('wsdlOperation');
	var selectedOpList = document.getElementById('selectedOp');
	var compAssChoosen=0;
	var associatedOp='';

	for (var i = 0 ;i<selectedOpLen;i++)
	{
		//browsing through to find selected items
		if (selectedOpList.options[i].selected == true)
		{
			var txt=selectedOpList.options[i].text;
			var val=selectedOpList.options[i].value;
			wsdlOperationList.options[wsdlOperationLen++] = new Option (txt,val) ;
			associatedOp = associatedOp+","+val;
			compAssChoosen++;
		}
	}
	for (var x = selectedOpList.options.length; x > 0 ; x--)
	{
		if (selectedOpList.options[x-1].selected == true)
		{
			selectedOpList.options[x-1] = null;
		}
	}
	if (functionCall == 'disassociate' && compAssChoosen == 0)
	{
		alert('<egui:intnl text="admin.common.Please choose a operation to disassociate"/>');
		return;
	}

	if(associatedOp.startsWith(","))
		associatedOp = associatedOp.substring(associatedOp.indexOf(",")+1);

	var wsdlMain = $j("#wsdl").attr("value");
	var mainOperation = $j("#Operations").val(); 
	var componentName = $j("#componentName").attr("value");
	var selectedUrl = $j('#wsdlUrl :selected').val();
	var selectedService = $j('#wsdlService :selected').val();
	var configMode = $j('#agentListObj :selected').val();
	var reqFrom = 'disassociate';
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");

	$j.ajax({
		type: "POST",
		url: webserviceConfigPage,
		data:"selectedUrlValue="+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom="+encodeURI(reqFrom)+"&associatedOp="+encodeURI(associatedOp)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
		success: function(msg) { 
			var operations = $j(msg).find('#operationResult').text();
			$j('#Operations').val(operations);
			var selectedop = $j(msg).find('#selectedOp').html();
			$j('#selectedOp').html(selectedop);
			
			var selectedOpLen = document.getElementById('selectedOp').options.length;
			if(selectedOpLen==0)
			{
				$j("#inputTable").html("");
				$j('#soapRequest').val("");
				$j("#inputTable").hide();
				$j('#requestMsg').hide();
				$j("#WebServiceDiv").height(420);
				$j("#innerWebServiceDiv").height(300);
				$j("#buttonRow").hide();
			}
		}
	});
}
function configureOperations()
{
	if(document.getElementById("wsdlService").selectedIndex == 0)
	{
		alert('<egui:intnl text="admin.test.Please select a Service"/>');
		return;
	}
	var x = $j("#configure").offset();
	var pos = $j("#configure").position();

	var groupLabel = $j("#selectedOp option").filter(":selected").parent("optgroup").attr("label");
	var reqFrom = 'configure';
	var wsdlMain = $j("#wsdl").attr("value");
	var credentialWithPattern = $j("#credentialWithPattern").attr("value");
	var mainOperation = $j("#Operations").val();
	var componentName = $j("#componentName").attr("value");
	var selectedUrl = $j('#wsdlUrl :selected').val();
	var configMode = $j('#agentListObj :selected').val();
	var selectedService = $j('#wsdlService :selected').val();
	var selectedOperation = $j('#selectedOp :selected').val();
	var selectedOperationList = document.getElementById("selectedOp");
	var selectedOperationLen = document.getElementById("selectedOp").options.length;
	var opPicked = 0;

	if (selectedOperationList.selectedIndex == -1)
	{
		alert("Please select a operation");
		return;
	}
	else
	{
		for (var i=0; i<selectedOperationLen; i++)	{
			if (selectedOperationList.options[i].selected == true)
			{
				opPicked++;
			}
		}
		if(opPicked!=1)
		{
			alert("Please select any one operation");
			return;
		}
	}
	alert('groupLabel : '+groupLabel);
	showLoadingDiv();
	$j("#wsdlUrl").attr('disabled',true);
	$j("#agentListObj").attr('disabled',true);
	$j.ajax({	
		type: "POST",
		url: webserviceConfigPage,
		data:"selectedUrlValue="+encodeURI(selectedUrl)+ "&selectedServiceValue="+encodeURI(selectedService)+ "&selectedOperationValue="+encodeURI(selectedOperation)+ "&componentName="+encodeURI(componentName)+ "&wsdl="+encodeURI(wsdlMain)+ "&operation="+encodeURI(mainOperation)+"&reqFrom="+encodeURI(reqFrom)+"&groupLabel="+encodeURI(groupLabel)+"&configMode="+encodeURI(configMode)+"&credentialWithPattern="+encodeURI(credentialWithPattern),
		success: function(msg) { 
			
			var alertMsg = $j.trim($j(msg).find('#alertResultDiv').text());
			if(configMode!='EgManager')
			{
				if(alertMsg=='Failed to get required configuration information from agent' || alertMsg=='Agent not installed or not running')
				{
					$j('#alertResultDiv').text(alertMsg);
					$j('#alertDiv').show();
					$j('#loading_image').hide();
					$j("#wsdlUrl").attr('disabled',false);
					$j("#agentListObj").attr('disabled',false);
					$j("#inputTable").html("");
					$j('#soapRequest').val("");
					$j("#inputTable").hide();
					$j('#requestMsg').hide();
					$j("#WebServiceDiv").height(420);
					$j("#innerWebServiceDiv").height(300);
					$j("#buttonRow").hide();
					return;
				}
			}
			$j('#loading_image').hide();
			$j("#wsdlUrl").attr('disabled',false);
			$j("#agentListObj").attr('disabled',false);
			var soapRequestHtml = $j(msg).find('#soapRequest').html();
			alert('msg : '+msg);
			alert('soapRequestHtml : '+soapRequestHtml);
			var soapReqText = $j(msg).find('#soapRequest').text();
			alert('soapReqText : '+soapReqText);
			if($j.trim($j('#soapRequest').val()) == "")
			{
				$j('#soapRequest').val(soapReqText);
			}
			else
			{
				$j('#soapRequest').val("");
				$j('#soapRequest').val(soapReqText);
			}
			
			var inputTable = $j(msg).find('#inputTable').html();
			$j('#inputTable').html(inputTable);
			
			var option = $j("input[name='changeView']:checked").val();
			if(option=='xmlview')
			{
				$j('#requestMsg').show();
				$j('#inputTable').hide();
			}
			if(option=='htmlview')
			{
				$j('#requestMsg').hide();
				$j('#inputTable').show();
				var ht = $j('#inputTbl').height();
			}
			
			//resize div-- starts
			var ht = $j('#inputTbl').height();
			var subht = $j('#subinputTbl').height();
			if(ht==null)
			{
				$j('#assocDiv').height(215);
				/*if(subht!=null && subht > 220)
					$j('#assocDiv').height(215);
				else	
					$j('#assocDiv').height(190);//subht+35*/
				
			}
			else
			{
				$j('#assocDiv').height(ht+35);
			}
			if(ht!=null && ht > 220)
				$j('#assocDiv').height(215);
			if(ht!=null && subht!=null)
			{
				var tot = ht+subht;
				if(tot>220)
					$j('#assocDiv').height(215);
				else
					$j('#assocDiv').height(tot+35);
			}
			//resize -- ends

			var divHt = $j('#assocDiv').height();
			var tableHt = $j('#inputTable').height();
			var textHt = $j('#requestMsg').height();

			if(option=='xmlview')
			{
				$j("#WebServiceDiv").animate({height:237+textHt+108+"px"},500);
				$j("#innerWebServiceDiv").animate({height:237+textHt+63+"px"},500);
			}
			if(option=='htmlview')
			{
				$j("#WebServiceDiv").animate({height:237+divHt+108+"px"},500);
				$j("#innerWebServiceDiv").animate({height:237+divHt+63+"px"},500);
			}

			$j("#buttonRow").show();
			$j("#save").attr('disabled',false);
			disableSendReq();
		}
	});
}

function selectFunction(val)
{
	if(val=='xmlview')
	{
		if($j('#soapRequest').val()!='')
		{
			$j('#requestMsg').show();
			var textHt = $j('#requestMsg').height();
			$j("#WebServiceDiv").animate({height:237+textHt+108+"px"},500);
			$j("#innerWebServiceDiv").animate({height:237+textHt+63+"px"},500);
		}
		$j('#inputTable').hide();
	}
	else if(val='htmlview')
	{
		if($j('#inputTbl').html()!=null || $j('#subinputTbl').html()!=null)
		{
			$j('#inputTable').show();

			//resize starts
			var ht = $j('#inputTbl').height();
			var subht = $j('#subinputTbl').height();
			if(ht==null)
			{
				$j('#assocDiv').height(215);
				/*if(subht!=null && subht > 220)
					$j('#assocDiv').height(215);
				else	
					$j('#assocDiv').height(190);*/
			}
			else
			{
				$j('#assocDiv').height(ht+35);
			}
			if(ht!=null && ht > 220)
				$j('#assocDiv').height(215);
			if(ht!=null && subht!=null)
			{
				var tot = ht+subht;
				if(tot>220)
					$j('#assocDiv').height(215);
				else
					$j('#assocDiv').height(tot+35);
			}
			//resize ends

			var divHt = $j('#assocDiv').height();
			var tableHt = $j('#inputTable').height();
			$j("#WebServiceDiv").animate({height:237+tableHt+108+"px"},500);
			$j("#innerWebServiceDiv").animate({height:237+tableHt+63+"px"},500);
		}
		$j('#requestMsg').hide();
	}
}
function changeButtonLabel()
{
	var groupLabel = $j("#selectedOp option").filter(":selected").parent("optgroup").attr("label");
	if(groupLabel=="Configured Operation")
	{
		$j('#configure').val('Reconfigure');
		$j('#configure').width(90);
	}
	else if(groupLabel=="UnConfigured Operation")
	{
		$j('#configure').val('Configure');
		$j('#configure').width(80);
	}

	var selectedOperationList = document.getElementById("selectedOp");
	var selectedOperationLen = document.getElementById("selectedOp").options.length;
	var opPicked = 0;
	for (var i=0; i<selectedOperationLen; i++)	
	{
		if (selectedOperationList.options[i].selected == true)
		{
			opPicked++;
		}
	}
}
function disableSendReq()
{
	var selectedType = $j('#agentListObj :selected').val();
	if(selectedType=='EgManager')
		$j("#sendReq").attr('disabled',false);
	else
		$j("#sendReq").attr('disabled',true);
}
function hideAlertDiv()
{
	$j("#alertDiv").hide('slow');
}

</script>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="eg_lightlight">
<%
try
{
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	String ua = request.getHeader( "User-Agent" );
	boolean isFirefox = ( ua != null && ua.indexOf( "Firefox/" ) != -1 );
	boolean isMSIE6 = ( ua != null && ua.indexOf( "MSIE 6.0" ) != -1 );
	
	EgSpecsInfo spec = new EgSpecsInfo("manager");
	String egServer = spec.getEGServer();
	String optionValue = "eG Manager-"+egServer;

	EgLicenseInfo licInfo = new EgLicenseInfo();
	com.eg.webservice.EgWebServiceBase wsclient=null;
	EgWebServiceUtil util = new EgWebServiceUtil();

	// inputs given in Testconfig page
	String wsdlUrl = request.getParameter("wsdl");
	String mainOperation = request.getParameter("operation");
	String credentialWithPattern = request.getParameter("credentialWithPattern");
	Hashtable credentPatternTable = new Hashtable();
	if(credentialWithPattern!=null)
	{
		StringTokenizer sCreden = new StringTokenizer(credentialWithPattern,",");
		while(sCreden.hasMoreTokens())
		{
			String credenToken = (String)sCreden.nextToken();
			String cPattern = credenToken.substring(0,credenToken.indexOf(":"));
			String cUserPass = credenToken.substring(credenToken.indexOf(":")+1);
			if(!credentPatternTable.containsKey(cPattern))
				credentPatternTable.put(cPattern,cUserPass);
		}
	}
	// inputs given in webservice config page
	String componentName = request.getParameter("componentName");
	String selectedUrlValue = request.getParameter("selectedUrlValue");
	String selectedServiceValue = request.getParameter("selectedServiceValue");
	String selectedOperationValue = request.getParameter("selectedOperationValue");
	String requestMsg = (String)request.getParameter("requestMsg");
	String reqFrom = request.getParameter("reqFrom");
	String configMode = request.getParameter("configMode");

	String finalValue="";
	Hashtable allInputs = new Hashtable();
	String info ="";
	if(selectedServiceValue!=null && selectedOperationValue!=null && !selectedOperationValue.equals("") && !selectedServiceValue.equals(""))
	{
		info = selectedServiceValue+"_"+selectedOperationValue;
	}

	String selectedUrlPattern = "";
	String selectedUrlOnly = "";
	if(selectedUrlValue!=null && !selectedUrlValue.equals(""))
	{
		selectedUrlPattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
		selectedUrlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
	}

	// For remote control-->Starts
	ArrayList validationMsgs=new ArrayList();
	boolean agentReporting = true;
	EgServerList serverList = new EgServerList();
	String agentID =componentName;
	String sep = System.getProperty("file.separator");
	if(agentID != null && agentID.length()>0 && agentID.indexOf(":")>0)
	{
		agentID = agentID.substring(0,agentID.indexOf(":"));
	}
	List runningAgents = PreAgentInfo.getRunningAgents();
	Vector agentsNotRunning = EgStateManager.notRunningAgents;
	ArrayList allAgents=new ArrayList();
	if(runningAgents!=null && !runningAgents.isEmpty())
		allAgents.addAll(runningAgents);

	if(agentsNotRunning!=null && !agentsNotRunning.isEmpty())
		allAgents.addAll(agentsNotRunning);

	ArrayList totalAgents=serverList.getAgentList(allAgents);
	boolean isAgentInstalled=true;
	if(agentsNotRunning!=null && agentsNotRunning.contains(agentID))
		agentReporting=false;

	if(totalAgents!=null && !totalAgents.isEmpty())
	{
		int agentIdx=totalAgents.indexOf(agentID);
		String agentState=(String)totalAgents.get(agentIdx+1);
		if(agentState!=null && agentState.equalsIgnoreCase("Not Installed-Not Running"))
		{
			isAgentInstalled=false;
		}
	}
	ArrayList allExternalAndRemoteAgents=new ArrayList();
	ArrayList externalAgents=licInfo.getExternalAgents();
	ArrayList remoteAgents=licInfo.getRemoteAgents();
	if(externalAgents!=null && !externalAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(externalAgents);
	if(remoteAgents!=null && !remoteAgents.isEmpty())
		allExternalAndRemoteAgents.addAll(remoteAgents);
	Vector finalAgents=new Vector();
	if(totalAgents!=null && totalAgents.size()>0)
	{
		for(int s=0;s<totalAgents.size();s=s+4)
		{
			String agentIPAdd=(String)totalAgents.get(s);
			if((agentIPAdd!=null && !agentIPAdd.equalsIgnoreCase(agentID)) && (allExternalAndRemoteAgents!=null && !allExternalAndRemoteAgents.contains(agentIPAdd)))
					continue;
			String agentState=(String)totalAgents.get(s+1);
			if(agentState!=null && agentState.equalsIgnoreCase("installed-running"))
			{
				finalAgents.add(agentIPAdd);
			}
		}
	}
	boolean isAgentsAvailable=true;
	boolean singleEntry=false;
	int index=0;
	if(finalAgents!=null)
	{
		if(finalAgents.isEmpty())
		{
			isAgentsAvailable=false;
		}
		//else if(finalAgents.size()==1)
		//{
			//singleEntry=true;
			//index=1;
		//}
	}
	// for remote control----> Ends

	ArrayList operationList=null;
	HashMap serviceMap=null;
	String requestXML="";
	Hashtable operationWithXml = null;
	String targetNameSpace="";
	String prefix="";
	String defaultMsg="";
	if(reqFrom!=null && reqFrom.equals("testConfig"))
	{
		Hashtable clientTable = null;
		clientTable = (Hashtable)session.getAttribute("webServiceBaseTable");
		if(clientTable!=null && clientTable.size()>0)
			clientTable.clear();
		session.setAttribute("webServiceBaseTable",clientTable);

		Hashtable operationWithxmlTable = null;
		operationWithxmlTable = (Hashtable)session.getAttribute("webServiceXmlTable");
		if(operationWithxmlTable!=null && operationWithxmlTable.size()>0)
			operationWithxmlTable.clear();
		session.setAttribute("webServiceXmlTable",operationWithxmlTable);

		session.removeAttribute("webServiceBaseTable");
		session.removeAttribute("webServiceObject");
		session.removeAttribute("webServiceXmlTable");
		session.removeAttribute("webServiceTargetNameSpace");
		session.removeAttribute("webServicePrefix");
	}
	if(selectedUrlValue !=null && !selectedUrlValue.equals(""))
	{
		if(reqFrom.equals("selectUrl") && configMode!=null)
		{
			Hashtable operationListTable = null;
			operationListTable = (Hashtable)session.getAttribute("webServiceBaseTable");
			if(operationListTable!=null && operationListTable.size()>0)
				operationListTable.clear();
			session.setAttribute("webServiceBaseTable",operationListTable);

			Hashtable operationWithxmlTable = null;
			operationWithxmlTable = (Hashtable)session.getAttribute("webServiceXmlTable");
			if(operationWithxmlTable!=null && operationWithxmlTable.size()>0)
				operationWithxmlTable.clear();
			session.setAttribute("webServiceXmlTable",operationWithxmlTable);

			synchronized( session ) {
					session.removeAttribute("webServiceBaseTable");
					session.removeAttribute("webServiceObject");
					session.removeAttribute("webServiceXmlTable");
					session.removeAttribute("webServiceTargetNameSpace");
					session.removeAttribute("webServicePrefix");
			}
			if(configMode.equals("EgManager"))
			{
				String patternOnly = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
				String username="";
				String passwd="";
				if(credentPatternTable!=null && credentPatternTable.containsKey(patternOnly))
				{
					String credential = (String)credentPatternTable.get(patternOnly);
					username = credential.substring(0,credential.indexOf(":"));
					passwd = credential.substring(credential.indexOf(":")+1);
				}
				if(username=="") username="None";
				if(passwd=="") passwd="None";

				String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
				wsclient = new com.eg.webservice.EgWebServiceBase(urlOnly, username, passwd);
				operationList = wsclient.getWsdlOperations();
				serviceMap = wsclient.getWsdlServices();
				if(serviceMap==null && serviceMap.size()==0)
				{
					return;
				}
				
				Hashtable clientTable = (Hashtable)session.getAttribute("webServiceBaseTable");
				if(clientTable==null || clientTable.size()==0)
				{
					clientTable=new Hashtable();
				}
				clientTable.put(urlOnly,operationList);
				synchronized( session ) {
					session.setAttribute("webServiceBaseTable",(Hashtable)clientTable);
					session.setAttribute("webServiceObject",(com.eg.webservice.EgWebServiceBase)wsclient);
				}
			}
			else if(!configMode.equals("EgManager"))
			{
				Hashtable remoteCtrlTable=null;
				if(isAgentInstalled && agentReporting)
				{
					String patternOnly = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
					String username="";
					String passwd="";
					String credential="";
					if(credentPatternTable!=null && credentPatternTable.containsKey(patternOnly))
					{
						credential = (String)credentPatternTable.get(patternOnly);
						username = credential.substring(0,credential.indexOf(":"));
						passwd = credential.substring(credential.indexOf(":")+1);
					}
					remoteCtrlTable = util.getRemoteControlFile(agentID,selectedUrlValue,credential,session.getId());
					if(remoteCtrlTable!=null && remoteCtrlTable.size()>0)
					{
						Hashtable opWithXml = (Hashtable)session.getAttribute("webServiceXmlTable");
						if(opWithXml==null || opWithXml.size()<0)
						{
							opWithXml=new Hashtable();
						}
						Enumeration akey = remoteCtrlTable.keys();
						while(akey.hasMoreElements())
						{
							Object servicekey = akey.nextElement();
							if(servicekey instanceof HashMap)
							{
								serviceMap = (HashMap)servicekey;
								operationList = (ArrayList)remoteCtrlTable.get(servicekey);
							}
							else
							{
								String strKey = (String)servicekey;
								if(!strKey.equals("this.targetNameSpace") || !strKey.equals("this.prefix"))
								{
									String xmlstring = (String)remoteCtrlTable.get(strKey);
									if(!opWithXml.containsKey(strKey))
									{
										opWithXml.put(strKey,xmlstring);
									}
								}
								targetNameSpace = (String)remoteCtrlTable.get("this.targetNameSpace");
								prefix = (String)remoteCtrlTable.get("this.prefix");
							}
						}
						if(serviceMap==null || serviceMap.size()==0)
						{
							return;
						}
						Hashtable clientTable = null;
						clientTable = (Hashtable)session.getAttribute("webServiceBaseTable");
						String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
						if(clientTable==null || clientTable.size()<0)
						{
							clientTable=new Hashtable();
						}
						clientTable.put(urlOnly,operationList);
						synchronized( session ) {
							session.setAttribute("webServiceBaseTable",(Hashtable)clientTable);
							session.setAttribute("webServiceXmlTable",(Hashtable)opWithXml);
							session.setAttribute("webServiceTargetNameSpace",targetNameSpace);
							session.setAttribute("webServicePrefix",prefix);
						}
					}
					else
					{
						defaultMsg="Failed to get required configuration information from agent";
						//return;
					}
				}
				else
				{
					if(!isAgentInstalled)
						defaultMsg="Agent not installed or not running";
					else if(!agentReporting)
						defaultMsg="Failed to get required configuration information from agent";
					//return;
				}
			}
		}
		else
		{
			if(configMode.equals("EgManager"))
			{
				wsclient = (com.eg.webservice.EgWebServiceBase)session.getAttribute("webServiceObject");
				if(wsclient==null)
				{
					String patternOnly = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
					String username="";
					String passwd="";
					String credential="";
					if(credentPatternTable!=null && credentPatternTable.containsKey(patternOnly))
					{
						credential = (String)credentPatternTable.get(patternOnly);
						username = credential.substring(0,credential.indexOf(":"));
						passwd = credential.substring(credential.indexOf(":")+1);
					}
					if(username=="") username="None";
					if(passwd=="") passwd="None";

					String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
					wsclient = new com.eg.webservice.EgWebServiceBase(urlOnly, username, passwd);
					operationList = wsclient.getWsdlOperations();
					serviceMap = wsclient.getWsdlServices();
					if(serviceMap==null && serviceMap.size()==0)
					{
						return;
					}
					Hashtable clientTable = (Hashtable)session.getAttribute("webServiceBaseTable");
					if(clientTable==null || clientTable.size()==0)
					{
						clientTable=new Hashtable();
					}
					clientTable.put(urlOnly,operationList);
					
					synchronized( session ) {
					session.setAttribute("webServiceBaseTable",(Hashtable)clientTable);
					session.setAttribute("webServiceObject",(com.eg.webservice.EgWebServiceBase)wsclient);
					}
				}
				Hashtable userInputTbl = (Hashtable)session.getAttribute("webServiceBaseTable");
				if(userInputTbl!=null && userInputTbl.size()>0)
				{
					Enumeration userKeys = userInputTbl.keys();
					while(userKeys.hasMoreElements())
					{
						String urlKey = (String)userKeys.nextElement();
						operationList = (ArrayList)userInputTbl.get(urlKey);
					}
				}
				if(wsclient==null)
					return;
			}
			else if(!configMode.equals("EgManager"))
			{
				operationWithXml = (Hashtable)session.getAttribute("webServiceXmlTable");
				if(operationWithXml==null)
				{
					Hashtable remoteCtrlTable=null;
					if(isAgentInstalled && agentReporting)
					{
						String patternOnly = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
						String username="";
						String passwd="";
						String credential="";
						if(credentPatternTable!=null && credentPatternTable.containsKey(patternOnly))
						{
							credential = (String)credentPatternTable.get(patternOnly);
							username = credential.substring(0,credential.indexOf(":"));
							passwd = credential.substring(credential.indexOf(":")+1);
						}
						remoteCtrlTable = util.getRemoteControlFile(agentID,selectedUrlValue,credential,session.getId());
						if(remoteCtrlTable!=null && remoteCtrlTable.size()>0)
						{
							operationWithXml = (Hashtable)session.getAttribute("webServiceXmlTable");
							if(operationWithXml==null || operationWithXml.size()<0)
							{
								operationWithXml=new Hashtable();
							}
							Enumeration akey = remoteCtrlTable.keys();
							while(akey.hasMoreElements())
							{
								Object servicekey = akey.nextElement();
								if(servicekey instanceof HashMap)
								{
									serviceMap = (HashMap)servicekey;
									operationList = (ArrayList)remoteCtrlTable.get(servicekey);
								}
								else
								{
									String strKey = (String)servicekey;
									if(!strKey.equals("this.targetNameSpace") || !strKey.equals("this.prefix"))
									{
										String xmlstring = (String)remoteCtrlTable.get(strKey);
										if(!operationWithXml.containsKey(strKey))
										{
											operationWithXml.put(strKey,xmlstring);
										}
									}
									targetNameSpace = (String)remoteCtrlTable.get("this.targetNameSpace");
									prefix = (String)remoteCtrlTable.get("this.prefix");
								}
							}
							if(serviceMap==null || serviceMap.size()==0)
							{
								return;
							}
							Hashtable clientTable = null;
							clientTable = (Hashtable)session.getAttribute("webServiceBaseTable");
							String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
							if(clientTable==null || clientTable.size()<0)
							{
								clientTable=new Hashtable();
							}
							clientTable.put(urlOnly,operationList);
							synchronized( session ) {
								session.setAttribute("webServiceBaseTable",(Hashtable)clientTable);
								session.setAttribute("webServiceXmlTable",(Hashtable)operationWithXml);
								session.setAttribute("webServiceTargetNameSpace",targetNameSpace);
								session.setAttribute("webServicePrefix",prefix);
							}
						}
						else
						{
							defaultMsg="Failed to get required configuration information from agent";
							//return;
						}
					}
					else
					{
						if(!isAgentInstalled)
							defaultMsg="Agent not installed or not running";
						else if(!agentReporting)
							defaultMsg="Failed to get required configuration information from agent";
						//return;
					}
				}
				Hashtable userInputTbl = (Hashtable)session.getAttribute("webServiceBaseTable");
				if(userInputTbl!=null && userInputTbl.size()>0)
				{
					Enumeration userKeys = userInputTbl.keys();
					while(userKeys.hasMoreElements())
					{
						String urlKey = (String)userKeys.nextElement();
						operationList = (ArrayList)userInputTbl.get(urlKey);
					}
				}
				targetNameSpace = (String)session.getAttribute("webServiceTargetNameSpace");
				prefix = (String)session.getAttribute("webServicePrefix");
			}
		}
	}
	if(reqFrom!=null && !reqFrom.equals(""))
	{
		if(reqFrom.equals("testConfig"))
		{
			boolean returnValue = false;
			String iniSubject="";

			iniSubject = "ASSOCIATED";
			returnValue = util.deleteUnUpdatedOperations(mainOperation, componentName, wsdlUrl, iniSubject);
			if(returnValue)
			{
				iniSubject = "CONFIGURED";
				returnValue = util.deleteUnUpdatedOperations(mainOperation, componentName, wsdlUrl, iniSubject);
			}
		}
		else if(reqFrom.equals("save"))
		{
			String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini";
			IniFile webServiceIni  = EgConfigFilesSync.getInstance(iniFileName,true);
			
			String pattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
			String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
			boolean htmlView = false;

			if(selectedUrlValue!=null && selectedOperationValue!=null && !selectedOperationValue.equals("") && !selectedOperationValue.equals("undefined"))
			{
				if(requestMsg==null || requestMsg.equals(""))
				{
					String inputValues = request.getParameter("inputValues");
					Hashtable inputHash = new Hashtable();
					if(inputValues!=null && !inputValues.equals("")){
						StringTokenizer stInput = new StringTokenizer(inputValues,"~");
						while(stInput.hasMoreTokens())
						{
							String inputToken = (String)stInput.nextToken();
							String MainKey = inputToken.substring(0,inputToken.indexOf(":"));
							String subKey = inputToken.substring(inputToken.indexOf(":")+1,inputToken.lastIndexOf(":"));
							String value = inputToken.substring(inputToken.lastIndexOf(":")+1);
							String wholeKey = MainKey+"#"+subKey;
							//Format: Request@#@Reward#CurrencyCode=code,Request@#@Reward#Amount=amt
							if(!inputHash.contains(wholeKey))
							{
								inputHash.put(wholeKey,value);
							}
						}
						htmlView=true;
					}
					if(operationList!=null){
					for (int k = 0; k < operationList.size(); ++k)
					{
						HashMap operation = (HashMap)operationList.get(k);
						String operationName = (String)operation.get("OperationName");
						if(operationName.equals(selectedOperationValue))
						{
							//Format: Request@#@Reward={CurrencyCode=code, Amount=amt, FormattedPrice=}
							Hashtable sample = util.getInputParametersForSave(operationName,operation,inputHash);
						
							String SOAPReq="";
							if(sample!=null && sample.size()>0)
							{
								if(configMode.equals("EgManager"))
									SOAPReq = wsclient.getSOAPRequest(operation,sample);
								else
								{
									if(targetNameSpace!=null && prefix!=null)
									{
										SOAPReq = EgSOAPUtil.getSOAPRequest(operation, prefix, targetNameSpace, sample);
									}
								}
							}
							else 
							{
								if(configMode.equals("EgManager"))
									SOAPReq = wsclient.getSOAPRequest(operation);
								else
								{
									if(operationWithXml!=null && operationWithXml.containsKey(operationName))
										SOAPReq = (String)operationWithXml.get(operationName);
								}
							}
							requestMsg=SOAPReq;
						}
					}
					}
				}
				if(requestMsg!=null && !requestMsg.equals(""))
				{
					StringBuffer resultBuffer = new StringBuffer();
					StringTokenizer stMsg = new StringTokenizer(requestMsg,"\n");
					while(stMsg.hasMoreTokens())
					{
						String msgToken = (String)stMsg.nextToken();
						resultBuffer.append(msgToken);
						resultBuffer.append("");
					}
					String cleaned ="";
					if(!htmlView)
						cleaned= resultBuffer.toString();
					else
						cleaned = requestMsg.replaceAll("\\s*[\r\n]+\\s*", "").trim();
					String iniValues = webServiceIni.getValue("CONFIGURED_OPERATIONS",componentName+":"+pattern);
					if(iniValues!=null && !iniValues.equals(""))
					{
						ArrayList iniList = new ArrayList();
						StringTokenizer iniTkn = new StringTokenizer(iniValues,",");
						while(iniTkn.hasMoreTokens())
						{
							String iniToken = (String)iniTkn.nextToken();
							iniList.add(iniToken);
						}
						String finalValues="";
						if(!iniList.contains(info))
							finalValues = iniValues+","+info;
						else
							finalValues = iniValues;

						webServiceIni.setValue ("CONFIGURED_OPERATIONS",componentName+":"+pattern,finalValues);
					}
					else
					{
						webServiceIni.setValue ("CONFIGURED_OPERATIONS",componentName+":"+pattern,info);
					}
					webServiceIni.saveFile();
					webServiceIni.setValue ("CONFIGURED_SOAP_REQUEST",componentName+":"+pattern+":"+info,cleaned);
					webServiceIni.saveFile();
					//Remove saved operation from [associated_operation] entry in ini 
					String iniSubject = "ASSOCIATED";
					boolean returnValue = util.disassociateFunction(selectedUrlValue,componentName,iniSubject,selectedOperationValue,selectedServiceValue);
				}
			}

			webServiceIni.saveFile();
			EgConfigFilesSync.releaseInstance(webServiceIni);
		}
		// Save Operations on associate--> start
		else if(reqFrom.equals("associate"))
		{
			String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini";
			IniFile webServiceIni  = EgConfigFilesSync.getInstance(iniFileName,true);
			
			String pattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
			String urlOnly = selectedUrlValue.substring(selectedUrlValue.indexOf(":")+1);
			String associatedOp = (String)request.getParameter("associatedOp");
			
			String reqMsg="";
			String newInfo="";
			if(associatedOp!=null && associatedOp.length()>0)
			{
				StringTokenizer stop = new StringTokenizer(associatedOp,",");
				while(stop.hasMoreTokens())
				{
					String token = (String)stop.nextToken();
					if(operationList!=null)
					{
						for (int k = 0; k < operationList.size(); ++k)
						{
							HashMap operation = (HashMap)operationList.get(k);
							String operationName = (String)operation.get("OperationName");
							
							if(operationName.equals(token))
							{
								if(configMode.equals("EgManager"))
									reqMsg = wsclient.getSOAPRequest(operation);
								else
								{
									if(operationWithXml!=null && operationWithXml.containsKey(operationName))
										reqMsg = (String)operationWithXml.get(operationName);
								}
								String cleaned = reqMsg.replaceAll("\\s*[\r\n]+\\s*", "").trim();

								newInfo = selectedServiceValue+"_"+token;
								String iniValues = webServiceIni.getValue("ASSOCIATED_OPERATIONS",componentName+":"+pattern);

								if(iniValues!=null && !iniValues.equals(""))
								{
									ArrayList iniList = new ArrayList();
									StringTokenizer iniTkn = new StringTokenizer(iniValues,",");
									while(iniTkn.hasMoreTokens())
									{
										String iniToken = (String)iniTkn.nextToken();
										iniList.add(iniToken);
									}
									String finalValues="";
									if(!iniList.contains(newInfo))
										finalValues = iniValues+","+newInfo;
									else
										finalValues = iniValues;

									webServiceIni.setValue ("ASSOCIATED_OPERATIONS",componentName+":"+pattern,finalValues);
								}
								else
								{
									webServiceIni.setValue ("ASSOCIATED_OPERATIONS",componentName+":"+pattern,newInfo);
								}
								webServiceIni.saveFile();
								webServiceIni.setValue ("ASSOCIATED_SOAP_REQUEST",componentName+":"+pattern+":"+newInfo,cleaned);
								webServiceIni.saveFile();
							}
						}
					}
				}
			}

			webServiceIni.saveFile();
			EgConfigFilesSync.releaseInstance(webServiceIni);

		}
		//End
		else if(reqFrom.equals("disassociate"))
		{
			String associatedOp = (String)request.getParameter("associatedOp");
			String iniSubject="";
			boolean returnValue = false;
			if(associatedOp!=null && !associatedOp.equals(""))
			{
				iniSubject = "ASSOCIATED";
				returnValue = util.disassociateFunction(selectedUrlValue,componentName,iniSubject,associatedOp,selectedServiceValue);
				if(returnValue)
				{
					iniSubject = "CONFIGURED";
					returnValue = util.disassociateFunction(selectedUrlValue,componentName,iniSubject,associatedOp,selectedServiceValue);
				}
			}
		}
	}
	
	IniFile webIni1 =  new IniFile(EgInstallInfo.getInstallDir() + 
									"/manager/config/eg_webservices.ini");
	String variables[] = webIni1.getVariables("CONFIGURED_OPERATIONS");
	if(variables!=null && variables.length >0)
	{
		for(int s=0;s<variables.length;s++)
		{
			String opVariable = (String)variables[s];
			String compName = opVariable.substring(0,opVariable.lastIndexOf(":"));
			if(compName.equals(componentName.trim()))
			{
				String opValue = webIni1.getValue("CONFIGURED_OPERATIONS",opVariable);
				String urlPattern = opVariable.substring(opVariable.lastIndexOf(":")+1);
				StringBuffer res = new StringBuffer();
				StringTokenizer tt = new StringTokenizer(opValue,",");
				while(tt.hasMoreTokens())
				{
					String tok = (String)tt.nextToken();
					String withPattern = urlPattern+":"+tok;	
					res.append(withPattern);
					res.append(",");
				}
				String resValue = res.toString();
				if(resValue.endsWith(","))
					resValue = resValue.substring(0,resValue.lastIndexOf(","));

				finalValue=finalValue+","+resValue;
			}
		}
	}

	String associatedVar[] = webIni1.getVariables("ASSOCIATED_OPERATIONS");
	if(associatedVar!=null && associatedVar.length >0)
	{
		for(int s=0;s<associatedVar.length;s++)
		{
			String opVariable = (String)associatedVar[s];
			String compName = opVariable.substring(0,opVariable.lastIndexOf(":"));
			if(compName.equals(componentName.trim()))
			{
				String opValue = webIni1.getValue("ASSOCIATED_OPERATIONS",opVariable);
				String urlPattern = opVariable.substring(opVariable.lastIndexOf(":")+1);
				StringBuffer res = new StringBuffer();
				StringTokenizer tt = new StringTokenizer(opValue,",");
				while(tt.hasMoreTokens())
				{
					String tok = (String)tt.nextToken();
					String withPattern = urlPattern+":"+tok;
					res.append(withPattern);
					res.append(",");
				}
				String resValue = res.toString();
				if(resValue.endsWith(","))
					resValue = resValue.substring(0,resValue.lastIndexOf(","));

				finalValue=finalValue+","+resValue;
			}
		}
	}
	finalValue = finalValue.trim();
	if(finalValue!=null && !finalValue.equals(""))
	{
		if(finalValue.startsWith(","))
			finalValue = finalValue.substring(finalValue.indexOf(",")+1);
		if(finalValue.endsWith(","))
			finalValue = finalValue.substring(0,finalValue.lastIndexOf(","));
	}
	if(finalValue.equals(""))
		finalValue="None";
	
	if(reqFrom!=null && !reqFrom.equals("") && reqFrom.equals("sendRequest"))
	{
		String inputValues = request.getParameter("inputValues");
		if(inputValues!=null && !inputValues.equals("")){
			StringTokenizer stInput = new StringTokenizer(inputValues,"~");
			while(stInput.hasMoreTokens())
			{
				String inputToken = (String)stInput.nextToken();
				String MainKey = inputToken.substring(0,inputToken.indexOf(":"));
				String subKey = inputToken.substring(inputToken.indexOf(":")+1,inputToken.lastIndexOf(":"));
				String value = inputToken.substring(inputToken.lastIndexOf(":")+1);
				String wholeKey = MainKey+"#"+subKey;
				if(!allInputs.contains(wholeKey))
				{
					allInputs.put(wholeKey,value);
				}
			}
		}
	}

%>
<!-- Loading Div -->
<div id ="loading_image" style = "position:absolute;top:100px;left:150px;visibility:visible;display:none;border:0px solid #ff0000;"> 
	<table height="100%">
		<tr>
			<td height="100%" valign="middle" class="x-mask-msg div"> 
				<div> </div>
			</td>
		</tr>
	</table>
</div>
<div id="alertDiv" name="alertDiv" style="display:none;left:160px;top:125px;width:300px;height:100px;border:0px solid #ff0000; position:absolute;">
	<table  border="0" cellspacing="0" cellpadding="0" width="100%">
		<tr>
			<td class="pop2_lefttop_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_top_bg" width="100%"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_righttop_curve" ><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
		<tr>
			<td class="pop2_left_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
			<td class="eg_whitebg" align="center">
				<div style="height:50px;border:1px solid black;">
					<table border="0" cellspacing="0" cellpadding="4" align="center" width="100%">
						<tr align="center">
							<td>
								<div id="alertResultDiv">
								<egui:intnl text='<%="admin.common."+defaultMsg%>'/>
								</div>
							</td>
						</tr>
						<tr align="center">
							<td><input type="button" class="eg_lightbutton" name="okButton" id="okButton" value=" OK " onclick="javascript:hideAlertDiv();"style="padding-left:4px;padding-right:4px"></td>
						</tr>
					</table>
				</div>
			</td>
			<td class="pop2_right_bg"><img src="/final/admin/eg_images/spacer.gif" width="11" height="50px"></td>
		</tr>
		<tr>
			<td class="pop2_leftbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
			<td class="pop2_bottom_bg"><img src="/final/admin/eg_images/spacer.gif" width="2" height="11"></td>
			<td class="pop2_rightbottom_curve"><img src="/final/admin/eg_images/spacer.gif" width="11" height="11"></td>
		</tr>
	</table>
</div>
<tr>
	<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
</tr>
<table border="2px" cellspacing="0" cellpadding="0" align="center" style="border-spacing:0px;" width="100%">
	<tr>
		<td style="padding-left:10px">
			<table cellspacing="0" cellpadding="0" border="0">
			<tr>
				<td nowrap>
					<egui:intnl text="admin.common.Please choose Manager or agent for configuration"/>&nbsp;:
				</td>
				<td>
					&nbsp;
				</td>
				<td>
					<select id="agentListObj" width="120" onchange ="disableSendReq();">
					<option value="EgManager" SELECTED><%=optionValue%></option>
<%					for(int t=0;t<finalAgents.size();t=t+1)
					{
						String s=(String)finalAgents.get(t);
						//String selected="";
						//if(s!=null && s.equalsIgnoreCase(agentID))
						{
%>							<option value="<%=s%>"><%=s%></option>
<%						}
					}
%>					</select>
				</td>
			</tr>
			</table>
		</td>
	</tr>
	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>
	<tr style="padding-bottom:0px;border-spacing:0px">
		<td style="padding-left:10px">
				<table align="left" cellspacing="0" cellpadding="0" border="0">
					<tr>
						<td class="eg_subcontent" ><egui:intnl text="admin.common.WSDL URL"/>&nbsp;</td>
						<td width="5" class="eg_subcontent">:&nbsp;</td>
						<td class="eg_subcontent">
							<select name="wsdlUrl" id="wsdlUrl" style="width:569px" onchange="selectUrl(this.value);" >
							<option value=""><egui:intnl text="admin.common.Select URL"/></option>
<%
								if(wsdlUrl!=null && !wsdlUrl.equals(""))
								{
									StringTokenizer strToken=null;
									if(wsdlUrl.indexOf(",")>-1)
										strToken = new StringTokenizer(wsdlUrl,",");
									else if(wsdlUrl.indexOf("|")>-1)
										strToken = new StringTokenizer(wsdlUrl,"|");
									else
										strToken = new StringTokenizer(wsdlUrl,"");
									while(strToken.hasMoreTokens())
									{
										String token = (String)strToken.nextToken();
										String pattern = token.substring(0,token.indexOf(":"));
										String urlValue = token.substring(token.indexOf(":")+1);
										
										if(urlValue!=null && !urlValue.equals(""))
										{
											if(urlValue.endsWith("/"))
												urlValue = urlValue.substring(0,urlValue.lastIndexOf("/"));
											
%>											<option value=<%=pattern+":"+urlValue%>><%=urlValue%></option>
<%											
										}
									}
								}
%>
							</select>
						</td>
					</tr>
					<tr>
						<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
					</tr>
					<tr>
						<td class="eg_subcontent" ><egui:intnl text="admin.common.Services"/>&nbsp;</td>
						<td width="5" class="eg_subcontent">:&nbsp;</td>
						<td class="eg_subcontent">
							<select name="wsdlService" id="wsdlService" style="width:180px" onchange="selectService(this.value);">
							<option value=""><egui:intnl text="admin.common.Select Service"/></option>
			<%									
								if(serviceMap!=null && serviceMap.size()>0)
								{
									Iterator iter = serviceMap.keySet().iterator();
									while(iter.hasNext()) {
									String key = (String)iter.next();
								
			%>							<option value=<%=key%>> <%=key%> </option>
			<%						}
								}
			%>
							</select>
						</td>
					</tr>
				</table>
		</td>
	</tr>

	<tr>
		<td id="eg_blankspace" height="12" nowrap>&nbsp;</td>
	</tr>

	<tr>
	<td colspan="5" width="100%">
		<table cellspacing="0" cellpadding="0" border="0">
		<tr>
			<td align="left" style="padding-left:10px">
				<table align="left" cellspacing="0" cellpadding="0" border="0" width="90%" id="cell_border1">
					<tr>
						<td id="eg_subheadbg" align="left" valign='middle' class="head_padding4" style ="width:293px;padding-left:10px">
						<Strong><egui:intnl text="admin.common.Monitored Operations"/></Strong>
						</td>
					</tr>
					<tr>
						<td id="eg_subcontentbg" valign="top" >
							<select name="selectedOp" id="selectedOp" size="7" multiple style="width:265px;" onchange ="changeButtonLabel();">
<%
							ArrayList associatedOpList = new ArrayList();
							String configuredValues = webIni1.getValue("CONFIGURED_OPERATIONS",componentName+":"+selectedUrlPattern);
							if(configuredValues!=null && !configuredValues.equals(""))
							{
								StringTokenizer aToken = new StringTokenizer(configuredValues,",");
								int i=0;
								while(aToken.hasMoreTokens())
								{
									String tt = (String)aToken.nextToken();
									//String operationOnly = tt.substring(tt.lastIndexOf("_")+1);
									int serviceLength=0;
									if(selectedServiceValue!=null && !selectedServiceValue.equals(""))
										serviceLength = selectedServiceValue.length();
									else
									{
										if(serviceMap!=null && serviceMap.size()>0)
										{
											String serviceValue="";
											Iterator iter = serviceMap.keySet().iterator();
											while(iter.hasNext()) {
												String key = (String)iter.next();
												if(tt.startsWith(key)){
													serviceValue = key;
												}
											}
											serviceLength = serviceValue.length();
										}
									}
									String operationOnly = tt.substring(serviceLength+1);
									if(operationList!=null && operationList.size()>0)
									{
										for (int k = 0; k < operationList.size(); ++k)
										{
											HashMap operation = (HashMap)operationList.get(k);
											String operationName = (String)operation.get("OperationName");
											if(operationName.equals(operationOnly))
											{
												if(!associatedOpList.contains(operationOnly))
													associatedOpList.add(operationOnly);

												if(i==0)
												{
%>													<optgroup label="Configured Operation">
<%												}
%>												<option value=<%=operationOnly%>> <%=operationOnly%> 													</option>
<%											i++;
											}
										}
									}
								}
							}

							String associatedValues = webIni1.getValue("ASSOCIATED_OPERATIONS",componentName+":"+selectedUrlPattern);
							if(associatedValues!=null && !associatedValues.equals(""))
							{
								StringTokenizer aToken = new StringTokenizer(associatedValues,",");
								int i=0;
								while(aToken.hasMoreTokens())
								{
									String tt = (String)aToken.nextToken();
									//String operationOnly = tt.substring(tt.lastIndexOf("_")+1);
									int serviceLength=0;
									if(selectedServiceValue!=null && !selectedServiceValue.equals(""))
										serviceLength = selectedServiceValue.length();
									else
									{
										if(serviceMap!=null && serviceMap.size()>0)
										{
											String serviceValue="";
											Iterator iter = serviceMap.keySet().iterator();
											while(iter.hasNext()) {
												String key = (String)iter.next();
												if(tt.startsWith(key)){
													serviceValue = key;
													break;
												}
											}
											serviceLength = serviceValue.length();
										}
									}
									String operationOnly = tt.substring(serviceLength+1);

									if(operationList!=null && operationList.size()>0)
									{
										for (int k = 0; k < operationList.size(); ++k)
										{
											HashMap operation = (HashMap)operationList.get(k);
											String operationName = (String)operation.get("OperationName");
											if(operationName.equals(operationOnly))
											{
												if(!associatedOpList.contains(operationOnly))
													associatedOpList.add(operationOnly);

												if(i==0)
												{
%>													<optgroup label="UnConfigured Operation">
<%												}
%>												<option value=<%=operationOnly%>> <%=operationOnly%> 														</option>
<%											i++;
											}
										}
									}
								}
							}
%>
							</select>
						</td>
					</tr>
				</table>
			</td>
			<td align="center" valign="middle" width="10%">
				<input type="button" value='&rsaquo;&rsaquo;' class="eg_back" onClick="JavaScript:disassociate('disassociate');" name="remove" style="width:50px"><br><br>
				<input type="button" value='&lsaquo;&lsaquo;' class="eg_back" OnClick="javascript:changeelement('associate');" style="width:50px"> 
			</td>
			<td align="left" width="45%">
				<table align="center" cellspacing="0" cellpadding="0" width="88%" border="0" id="cell_border1">
					<tr>
						<td id="eg_subheadbg"  align="center" valign='middle' class="head_padding4" style ="width:293px"> <Strong><egui:intnl text="admin.common.Defined Operations"/></Strong>
						</td>
					</tr>
					<tr>
						<td id="eg_subcontentbg" >
							<select name="wsdlOperation" id="wsdlOperation" size="7" multiple style="width:265px">
<%
					if ((operationList != null) && (operationList.size() > 0))
					{
						for (int k = 0; k < operationList.size(); ++k)
						{
							HashMap operation = (HashMap)operationList.get(k);
							String operationName = (String)operation.get("OperationName");
							if(!associatedOpList.contains(operationName))
							{
%>	
								<option value=<%=operationName%>> <%=operationName%> </option>
<%								
							}
						}
					}
%>							</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		</table>
	</td>
	</tr>

	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>

	<tr>
		<td>
			<table cellspacing="0" cellpadding="0" border="0">
				<tr>
					<td class="eg_subcontent" style="padding-left:80px">
						<input type="button" style="position:relative;width:80px;height:20px;z-Index:100;" name="updateImg" id="configure" class="eg_back" value='<egui:intnl text="admin.service.Configure"/>' onClick="javascript:configureOperations();">
					</td>
					<td> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </td>
					<td id="" width="15">
						<input type="radio" name="changeView" id="xmlview" class="eg_input" value="xmlview" checked="checked" onclick="javascript:selectFunction(this.value);">
					</td>
					<td id="xmltd"><egui:intnl text="admin.common.XML View"/></td>
					<td>&nbsp;&nbsp;&nbsp; </td>
					<td id="" width="15"> 
						<input type="radio" name="changeView" id="htmlview" class="eg_input" value="htmlview"  onclick="javascript:selectFunction(this.value);">
					</td>
					<td id="htmltd"><egui:intnl text="admin.common.HTML View"/></td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td id="eg_blankspace" height="6" nowrap>&nbsp;</td>
	</tr>

	<tr style="display:none" id="requestMsg">
		<td >
			<table cellspacing="0" cellpadding="0" border="0" width="100%" class="font_normal11">
				<tr>
					<td class="font_bold"><egui:intnl text="admin.common.SOAP Request Message" /></td>
				</tr>
				<tr>
					<td id="eg_blankspace" height="3" nowrap>&nbsp;</td>
				</tr>
				<tr>
					<td>
					<textarea rows="15" cols="100" accept="xml" id="soapRequest" name="soapRequest">
<%
					if(selectedOperationValue !=null && operationList!=null &&!selectedOperationValue.equals(""))
					{
						for (int k = 0; k < operationList.size(); ++k)
						{
							HashMap operation = (HashMap)operationList.get(k);
							String operationName = (String)operation.get("OperationName");
							if(operationName.equals(selectedOperationValue))
							{
								String groupLabel = request.getParameter("groupLabel");
								if(groupLabel!=null && groupLabel.equalsIgnoreCase("Configured Operation"))
								{
									IniFile webserviceIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini");
									String pattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
									String toFind = componentName+":"+pattern+":"+selectedServiceValue+"_"+selectedOperationValue;
									String soapmsg = webserviceIni.getValue("CONFIGURED_SOAP_REQUEST",toFind);

%>									<%=EgSOAPUtil.formatXML(soapmsg)%>
<%								}
								else
								{
									String SOAPReq="";
									if(allInputs!=null && allInputs.size()>0)
									{
										Hashtable sample = util.getInputParametersForSave(operationName,operation,allInputs);
										if(sample!=null && sample.size()>0)
										{
											if(configMode.equals("EgManager"))
												SOAPReq = wsclient.getSOAPRequest(operation,sample);
											else
											{
												if(targetNameSpace!=null && prefix!=null)
												{
													SOAPReq = EgSOAPUtil.getSOAPRequest(operation, prefix, targetNameSpace, sample);
												}
											}
										}

									}
									else 
									{
										if(configMode.equals("EgManager"))
											SOAPReq = wsclient.getSOAPRequest(operation);
										else
										{
											if(operationWithXml.containsKey(operationName))
											{
												SOAPReq = (String)operationWithXml.get(operationName);
											}
										}
									}
%>
									<%=SOAPReq%>
<%								}
							}
						}
					}
%>					</textarea>
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>

	<tr id="inputTable" style="display:none">
		<td width="100%">
		<div id="assocDiv" class="x-table" style="width:100%;" >
<%
		if(reqFrom!=null)
		{
			if(reqFrom.equalsIgnoreCase("configure") || reqFrom.equalsIgnoreCase("sendRequestXml")) {

			String soapmsg="";
			Hashtable reconfigTable = new Hashtable();
			Hashtable sampleTable = new Hashtable();
			Hashtable keyTable = new Hashtable();
			Hashtable keysfromXML = new Hashtable();
			Hashtable recurseTable= new Hashtable();
			ArrayList notToIterate = new ArrayList();
			if(reqFrom.equalsIgnoreCase("configure"))
			{
				String groupLabel = request.getParameter("groupLabel");
				if(groupLabel!=null && groupLabel.equalsIgnoreCase("Configured Operation"))
				{
					IniFile webserviceIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_webservices.ini");
					String pattern = selectedUrlValue.substring(0,selectedUrlValue.indexOf(":"));
					String toFind = componentName+":"+pattern+":"+selectedServiceValue+"_"+selectedOperationValue;
					soapmsg = webserviceIni.getValue("CONFIGURED_SOAP_REQUEST",toFind);
				}
			}
			else if(reqFrom.equalsIgnoreCase("sendRequestXml"))
			{
				soapmsg = (String)request.getParameter("requestMsg");
			}
		
			if(soapmsg!=null && !soapmsg.equals(""))
			{
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
				DocumentBuilder builder = factory.newDocumentBuilder();
				Document document = builder.parse(new InputSource(new StringReader(soapmsg)));
				NodeList nl = document.getElementsByTagName("*");
				
					for (int n = 0; n < nl.getLength(); ++n)
					{
						StringBuffer keyBuffer = new StringBuffer();
						Node node = nl.item(n);
						NodeList childNodes = node.getChildNodes();
						Node elementNode;
						Element element1 = (Element)nl.item(n);
						Node parentNode = nl.item(n).getParentNode();
						for (int j = 0; j < childNodes.getLength(); ++j)
						{
							String parentnodeName = parentNode.getNodeName();
							String parentKey = parentnodeName.substring(parentnodeName.indexOf(":")+1);
							elementNode = childNodes.item(j);
							boolean hasChild = elementNode.hasChildNodes();
							String elementNodeName = elementNode.getNodeName();
							String tagValue="";
							String nameOnly = elementNodeName.substring(elementNodeName.indexOf(":")+1);
							if(hasChild && elementNodeName.indexOf("soapenv:Body")==-1 && elementNodeName.indexOf("soapenv:Header")==-1)
							{
								String childName="";
								String fullName="";
								if (elementNode.getFirstChild()!=null && elementNode.getFirstChild().getNodeType() == Node.TEXT_NODE)
								{
									tagValue = elementNode.getFirstChild().getNodeValue();
								}
								else
								{
									if(!notToIterate.contains(elementNode))
									{
										notToIterate.add(elementNode);
										keysfromXML = util.findKeysFromXML(elementNode,keysfromXML,nameOnly,recurseTable,keyTable,notToIterate);
									}
									else
										continue;
								}
							}
						}
					}
				for(int i = 0; i < nl.getLength();i++)
				{
					Element element = (Element)nl.item(i);
					NodeList nl2 = nl.item(i).getChildNodes();
					Node parentNode = nl.item(i).getParentNode();
					for(int j = 0; j < nl2.getLength(); j++)
					{
						String parentnodeName = parentNode.getNodeName();
						String nodeName = element.getNodeName();
						String nodeValue = nl2.item(j).getNodeValue();
						String keyOnly = nodeName.substring(nodeName.indexOf(":")+1);
						String parentKey = parentnodeName.substring(parentnodeName.indexOf(":")+1);
						String fullKeyString=parentKey+"#"+keyOnly;
						if(nodeName!=null  && nodeValue!=null)
						{
							nodeValue = nodeValue.trim();
							if(!nodeValue.equals("null") && !nodeValue.equals("Optional")&& !nodeValue.equals("") && !reconfigTable.contains(keyOnly))
							{
								reconfigTable.put(keyOnly,nodeValue);
								sampleTable.put(fullKeyString,nodeValue);
							}
						}
					}
				}
			}
			
			// for getting inputs from user(HTML view)
			Hashtable inputHash = new Hashtable();
			Hashtable innerInputs = null;
			ArrayList resultTableList= new ArrayList();
			ArrayList arrList=null;
			String operationKey = "";
			String operationInputType="";
			if(operationList!=null && selectedOperationValue!=null && !selectedOperationValue.equals(""))
			{
				for (int k = 0; k < operationList.size(); ++k)
				{
					HashMap operation = (HashMap)operationList.get(k);
					String operationName = (String)operation.get("OperationName");
					if(operationName.equals(selectedOperationValue))
					{
						operationKey = operationName;// For hidden td
						operationInputType= (String)operation.get("InputType");
						HashMap InputMap = (HashMap)operation.get("Input");
						Iterator iterator = InputMap.keySet().iterator();
					
						while(iterator. hasNext()){	
							String key = (String)iterator.next();
							HashMap outputMap = (HashMap)InputMap.get(key);
							
							Iterator opiterator = outputMap.keySet().iterator();
							String nameValue=null;
							Object typeValue=null;
							String optional = null;
							Hashtable typeTable = new Hashtable();

							nameValue = (String)outputMap.get("name");
							typeValue = outputMap.get("type");
							optional = (String)outputMap.get("minOccurs");

							if(nameValue==null || nameValue.equals(""))
							{
								nameValue=key;
							}
							if(nameValue!=null)
							{
								if(typeValue==null)
								{
									typeValue=" ";
								}
								if(optional!=null && optional.equals("1") && nameValue.indexOf("*")==-1)
								{
									nameValue = nameValue+"*";
								}
								if(!inputHash.contains(nameValue))
								{
									inputHash.put(nameValue,typeValue);
								}
							}
						}
					}
				}
			}
			ArrayList complexList = new ArrayList();
			if(inputHash!=null && inputHash.size()>0)
			{
				ArrayList valueList = new ArrayList();
				Enumeration allKeys = inputHash.keys();
				HashMap innerType = null;
				while(allKeys.hasMoreElements())
				{
					Object typeValue=null;
					String minOccurs = null;
					String nameKey = (String)allKeys.nextElement();
					typeValue = inputHash.get(nameKey);
					
					if(typeValue instanceof HashMap)
					{
						//start
						HashMap hashmap = (HashMap)typeValue;
						if(hashmap!=null)
						{
							if(hashmap.size()>0 && !hashmap.containsKey("enumeration"))
							{
								Hashtable WithMainKey = new Hashtable();
								innerInputs = util.getInputParameters(nameKey,typeValue,WithMainKey);
								resultTableList.add(innerInputs);
							}
							//  not to show empty table
							else if(hashmap.size()==0 || hashmap.containsKey("enumeration"))
							{
								complexList.add(nameKey);
								if(!valueList.contains(nameKey))
									valueList.add(nameKey);
							}
						}
					}
					else
					{
						if(!valueList.contains(nameKey))
							valueList.add(nameKey);
					}
				}
				if(valueList!=null && valueList.size()>0)
				{
%>
				<table cellspacing="0" cellpadding="3" border="0" id="inputTbl" class="linesquare x-grid-table" width="100%">
					<col width="30%"><col width="60%"><col width="10%">
					<thead>
					<tr class="x-grid-row">
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.SOAP Parameter"/></div></th>
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Value"/></th>
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Type"/></th>
					</tr>
					</thead>
					<tbody>
<%					Enumeration allKeys1 = inputHash.keys();
					while(allKeys1.hasMoreElements())
					{
						Object typeValue=null;
						String minOccurs = null;
						String nameKey = (String)allKeys1.nextElement();
						typeValue = inputHash.get(nameKey);
						if(typeValue instanceof HashMap)
						{
							HashMap hashmap = (HashMap)typeValue;
							ArrayList enumList=null;
							
							if(hashmap!=null && hashmap.size()>0  && hashmap.containsKey("enumeration"))
							{
								enumList = (ArrayList)hashmap.get("enumeration");
							}
							if(hashmap.size()==0 || enumList!=null)
							{
%>								<tr id="inputRow" class="x-grid-row">
									<td style="display:none" class="hiddentd x-grid-cell"><div class="x-grid-cell-inner"><%=operationKey%></div></td>
									<td class="parameterName x-grid-cell"><div class="x-grid-cell-inner"><%=nameKey%></div></td>
									<td class="textField x-grid-cell"><div class="x-grid-cell-inner">
<%
								if(nameKey.endsWith("*"))
									nameKey = nameKey.substring(0,nameKey.indexOf("*"));
								
								String tagValue="";
								if(sampleTable.containsKey(operationKey+"#"+nameKey))
									tagValue = (String)sampleTable.get(operationKey+"#"+nameKey);
								else if(sampleTable.containsKey(operationInputType+"#"+nameKey))
									tagValue = (String)sampleTable.get(operationInputType+"#"+nameKey);
								
								if(tagValue==null)tagValue="";
								if(enumList!=null && enumList.size()>0)
								{
%>									<select name="selectValue" id="selectValue" style="width:190px">
<%									for(int e=0;e<enumList.size();e++)
									{
										String enumValue = (String)enumList.get(e);
										String selected="";
										if(enumValue.equals(tagValue))
										{
											selected="SELECTED";
										}
%>
										<option value="<%=enumValue%>" <%=selected%>><%=enumValue%></option>
<%
									}
%>
									</select>
<%								}
								else
								{
%>									<input type="text" name="inputValue" id="inputValue" size="30" value="<%=tagValue%>">
<%								}
%>								</div></td>
<%
								if(enumList!=null && enumList.size()>0)
								{
									HashMap dummy = new HashMap();
%>									<td class="x-grid-cell"><div class="x-grid-cell-inner"><%=dummy%></div></td>
<%								}
								else
								{
%>									<td class="x-grid-cell"><div class="x-grid-cell-inner"><%=typeValue%></div></td>
<%								}
%>
								</tr>
<%							}
						}
						else
						{
							
%>							<tr id="inputRow" class="x-grid-row">
							<td style="display:none" class="hiddentd x-grid-cell"><div class="x-grid-cell-inner"><%=operationKey%></div></td>
							<td class="parameterName x-grid-cell"><div class="x-grid-cell-inner"><%=nameKey%></div></td>
							<td class="textField x-grid-cell"><div class="x-grid-cell-inner">
<%
								if(nameKey.endsWith("*"))
									nameKey = nameKey.substring(0,nameKey.indexOf("*"));

								String tagValue="";
								if(sampleTable.containsKey(operationKey+"#"+nameKey))
									tagValue = (String)sampleTable.get(operationKey+"#"+nameKey);
								else if(sampleTable.containsKey(operationInputType+"#"+nameKey))
									tagValue = (String)sampleTable.get(operationInputType+"#"+nameKey);
								
								if(tagValue==null)tagValue="";

%>								<input type="text" name="inputValue" id="inputValue" size="30" value="<%=tagValue%>">
<%								
%>							</div></td>
							<td class="x-grid-cell"><div class="x-grid-cell-inner"><%=typeValue%></div></td>
							</tr> 
<%						}
					}
%>				
					</tbody>
				</table>
<%
				}
			}
			else
			{
%>				<table id="inputTbl" class="linesquare x-grid-table" width="100%" align="center">
					<thead>
					<tr class="x-grid-row">
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.SOAP Parameter"/></div></th>
					</tr>
					</thead>
					<tbody>
					<tr class="x-grid-row">
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.No Input Parameters required for this operation"/></div></td>
					</tr>
					</tbody>
				</table>
<%
			}
			if(resultTableList!=null && resultTableList.size()>0)
			{
				for(int r=0;r<resultTableList.size();r++)
				{
					Hashtable innerInputHash = (Hashtable)resultTableList.get(r);
					if(innerInputHash!=null && innerInputHash.size()>0)
					{
						String mkey="";
						String skey="";
						ArrayList mList = null;
				
						Enumeration mainKey = innerInputHash.keys();
						while(mainKey.hasMoreElements())
						{
							mkey = (String)mainKey.nextElement();
							
							// not to show empty table 
							ArrayList typeList = new ArrayList();
							ArrayList dupList = (ArrayList)innerInputHash.get(mkey);
							if(dupList!=null && dupList.size()>0)
							{
								for(int m=0;m<dupList.size();m++)
								{
									Hashtable mValue = (Hashtable)dupList.get(m);
									Enumeration innerKey = mValue.keys();
									while(innerKey.hasMoreElements())
									{
										String key = (String)innerKey.nextElement();
										Object value = mValue.get(key);
										if(value instanceof HashMap)
										{
											HashMap hash = (HashMap)value;
											ArrayList enumList=null;
											if(hash!=null && hash.size()>0 && hash.containsKey("enumeration"))
											{
												enumList = (ArrayList)hash.get("enumeration");
											}
											if(hash.size()==0 || enumList!=null)
											{
												complexList.add(key);
												if(!typeList.contains(key))
													typeList.add(key);
											}
										}
										else
										{
											if(!typeList.contains(key))
												typeList.add(key);
										}
									}
								}
							}

							if(typeList!=null && typeList.size()>0)
							{
								StringBuffer strBuff = new StringBuffer();
								String tokens[] = EgUtils.getTokens(mkey,"@#@");
								if(tokens!=null && tokens.length>0)
								{
									for(int v=0;v<tokens.length;v++)
									{
										String thisTok = (String)tokens[v];
										strBuff.append("&lt;");
										strBuff.append(thisTok);
										strBuff.append("&gt;");
										strBuff.append("-");
									}
								}
								String replacedString = strBuff.toString();
								if(replacedString.endsWith("-"))
								{
									replacedString = replacedString.substring(0,replacedString.lastIndexOf("-"));
								}
%>
							<table cellspacing="0" cellpadding="1" border="0" class="linesquare x-grid-table" width="100%" >
								<thead>
									<tr class="x-grid-row">
										<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text='<%="admin.common. "+replacedString%>'/></div></th>
								</tr>
								</thead>
							</table>
							<table cellspacing="0" cellpadding="3" border="0" id="subinputTbl" class="linesquare x-grid-table" width="100%">
								<col width="30%"><col width="60%"><col width="10%">
								<thead>
								<tr class="x-grid-row">
									<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.SOAP Parameter"/></div></th>
									<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Value"/></th>
									<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.Type"/></th>
								</tr> 
								</thead>
								<tbody>
		<%
							mList = (ArrayList)innerInputHash.get(mkey);
							if(mList!=null && mList.size()>0)
							{
								for(int m=0;m<mList.size();m++)
								{
									Hashtable mValue = (Hashtable)mList.get(m);
									Enumeration innerKey = mValue.keys();
									while(innerKey.hasMoreElements())
									{
										String key = (String)innerKey.nextElement();
										Object value = mValue.get(key);
										HashMap hash=null;
										ArrayList enumList=null;
										if(value instanceof HashMap)
										{
											hash = (HashMap)value;
											if(hash!=null && hash.size()>0 && hash.containsKey("enumeration"))
											{
												enumList = (ArrayList)hash.get("enumeration");
											}
											if(hash.size()>0 && !hash.containsKey("enumeration"))
												continue;
										}
%>
								<tr id="subinputRow" class="x-grid-row">
									<td style="display:none" class="hiddentd x-grid-cell"><div class="x-grid-cell-inner"><%=mkey%></div></td>
									<td id="cell_border" class="parameterName x-grid-cell"><div class="x-grid-cell-inner"><%=key%></div></td>
									<td id="cell_border" class="textField x-grid-cell"><div class="x-grid-cell-inner">
<%
												if(key.endsWith("*"))
													key = key.substring(0,key.indexOf("*"));
												
												String opInputType="";
												for (int k = 0; k < operationList.size(); ++k)
												{
													HashMap operation = (HashMap)operationList.get(k);
													String operationName = (String)operation.get("OperationName");
													if(operationName.equals(selectedOperationValue))
													{
														opInputType= (String)operation.get("InputType");
													}
												}
												Hashtable insideOpKey=new Hashtable();
												if(keysfromXML.containsKey(opInputType))
												{
													Object tagVal = keysfromXML.get(opInputType);
													if(tagVal instanceof Hashtable)
														insideOpKey = (Hashtable)tagVal;
												}
												else if(keysfromXML.containsKey(selectedOperationValue))
												{
													Object tagVal = keysfromXML.get(selectedOperationValue);
													if(tagVal instanceof Hashtable)
														insideOpKey = (Hashtable)tagVal;
												}
												String tagValue = util.findTagValues(insideOpKey,mkey,key); 
												if(tagValue==null)
													tagValue="";
												
												if(enumList!=null && enumList.size()>0)
												{
%>													<select name="selectValue" id="selectValue" style="width:190px">
		<%											for(int e=0;e<enumList.size();e++)
													{
															String enumValue = (String)enumList.get(e);
															String selected="";
															if(enumValue.equals(tagValue))
															{
																selected="SELECTED";
															}
%>															<option value="<%=enumValue%>" <%=selected%>><%=enumValue%></option>
<%													}
%>													</select>
<%												}
												else
												{
%>
												<input type="text" name="inputValue"  id="inputValue" size="30" value="<%=tagValue%>">
<%												}
												
%>											</div></td>
<%											if(enumList!=null && enumList.size()>0)
											{
												HashMap dummy = new HashMap();
%>												<td class="x-grid-cell"><div class="x-grid-cell-inner"><%=dummy%></div></td>
<%												
											}
											else
											{
%>												<td class="x-grid-cell"><div class="x-grid-cell-inner"><%=value%></div></td>
<%											}
%>										</tr>
								
		<%							}
								}
							}
		%>					</table>
		<%					}
						}
					}
				}
			}
			if(resultTableList.size()==1)
			{
				Hashtable innerInputHash = (Hashtable)resultTableList.get(0);
				if(innerInputHash.size()==0)
				{
%>				<table id="inputTbl" class="linesquare x-grid-table" width="100%" align="center">
					<thead>
					<tr class="x-grid-row">
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.SOAP Parameter"/></div></th>
					</tr>
					</thead>
					<tbody>
					<tr class="x-grid-row">
						<th class="x-grid-cell"><div class="x-grid-cell-inner"><egui:intnl text="admin.common.No Input Parameters required for this operation"/></div></td>
					</tr>
					</tbody>
				</table>
<%
				}
			}
		}
		}
%>
 			</div>
		</td>
	</tr>

	<tr>
		<td id="eg_blankspace" height="10" nowrap>&nbsp;</td>
	</tr>

	<tr id="buttonRow" style="display:none">
		<td>
			<table width="100%" border="0" cellspacing="0" cellpadding="0" >
				<tr>
					<td class="eg_subcontent" style="padding-left:175px">
						<input type="button" style="width:155px;height:20px;z-Index:100;" name="updateImg" id="save" class="eg_back" value='<egui:intnl text="admin.service.Save And Configure More"/>' disabled onClick="javascript:save();">
					</td>
					<td class="eg_subcontent" style="padding-right:215px">
						<input type="button" style="width:100px;height:20px;z-Index:100;" name="updateImg" id="sendReq" class="eg_back" value='<egui:intnl text="admin.service.Send Request"/>' disabled onClick="javascript:sendRequest();">
					</td>
				</tr>
			</table>
		</td>
	</tr>

	<tr id="op" style="display:none">
		<td> 
			<div id="operationResult" ><%=finalValue%></div>
		</td>
	</tr>
	
</table>
<input type="hidden" name="wsdl" id="wsdl" value="<%=wsdlUrl%>">
<input type="hidden" name="componentName" id="componentName" value="<%=componentName%>">
<input type="hidden" name="mainOperation" id="mainOperation" value="<%=mainOperation%>">
<input type="hidden" name="credentialWithPattern" id="credentialWithPattern" value="<%=credentialWithPattern%>">
</body>
<%
}
catch(Exception e)
{
	e.printStackTrace();
}
%>
</html>

