<%
/*
 *   File		:	EgConfigureComponentTestsp.jsp
 *   Purpose	:	Processing page for test configuration
 *   Author		:	S.Anand (2008)
*/
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="com.eg.EgSpecsInfo" %>
<%@ page import="com.eg.EgExternalInfo" %>
<%@ page import="com.eg.EgAggregateInfo"%>
<%@ page import="com.eg.EgDiscInfo" %>
<%@ page import="java.net.URLEncoder" %>
<%@ page import="com.eg.EgCrypt" %>
<%@ page import="com.eg.EgServicesInfo" %>
<%@ page import="com.egurkha.util.*" %>
<%@ page import="com.eg.EgUtils"%>
<%@ page import="com.eg.IniFile" %>
<%@ page import="java.io.File" %>
<%@ page import="com.eg.UploadCorrectiveScript" %>
<%@ page import="com.eg.EgServicesInfo"%>
<%@ page import="com.eg.EgURLEncoder" %>
<%@ page import="com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import = "net.sf.json.*"%>

<jsp:useBean id="prgBean" scope="page" class="egurkha.EgTestParamBean"/>
<jsp:useBean id="servicer" class="egurkha.ServiceBean" scope="page" />

<%!
	String eventTests[] = {"UserEnviron2008Test","SecurityLogTest","ADAMEvtLogTest","FRSEvtLogTest","DSEvtLogTest","DNSEvtTest","VsEvtLogTest","SystemEvtLogTest","AppEvtLogTest","SystemEvtTest","AppEvtTest","CustEvtLogTest"};

	String[] getDeleteQueries(String componentName,String testname)
	{
		String[] str = StringUtils.getTokens(componentName,":");
		String measure_last = "delete from measure_last where test_name='"+testname+"' and trgt_host='"+str[0]+"' and port_no='NULL' and site_name>'' and info>'' and msmt_host >''";
		String metatest = "delete from metatest where comp_name='"+componentName+"' and comp_type>'' and site_name>'' and info>'' and msmt_host>'' and test_name ='"+testname+"'";
		String testtable = "delete from "+testname+" where trgt_host='"+str[0]+"' and port_no='NULL' and site_name>'' and info>'' and msmt_host>'' and msmt_time>''";
		String reporttable = "delete from report where site_name>'' and comp_name='"+componentName+"' and comp_type>'' and info>'' and layer_name>'' and test_name='"+testname+"' and measure>'' and msmt_time>''";
		String query[] = {measure_last,metatest,testtable,reporttable};
		return query;
	}
%>

<%

	JSONObject rootJson = new JSONObject();
	//A component which the user is going to configure in the main test configuration page is
	//referred as UserInitiatedComponent. A test which is choosen by the user in the main page
	//for configuration is referred as UserInitiatedTest.

	//code for auditlog - starts
	boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
	AuditLogThread auditLogThread = null;
	int auditParamIdx = 1;
	if (isAuditLogEnabled)
	{
		auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Tests");
		auditLogThread.setValue("Activity","Configure Test");
	}
	//code for auditlog - ends

	//list having ini values for the selected test only.
	ArrayList aListParamNamesAndValues = (ArrayList)session.getAttribute("aListParamNamesValues");

	Hashtable hashTestsAndDelimiters = new Hashtable();

	//contains tests having '#' as delimiter - starts
	String testNameDelimiter[] = egSpecs.getTestInfosWithDelimiters();
	ArrayList aListTestsWithDelimiterHash = new ArrayList();
	for (int i=0; i<testNameDelimiter.length; i++)
	{
		String delimiter = egSpecs.getTestInfoDelimiter(testNameDelimiter[i]);
		if (delimiter.equals("#"))
		{
			if (!aListTestsWithDelimiterHash.contains(testNameDelimiter[i]))
			{
				aListTestsWithDelimiterHash.add(testNameDelimiter[i]);
			}
		}
		hashTestsAndDelimiters.put(testNameDelimiter[i].trim(),delimiter);
	}
	//contains tests having '#' as delimiter - ends

	Hashtable hashDelimitersAndMasks = new Hashtable();
	IniFile testsIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
	String strDelimiters[] = testsIni.getVariables("TEST_INFO_DELIMITER_MASK");
	for (int m=0;m<strDelimiters.length;m++)
	{
		String strDelimiterTemp = strDelimiters[m];
		String strMaskTemp = testsIni.getValue("TEST_INFO_DELIMITER_MASK",strDelimiterTemp);
		hashDelimitersAndMasks.put(strDelimiterTemp,strMaskTemp);
	}

	String strDelimiter = "";
	String strMask = "";
	boolean b_testWithDelimiter = false;
	boolean b_delimiterWithMask = false;

	Arrays.sort(paramToContinue,String.CASE_INSENSITIVE_ORDER);
	Arrays.sort(snmpV1V2ParamToContinue,String.CASE_INSENSITIVE_ORDER);

	//whether the request comes from test-configure main page (EgConfigureComponentTests.jsp)
	//or intermediate page - apply to other components (EgApplyToOtherComponents.jsp).
	String fromPage = request.getParameter("requestFrom");
	fromPage = (fromPage != null)?fromPage:"EgConfigureComponentTests.jsp";

	ArrayList aListSpecialCharacterAllowedParam = new ArrayList();
	String specialCharactersAllowedParameter = (String)session.getAttribute("specialCharactersAllowedParameter");
	if (!StringUtils.isNull(specialCharactersAllowedParameter))
	{
		StringTokenizer stParams = new StringTokenizer(specialCharactersAllowedParameter,",");
		while (stParams.hasMoreTokens())
		{
			String specialParam = (stParams.nextToken()).toLowerCase();
			aListSpecialCharacterAllowedParam.add(specialParam);
		}
	}

	String[] tcKeywords = (String[])session.getAttribute("tcKeywords");
	ArrayList aListEgKeyWords = new ArrayList(Arrays.asList(tcKeywords));

	ArrayList aListPasswordParameters = (ArrayList)session.getAttribute("aListPasswordParameters");
	boolean hasPasswordParameters = false;
	if (aListPasswordParameters != null)
	{
		hasPasswordParameters = true;
	}

	boolean isOldSnmp = false;
	Boolean isOldSnmpObj = (Boolean)session.getAttribute("isOldSnmp");
	if (isOldSnmpObj != null)
	{
		isOldSnmp = isOldSnmpObj.booleanValue();
	}

	String componentType = "";
	String componentName = "";
	String testName = "";
	String testPeriod = "";
	String detailedDiagnosis = "";

	//For result page
	ArrayList aListDisplayParamNamesAndValues = new ArrayList();

	//Apply to other components - Start
	String selectedParameters = "";
	String selectedComponents = "";
	//Apply to other components - End

	//This list will contain user updated parameter name and values
	ArrayList aListTemp = new ArrayList();

	//This list will contain list of components
	ArrayList aListComponents = new ArrayList();

	//put for intermediate page - starts
	Hashtable hashParamNamesAndValues = new Hashtable();
	ArrayList aListChoosenParameters = null;
	ArrayList aListChoosenParametersInLowerCase = new ArrayList();
	StringTokenizer stParamTemp = null;
	ArrayList aListTempValue = new ArrayList();
	ArrayList aListSelectedComponents = null;
	//put for intermediate page - ends

	//performance test or configuration test
	String testType = "";

	//contains enabled test for a component type
	ArrayList aListEnabledTestForCompType = new ArrayList();

	ArrayList aListParamsWithDoubleQuotes = (ArrayList)session.getAttribute("aListParamsWithDoubleQuotes");
	if (aListParamsWithDoubleQuotes == null)
	{
		aListParamsWithDoubleQuotes = new ArrayList();
	}

	//creating the ini object
	IniFile agentIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_agents.ini");
	IniFile testParamIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testparam.ini");
	IniFile disableIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_disable.ini");
	IniFile testinfoIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_testinfo.ini");
	boolean allowAggOperation = false;
	IniFile aggIni = null;
	if (allowAggOperation)
	{
		aggIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_aggregate.ini");
	}
	IniFile eg_vcmappingIni = null;
	IniFile eg_servicesIni = null;
	IniFile eg_hmcMapping = null;
	IniFile eg_rhevMapping = null;
	IniFile eg_nutanixMapping = null;

	//variables declared for config file sync - starts
	ArrayList aListAgentsIniEntries = null;
	ArrayList aListServicesIniEntries = null;
	ArrayList aListHmcMappingIniEntries = null;
	ArrayList aListVcMappingIniEntries = null;
	ArrayList aListRhevMappingIniEntries = null;
	ArrayList aListTestInfoIniEntries = null;
	ArrayList aListNutMappingIniEntries = null;
	//variables declared for config file sync - ends

	boolean isPortRelevantForTest = false;
	if (fromPage.equals("EgConfigureComponentTests.jsp"))
	{
		componentType = request.getParameter("componentType");
		componentName = request.getParameter("componentName");
		testName = request.getParameter("testName");
		isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
		testPeriod = request.getParameter("testPeriod");
		testType = request.getParameter("testType");
		testType = testType != null?testType:"PerformanceTest";
		detailedDiagnosis = request.getParameter("detaileddiagnosis");

		b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		// for bug id - 14020
		String strEvtLogSub = "EVENTLOG_POLICIES";
		String strEvtlogPolicies[] = testsIni.getVariables(strEvtLogSub);
		ArrayList specificTestsEventLogPolicyList = new ArrayList();
		if (strEvtlogPolicies != null)
		{
			for (int i=0;i<strEvtlogPolicies.length;i++)
			{
				String strPolicyVar = strEvtlogPolicies[i];
				if (!com.egurkha.util.StringUtils.isNull(strPolicyVar) && strPolicyVar.startsWith(testName.trim()))
				{
					specificTestsEventLogPolicyList.add(strPolicyVar);
				}
			}
		}
		// for bug id - 14020

		String strFilterType = request.getParameter("selectedFilterType");
		//contains user updated parameter name and values - starts
		Enumeration e = request.getParameterNames();
		while (e.hasMoreElements())
		{
			String strParamName = (String)e.nextElement();
			String strParamValue = request.getParameter(strParamName);

			if (!StringUtils.isNull(strParamName) && strParamName.equals("data_over_tcp"))
			{
				String groupLead = request.getParameter(strParamName+"_radioGrp");
				String sasiTestYes = request.getParameter(strParamName+"1");
				String sasiTestNo = request.getParameter(strParamName+"2");
				//strParamValue
			}
			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
						
			boolean isPasswordParameter = false;
			boolean allowToTrim = true;
			if (hasPasswordParameters)
			{
				if (aListPasswordParameters.contains("-"+strParamName))
				{
					isPasswordParameter = true;
					allowToTrim = false;
				}
			}

			if (!isPasswordParameter)
			{
				if (strParamValue.indexOf(" -") > -1 || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
				{
					strParamValue = "\"" + strParamValue + "\"";
					allowToTrim = false;
				}
			}

			//a line feed ('\n') or enter key
			while(strParamValue.indexOf("\n") > -1)
			{
				int idx = strParamValue.indexOf("\n");
				String strPrefix = strParamValue.substring(0,idx);
				String strSuffix = strParamValue.substring(idx+1,strParamValue.length());
				strSuffix = strSuffix.trim();
				strParamValue = strPrefix + strSuffix;
			}

			if (strParamName.equalsIgnoreCase("management_server_text"))
			{
				strParamName = "management_server";
			}

			if (strParamName.equalsIgnoreCase("-logtype"))
			{
				strParamValue = strParamValue.toLowerCase();
			}

			//special case - if the user selects multiple value for filter
			if (strParamName.equalsIgnoreCase("filter") || strParamName.equalsIgnoreCase("filter_combo"))
			{
				String[] filterValue = null;
				if  (!StringUtils.isNull(strFilterType) && strFilterType.equals("combo")) 
				{
					strParamName = "filter";
					filterValue = request.getParameterValues("filter_combo");
					ArrayList aListFilterList = new ArrayList();
					ArrayList tmpFilterList = new ArrayList(Arrays.asList(filterValue));
					if (tmpFilterList != null && tmpFilterList.size() > 0)
					{
						for (int t=0;t<tmpFilterList.size();t++)
						{
							String strFilterData = (String) tmpFilterList.get(t);
							if (!StringUtils.isNull(strFilterData) && strFilterData.indexOf(",") != -1)
							{
								ArrayList newFilterList = StringUtils.egTokenizer(strFilterData,",");
								aListFilterList.addAll(newFilterList);
							}
							else
							{
								aListFilterList.add(strFilterData);
							}
						}
					}

					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 starts... 
					Hashtable resultPolicy = new Hashtable();
					String strLogType = request.getParameter("logType");
					boolean isExistPolicy = false;
					if (aListFilterList != null && !aListFilterList.isEmpty())
					{
						if (!aListFilterList.contains("all"))
						{
							aListFilterList.add("all");
						}

						for (int pol=0;pol<aListFilterList.size();pol++)
						{
							String strPolicy = (String) aListFilterList.get(pol);
							String vardecal=testName.trim()+":"+strLogType.toLowerCase()+":"+strPolicy;
							if (specificTestsEventLogPolicyList != null && !specificTestsEventLogPolicyList.isEmpty())
							{
								for (int j=0;j<specificTestsEventLogPolicyList.size();j++)
								{
									String strCorrectVariable = (String) specificTestsEventLogPolicyList.get(j);
									if (!com.egurkha.util.StringUtils.isNull(strCorrectVariable))
									{
										if(strCorrectVariable.equalsIgnoreCase(vardecal))
										{
											vardecal= strCorrectVariable;
											break;
										}

										if (strCorrectVariable.endsWith(strPolicy))
										{
											String assignValue = testsIni.getValue(strEvtLogSub,strCorrectVariable);
											resultPolicy.put(vardecal,assignValue);
										}
									}
								}
							}
						}
					}

					if (resultPolicy != null && resultPolicy.size() > 0)
					{
						ArrayList resultPolicyList = new ArrayList();
						Iterator keyIt = resultPolicy.entrySet().iterator();
						while(keyIt.hasNext())
						{
							Map.Entry entry =  (Map.Entry) keyIt.next();
							resultPolicyList.add((String) entry.getKey());
						}

						IniFile egTestsIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_tests.ini");
						for (int r=0;r<resultPolicyList.size();r++)
						{
							String strEvtPolVar = (String) resultPolicyList.get(r);
							String strEvtPolVal = (String) resultPolicy.get(strEvtPolVar);
							egTestsIni.setValue(strEvtLogSub,strEvtPolVar,strEvtPolVal);
						}
						egTestsIni.saveFile();
						EgConfigFilesSync.releaseInstance(egTestsIni);
					}
					// for [EVENTLOG_POLICIES] entry in eg_tests.ini bug id- 14020 ends... 
				}
				else
				{
					filterValue = request.getParameterValues("filter");
				}
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("pageTypesToBeincludedindashboard"))
			{
				String[] filterValue = request.getParameterValues(strParamName);
				
				ArrayList aListFilterValue = new ArrayList(Arrays.asList(filterValue));
				strParamValue = aListFilterValue.toString();
				strParamValue = strParamValue.substring(1,strParamValue.length()-1);
				if (strParamValue == null || strParamValue.length() <= 0) 
				{
					strParamValue = "None";
				}
				if (strParamValue.indexOf(",") > -1)
				{
					if (strParamValue.indexOf(";") == -1)
					{
						if (strParamValue.indexOf(":") > -1)
						{
							strParamValue = StringUtils.replace(strParamValue,",","|");
						}
						else
						{
							strParamValue = StringUtils.replace(strParamValue,",",";");
							strParamValue = StringUtils.replace(strParamValue," ","");
						}
					}
					else
					{
						strParamValue = StringUtils.replace(strParamValue,",","|");
					}
				}
			}
			else if (strParamName.equalsIgnoreCase("Target_DiskIO_Rate"))
			{
				String targetDiskIORate_select = request.getParameter("TargetDiskIORate_select");
				String targetDiskIORate = request.getParameter("Target_DiskIO_Rate");
				strParamValue = targetDiskIORate_select + "_" + targetDiskIORate;
			}
			else if (strParamName.equalsIgnoreCase("executiontime") && 
				request.getParameter("minutes") != null && 
				request.getParameter("hours") != null)
			{
				strParamValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
			}
			else if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}

			aListTemp.add("-"+strParamName);
			if (allowToTrim)
			{
				strParamValue = strParamValue.trim();
			}
			aListTemp.add(strParamValue);
		}
		//contains user updated parameter name and values - ends

		//adding the components - starts
		aListComponents.add(componentName);
		//adding the components - ends
	}
	else
	{
		//from EgApplyToOtherComponents.jsp
		hashParamNamesAndValues = (Hashtable)session.getAttribute("hashParamNamesAndValues");
		componentType = (String)hashParamNamesAndValues.get("componentType");
		componentName = (String)hashParamNamesAndValues.get("componentName");
		testName = (String)hashParamNamesAndValues.get("testName");
		isPortRelevantForTest = egSpecs.isPortRelevantForTest(testName);
		testPeriod = (String)hashParamNamesAndValues.get("testPeriod");
		testType = (String)hashParamNamesAndValues.get("testType");
		detailedDiagnosis = (String)hashParamNamesAndValues.get("detaileddiagnosis");

		b_testWithDelimiter = hashTestsAndDelimiters.containsKey(testName.trim());
		b_delimiterWithMask = false;
		if (b_testWithDelimiter)
		{
			strDelimiter = (String)hashTestsAndDelimiters.get(testName);
		}

		//contains user updated parameter name and values - starts
		aListTemp = (ArrayList)hashParamNamesAndValues.get("userUpdatedParamNamesAndValues");
		ArrayList aList_A = new ArrayList();
		for (int i=0;i<aListTemp.size();i=i+2)
		{
			String strParamName = (String)aListTemp.get(i);
			String strParamValue = (String)aListTemp.get(i+1);

			b_delimiterWithMask = hashDelimitersAndMasks.containsKey(testName+":"+strParamName+":"+strDelimiter);
			if (b_delimiterWithMask)
			{
				strMask = (String)hashDelimitersAndMasks.get(testName+":"+strParamName+":"+strDelimiter);
			}
			
			if (strParamName.equalsIgnoreCase("-delimiter") || strParamName.equalsIgnoreCase("-delimiterMask"))
			{
				continue;
			}

			if (b_testWithDelimiter && strParamValue.indexOf(strDelimiter) != -1 && b_delimiterWithMask)
			{
				strParamValue = StringUtils.replace(strParamValue,strDelimiter,strMask);
			}

			aList_A.add(strParamName);
			aList_A.add(strParamValue);
		}
		aListTemp = aList_A;
		//contains user updated parameter name and values - ends

		aListChoosenParameters = getArrayList(request.getParameter("selectedParameters"),",");

		//aListChoosenParametersInLowerCase
		for (int i=0;i<aListChoosenParameters.size();i++)
		{
			aListChoosenParametersInLowerCase.add(aListChoosenParameters.get(i).toString().toLowerCase());
		}

		//Apply to other components - Start
		selectedComponents = request.getParameter("selectedComponents");
		//Apply to other components - End

		aListSelectedComponents = getArrayList(selectedComponents,",");

		//adding the components - starts
		//adding the very first component is the component which the user has choosen for configuration (clicked).
		aListComponents.add(componentName);
		//adding the component(s) which user pick from apply to other component page
		aListComponents.addAll(aListSelectedComponents);
		//adding the components - ends
	}

	boolean isExternalTest = egSpecs.isExternalTest(testName,componentType);
	//In eg_testparam.ini
	//[TEST_RELATIONS] ==> here when one test is configured,the corresponding test 
	//also get configured,except test period value.
	//i.e all similar parameters except test period

	//[COMMON_TEST_RELATIONS] ==> here when one test is configured,the corresponding 
	//test also get configured including test period value.
	//i.e all similar parameters including test period

	//code to get test relations from eg_testparam.ini starts here
	ArrayList aListRelationTests = new ArrayList();
	aListRelationTests.add(testName);

	String testRelationVariables[] = testParamIni.getVariables("TEST_RELATIONS");
	String testRelation = testParamIni.getValue("TEST_RELATIONS",testName);
	if (testRelation != null && testRelation.length() > 0)
	{
		aListRelationTests.addAll(getArrayList(testRelation,","));
	}

	String commonTestRelationVariables[] = testParamIni.getVariables("COMMON_TEST_RELATIONS");
	ArrayList aListCommonTestRelationVariables = new ArrayList();
	for (int i=0;i<commonTestRelationVariables.length;i++)
	{
		String eachVariable = commonTestRelationVariables[i];
		ArrayList aListTempVariable = getArrayList(eachVariable,",");
		if (aListTempVariable.contains(testName))
		{
			aListCommonTestRelationVariables.addAll(aListTempVariable);
			break;
		}
	}
	//ends here

	//for password - starts
	ArrayList aListDefaultPasswordParameters = (ArrayList)session.getAttribute("aListDefaultPasswordParameters");
	boolean hasDefaultPasswordParameter = false;
	if (aListDefaultPasswordParameters != null)
	{
		hasDefaultPasswordParameter = true;
	}
	//for password - ends

	//for aggregate - starts
	boolean isAggSupported = false;
	boolean isAggComponentType = false;
	ArrayList aListAggTest = null;
	boolean hasAggServerType = false;
	//contains aggtest and their mapping test
	ArrayList managedComponents = null;
	//for auditlog - contains list of configured aggregate component
	ArrayList aListAuditAggComponents = null;
	String aggComponentType = null;
	if (allowAggOperation)
	{
		isAggSupported = EgInstallInfo.isAggSupported;
		Hashtable ht_AggComponentType = null;
		Enumeration en_AggComponentType = null;
		isAggComponentType = componentType.startsWith("Agg_");
		if (isAggSupported && !isAggComponentType)
		{
			if (isAuditLogEnabled)
			{
				aListAuditAggComponents = new ArrayList();
			}

			ht_AggComponentType = new Hashtable();
			aListAggTest = new ArrayList();
			managedComponents = discInfo.getAllManagedNames(true);

			String allAggServerTypes[] = aggIni.getVariables("COMPONENT_TYPE_MAPPING");
			allAggServerTypes = (allAggServerTypes != null)?allAggServerTypes:new String[0];
			for (int m=0;m<allAggServerTypes.length;m++)
			{
				String tempAggComponentType = allAggServerTypes[m];
				String tempComponentType = aggIni.getValue("COMPONENT_TYPE_MAPPING",allAggServerTypes[m]);
				ht_AggComponentType.put(tempAggComponentType,tempComponentType);
			}

			en_AggComponentType = ht_AggComponentType.keys();
			while (en_AggComponentType.hasMoreElements())
			{
				String tempAggCompType = (String)en_AggComponentType.nextElement();
				String strCompType = (String)ht_AggComponentType.get(tempAggCompType);
				StringTokenizer stAgg = new StringTokenizer(strCompType,",");
				while (stAgg.hasMoreTokens())
				{
					String thisToken = stAgg.nextToken();
					if (!thisToken.equals(componentType)) continue;
					aggComponentType = tempAggCompType;
					hasAggServerType = true;
				}
			}

			String allAggTests[] = aggIni.getVariables("AGGREGATE_TEST");
			allAggTests = (allAggTests != null)?allAggTests:new String[0];
			for (int m=0;m<allAggTests.length;m++)
			{
				String tempAggTest = allAggTests[m];
				String tempTest = aggIni.getValue("AGGREGATE_TEST",allAggTests[m]);
				aListAggTest.add(tempTest);
				aListAggTest.add(tempAggTest);
			}
		}
	}
	//for aggregate - ends

	//for auditlog -starts
	if (isAuditLogEnabled)
	{
		String auditComponent = "";
		if (componentName.indexOf(":NULL") > -1)
		{
			auditComponent = componentName.substring(0,componentName.indexOf(":"));
		}
		else
		{
			auditComponent = new String(componentName);
		}

		if (!isPortRelevantForTest)
		{
			if (auditComponent.indexOf(":") > -1)
			{
				auditComponent = auditComponent.substring(0,auditComponent.indexOf(":"));
			}
		}

		auditLogThread.setValue("Description","Test " + "$test$:" + testName + " for component " + auditComponent + " of type $ctype$:" + componentType + " has been configured");
	}
	//for auditlog -ends

	//tells whether _cf test is enabled or not
	boolean isConfigSupported = EgInstallInfo.isConfigSupported;

	//ensure whether the user is configuration management enabled
	if (_user != null && isConfigSupported)
	{
		EgUserRole userRole = _user.getUserRole();
		isConfigSupported = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);
	}

	if (isConfigSupported)
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
		aListEnabledTestForCompType.addAll(egSpecs.getEnabledTests(componentType,true));
	}
	else
	{
		aListEnabledTestForCompType = egSpecs.getEnabledTests(componentType,false);
	}

	//Stopping the discovery process
	//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
	IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
	servicer.stopDiscovery();

	boolean isHashDelimiter = aListTestsWithDelimiterHash.contains(testName);
	detailedDiagnosis = (detailedDiagnosis != null)?detailedDiagnosis:"";

	//Iterating each component - starts
	for (int z=0;z<aListComponents.size();z++)
	{
		ArrayList aListConfigurableTest = new ArrayList();
		String tempComponentName = (String)aListComponents.get(z);
		String tempComponentNickName = tempComponentName.substring(0,tempComponentName.indexOf(":"));
		String tempPort = tempComponentName.substring(tempComponentName.indexOf(":")+1);
		List aListAgents = getAgents(tempComponentName);
		ArrayList aListUpdatedParamNamesAndValues = new ArrayList();

		//for aggregate - starts
		List aggCompWithType = null;
		if (allowAggOperation)
		{
			if (isAggSupported && !isAggComponentType)
			{
				aggCompWithType = egAggInfo.getAssociatedAggList(componentType + ":" + tempComponentName);
				aggCompWithType = aggCompWithType != null?aggCompWithType:new ArrayList();
			}
		}
		//for aggregate - ends

		if (z == 0)
		{
			for (int i=0;i<aListParamNamesAndValues.size();i=i+2)
			{
				String paramName = (String)aListParamNamesAndValues.get(i);
				String paramValue = (String)aListParamNamesAndValues.get(i+1);
				aListUpdatedParamNamesAndValues.add(paramName);
				if (aListTemp.contains(paramName))
				{
					int idx = aListTemp.indexOf(paramName);
					String strValue = (String)aListTemp.get(idx+1);
					if (isHashDelimiter && strValue.indexOf(',') > -1)
					{
						strValue = StringUtils.replace(strValue,",","#");
					}
					//No else if block to replace comma with pipe because
					//down the line we have to process the parameter value where 
					//each token is separated using comma.After processing the parameter,
					//comma is replaced with pipe symbol.
					//for eg credentials,url parameter value have to be processed.
					aListUpdatedParamNamesAndValues.add(strValue);
				}
				else
				{
					aListUpdatedParamNamesAndValues.add(paramValue);
				}
			}
			aListTempValue = new ArrayList(aListUpdatedParamNamesAndValues);
		}
		else
		{
			String tempAgentNickName = null;
			if (isExternalTest)
			{
				tempAgentNickName = (String)aListAgents.get(1);
			}
			else
			{
				tempAgentNickName = (String)aListAgents.get(0);
			}

			if (tempAgentNickName == null) continue;

			String specificPattern_A = testName + ":" + componentType + ":" + tempComponentName;
			String specificPattern_B = testName + ":" + componentType + ":" + tempComponentNickName;
			String defaultPattern_A = testName + "::" + tempComponentName;
			String defaultPattern_B = testName + "::" + tempComponentNickName;
			String agentIniVariables[] = agentIni.getVariables(tempAgentNickName);
			List listAgentIniVariables = Arrays.asList(agentIniVariables);
			String resultantPattern = "";
			if (listAgentIniVariables.contains(specificPattern_A))
			{
				resultantPattern = specificPattern_A;
			}
			else if (listAgentIniVariables.contains(specificPattern_B))
			{
				resultantPattern = specificPattern_B;
			}
			else if (listAgentIniVariables.contains(defaultPattern_A))
			{
				resultantPattern = defaultPattern_A;
			}
			else if (listAgentIniVariables.contains(defaultPattern_B))
			{
				resultantPattern = defaultPattern_B;
			}

			if (resultantPattern.equalsIgnoreCase("")) continue;

			String iniValue =  agentIni.getValue(tempAgentNickName,resultantPattern);
			iniValue = iniValue.substring(iniValue.indexOf(",")+1,iniValue.lastIndexOf(","));

			if (isOldSnmp)
			{
				ArrayList aListOldParams = getParameterList(iniValue,true);
				if (!aListOldParams.contains("-snmpversion"))
				{
					int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
					aListOldParams = getParameterList(iniValue,false);
					aListOldParams.add(snmpComIdx+2,"-snmpversion");
					aListOldParams.add(snmpComIdx+3,"v1");

					iniValue = aListOldParams.toString();
					iniValue = iniValue.substring(1,iniValue.length()-1);
					iniValue = StringUtils.replace(iniValue,",","");
				}
			}

			ArrayList aListSample = getParameterList(iniValue,false);
			aListUpdatedParamNamesAndValues = new ArrayList(aListSample);

			for (int m=0;m<aListChoosenParameters.size();m++)
			{
				String eachParam = (String)aListChoosenParameters.get(m);
				if (aListUpdatedParamNamesAndValues.contains(eachParam))
				{
					//fetching the selected parameter from the builded list
					int idx = aListUpdatedParamNamesAndValues.indexOf(eachParam);
					int idx2 = aListTempValue.indexOf(eachParam);
					String str1 = (String)aListTempValue.get(idx2+1);
					aListUpdatedParamNamesAndValues.remove(idx+1);
					aListUpdatedParamNamesAndValues.add(idx+1,str1);
				}
			}
		}

		ArrayList aListProcessedParamNamesAndValues = new ArrayList();
		for (int i=0; i<aListUpdatedParamNamesAndValues.size(); i=i+2)
		{
			String strParamName = (String)aListUpdatedParamNamesAndValues.get(i);
			String strParamNameLowerCase = strParamName.toLowerCase();
			String strParamValue = (String)aListUpdatedParamNamesAndValues.get(i+1);
			boolean allowToModifyParameter = true;

			//applicable only to "apply to other components".not to UserInitiatedComponent.
			//this code fires when the user in transit page(EgApplyToOtherCompoent.jsp),unclick 
			//the parameter.
			if (z > 0 && 
				!aListChoosenParametersInLowerCase.contains(strParamNameLowerCase))
			{
				allowToModifyParameter = false;
			}

			if (allowToModifyParameter)
			{
				boolean encryptPasswordData = false;
				if (hasPasswordParameters && aListPasswordParameters.contains(strParamName))
				{
					encryptPasswordData = true;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains(strParamNameLowerCase))
				{
					encryptPasswordData = true;
				}
				
				if (strParamName.equalsIgnoreCase("-logtype"))
				{
					strParamValue = strParamValue.toLowerCase();
				}

				if (strParamName.equals("-url"))
				{
					String strHiddenUrlDelim = ",";
					if (testName.equals("HttpTest") || 
						testName.equals("HttpPostTest") || 
						testName.equals("SMHttpTest") || 
						testName.equals("AzureWebAcsTest") || 
						testName.equals("DownSpeedTest"))
					{
						String strHiddenUrl = request.getParameter("hiddenURLs");
						strParamValue = strHiddenUrl;
						strHiddenUrlDelim = "|";
					}
					//handling parameter value for url
					//if (strParamValue.indexOf(",") > -1)
					if (strParamValue.indexOf(strHiddenUrlDelim) > -1)
					{
						String encodedUrl = "";
						StringTokenizer st12 = new StringTokenizer(strParamValue,strHiddenUrlDelim);
						//StringTokenizer st12 = new StringTokenizer(strParamValue,",");
						String tempUrl = "";
						while (st12.hasMoreTokens())
						{
							tempUrl = st12.nextToken();
							if (tempUrl.indexOf("?") > -1)
							{
								int urlIndex = tempUrl.indexOf("?");
								tempUrl = tempUrl.substring(0, urlIndex) + "?" + URLEncoder.encode(tempUrl.substring(urlIndex + 1));
							}
							if (encodedUrl != null && !encodedUrl.equals(""))
							{
								encodedUrl = encodedUrl + "|" + tempUrl;
							}
							else
							{
								encodedUrl = tempUrl;
							}
						}
						strParamValue = encodedUrl;
					}
					else
					{
						if(strParamValue.indexOf("?") > -1)
						{
							int vecValIndex = strParamValue.indexOf("?");
							strParamValue = strParamValue.substring(0, vecValIndex) + "?" + URLEncoder.encode(strParamValue.substring(vecValIndex + 1));
						}
					}
				}
				else if (encryptPasswordData)
				{
					//handling parameter value for password data
					strParamValue = EgCrypt.decrypt(strParamValue);
					String passList = "";
					if ((testName.equals("CtxAuthTest") || 
						testName.equals("WinAuthTest") || 
						testName.equals("TermAuthTest") || 
						testName.equals("WindowshareTest") || 
						testName.equals("UNCCheckTest")) && 
						strParamValue.indexOf("#~#") > -1)
					{
						ArrayList aListTokens = StringUtils.myTokenizer(strParamValue, "#~#");
						for(int m=0;m<aListTokens.size();m++)
						{
							passList += EgCrypt.encrypt((String)aListTokens.get(m))+"|";
						}
						passList = passList.substring(0, passList.length()-1);
					}
					else
					{
						passList = EgCrypt.encrypt(strParamValue);
					}
					strParamValue = passList;
				}
				else if(strParamName.equalsIgnoreCase("-credentials"))
				{
					//handling parameter value for credentials
					String credentialUser = "";
					String credentialPassword = "";
					int thisCount = 0;
					StringBuffer credentialResultantBuffer = new StringBuffer();
					StringTokenizer credentialTokens = new StringTokenizer(strParamValue,",");
					while (credentialTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							credentialResultantBuffer.append("|");
						}
						String eachUnameUpass = credentialTokens.nextToken();
						credentialUser = eachUnameUpass.substring(0,eachUnameUpass.indexOf(":"));
						if (egServicesInfo.isAesEncryptForTestConfig())
						{
							credentialPassword = EgCrypt.encrypt(eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length()));
						}
						else
						{
							credentialPassword = EgCrypt.encrypt(eachUnameUpass.substring(eachUnameUpass.indexOf(":")+1,eachUnameUpass.length()), true);
						}
						credentialResultantBuffer.append(credentialUser+":"+credentialPassword);
					}
					strParamValue = credentialResultantBuffer.toString();
				}
				else if(strParamName.equalsIgnoreCase("-privateKey"))
				{
					//handling parameter value for File password
					String filePath="none";
					String filePassword = "none";
					String encryptedFilePassword= "";
					int thisCount = 0;
					StringBuffer resultantBuffer = new StringBuffer();
					StringTokenizer resultTokens = new StringTokenizer(strParamValue,",");
					while (resultTokens.hasMoreTokens())
					{
						thisCount++;
						if (thisCount > 1)
						{
							resultantBuffer.append("|");
						}
						String eachFnameFpass = resultTokens.nextToken();
						String tokens[] = EgUtils.getTokens(eachFnameFpass,"#~~#");
						if(tokens != null && tokens.length==2)
						{
							filePath = tokens[0];
							filePassword = tokens[1];
						}
						if (egServicesInfo.isAesEncryptForTestConfig())
						{
							encryptedFilePassword = EgCrypt.encrypt(filePassword);
						}
						else
						{
							encryptedFilePassword = EgCrypt.encrypt(filePassword, true);
						}
						resultantBuffer.append(filePath+":"+encryptedFilePassword);
					}
					strParamValue = resultantBuffer.toString();
				}
				else if (strParamName.equalsIgnoreCase("-alertFile"))
				{
					if (testName.equalsIgnoreCase("EgErrorLogTest") || 
						testName.equalsIgnoreCase("EgThreshLogTest") || 
						testName.equalsIgnoreCase("EgTrendLogTest"))
					{
						if (strParamValue.indexOf(",") != -1)
						{
							String strUpdatedParamValue = "";
							StringTokenizer strTokens = new StringTokenizer(strParamValue,",");
							while (strTokens.hasMoreTokens())
							{
								String strToken = strTokens.nextToken();
								strUpdatedParamValue = strUpdatedParamValue + "(EG_HOME_DIR)" + strToken + ",";
							}
							strParamValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-1);
						}
						else
						{
							strParamValue = "(EG_HOME_DIR)" + strParamValue;
						}
					}
				}
				else if (strParamName.equals("-Published_resources"))
				{
					String strHiddenPubResrc = request.getParameter("hiddenPublishedResource");
					if ((!StringUtils.isNull(strHiddenPubResrc) && strHiddenPubResrc.indexOf(" -") > -1) || aListParamsWithDoubleQuotes.contains(strParamName.toLowerCase()))
					{
						strHiddenPubResrc = "\"" + strHiddenPubResrc + "\"";
					}
					strParamValue = strHiddenPubResrc;
				}
				else if (strParamName.equals("-site_URL(S)"))
				{
					String strHiddenSiteURL = request.getParameter("hiddenSiteURL");
					strParamValue = strHiddenSiteURL;
				}

				//replacing pipe in place of comma for the tests having pipe as delimiter
				if (!isHashDelimiter && strParamValue.indexOf(",") > -1)
				{
					strParamValue = StringUtils.replace(strParamValue,",","|");
				}
				if (!isHashDelimiter && strParamValue.indexOf(";") > -1)
				{
					ArrayList aListEventTests = new ArrayList(Arrays.asList(eventTests));
					if(!aListEventTests.contains(testName) && !testName.equalsIgnoreCase("WinProcessTest") && !testName.equalsIgnoreCase("LSEventLogTest") && !testName.equalsIgnoreCase("LSEdgeEvtLogTest"))
					{
						strParamValue = StringUtils.replace(strParamValue,";","~#~");
					}
				}
			}

			aListProcessedParamNamesAndValues.add(strParamName);
			aListProcessedParamNamesAndValues.add(strParamValue);
		}

		//to display the updated parameters and their values to the user - starts
		if (z == 0)
		{
			String tempValue = new String(testPeriod);
			tempValue = tempValue.trim();
			if (Integer.parseInt(tempValue) <= 60)
			{
				tempValue+=" secs";
			}
			else if (Integer.parseInt(tempValue) <= 3599)
			{
				int tpmin=Integer.parseInt(tempValue)/60;
				tempValue=""+tpmin+" mins";
			}
			else if (tempValue.equals("3600"))
			{
				tempValue="1 hr";
			}
			else
			{
				int tphr=Integer.parseInt(tempValue)/3600;
				tempValue=""+tphr+" hrs";
			}

			aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test.TEST PERIOD"));
			aListDisplayParamNamesAndValues.add(tempValue);

			//for auditlog - starts
			if (isAuditLogEnabled)
			{
				auditLogThread.setCurrentValue("01~~TEST PERIOD",tempValue);
				auditParamIdx++;
			}
			//for auditlog - ends

			ArrayList aListDisplay = (ArrayList)session.getAttribute("aListDisplay");

			for(int i=0;i<aListProcessedParamNamesAndValues.size();i=i+2)
			{
				String paramName = (String)aListProcessedParamNamesAndValues.get(i);

				if (fromPage.equalsIgnoreCase("EgApplyToOtherComponents.jsp") && 
					!aListTemp.contains(paramName))
				{
					continue;
				}

				paramName = paramName.substring(1).trim();
				if (fromPage.equalsIgnoreCase("EgConfigureComponentTests.jsp") && 
					request.getParameter(paramName) == null)
				{
					continue;
				}

				String paramValue = (String)aListProcessedParamNamesAndValues.get(i+1);
				paramValue = paramValue.trim();

				int paramIdx = Arrays.binarySearch(paramToContinue,paramName,String.CASE_INSENSITIVE_ORDER);
				if (paramIdx > -1) continue;

				if (paramName.equalsIgnoreCase("port") && paramValue.equalsIgnoreCase("NULL"))
					continue;

				boolean showConfirmPassWord = false;
				if (hasPasswordParameters && aListPasswordParameters.contains("-" + paramName))
				{
					continue;
				}
				else if (hasDefaultPasswordParameter && aListDefaultPasswordParameters.contains("-" + paramName.toLowerCase()))
				{
					continue;
				}

				if (paramName.equals("rptName") || paramName.equals("mCount"))
				{
					continue;
				}

				if (paramValue.startsWith("\"") && paramValue.endsWith("\""))
				{
					paramValue = paramValue.substring(1,paramValue.length()-1);
				}

				if (paramName.equalsIgnoreCase("os"))
				{
					if (paramValue.equalsIgnoreCase("xp"))
					{
						paramValue = "Window XP";
					}
					else if (paramValue.equalsIgnoreCase("2003"))
					{
						paramValue = "Windows 2003";
					}
					else if (paramValue.equalsIgnoreCase("2008"))
					{
						paramValue = "Windows 2008";
					}
					else if (paramValue.equalsIgnoreCase("w2k"))
					{
						paramValue = "Windows 2000";
					}
					else if (paramValue.equalsIgnoreCase("nt"))
					{
						paramValue = "Windows NT";
					}
					else if (paramValue.equalsIgnoreCase("hpux") || 
						paramValue.equalsIgnoreCase("aix"))
					{
						paramValue = paramValue.toUpperCase();
					}
					else if (paramValue.equalsIgnoreCase("tru64"))
					{
						paramValue = "Tru64";
					}
					else if (paramValue.equalsIgnoreCase("linux"))
					{
						paramValue = "Linux";
					}
					else if (paramValue.equalsIgnoreCase("solaris"))
					{
						paramValue = "Solaris";
					}
					else if (paramValue.equalsIgnoreCase("other"))
					{
						paramValue = "Other";
					}
				}
				else if (paramName.equalsIgnoreCase("Target_DiskIO_Rate"))
				{
					String tempTargetDiskIORate = paramValue.substring(0,paramValue.indexOf("_"));
					String tempTargetDiskIORateValue = paramValue.substring(paramValue.indexOf("_")+1,paramValue.length());

					if (tempTargetDiskIORate.equalsIgnoreCase("eq"))
					{
						tempTargetDiskIORate = "Equals";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("lt"))
					{
						tempTargetDiskIORate = "Less Than";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("le"))
					{
						tempTargetDiskIORate = "Less Than or Equal To";
					}
					else if (tempTargetDiskIORate.equalsIgnoreCase("gt"))
					{
						tempTargetDiskIORate = "Greater Than";
					}
					else
					{
						tempTargetDiskIORate = "Greater Than or Equal To";
					}

					paramValue = tempTargetDiskIORate + " " + tempTargetDiskIORateValue;
				}
				else if (paramName.equalsIgnoreCase("executiontime") && 
					request.getParameter("minutes") != null && 
					request.getParameter("hours") != null)
				{
					paramValue = request.getParameter("hours") + ":" + request.getParameter("minutes");
				}

				if (!aListDisplay.contains(paramName+"#"+paramValue) && 
					(paramValue.equalsIgnoreCase("false") || paramValue.equalsIgnoreCase("n") || paramValue.equalsIgnoreCase("no")))
				{
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.No"));

					//for auditlog - starts
					if (isAuditLogEnabled)
					{
						if (auditParamIdx <= 9)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+paramName.toUpperCase(),"No");
						}
						else
						{
							auditLogThread.setCurrentValue(auditParamIdx+"~~"+paramName.toUpperCase(),"No");
						}
						auditParamIdx++;
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
							if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
							{
								String query[] = getDeleteQueries(componentName,testName);
								com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
								updateAndTransmitUserInfo.rename(query);
							}
						}
					}
					//for auditlog - ends
				}
				else if (!aListDisplay.contains(paramName+"#"+paramValue) && 
					(paramValue.equalsIgnoreCase("true") || paramValue.equalsIgnoreCase("y") || paramValue.equalsIgnoreCase("yes")))
				{
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.common.Yes"));

					//for auditlog - starts
					if (isAuditLogEnabled)
					{
						if (auditParamIdx <= 9)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+paramName.toUpperCase(),"Yes");
						}
						else
						{
							auditLogThread.setCurrentValue(auditParamIdx+"~~"+paramName.toUpperCase(),"Yes");
						}
						auditParamIdx++;
						if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
						{
							String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
							if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
							{
								String query[] = getDeleteQueries(componentName,testName);
								com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
								updateAndTransmitUserInfo.rename(query);
							}
						}
					}
					//for auditlog - ends
				}
				else
				{
					aListDisplayParamNamesAndValues.add(_mapping.getTextDescription("admin.test."+paramName.toUpperCase()));
					if(paramName.equalsIgnoreCase("credentials"))
					{
						String temp = "";
						ArrayList aListUsers = getArrayList(paramValue,"|");
						for(int b=0;b<aListUsers.size();b++)
						{
							String str=(String)aListUsers.get(b);
							str = str.substring(0,str.indexOf(":"));
							temp = temp + str + ",";
						}
						temp = temp.substring(0,temp.length()-1);
						paramValue = temp;
					}

					if (paramName.equalsIgnoreCase("alertFile"))
					{
						if (testName.equalsIgnoreCase("EgErrorLogTest") || 
							testName.equalsIgnoreCase("EgThreshLogTest") || 
							testName.equalsIgnoreCase("EgTrendLogTest"))
						{
							if (paramValue.indexOf("|") != -1)
							{
								String strUpdatedParamValue = "";
								StringTokenizer strTokens = new StringTokenizer(paramValue,"|");
								while (strTokens.hasMoreTokens())
								{
									String strToken = strTokens.nextToken();
									strUpdatedParamValue = strUpdatedParamValue + strToken.substring(strToken.indexOf("(EG_HOME_DIR)")+13) + "| ";
								}
								paramValue = strUpdatedParamValue.substring(0,strUpdatedParamValue.length()-2);
							}
							else
							{
								paramValue = paramValue.substring(paramValue.indexOf("(EG_HOME_DIR)")+13);
							}
						}
					}

					if(paramValue.indexOf("|")>-1)
					{
						paramValue = StringUtils.replace(paramValue,"|",",");
					}
					if (paramValue.indexOf("~#~") > -1)
					{
						paramValue = StringUtils.replace(paramValue,"~#~",";");
					}

					if(!paramName.equalsIgnoreCase("snmpcommunity") && paramValue.indexOf("#")>-1)
					{
						paramValue = StringUtils.replace(paramValue,"#",",");
					}

					if (paramName.equalsIgnoreCase("url"))
					{
						int tempUrlIdx = aListTemp.indexOf("-"+paramName);
						paramValue = (String)aListTemp.get(tempUrlIdx+1);
					}

					if (b_testWithDelimiter && strMask.length() > 0 && paramValue.indexOf(strMask) != -1)
					{
						paramValue = StringUtils.replace(paramValue,strMask,strDelimiter);
					}

					if (aListDisplay.contains(paramName+"#"+paramValue))
					{
						int paramValIdx = aListDisplay.indexOf(paramName+"#"+paramValue);
						paramValue = (String)aListDisplay.get(paramValIdx+1);
					}
					aListDisplayParamNamesAndValues.add(paramValue);

					if (paramName.equalsIgnoreCase("snmpversion") && 
						(paramValue.equalsIgnoreCase("v1") || paramValue.equalsIgnoreCase("v2")))
					{
						//Displaying the needed parameters in the ui for snmpV1 and snmpV2 only.
						int snmpParamIdx = Arrays.binarySearch(snmpV1V2ParamToContinue,paramName,String.CASE_INSENSITIVE_ORDER);

						if (snmpParamIdx > -1) continue;
					}

					//for auditlog - starts
					if (isAuditLogEnabled)
					{
						if (paramName.equalsIgnoreCase("host"))
						{
							if(!testName.endsWith("_ag") && !testName.endsWith("_agx"))
							{
								auditLogThread.setCurrentValue("02~~HOST",paramValue);
								auditParamIdx++;
							}
						}
						else if (paramName.equalsIgnoreCase("port"))
						{
							auditLogThread.setCurrentValue("03~~PORT",paramValue);
							auditParamIdx++;
						}
						else
						{
							if (auditParamIdx <= 9)
							{
								auditLogThread.setCurrentValue("0"+auditParamIdx+"~~"+paramName.toUpperCase(),paramValue);
							}
							else
							{
								auditLogThread.setCurrentValue(auditParamIdx+"~~"+paramName.toUpperCase(),paramValue);
							}
							if(paramName.toUpperCase().equals("AGGREGATEDESCRIPTOR") && (testName.endsWith("_ag") || testName.endsWith("_agx")))
							{
								String paramValue_previous = request.getParameter("AGGREGATEDESCRIPTOR_previous");
								if(!StringUtils.isNull(paramValue_previous) && !paramValue_previous.equals(paramValue))
								{
									String query[] = getDeleteQueries(componentName,testName);
									com.eg.UpdateAndTransmitUserInfo updateAndTransmitUserInfo = new com.eg.UpdateAndTransmitUserInfo();
									updateAndTransmitUserInfo.rename(query);
								}
							}
							auditParamIdx++;
						}
					}
					//for auditlog - ends
				}
			}

			if (!detailedDiagnosis.equals(""))
			{
				aListDisplayParamNamesAndValues.add("DETAILEDDIAGNOSIS");
				aListDisplayParamNamesAndValues.add(detailedDiagnosis);

				//for auditlog - starts
				if (isAuditLogEnabled)
				{
					if (auditParamIdx <= 9)
					{
						auditLogThread.setCurrentValue("0"+auditParamIdx+"~~DETAILEDDIAGNOSIS",detailedDiagnosis);
					}
					else
					{
						auditLogThread.setCurrentValue(auditParamIdx+"~~DETAILEDDIAGNOSIS",detailedDiagnosis);
					}
					auditParamIdx++;
				}
				//for auditlog - ends
			}
		}
		//to display the updated paramters and their values to the user - ends

		String strValue = aListProcessedParamNamesAndValues.toString();
		strValue = strValue.substring(1,strValue.length()-1);
		strValue = StringUtils.replace(strValue,",","");
		strValue = strValue.trim();

		ArrayList aListDisabledTest = new ArrayList();

		String strDisabledTest = disableIni.getValue("Default_server","Default_server" + ":" + tempComponentNickName);

		if (strDisabledTest!= null && !strDisabledTest.equals(""))
		{
			aListDisabledTest = getArrayList(strDisabledTest,",");
		}

		strDisabledTest = disableIni.getValue(componentType,componentType + ":" + tempComponentName);
		if (strDisabledTest!= null && !strDisabledTest.equals(""))
		{
			aListDisabledTest.addAll(getArrayList(strDisabledTest,","));
		}

		for(int k=0;k<aListRelationTests.size();k++)
		{
			String strTestName = (String)aListRelationTests.get(k);
			if (aListEnabledTestForCompType.contains(strTestName) && 
				!aListDisabledTest.contains(strTestName))
			{
				aListConfigurableTest.add(strTestName);
			}
		}

		//processing each test-starts here
		String strTestPeriod = "";
		for (int k=0;k<aListConfigurableTest.size();k++)
		{
			String strTestName = (String)aListConfigurableTest.get(k);

			//for auditlog - starts
			if (isAuditLogEnabled  && z == 0 && k > 0)
			{
				if(strTestName.endsWith("_ex"))
				{
					if (auditParamIdx <= 9)
					{
						auditLogThread.setCurrentValue("0"+auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)",strTestName);
					}
					else
					{
						auditLogThread.setCurrentValue(auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)",strTestName);
					}
				}
				else
				{
					if (auditParamIdx <= 9)
					{
						auditLogThread.setCurrentValue("0"+auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)","$test$:"+strTestName);
					}
					else
					{
						auditLogThread.setCurrentValue(auditParamIdx+"~~OTHER AUTO CONFIGURED TEST(S)","$test$:"+strTestName);
					}
				}

				if (k == aListConfigurableTest.size())
				{
					auditParamIdx++;
				}
			}
			//for auditlog - ends

			boolean isTestAtIntialConfiguration = false;
			List aListTempAgents = null;
			boolean isThisTestExternal = egSpecs.isExternalTest(strTestName,componentType);
			if (isThisTestExternal)
			{
				aListTempAgents = aListAgents.subList(1,aListAgents.size());
			}
			else
			{
				aListTempAgents = aListAgents.subList(0,1);
			}

			String specificPattern_A = strTestName + ":" + componentType + ":" + tempComponentName;
			String specificPattern_B = strTestName + ":" + componentType + ":" + tempComponentNickName;
			String defaultPattern_A = strTestName + "::" + tempComponentName;
			String defaultPattern_B = strTestName + "::" + tempComponentNickName;

			//Applicable to external test only - starts
			//Scenario :A generic comptype say gen1 has one internal or remote agent
			//and 3 external agents. We already know that an external test say network
			//test will have same set of test-parameters for all the external agents
			//For e.g., [agent148] or [agent66] or [192.168.10.50]
			//NetworkTest::gen148=-manual, -host 192.168.10.148 -packetSize 32
			//-packetCount 5 -timeout 10 -packetInterval 100 -targets victory -rptName gen148, 300
			//Hence, a single set of parameters are enough to be built for updation to all
			//the external agent sections
			boolean isParameterSetAvailable = false;
			String tempTestValue = null;
			String tempResultantPattern = null;
			//Applicable to external test only - ends

			for (int i=0; i<aListTempAgents.size(); i++)
			{
				String tempAgentNickName = (String)aListTempAgents.get(i);
				StringBuffer strBuffer = null;
				String resultantPattern = "";
				if (!isParameterSetAvailable)
				{
					String agentIniVariables[] = agentIni.getVariables(tempAgentNickName);
					List listAgentIniVariables = Arrays.asList(agentIniVariables);
					if (listAgentIniVariables.contains(specificPattern_A))
					{
						resultantPattern = specificPattern_A;
					}
					else if (listAgentIniVariables.contains(specificPattern_B))
					{
						resultantPattern = specificPattern_B;
					}
					else if (listAgentIniVariables.contains(defaultPattern_A))
					{
						resultantPattern = defaultPattern_A;
					}
					else if (listAgentIniVariables.contains(defaultPattern_B))
					{
						resultantPattern = defaultPattern_B;
					}

					if (resultantPattern.equalsIgnoreCase("")) continue;

					boolean isUserInitiatedTest = strTestName.equals(testName);
					String oldIniValue = agentIni.getValue(tempAgentNickName,resultantPattern);
					String testConfigurationStatus = oldIniValue.substring(0,oldIniValue.indexOf(","));
					if (testConfigurationStatus.equals("-auto"))
					{
						isTestAtIntialConfiguration = true;
					}
					String oldValue = oldIniValue.substring(oldIniValue.indexOf(",")+1,oldIniValue.lastIndexOf(","));
					if (isOldSnmp)
					{
						ArrayList aListOldParams = getParameterList(oldValue,true);
						if (!aListOldParams.contains("-snmpversion"))
						{
							int snmpComIdx=aListOldParams.indexOf("-snmpcommunity");
							aListOldParams = getParameterList(oldValue,false);
							aListOldParams.add(snmpComIdx+2,"-snmpversion");
							aListOldParams.add(snmpComIdx+3,"v1");

							oldValue = aListOldParams.toString();
							oldValue = oldValue.substring(1,oldValue.length()-1);
							oldValue = StringUtils.replace(oldValue,",","");
						}
					}

					String testParam = null;
					if (isUserInitiatedTest)
					{
						testParam = strValue;
						if (k == 0)
						{
							boolean configureVc = false;
							boolean configureHmc = false;
							boolean configureRhev = false;
							boolean configureNutanix = false;
							boolean configureXMSIP = false;
							if (z == 0)
							{
								//for VC
								if (aListProcessedParamNamesAndValues.contains("-virtual_center"))
								{
									configureVc = true;
								}

								//for Nutanix
								if (aListProcessedParamNamesAndValues.contains("-Prism_IP"))
								{
									configureNutanix = true;
								}

								//for HMC
								if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									configureHmc = true;
								}
								// for RHEV
								if (aListProcessedParamNamesAndValues.contains("-Rhel_mgr_host"))
								{
									configureRhev = true;
								}
								else if (aListProcessedParamNamesAndValues.contains("-management_server") && 
									aListProcessedParamNamesAndValues.contains("-management_user"))
								{
									if (aListProcessedParamNamesAndValues.indexOf("-is_managed_by") > -1)
									{
										int tempIdx = aListProcessedParamNamesAndValues.indexOf("-is_managed_by");
										String tempValue = (String)aListProcessedParamNamesAndValues.get(tempIdx+1);
										tempValue = tempValue.trim();
										if (tempValue != null && tempValue.equalsIgnoreCase("hmc"))
										{
											configureHmc = true;
										}
									}
								}

								//for xmsIP
								if (aListProcessedParamNamesAndValues.contains("-xms_ip"))
								{
									configureXMSIP = true;
								}

							}
							else
							{
								//for VC
								if (aListChoosenParametersInLowerCase.contains("-virtual_center") && 
									aListProcessedParamNamesAndValues.contains("-virtual_center"))
								{
									configureVc = true;
								}

								//for Nutanix
								if (aListChoosenParametersInLowerCase.contains("-prism_ip") && 
									aListProcessedParamNamesAndValues.contains("-Prism_IP"))
								{
									configureNutanix = true;
								}

								//for HMC
								if (aListChoosenParametersInLowerCase.contains("-hmc_server") && 
									aListChoosenParametersInLowerCase.contains("-hmc_user") && 
									aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									configureHmc = true;
								}
								else if (aListChoosenParametersInLowerCase.contains("-management_server") && 
										aListChoosenParametersInLowerCase.contains("-management_user") && 
										aListProcessedParamNamesAndValues.contains("-management_server") && 
										aListProcessedParamNamesAndValues.contains("-management_user"))
								{
									if (aListProcessedParamNamesAndValues.indexOf("-is_managed_by") > -1)
									{
										int tempIdx = aListProcessedParamNamesAndValues.indexOf("-is_managed_by");
										String tempValue = (String)aListProcessedParamNamesAndValues.get(tempIdx+1);
										tempValue = tempValue.trim();
										if (tempValue != null && tempValue.equalsIgnoreCase("hmc"))
										{
											configureHmc = true;
										}
									}
								}
								//for RHEV
								if (aListChoosenParametersInLowerCase.contains("-rhel_mgr_host") && 
									aListProcessedParamNamesAndValues.contains("-Rhel_mgr_host"))
								{
									configureRhev = true;
								} 

								//for XMS IP
								if (aListChoosenParametersInLowerCase.contains("-xms_ip") && 
									aListProcessedParamNamesAndValues.contains("-xms_ip"))
								{
									configureXMSIP = true;
								}
							}

							if (configureHmc)
							{
								if (eg_hmcMapping == null)
								{
									eg_hmcMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_hmcmapping.ini");
								}

								int hostIdx = aListProcessedParamNamesAndValues.indexOf("-host");
								String hostValue = (String)aListProcessedParamNamesAndValues.get(hostIdx+1);
								String hmcServerValue = "";
								int hmcServerIdx = 0;
								if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
									aListProcessedParamNamesAndValues.contains("-hmc_user"))
								{
									hmcServerIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_server");
								}
								else
								{
									hmcServerIdx = aListProcessedParamNamesAndValues.indexOf("-management_server");
								}
								hmcServerValue = (String)aListProcessedParamNamesAndValues.get(hmcServerIdx+1);

								if (z == 0)
								{
									if (eg_servicesIni == null)
									{
										eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
									}

									int hmcUserIdx = 0;
									int hmcPasswordIdx = 0;

									if (aListProcessedParamNamesAndValues.contains("-hmc_server") && 
										aListProcessedParamNamesAndValues.contains("-hmc_user"))
									{
										hmcUserIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_user");
										hmcPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-hmc_password");
									}
									else
									{
										hmcUserIdx = aListProcessedParamNamesAndValues.indexOf("-management_user");
										hmcPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-management_password");
									}

									String hmcUserValue = (String)aListProcessedParamNamesAndValues.get(hmcUserIdx+1);

									String hmcPasswordValue = (String)aListProcessedParamNamesAndValues.get(hmcPasswordIdx+1);
									hmcPasswordValue = EgCrypt.decrypt(hmcPasswordValue);
									hmcPasswordValue = EgCrypt.encrypt(hmcPasswordValue);

									int sslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
									String sslValue = (String)aListProcessedParamNamesAndValues.get(sslIdx+1);

									String hmcPattern = null;
									if (hmcServerValue == null)
									{
										hmcPattern = eg_servicesIni.getValue("HMC",hostValue);
									}
									else
									{
										hmcPattern = eg_servicesIni.getValue("HMC",hmcServerValue);
									}

									String isDiscovery = "No";
									String hostName = hmcServerValue;
									if (hmcPattern != null)
									{
										StringTokenizer sst = new StringTokenizer(hmcPattern,"#");
										if(sst.hasMoreTokens())
										{
											String s = sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
											hostName = sst.nextToken();
										}
									}
									String pattern = sslValue + "#" + hmcUserValue + "#" + hmcPasswordValue + "#" + isDiscovery + "#" + hostName;

									if (aListServicesIniEntries == null)
									{
										aListServicesIniEntries = new ArrayList();
									}

									if (hmcServerValue == null)
									{
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hostValue,pattern));

									}
									else
									{
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"HMC",hmcServerValue,pattern));

									}
								}

								String Var = componentType + ":" + tempComponentName;
								String Val = componentType + "," + tempComponentNickName + "," + hostValue + ",NULL";
								if (aListHmcMappingIniEntries == null)
								{
									aListHmcMappingIniEntries = new ArrayList();
								}
								aListHmcMappingIniEntries.add(new IniHelper(IniHelper.SET,hmcServerValue,Var,Val));
							}

							// for discovery changes - starts
							if (configureVc)
							{
								int vcidx = aListProcessedParamNamesAndValues.indexOf("-virtual_center");
								String virtual_centerValue = (String)aListProcessedParamNamesAndValues.get(vcidx+1);

								if (!virtual_centerValue.equalsIgnoreCase("other") && !virtual_centerValue.equalsIgnoreCase("none"))
								{
									if (eg_vcmappingIni == null)
									{
										eg_vcmappingIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_vcmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);

									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int esxUserIdx = aListProcessedParamNamesAndValues.indexOf("-Esx_user");
										String strEsxUserValue = (String)aListProcessedParamNamesAndValues.get(esxUserIdx+1);

										int esxPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Esx_password");
										String strEsxPasswordValue = (String)aListProcessedParamNamesAndValues.get(esxPasswordIdx+1);
										strEsxPasswordValue = EgCrypt.decrypt(strEsxPasswordValue);
										strEsxPasswordValue = EgCrypt.encrypt(strEsxPasswordValue);

										int esxSslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(esxSslIdx+1);

										int webPortIdx = aListProcessedParamNamesAndValues.indexOf("-webPort");
										String webPort = (String)aListProcessedParamNamesAndValues.get(webPortIdx+1);

										String isDiscovery = "No";
										//String hosted_vm_type="ServerVMs";
										String virtualCenterPattern = eg_servicesIni.getValue("VIRTUAL_CENTER",virtual_centerValue);
										StringTokenizer sst = new StringTokenizer(virtualCenterPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
											/*sst.nextToken();
											if(sst.hasMoreTokens())
											{
												hosted_vm_type = sst.nextToken();
											}*/
										}

										if (strSslValue != null)
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												if (webPort != null)
												{
													if (webPort.equalsIgnoreCase("default"))
													{
														webPort = "443";
													}
												}
												else
												{
													webPort = "443";
												}
											}
											else
											{
												if (webPort != null)
												{
													if (webPort.equalsIgnoreCase("default"))
													{
														webPort = "80";
													}
												}
												else
												{
													webPort = "80";
												}
											}
										}

										String pattern = strSslValue + "#" + strEsxUserValue + "#" + strEsxPasswordValue + "#" + isDiscovery + "#" + webPort;
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"VIRTUAL_CENTER",virtual_centerValue,pattern));

									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + strHostValue + "," + tempComponentNickName + ",NULL";

									if (aListVcMappingIniEntries == null)
									{
										aListVcMappingIniEntries = new ArrayList();
									}
									aListVcMappingIniEntries.add(new IniHelper(IniHelper.SET,virtual_centerValue,Var,Val));
								}
							}

							// for nutanix changes - starts
							if (configureNutanix)
							{
								int cvmipidx = aListProcessedParamNamesAndValues.indexOf("-Prism_IP");
								String cvm_ipValue = (String)aListProcessedParamNamesAndValues.get(cvmipidx+1);

								if (!cvm_ipValue.equalsIgnoreCase("other") && !cvm_ipValue.equalsIgnoreCase("none"))
								{
									if (eg_nutanixMapping == null)
									{
										eg_nutanixMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_nutanixmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);

									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int cvmUserIdx = aListProcessedParamNamesAndValues.indexOf("-Prism_user");
										String strCVMUserValue = (String)aListProcessedParamNamesAndValues.get(cvmUserIdx+1);

										int cmvPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Prism_password");
										String strCVMPasswordValue = (String)aListProcessedParamNamesAndValues.get(cmvPasswordIdx+1);
										strCVMPasswordValue = EgCrypt.decrypt(strCVMPasswordValue);
										strCVMPasswordValue = EgCrypt.encrypt(strCVMPasswordValue);

										int cvmSslIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(cvmSslIdx+1);

										int webPortIdx = aListProcessedParamNamesAndValues.indexOf("-webPort");
										String webPort = (String)aListProcessedParamNamesAndValues.get(webPortIdx+1);

										String isDiscovery = "No";
										String nutanixPattern = eg_servicesIni.getValue("NUTANIX",cvm_ipValue);
										StringTokenizer sst = new StringTokenizer(nutanixPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
										}

										//if (strSslValue != null)
										//{
											//if (strSslValue.equalsIgnoreCase("true"))
											//{
												//if (webPort != null)
												//{
													//if (webPort.equalsIgnoreCase("default"))
													//{
														//webPort = "443";
													//}
												//}
												//else
												//{
													//webPort = "443";
												//}
											//}
											//else
											//{
												//if (webPort != null)
												//{
													//if (webPort.equalsIgnoreCase("default"))
													//{
														//webPort = "80";
													//}
												//}
												//else
												//{
													//webPort = "80";
												//}
											//}
										//}

										String pattern = strSslValue + "#" + strCVMUserValue + "#" + strCVMPasswordValue + "#" + isDiscovery + "#" + webPort;
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"NUTANIX",cvm_ipValue,pattern));

									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + tempComponentNickName + "," + strHostValue + ",NULL";

									if (aListNutMappingIniEntries == null)
									{
										aListNutMappingIniEntries = new ArrayList();
									}
									aListNutMappingIniEntries.add(new IniHelper(IniHelper.SET,cvm_ipValue,Var,Val));
								}
							}
							// for nutanix changes - ends

							// for RHEV //////////////////////
							if (configureRhev)
							{
								int rhevIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_host");
								String rhev_mgrValue = (String)aListProcessedParamNamesAndValues.get(rhevIdx+1);
								if (!rhev_mgrValue.equalsIgnoreCase("other") && !rhev_mgrValue.equalsIgnoreCase("none"))
								{
									if (eg_rhevMapping == null)
									{
										eg_rhevMapping = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_rhevmapping.ini");
									}

									int hostidx = aListProcessedParamNamesAndValues.indexOf("-host");
									String strHostValue = (String)aListProcessedParamNamesAndValues.get(hostidx+1);
									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int rhevUserIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_user");
										String strRhevUserValue = (String)aListProcessedParamNamesAndValues.get(rhevUserIdx+1);

										int rhevPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_password");
										String strRhevPasswordValue = (String)aListProcessedParamNamesAndValues.get(rhevPasswordIdx+1);
										strRhevPasswordValue = EgCrypt.decrypt(strRhevPasswordValue);
										strRhevPasswordValue = EgCrypt.encrypt(strRhevPasswordValue);

										int rhevSSLIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(rhevSSLIdx+1);

										int mgrPortIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_port");
										String mgrPort = (String)aListProcessedParamNamesAndValues.get(mgrPortIdx+1);

										int domainIdx = aListProcessedParamNamesAndValues.indexOf("-Rhel_mgr_domain");
										String domain = (String)aListProcessedParamNamesAndValues.get(domainIdx+1);

										String isDiscovery = "No";
										String rhevMgrPattern = eg_servicesIni.getValue("RHEV",rhev_mgrValue);
										StringTokenizer sst = new StringTokenizer(rhevMgrPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
										}

										if (strSslValue != null)
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												if (mgrPort != null)
												{
													if (mgrPort.equalsIgnoreCase("default"))
													{
														mgrPort = "8443";
													}
												}
												else
												{
													mgrPort = "8443";
												}
											}
											else
											{
												if (mgrPort != null)
												{
													if (mgrPort.equalsIgnoreCase("default"))
													{
														mgrPort = "8080";
													}
												}
												else
												{
													mgrPort = "8080";
												}
											}
										}
										String pattern = strSslValue + "#" + strRhevUserValue + "#" + strRhevPasswordValue + "#" + isDiscovery + "#" + mgrPort +"#"+ domain; 
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"RHEV",rhev_mgrValue,pattern));
									}

									String Var = componentType + ":" + tempComponentName;
									String Val = componentType + "," + strHostValue  + "," + tempComponentNickName + ","+tempPort;

									if (aListRhevMappingIniEntries == null)
									{
										aListRhevMappingIniEntries = new ArrayList();
									}
									aListRhevMappingIniEntries.add(new IniHelper(IniHelper.SET,rhev_mgrValue,Var,Val));

								}
							}


							// for XMS IP Configuration
							if (configureXMSIP)
							{
								int xmsIPIdx = aListProcessedParamNamesAndValues.indexOf("-xms_ip");
								String xmsIPValue = (String)aListProcessedParamNamesAndValues.get(xmsIPIdx+1);
								if (!xmsIPValue.equalsIgnoreCase("other") && !xmsIPValue.equalsIgnoreCase("none"))
								{
									if (z == 0)
									{
										if (eg_servicesIni == null)
										{
											eg_servicesIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
										}

										int xmsUserIdx = aListProcessedParamNamesAndValues.indexOf("-XtremIO_user");
										String strXMSUserValue = (String)aListProcessedParamNamesAndValues.get(xmsUserIdx+1);

										int xmsPasswordIdx = aListProcessedParamNamesAndValues.indexOf("-XtremIO_password");
										String strXMSPasswordValue = (String)aListProcessedParamNamesAndValues.get(xmsPasswordIdx+1);
										strXMSPasswordValue = EgCrypt.decrypt(strXMSPasswordValue);
										strXMSPasswordValue = EgCrypt.encrypt(strXMSPasswordValue);

										int xmsSSLIdx = aListProcessedParamNamesAndValues.indexOf("-ssl");
										String strSslValue = (String)aListProcessedParamNamesAndValues.get(xmsSSLIdx+1);

										if (!StringUtils.isNull(strSslValue))
										{
											if (strSslValue.equalsIgnoreCase("true"))
											{
												strSslValue = "Yes";
											}
											else
											{
												strSslValue = "No";
											}
										}

										String isDiscovery = "No";
										String xmsMgrPattern = eg_servicesIni.getValue("EMC_XtremIO_4x",xmsIPValue);
										StringTokenizer sst = new StringTokenizer(xmsMgrPattern,"#");
										if (sst.hasMoreTokens())
										{
											sst.nextToken();
											sst.nextToken();
											sst.nextToken();
											isDiscovery = sst.nextToken();
										}

										String pattern = strSslValue + "#" + strXMSUserValue + "#" + strXMSPasswordValue + "#" + isDiscovery; 
										if (aListServicesIniEntries == null)
										{
											aListServicesIniEntries = new ArrayList();
										}
										aListServicesIniEntries.add(new IniHelper(IniHelper.SET,"EMC_XtremIO_4x",xmsIPValue,pattern));
									}
								}
							}
						}
					}
					else
					{
						ArrayList aListEachTestNameVal = getParameterList(oldValue,false);
						ArrayList aListEachTestNameValTemp = getParameterList(oldValue,true);

						for (int m=0;m<aListProcessedParamNamesAndValues.size();m=m+2)
						{
							String paramName = (String)aListProcessedParamNamesAndValues.get(m);
							String paramNameInLowerCase = paramName.toLowerCase();
							String paramValue = (String)aListProcessedParamNamesAndValues.get(m+1);

							boolean allowToModifyParameterValue = true;
							if (k != 0)
							{
								if (paramNameInLowerCase.equals("-ddfreq"))
								{
									allowToModifyParameterValue = false;
								}
							}

							if (aListEachTestNameValTemp.contains(paramNameInLowerCase) && allowToModifyParameterValue)
							{
								boolean isParamChoosen = true;

								//Applicable only to other components.not to UserInitiatedComponent.
								if (z > 0)
								{
									//ensuring "Are we updating the only the parameter(s) which we picked in apply to other component page?"
									if (!aListChoosenParametersInLowerCase.contains(paramNameInLowerCase))
									{
										isParamChoosen = false;
									}
								}
								else
								{
									//Applicable only to UserInitiatedComponent.
									//ensuring "Are we updating the parameter(s) that are displayed 
									//in UI?"i.e shouldnot configure the hidden parameters such as 
									//mCount,rptName
									if (!aListTemp.contains(paramName))
									{
										isParamChoosen = false;
									}
								}

								if (isParamChoosen)
								{
									int paramIdx = aListEachTestNameValTemp.indexOf(paramNameInLowerCase);
									aListEachTestNameVal.remove(paramIdx+1);
									aListEachTestNameVal.add(paramIdx+1,paramValue);
								}
							}
						}
						testParam = aListEachTestNameVal.toString();
						testParam = testParam.substring(1,testParam.length()-1);
						testParam = StringUtils.replace(testParam,",","");
					}

					strBuffer = new StringBuffer();
					if (isTestAtIntialConfiguration)
					{
						String lowerCaseTestParam = testParam.toLowerCase();
						ArrayList aListOldValues = getParameterList(oldValue,false);
						ArrayList aListNewValues = getParameterList(testParam.trim(),false);
						if (lowerCaseTestParam.indexOf(" -mode ") > -1 && 
							(lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 || lowerCaseTestParam.indexOf(" -service_url_path ") > -1))
						{
							//only for the component type "Java Application"
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -measure_mode ") > -1 && 
							(lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 || lowerCaseTestParam.indexOf(" -service_url_path ") > -1) &&
							lowerCaseTestParam.indexOf(" -logfilename ") > -1)
						{
							//only for the component type "Java Application" and JvmMemPoolGCTest
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -measurement_mode ") > -1 && 
							lowerCaseTestParam.indexOf(" -jmx_remote_port ") > -1 &&
							lowerCaseTestParam.indexOf(" -ssl ") > -1 && lowerCaseTestParam.indexOf(" -url ") > -1)
						{
							//only for the component type "Java Application" and JvmMemPoolGCTest
							strBuffer.append(doProperUpdateForJVMComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if (lowerCaseTestParam.indexOf(" -use_sapcontrol ") > -1 && testName.equals("AsAbapWorkTest"))
						{
							//only for the component type "SAP ABAP Instance" and AsAbapWorkTest
							strBuffer.append(doProperUpdateForABAPComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else if(lowerCaseTestParam.indexOf(" -snmpport ") > -1)
						{
							//only for snmp component
							strBuffer.append(doProperUpdateForSNMPComponent(oldValue,aListOldValues,testParam.trim(),aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
						else
						{
							//other components
							strBuffer.append(doProperUpdate(aListOldValues,aListNewValues,aListSpecialCharacterAllowedParam,aListEgKeyWords,hasPasswordParameters,aListPasswordParameters,aListParamsWithDoubleQuotes));
						}
					}
					else
					{
						strBuffer.append("-manual");
					}
					strBuffer.append(", " + testParam + ", ");

					//for handling test period value - starts here
					if (isUserInitiatedTest)
					{
						if (z == 0)
						{
							strTestPeriod = new String(testPeriod);
						}
						else
						{
							if (aListChoosenParametersInLowerCase.contains("-testperiod"))
							{
								strTestPeriod = new String(testPeriod);
							}
							else
							{
								strTestPeriod = oldIniValue.substring(oldIniValue.lastIndexOf(",")+1,oldIniValue.length());
							}
						}
					}
					else
					{
						if (aListCommonTestRelationVariables.contains(strTestName))
						{
							strTestPeriod = new String(testPeriod);
						}
						else
						{
							strTestPeriod = oldIniValue.substring(oldIniValue.lastIndexOf(",")+1,oldIniValue.length());
						}
					}
					//ends here

					strBuffer.append(strTestPeriod.trim());

					if (aListTempAgents.size() > 1)
					{
						tempTestValue = strBuffer.toString();
						tempResultantPattern = resultantPattern;
						isParameterSetAvailable = true;
					}
				}
				else
				{
					strBuffer = new StringBuffer(tempTestValue);
					resultantPattern = tempResultantPattern;
				}

				if (aListAgentsIniEntries == null)
				{
					aListAgentsIniEntries = new ArrayList();
				}
				aListAgentsIniEntries.add(new IniHelper(IniHelper.SET,tempAgentNickName,resultantPattern,strBuffer.toString()));
			}

			//for aggregate - starts
			boolean isAggregateTest = egAggInfo.isAggregateTest(strTestName);
			if (isAggSupported && allowAggOperation && !isAggComponentType && !isAggregateTest)
			{
				boolean hasAggTest = false;
				boolean allowAggregateOperation = true;

				//this case will come for apply to other component.
				//Aggregate operation shoul dbe suspended when testperiod
				//is deselected
				if (z > 0)
				{
					allowAggregateOperation = aListChoosenParametersInLowerCase.contains("-testperiod");
				}

				//this case will come for test relation
				//aggregation operation should be suspended for the test other than user intiated
				//test, when there is no relation under[COMMON_TEST_RELATION]
				if (allowAggregateOperation)
				{
					if (k > 0)
					{
						allowAggregateOperation = aListCommonTestRelationVariables.contains(strTestName);
					}
				}

				if (allowAggregateOperation)
				{
					String maxTestFrequency = new String(testPeriod);
					String aggregateTestName = "";
					if (aListAggTest.contains(strTestName))
					{
						aggregateTestName = (String)aListAggTest.get(aListAggTest.indexOf(strTestName)+1);
						hasAggTest = true;
					}
					if (hasAggServerType && hasAggTest)
					{
						for (int m=0;m<aggCompWithType.size();m++)
						{
							String strAgg = (String)aggCompWithType.get(m);
							if (!managedComponents.contains(strAgg)) continue;

							String strAggType = strAgg.substring(0,strAgg.indexOf(":"));
							String strAggCompName = strAgg.substring(strAgg.indexOf(":")+1);
							List aListAgentsForAggComponent = getAgents(strAggCompName);
							List aListTempAggAgents = null;
							boolean isThisAggTestExternal = egSpecs.isExternalTest(aggregateTestName,strAggType);
							if (isThisAggTestExternal)
							{
								aListTempAggAgents = aListAgentsForAggComponent.subList(1,aListAgentsForAggComponent.size());
							}
							else
							{
								aListTempAggAgents = aListAgentsForAggComponent.subList(0,1);
							}

							if (aListTempAggAgents == null) continue;
							for (int s=0;s<aListTempAggAgents.size();s++)
							{
								String auditAggTest = "";
								String tempPattern = "";
								String tempTestParam = "";
								String strComp = "";
								String tempAggAgent = (String)aListTempAggAgents.get(s);
								boolean b_isPortRelevantForAggTest = egSpecs.isPortRelevantForTest(aggregateTestName);

								String agg_resultantPattern = "";
								String agg_specificPattern_A = aggregateTestName + ":" + strAggType + ":" + strAggCompName;
								String agg_specificPattern_B = aggregateTestName + ":" + strAggType + ":" + strAggCompName.substring(0,strAggCompName.indexOf(":"));
								String agg_defaultPattern_A = aggregateTestName + "::" + strAggCompName;
								String agg_defaultPattern_B = aggregateTestName + "::" + strAggCompName.substring(0,strAggCompName.indexOf(":"));
								List listAgentIniVariables = Arrays.asList(agentIni.getVariables(tempAggAgent));

								if (listAgentIniVariables.contains(agg_specificPattern_A))
								{
									agg_resultantPattern = agg_specificPattern_A;
								}
								else if (listAgentIniVariables.contains(agg_specificPattern_B))
								{
									agg_resultantPattern = agg_specificPattern_B;
								}
								else if (listAgentIniVariables.contains(agg_defaultPattern_A))
								{
									agg_resultantPattern = agg_defaultPattern_A;
								}
								else if (listAgentIniVariables.contains(agg_defaultPattern_B))
								{
									agg_resultantPattern = agg_defaultPattern_B;
								}

								if (agg_resultantPattern.equalsIgnoreCase("")) continue;

								tempTestParam = agentIni.getValue(tempAggAgent,agg_resultantPattern);
								if(tempTestParam == null || tempTestParam.trim().length()==0) continue;
								String oldTestFrequency = tempTestParam.substring(tempTestParam.lastIndexOf(EgConstants.COMMA)+1).trim();
								oldTestFrequency = oldTestFrequency.trim();
								if (Integer.parseInt(maxTestFrequency) > Integer.parseInt(oldTestFrequency))
								{
									tempTestParam = "-manual," + tempTestParam.substring(tempTestParam.indexOf(",")+1,tempTestParam.lastIndexOf(",")) + ", " + maxTestFrequency;
									if (aListAgentsIniEntries == null)
									{
										aListAgentsIniEntries = new ArrayList();
									}
									aListAgentsIniEntries.add(new IniHelper(IniHelper.SET,tempAggAgent,agg_resultantPattern,tempTestParam));
									aListAuditAggComponents.add(agg_resultantPattern);
								}
							}
						}
					}
				}
			}
			//for aggregate - ends
		}

		//Detailed Diagnosis - start
		if (!detailedDiagnosis.equals(""))
		{
			List listDisabledDDTestGlobally = Arrays.asList(testinfoIni.getVariables("Disable_DD"));
			if (!listDisabledDDTestGlobally.contains(testName))
			{
				String strComp = "";
				String disabledSpecificDDTests = "";
				if (isPortRelevantForTest)
				{
					strComp = tempComponentName;
					disabledSpecificDDTests = testinfoIni.getValue("Disable_Specific_DD",strComp);
				}
				else
				{
					if (tempComponentName.indexOf(":") == -1)
					{
						strComp = tempComponentName+":NULL";
					}
					else
					{
						strComp = tempComponentNickName + ":NULL";
					}
					disabledSpecificDDTests = testinfoIni.getValue("Disable_Specific_DD",strComp);
				}

				ArrayList aListDisabledSpecificDDTests = getArrayList(disabledSpecificDDTests,",");

				if (aListTestInfoIniEntries == null)
				{
					aListTestInfoIniEntries = new ArrayList();
				}

				if (detailedDiagnosis.equals("Off") && !aListDisabledSpecificDDTests.contains(testName))
				{
					String str = aListDisabledSpecificDDTests.toString();
					str = str.substring(1,str.length()-1);
					str = StringUtils.replace(str," ","");
					if(str.length()>0)
					{
						str = str + "," + testName;
					}
					else
					{
						str = testName;
					}

					aListTestInfoIniEntries.add(new IniHelper(IniHelper.SET,"Disable_Specific_DD",strComp,str));
				}
				else if (detailedDiagnosis.equals("On") && aListDisabledSpecificDDTests.contains(testName))
				{
					aListDisabledSpecificDDTests.remove(testName);
					if (aListDisabledSpecificDDTests.size() == 0)
					{
						aListTestInfoIniEntries.add(new IniHelper(IniHelper.DELETE,"Disable_Specific_DD",strComp,""));
					}
					else
					{
						String str = aListDisabledSpecificDDTests.toString();
						str = str.substring(1,str.length()-1);
						str = StringUtils.replace(str," ","");
						aListTestInfoIniEntries.add(new IniHelper(IniHelper.SET,"Disable_Specific_DD",strComp,str));
					}
				}
			}
		}
		//Detailed Diagnosis - ends

		//for auditlog - starts
		if (isAuditLogEnabled && z > 0)
		{
			if (auditParamIdx <= 9)
			{
				auditLogThread.setCurrentValue("0"+auditParamIdx+"~~TEST CONFIGURED FOR OTHER COMPONENTS",tempComponentName);
			}
			else
			{
				auditLogThread.setCurrentValue(auditParamIdx+"~~TEST CONFIGURED FOR OTHER COMPONENTS",tempComponentName);
			}
		}
		//for auditlog - ends
	}
	//Iterating each component - ends

	if (aListAuditAggComponents != null)
	{
		if (!aListAuditAggComponents.isEmpty())
		{
			auditParamIdx = auditParamIdx+1;
		}

		TreeMap tmapAuditAggComp = new TreeMap();
		for (int i=0;i<aListAuditAggComponents.size();i++)
		{
			String strAuditPattern = (String)aListAuditAggComponents.get(i);
			String auditAggTest = strAuditPattern.substring(0,strAuditPattern.indexOf(":"));
			String auditAggComponentName = strAuditPattern.substring(strAuditPattern.indexOf("::")+2,strAuditPattern.length());
			int idx = auditAggComponentName.indexOf(":NULL");
			if (idx != -1)
			{
				auditAggComponentName = auditAggComponentName.substring(0,idx);
			}

			ArrayList aListAuditTests = (ArrayList)tmapAuditAggComp.get(auditAggComponentName);

			if (aListAuditTests == null)
			{
				ArrayList aListTempAuditTests = new ArrayList();
				aListTempAuditTests.add(auditAggTest);
				tmapAuditAggComp.put(auditAggComponentName,aListTempAuditTests);
			}
			else
			{
				aListAuditTests.add(auditAggTest);
			}
		}

		if (allowAggOperation)
		{
			Iterator itrComponents = tmapAuditAggComp.keySet().iterator();
			while (itrComponents.hasNext())
			{
				String strComponentName = (String)itrComponents.next();
				ArrayList aListAuditTests = (ArrayList)tmapAuditAggComp.get(strComponentName);
				for (int j=0;j<aListAuditTests.size();j++)
				{
					String auditAggTest = (String)aListAuditTests.get(j);
					if (auditAggTest.endsWith("_ex"))
					{
						if (auditParamIdx <= 9)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),auditAggTest);
						}
						else
						{
							auditLogThread.setCurrentValue(auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),auditAggTest);
						}
					}
					else
					{
						if (auditParamIdx <= 9)
						{
							auditLogThread.setCurrentValue("0"+auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),"$test$:"+auditAggTest);
						}
						else
						{
							auditLogThread.setCurrentValue(auditParamIdx+"~~AUTO CONFIGURED AGGREGATE TEST(S) FOR "+ strComponentName +" of "+_mapping.getComponentTypeDescription(aggComponentType),"$test$:"+auditAggTest);
						}
					}
				}
				auditParamIdx++;
			}
		}
	}

	//for auditlog - ends
	if (isAuditLogEnabled)
	{
		auditLogThread.sendItToDB();
	}
	//for auditlog - ends

	//for eg_agents.ini - starts
	if (aListAgentsIniEntries != null)
	{
		IniFile eg_agentsIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_agents.ini");
		for (int i=0;i<aListAgentsIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListAgentsIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_agentsIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_agentsIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_agentsIniSync);
	}
	//for eg_agents.ini - ends

	//for eg_testinfo.ini - starts
	if (aListTestInfoIniEntries != null)
	{
		IniFile eg_testInfoIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_testinfo.ini");
		for (int i=0;i<aListTestInfoIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListTestInfoIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_testInfoIniSync.setValue(sub,key,val);
				}
				else if (iniAction.equals(IniHelper.DELETE))
				{
					eg_testInfoIniSync.deleteValue(sub,key);
				}
			}
		}
		eg_testInfoIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_testInfoIniSync);
	}
	//for eg_testinfo.ini - ends

	//for eg_services.ini - starts
	if (aListServicesIniEntries != null)
	{
		IniFile eg_servicesIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_services.ini");
		for (int i=0;i<aListServicesIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListServicesIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_servicesIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_servicesIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_servicesIniSync);
	}
	//for eg_services.ini - ends

	//for eg_nutanixmapping.ini - starts
	if (aListNutMappingIniEntries != null)
	{
		IniFile eg_NutMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_nutanixmapping.ini");
		for (int i=0;i<aListNutMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListNutMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_NutMappingIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_NutMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_NutMappingIniSync);
	}
	//for eg_nutanixmapping.ini - ends

	//for eg_vcmapping.ini - starts
	if (aListVcMappingIniEntries != null)
	{
		IniFile eg_VcMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_vcmapping.ini");
		for (int i=0;i<aListVcMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListVcMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null)
			{
				if (iniAction.equals(IniHelper.SET))
				{
					eg_VcMappingIniSync.setValue(sub,key,val);
				}
			}
		}
		eg_VcMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_VcMappingIniSync);
	}
	//for eg_vcmapping.ini - ends
	
	// for eg_rhevmapping.ini - starts
	if (aListRhevMappingIniEntries != null)
	{
		IniFile eg_rhevMappingIniSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_rhevmapping.ini");
		for (int i=0;i<aListRhevMappingIniEntries.size();i++)
		{
			IniHelper iniHelper= (IniHelper)aListRhevMappingIniEntries.get(i);
			String iniAction = iniHelper.getAction();
			String sub = iniHelper.getSubject();
			String key = iniHelper.getVariable();
			String val = iniHelper.getValue();
			if (iniAction != null && iniAction.equals(IniHelper.SET))
			{
				eg_rhevMappingIniSync.setValue(sub,key,val);
			}
		}
		eg_rhevMappingIniSync.saveFile();
		EgConfigFilesSync.releaseInstance(eg_rhevMappingIniSync);
	}
	// for eg_rhevmapping.ini - ends

	//Starting the discovery process
	servicer.startDiscovery("1");
	EgConfigFilesSync.releaseInstance(infraIni);
	//source:EgTestParamp.jsp
	// Corrective script won't be uploaded to the respective directory
	// if the path is directly given in the textfield rather than using the
	// EgUploadServlet.java - this code is just to fix it!
	String correctiveScriptAdded = request.getParameter("correct");
	if(correctiveScriptAdded != null && correctiveScriptAdded.equals("true"))
	{
		// Copy the file to the destination dir if needed
		// inform other managers about this script if
		// this manager is part of a cluster

		String agentOS = request.getParameter("agentOS");
		String file = request.getParameter("correctivescript");
		//uploadScript(agentOS, file);
		IniFile mgrMiscObj = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_mgrmisc.ini");
		if (!StringUtils.isNull(file))
		{
			if (file.indexOf(",") == -1)
			{
				mgrMiscObj.setValue("ASSOCIATED_CORRECTIVE_SCRIPTS",agentOS+":"+file,"true");
			}
			else
			{
				ArrayList correctiveScriptList = StringUtils.egTokenizer(file,",");
				if (correctiveScriptList != null && correctiveScriptList.size() > 0)
				{
					for (int s=0;s<correctiveScriptList.size();s++)
					{
						String strScriptFileName = (String) correctiveScriptList.get(s);

						mgrMiscObj.setValue("ASSOCIATED_CORRECTIVE_SCRIPTS",agentOS+":"+strScriptFileName,"true");
					}
				}
			}
		}
		mgrMiscObj.saveFile();
		EgConfigFilesSync.releaseInstance(mgrMiscObj);
	}

	//forward to result page - starts
	session.setAttribute("aListDisplayParamNamesAndValues",aListDisplayParamNamesAndValues);
	if (fromPage.equals("EgApplyToOtherComponents.jsp") && !aListSelectedComponents.isEmpty())
	{
		session.setAttribute("aListAdditionalComponentsConfigured",aListSelectedComponents);
	}

	String query = "EgConfigureComponentResult.jsp?componentType="+EgURLEncoder.encode(componentType,"UTF-8")+"&componentName="+EgURLEncoder.encode(componentName,"UTF-8")+"&testName="+EgURLEncoder.encode(testName,"UTF-8")+"&testType="+EgURLEncoder.encode(testType,"UTF-8");
	//forward to result page - ends
	rootJson.put("success",true);
	rootJson.put("successUpdate","true");
	out.println(rootJson.toString());
%>



<%!
	EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	EgAggregateInfo egAggInfo = new EgAggregateInfo("manager");
	EgDiscInfo discInfo = new EgDiscInfo("manager");

	String[] paramToContinue = {"agentless","site","aluser","alpassword","almode","sshPort"};

	//param to be continued for snmpV1 and snmpV2
	String[] snmpV1V2ParamToContinue = {"username","authpass","authtype","encryptflag","encrypttype","encryptpassword"};

	public ArrayList getArrayList(String strValue,String delimiter)
	{
		ArrayList aL = new ArrayList();
		StringTokenizer stTempTokens = new StringTokenizer(strValue,delimiter);
		while (stTempTokens.hasMoreTokens())
		{
			String str = stTempTokens.nextToken().trim();
			aL.add(str);
		}
		return aL;
	}

	private void uploadScript(String agentOS, String file)
	{
		File scriptFile = new File(file);

		if(scriptFile == null || !scriptFile.exists())
		{
			return;
		}
		else
		{
			//Here we would need just the script file's name for a
			// SM to download it. Not the file name with path.
			if(file.indexOf("/") > -1)
			{
				file = file.substring(file.lastIndexOf("/"));
			}
			else if(file.indexOf("\\") > -1)
			{
				file = file.substring(file.lastIndexOf("\\"));
			}
		}

		if(EgInstallInfo.isClusterSupported)
		{
			//If clustering is supported intimate other managers about the new script.
			UploadCorrectiveScript uploadCorrectiveScript = new UploadCorrectiveScript();
			uploadCorrectiveScript.getCorrectiveScript(agentOS, file);
			uploadCorrectiveScript = null;
		}

		String os = System.getProperty("os.name");
		Runtime r=null;
		Process p = null;

		String destinationStr = EgInstallInfo.getInstallDir() + "/bin/AutoCorrect/" + agentOS;
		File destinationDir = new File(destinationStr);

		try
		{
			if( os.indexOf("Windows")!= -1)
			{
				r = Runtime.getRuntime();
				String cmd ="cmd.exe /c copy " + file +" "+ destinationDir.getAbsolutePath();
				p = r.exec(cmd);

			}
			else
			{
				r = Runtime.getRuntime();
				String cmd ="cp "+ file +" "+ destinationDir.getAbsolutePath();
				try
				{
					p = r.exec(cmd);
				}
				catch(Exception eee)
				{
				}
			}
		}
		catch(Exception x){}

		try
		{
			if (p != null)
			{
				int processExecuted = p.waitFor();
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}

		if (p != null)
		{
			p.destroy();
		}
	}

	private List getAgents(String componentName)
	{
		List agentsList = new ArrayList();

		EgExternalInfo egExternalInfo = new EgExternalInfo("manager");
		Hashtable internalAgentMap = egExternalInfo.getInternalAgentMap();
		String componentNickName = componentName.substring(0,componentName.indexOf(":"));
		String agentNickName = "";

		boolean isRemote = false;

		// To fetch the exact agent for the selected component - start
		isRemote = egExternalInfo.isRemoteBased(componentNickName);
		if (isRemote)
		{
			//Agentless
			agentNickName = egExternalInfo.getRemoteAgentForHost(componentNickName);
		}
		else
		{
			//Auto or Manual
			String agentName = egExternalInfo.getAgentFor(componentNickName);
			if (agentName != null) //Manual
			{
				if (internalAgentMap != null && internalAgentMap.containsKey(agentName))
				{
					agentNickName = (String)internalAgentMap.get(agentName);
				}
				else
				{
					agentNickName = agentName;
				}
			}
			else //Auto
			{
				agentNickName = componentNickName;
			}
		}

		//adding an internal agent (or) a remote agent
		agentsList.add(agentNickName);
		//To fetch the exact agent for the selected component - end

		//To fetch the external agent for the selected component type - starts
		boolean hasExternalAgent = egExternalInfo.hasExternalAgent(componentNickName);
		if (hasExternalAgent)
		{
			String extAgents[] = egExternalInfo.getExternalAgentsForHost(componentNickName);
			//adding one or more external agent(s)
			agentsList.addAll(Arrays.asList(extAgents));
		}
		//To fetch the external agent for the selected component type - ends

		return agentsList;
	}

	public String doProperUpdate(
			ArrayList aListOldValues,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVal = "";
		String result = "-manual";

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);

			if (aListParamsWithDoubleQuotes.contains(tmpVar.toLowerCase()))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				if (aListParamsWithDoubleQuotes.contains(tmpVar.toLowerCase()))
				{
					tmpVal = (String)aListOldValues.get(i+1);
				}
				else
				{
					tmpVal = (String)aListOldValues.get(i+1);
					tmpVal = tmpVal.trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result = "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForSNMPComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		ArrayList aListSnmpV1V2Param = new ArrayList();
		aListSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListSnmpV3Param = new ArrayList();
		aListSnmpV3Param.add("username");
		aListSnmpV3Param.add("authpass");
		aListSnmpV3Param.add("authtype");
		aListSnmpV3Param.add("encryptflag");
		aListSnmpV3Param.add("encrypttype");
		aListSnmpV3Param.add("encryptpassword");

		int tempIdx = newValueLowerCase.indexOf("-snmpversion");
		String tempValue = "";
		String newSnmpVersion = "";
		if (tempIdx > -1)
		{
			tempValue = newValue.substring(tempIdx+1);
			newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newSnmpVersion = newSnmpVersion.trim();
		}

		String oldSnmpVersion = "";
		if (!oldValue.equals(""))
		{
			tempIdx = oldValueLowerCase.indexOf("-snmpversion")+1;
			if (tempIdx > -1)
			{
				tempValue = oldValue.substring(tempIdx);
				oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				oldSnmpVersion = oldSnmpVersion.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (newSnmpVersion.equalsIgnoreCase("v3"))
				{
					if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
				}
				else//v1,v2
				{
					if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
				{
					tmpVal = (String)aListOldValues.get(i+1);
				}
				else
				{
					tmpVal = (String)aListOldValues.get(i+1);
					tmpVal = tmpVal.trim();
				}

				if (tmpVal.startsWith("$"))
				{
					if (oldSnmpVersion.equalsIgnoreCase("v3"))
					{
						if (aListSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
					}
					else //v1,v2
					{
						if (aListSnmpV3Param.contains(tmpVarLowerCase)) continue;
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForJVMComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasMeasureMode = (oldValue.indexOf("-measure_mode") > -1);
		boolean hasMeasurementMode = (oldValue.indexOf("-measurement_mode") > -1);

		ArrayList aListJvmParam = new ArrayList();
		//The RadioParams "mode" and "profiler" are not added.because we know that these params will not have $unconfigured value.
		aListJvmParam.add("jmx_remote_port");
		aListJvmParam.add("user");
		aListJvmParam.add("password");
		aListJvmParam.add("pct_low_cpu_util_threads");
		aListJvmParam.add("pct_medium_cpu_util_threads");
		aListJvmParam.add("pct_high_cpu_util_threads");
		aListJvmParam.add("service_url_path");


		ArrayList aListJvmLogParam = new ArrayList();
		aListJvmLogParam.add("jrehome");
		aListJvmLogParam.add("logfilename");

		ArrayList aListJvmWarParam = new ArrayList();
		aListJvmWarParam.add("ssl");
		aListJvmWarParam.add("url");
		aListJvmWarParam.add("username");
		aListJvmWarParam.add("password");
		aListJvmWarParam.add("encryptpass");

		ArrayList aListJvmSnmpV1V2Param = new ArrayList();
		aListJvmSnmpV1V2Param.add("snmpcommunity");

		ArrayList aListJvmSnmpV3Param = new ArrayList();
		aListJvmSnmpV3Param.add("username");
		aListJvmSnmpV3Param.add("authpass");
		aListJvmSnmpV3Param.add("authtype");
		aListJvmSnmpV3Param.add("encryptflag");
		aListJvmSnmpV3Param.add("encrypttype");
		aListJvmSnmpV3Param.add("encryptpassword");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both jmx and snmp
		aListCommonParams.add("profiler_home");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newModeValue = "";
		if (newValueLowerCase.indexOf(" -mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-mode")+1;
			tempValue = newValue.substring(tempIdx);
			newModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newModeValue = newModeValue.trim();
		}

		//retreving the snmpversion value
		String newSnmpVersion = "";
		if (newValueLowerCase.indexOf(" -snmpversion ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-snmpversion")+1;
			tempValue = newValue.substring(tempIdx);
			newSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newSnmpVersion = newSnmpVersion.trim();
		}

		//retreving the profiler value if exist
		String newProfilerValue = "";
		if (newValueLowerCase.indexOf(" -profiler ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -profiler ")+1;
			tempValue = newValue.substring(tempIdx);
			newProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newProfilerValue = newProfilerValue.trim();
		}

		//retreving the measure mode value
		String newMeasureModeValue = "";
		if (newValueLowerCase.indexOf(" -measure_mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-measure_mode")+1;
			tempValue = newValue.substring(tempIdx);
			newMeasureModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newMeasureModeValue = newMeasureModeValue.trim();
		}

		//retreving the measurement mode value
		String newMeasurementModeValue = "";
		if (newValueLowerCase.indexOf(" -measurement_mode ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-measurement_mode")+1;
			tempValue = newValue.substring(tempIdx);
			newMeasurementModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newMeasurementModeValue = newMeasurementModeValue.trim();
		}

		String oldModeValue = "";
		String oldMeasureModeValue = "";
		String oldMeasurementModeValue = "";
		String oldSnmpVersion = "";
		String oldProfilerValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasMeasureMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-measure_mode")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldMeasureModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldMeasureModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldMeasureModeValue = oldMeasureModeValue.trim();
			}

			//retreving the measurement mode value
			if (hasMeasurementMode)
			{
				tempIdx = oldValueLowerCase.indexOf("-measurement_mode")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldMeasurementModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldMeasurementModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldMeasurementModeValue = oldMeasurementModeValue.trim();
			}

			//retreving the mode value
			tempIdx = oldValueLowerCase.indexOf("-mode")+1;
			tempValue = oldValue.substring(tempIdx);
			if (tempValue.indexOf("-") != -1)
			{
				oldModeValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			}
			else
			{
				oldModeValue = tempValue.substring(tempValue.indexOf(" ")+1);
			}
			oldModeValue = oldModeValue.trim();

			//retreving the snmpversion value
			tempIdx = oldValueLowerCase.indexOf("-snmpversion")+1;
			tempValue = oldValue.substring(tempIdx);
			oldSnmpVersion = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			oldSnmpVersion = oldSnmpVersion.trim();

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -profiler ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -profiler ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldProfilerValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldProfilerValue = oldProfilerValue.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (hasMeasureMode)
				{
					if (newMeasureModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //logFile
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}
				else if (hasMeasurementMode)
				{
					if (newMeasurementModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //warFile
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}
				else
				{
					if (newModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else//snmp
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}

						if (newSnmpVersion.equalsIgnoreCase("v1") || 
							newSnmpVersion.equalsIgnoreCase("v2"))
						{
							if (aListJvmSnmpV3Param.contains(tmpVarLowerCase))
							{
								continue;
							}
						}
						else//v3
						{
							if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase))
							{
								continue;
							}
						}
					}

					if (newProfilerValue.equalsIgnoreCase("false") && 
						tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
					{
						continue;
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldModeValue.equalsIgnoreCase("false"))//jmx
					{
						if (!aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else//snmp
					{
						if (aListJvmParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}

						if (oldSnmpVersion.equalsIgnoreCase("v1") || 
							oldSnmpVersion.equalsIgnoreCase("v2"))
						{
							if (aListJvmSnmpV3Param.contains(tmpVarLowerCase)) continue;
						}
						else//v3
						{
							if (aListJvmSnmpV1V2Param.contains(tmpVarLowerCase)) continue;
						}
					}

					if (newProfilerValue.equalsIgnoreCase("false") && 
						tmpVarLowerCase.equalsIgnoreCase("profiler_home"))
					{
						continue;
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	private String doProperUpdateForABAPComponent(
			String oldValue,
			ArrayList aListOldValues,
			String newValue,
			ArrayList aListNewValues,
			ArrayList aListSpecialCharacterAllowedParam,
			ArrayList aListEgKeyWords,
			boolean hasPasswordParameters,
			ArrayList aListPasswordParameters,
			ArrayList aListParamsWithDoubleQuotes
		)
	{
		//newValue : User updated value
		//oldValue : Ini value

		HashMap oldUnConPairs = new HashMap();
		HashMap newUnConPairs = new HashMap();
		String tmpStr = "";
		String tmpVar = "";
		String tmpVarLowerCase = "";
		String tmpVal = "";
		String result = "-manual";

		oldValue = oldValue.substring(oldValue.indexOf(",")+1);
		newValue = newValue.substring(newValue.indexOf(",")+1);

		String oldValueLowerCase = oldValue.toLowerCase();
		String newValueLowerCase = newValue.toLowerCase();

		boolean hasUseSapControl = (oldValue.indexOf("-use_sapcontrol") > -1);

		ArrayList aListOsUserParam = new ArrayList();
		aListOsUserParam.add("os_username");
		aListOsUserParam.add("os_password");
		aListOsUserParam.add("ssl");
		aListOsUserParam.add("wsdl_port");

		ArrayList aListSapUserParam = new ArrayList();
		aListSapUserParam.add("timeout");
		aListSapUserParam.add("sapuser");
		aListSapUserParam.add("sysno");
		aListSapUserParam.add("clientname");
		aListSapUserParam.add("router");
		aListSapUserParam.add("password");
		aListSapUserParam.add("Jco_version");
		aListSapUserParam.add("instancename");

		ArrayList aListCommonParams = new ArrayList();
		//param applicable to both SAP control yes and no
		aListCommonParams.add("ddFreq");

		int tempIdx = -1;
		String tempValue = "";

		//retreving the mode value
		String newUseSAPControlValue = "";
		if (newValueLowerCase.indexOf(" -use_sapcontrol ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf("-use_sapcontrol")+1;
			tempValue = newValue.substring(tempIdx);
			newUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
			newUseSAPControlValue = newUseSAPControlValue.trim();
		}

		//retreving the profiler value if exist
		String newDDFreqValue = "";
		if (newValueLowerCase.indexOf(" -ddFreq ") > -1)
		{
			tempIdx = newValueLowerCase.indexOf(" -ddFreq ")+1;
			tempValue = newValue.substring(tempIdx);
			newDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
			newDDFreqValue = newDDFreqValue.trim();
		}

		String oldUseSAPControlValue = "";
		String oldDDFreqValue = "";
		if (!oldValue.equals(""))
		{
			//retreving the measure mode value
			if (hasUseSapControl)
			{
				tempIdx = oldValueLowerCase.indexOf("-use_sapcontrol")+1;
				tempValue = oldValue.substring(tempIdx);
				if (tempValue.indexOf("-") != -1)
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf("-"));
				}
				else
				{
					oldUseSAPControlValue = tempValue.substring(tempValue.indexOf(" ")+1);
				}
				oldUseSAPControlValue = oldUseSAPControlValue.trim();
			}

			//retreving the profiler value if exist
			if (oldValueLowerCase.indexOf(" -ddFreq ") > -1)
			{
				tempIdx = oldValueLowerCase.indexOf(" -ddFreq ")+1;
				tempValue = oldValue.substring(tempIdx);
				oldDDFreqValue = tempValue.substring(tempValue.indexOf(" "),tempValue.indexOf(" -"));
				oldDDFreqValue = oldDDFreqValue.trim();
			}
		}

		for (int i=0;i<aListNewValues.size();i=i+2)
		{
			tmpVar = (String)aListNewValues.get(i);
			if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
			{
				continue;
			}
			tmpVar = tmpVar.substring(1);
			tmpVarLowerCase = tmpVar.toLowerCase();
			if (aListParamsWithDoubleQuotes.contains(tmpVarLowerCase))
			{
				tmpVal = (String)aListNewValues.get(i+1);
			}
			else
			{
				tmpVal = (String)aListNewValues.get(i+1);
				tmpVal = tmpVal.trim();
			}

			if (tmpVal.startsWith("$"))
			{
				if (hasUseSapControl)
				{
					if (newUseSAPControlValue.equalsIgnoreCase("false"))//SAP control false
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else //SAP control true
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
				}

				if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
				{
					String tmpValLowerCase = tmpVal.toLowerCase();
					tmpValLowerCase = tmpValLowerCase.trim();
					if (aListEgKeyWords.contains(tmpValLowerCase))
					{
						newUnConPairs.put(tmpVar,tmpVal);
					}
				}
				else
				{
					newUnConPairs.put(tmpVar,tmpVal);
				}
			}
		}

		if (newUnConPairs.size() > 0)
		{
			for (int i=0;i<aListOldValues.size();i=i+2)
			{
				tmpVar = (String)aListOldValues.get(i);
				if (hasPasswordParameters && aListPasswordParameters.contains(tmpVar))
				{
					continue;
				}
				tmpVar = tmpVar.substring(1);
				tmpVarLowerCase = tmpVar.toLowerCase();
				tmpVal = (String)aListOldValues.get(i+1);

				if (tmpVal.startsWith("$"))
				{
					if (oldUseSAPControlValue.equalsIgnoreCase("false"))//SAP control false
					{
						if (!aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}
					else
					{
						if (aListSapUserParam.contains(tmpVarLowerCase) && 
							!aListCommonParams.contains(tmpVarLowerCase))
						{
							continue;
						}
					}

					if (aListSpecialCharacterAllowedParam.contains(tmpVar.toLowerCase()))
					{
						String tmpValLowerCase = tmpVal.toLowerCase();
						tmpValLowerCase = tmpValLowerCase.trim();
						if (aListEgKeyWords.contains(tmpValLowerCase))
						{
							oldUnConPairs.put(tmpVar,tmpVal);
						}
					}
					else
					{
						oldUnConPairs.put(tmpVar,tmpVal);
					}
				}
			}

			Iterator it = newUnConPairs.keySet().iterator();
			while(it.hasNext())
			{
				Object key = it.next();
				String valNew =  (String)newUnConPairs.get(key);
				String valOld =  (String)oldUnConPairs.get(key);
				if (valNew.equals(valOld))
				{
					result =  "-auto";
					break;
				}
			}
		}

		return result;
	}

	public boolean isParameter(String encryptParam)
	{
		String decryptParam = EgCrypt.decrypt(encryptParam);
		if (decryptParam.equals(encryptParam)) // not password
		{
			return (true);
		}
		return false;
	}

	private ArrayList getParameterList(String str,boolean needLowerCaseKey)
	{
		String delimiter = " -";
		ArrayList aListResultant = new ArrayList();
		String prevKey = "";

		str = str.substring(str.indexOf("-"));
		int spaceHyphenIdx = str.indexOf(delimiter);
		while (spaceHyphenIdx != -1)
		{
			String cutString = str.substring(0,spaceHyphenIdx);

			//This check will be carried out when the cutString contains only the key
			//for e.g.:-
			//str : -admin_password -103:98:88:90:79:76:81:-110:52 -ssl false
			//cutString : -admin_password
			if (cutString.trim().indexOf(" ") == -1)
			{
				String strPart1 = str.substring(cutString.length()+1);
				String strPart2 = strPart1.substring(0,strPart1.indexOf(delimiter));
				cutString = cutString+" "+strPart2;
				spaceHyphenIdx = cutString.length();
			}

			if (cutString.indexOf("\"") != -1)
			{
				String strAfterDoubleQuotes = str.substring(spaceHyphenIdx);
				String remainingPiece = strAfterDoubleQuotes.substring(0,strAfterDoubleQuotes.indexOf("\"")+1);
				cutString = cutString + remainingPiece;

				String key = cutString.substring(0,cutString.indexOf(" "));
				String value = cutString.substring(cutString.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(key.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(key.trim());
				}
				aListResultant.add(value.trim());

				String remainingString = strAfterDoubleQuotes.substring(strAfterDoubleQuotes.indexOf("\"")+1);
				str = remainingString.trim();
				if (str.length() == 0)
				{
					spaceHyphenIdx = -1;
				}
				else
				{
					spaceHyphenIdx = str.indexOf(delimiter);
				}
			}
			else
			{
				if (cutString.startsWith("- "))
				{
					int idx = aListResultant.indexOf(prevKey);
					String strValue = (String)aListResultant.get(idx+1);
					strValue = strValue + " " + cutString;
					aListResultant.remove(idx+1);
					aListResultant.add(strValue);

					str = str.substring(cutString.length()+1);
				}
				else
				{
					String key = cutString.substring(0,cutString.indexOf(" "));
					String value = cutString.substring(cutString.indexOf(" ")+1);
					if (needLowerCaseKey)
					{
						aListResultant.add(key.trim().toLowerCase());
						prevKey = key.trim().toLowerCase();
					}
					else
					{
						aListResultant.add(key.trim());
						prevKey = key.trim();
					}
					aListResultant.add(value.trim());

					str = str.substring(spaceHyphenIdx+1);
				}
				spaceHyphenIdx = str.indexOf(delimiter);
			}
		}

		if (str.length() > 0)
		{
			if (str.startsWith("- "))
			{
				int idx = aListResultant.indexOf(prevKey);
				String strValue = (String)aListResultant.get(idx+1);
				strValue = strValue + " " + str;
				aListResultant.remove(idx+1);
				aListResultant.add(strValue);
			}
			else
			{
				String lastKey = str.substring(0,str.indexOf(" "));
				String lastValue = str.substring(str.indexOf(" ")+1);
				if (needLowerCaseKey)
				{
					aListResultant.add(lastKey.trim().toLowerCase());
				}
				else
				{
					aListResultant.add(lastKey.trim());
				}
				aListResultant.add(lastValue.trim());
			}
		}

		return aListResultant;
	}
%>



