<%
/**********************************************************************************
*	Name			:	EgUploadMIB.jsp
*	Purpose			:	Upload the MIB file and Delete the MIb file.
***********************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import="com.eg.EgMibUtil" %>
<%@ page import="com.eg.UploadMIBFile" %>
<%@ page import="java.util.ArrayList" %>
<%@ page import="java.util.Collections" %>
<%@ page import= "com.egurkha.util.StringUtils"%>
<%@ page import="java.io.File"%>
<%@ page import ="net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>


<%
	session.setAttribute("egPageDesc","EgUploadMIB.jsp");
%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();

	File deleteFileObj = null;
	String dirPath = EgInstallInfo.getInstallDir()+"/.snmp";
	String deleteMIBFile = request.getParameter("deleteMIBFile");
	String deletedMIBFileNames[] = request.getParameterValues("MIBfiles");
	String strDelMIBFileNames = request.getParameter("StrMIBfiles");
	
	rootJson.put("dirPath",dirPath);
	rootJson.put("deletMIBFile",deleteMIBFile);
	//out.println(deleteMIBFile);
	if(deleteMIBFile != null && deleteMIBFile.equals("true"))
	{
		if(deletedMIBFileNames == null || deletedMIBFileNames.length == 0)
		{
			if (!StringUtils.isNull(strDelMIBFileNames) && strDelMIBFileNames.length() > 0)
			{
				String[] tempDeleteMibArr = StringUtils.getTokens(strDelMIBFileNames,",");
				deletedMIBFileNames = new String[tempDeleteMibArr.length];
				for (int i=0;i<tempDeleteMibArr.length;i++)
				{
					String tmpVal = tempDeleteMibArr[i];
					deletedMIBFileNames[i] = tmpVal;
				}
			}
		}

		if(deletedMIBFileNames!=null && deletedMIBFileNames.length > 0)
		{
			//out.println(Arrays.asList(deletedMIBFileNames));
			for(int j=0;j<deletedMIBFileNames.length;j++)
			{
				String del_file = deletedMIBFileNames[j].trim();
				deleteFileObj = new File(dirPath+"/"+del_file);
				if(deleteFileObj != null && deleteFileObj.exists())
					deleteFileObj.delete();
				if(EgInstallInfo.isClusterSupported)
				{
					UploadMIBFile uploadMib = new UploadMIBFile();
					uploadMib.deleteMIBFile(del_file);
				}
			}
		}
	}
	EgMibUtil.reload();

	ArrayList fileNameList = new ArrayList();	
	File uploadMIBDir = new File(dirPath);
	if(uploadMIBDir.exists())
	{
		File uploadMIBFiles[] = uploadMIBDir.listFiles();
		if(uploadMIBFiles != null)
		{
			for(int i=0;i<uploadMIBFiles.length;i++)
			{
				File temp = (File)uploadMIBFiles[i];
				if(!temp.isDirectory())
				{
					String fileName = temp.getName();
					fileNameList.add(fileName);
				}
			}
		}
	}
	if(fileNameList.size() > 0)
	{
		screenLabels.put("mulitselt_title",_mapping.getTextDescription("admin.user.Select the MIB files to be deleted"));

		Collections.sort(fileNameList,String.CASE_INSENSITIVE_ORDER);

		JSONArray mibUploadDataArr = new JSONArray();
		JSONArray mibUploadDataGridArr = new JSONArray();
		for(int k=0;k<fileNameList.size();k++)
		{
			JSONObject mibUploadDataObj = new JSONObject();
			JSONObject mibUploadDataGridObj = new JSONObject();
			String fileName = (String)fileNameList.get(k);
			mibUploadDataObj.put("displayField",fileName);
			mibUploadDataObj.put("valueField",fileName);
			mibUploadDataGridObj.put("Mibname",fileName);

			mibUploadDataArr.add(mibUploadDataObj);
			mibUploadDataGridArr.add(mibUploadDataGridObj);
		}
		rootJson.put("mibUploadDataArr",mibUploadDataArr);
		rootJson.put("mibUploadDataGridArr",mibUploadDataGridArr);

		rootJson.put("isDeleteButton",true);
		rootJson.put("isSearchBcx",true);
		rootJson.put("isNoMibFiles",false);

	}
	else
	{
		rootJson.put("isDeleteButton",false);
		rootJson.put("isSearchBox",false);
		rootJson.put("isNoMibFiles",true);

	}

	rootJson.put("hiddenObj",hiddenObj);
	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
	if(request.getQueryString()!=null)
		session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgSnmpUploadMIB.jsp");
%>



