<%
/**
 *	Process page for EgAdminTopology.jsp
 *
 *	@author		KrishnaKumar.C
 *	@created	16/08/2000
 *
 *	@modified	05/06/2001	Bala		Save IniFile
 *			03/12/2001	Sandhya		Update in PHYSICAL_TOPOLOGY section and in segment section.
 *			25/01/2002	Sandhya		Update WEB_SITE_MAPPING and WEB_SITE_SEGMENTS sections when 
 *							a component is removed from segment(s).
 *			19/03/2002	Sandhya		Added a new method returnSites(Vector) in ConfigTopology bean
 *			07/05/2002	Sandhya		Made changes to sortTopology() method to prevent cyclic/null topology	
 *			14/12/2002	KK/Srihari	Bug Fix
 *			18/04/2003	Arun		Fixed bug where non-site servers could not be deleted
 *			21/10/2003	Arun		Added UserRegistry code (from Egaddsegmentp.jsp) to prevent 
 *			10/06/2004	Anitha N    Manager Clustering changes
 *			28/06/2004	Arun		Code to save segments moved here from Egaddsegmentp.jsp
 *			19/03/2009  Alagu/Gokul Bug fix for Once a component is disassociated from physical topology of a site or service,
 *									any segment which starts with the component should allow to remove its associations
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%//@ page errorPage = "EgProbs.jsp"%>
<%@ page import = "com.eg.EgDbAdapterTypeUI"%>
<%@ page import = "com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgTopoInfo"%>
<%@ page import = "com.eg.EgGroupInfoAdmin" %>
<%@ page import = "com.eg.IniFile" %>
<%@ page import = "com.eg.EgURLEncoder" %>
<%@ page import = "com.eg.EgStateZone" %>
<%@ page import = "com.eg.EgConfigFilesSync" %>
<%@ page import = "com.egurkha.*"%>
<%@ page import = "egurkha.EgDbAdapterUI"%>
<%@ page import = "egurkha.GroupInfoBeanAdmin" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.sql.*" %>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "com.eg.DeleteMailFilterElements"%>
<%@ page import ="com.egurkha.monitor.EgComponentUserMappingBean"%>
<%@ page import = "com.eg.EgAggregateInfo"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"  autoFlush="true"%>
<jsp:useBean id="topo" class="egurkha.ConfigTopologyAdmin" scope="page" />
<jsp:useBean id="sitebean" class="egurkha.ConfigSiteBeanAdmin" scope="page" />
<jsp:useBean id="ecumb" scope="page" class="com.egurkha.monitor.EgComponentUserMappingBean" />
<%!
	boolean flag_bstate;
	boolean flag_dbinsert;
	boolean	flag_dbdelete;
%>

<%
	boolean isdeleteCom_flag=false;
	JSONObject rootJson = new JSONObject();
	rootJson.put("isError","false");
	JSONObject screenLabels = new JSONObject();
	String  s_tmp = "";
	String  str_conn="";
	String	str_temp="";
	String	str_str="";
	String  arr_var[];
	String	sql_query="";
	ResultSet rs=null;
	String subject = "PHYSICAL_TOPOLOGY";

	EgDbAdapterUI egDb;
	EgInstallInfo installInfo = new EgInstallInfo();
	EgGroupInfoAdmin groupinfo = new EgGroupInfoAdmin();
	EgTopoInfo topoInfo = groupinfo.getTopoInfoWriteObject();//new EgTopoInfo("manager", true);
	//topoInfo.setWriteEnable(true); //write objection enable
//	GroupInfoBeanAdmin groupInfobean=topoInfo.getGroupInfoBeanObject();
	GroupInfoBeanAdmin groupInfobean= new GroupInfoBeanAdmin(topoInfo);
	//GroupInfoBean.setTopoInfo(topoInfo);
	List removeServers = new LinkedList();
	Vector v=new Vector();
	Vector v_ass_comp=new Vector();
	Vector v_var = new Vector();
	Vector v_varforval = new Vector();
	//v_rest contains servers after doing UNMANAGE 
	Vector v_rest = new Vector();
	Vector v_tmp_log = new Vector();
	Vector v_servers = new Vector();
	ArrayList a_seg_serv = new ArrayList();

	String temp = null;
	String comp_type = "";
	String comp_name = "";
	String removeserver = "";

	Hashtable serviceHash = new Hashtable();
	Hashtable siteServerHash = new Hashtable();
	Hashtable serverAssocSiteHash = new Hashtable();
	Hashtable virtualIni = new Hashtable();

	boolean zone = false;
	String str_fmanage=request.getParameter("fmanage");

	String newsegment = request.getParameter("newsegment");
	String str_fumanage = request.getParameter("fumanage");
	String str_comp_type=request.getParameter("comptype");
	String str_comp_name=request.getParameter("compname");
	if(str_comp_name!=null && str_comp_name.startsWith(","))
		str_comp_name = str_comp_name.substring(str_comp_name.indexOf(",")+1);
	String segment = request.getParameter("segment");
	String zonename = request.getParameter("zone");
	String updateZone = request.getParameter("updateZone");
	String showIndOnlyParam = request.getParameter("showIndOnlyParam");
	String prevasscomp=request.getParameter("prevassocomp");
	String allCompBoxVal = request.getParameter("AllCompBoxVal");
	String zoom = request.getParameter("zoomValue");

	String removedComponents = request.getParameter("tobeDeletedHdn");
	String imageName = request.getParameter("imageName");

	String thisSegmentName = segment;	//added for zone update
	String compWithType = str_comp_type+":"+str_comp_name; // for auditlog

	//mail filter -start
	ArrayList removedElementsList = null;
	if(removedComponents != null && removedComponents.length() > 0)
	{
		removedElementsList = new ArrayList();
		StringTokenizer strTokens = new StringTokenizer(removedComponents,",");
		while(strTokens.hasMoreTokens())
		{
			String element = strTokens.nextToken().trim();
			if(element.length() == 0)
				continue;
			element = element.substring(0,element.lastIndexOf(":"));
			if(element.startsWith("Group:"))
			{
				element = element.substring(element.indexOf(":")+1,element.lastIndexOf(":"));
				List l = groupinfo.getAllComponentsUnderGroup(element);
				if(l != null)
					removedElementsList.addAll(l);
				continue;
			}
			removedElementsList.add(element);
		}
	}
	//end


	/* code for auditlog starts */
	boolean isNewSegment = true;
	String currentSegment = segment;
	String existingAssociatedComponents = request.getParameter("existingAssociatedComponents");
	AuditLogThread auditLogThread = new AuditLogThread();	
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Segments");
	/* code for auditlog ends */

	if ((zonename!=null) && !((zonename.equals("-1")) || (zonename.equalsIgnoreCase("null"))))
		zone=true;

	//added for updating the zone when a component is disassociated
	String groupFileName = "eg_group.ini";
	IniFile ini_grp = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/" + groupFileName);
//	if (updateZone!=null && updateZone.equals("true"))
//	{
//		if (zone)
//		{
//			ArrayList uComps = new ArrayList();
//			StringTokenizer st = new StringTokenizer(str_fumanage, ",");
//			while (st.hasMoreTokens())
//			{
//				String thisToken = st.nextToken();
//				String this_comp_type = thisToken.substring(thisToken.lastIndexOf(":")+1);
//				String this_comp_name = thisToken.substring(0, thisToken.lastIndexOf(":"));
//				/*
//				if (this_comp_type.equals("Group"))
//				{
//					String thisGroup="";
//					try{
//					thisGroup = this_comp_name.substring(0, this_comp_name.indexOf(":"));
//					}catch(StringIndexOutOfBoundsException sio)
//					{
//						thisGroup = this_comp_name;
//					}
//					uComps.addAll(groupinfo.getAllComponentsUnderGroup(thisGroup));
//				}else
//				{
//					*/
//					uComps.add(this_comp_type+":"+this_comp_name);
//				//}
//			}
//			for (int i=0; i<uComps.size(); i++)
//			{
//				String myCmp = (String)uComps.get(i);
//				List al_segcomp=new ArrayList();
//				String[] segcomp=topoInfo.getSegmentsForComponent(myCmp);
//				boolean segexists=false;
//				for (int j=0;j<segcomp.length;j++)
//				{
//					if (!segcomp[j].equals(thisSegmentName))
//					{
//						String segzone=groupinfo.getZoneNameForSegment(segcomp[j]);
//						if (segzone!=null && !segzone.equals(""))
//						{
//							segexists=true;
//							break;
//						}else
//						{
//							segexists=false;
//							//break;
//						}
//
//					}
//					
//				}
//				if (segexists)
//					continue;
//
//				ini_grp.setValue("ZONE_DETAILS", myCmp+"#"+zonename, zonename);
//				if (myCmp.startsWith("Group:"))
//				{
//					String thisGrp = myCmp.substring(myCmp.indexOf(":")+1, myCmp.lastIndexOf(":"));
//					ArrayList grpCmp = groupinfo.getAllComponentsUnderGroup(thisGrp);
//					Iterator grpCmpItr = grpCmp.iterator();
//					while (grpCmpItr.hasNext())
//					{
//						ini_grp.deleteValue("ZONE_DETAILS", grpCmpItr.next()+"#"+zonename);
//					}
//				}
//			}
//			if (str_fmanage.equals("") || (str_fmanage.length()<1))
//			{
//				/*
//				//if all components are removed then add the started component in zone
//				groupinfo = new EgGroupInfoAdmin();
//				if(str_comp_type.equals("Group"))
//				{
//					//generic:NULL
//					ArrayList groupcmps = groupinfo.getAllComponentsUnderGroup(str_comp_name.substring(0, str_comp_name.indexOf(":")));
//					for (int gp=0; gp<groupcmps.size(); gp++)
//					{
//						groupinfo = new EgGroupInfoAdmin();
//						groupinfo.setValue("ZONE_DETAILS", (String)groupcmps.get(gp), zonename);
//						groupinfo.saveFile();
//					}
//				}else
//				{
//					groupinfo.setValue("ZONE_DETAILS", str_comp_type+":"+str_comp_name, zonename);
//					groupinfo.saveFile();
//				}
//				*/
//				/*
//				if(str_comp_type.equals("Group"))
//				{
//					//generic:NULL
//					ArrayList groupcmps = groupinfo.getAllComponentsUnderGroup(str_comp_name.substring(0, str_comp_name.indexOf(":")));
//					for (int gp=0; gp<groupcmps.size(); gp++)
//					{
//						//groupinfo = new EgGroupInfoAdmin();
//						ini_grp.setValue("ZONE_DETAILS", (String)groupcmps.get(gp)+"#"+zonename, zonename);
//						//groupinfo.saveFile();
//					}
//				}else
//				{
//					*/
//					ini_grp.setValue("ZONE_DETAILS", str_comp_type+":"+str_comp_name+"#"+zonename, zonename);
//					if (str_comp_type.startsWith("Group"))
//					{
//						ArrayList grpCmp = groupinfo.getAllComponentsUnderGroup(str_comp_name);
//						Iterator grpCmpItr = grpCmp.iterator();
//						while (grpCmpItr.hasNext())
//						{
//							ini_grp.deleteValue("ZONE_DETAILS", grpCmpItr.next()+"#"+zonename);
//						}
//					}
//			}
//		}
//	}

	if(segment != null && (!segment.equals("null")))
		subject = segment;
	else
	{
		EgConfigFilesSync.releaseInstance(ini_grp);
		return;
	}

	//audit log new design
	IniFile topoInfoWr = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
	String prevAssociatedComps = topoInfoWr.getValue(currentSegment,compWithType);
	StringTokenizer prev_tokens = new StringTokenizer(prevAssociatedComps,",");
	ArrayList prevConnectedComps = new ArrayList();
	ArrayList prevUsedComps = new ArrayList();
	while(prev_tokens.hasMoreTokens())
	{
		String comp = prev_tokens.nextToken();
		if(comp != null && comp.endsWith("L"))
		{
			if(comp.lastIndexOf(":L") > -1)
			{
				comp = comp.substring(0,comp.lastIndexOf(":L"));
			}
			prevUsedComps.add(comp);
		}
		else if(comp != null && comp.endsWith("N"))
		{
			if(comp.lastIndexOf(":N") > -1)
			{
				comp = comp.substring(0,comp.lastIndexOf(":N"));
			}
			prevConnectedComps.add(comp);
		}
	}
	//end


	// entering segment name in INI
	if(request.getParameter("update").equalsIgnoreCase("true"))
	{
		//String str_iniFileName = "eg_topology.ini";
		//removal of physical topology
		//IniFile ini_top = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/" + str_iniFileName, true);
		topoInfoWr.setValue("TOPOLOGY_SEGMENTS",subject,subject);
		topoInfoWr.saveFile();
		//topoInfo.setValue("TOPOLOGY_SEGMENTS",subject,subject);
		//ini_top.setValue(subject,"#Format:Component_name","Associated Components");
		//topoInfo.saveFile();
		topoInfo = groupinfo.getTopoInfoWriteObject();//new EgTopoInfo("manager", true);
		//ini_top.saveFile();
	}
	StringTokenizer st = new StringTokenizer(str_fmanage,",");
	String str_associated_comp = "";
	while(st.hasMoreTokens())
	{
		temp = st.nextToken().trim();
		comp_type = temp.substring(temp.lastIndexOf(":")+1);
		comp_name = temp.substring(0,temp.lastIndexOf(":"));
		String addent = comp_type + ":" + comp_name;
		v_ass_comp.add(addent);
		str_associated_comp = str_associated_comp + addent+ ",";
		//to populate v_rest without direction
		temp = temp.substring(0,temp.lastIndexOf(":"));
		comp_name = temp.substring(0,temp.lastIndexOf(":"));
		/* COMMENTED DUE TO 3.4 BUG FIX
		if (!(v_rest.contains(addent)))//if (!(v_rest.contains(addent)))	//logical topology populated with direction -pandian
			v_rest.add(addent);
		*/
		if (!(v_rest.contains(comp_type+":"+comp_name)))//if (!(v_rest.contains(addent)))	//logical topology populated with direction -pandian
			v_rest.add(comp_type+":"+comp_name);
	}
	/* MODIFICATION FOR VIRTUAL INI STARTS */
	//VIRTUAL INI : since i have to populate servers before entering into ini, i created vir.ini so that it will reflect as if these values were from ini file.
	/*
	String [] virVars = topoInfo.getVariables(subject);
	virtualIni.put("#SEGMENT_NAME", subject);
	if (virVars!=null)
	{
		int virCount = virVars.length;
		for (int i=0; i<virCount; i++)
		{
			String thisVar = virVars[i];
			virtualIni.put(thisVar, topoInfo.getValue(subject, thisVar));
		}
	}
	virtualIni.put(str_comp_type + ":" + str_comp_name,str_associated_comp);
	*/
	virtualIni = groupinfo.getVirtualIni(subject, str_comp_type + ":" + str_comp_name, str_associated_comp);
	/* MODIFICATION FOR VIRTUAL INI END */
//	v_ass_comp = groupinfo.getGroupedTopoINIVector(v_ass_comp, subject, virtualIni);

//	v_rest = groupinfo.getGroupedVector(v_rest, virtualIni);

	Vector  v_new_servers =  new Vector(v_rest); // used to hold the newly associated components. intially holds all the associated components.

	str_associated_comp = str_associated_comp.substring(0,str_fmanage.length());
//	str_associated_comp = groupinfo.getGroupedTopoINIString(str_associated_comp, subject, virtualIni);

	if(str_associated_comp.length()==0)
		str_associated_comp = "null";

	//From EgAdminTopology.jsp
	Vector v_ass_servers = (Vector)session.getValue("ass_servers");
	for(int i=0; i<v_ass_servers.size(); i++)
	{
		//temp = 192.168.10.100:80:L:Web_server
		temp = (String)v_ass_servers.get(i);
		comp_type = temp.substring(temp.lastIndexOf(":")+1);
		temp = temp.substring(0,temp.lastIndexOf(":"));
		comp_name = temp.substring(0,temp.lastIndexOf(":"));
		//This vector is passed as a parameter to returnSites() method 
		v_ass_servers.set(i,comp_type + ":" + comp_name);
	}
	for(int i=0; i<v_ass_servers.size(); i++)
	{
		String serverName = (String)v_ass_servers.get(i);
		if(!v_rest.contains(serverName))
		{
			removeServers.add(serverName);
		}
	}
	boolean remove = (removeServers.size() > 0);

	v_new_servers.removeAll(v_ass_servers); //remove all the previously assosiated components so that to get new Components
	String s_new_servers = ""; // holds comma seperated new components, ready to be append with the LOGICAL TOPOLOGY section of eg_topology.ini.

	for(int i=0;i<v_new_servers.size();i++)
	{
		String thisLogNewSrv = (String)v_new_servers.get(i);
		s_new_servers += thisLogNewSrv.substring(0, thisLogNewSrv.lastIndexOf(":")) + ":D,";
	}

	if(s_new_servers.length()>0) s_new_servers = s_new_servers.substring(0,s_new_servers.length()-1);

	/* 
	 * When a site is associated to only one segment and if the servers in that segment are removed, 
	 * call errors page 
	 */
	String var1[];
	String strVal = null;
	String s_log_serv = "";
	String site,serv = "";
	boolean performaction = true;
	boolean deletesite = true;
	Vector v_sites = new Vector();
	Vector v_site_serv = new Vector();
	Vector v_site_seg = new Vector();
	Vector v_log_serv = new Vector();
	Vector v_seg_serv = new Vector();
	Vector addingvec =new Vector();
	boolean isTopoToSave = false;
	String[] var = topoInfoWr.getVariables("WEB_SITE_SEGMENTS");

	boolean affectService = !topoInfoWr.getValue("MISC","Update_Service").trim().equalsIgnoreCase("no");

	if(var.length == 0)
	{
		performaction = false;
	}

	String val = str_comp_type + ":" + str_comp_name;
	boolean isAService = false;
	for(int i=0; i<var.length; i++)
	{
		strVal = topoInfoWr.getValue("WEB_SITE_SEGMENTS",var[i]);
		Vector vect = new Vector();
		StringTokenizer stoken = new StringTokenizer(strVal,",");
		while(stoken.hasMoreTokens())
			vect.add(stoken.nextToken());
		// hari comment if(strVal.indexOf(",") == -1) //Not necessary
		// hari comment	if(strVal.equals(segment) && remove)
		boolean isSegInSer = vect.contains(segment);
		if(!affectService && isSegInSer && s_new_servers.length()>0)
		{
			String s_log_entry = topoInfoWr.getValue("LOGICAL_TOPOLOGY",var[i]).trim();
			if(s_log_entry.length() > 0) s_log_entry += ",";
			s_log_entry += s_new_servers;
			topoInfo.setValue("LOGICAL_TOPOLOGY",var[i],s_log_entry,topoInfoWr);
			isTopoToSave = true;
		}
		if (isTopoToSave)
		{
			topoInfoWr.saveFile();
			isTopoToSave= false;
		}
		if(remove && isSegInSer)
		{
			site = var[i];
			site = site.substring(site.indexOf(":")+1);
			Boolean bb = (Boolean) serviceHash.get(site);
			if (bb == null)
			{
				isAService = sitebean.isAService(site);
				serviceHash.put(site,new Boolean(isAService));
			} else {
				isAService = bb.booleanValue();
			}

			//Populate servers associated to site
			v_site_serv.removeAllElements();
			v_site_serv = sitebean.getServAssociatedToSite(site);

				//Populate LOGICAL_TOPOLOGY servers
				//v_tmp_log is populated to determine sites
				//associated to servers
				s_log_serv = topoInfoWr.getValue("LOGICAL_TOPOLOGY",var[i]);
				v_log_serv.removeAllElements();
				if(!s_log_serv.equals(""))
				{
					s_tmp = "";
					if(s_log_serv.indexOf(",") > -1)
					{
						st = new StringTokenizer(s_log_serv,",");
						while(st.hasMoreTokens())
						{
							temp = st.nextToken().trim();
							temp = temp.substring(0,temp.lastIndexOf(":"));
							v_log_serv.add(temp);
							if(!v_tmp_log.contains(temp))
							{
								v_tmp_log.add(temp);
								v_tmp_log.add(var[i]);
							}
							else
							{
								int idx = v_tmp_log.indexOf(temp);
								s_tmp = (String)v_tmp_log.get(idx + 1);
								s_tmp = s_tmp + "," + var[i];
								v_tmp_log.set(idx + 1,s_tmp);
							}
						}//end of while
					}
					else
					{
						s_log_serv = s_log_serv.substring(0,s_log_serv.lastIndexOf(":"));
						v_log_serv.add(s_log_serv);
						if(!v_tmp_log.contains(s_log_serv))
						{
							v_tmp_log.add(s_log_serv);
							v_tmp_log.add(var[i]);
						}
						else
						{
							s_tmp = (String)v_tmp_log.get(v_tmp_log.size() - 1);
							s_tmp = s_tmp + "," + var[i];
							v_tmp_log.set(v_tmp_log.size() - 1,s_tmp);
						}
					}
				}

				//Populate associated servers of 'val'
				//To find if val has one or more associated
				//servers
				strVal = topoInfoWr.getValue(segment,val);
				v_seg_serv.removeAllElements();
				if(strVal.indexOf(",") > -1)
				{
					st = new StringTokenizer(strVal,",");
					while(st.hasMoreTokens())
					{
						temp = st.nextToken();
						temp = temp.substring(0,temp.lastIndexOf(":"));
						v_seg_serv.add(temp);
					}
				}
				else
				{
					strVal = strVal.substring(0,strVal.lastIndexOf(":"));
				}

				for(int j=0; j<v_site_serv.size(); j++)
				{
					temp = (String)v_site_serv.get(j);
					if(val.equals(temp))
					{
						//All the servers are unmanaged
						if(v_rest.size() == 0 && v_seg_serv.size() == 0)
						{
							String strVal1 = topoInfoWr.getValue(segment,strVal);
							v_servers.removeAllElements();
							if(!isAService)
							{
								v_servers = (Vector) siteServerHash.get(segment);
								if (v_servers == null)
								{
									v_servers = sitebean.getSiteServers(segment);
									siteServerHash.put(segment,v_servers);
								}
							}
							else
							{
								a_seg_serv.clear();
								a_seg_serv = sitebean.getServersForSegment(segment,2);
								for(int s=0; s<a_seg_serv.size(); s++)
									v_servers.add(a_seg_serv.get(s));
							}

							/*
							 * If there is only one Site_server(if it is a site) in a segment or only two servers
							 * (if it is a service) in a segment, then the server should not be removed
							 */
							if(strVal1 == null || strVal1.equals("") || (strVal1.equals("null"))) 
							{
								if(v_servers.size() <= 2) 
								{
									if(sitebean.findServerInASegment(segment,val))
									{
										deletesite = true;
										break;
									}
									else
									{
										deletesite = false;
										break;
									}
								}
								else if(isAService)
								{
									if(v_servers.size() == 2) {
										deletesite = false;
									}
								}
							}
						} //End of if
						else
						{
							for(int p=0; p<v_ass_servers.size(); p++)
							{
								if(!v_rest.contains((String)v_ass_servers.get(p)))
								{
									removeserver = (String)v_ass_servers.get(p);
									if(v_log_serv.contains(removeserver) && v_seg_serv.contains(removeserver))
									{
										//If it comes here, then the server to
										//be removed is part of a segment and
										//part of LOGICAL_TOPOLOGY.Check if
										//there is any server before val. If 
										//yes, remove. If no, dont remove.
										if(sitebean.findServerInASegment(segment,val))
										{
											deletesite = true;
										}
										else
										{
											if(v_rest.size() == 0)
											{
												deletesite = false;
												break;	
											}
										}
									}
									/*
									else
									{
										-- Srinivas Removed this
										deletesite = false;
										break;
									}*/
								}
							} //End of for
						}
					}
					else
					{
	///*
						// Don't know whats being done here
						//if a server, for which a service/site is associated, shouldn't be deleted. --pandian
						if(isAService)
						{
							if(!deletesite)
							{
								//if(strVal.indexOf(temp) > -1) // commented by ahamed
								//if(removedComponents != null && removedComponents.indexOf(temp) > -1) // Refer 19/03/2009  Alagu/Gokul
								if(removedComponents != null && removedComponents.indexOf(temp) > -1 && !v_tmp_log.contains(val))
									deletesite = false;
							}
						}
						else
						{
							//if(strVal.indexOf(temp) > -1) // commented by ahamed
							//if(removedComponents != null && removedComponents.indexOf(temp) > -1) // Refer 19/03/2009  Alagu/Gokul
							if(removedComponents != null && removedComponents.indexOf(temp) > -1 && !v_tmp_log.contains(val))
								deletesite = false;
						}
	//*/
					}
				} //end of for
				// Srinivas added this if
				if (deletesite)
				{
					for (int a=0; a<removeServers.size(); a++)
					{
						String serverName = (String)removeServers.get(a);
						ArrayList dependencies = topoInfo.getImmediateLeftDependenciesForComponent(serverName, segment, topoInfoWr);
						if (v_site_serv.contains(serverName))
						{ // server being removed is a site server
							boolean enoughDependencies = ((dependencies != null) && (dependencies.size()> 1)); 
							//if (v_site_serv.contains(serverName) && !enoughDependencies)
							if (!enoughDependencies)
							{
								String [] rightDep = topoInfo.getImmediateRightDependenciesForComponent(serverName, segment, topoInfoWr);
								if (rightDep==null || rightDep.length<1)
								{
									deletesite = false;
									break;
								}
							}
						} else {
							// server being removed is someone else
							if (dependencies != null)
							{
								for (int j=0; j<dependencies.size(); j++)
								{
									String depStr = (String)dependencies.get(j);
									if (v_site_serv.contains(depStr))
									{
										ArrayList dd = topoInfo.getImmediateLeftDependenciesForComponent(depStr, segment, topoInfoWr);
										
										if (dd == null || dd.size() == 0)
										{
											String [] rightDep = topoInfo.getImmediateRightDependenciesForComponent(depStr, segment, topoInfoWr);
											if (rightDep==null || rightDep.length<1)
											{
												deletesite = false;
												break;
											}
											else if (rightDep!=null &&  (rightDep.length == removeServers.size()))
											{
												deletesite = false;
												break;
											}
										}
									}
								}
								if (!deletesite)
									break;
							}
						}
					}
				}
/*
				if (deletesite && v_site_serv.contains(val))
				{
					String[] dependencies = topoInfo.getDependenciesForComponent(val, segment);
					boolean enoughDependencies = ((dependencies != null) && (dependencies.length > removeServers.size()));
					if (!enoughDependencies)
					{
						deletesite = false;
					}
				}
*/
			}
		} //end of outer for
		Vector v_tmp_sites = new Vector();
		if(isTopoToSave) 
		{
			topoInfoWr.saveFile();
			/* Srinivas Pandi */
			serviceHash = new Hashtable();
			siteServerHash = new Hashtable();
			serverAssocSiteHash = new Hashtable();
			/* Srinivas Pandi */
			isTopoToSave = false; 
		}
		isTopoToSave = false; 
		if(!deletesite)
		{
			if(v_tmp_log.size() > 0)
			{
				//removal of physical topology
				v_sites = topo.returnSites(v_ass_servers,false);
				for(int k=0; k<v_ass_servers.size(); k++)
				{
					if(!v_rest.contains((String)v_ass_servers.get(k)))
					{
						removeserver = (String)v_ass_servers.get(k);
						if(v_tmp_log.contains(removeserver))
						{
							int idx = v_tmp_log.indexOf(removeserver);
							site = (String)v_tmp_log.get(idx + 1);
							if(site.indexOf(",") > -1)
							{
								st = new StringTokenizer(site,",");
								while(st.hasMoreTokens())
								{
									s_tmp = st.nextToken();
									s_tmp = s_tmp.substring(s_tmp.indexOf(":")+1);
									if(!v_tmp_sites.contains(s_tmp))
										v_tmp_sites.add(s_tmp);
								}
							}
							else
							{
								site = site.substring(site.indexOf(":")+1);
								if(!v_tmp_sites.contains(site))
									v_tmp_sites.add(site);
							}
							for(int b=0; b<v_tmp_sites.size(); b++)
							{
								if(v_sites.contains((String)v_tmp_sites.get(b)))
								{
									int d = v_sites.indexOf((String)v_tmp_sites.get(b));
									if(d != -1)
									{
										v_sites.removeElementAt(d);
									}
								}
							}
						}
						else
						{
							topoInfoWr.saveFile();
							//topo.createFile(topoInfo.getFilePointer());
							topo.createFile(topoInfoWr);
							v_sites = topo.returnSites(v_ass_servers,false);
						}
					}
				}
			}
			else
			{
				//return only sites if flag is 'false'
				//removal of physical topology
				topoInfoWr.saveFile();
				//topoInfo = new EgTopoInfo("manager", true);
				//topo.createFile(topoInfo.getFilePointer());
				topo.createFile(topoInfoWr);
				v_sites = topo.returnSites(v_ass_servers,false);
			}
		}
		else
		{
			//topo.createFile(topoInfo.getFilePointer());
			topo.createFile(topoInfoWr);
			isTopoToSave = true;
			//to remove servers from LOGICAL_TOPOLOGY section
			v_log_serv.removeAllElements();
			var = topoInfoWr.getVariables("LOGICAL_TOPOLOGY");
			for(int s=0; s<var.length; s++)
			{
				s_tmp = "";
				v_log_serv.removeAllElements();
				strVal = topoInfoWr.getValue("LOGICAL_TOPOLOGY",var[s]);
				if(strVal.indexOf(",") > -1)
				{
					st = new StringTokenizer(strVal,",");
					while(st.hasMoreTokens())
					{
						s_tmp = st.nextToken();
						if(s_tmp.indexOf(":") > -1)
						{
							s_tmp = s_tmp.substring(0,s_tmp.lastIndexOf(":"));
							if(!v_log_serv.contains(s_tmp))
								v_log_serv.add(s_tmp);
						}
					}
				}
				else
				{
					s_tmp = strVal;
					if(s_tmp.indexOf(":") > -1)
					{
						s_tmp = s_tmp.substring(0,s_tmp.lastIndexOf(":"));
						if(!v_log_serv.contains(s_tmp))
							v_log_serv.add(s_tmp);
					}
				}
				if(v_log_serv.size() > 0)		
				{
					for(int p=0; p<v_ass_servers.size(); p++)
					{
						if(!v_rest.contains((String)v_ass_servers.get(p)))
						{
							removeserver = (String)v_ass_servers.get(p);
							if(v_log_serv.contains(removeserver))
							{
								int idx = v_log_serv.indexOf(removeserver);
								if(idx > -1)
								{
									v_log_serv.removeElementAt(idx);
								}
							}
						}
					}
				}
				if(v_log_serv.size() == 0)
				{
					topoInfoWr.deleteValue("LOGICAL_TOPOLOGY",var[s]);
					isTopoToSave = true;
				}
				else
				{
					String s_site_loglist = "";
					for(int n=0; n<v_log_serv.size(); n++)
						s_site_loglist += (String)v_log_serv.get(n) + ":D" + ",";
					s_site_loglist = s_site_loglist.substring(0,s_site_loglist.lastIndexOf(","));
					topoInfoWr.setValue("LOGICAL_TOPOLOGY",var[s],s_site_loglist);
					isTopoToSave = true;
				}
			}
		}
		Vector sess_vec = new Vector();
		StringBuffer servicesBuff=new StringBuffer();
		//if (!true) return; //??
		if(!deletesite)
		{
			sess_vec.addElement(_mapping.getTextDescription("admin.topology.Configure segments"));
			sess_vec.addElement("EgAdminTopology.jsp?comptype=" + str_comp_type + "&compname=" + EgURLEncoder.encode(str_comp_name,"UTF-8")+ "&qctr=1&segment=" + EgURLEncoder.encode(subject,"UTF-8")+"&zone="+EgURLEncoder.encode(zonename,"UTF-8")+"&showIndOnlyParam="+showIndOnlyParam);
			sess_vec.addElement(_mapping.getTextDescription("admin.topology.Component(s) cannot be removed")+".");
			if(v_sites.size() > 0)
			{
				sess_vec.addElement(_mapping.getTextDescription("admin.topology.Modifying segment")+" '"+ subject +"' "+ _mapping.getTextDescription("admin.topology.will directly/indirectly affect the following service(s):"));
				int c = v_sites.size();
				for(int k=0; k<c; k++)
				{
					if (k+1< c)
					{
						sess_vec.add((String)v_sites.get(k)+",");
						servicesBuff.append((String)v_sites.get(k));
						servicesBuff.append(",");
					}
					else
					{
						sess_vec.add((String)v_sites.get(k)+". ");
						servicesBuff.append((String)v_sites.get(k));
					}
					/* code for auditlog starts */
					auditLogThread.setCurrentValue("Service(s)",v_sites.get(k).toString());
					/* code for auditlog ends */
				}
				sess_vec.addElement(_mapping.getTextDescription("admin.topology.Before performing this operation, reconfigure the service(s) above")+".");
				String serviceBuffStr = servicesBuff.toString();
				screenLabels.put("admin.error.Error",_mapping.getTextDescription("admin.topology.Modifying segment")+" '"+ subject +"' "+ _mapping.getTextDescription("admin.topology.will directly/indirectly affect the following service(s): "+serviceBuffStr));
				/* code for auditlog starts */
				auditLogThread.setValue("Activity","Modify Segment");		
				auditLogThread.setValue("Description",segment +" "+ "segment can not be modified as this will directly/indirectly affect the following service(s): "+serviceBuffStr);
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			else
			{
				String services="";
				if(v_ass_servers!=null && v_ass_servers.size()>0)
				{
					topoInfo = groupinfo.getTopoInfoWriteObject();
					for(int i=0;i<v_ass_servers.size();i++)
					{
						String serverName =(String)v_ass_servers.get(i);
						ArrayList serviceList = topoInfo.getSitesForComponent(serverName);
						if(serviceList==null || serviceList.size()==0)
						{
							serviceList = topoInfo.getSitesForComponent(val);
						}
						String str = serviceList.toString();
						str=str.substring(1,str.length()-1);
						if (str != null && str.length() > 0 && servicesBuff.indexOf(str) < 0)
						{
							servicesBuff.append(str+", ");
						}
					}
					if(servicesBuff!=null && servicesBuff.length()>0)
					{
						services=servicesBuff.toString();
						services=services.substring(0,services.length()-2);
					}
				}
				sess_vec.addElement(_mapping.getTextDescription("admin.topology.The chosen component(s) for removal is part of one or more services") +".");
				sess_vec.addElement(_mapping.getTextDescription("admin.topology.Hence this operation is not allowed")+".");
				screenLabels.put("admin.error.Error",_mapping.getTextDescription("admin.topology.Modifying segment")+" '"+ subject +"' "+ _mapping.getTextDescription("admin.topology.will directly/indirectly affect the following service(s): "+services));
				/* code for auditlog starts */
				auditLogThread.setValue("Activity","Modify Segment");
				auditLogThread.setValue("Description",segment +" "+ "segment can not be modified as this will directly/indirectly affect the following service(s): "+services);
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
			}
			session.putValue("vec_Errors",sess_vec);
			if (isTopoToSave)
			{
				topoInfoWr.saveFile();
			}

			rootJson.put("isError","true");
			
		}
		else
		{
			boolean done = false;
			v_sites.removeAllElements();
			if(v_rest.size() == 0)
			{
				//return sites and servers if flag is 'true'
				topoInfoWr.saveFile(); //newly added to eliminate configTopology
				topo.createFile(topoInfoWr);
				v_sites = topo.returnSites(v_ass_servers,true);
			}
			
			//Do this before setting values 
			Vector v_tmp_serv = new Vector();
			var = topoInfo.getVariables(subject,topoInfoWr);
			for(int z=0; z<var.length; z++)
				v_tmp_serv.add(var[z]);
			
			if (!isTopoToSave) // if we already have this file opened to save - why open again? -- Srinivas
			{
				topo.createFile(topoInfoWr);
				isTopoToSave = true;
			}
			Hashtable relTable = groupInfobean.getTopoTable(subject,str_comp_type + ":" + str_comp_name, str_associated_comp, virtualIni);

//			ArrayList removals = (ArrayList) relTable.get("removals");
			Hashtable additions = (Hashtable) relTable.get("additions");

			// removing the minus hosts
//			int remSrvCnt = removals.size();
//			for (int i=0; i<remSrvCnt; i++)
//			{
//				String thisSrv = (String)removals.get(i);
//				topoInfoWr.deleteValue(subject, thisSrv);
//			}

			//addition of plus hosts
			Enumeration keyz = additions.keys();
			while (keyz.hasMoreElements())
			{
				String thisKey = (String)keyz.nextElement();
				String thisVal = (String)additions.get(thisKey);
			   	addingvec.add(thisVal);
				topoInfo.setValue(subject, thisKey, thisVal, topoInfoWr);
				isTopoToSave = true;
			}

			arr_var=topoInfo.getVariables(subject, topoInfoWr);
			for(int v_ctr=0;v_ctr<arr_var.length;v_ctr++)
			{
				if(arr_var[v_ctr].startsWith("#"))
				{
					continue;
				}
				v_var.addElement(arr_var[v_ctr]);
			}

			//associated components vector loop
			for(int a_ctr=0;a_ctr<v_ass_comp.size();a_ctr++)
			{
				str_temp="";
				str_temp =(String) v_ass_comp.elementAt(a_ctr);				
				str_temp = str_temp.substring(0,str_temp.lastIndexOf(":"));
				//variables (keys) in topology.ini loop
				for(int i=0;i < arr_var.length;i++)
				{
					if(arr_var[i].startsWith("#"))
					{
							continue;
					}
					temp = topoInfoWr.getValue(subject,arr_var[i]);
					//if the value has the associated element
					if(temp.indexOf(str_temp) > -1)
					{
						int start =temp.indexOf(str_temp)+str_temp.length();
						String comp = temp.substring(start,start+2);
						if(comp.equals(":L") || comp.equals(":N"))
						{
							v_varforval.addElement(arr_var[i]);
						}
					}
				}
				//adding "null" value
				//the component shouldnt part of topology variables.
				if(!v_var.contains(str_temp) && v_varforval.size() != 0)
				{
					topoInfoWr.setValue(subject,str_temp,"null");
					isTopoToSave = true;
				}
				v_varforval.removeAllElements();
			}

//	FOUND A PLACE FOR ZONE UPDATE :(
// IF THIS SEGMENT IS PART OF A ZONE, THEN ADD THIS SEGMENT INTO THE ZONE AND REMOVE 
// SEGMENT COMPONENTS FROM ZONES.
//			if (zone)
//			{
//				String [] segcomps = topoInfo.getVariables(subject,topoInfoWr);
//				ini_grp.setValue("ZONE_DETAILS", "Segment:"+thisSegmentName+":NULL"+"#"+zonename, zonename);
//				if (updateZone!=null && !updateZone.equals("true"))
//					for (int i=0; i<segcomps.length; i++)
//					{
//						String thisSegCmp = segcomps[i];
//						ini_grp.deleteValue("ZONE_DETAILS", segcomps[i]+"#"+zonename);
//						if (thisSegCmp.startsWith("Group:"))
//						{
//							String thisGrp = thisSegCmp.substring(thisSegCmp.indexOf(":")+1, thisSegCmp.lastIndexOf(":"));
//							ArrayList grpCmps = groupinfo.getAllComponentsUnderGroup(thisGrp);
//							Iterator grpCmpItr = grpCmps.iterator();
//							while (grpCmpItr.hasNext())
//							{
//								ini_grp.deleteValue("ZONE_DETAILS", (String)grpCmpItr.next()+"#"+zonename);
//							}
//						}
//					}
//				//ini_grp.saveFile();
//			}

			//Saving the IniFile
			String sub[] = new String[2]; 
			sub[0] = subject;
			sub[1] = "PHYSICAL_TOPOLOGY";
			topo.createFile(topoInfoWr); ////added for sorttopology which is done below.
			for(int i=0; i<sub.length; i++)
			{
				//removal of physical topology
				if(topo.sortTopology(sub[i]) && topo.checkCyclicGroupDependency(sub[i]))
				{
					isTopoToSave = true;
				}
				else
				{
					//Someone is creating a goofy topology or trying to delete the topology
					sess_vec.removeAllElements();
					sess_vec.addElement(_mapping.getTextDescription("admin.topology.Topology Configuration"));
					sess_vec.addElement("EgAdminTopology.jsp?comptype=" + str_comp_type + "&compname=" + str_comp_name +"&qctr=1&segment="+subject+"&zone="+zonename+"&showIndOnlyParam="+showIndOnlyParam);
					sess_vec.addElement(_mapping.getTextDescription("admin.topology.Topology Misconfiguration!"));
					sess_vec.addElement(_mapping.getTextDescription("admin.topology.The components/groups/components of the chosen groups are already related to this segment"));
					sess_vec.addElement(_mapping.getTextDescription("admin.topology.This might delete/re-arrange your topology!"));
					sess_vec.addElement(_mapping.getTextDescription("admin.topology.Your last changes have not been saved"));
					session.putValue("vec_Errors",sess_vec);
					/* code for auditlog starts */
					auditLogThread.setValue("Activity","Modify Segment");		
					auditLogThread.setCurrentValue("Component Type", "$ctype$:"+str_comp_type);
					auditLogThread.setCurrentValue("Component Name", str_comp_name);
					auditLogThread.setCurrentValue("Segment", segment);
					if(zonename != null && !zonename.equals("-1") && zonename.length() != 0)
					{
						auditLogThread.setCurrentValue("Zone", zonename);
					}
					auditLogThread.setValue("Description",segment + " "+ "segment has not been modified as current changes would result in a cyclic/null topology");
					auditLogThread.sendItToDB();
					/* code for auditlog ends */

					rootJson.put("isError","true");

					//Error Msg
					JSONArray  errorArray = new JSONArray();
					errorArray.add(_mapping.getTextDescription("admin.error.The component(s) you have chosen is/are already part of a group in this segment")+".");
					errorArray.add(_mapping.getTextDescription("admin.error.One/more components in the group(s) you have chosen is/are already part of another group in this segment")+".");

					screenLabels.put("admin.error.Error",errorArray);
					isdeleteCom_flag=true;
					//rootJson.put("screenLabels",screenLabels);
					//out.println(rootJson.toString());

					//return;
				}
//
//					sess_vec.addElement(_mapping.getTextDescription("admin.error.Configure segments"));
//					sess_vec.addElement("EgAdminTopology.jsp?comptype=" + str_comp_type + "&compname=" + EgURLEncoder.encode(str_comp_name,"UTF-8") + "&qctr=1&segment=" + EgURLEncoder.encode(subject,"UTF-8")+"&zone="+EgURLEncoder.encode(zonename,"UTF-8")+"&showIndOnlyParam="+showIndOnlyParam);
//					sess_vec.addElement(_mapping.getTextDescription("admin.error.All components cannot be removed from the segment"));
//					
//					sess_vec.addElement(_mapping.getTextDescription("admin.error.All components cannot be removed from the segment")+".");
//					sess_vec.addElement(_mapping.getTextDescription("admin.error.Hence this operation cannot be performed")+".");
//
//					session.putValue("vec_Errors",sess_vec);
//					/* code for auditlog starts */
//					auditLogThread.setValue("Activity","Modify Segment");		
//					auditLogThread.setCurrentValue("Component Type", "$ctype$:"+str_comp_type);
//					auditLogThread.setCurrentValue("Component Name", str_comp_name);
//					auditLogThread.setCurrentValue("Segment", subject);
//					if(zonename != null && !zonename.equals("-1") && zonename.length() != 0)
//					{
//						auditLogThread.setCurrentValue("Zone", zonename);
//					}
//					auditLogThread.setValue("Description","All components cannot be removed from the segment"+ " " + segment);
//					auditLogThread.sendItToDB();
//					/* code for auditlog ends */
//
//					rootJson.put("isError","true");
//					screenLabels.put("admin.error.Error",_mapping.getTextDescription("admin.error.All components cannot be removed from the segment")+","+ _mapping.getTextDescription("admin.error.Hence this operation cannot be performed"));
//					isdeleteCom_flag=true;
					//rootJson.put("screenLabels",screenLabels);
					//out.println(rootJson.toString());
					
					//return;
//				}
//				else
//				{
//					for (int ee=0; ee<emptyCheck.length; ee++)
//					{
//						ini_grp.deleteValue("ZONE_DETAILS", emptyCheck[ee]+"#"+zonename);
//					}
//				}
			}
			if(!isdeleteCom_flag)
			{
				ini_grp.saveFile();
				EgConfigFilesSync.releaseInstance(ini_grp);
				if (isTopoToSave) 
				{
					topoInfoWr.saveFile();
					isTopoToSave= false;
				}

				//Delete , if segment Co-ordinates are stored in js_topology.ini.
				String iniFileName = EgInstallInfo.getInstallDir()+"/manager/config/js_topology.ini";
				IniFile jsTopoIniObj  = EgConfigFilesSync.getInstance(iniFileName,true);
				jsTopoIniObj.deleteSubject(segment);
				jsTopoIniObj.saveFile();
				EgConfigFilesSync.releaseInstance(jsTopoIniObj);

				topoInfo = groupinfo.getTopoInfoWriteObject();//new EgTopoInfo("manager", true);
				//to update WEB_SITE_MAPPING and WEB_SITE_SEGMENTS sections when component(s) is removed from segment(s).
				var1 = topoInfoWr.getVariables("WEB_SITE_SEGMENTS");
				String [] s_segments = topoInfoWr.getVariables("TOPOLOGY_SEGMENTS");
				
				Hashtable segmentServerHash = new Hashtable();
				Hashtable siteSegmentHash = new Hashtable();

				if(performaction)
				{
					var = topoInfoWr.getVariables("WEB_SITE_MAPPING");
					for(int z=0; z<var1.length; z++)
					{
						strVal = topoInfoWr.getValue("WEB_SITE_SEGMENTS",var1[z]);

						Vector vect = (Vector) siteSegmentHash.get(var1[z]);
						if (vect == null)
						{
							vect = new Vector();
							StringTokenizer stoken = new StringTokenizer(strVal,",");
							while(stoken.hasMoreTokens())
								vect.add(stoken.nextToken());
							siteSegmentHash.put(var1[z],vect);
						}
						// hari comment if(strVal.indexOf(",") == -1) //Not necessary
						// hari comment	if(strVal.equals(segment) && remove)
						boolean isSegInSer = vect.contains(segment);
						if (!isSegInSer)
							continue; // not in service - so dont bother
						v_site_seg = new Vector();
						v_seg_serv = new Vector();
						boolean removesegment = true;

						site = var1[z];
						site = site.substring(site.indexOf(":")+1);
						Boolean bb = (Boolean) serviceHash.get(site);
						if (bb == null)
						{
							isAService = sitebean.isAService(site);
							serviceHash.put(site,new Boolean(isAService));
						} else {
							isAService = bb.booleanValue();
						}
						if(!isAService)
						{
							v_seg_serv = (Vector) siteServerHash.get(segment);
							if (v_seg_serv == null)
							{
								v_seg_serv = sitebean.getSiteServers(segment);
								siteServerHash.put(segment,v_seg_serv);
							}
						}
						else
						{
							v_seg_serv = (Vector) segmentServerHash.get(segment);
							if (v_seg_serv == null)
							{
								a_seg_serv.clear();
								a_seg_serv = sitebean.getServersForSegment(segment,2);
								v_seg_serv = new Vector(a_seg_serv);
								segmentServerHash.put(segment,v_seg_serv);
							} 	
						}
						try
						{
							for(int i=0; i<var.length; i++)
							{
								String s = var[i];
								s = s.substring(s.indexOf(":")+1);
								if (!s.equalsIgnoreCase(site))
									continue;
								bb = (Boolean) serviceHash.get(site);
								if (bb == null)
								{
									isAService = sitebean.isAService(site);
									serviceHash.put(site,new Boolean(isAService));
								} else {
									isAService = bb.booleanValue();
								}
								v_site_serv = (Vector) serverAssocSiteHash.get(site);
								if (v_site_serv == null)
								{
									v_site_serv = sitebean.getServAssociatedToSite(site);
									serverAssocSiteHash.put(site,v_site_serv);
								}
								String s_site_servlist = "";
								for(int j=0; j<v_site_serv.size(); j++)
								{
									val = (String)v_site_serv.get(j);	  
									if(!v_ass_servers.contains(val))
									{
										if(!((str_comp_type + ":" + str_comp_name).equals(val)))
										{
											s_site_servlist += val + ",";
										}
										else if(v_seg_serv.contains(val))
										{
											s_site_servlist += val + ",";
										}
										
									}
									else if(isAService)
									{
										if(v_seg_serv.contains(val))
										{
											s_site_servlist += val + ",";
										}
									}
								}
								if(s_site_servlist.length()!=0)
								{
									s_site_servlist = s_site_servlist.substring(0,s_site_servlist.lastIndexOf(","));
									site = var[i];
									site = site.substring(site.indexOf(":")+1);
									String strVar[] = topoInfoWr.getVariables(site + "_INDEPENDENT");
									if(strVar.length > 0)
									{
										boolean f = false;
										for(int r=0; r<strVar.length; r++)
										{
											if(s_site_servlist.indexOf(strVar[r]) == -1)
											{	
												s_site_servlist += "," + strVar[r];
												f = true;
											}
										}
										if (f)
										{
											topoInfo.setValue("WEB_SITE_MAPPING",var[i],s_site_servlist,topoInfoWr);
											isTopoToSave = true;
											siteSegmentHash.remove(var[i]);
										}
									}
									else
									{
										topoInfo.setValue("WEB_SITE_MAPPING",var[i],s_site_servlist,topoInfoWr);
										isTopoToSave = true;
										siteSegmentHash.remove(var[i]);
									}
								}

								// New Code to be included here
								// Painful Discovery !!!
								// Need to look at the Segments
								// for the associated SiteServer
								// for the site !!!
								v_site_seg = (Vector) siteSegmentHash.get(var[i]);
								if (v_site_seg == null)
								{
									v_site_seg = new Vector();
									strVal = topoInfoWr.getValue("WEB_SITE_SEGMENTS",var[i]);
									if(strVal.indexOf(",") > -1)
									{
										st = new StringTokenizer(strVal,",");
										String str_tmp = "";
										while(st.hasMoreTokens())
										{
											str_tmp = st.nextToken();
											if(!v_site_seg.contains(str_tmp))
											{
											  v_site_seg.add(str_tmp);
											}
										}
									}
									else
									{
										if(!v_site_seg.contains(strVal))
										{
										  v_site_seg.add(strVal);
										}
									}
									siteSegmentHash.put(var[i],v_site_seg);
								}


								for(int l=0; l<v_site_seg.size(); l++)
								{
									String mySeg = (String)v_site_seg.get(l);
									if(mySeg.equals("Independent_servers"))
									{
										continue;
									}
									//alagu
									//v_servers = (Vector)v_seg_serv.clone();
									v_servers = (Vector)segmentServerHash.get(mySeg);
									//out.println("<br>*v_servers:"+mySeg+" "+v_servers);
									if (v_servers==null)
									{
										ArrayList tmpSegList= sitebean.getServersForSegment(mySeg, 2);
										if (tmpSegList==null)
											continue;
										v_servers=new Vector(tmpSegList);
									}
									//Alagu ends
									removesegment = true;
									String[] comps = topoInfo.getVariables(mySeg,topoInfoWr);
									if (comps == null || comps.length == 0)
									{
										v_servers = new Vector();
									} else 
									{
										// Take v_servers, find what comps are in this segment
										// and use those to check
										Vector v1 = new Vector();
										for (int p=0; p<v_servers.size(); p++)
										{
											String me = (String) v_servers.get(p);
											for (int j=0; j<comps.length; j++)
											{
												if (comps[j].equalsIgnoreCase(me))
												{
													v1.add(me);
													break;
												}
											}
										}
										v_servers = v1;
									}
									if (v_servers.size() == 0)
										continue;
									for(int m=0; m<v_servers.size(); m++)
									{
										if(s_site_servlist.indexOf((String)v_servers.get(m)) >= 0)
										{
											removesegment = false;
											break;
										}
									}
									if(removesegment)
									{
										if(v_site_seg.size() > 1)
										{
											v_site_seg.removeElementAt(l);
											l--;
										}
									}
									//setting values after deleting
									if(v_site_seg.size() >= 1)
									{
										String s_site_seglist = "";
										for(int n=0; n<v_site_seg.size(); n++)
										{
											s_site_seglist += (String)v_site_seg.get(n) + ",";
										}
										s_site_seglist = s_site_seglist.substring(0,s_site_seglist.lastIndexOf(","));
										//New code
										if(v_sites.size() > 0)
										{
											String subj[] = topoInfoWr.getSubjects();
											for(int g=0; g<v_sites.size(); g=g+1)
											{
												s_site_seglist = "";
												String ssite = (String)v_sites.get(g);
												g = g+1;
												serv = (String)v_sites.get(g);
												strVal = topoInfoWr.getValue("WEB_SITE_SEGMENTS","Web_site:" + ssite);
												if(strVal.indexOf(",") == -1 && !done)
												{
													strVal = topoInfoWr.getValue("WEB_SITE_MAPPING","Web_site:" + ssite);
													if(v_servers.size() == 0) 
														v_servers = (Vector)v_tmp_serv.clone();
												}
												else
												{
													done = true;
													st = new StringTokenizer(strVal,",");
													while(st.hasMoreTokens())
													{
														temp = st.nextToken();
														for(int t=0; t<subj.length; t++)
														{	
															if(subj[t].equals(temp))
															{	
																/*
																	get service components
																	get segemnt componetns
																	if one component atleast exists, add that service
																*/
																//1
																String siteCmpStr = topoInfoWr.getValue("WEB_SITE_MAPPING","Web_site:" + ssite);
																if (siteCmpStr!=null && siteCmpStr.equals(""))
																	continue;
																ArrayList siteCmpLst = new ArrayList(Arrays.asList(StringUtils.getTokens(siteCmpStr, ",")));
																//2
																String [] segCmpArr = topoInfo.getVariables(subj[t],topoInfoWr);
																if (segCmpArr==null)
																	segCmpArr = new String [0];
																ArrayList segCmpLst = new ArrayList(Arrays.asList(segCmpArr));
																int sizeBe4 = segCmpLst.size();
																segCmpLst.removeAll(siteCmpLst);
																int sizeAfter = segCmpLst.size();
																if (sizeBe4!=sizeAfter)
																	s_site_seglist += temp + ",";
															}
														}
													}
													s_site_seglist = s_site_seglist.substring(0,s_site_seglist.lastIndexOf(","));
													topoInfo.setValue("WEB_SITE_SEGMENTS","Web_site:" + ssite,s_site_seglist,topoInfoWr);
													isTopoToSave = true;
												}
											}
										}
									//end of new code
										else
										{
											topoInfo.setValue("WEB_SITE_SEGMENTS",var[i],s_site_seglist,topoInfoWr);
											isTopoToSave = true;
										}
									}
									//topo.saveFile();
								}
								break;
							}
						}
						catch(Exception e)
						{
							out.println("Error " + e.toString());
						}
					}
				}
				if (isTopoToSave)
				{
					topoInfoWr.saveFile();
					isTopoToSave= false;
				}
				//Updating segment name
				var = topoInfoWr.getVariables("WEB_SITE_MAPPING");
				for(int z=0; z<var.length; z++)
				{
					site = var[z];
					site = site.substring(9,site.length());
					segment = topoInfoWr.getValue("WEB_SITE_SEGMENTS","Web_site:" + site);
					sitebean.getUpdatedSegmentName(site,segment);
				}

				v.clear();
				v_tmp_log.clear();
				v_ass_servers.clear();
				v_rest.clear();
				v_servers.clear();
				v_tmp_sites.clear();
				v_sites.clear();

				/*
				 * Update the settings for all user IDs.
				 */
				//UserRegistry registry = UserRegistry.getInstance();
				registry.updateAllUserMaps();
				EgStateZone.updateZoneGroupStatus();
				String qs = "EgAdminTopology.jsp?comptype=" + str_comp_type + "&compname=" + str_comp_name +"&qctr=1&segment="+subject+"&zone="+zonename+"&showIndOnlyParam="+showIndOnlyParam+"&newsegment=false";
				//String qs = "EgComponentSegments.jsp?comptype=" + str_comp_type + "&compname=" + str_comp_name +"&qctr=1&segment="+subject+"&zone="+zonename+"&showIndOnlyParam="+showIndOnlyParam+"&newsegment=false";
				/*
				<a href = <%=qs % >> return </a>
				*/

				// mail filter -start
				if(removedElementsList != null && removedElementsList.size() > 0)
				{
					DeleteMailFilterElements delMailFilterElements = new DeleteMailFilterElements();
					delMailFilterElements.removeElementsFromMailFilter(null,removedElementsList);
				}
				//end

				/* code for auditlog starts */
				if(existingAssociatedComponents != null && !existingAssociatedComponents.equals("null"))
				{
					isNewSegment = false;
					Vector vector = new Vector();
					StringTokenizer previousComponents = new StringTokenizer(existingAssociatedComponents,",");
					while(previousComponents.hasMoreTokens())
						vector.add(previousComponents.nextToken());
					if(vector.size()>0)
						Collections.sort(vector);
					//for(int i=0;i<vector.size();i++)
					//{
						//auditLogThread.setPreviousValue("Associated Components",vector.get(i).toString());		
						//auditLogThread.setCurrentValue("Associated Components",vector.get(i).toString());		
					//}
				}	
				
				if(str_fmanage != null && !str_fmanage.equals("null"))
				{
					Vector vector = new Vector();
					StringTokenizer currentComponents = new StringTokenizer(str_fmanage,",");
					while(currentComponents.hasMoreTokens())
						vector.add(currentComponents.nextToken());
					if(vector.size()>0)
						Collections.sort(vector);
					//for(int i=0;i<vector.size();i++)
					//auditLogThread.setCurrentValue("Associated Components",vector.get(i).toString());		
				}

				//audit log new design
				String associatedComps = topoInfoWr.getValue(currentSegment,compWithType);
				StringTokenizer tokens_associated = new StringTokenizer(associatedComps,",");
				ArrayList connectedComps = new ArrayList();
				ArrayList usedComps = new ArrayList();
				while(tokens_associated.hasMoreTokens())
				{
					String comp = tokens_associated.nextToken();
					if(comp != null && comp.endsWith("L"))
					{
						if(comp.lastIndexOf(":L") > -1)
						{
							comp = comp.substring(0,comp.lastIndexOf(":L"));
						}
						usedComps.add(comp);
					}
					else if(comp != null && comp.endsWith("N"))
					{
						if(comp.lastIndexOf(":N") > -1)
						{
							comp = comp.substring(0,comp.lastIndexOf(":N"));
						}
						connectedComps.add(comp);
					}
				}
				//When individual components are disassociated from segment, delete the mappings from eg_aggregate.ini
				if(EgInstallInfo.isAggregationSupported() && !newsegment.equalsIgnoreCase("true"))
				{
					ArrayList aggregateEntries = new ArrayList();
					String seg_for_agg = request.getParameter("segment");
					ArrayList componentsUnderSegments = new ArrayList();
					topoInfo = groupinfo.getTopoInfoWriteObject();
					String arr[] = topoInfo.getAllServers(seg_for_agg);
					if(arr != null && arr.length>0)
					{
						componentsUnderSegments.addAll(Arrays.asList(arr));
					}
					EgAggregateInfo aggregateInfo = new EgAggregateInfo("manager");
					String variables[] = aggregateInfo.getVariables("COMPONENT_ASSOCIATION");
					String variables_uica[] = aggregateInfo.getVariables("UI_COMPONENT_ASSOCIATION");
					if(variables != null && variables.length>0 || variables_uica != null && variables_uica.length>0)
					{
						Set mySet = new TreeSet();
						if(variables != null && variables.length>0)
						{
							mySet.addAll(Arrays.asList(variables));
						}
						if(variables_uica != null && variables_uica.length>0)
						{
							mySet.addAll(Arrays.asList(variables_uica));
						}
						variables = (String[])mySet.toArray(new String[mySet.size()]);
						boolean changed = false;
						boolean remove_entry = false;
						String aggregateComponent = null;
						String key1 = "#segment#"+seg_for_agg;
						String key2 = "#Segment#"+seg_for_agg;
						for(int i=0;i<variables.length;i++)
						{
							String ca = variables[i];
							if(ca.endsWith(key1) || ca.endsWith(key2))
							{
								aggregateComponent = ca.substring(0,ca.indexOf("#"));
								List associatedCompss = aggregateInfo.getAssociatedComponents(aggregateComponent, true);
								if(associatedCompss != null && !associatedCompss.isEmpty())
								{
									remove_entry = false;
									for(int j=0;j<associatedCompss.size();j++)
									{
										String associatedComp = (String)associatedCompss.get(j);
										if(componentsUnderSegments.contains(associatedComp))
										{
											remove_entry = false;
											break;
										}
										remove_entry = true;
										changed = true;
									}
									if(remove_entry)
									{
										//aggregateInfo.deleteValue("UI_COMPONENT_ASSOCIATION",ca);
										//aggregateInfo.deleteValue("COMPONENT_ASSOCIATION",ca);
										aggregateEntries.add(new IniHelper(IniHelper.DELETE,"UI_COMPONENT_ASSOCIATION",ca,""));
										aggregateEntries.add(new IniHelper(IniHelper.DELETE,"COMPONENT_ASSOCIATION",ca,""));
									}
								}
							}
						}
						if(changed)
						{
							//aggregateInfo.saveFile();
						}
						if(aggregateInfo.isAutoAssociateComponentToAnchor())
						{
							//aggregateInfo = new EgAggregateInfo("manager");
							changed = false;
							Hashtable anchorHt = aggregateInfo.getAnchorComponentsOfElement("segment",seg_for_agg);//ht from associated components of anchor components created from selected segment
							if(anchorHt != null && !anchorHt.isEmpty())
							{
								Hashtable zht = new Hashtable();//ht from components of selected segment
								Iterator itr = componentsUnderSegments.iterator();
								while(itr.hasNext())
								{
									String s = (String)itr.next();
									String type = "Agg_"+s.substring(0,s.indexOf(":"));
									if(zht.containsKey(type))
									{
										ArrayList alist = (ArrayList)zht.get(type);
										alist.add(s);
									}
									else
									{
										ArrayList alist = new ArrayList();
										alist.add(s);
										zht.put(type,alist);
									}
								}
								itr = anchorHt.keySet().iterator();
								while(itr.hasNext())
								{
									String s = (String)itr.next();
									List comps_in_anchor = (List)anchorHt.get(s);
									String type = s.substring(0,s.indexOf(":"));
									ArrayList comps_in_zone = (ArrayList)zht.get(type);
									if(comps_in_zone.size() > comps_in_anchor.size())
									{
										//if selected segment has component, but anchor has not, add this into [AGGREGATE_COMPONENTS]
										comps_in_zone.removeAll(comps_in_anchor);
										for(int i=0;i<comps_in_zone.size();i++)
										{
											changed = true;
											//aggregateInfo.setValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_zone.get(i),"associated");
											aggregateEntries.add(new IniHelper(IniHelper.SET,"AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_zone.get(i),"associated"));
										}
									}
									else if(comps_in_zone.size() < comps_in_anchor.size())
									{
										//if selected segment does not have component, but anchor coponent does, remove this from [AGGREGATE_COMPONENTS]
										comps_in_anchor.removeAll(comps_in_zone);
										for(int i=0;i<comps_in_anchor.size();i++)
										{
											changed = true;
											//aggregateInfo.deleteValue("AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_anchor.get(i));
											aggregateEntries.add(new IniHelper(IniHelper.DELETE,"AGGREGATE_COMPONENTS",s+"#"+(String)comps_in_anchor.get(i),""));
										}
									}
								}
								if(changed)
								{
									//aggregateInfo.saveFile();
								}
							}
						}
					}
					if(aggregateEntries.size() > 0)
					{
						IniFile aggregateInfoSync = EgConfigFilesSync.getInstance(EgConfigInfo.egMgrConfigDir + "eg_aggregate.ini");
						for(int idx=0;idx<aggregateEntries.size();idx++)
						{
							IniHelper iniHelper = (IniHelper)aggregateEntries.get(idx);
							String iniAction = iniHelper.getAction();
							String sub1 = iniHelper.getSubject();
							String key = iniHelper.getVariable();
							String val_1 = iniHelper.getValue();

							if(iniAction != null)
							{
								if (iniAction.equals(IniHelper.SET))
								{
									aggregateInfoSync.setValue(sub1,key,val_1);
								}
								else if (iniAction.equals(IniHelper.DELETE))
								{
									aggregateInfoSync.deleteValue(sub1,key);
								}
							}
						}			
						aggregateInfoSync.saveFile();
						EgConfigFilesSync.releaseInstance(aggregateInfoSync);
					}
				}
				String columnName = "";
				String usedComps_str = "";
				String conectedComps_str = "";
				ArrayList used = new ArrayList();
				ArrayList connected = new ArrayList();
				if( (prevConnectedComps.size() > connectedComps.size()) 
					|| (prevUsedComps.size() > usedComps.size()) )
				{
					used = prevUsedComps;
					connected = prevConnectedComps;
					used.removeAll(usedComps);
					connected.removeAll(connectedComps);
					columnName = "Disassociated components";
				}
				else if( (prevConnectedComps.size() < connectedComps.size()) 
					|| (prevUsedComps.size() < usedComps.size()) )
				{
					used = usedComps;
					connected = connectedComps;
					usedComps.removeAll(prevUsedComps);
					connectedComps.removeAll(prevConnectedComps);
					columnName = "Associated components";
				}
				for(int i=0; i<used.size(); i++)
				{
					String temp_str = (String)used.get(i);
					if(temp_str.endsWith(":NULL"))
					{
						temp_str = temp_str.substring(0,temp_str.lastIndexOf(":"));
					}
					temp_str = "$ctype$:"+temp_str;
					usedComps_str = usedComps_str+temp_str+",";
				}
				for(int i=0; i<connected.size(); i++)
				{
					String temp_str = (String)connected.get(i);
					if(temp_str.endsWith(":NULL"))
					{
						temp_str = temp_str.substring(0,temp_str.lastIndexOf(":"));
					}
					temp_str = "$ctype$:"+temp_str;
					conectedComps_str = conectedComps_str+temp_str+",";
				}
				if(usedComps_str.endsWith(","))
					usedComps_str = usedComps_str.substring(0,usedComps_str.length()-1);
				if(conectedComps_str.endsWith(","))
					conectedComps_str = conectedComps_str.substring(0,conectedComps_str.length()-1);

				if(!"".equals(columnName))
				{
					if(compWithType.endsWith(":NULL"))
					{
						compWithType = compWithType.substring(0,compWithType.lastIndexOf(":"));
					}
					auditLogThread.setCurrentValue("ColumnName",columnName);
					if(usedComps_str.length() != 0)
						auditLogThread.setCurrentValue("$ctype$:"+compWithType+" (Uses)",usedComps_str);
					if(conectedComps_str.length() != 0)
						auditLogThread.setCurrentValue("$ctype$:"+compWithType+" (Connects)",conectedComps_str);
				}
				//end

				if("true".equalsIgnoreCase(newsegment))
				{
					String extraStr = "";
					if(zonename != null && zonename.length() != 0 && !zonename.equals("-1"))
						extraStr = "and it is associated to the zone "+zonename;
					auditLogThread.setValue("Activity","Add Segment");	
					auditLogThread.setValue("Description","Segment "+currentSegment +" "+ "has been created "+extraStr);
				}
				else
				{
					auditLogThread.setValue("Activity","Modify Segment");		
					auditLogThread.setValue("Description","Segment "+currentSegment +" "+ "has been modified");
				}
				auditLogThread.sendItToDB();
				/* code for auditlog ends */
				qs=qs+"&reqFrom=thisPage"+"&zoom="+zoom;

				String uiFile = "eg_ui.ini";
				String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
				IniFile egUISave = new IniFile(s_iniFile_dir + uiFile);
				String showUsers=egUISave.getValue("ALARM_HISTORY","Show_Users");
				String curr_date=null;
				if(showUsers!=null && (showUsers.equalsIgnoreCase("true") || showUsers.equalsIgnoreCase("yes")))
				{
					curr_date=String.valueOf(new java.util.Date());
					if(ecumb.hashLastComponentUserUpdated!=null && ecumb.hashLastComponentUserUpdated.size()>0)
					{
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
					else
					{
						ecumb.hashLastComponentUserUpdated=new Hashtable();
						ecumb.hashLastComponentUserUpdated.put("Updated",(String)curr_date);
					}
				}
			}
			if (topoInfoWr != null)
			{
				EgConfigFilesSync.releaseInstance(topoInfoWr);
			}
			rootJson.put("isEmpty","false");
			IniFile topoInfoWr1 = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_topology.ini");
			String [] emptyCheck  = topoInfoWr1.getVariables(subject);
			//dont allow if user tries to create an empty topology
			if (emptyCheck==null || emptyCheck.length<=1)
			{
				topoInfoWr1.deleteValue("TOPOLOGY_SEGMENTS",subject);
				topoInfoWr1.deleteValue("SEGMENT_DISPLAY_IMAGE",subject);
				topoInfoWr1.saveFile();
				rootJson.put("isEmpty","emptyCheck");
			}
			EgConfigFilesSync.releaseInstance(topoInfoWr1);
		}
		if (ini_grp != null)
		{
			EgConfigFilesSync.releaseInstance(ini_grp);
		}
		if (topoInfoWr != null)
		{
			EgConfigFilesSync.releaseInstance(topoInfoWr);
		}
		rootJson.put("success","true");
		rootJson.put("screenLabels",screenLabels);
		out.println(rootJson.toString());
%>



