<%
/************************************************************************************************************
*	Name			:	deletegroupsremotepJson.jsp
*	Purpose			:	To delete remote agents which do not manage any hosts
***********************************************************************************************************/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.AgentConfig"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "java.util.Vector"%>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject resultMsg = new JSONObject();

	/* code for auditlog starts */
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Delete Agents");
	/* code for auditlog ends */

	//trans.createFile("eg_external.ini","save");
	trans.createSyncFile("eg_external.ini","save");
	AgentConfig agentConfig=AgentConfig.getAgentConfig();
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	Vector allInternalHosts = externalInfo.getAllAgents();
	rootJson.put("allInternalHosts",allInternalHosts);

	Vector sessionVector = new Vector();
	String from = request.getParameter("from");
	boolean flagNotDel = false;

	if(from != null && from.equalsIgnoreCase("deleteRemoteAgentsPage"))
	{
		String remoteAgentsStr = request.getParameter("remoteAgents");
		String remoteAgentsArr[] = StringUtils.getTokens(remoteAgentsStr,",");
		if(remoteAgentsArr != null && remoteAgentsArr.length > 0)
		{
			for(int r=0;r<remoteAgentsArr.length;r++)
			{
				String s_ragent = remoteAgentsArr[r];
				if (allInternalHosts != null && allInternalHosts.contains(s_ragent))
				{
					flagNotDel = true;
					rootJson.put("requestStatus","failed");
					JSONObject errorMsg = new JSONObject();
					errorMsg.put("title",_mapping.getTextDescription("admin.error.List of remote agent"));
					errorMsg.put("message1",_mapping.getTextDescription("admin.error.This remote agent has been used as an internal agent to one or more hosts")+"."+_mapping.getTextDescription("admin.error.It needs to be disassociated as the internal agent from the host(s)")+"."+_mapping.getTextDescription("admin.error.Go to the Components Add/Modify page to perform this action before deleting this agent")+".");

					rootJson.put("error",errorMsg);

					/* auditlog - start */
					auditLogThread.setValue("Activity","Add/Delete");
					auditLogThread.setCurrentValue("ColumnName","Remote Agent Not Deleted");
					auditLogThread.setCurrentValue("Host/Nick name",remoteAgentsStr);
					auditLogThread.setValue("Description","Remote agent has not been deleted since it is assigned as an internal agent to one or more hosts");
					auditLogThread.sendItToDB();
					/* auditlog - end */
				}
			}
		}
		if (!flagNotDel)
		{
			auditLogThread.setValue("Activity","Remote Agents");
			if(remoteAgentsStr != null && !remoteAgentsStr.equalsIgnoreCase("null") && remoteAgentsStr.trim().length()>0)
			{
				String remoteAgents[] = StringUtils.getTokens(remoteAgentsStr,",");
				for(int i=0;i<remoteAgents.length;i++)
				{
					trans.deleteSpecValue(EgExternalInfo.remoteAgentsSection, remoteAgents[i]);
					agentConfig.removeAgentElement(remoteAgents[i]);
					auditLogThread.setCurrentValue("Agent Names",remoteAgents[i]);
				}
			}
			rootJson.put("requestStatus","success");
			resultMsg.put("title",_mapping.getTextDescription("admin.common.Delete Remote Agents"));
			resultMsg.put("message1",_mapping.getTextDescription("admin.common.Remote agent(s) deleted from eG system")+"...");
			rootJson.put("result",resultMsg);

			auditLogThread.setValue("Description","Remote agents have been deleted from eG system");
		}
	}
	trans.saveFile();
	trans.releaseInstance();
	auditLogThread.sendItToDB();
	session.putValue("vec_Results",sessionVector);

	System.out.println("rootJson____"+rootJson);
	out.println(rootJson.toString());
%>



