<%
/*******************************************************************************
 *      File name               :       EgDispRemoteAgentsJson.jsp
 *      Purpose                 :       To display the list of remote agents
                                        in the system.
 ******************************************************************************/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgServicesInfo"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String egTitleSearchStr = request.getParameter("egTitleSearchStr");
	boolean isSearchResult = (egTitleSearchStr!=null && egTitleSearchStr!="");
	ArrayList searchList = new ArrayList();
	if (isSearchResult)
	{
		StringTokenizer st = new StringTokenizer(egTitleSearchStr);
		while (st.hasMoreTokens())
		{
			String thisToken = st.nextToken().trim();
			if (thisToken.equals(""))
				continue;
			searchList.add(thisToken);
		}
	}
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	trans.createFile("eg_external.ini");
	String [] s_eagents = trans.getVariables("Eg_Remote_Agents");
	EgSpecsInfo specs = new EgSpecsInfo("manager");
	EgServicesInfo servicesInfo = new EgServicesInfo("manager");
	EgExternalInfo externalInfo = new EgExternalInfo("manager");
	RemoteAgent rmtObj = new RemoteAgent();

	Vector allInternalHosts = externalInfo.getAllAgents();
	boolean searchItemFound=false;
	ArrayList remAgents = new ArrayList();
	if (s_eagents!=null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
		for(int i=0;i < s_eagents.length;i++)
		{
			if (isSearchResult && !doesExist(searchList, s_eagents[i]))
				continue;
			searchItemFound=true;
			remAgents.add(s_eagents[i]);
		}
	}
	List tmpList = new ArrayList();
	String defaultRemAgent = "";
	for (int j=0; j <remAgents.size();j++)
	{
		String tmpExtagent = (String)remAgents.get(j);
		if (specs.getEGServer().equals(tmpExtagent))
		{
			defaultRemAgent = tmpExtagent;
		}
		else
		{
			tmpList.add(tmpExtagent);
		}
	}
	if (!defaultRemAgent.equals(""))
	{
		tmpList.add(0,defaultRemAgent);
	}
	remAgents = new ArrayList(tmpList);
	Collections.sort(remAgents,String.CASE_INSENSITIVE_ORDER);

	JSONArray gridRmtAgents = new JSONArray();
	JSONObject gridObject = new JSONObject();
	boolean isDisabled = false;

	if(remAgents != null && remAgents.size() > 0 && searchItemFound)
	{
		for(int i=0;i < remAgents.size();i++)
		{
			gridObject.put("Hostname",(String)remAgents.get(i));
			String remoteAgentIP = externalInfo.getIpForRemoteAgent((String)remAgents.get(i));
			boolean border=(i+1)< remAgents.size();
			gridObject.put("HostIP",remoteAgentIP);

			boolean isUsed = false;
			List agentWithCmp = rmtObj.getAgentsUsedWithComponent((String)remAgents.get(i));
			if (agentWithCmp.contains((String)remAgents.get(i)))
			{
				isUsed = true;
			}
			gridObject.put("AssoDissRemAgnt",isUsed);

			boolean flagNotDel = false;
			if (allInternalHosts != null && allInternalHosts.contains((String)remAgents.get(i)))
			{
				flagNotDel = true;
			}
			gridObject.put("internalRemAgent",flagNotDel);
			isDisabled = isUsed || flagNotDel;
			gridObject.put("isDisabled",isDisabled);

			gridRmtAgents.add(gridObject);
		}
	}
	else
	{
		if (!isSearchResult && s_eagents == null || s_eagents.length == 0)
		{
			rootJson.put("NoRmtFound","true");
			screenLabels.put("admin.remote.No remote agents present in the system",_mapping.getTextDescription("admin.remote.No remote agents present in the system"));
		}
		else if (isSearchResult && remAgents.size() ==0)
		{
			screenLabels.put("admin.remote.No remote agent(s) found for your current search",_mapping.getTextDescription("admin.remote.No remote agent(s) found for your current search"));
		}
	}
%>

<%!
	private boolean doesExist(List searchList, String thisGroup)
	{
		Iterator i = searchList.iterator();
		while(i.hasNext())
		{
			String nextStr = (String) i.next();
			if (thisGroup.indexOf(nextStr)!=-1||(thisGroup.toUpperCase().indexOf(nextStr.toUpperCase()))!=-1)
				return true;
		}
		return false;
	}
%>

<%
	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?"+request.getQueryString());
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp");

	rootJson.put("gridRmtAgents",gridRmtAgents);
	rootJson.put("screenLabels",screenLabels);

	String[] rmtAgents = externalInfo.getAllRemoteAgents();
	if (rmtAgents != null && rmtAgents.length > 0)
	{
		List rmtList = Arrays.asList(rmtAgents);
		String strrmtList = rmtList.toString();
		strrmtList = strrmtList.substring(1,strrmtList.length()-1);
		rootJson.put("strrmtList",strrmtList);
	}


	out.println(rootJson.toString());
%>



