<%
/**
 *  File name       :	EgConfigRemoteAgentsJson.jsp
 *  Purpose         :   To configure hosts to Remote agents. 
 */
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.util.*"%>
<%@ page import = "java.util.*"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	screenLabels.put("admin.test.Please choose a remote agent",_mapping.getTextDescription("admin.test.Please choose a remote agent"));
	screenLabels.put("admin.test.Remote agent",_mapping.getTextDescription("admin.test.Remote agent"));
	screenLabels.put("admin.common.Updating",_mapping.getTextDescription("admin.common.Updating"));
	screenLabels.put("admin.remote.No managed hosts selected",_mapping.getTextDescription("admin.remote.No managed hosts selected"));
	screenLabels.put("admin.remote.Please choose atleast one agent to manage or unmanage",_mapping.getTextDescription("admin.remote.Please choose atleast one agent to manage or unmanage"));

	EgExternalInfo extInfo = new EgExternalInfo("manager");
	String[] s_eagent_servers = extInfo.getRemoteComponents();

	Vector v_managed_servers = new Vector();
	List finalServers = new LinkedList();
	Vector v_eagent_servers = new Vector();
	String s_tmp = "";
	String s_val = "";
	String s_eagent = request.getParameter("eagent");
	if(s_eagent != null && !s_eagent.equals("null"))
	{
		if (s_eagent_servers != null)
		{
			for(int i=0;i < s_eagent_servers.length;i++)
			{
				s_tmp = s_eagent_servers[i];
				s_val = extInfo.getRemoteAgentForHost(s_tmp);

				if (s_val.indexOf(",") > -1 
					&& (s_val.indexOf(s_eagent+",") > -1 
						|| s_val.startsWith(s_eagent+",") 
						|| s_val.endsWith(s_eagent)))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else if(s_val.equals(s_eagent))
				{
					v_eagent_servers.addElement(s_tmp);
				}
				else
				{
					continue;
				}
			}
		}

		/* need to find out the servers which have agentless enabled */
		if (s_eagent_servers != null)
		{
			for (int k=0; k<s_eagent_servers.length; k++)
			{
				if (!finalServers.contains(s_eagent_servers[k]))
						finalServers.add(s_eagent_servers[k]);
			}
		}

		for(int k=0;k < v_eagent_servers.size();k++)
		{
			if(finalServers.contains(v_eagent_servers.elementAt(k)))
			{
				int index1 = finalServers.indexOf(v_eagent_servers.elementAt(k));
				finalServers.remove(index1);
			}
		}
	}
	String reqFrom = request.getParameter("from");
	reqFrom = (reqFrom != null)?reqFrom:"";

	List v = new LinkedList();
	ArrayList al = new ArrayList();
	if (s_eagent_servers != null)
	{
		for (int a=0; a<s_eagent_servers.length; a++)
		{
			String info = extInfo.getAgentlessInfos(s_eagent_servers[a]);
			StringTokenizer tokenInfo = new StringTokenizer(info,",");
			int countTok = tokenInfo.countTokens();
			if (countTok == 5)
			{
				if (StringUtils.isNull(info) || (info.startsWith("None,") && info.endsWith(",None")))
				{
					v.add(s_eagent_servers[a]);
				}
			}
			if (countTok == 7)
			{
				while(tokenInfo.hasMoreElements())
				{
					al.add(tokenInfo.nextElement());
				}
				String firstEl = (String)al.get(0);
				String fifthEl = (String)al.get(4);
				if (StringUtils.isNull(firstEl) && StringUtils.isNull(fifthEl) || (firstEl.startsWith("None") && fifthEl.endsWith("None")))
				{
					v.add(s_eagent_servers[a]);
				}
				al.clear();
			}
		}
	}

	int count = v.size();
	rootJson.put("vector",v);

	screenLabels.put("admin.remote.The following components have not been configured for agentless monitoring",_mapping.getTextDescription("admin.remote.The following components have not been configured for agentless monitoring"));
	screenLabels.put("admin.remote.Immediately go to",_mapping.getTextDescription("admin.remote.Immediately go to"));
	screenLabels.put("admin.remote.ADD / MODIFY",_mapping.getTextDescription("admin.remote.ADD / MODIFY"));
	screenLabels.put("admin.remote.and configure the remote agents of these components",_mapping.getTextDescription("admin.remote.and configure the remote agents of these components"));
	screenLabels.put("admin.remote.HOSTS MANAGED",_mapping.getTextDescription("admin.remote.HOSTS MANAGED"));
	screenLabels.put("admin.remote.HOSTS MANAGED BY THIS AGENT",_mapping.getTextDescription("admin.remote.HOSTS MANAGED BY THIS AGENT"));

	String[] s_eagents = extInfo.getAllRemoteAgents();
	if (s_eagents != null)
	{
		Arrays.sort(s_eagents,String.CASE_INSENSITIVE_ORDER);
	}
	else
	{
		s_eagents = new String[0];
	}

	if(s_eagents.length==0)
	{
		screenLabels.put("admin.remote.No Remote Agents currently available",_mapping.getTextDescription("admin.remote.No Remote Agents currently available"));
	}
	else
	{
		screenLabels.put("admin.remote.Remote agent",_mapping.getTextDescription("admin.remote.Remote agent"));

		JSONArray remoteAgentsArray = new JSONArray();
		JSONObject remoteValue = new JSONObject();

		remoteValue.put("displayField",_mapping.getTextDescription("admin.remote.Choose a remote agent"));
		remoteValue.put("valueField",-1);
		remoteAgentsArray.add(remoteValue);
		for(int i=0;i < s_eagents.length;i++)
		{
			if(s_eagents[i].equals(s_eagent))
			{
				remoteValue.put("displayField",s_eagents[i]);
				remoteValue.put("valueField",s_eagents[i]);
				remoteAgentsArray.add(remoteValue);
			}
			else
			{
				remoteValue.put("displayField",s_eagents[i]);
				remoteValue.put("valueField",s_eagents[i]);
				remoteAgentsArray.add(remoteValue);
			}
		}
		rootJson.put("remoteAgentsArray",remoteAgentsArray);

		JSONArray ManagedHostByThisAgnt = new JSONArray();
		JSONObject ManagedHostByThisAgntObj = new JSONObject();

		String existingAgents = "";
		int hostsCount = v_eagent_servers.size();
		if (hostsCount > 0)
		{
			Collections.sort(v_eagent_servers,String.CASE_INSENSITIVE_ORDER);
			for(int j=0; j<hostsCount; j++)
			{
				String str_temp = (String)v_eagent_servers.get(j);
				ManagedHostByThisAgntObj.put("displayField",str_temp);
				ManagedHostByThisAgntObj.put("valueField",str_temp);
				ManagedHostByThisAgnt.add(ManagedHostByThisAgntObj);

				existingAgents += str_temp + ",";
			}
			if(existingAgents.indexOf(",")!=-1)
			{
				existingAgents = existingAgents.substring(0,existingAgents.lastIndexOf(","));
				rootJson.put("existingAgents",existingAgents);
			}
		}
		rootJson.put("ManagedHostByThisAgent",ManagedHostByThisAgnt);

		screenLabels.put("admin.thresdhold.Associate",_mapping.getTextDescription("admin.thresdhold.Associate"));
		screenLabels.put("admin.remote.OTHER HOSTS",_mapping.getTextDescription("admin.remote.OTHER HOSTS"));

		JSONArray ManagedHostByOthrAgnt = new JSONArray();
		JSONObject ManagedHostByOthrAgntObj = new JSONObject();

		if(finalServers.size() > 0)
		{
			Collections.sort(finalServers,String.CASE_INSENSITIVE_ORDER);
			for(int x=0;x < finalServers.size();x++)
			{
				ManagedHostByOthrAgntObj.put("displayField",finalServers.get(x));
				ManagedHostByOthrAgntObj.put("valueField",finalServers.get(x));
				ManagedHostByOthrAgnt.add(ManagedHostByOthrAgntObj);
			}
		}
		rootJson.put("ManagedHostByOthrAgnt",ManagedHostByOthrAgnt);

		screenLabels.put("admin.remote.Update",_mapping.getTextDescription("admin.remote.Update"));
      }

	v_eagent_servers.removeAllElements();
	finalServers.clear();

	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?"+request.getQueryString()+"&fromAssignRem=true");
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?eagent=null&fromAssignRem=true");

	rootJson.put("screenLabels",screenLabels);
	out.println(rootJson.toString());
%>



