<%
/************************************************************************************************************
*	Name			:	DeleteRemoteAgentsJson.jsp
*	Purpose			:	To delete remote agents which do not manage any hosts
***********************************************************************************************************/
%>
<%@ include file = "../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import = "com.eg.EgSpecsInfo"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgExternalInfo"%>
<%@ page import = "com.egurkha.admin.RemoteAgent"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>
<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");
%>

<jsp:useBean id="trans" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	String delAgent = request.getParameter("eagent");
	RemoteAgent rmtObj = new RemoteAgent();
	boolean isUsed = false;
	List agentWithCmp = rmtObj.getAgentsUsedWithComponent(delAgent);
	if (agentWithCmp.contains(delAgent))
	{
		isUsed = true;
	}
	rootJson.put("AssociatedAgnt",isUsed);

	trans.createFile("eg_external.ini");
	String [] remoteAgents = trans.getVariables("Eg_Remote_Agents");
	String [] remoteAgentHosts = trans.getVariables("Remote_Agent_Mapping_Section");

	Vector deleteRemoteAgents = null;
	if(remoteAgents != null && remoteAgents.length>0)
	{
		deleteRemoteAgents = new Vector(Arrays.asList(remoteAgents));
		deleteRemoteAgents.remove(new EgSpecsInfo("manager").getEGServer());
	}
	else
		deleteRemoteAgents = new Vector();

	for(int a=deleteRemoteAgents.size()-1;a>=0;a--)
	{
		String remoteAgent = (String) deleteRemoteAgents.get(a);
		for (int i=0; i<remoteAgentHosts.length; i++)
		{
			String remoteAgentsToNick = trans.getStrValue(EgExternalInfo.remoteAgentMappingSection, remoteAgentHosts[i]);
			if (remoteAgentsToNick.indexOf(",") > -1 && (remoteAgentsToNick.indexOf(remoteAgent+",") > -1 || remoteAgentsToNick.startsWith(remoteAgent+",") || remoteAgentsToNick.endsWith(remoteAgent)))
				deleteRemoteAgents.remove(remoteAgent);
			else if(remoteAgentsToNick.equals(remoteAgent))
				deleteRemoteAgents.remove(remoteAgent);
		}
	}
	trans.saveFile();
	if(deleteRemoteAgents.size()>0)
		Collections.sort(deleteRemoteAgents,String.CASE_INSENSITIVE_ORDER);

	screenLabels.put("admin.common.Please enter a Search String",_mapping.getTextDescription("admin.common.Please enter a Search String"));
	screenLabels.put("admin.common.No remote agent(s) found for your search",_mapping.getTextDescription("admin.common.No remote agent(s) found for your search"));
	screenLabels.put("admin.common.Please select remote agent(s)",_mapping.getTextDescription("admin.common.Please select remote agent(s)"));
	screenLabels.put("admin.common.Remote agents which are not associated to any hosts",_mapping.getTextDescription("admin.common.Remote agents which are not associated to any hosts"));
	screenLabels.put("admin.common.Delete",_mapping.getTextDescription("admin.common.Delete"));

	JSONArray remoteAgentArray = new JSONArray();
	JSONObject remoteObj = new JSONObject();
	for(int i=0;i<deleteRemoteAgents.size();i++)
	{
		String remoteAgent = (String) deleteRemoteAgents.get(i);
		remoteObj.put("displayField",remoteAgent);
		remoteObj.put("valueField",remoteAgent);
		remoteAgentArray.add(remoteObj);
	}

	JSONArray searchArr = new JSONArray();
	JSONObject searchObj = new JSONObject();
	String searchAgents = request.getParameter("compsearch");
	for (int j=0;j<deleteRemoteAgents.size();j++)
	{
		String deleteRemote = (String)deleteRemoteAgents.get(j);
		if(searchAgents != null && ((deleteRemote.toUpperCase()).indexOf(searchAgents.toUpperCase()) > -1 ))
		{
			searchObj.put("displayField",deleteRemote);
			searchObj.put("valueField",deleteRemote);
			searchArr.add(searchObj);
		}
	}
	rootJson.put("searchArr",searchArr);
	rootJson.put("from","deleteRemoteAgentsPage");
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("remoteAgentArray",remoteAgentArray);

	if(request.getQueryString()!=null)
	session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?"+request.getQueryString()+"&fromDeleteRem=true");
	else session.setAttribute("adminLastAccessedURL","/final/admin/EgRemoteAgents.jsp?eagent=null&fromDeleteRem=true");

	out.println(rootJson.toString());
%>



