<%
/**
 *	 File			:	EgMailServerSettingsJson.jsp
 *	 Purpose		:	Enables the administrator to configure eG's mail settings.
 */
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgMemInfo"%>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import = "com.egurkha.EgConstants"%>
<%@ page import = "com.egurkha.util.StringUtils"%>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgInstallInfo"%>

<%!
	String licenseCheck = "me";
	String subject = "";
	String strHost = "";
	String strPort = "";
	String strProtocol = "";
	String[] strProtocolValues = {"SMTP","SMTP-SSL","SMTP-TLS"};
	String strSender = "";
	String strmSub = "";
	String strsSub = "";
	String strsFormat = "";
	String strmailFormat = "";
	String strmailseparate = "";
	String strsmsseparate = "";
	String normalMail = "";
	String ddMail = "";
	String mailReceiver = "";
	String mailReceiverPasswd = "";
	String mailRcvPort = "";
	String mailRcvProtocol = "";
	String mailRcvServer = "";
	boolean isDouble = EgDbInfo.doubleByteEnabled;
%>

<jsp:useBean id="mailconfig" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);

	boolean smsEnabled = false;
	synchronized(licenseCheck)
	{
		smsEnabled = EgMemInfo.smsEnabled;
	}

	subject = "MISC_ARGS";
	mailconfig.createFile("eg_services.ini");
	strHost = mailconfig.getStrValue(subject,"MailHost");
	strPort = mailconfig.getStrValue(subject,"MailPort");
	strProtocol = mailconfig.getStrValue(subject,"MailHostProtocol");
	strSender = mailconfig.getStrValue(subject,"MailSender");
	
	mailReceiver = mailconfig.getStrValue(subject,"MailReceiver");
	mailReceiverPasswd = mailconfig.getStrValue(subject,"MailReceiverPasswd");
	mailRcvPort = mailconfig.getStrValue(subject,"MailRcvPort");
	mailRcvProtocol = mailconfig.getStrValue(subject,"MailRcvProtocol");
	mailRcvServer = mailconfig.getStrValue(subject,"MailRcvServer");

	strmSub = mailconfig.getStrValue(subject,"MailSubject");
	strsSub = mailconfig.getStrValue(subject,"SmsSubject");
	strsFormat = mailconfig.getStrValue(subject,"SmsFormat");
	strmailseparate = mailconfig.getStrValue(subject,"MailSeparate");
	strsmsseparate = mailconfig.getStrValue(subject,"SeparateSms");
	strmailFormat = mailconfig.getStrValue(subject,"MailFormat");
	normalMail = mailconfig.getStrValue(subject,"MailNormal");
	ddMail = mailconfig.getStrValue(subject,"ShowDDinMail");
	String strUser = mailconfig.getStrValue(subject,"MailUser");
	String strPwd = mailconfig.getStrValue(subject,"MailPasswd");
	String receiverSettingConfig = mailconfig.getStrValue(subject,"receiverSettingConfig");
	String mailAsAttachment = mailconfig.getStrValue(subject,"SendMailAlertAsAttachment");
	boolean selectRevSetting = false;
	String isBackUpServer = mailconfig.getStrValue(subject,"Backup_mailserver_setting");
	boolean isBackUpServerNeeded = (isBackUpServer != null && isBackUpServer.equalsIgnoreCase("yes")) ? true : false;
	if(receiverSettingConfig.equalsIgnoreCase("false") || receiverSettingConfig.equalsIgnoreCase(""))
	{
		selectRevSetting=false;
	}
	else
	{
		selectRevSetting=true;
	}

	rootJson.put("strHost",strHost);
	rootJson.put("strPort",strPort);
	rootJson.put("strProtocol",strProtocol);
	rootJson.put("strSender",strSender);

	rootJson.put("mailReceiver",mailReceiver);
	rootJson.put("mailReceiverPasswd",mailReceiverPasswd);
	rootJson.put("mailRcvPort",mailRcvPort);
	rootJson.put("mailRcvProtocol",mailRcvProtocol);
	rootJson.put("mailRcvServer",mailRcvServer);

	rootJson.put("strmSub",strmSub);
	rootJson.put("strsSub",strsSub);
	rootJson.put("strsFormat",strsFormat);
	rootJson.put("strmailseparate",strmailseparate);
	rootJson.put("strsmsseparate",strsmsseparate);
	rootJson.put("strmailFormat",strmailFormat);
	rootJson.put("normalMail",normalMail);
	rootJson.put("ddMail",ddMail);

	rootJson.put("strUser",strUser);
	rootJson.put("receiverSettingConfig",receiverSettingConfig);
	rootJson.put("mailAsAttachment",mailAsAttachment);
	rootJson.put("isBackUpServer",isBackUpServer);
	rootJson.put("isBackUpServerNeeded",isBackUpServerNeeded);
	rootJson.put("selectRevSetting",selectRevSetting);

	//For Mail senders IDs
	String[] mailIDs =  mailconfig.getVariables("MAIL_SENDERS");
	StringBuffer mailBuff = new StringBuffer();
	for (int i=0;i<mailIDs.length;i++)
	{
		mailBuff.append(mailIDs[i]);
		if (!(mailIDs.length==(i+1)))
		{
			mailBuff.append("\n");
		}
	}
	rootJson.put("mailBuff",mailBuff.toString());
	String authenticateYes = null;
	String authenticateNo = null;

	if (StringUtils.isNull(strUser))
	{
		authenticateYes = EgConstants.BLANK_STRING;
		authenticateNo = "checked";
	}
	else
	{
		authenticateYes = "checked";
		authenticateNo = EgConstants.BLANK_STRING;
		strPwd = EgCrypt.decrypt(strPwd);
	}
	rootJson.put("strPwd",strPwd);
	rootJson.put("authenticateYes",authenticateYes);
	rootJson.put("authenticateNo",authenticateNo);

	String type1 = "";
	String type2 = "";
	String type3 = "";
	String type4 = "";
	String type5 = "";
	String type6 = "";
	String type7 = "";
	String type8 = "";
	String type9 = "";

	String mail1 = "";
	String mail2 = "";
	String mail3 = "";
	String mail4 = "";
	String mail5 = "";
	String mail6 = "";
	String mail7 = "";
	String mail8 = "";

	//skm (03/03/2006)
	IniFile servicesInfo = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini");
	String mailLastValue = null;
	if (servicesInfo != null)
		mailLastValue = servicesInfo.getValue("MISC_ARGS","MailLastValue");
	//skm (03/03/2006)

	StringTokenizer st = new StringTokenizer(strsFormat, ",");
	while(st.hasMoreTokens())
	{
		String strTok = st.nextToken();
		if(strTok.equals("cname"))
			type1 = "checked";
		else if(strTok.equals("ctype"))
			type2 = "checked";
		else if(strTok.equals("desc"))
			type3 = "checked";
		else if(strTok.equals("site"))
			type4 = "checked";
		else if(strTok.equals("test"))
			type5 = "checked";
		else if(strTok.equals("measure"))
			type6 = "checked";
		else if(strTok.equals("mHost"))
			type7 = "checked";
		else if(strTok.equals("layer"))
			type8 = "checked";
		else if(strTok.equals("prior"))
			type9 = "checked";
	}

	StringTokenizer stmail = new StringTokenizer(strmailFormat, ",");
	while(stmail.hasMoreTokens())
	{
		String strTok = stmail.nextToken();
		if(strTok.equals("cname"))
			mail1 = "checked";
		else if(strTok.equals("ctype"))
			mail2 = "checked";
		else if(strTok.equals("layer"))
			mail3 = "checked";
		else if(strTok.equals("desc"))
			mail4 = "checked";
		else if(strTok.equals("site"))
			mail5 = "checked";
		else if(strTok.equals("test"))
			mail6 = "checked";
		else if(strTok.equals("measure"))
			mail7 = "checked";
		else if(strTok.equals("mHost"))
			mail8 = "checked";
	}

	JSONArray protocolArray = new JSONArray();
	JSONObject protocolObj = new JSONObject();
	for(int i=0;i<strProtocolValues.length;i++)
	{
		protocolObj.put("displayField",strProtocolValues[i]);
		protocolObj.put("valueField",strProtocolValues[i]);
		protocolArray.add(protocolObj);
	}
	rootJson.put("protocolArray",protocolArray);

	if(mailReceiverPasswd != null && mailReceiverPasswd.length() > 0)
	{
		mailReceiverPasswd = EgCrypt.decrypt(mailReceiverPasswd);
		rootJson.put("mailReceiverPasswd",mailReceiverPasswd);
	}

	if (mailLastValue!=null && (mailLastValue.equalsIgnoreCase("yes")||mailLastValue.equalsIgnoreCase("true")))	//skm (09/03/2006)
	{
		rootJson.put("measureFlag","true");
		rootJson.put("smsMeasureFlag","true");
		rootJson.put("mailSubjectMeasureFlag","true");
	}
	else
	{
		rootJson.put("measureFlag","false");
		rootJson.put("smsMeasureFlag","false");
		rootJson.put("mailSubjectMeasureFlag","false");
	}

	if (request.getQueryString() != null)
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgMailServerSettings.jsp?"+request.getQueryString());
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgMailServerSettings.jsp");
	}

	System.out.println("rootJson___________"+rootJson);
	out.println(rootJson.toString());
%>



