<%
/** 
 *	 File			:	EgBackupMailServerpJson.jsp
 *	 Purpose		:	Enables the administrator to configure eG's backup mail settings process page.
 */
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "com.eg.EgCrypt" %>
<%@page import = "com.eg.IniFile"%>
<%@ page import = "com.eg.EgMemInfo" %>
<%@ page import = "com.egurkha.util.StringUtils" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "java.util.ArrayList"%>
<%@ page import = "java.util.Hashtable"%>
<%@ page import = "net.sf.json.*"%>
<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8" %>

<jsp:useBean id="backupMailconfig" scope="page" class="egurkha.TransactionBean"/>

<%
	JSONObject rootJson = new JSONObject(); 
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
%>
<%
try
{
	IniFile uiObject = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_services.ini",true);
	backupMailconfig.createFile("eg_services.ini","save");
	String subject = "BACKUP_MAIL_SERVERS";

	String rmvSettingsFrmIni = request.getParameter("removehostFrmIni");
	if (rmvSettingsFrmIni == null)
	{
		rmvSettingsFrmIni = "";
	}

	if (rmvSettingsFrmIni.equals("true"))
	{
		Vector sBckVal = new Vector(); 
		sBckVal = uiObject.getVariables(subject,true);
		if(sBckVal != null)
		{
			String removeSmtpHost = request.getParameter("removeSmtpHost");
			backupMailconfig.deleteSpecValue(subject,removeSmtpHost);
			backupMailconfig.saveFile();
		}

		rootJson.put("requestStatus","success");
		JSONObject resultMsg = new JSONObject();
		resultMsg.put("title",_mapping.getTextDescription("admin.title.Backup mail server settings"));
		resultMsg.put("message1",_mapping.getTextDescription("admin.title.Backup mail backup server settings have been removed successfully")+".");
		rootJson.put("result",resultMsg);

		System.out.println("rootJson_____"+rootJson);
		out.println(rootJson.toString());
		return;
	}

	backupMailconfig.delSubject(subject);
	String configureParam = request.getParameter("paramForBackMailSvr");
	String[] backupConfigs = StringUtils.getTokens(configureParam,"~#~");
	ArrayList valueList = new ArrayList();
	
	String temp = "";
	String iniValue = "";
	if (backupConfigs != null && backupConfigs.length > 0)
	{
		for (int i = 0;i < backupConfigs.length ; i++)
		{	
			int position = 0;
			iniValue = "";
			String configuration = backupConfigs[i];
			if (configuration == null && configuration.indexOf("=") == -1)
				continue;
			String variable = configuration.substring(0,configuration.indexOf("="));
			String value = configuration.substring(configuration.indexOf("=")+1);
			valueList = StringUtils.egTokenizer(value,"~|~");

			for (int j=0;j<valueList.size();j++)
			{	
				temp = (String)valueList.get(j);
				if(position == 2 || position == 6)
				{
					if(!temp.equals("none"))
					{
							temp = EgCrypt.encrypt(temp);
					}
							iniValue = iniValue+temp+"~|~";		
				}
				else
				{
					iniValue = iniValue+temp+"~|~";
				}
				position = position+1;
			
			}
		
			if(iniValue != null)
			{
				iniValue = iniValue.substring(0, iniValue.lastIndexOf("~|~"));
				backupMailconfig.setValue(subject,variable,iniValue);
				backupMailconfig.saveFile();
			}

		}
	}
	else 
	{
		
        Vector sVal = new Vector(); 
		sVal = uiObject.getVariables(subject,true);
		if(sVal != null)
		{
			Enumeration e = sVal.elements();
			while(e.hasMoreElements())
			{
				String var = e.nextElement().toString();
				backupMailconfig.deleteSpecValue(subject,var);
				backupMailconfig.saveFile();
			} 
		}
	}
	String clearBckSet = request.getParameter("clearBckSet");
	if (clearBckSet == null)
	{
		clearBckSet = "";
	}

	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.Backup mail server settings"));
	if (clearBckSet.equals("true"))
	{
		resultMsg.put("message1",_mapping.getTextDescription("admin.title.Backup mail server settings have been removed successfully")+".");
	}
	else
	{
		resultMsg.put("message1",_mapping.getTextDescription("admin.title.Backup mail server settings have been configured successfully")+".");
	}
	rootJson.put("result",resultMsg);

	System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
}
catch(Exception e)
{
	e.printStackTrace();
}
%>



