<%
/*******************************************************************************
*	Name				:	EgConfigLogoMsgJSON.jsp
*	Purpose				:	This jsp is used to configure custom logo and messages.
*	Version				:	eG 6.0
*	CreationDate		:	13/11/2013
*	Author				:	Abdul Khader
*******************************************************************************/
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>

<%@ page import="com.eg.EgInstallInfo" %>
<%@ page import = "com.eg.EgDbInfo"%>
<%@ page import="com.egurkha.*" %>
<%@ page import="com.egurkha.ini.IniUI" %>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="egurkha.TransactionBean" %>
<%@ page import="java.io.*" %>
<%@ page import = "net.sf.json.*" %>
<%@ page import = "com.egurkha.util.StringUtils" %>

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	boolean isDouble=EgDbInfo.doubleByteEnabled;
%>
<%
	JSONObject rootJson = new JSONObject();
	JSONObject loginScreenJson = new JSONObject();
	JSONObject monitorInterfaceJson = new JSONObject();
	JSONObject reporterInterfaceJson = new JSONObject();
	JSONObject configMgmtInterfaceJson = new JSONObject();
	JSONObject audibleAlertsJson = new JSONObject();
	JSONObject messagesJson = new JSONObject();

	JSONArray availableModulesJson = new JSONArray();

	HttpSession sessionForSkin = request.getSession();
	String sessionId = sessionForSkin.getId();
	User userForAdmin = null;
	String adminSkin=null;
	try
	{
		userForAdmin = UserRegistry.getInstance().getUser(sessionId);
		adminSkin = userForAdmin.getAdminSkin();
	}
	catch(Exception e)
	{
		adminSkin ="blue";
	}
	rootJson.put("isDouble",isDouble);
	rootJson.put("adminSkin",adminSkin);

	User user = registry.getUser(session.getId());
	EgUserRole userRole = user.getUserRole();
	boolean hasMonitorTab = userRole.hasAnyMonitorRole(EgUserPermission.MONITOR);
	boolean hasReporterTab = userRole.hasAnyReporterRole(EgUserPermission.REPORTER);
	boolean hasConfigTab = userRole.hasAnyConfigRole(EgUserPermission.CONFIG);

	String[] availableUIArr={"monitor","reporter","configMgmt"};
	ArrayList availableUIList = new ArrayList();

	egurkha.TransactionBean configmsg = new egurkha.TransactionBean();

	String process = request.getParameter("process");
	process = (process == null ?"" :process);
	String from = request.getParameter("from");
	from = (from == null ? "" : from);
	configmsg.createFile("eg_ui.ini");

	String loginImageUploadStatus = "NotUploaded";
	String loginCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_LOGIN_LOGO");
	File loginCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/admin/eg_images/"+loginCustomGifFileName);

	String monitorImageUploadStatus = "NotUploaded";
	String monitorCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_MONITOR_LOGO");
	File monitorCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/monitor/eg_images/"+monitorCustomGifFileName);

	String audibleAlertUploadStatus = "NotUploaded";
	File audibleAlertSoundFiles = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/monitor/eg_waves");
	String[] listOfSoundFiles = audibleAlertSoundFiles.list();
	for (int i=0; i<listOfSoundFiles.length; i++)
	{
		if(listOfSoundFiles[i].startsWith("custom-"))
		{
			audibleAlertUploadStatus = "Uploaded";
			break;
		}
	}

	String reporterImageUploadStatus = "NotUploaded";
	if (EgInstallInfo.isReporterSupported)
	{
		String reporterCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_REPORTER_LOGO");
		File reporterCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/reporter/images/"+reporterCustomGifFileName);
	}

	String configMgmtImageUploadStatus = "NotUploaded";
	if (EgInstallInfo.isConfigSupported)
	{
		String configMgmtCustomGifFileName = configmsg.getStrValue("LOGOS", "CUSTOM_CONFIG_LOGO");
		File configMgmtCustomGifFile = new File(EgInstallInfo.getInstallDir()+"/manager/tomcat/webapps/final/config/images/"+configMgmtCustomGifFileName);
	}
	String tableWidth="";
	if(trackerLanguage!=null && (trackerLanguage.equals("en_US") || trackerLanguage.equals("ch_CH") || trackerLanguage.equals("ja_JP") || trackerLanguage.equals("ko_KR") || trackerLanguage.equals("th_TH")))
	{
		tableWidth="95%";
	}
	else if(trackerLanguage!=null && (trackerLanguage.equals("fr_FR") || trackerLanguage.equals("de_DE") || trackerLanguage.equals("es_ES") || trackerLanguage.equals("it_IT") || trackerLanguage.equals("pt_BR")))
	{
		tableWidth="97%";
	}

	configmsg.createFile("eg_services.ini");
	String caption = configmsg.getStrValue("MISC_ARGS", "LogoText");
	String mess1 = configmsg.getStrValue("MISC_ARGS","LicenseExpiredMess");
	String messLicense1 = StringUtils.replace(mess1,"&#46;",".");
	String mess2 = configmsg.getStrValue("MISC_ARGS","LicenseExpiryMess");
	String messLicense2 = StringUtils.replace(mess2,"&#46;",".");
	String mess3 = configmsg.getStrValue("MISC_ARGS","LicenseExpiryMailMessage");
	String messLicense3 = StringUtils.replace(mess3,"&#46;",".");
	String mailid = configmsg.getStrValue("MISC_ARGS","LicenseMgrMailid");

	IniUI ui = IniUI.getInstance();
	String monitorbgcolor = ui.getLogo(IniUI.MONITOR);
	String adminbgcolor = ui.getLogo(IniUI.LOGIN);
	String repImageOption = ui.getLogo(IniUI.REPORTER);
	String configImageOption = ui.getLogo(IniUI.CONFIG);
	String alarmOption = ui.getAlarmOption();

	String customSelected=(alarmOption.equals("CUSTOM"))?"checked":"";
	String defaultSelected=(alarmOption.equals("DEFAULT"))?"checked":"";
	String noneSelected=(alarmOption.equals("NONE"))?"checked":"";

	String  selectedOptions = "NONE";
	String  selectedOptionsOfConfigMgmt = "NONE";
	String  customStr = null,
			defaultStr = null,
			noneStr = null,

			repCustom = null,
			repDefault = null,
			repNone = null,

			configCustom = null,
			configDefault = null,
			configNone = null,

			loginYesStr = null,
			loginNoStr = null;

	if (monitorbgcolor != null && monitorbgcolor.equalsIgnoreCase("CUSTOM"))
	{
		customStr = "checked";
		defaultStr = "";
		noneStr = "";
	}
	else if (monitorbgcolor != null && monitorbgcolor.equalsIgnoreCase("DEFAULT"))
	{
		customStr = "";
		defaultStr = "checked";
		noneStr = "";
	}
	else
	{
		customStr = "";
		defaultStr = "";
		noneStr = "checked";
	}

	if (adminbgcolor != null && adminbgcolor.equalsIgnoreCase("YES"))
	{
		loginYesStr = "checked";
		loginNoStr = "";
	}
	else
	{
		loginYesStr = "";
		loginNoStr = "checked";
	}
	loginScreenJson.put("loginYesStr",loginYesStr);
	loginScreenJson.put("loginNoStr",loginNoStr);

	if (StringUtils.isNull(repImageOption) || repImageOption.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		repImageOption = EgConstants.DEFAULT;
	}
	
	if (StringUtils.isNull(configImageOption) || configImageOption.equalsIgnoreCase(EgConstants.NULL_STRING))
	{
		configImageOption = EgConstants.DEFAULT;
	}

	if (repImageOption.equalsIgnoreCase(EgConstants.NONE))
	{
		selectedOptions = "NONE";
		repCustom = "";
		repDefault = "";
		repNone = " checked ";
	}
	else if (repImageOption.equalsIgnoreCase(EgConstants.DEFAULT))
	{
		selectedOptions = "DEFAULT";
		repCustom = "";
		repDefault = " checked ";
		repNone = "";
	}
	else
	{
		selectedOptions = "CUSTOM";
		repCustom = " checked ";
		repDefault = "";
		repNone = "";
	}

	if(configImageOption.equalsIgnoreCase(EgConstants.NONE))
	{
		selectedOptionsOfConfigMgmt = "NONE";
		configCustom = "";
		configDefault = "";
		configNone = " checked ";
	}
	else if (configImageOption.equalsIgnoreCase(EgConstants.DEFAULT))
	{
		selectedOptionsOfConfigMgmt = "DEFAULT";
		configCustom = "";
		configDefault = " checked ";
		configNone = "";
	}
	else
	{
		selectedOptionsOfConfigMgmt = "CUSTOM";
		configCustom = " checked ";
		configDefault = "";
		configNone = "";
	}

	String monpath = ui.getAbsoluteImagePath("/final/monitor/eg_images/");
	String admpath = ui.getAbsoluteImagePath("/final/admin/eg_images/");
	String reppath = ui.getAbsoluteImagePath("/final/reporter/images/");
	String configpath = ui.getAbsoluteImagePath("/final/config/images/");

	for(int i=0;i<availableUIArr.length;i++)
	{
		String tmpUIVal = availableUIArr[i];
		if(tmpUIVal.equals("monitor") && hasMonitorTab)
		{
			availableUIList.add(tmpUIVal);
			availableModulesJson.add(tmpUIVal);
		}
		else if(tmpUIVal.equals("reporter") && hasReporterTab)
		{
			availableUIList.add(tmpUIVal);
			availableModulesJson.add(tmpUIVal);
		}
		else if(tmpUIVal.equals("configMgmt") && hasConfigTab)
		{
			availableUIList.add(tmpUIVal);
			availableModulesJson.add(tmpUIVal);
		}
	}

	session.setAttribute("availableUIList",availableUIList);

	if(process.equals("") || process.equals("loginscreen"))
	{
		String adminCustomImage = ui.getValue("LOGOS","CUSTOM_LOGIN_LOGO");
		rootJson.put("adminCustomImage",adminCustomImage);
		loginScreenJson.put("adminCustomImage",adminCustomImage);
		loginScreenJson.put("loginImageUploadStatus",loginImageUploadStatus);
	}

	if(process.equals("") || process.equals("monitorinterface"))
	{
		String monitorCustomImage = ui.getValue("LOGOS","CUSTOM_MONITOR_LOGO");
		monitorInterfaceJson.put("monitorCustomImage",monitorCustomImage);
		monitorInterfaceJson.put("customStr",customStr);
		monitorInterfaceJson.put("defaultStr",defaultStr);
		monitorInterfaceJson.put("noneStr",noneStr);
		monitorInterfaceJson.put("monitorImageUploadStatus",monitorImageUploadStatus);
	}
	if(process.equals("") || process.equals("reporterinterface")) 
	{
		if (EgInstallInfo.isReporterSupported)
		{
			String reporterCustomImage = ui.getValue("LOGOS","CUSTOM_REPORTER_LOGO");
			reporterInterfaceJson.put("reporterCustomImage",reporterCustomImage);
			reporterInterfaceJson.put("tableWidth",tableWidth);
			reporterInterfaceJson.put("repCustom",repCustom);
			reporterInterfaceJson.put("repDefault",repDefault);
			reporterInterfaceJson.put("repNone",repNone);
			reporterInterfaceJson.put("reporterImageUploadStatus",reporterImageUploadStatus);
			reporterInterfaceJson.put("selectedOptions",selectedOptions);
		}
	}
	if(process.equals("") || process.equals("configmanageinterface")) 
	{
		if (EgInstallInfo.isConfigSupported)
		{
			String configCustomImage = ui.getValue("LOGOS","CUSTOM_CONFIG_LOGO");
			configMgmtInterfaceJson.put("configCustomImage",configCustomImage);
			configMgmtInterfaceJson.put("configCustom",configCustom);
			configMgmtInterfaceJson.put("configDefault",configDefault);
			configMgmtInterfaceJson.put("configNone",configNone);
			configMgmtInterfaceJson.put("configMgmtImageUploadStatus",configMgmtImageUploadStatus);
			configMgmtInterfaceJson.put("selectedOptionsOfConfigMgmt",selectedOptionsOfConfigMgmt);
		}
	}
	if(process.equals("") || process.equals("audiblealerts")) 
	{
		audibleAlertsJson.put("customSelected",customSelected);
		audibleAlertsJson.put("defaultSelected",defaultSelected);
		audibleAlertsJson.put("noneSelected",noneSelected);
		audibleAlertsJson.put("audibleAlertUploadStatus",audibleAlertUploadStatus);
	}

	if(process.equals("") || process.equals("messages")) 
	{
		messagesJson.put("caption",caption);
		messagesJson.put("mess1",messLicense1);
		messagesJson.put("mess2",messLicense2);
		messagesJson.put("mess3",messLicense3);
		messagesJson.put("mailid",mailid);
	}			

	rootJson.put("loginScreenJson",loginScreenJson);
	rootJson.put("monitorInterfaceJson",monitorInterfaceJson);
	rootJson.put("reporterInterfaceJson",reporterInterfaceJson);
	rootJson.put("configMgmtInterfaceJson",configMgmtInterfaceJson);
	rootJson.put("audibleAlertsJson",audibleAlertsJson);
	rootJson.put("messagesJson",messagesJson);

	rootJson.put("availableModulesJson",availableModulesJson);

	if(from.equals("logotree"))
	{
		if(request.getQueryString()!=null)
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgLogoMessagesSettings.jsp");
		}
		else
		{
			session.setAttribute("adminLastAccessedURL","/final/admin/EgLogoMessagesSettings.jsp");
		}
	}
	else
	{
		session.setAttribute("adminLastAccessedURL","/final/admin/EgLogoMessagesSettings.jsp");
	}

	out.println(rootJson.toString());
%>




