<%
/*
 *	Name            :   UserNamesJson.jsp
 *	Purpose         :   To list all named users. 
 */
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>

<%@ page import="com.eg.EgUsersInfo"%>

<%@ page import="java.util.HashMap"%>
<%@ page import="java.util.List"%>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Date"%>
<%@ page import = "com.egurkha.util.DateUtil" %>


<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>

<%	
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();

	List csvData = new ArrayList();
	boolean isNamedUsers = EgInstallInfo.isnamedUserLicense;
	boolean isConcUsers = EgInstallInfo.isconcurrentUserLicense;
	//String from = request.getParameter("from");

	//if (from == null) 
	//{
	//	from = "NamedUsers";
	//}
	String date = request.getParameter("date");
	String currentValue = request.getParameter("currentValue");
	String datePick = request.getParameter("datePickVal");
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	com.eg.IniFile egUI = new com.eg.IniFile(s_iniFile_dir + uiFile);
	String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	String startDate = DateUtil.changeDateFormat(datePick,"MMM dd yyyy",currentDateFormat);
	EgUsersInfo usersInfo = new EgUsersInfo();
	HashMap users = new HashMap();

	if (isNamedUsers)
	{
		if(currentValue != null && currentValue.equals("peakUsage"))
		{
			csvData.add("Peak usage report ");
		}
		else
		{
			csvData.add("Named Users Report");
		}
	}
	else if(isConcUsers)
	{
		if(currentValue != null && currentValue.equalsIgnoreCase("peakUsage") && !currentValue.equalsIgnoreCase("null"))
		{
			csvData.add("Peak usage report ");
		}
		else
		{
			csvData.add("Concurrent Users Report");
		}
	}
	users = usersInfo.getUserNamesForTheDay(date);
	ArrayList ctxUsrs = (ArrayList)users.get("Citrix Users");
	ArrayList vdiUsrs = (ArrayList)users.get("VDI Users");
	ArrayList trmUsrs = (ArrayList)users.get("Terminal Users");

	if (ctxUsrs == null) ctxUsrs = new ArrayList();
	if (vdiUsrs == null) vdiUsrs = new ArrayList();
	if (trmUsrs == null) trmUsrs = new ArrayList();

	int ctxCnt = ctxUsrs.size();
	int vdiCnt = vdiUsrs.size();
	int trmCnt = trmUsrs.size();
	int totCnt = ctxCnt + vdiCnt + trmCnt;


	csvData.add("");
	csvData.add("\"Report Date: "+startDate+"\"");
	csvData.add("");	
	String tblHd = "";
	if (ctxCnt > 0)
	{
		csvData.add("Citrix users,"+ctxCnt+"");
		tblHd = "Citrix users";
	}
	if (vdiCnt > 0)
	{
		csvData.add("VDI users,"+vdiCnt+"");
		if (tblHd.length() > 0)
			tblHd += ",";
		tblHd += "VDI users";
	}
	if (trmCnt > 0)
	{
		csvData.add("Cloud/Terminal users,"+trmCnt+"");
		if (tblHd.length() > 0)
			tblHd += ",";
		tblHd += "Cloud/Terminal users";
	}
	if (isNamedUsers)
	{
		csvData.add("Total named users,"+totCnt+"");
	}
	else if(isConcUsers)
	{
		csvData.add("Total concurrent users,"+totCnt+"");
	}
	csvData.add("");
	csvData.add(tblHd);
	int bigSz = (ctxCnt > vdiCnt)?ctxCnt:vdiCnt;
	bigSz = (bigSz > trmCnt)?bigSz:trmCnt;
	String rowData = "";
	for (int b=0; b<bigSz; b++)
	{
		rowData = "";
		if (ctxCnt > 0 && ctxCnt > b)
		{
			rowData = ctxUsrs.get(b).toString();
		}
		if (vdiCnt > 0 )
		{
			//if (rowData.length() > 0)
			if(ctxCnt > 0)
				rowData += ",";

			if (vdiCnt > b)
				rowData += vdiUsrs.get(b).toString();
		}
		if (trmCnt > 0)
		{
			if(vdiCnt > 0 || rowData.length() > 0 || ctxCnt > 0)
				rowData += ",";

			if (trmCnt > b)
				rowData += trmUsrs.get(b).toString();
		}
		csvData.add(rowData);
	}

	session.setAttribute("list",csvData);
	session.setAttribute("isAuditlogCSV","true");
	

	rootJSON.put("date",date);
	rootJSON.put("datePick",datePick);
	rootJSON.put("ctxCount",ctxCnt);
	rootJSON.put("vdiCount",vdiCnt);
	rootJSON.put("trmCount",trmCnt);
	rootJSON.put("totCount",totCnt);

	JSONArray jsonArr = new JSONArray();
	if(ctxCnt%3 == 1)
	{
		ctxUsrs.add("");
		ctxUsrs.add("");
	}
	else if (ctxCnt%3 == 2)
	{
		ctxUsrs.add("");
	}
	for(int c=0; c<ctxCnt; c+=3)
	{		
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("col_1",ctxUsrs.get(c).toString());
		tmpObj.put("col_2",ctxUsrs.get(c+1).toString());
		tmpObj.put("col_3",ctxUsrs.get(c+2).toString());
		jsonArr.add(tmpObj);
	}
	rootJSON.put("ctxUsers",jsonArr);
	
	jsonArr = new JSONArray();
	if(vdiCnt%3 == 1)
	{
		vdiUsrs.add("");
		vdiUsrs.add("");
	}
	else if (vdiCnt%3 == 2)
	{
		vdiUsrs.add("");
	}
	for(int c=0; c<vdiCnt; c+=3)
	{		
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("col_1",vdiUsrs.get(c).toString());
		tmpObj.put("col_2",vdiUsrs.get(c+1).toString());
		tmpObj.put("col_3",vdiUsrs.get(c+2).toString());
		jsonArr.add(tmpObj);
	}
	rootJSON.put("vdiUsers",jsonArr);

	jsonArr = new JSONArray();
	if(trmCnt%3 == 1)
	{
		trmUsrs.add("");
		trmUsrs.add("");
	}
	else if (trmCnt%3 == 2)
	{
		trmUsrs.add("");
	}
	for(int c=0; c<trmCnt; c+=3)
	{		
		JSONObject tmpObj = new JSONObject();
		tmpObj.put("col_1",trmUsrs.get(c).toString());
		tmpObj.put("col_2",trmUsrs.get(c+1).toString());
		tmpObj.put("col_3",trmUsrs.get(c+2).toString());
		jsonArr.add(tmpObj);
	}
	rootJSON.put("trmUsers",jsonArr);

	out.println(rootJSON);
%>