<%
/*
 *	Name            :   EgLicenseInfoJson.jsp
 *	Purpose         :   To view license information. 
 *  Navigation		:	Home > [Click here to get the license details]
 */
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="java.util.ArrayList"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="java.util.HashMap"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgServerList"%>
<%@ page import="com.eg.EgLicenseInfo"%>
<%@ page import="com.eg.EgUsersInfo"%>
<%@ page import="com.eg.EgDbInfo"%>
<%@ page import="com.eg.EgConfigInfo"%>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="egurkha.reporter.ErUtils"%>
<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="net.sf.json.JSONArray"%>
<%@ page import="java.text.*"%>
<%@ page import="com.egurkha.util.DateUtil"%>
<%@ page import="com.egurkha.*" %>
<%@ page import = "com.egurkha.ini.IniUI"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	JSONObject rootJSON = new JSONObject();

	String s_iniFileDir = EgInstallInfo.getInstallDir();
	String strCommand = s_iniFileDir + "/bin/viewCert" + " " + s_iniFileDir + "/bin/license";
	com.egurkha.util.EgUtilities egutil =  com.egurkha.util.EgUtilities.createInstance();
	ArrayList al = egutil.getExecOutputLines(strCommand);
	if (al == null || al.size() < 2)	return;
	ArrayList bl = (ArrayList) al.get(0);
	if (bl == null || bl.size() == 0)	return;

	boolean isNamedUsersCert = EgInstallInfo.isnamedUserLicense;
	boolean isConcUsersCert = EgInstallInfo.isconcurrentUserLicense;
	String uiFile = "eg_ui.ini";
	String s_iniFile_dir = EgInstallInfo.getInstallDir()+ "/manager/config/";
	IniFile egUI = new IniFile(s_iniFile_dir + uiFile);
	EgUsersInfo usersInfo = new EgUsersInfo();
	ArrayList peakUsageData = usersInfo.getPeakUsageValuesForPreviusMonth();
	IniUI iniUI = IniUI.getInstance();
	String trac_currentDateFormat = iniUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
	boolean isNamedUsers = EgInstallInfo.isnamedUserLicense;
	boolean isConcUsers = EgInstallInfo.isconcurrentUserLicense;

	String line="";
	ArrayList aListLicenseEntries=new ArrayList();
	for (int r = 0; r<bl.size(); r++)
	{
		line = (String) bl.get(r);
		if(line.length()==0)
		{
			continue;
		}
		aListLicenseEntries.add(line);
	}
	HashMap infoMap = new HashMap();
	for(int i=0; i<aListLicenseEntries.size(); i++)
	{
		String eleme = (String)aListLicenseEntries.get(i);
		int index = eleme.indexOf(":");
		if(index > 0)
		{
			String info=(eleme.substring(0,index)).trim();
			String value=eleme.substring(index+1);
			if(value.indexOf("Not Applicable") >= 0||(value.trim().startsWith("-")))
			{
				value = "-";
			}
			infoMap.put(info,value.trim());
		}
	}

	String NumberOfAgents = (String)infoMap.get("No of Monitors");
	String NumberOfBasicAgents = (String)infoMap.get("No of Basic Monitors");
	String NoofApplications = (String)infoMap.get("No of Applications");
	String NoofTargets= (String)infoMap.get("No of Monitored Targets");
	String NoofNetworkDevices = (String)infoMap.get("No of Network Devices");
	String Services = (String)infoMap.get("No of Web Sites");
	String segments = (String)infoMap.get("No of Segments");
	String TotalUser = (String)infoMap.get("No of Monitor Users");
	String NumberOfExternalAgents = (String)infoMap.get("No of External Agents");
	String currentDateTime = (String) infoMap.get("Expiry Date");
	String destDate = "";
	if (currentDateTime != null && !currentDateTime.equals("No expiry date set"))
	{
		//Convert expiry date to user timezone - Start
		SimpleDateFormat sourceformatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy");
		ParsePosition pos = new ParsePosition(0);
		Date parsedDate = sourceformatter.parse(currentDateTime, pos);

		Calendar calObj = Calendar.getInstance();
		calObj.setTime(parsedDate);
		String s_date = checkDate(calObj.get(Calendar.DATE));
		String s_month = checkDate(calObj.get(Calendar.MONTH)+1);
		String s_hourofday = checkDate(calObj.get(Calendar.HOUR_OF_DAY));
		String s_min = checkDate(calObj.get(Calendar.MINUTE));
		String s_sec = checkDate(calObj.get(Calendar.SECOND));
		String s_year = ""+calObj.get(Calendar.YEAR);

		destDate = s_month+"-"+s_date+"-"+s_year;
		String destTime = s_hourofday+":"+s_min+":"+s_sec;

		String currentDateFormat = egUI.getValue("CURRENT_DATE_FORMAT","selectedDateFormat");
		String userDtFormat = _user.getUserDateFormat();
		if (userDtFormat != null && userDtFormat.equalsIgnoreCase("default"))
		{
			userDtFormat = currentDateFormat;
		}
		if(DateUtil.isDate(destDate,"MM-dd-yyyy"))
		{
			destDate = DateUtil.changeDateFormat(destDate,"MM-dd-yyyy",currentDateFormat);
			EgTimeZoneConverter egtc = new EgTimeZoneConverter(destDate+" "+destTime, _user);
			destDate = egtc.getDateTime();
		}
		//Convert expiry date to user timezone - End
	}
	else
	{
		destDate = currentDateTime;
	}

	rootJSON.put("product",infoMap.get("Product"));
	rootJSON.put("version",infoMap.get("Version"));
	rootJSON.put("IPAddress",infoMap.get("IP Address"));
	rootJSON.put("hostID",infoMap.get("Host ID"));
	rootJSON.put("expDate",destDate);

	egurkha.ConfigSiteBean csb = new egurkha.ConfigSiteBean();
	String numDaysStr="";
	int numDays = csb.lcatInt();
	if(numDays == -1)
		numDaysStr = "Infinite days";
	else
		numDaysStr = numDays + " day(s)";
	rootJSON.put("licIsValidFor",numDaysStr);

	IniFile services=new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_services.ini");
	String Mail_sender=services.getValue("MISC_ARGS","MailSender");
	if(Mail_sender.equals(""))
		Mail_sender="license@eginnovations.com";
	else
		Mail_sender=Mail_sender;
	rootJSON.put("mailSenderID",Mail_sender);

	rootJSON.put("clusterType",infoMap.get("Cluster Type"));
	//To show cluster details - [primary and secondary manager details] - STARTS HERE
	boolean isClusterSupported = EgInstallInfo.isClusterSupported;
	if(isClusterSupported)
	{
		String primaryManager = "";
		String secondaryManager = "";
		IniFile mgrIni = new IniFile(EgConfigInfo.egMgrConfigDir + "eg_managers.ini");
		String[] primaryMgr = mgrIni.getVariables("PRIMARY");
		String[] secondaryMgrs = mgrIni.getVariables("SECONDARY");
		if(primaryMgr != null && primaryMgr.length > 0)
		{
			primaryManager = primaryMgr[0];
		}
		else
		{
			primaryManager = "-";
		}
		if(secondaryMgrs != null && secondaryMgrs.length > 0)
		{
			for(int k=0; k<secondaryMgrs.length;k++)
			{
				secondaryManager += secondaryMgrs[k] + ", ";
			}
			secondaryManager = secondaryManager.substring(0,(secondaryManager.length()-2));
		}
		else
		{
			secondaryManager = "-";
		}
		rootJSON.put("primaryManager",primaryManager);
		rootJSON.put("secondaryManager",secondaryManager);
	}
	else
	{
		rootJSON.put("primaryManager","-");
		rootJSON.put("secondaryManager","-");
	}
	//To show cluster details - [primary and secondary manager details] - ENDS HERE
	rootJSON.put("IC",infoMap.get("Integration Console"));
	rootJSON.put("TTMgr",infoMap.get("Trouble Ticket Manager"));
	rootJSON.put("DD",infoMap.get("Detailed Diagnosis"));
	rootJSON.put("extSuperMgr",infoMap.get("External Supermanager"));
	rootJSON.put("eGSuperMgr",infoMap.get("eG Supermanager Support"));
	rootJSON.put("eGReporter",infoMap.get("eG Reporter"));
	rootJSON.put("rmtCtrlActs",infoMap.get("Remote Control Activities"));
	rootJSON.put("SMSAlerts",infoMap.get("SMS Alerts"));
	rootJSON.put("configMgmt",infoMap.get("Configuration Management"));
	rootJSON.put("metricAgg",infoMap.get("Metric Aggregation"));
	rootJSON.put("agentPerSys",infoMap.get("Agent Per System"));
	rootJSON.put("clientEmul",infoMap.get("Client Emulation"));
	
	egurkha.UserBean user = new egurkha.UserBean();
	ArrayList aListAgentDataTemp = serverList.getAgentListFromDB();

	int available = 0;
	int RunTotal=0;
	int NotRunTotal=0;
	ArrayList temp = new ArrayList();
	Hashtable list = new Hashtable();
	List csvData = new ArrayList();
	String csvRow = " " ;
	String csvRow2 = " " ;
	int numHosts = user.getBasicMonitorsCount() + user.getPremiumMonitorsCount(); // Total used agents

	temp = user.getPremiumAgents();	
	list = FindRunningNotRunning(temp,aListAgentDataTemp);
	int basedPremiRun=((ArrayList)list.get("Running")).size();
	int basedPremiNotRun=((ArrayList)list.get("NotRunning")).size();
	
	temp = user.agentlessPremium();
	list = FindRunningNotRunning(temp,aListAgentDataTemp);
	int alpremiRun=((ArrayList)list.get("Running")).size();
	int alpremiNotRun=((ArrayList)list.get("NotRunning")).size();
	int runPremium = basedPremiRun+alpremiRun;
	int notrunPremium = basedPremiNotRun+alpremiNotRun;
	
	temp = user.getCurrentBasicAgents();
	int numBasicAgent=temp.size();
	list = FindRunningNotRunning(temp,aListAgentDataTemp);
	int RunBasic=((ArrayList)list.get("Running")).size();
	int NotRunBasic=((ArrayList)list.get("NotRunning")).size();	
	
	temp = user.agentlessBasic();
	list = FindRunningNotRunning(temp,aListAgentDataTemp);
	int numBasicAlCount=temp.size();//  change:2     => values interchange(running<=>notRunning)
	int albrun=((ArrayList)list.get("Running")).size();
	int albNotrun=((ArrayList)list.get("NotRunning")).size();
	int runBasic = RunBasic+albrun;
	int notrunBasic = NotRunBasic+albNotrun;

	RunTotal = runPremium+runBasic;
	NotRunTotal = notrunPremium+notrunBasic;
	JSONArray grid1 = new JSONArray();
	JSONObject tmpObj = null;

	//If basic comps exceeds the allowed count then it will consume premium license if exist.
	int basic_used = user.getBasicMonitorsCount();
	int used_Primium = user.getPremiumMonitorsCount();
	if (!NumberOfBasicAgents.equals("-"))
	{
		int allowedBasic = Integer.parseInt(NumberOfBasicAgents);
		if (basic_used > allowedBasic)
		{
			used_Primium += (basic_used-allowedBasic);
			basic_used  = allowedBasic;		
		}
	}
	String repTitle = "Total License Usage Report";
	String colHeads =  "Attribute,Allowed,Currently Used,Available,Current Usage(%),Running,Not Running";
	csvData.add(repTitle);
	csvData.add("");
	csvData.add(colHeads);
	csvData.add("");
	//Total Monitors
	if(NumberOfAgents.equals("-"))
	{
		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Total Monitors");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Total Monitors"));
		tmpObj.put("Allowed","-");
		tmpObj.put("Used",numHosts+"@#@Total Monitors");
		tmpObj.put("Available","-");
		tmpObj.put("Usage","-");
		tmpObj.put("Running",RunTotal+"");
		tmpObj.put("NotRunning",NotRunTotal+"");
		csvRow = attrName+","+"-"+","+numHosts+","+"-"+","+"-"+","+RunTotal+","+NotRunTotal;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	else
	{
		String val1=cal(NumberOfAgents,numHosts);
		available = Integer.parseInt(NumberOfAgents) - numHosts;
		if(available < 0) available=0;
	
		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Total Monitors");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Total Monitors"));
		tmpObj.put("Allowed",NumberOfAgents+"");
		tmpObj.put("Used",numHosts+"@#@Total Monitors");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val1+"");
		tmpObj.put("Running",RunTotal+"");
		tmpObj.put("NotRunning",NotRunTotal+"");
		csvRow =attrName+","+NumberOfAgents+","+numHosts+","+available+","+val1+","+RunTotal+","+NotRunTotal;
		csvData.add(csvRow);
		grid1.add(tmpObj);		
	}
	//Premium Monitors
	
	if(NumberOfAgents.equals("-")||NumberOfBasicAgents.equals("-"))
	{
		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Premium Monitors");
		tmpObj.put("Attribute","&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.license.Premium Monitors"));
		tmpObj.put("Allowed","-");
		tmpObj.put("Used",used_Primium+"@#@Premium Monitors");
		tmpObj.put("Available","-");
		tmpObj.put("Usage","-");
		tmpObj.put("Running",runPremium+"");
		tmpObj.put("NotRunning",notrunPremium+"");
		csvRow = attrName+","+"-"+","+used_Primium+","+"-"+","+"-"+","+runPremium+","+notrunPremium;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	else
	{
		int premiumAllowed=0;
		String allow_Premium="-";
		String primi_percent ="-";
		if(Integer.parseInt(NumberOfAgents)>=Integer.parseInt(NumberOfBasicAgents))
		{
			premiumAllowed=Integer.parseInt(NumberOfAgents)-Integer.parseInt(NumberOfBasicAgents);
			allow_Premium=new Integer(premiumAllowed).toString();
			primi_percent=cal(allow_Premium,used_Primium);
			available = Integer.parseInt(allow_Premium) - used_Primium;
		}
		else
		{
			available = -1;
		}
		if(available < 0)
			available=0;

		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Premium Monitors");
		tmpObj.put("Attribute","&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.license.Premium Monitors"));
		tmpObj.put("Allowed",allow_Premium+"");
		tmpObj.put("Used",used_Primium+"@#@Premium Monitors");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",primi_percent+"");
		tmpObj.put("Running",runPremium+"");
		tmpObj.put("NotRunning",notrunPremium+"");
		csvRow = attrName+","+allow_Premium+","+used_Primium+","+available+","+primi_percent+","+runPremium+","+notrunPremium;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	//Basic Monitors
	
	if(NumberOfAgents.equals("-") || NumberOfBasicAgents.equals("-"))
	{
		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Basic Monitors");
		tmpObj.put("Attribute","&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.license.Basic Monitors"));
		tmpObj.put("Allowed","-");
		tmpObj.put("Used",basic_used+"@#@Basic Monitors");
		tmpObj.put("Available","-");
		tmpObj.put("Usage","-");
		tmpObj.put("Running",runBasic+"");
		tmpObj.put("NotRunning",notrunBasic+"");
		csvRow = attrName+","+"-"+","+basic_used+","+"-"+","+"-"+","+runBasic+","+notrunBasic;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	else
	{
		String basic_Percent=cal(NumberOfBasicAgents,basic_used);
		available = Integer.parseInt(NumberOfBasicAgents) - basic_used;
		if(available < 0) available=0;

		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Basic Monitors");
		tmpObj.put("Attribute","&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.license.Basic Monitors"));
		tmpObj.put("Allowed",NumberOfBasicAgents+"");
		tmpObj.put("Used",basic_used+"@#@Basic Monitors");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",basic_Percent+"");
		tmpObj.put("Running",runBasic+"");
		tmpObj.put("NotRunning",notrunBasic+"");
		csvRow = attrName+","+NumberOfBasicAgents+","+basic_used+","+available+","+basic_Percent+","+runBasic+","+notrunBasic;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	
	//External Agents
	EgLicenseInfo licInfo = new EgLicenseInfo();
	int extAgentsCount = user.getExternalAgentCount();
	temp = licInfo.getExternalAgents();
	Hashtable p1=FindRunningNotRunning(temp,aListAgentDataTemp);
	int RunExternal=((ArrayList)p1.get("Running")).size();
	int NotRunExternal=((ArrayList)p1.get("NotRunning")).size();

	if (!NumberOfExternalAgents.equals("-"))
	{
		String val4=cal(NumberOfExternalAgents,extAgentsCount);
		available = Integer.parseInt(NumberOfExternalAgents) - extAgentsCount;
		if(available < 0) available=0;
		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.External Agents");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.External Agents"));
		tmpObj.put("Allowed",NumberOfExternalAgents+"");
		tmpObj.put("Used",extAgentsCount+"@#@External Agents");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val4+"");
		tmpObj.put("Running",RunExternal+"");
		tmpObj.put("NotRunning",NotRunExternal+"");
		csvRow = attrName+","+NumberOfExternalAgents +","+extAgentsCount+","+available+","+val4+","+RunExternal+","+NotRunExternal;
		csvData.add(csvRow);
		grid1.add(tmpObj);
	}
	rootJSON.put("grid1",grid1);
	JSONArray grid2 = new JSONArray();
	csvData.add("");
	String colHeads2 =  "Attribute,Allowed,Currently Used,Available,Current Usage(%)";
	csvData.add(colHeads2);
	csvData.add("");
	//Monitored Targets
	int numMonTargets = user.getManagedIpCount();
	if(!NoofTargets.equals("-"))
	{
		String val4=cal(NoofTargets,numMonTargets);

		available = Integer.parseInt(NoofTargets) - numMonTargets;
		if(available < 0) available=0;
		String attrName = _mapping.getTextDescription("admin.license.Monitored Targets");
		tmpObj = new JSONObject();
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Monitored Targets"));
		tmpObj.put("Allowed",NoofTargets+"");
		tmpObj.put("Used",numMonTargets+"@#@Monitored Targets");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val4+"");
		csvRow2 = attrName + "," +NoofTargets + "," +numMonTargets + "," +available + "," + val4 ;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	//Applications
	int numAppCount = user.getAppCount();
	if(!NoofApplications.equals("-"))
	{
		String val4=cal(NoofApplications,numAppCount);

		available = Integer.parseInt(NoofApplications) - numAppCount;
		if(available < 0) available=0;
		String attrName =  _mapping.getTextDescription("admin.license.Applications");
		tmpObj = new JSONObject();
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Applications"));
		tmpObj.put("Allowed",NoofApplications+"");
		tmpObj.put("Used",numAppCount+"@#@Applications");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val4+"");
		csvRow2 = attrName + "," +NoofApplications + "," +numAppCount + "," +available +"," +val4;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	//Network Devices
	int netDeviceCount = user.getNetDeviceCount();
	if(!NoofNetworkDevices.equals("-"))
	{
		String val5=cal(NoofNetworkDevices,netDeviceCount);
		available = Integer.parseInt(NoofNetworkDevices) - netDeviceCount;
		if(available < 0) available=0;
		String attrName = _mapping.getTextDescription("admin.license.Network Devices");
		tmpObj = new JSONObject();
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Network Devices"));
		tmpObj.put("Allowed",NoofNetworkDevices+"");
		tmpObj.put("Used",netDeviceCount+"@#@Network Devices");
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val5+"");
		csvRow2 = attrName + "," +NoofNetworkDevices + "," +netDeviceCount + "," +available +"," +val5;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	// Named Users 
	EgUsersInfo obj = new EgUsersInfo();
	EgDbInfo dbInfo = new EgDbInfo("manager");
	ArrayList aListData = null;
	ArrayList aListData1 = null;
	boolean showUsersCountInUI = false;
	String tmpValue = egUI.getValue("User_Cert","ShowUsersCountInUI");
	String calcAlwaysNamed = egUI.getValue("User_Cert","CalculateTotalAlways");
	String calcAlwaysCCusr = services.getValue("ConcurrentUsers_Report","RunAlways");
	String CCUsersCertCheck = services.getValue("ConcurrentUsers_Report","CCUsersCertCheck");
	if (tmpValue != null && (tmpValue.equalsIgnoreCase("yes") || tmpValue.equalsIgnoreCase("true")))
	{
		showUsersCountInUI = true;
	}
	if (!obj.isUserBasedLicense())
	{
		if (calcAlwaysNamed != null && (calcAlwaysNamed.equalsIgnoreCase("yes") || calcAlwaysNamed.equalsIgnoreCase("true"))) 
		{
			isNamedUsersCert = true;
		}
		else if (calcAlwaysCCusr != null && (calcAlwaysCCusr.equalsIgnoreCase("yes") || calcAlwaysCCusr.equalsIgnoreCase("true")))
		{
			isConcUsersCert = true;
		}
	}
	if (obj.isUserBasedLicense() || showUsersCountInUI)
	{
		aListData = obj.getRemoteUserCount();
		aListData1 = obj.getUserInfos(false);
		if (aListData == null || aListData.size() ==0)
		{
			aListData = obj.getRemoteUserCount(true);
		}
		if (aListData1  == null || aListData1.size() == 0)
		{
			aListData1 = obj.getUserInfos();
		}
	}
	/*
	aListData.add("8");
	aListData.add("10");
	aListData.add("80");

	aListData1.add("Citrix Users");
	aListData1.add("3");
	aListData1.add("10");
	aListData1.add("30");

	aListData1.add("Terminal Users");
	aListData1.add("3");
	aListData1.add("10");
	aListData1.add("30");

	//
	aListData1.add("VDI Users");
	aListData1.add("2");
	aListData1.add("10");
	aListData1.add("20");
	*/


	if(aListData!=null && aListData.size()>0)
	{
		//String strCompType = "Named Users";
		String count = (String)aListData.get(0);
		String AllowedCount = (String)aListData.get(1);
		String pctUsage = (String)aListData.get(2);
		double count_user = 0;				//Double.parseDouble(count);
		double count_AllowedCount = 0;		//Double.parseDouble(AllowedCount);
		double count_pctUsage = 0;			//Double.parseDouble(pctUsage);

		if (pctUsage!=null && pctUsage.equals("-1"))
		{
			pctUsage = "-";
		}
		String count_user_str = "-";
		String count_AllowedCount_str = "-";
		String avail_str = "-";
		count_user = Double.parseDouble(count);
		count_user_str = Math.round(count_user)+"";
		if (!AllowedCount.equals("-"))
		{
			
			count_AllowedCount = Double.parseDouble(AllowedCount);
			count_pctUsage = Double.parseDouble(pctUsage);
			
			count_AllowedCount_str = Math.round(count_AllowedCount)+"";
		}
		if(!pctUsage.equals("-"))
		{
			pctUsage = dbInfo.round(count_pctUsage,2);
		}
		if (count_pctUsage > 100)
		{
			pctUsage = ">100";
		}
		double avail = 0.0;
		if (!AllowedCount.equals("-"))
		{
			try{
				avail = Double.parseDouble(AllowedCount) - Double.parseDouble(count);
			}catch(Exception e){e.printStackTrace();}
			if (avail < 0.0)
			avail = 0.0;
			avail_str = Math.round(avail)+"";
		}
		rootJSON.put("namedUsr_ShowGraph",false);
		if(count !=null && !count.equals("0"))
		{
			rootJSON.put("namedUsr_ShowGraph",true);
		}
		
		tmpObj = new JSONObject();
		String attrName = " ";
		if (isNamedUsersCert)
		{
			attrName = _mapping.getTextDescription("admin.license.Named Users");
			tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Named Users"));
		}
		else if (isConcUsersCert)
		{
			attrName = _mapping.getTextDescription("admin.license.Concurrent Users");
			tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Concurrent Users"));

			if (CCUsersCertCheck != null && CCUsersCertCheck.equalsIgnoreCase("Citrix"))
			{
				rootJSON.put("CCUsersCertCheck",false);
			}
			else
			{
				rootJSON.put("CCUsersCertCheck",true);
			}
		}
		tmpObj.put("Allowed",count_AllowedCount_str);
		tmpObj.put("Used",count_user_str);		
		tmpObj.put("Available",avail_str);
		tmpObj.put("Usage",pctUsage);
		csvRow2 = attrName + "," +count_AllowedCount_str + "," +count_user_str + "," +avail_str +"," +pctUsage;
		csvData.add(csvRow2);
		grid2.add(tmpObj);

	}
	else if (obj.isUserBasedLicense())
	{
		tmpObj = new JSONObject();
		String attrName = " ";
		if (isNamedUsersCert)
		{
			attrName = _mapping.getTextDescription("admin.license.Named Users");
			tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Named Users"));
		}
		else if (isConcUsersCert)
		{
			attrName = _mapping.getTextDescription("admin.license.Concurrent Users");
			tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Concurrent Users"));

			if (CCUsersCertCheck != null && CCUsersCertCheck.equalsIgnoreCase("Citrix"))
			{
				rootJSON.put("CCUsersCertCheck",false);
			}
			else
			{
				rootJSON.put("CCUsersCertCheck",true);
			}
		}
		long getUserAllowedCount = obj.getUserAllowedCount();
		String zeroval = "0";
		tmpObj.put("Allowed",obj.getUserAllowedCount());
		tmpObj.put("Used","0");		
		tmpObj.put("Available",obj.getUserAllowedCount());
		tmpObj.put("Usage","0");
		csvRow2 = attrName + "," +getUserAllowedCount + "," +zeroval + "," +getUserAllowedCount +"," +zeroval;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
		
	}
	if(aListData1!=null && aListData1.size()>0)
	{
		for(int i=0;i<aListData1.size();i=i+4)
		{
			String strCompType = (String)aListData1.get(i);
			String count = (String)aListData1.get(i+1);
			String AllowedCount = (String)aListData1.get(i+2);
			String pctUsage = (String)aListData1.get(i+3);
			double count_user = Double.parseDouble(count);
			if(!pctUsage.equals("-"))
			{
				double pctUsageDou = Double.parseDouble(pctUsage);
				if (pctUsageDou > 100)
				{
					pctUsage = ">100";
				}
			}
			tmpObj = new JSONObject();
			String attrName = _mapping.getTextDescription("admin.license."+strCompType);
			tmpObj.put("Attribute","&nbsp;&nbsp;&nbsp;&nbsp;"+_mapping.getTextDescription("admin.license."+strCompType));
			tmpObj.put("Allowed","-");
			tmpObj.put("Used",Math.round(count_user)+"");		
			tmpObj.put("Available","-");
			tmpObj.put("Usage",pctUsage+"");
			csvRow2 =  attrName + "," +"-" + "," +Math.round(count_user)+ "," +"-" +"," +pctUsage+ " ";
			csvData.add(csvRow2);
			grid2.add(tmpObj);
		}
	}
	//Services
	EgConfigInfo configInfo = new EgConfigInfo("manager");
	IniFile iniFilePtr = new IniFile(configInfo.getTopologyFile());
	String [] subs = iniFilePtr.getVariables("WEB_SITE_MAPPING");
	int numSites = 0;
	if(subs != null)
	{
		numSites = subs.length;
	}
	if(!Services.equals("-"))
	{
		String val6=cal(Services,numSites);
		available = Integer.parseInt(Services) - numSites;
		if(available < 0) available=0;

		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Services");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Services"));
		tmpObj.put("Allowed",Services+"");
		tmpObj.put("Used",numSites+"@#@Services");		
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val6+"");
		csvRow2 = attrName + "," +Services + "," +numSites + "," +available +"," +val6;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	//Segments
	int numSegments = user.getSegmentCount();
	if(!segments.equals("-"))
	{
		String val7=cal(segments,numSegments);
		available = Integer.parseInt(segments) - numSegments;
		if(available < 0) available=0;

		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Segments");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Segments"));
		tmpObj.put("Allowed",segments+"");
		tmpObj.put("Used",numSegments+"@#@Segments");		
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val7+"");
		csvRow2 = attrName + "," +segments + "," +numSegments + "," +available +"," +val7;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	//Monitor Users
	int numMonUser = 0;
	if(user.setConnection().equalsIgnoreCase("CONNECTED"))
	{
		numMonUser = user.monUserCount();
	}
	if(!TotalUser.equals("-")) 
	{
		String val8=cal(TotalUser,numMonUser);
		available = Integer.parseInt(TotalUser) - numMonUser;
		if(available < 0) available=0;

		tmpObj = new JSONObject();
		String attrName = _mapping.getTextDescription("admin.license.Monitor Users");
		tmpObj.put("Attribute",_mapping.getTextDescription("admin.license.Monitor Users"));
		tmpObj.put("Allowed",TotalUser+"");
		tmpObj.put("Used",numMonUser+"@#@Monitor Users");		
		tmpObj.put("Available",available+"");
		tmpObj.put("Usage",val8+"");
		csvRow2 = attrName + "," +TotalUser + "," +numMonUser + "," +available +"," +val8;
		csvData.add(csvRow2);
		grid2.add(tmpObj);
	}
	rootJSON.put("grid2",grid2);

	//peakusage
	String peakUsgMsg = "";
	if (peakUsageData != null && peakUsageData.size() >= 2)
	{
		String peakUsgCnt = peakUsageData.get(0).toString();
		String peakUsgDate = peakUsageData.get(1).toString();
		if (peakUsgCnt != null && peakUsgCnt.trim().length() > 0 && peakUsgDate != null && peakUsgDate.trim().length() > 0)
		{
			int dotIdx = peakUsgCnt.indexOf(".");
			if (dotIdx > -1)
			{
				peakUsgCnt = peakUsgCnt.substring(0,dotIdx);
			}
			peakUsgDate = DateUtil.changeDateFormat(peakUsgDate,"yyyy-MM-dd HH:mm:ss",trac_currentDateFormat);
			if (isNamedUsers)
			{
				peakUsgMsg += "\"Peak usage last month was on "+peakUsgDate+". The peak value on this day was "+peakUsgCnt+" named users.\"";
				csvRow2 = peakUsgMsg;
				csvData.add("");
				csvData.add(csvRow2);
			}
			else
			{
				peakUsgMsg += "\"Peak usage last month was on "+peakUsgDate+". The peak value on this day was "+peakUsgCnt+" concurrent users.\"";
				csvRow2 = peakUsgMsg;
				csvData.add("");
				csvData.add(csvRow2);
			}
		}
	}
	rootJSON.put("grid2",grid2);
	session.setAttribute("list",csvData);
	user.releaseConnection(false);
	
	String[] opt=new String[11];
	opt=new String[]{"Any","1 day", "2 days", "3 days", "4 days", "5 days", "6 days","1 week","2 weeks","3 weeks","4 weeks","1 month"};
	JSONArray optArr = new JSONArray();
	for (int a=0; a < opt.length; a++)
	{
		tmpObj = new JSONObject();
		tmpObj.put("valueField",opt[a]);
		tmpObj.put("displayField",_mapping.getTextDescription("admin.license."+opt[a]));
		optArr.add(tmpObj);
	}
	int windowCount = obj.getWindowValue();
	String timeline = "2 weeks";
	if(windowCount !=0 && windowCount<7)
	{
		if(windowCount == 1)
		{
			timeline = Integer.toString(windowCount);
			timeline = timeline+" "+"day";
		}
		else
		{
			timeline = Integer.toString(windowCount);
			timeline = timeline+" "+"days";
		}
	}
	else if(windowCount==7)
	{
		timeline="1 week";
	}
	else if(windowCount !=0 && windowCount>=8)
	{
	  timeline="2 weeks";
	}
	rootJSON.put("timelines",optArr);
	rootJSON.put("timelineSelected",timeline);

	JSONArray modeArr = new JSONArray();
	tmpObj = new JSONObject();
	tmpObj.put("valueField","2D");
	tmpObj.put("displayField",_mapping.getTextDescription("admin.license.2D"));
	modeArr.add(tmpObj);
	tmpObj = new JSONObject();
	tmpObj.put("valueField","3D");
	tmpObj.put("displayField",_mapping.getTextDescription("admin.license.3D"));
	modeArr.add(tmpObj);
	rootJSON.put("modes",modeArr);

	out.println(rootJSON);
	
%>

<%
	session.setAttribute("adminLastAccessedURL","/final/admin/EgLicenseInfo.jsp");
%>
<%!
	ErUtils erutils=new ErUtils();
	EgServerList serverList = new EgServerList();	
	public String cal(String allow,double used)
	{
		String Total="";
		String allowasZero="-";
		try
		{
			if(allow.equals("-")) 
			return "";
			double val=-5;
			double Total_agent=Double.parseDouble(allow);
			if(Total_agent>0)
			{
				val=(100*used)/Total_agent;
				if(val==0||val>100)
				{
					Total="-";
				}
				else
				{
					Total=erutils.round (val, 2);
				}
			}
			else
			{
				return allowasZero;
			}
		}
		catch(Exception e)
		{
			System.out.println(e);
		}
		return Total;
	}
	//This method is used to find out Running and NotRunning agents.
	public Hashtable FindRunningNotRunning(ArrayList mn,ArrayList aListAgentData)
	{
		ArrayList list = new ArrayList();
		ArrayList totOutput = new ArrayList();
		ArrayList mm = new ArrayList(mn);
		Hashtable runandnot=new Hashtable();
		ArrayList result1 = new ArrayList();
		ArrayList result2 = new ArrayList();
		if(mm.size() > 0)
		{
			for(int i = 0; i < mm.size(); i++)
			{
				list.add(mm.get(i));
				totOutput.addAll(serverList.getAgentListNew(list,aListAgentData));
				list = new ArrayList();
			}
		}
		for(int k=1;k<totOutput.size();k=k+2)
		{
			String xx = (String)totOutput.get(k);
			if(xx.equals("Installed-Running"))
			{
				result1.add((String)totOutput.get(k-1));
			}
			else if(xx.equals("Not Installed-Not Running")||xx.equals("Installed-Not Running"))
			{
				result2.add((String)totOutput.get(k-1));
			}
		}
		runandnot.put("Running",result1);
		runandnot.put("NotRunning",result2);
		return runandnot;
	}

	public String checkDate(int dateValue)
	{
		String finalDate = "";
		if (dateValue < 10)
		{
			finalDate = "0"+dateValue;
		}
		else
		{
			finalDate = ""+dateValue;
		}
		return finalDate;
	}
%>



