<%
/***********************************************************************************************************
*
 *   File		:	EgIncludeExcludeComponentspJson.jsp
 *   Purpose	:	Processing page
************************************************************************************************************/
%>

<%@ include file = "../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import = "java.util.*" %>
<%@ page import = "java.net.URLEncoder" %>
<%@ page import = "com.eg.EgSpecsInfo" %>
<%@ page import = "com.egurkha.admin.IncludeExcludeComponents" %>
<%@ page import = "com.eg.EgUtils" %>
<%@ page import = "com.eg.EgCrypt" %>
<%@ page import = "com.eg.EgServicesInfo" %>
<%@ page import = "com.eg.EgURLEncoder"%>
<%@ page import = "com.eg.EgExternalInfo" %>
<%@ page import = "com.eg.EgConfigFilesSync"%>
<%@ page import = "com.eg.IniHelper"%>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "com.egurkha.admin.AuditLogThread"%>
<%@ page import = "net.sf.json.*"%>

<%@ page language = "java" contentType = "text/html; charset=UTF-8" pageEncoding = "UTF-8"%>

<jsp:useBean id="sBean" scope="page" class="egurkha.ServiceBean"/>

<%
	JSONObject rootJson = new JSONObject();
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	EgServicesInfo egServicesInfo = new EgServicesInfo("manager");
	EgSpecsInfo egSpecs = new EgSpecsInfo("manager");
	//ArrayList aListAuditlogTests = new ArrayList();

	String strComponentType = request.getParameter("componentType");
	if (strComponentType == null)
	{
		strComponentType = "";
	}

	String strSeletedTestList = request.getParameter("seletedTestList");
	if (strSeletedTestList == null)
	{
		strSeletedTestList = "";
	}

	String strTestName = "";
	String strIncludedCompList = request.getParameter("enabledCompList");
	if (strIncludedCompList == null)
	{
		strIncludedCompList = "";
	}

	String strExcludedCompList = request.getParameter("disabledCompList");
	if (strExcludedCompList == null)
	{
		strExcludedCompList = "";
	}

	Hashtable htableSessionTestWithExcludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithExcludedComponents");
	if (htableSessionTestWithExcludedComponents == null)
	{
		htableSessionTestWithExcludedComponents = new Hashtable();
	}
	Hashtable htableSessionTestWithIncludedComponents = (Hashtable)session.getAttribute("htableSessionTestWithIncludedComponents");
	if (htableSessionTestWithIncludedComponents == null)
	{
		htableSessionTestWithIncludedComponents = new Hashtable();
	}
	session.removeAttribute("htableInitialExcludedComponents");
	session.removeAttribute("htableInitialIncludedComponents");

	Vector selectedTests = new Vector();
	if (strSeletedTestList.length() > 0)
	{
		//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
		IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
		sBean.stopDiscovery();	//stoping the discovery process
	
		IncludeExcludeComponents includeExcludeComp=new IncludeExcludeComponents();
		selectedTests = includeExcludeComp.getTokensAsVector(strSeletedTestList,",");
				
		if (htableSessionTestWithExcludedComponents.size() > 0)
		{
			includeExcludeComp.componentsToExclude(strComponentType,strSeletedTestList,htableSessionTestWithExcludedComponents);
		}
		if(htableSessionTestWithIncludedComponents.size() > 0)
		{
			includeExcludeComp.componentsToInclude(strComponentType,strSeletedTestList,htableSessionTestWithIncludedComponents);
		}
		
		sBean.startDiscovery("1",true);  //starting the discovery process
		EgConfigFilesSync.releaseInstance(infraIni);
	}

	//code for auditlog - starts
	boolean isAuditLogEnabled = egServicesInfo.isAuditlogEnabled();
	AuditLogThread auditLogThread = null;
	if (isAuditLogEnabled)
	{
		auditLogThread = new AuditLogThread();
		auditLogThread.setValue("Category","Admin");
		auditLogThread.setValue("User_id",_user.getLoginID());
		auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
		auditLogThread.setValue("Session_id",session.getId());
		auditLogThread.setValue("Module","Tests");
		auditLogThread.setValue("Activity","Include / Exclude Components");
		auditLogThread.setValue("Description","The components have been included / excluded successfully");
		StringTokenizer stt=null;
		stt = new StringTokenizer(strSeletedTestList,",");
		boolean canWriteLog = false;
		while (stt.hasMoreTokens())
		{
			strIncludedCompList = "";
			strExcludedCompList = "";
			strTestName = stt.nextToken();

			ArrayList aListIncludedComponents  = (ArrayList)htableSessionTestWithIncludedComponents.get(strTestName);
			if (aListIncludedComponents == null)
			{
				aListIncludedComponents = new ArrayList();
			}
			for (int i=0;i < aListIncludedComponents .size();i++)
			{
				String str = aListIncludedComponents.get(i).toString();
				if (str.indexOf("$") != -1)
				{
					str = str.substring(0,str.indexOf("$"));
				}
				if (str.indexOf(":") != -1)
				{
					if (str.indexOf(":") == str.lastIndexOf(":"))
					{
						//Check for Oracle component
						if (str.indexOf(":NULL") > -1 && str.indexOf(":null") > -1)
						{
							str = str.substring(0,str.indexOf(":"));
						}
						strIncludedCompList += str + ",";
					}
					else
					{
						strIncludedCompList += str + ",";
					}
				}
			}

			ArrayList aListExcludedComponents  = (ArrayList)htableSessionTestWithExcludedComponents.get(strTestName);
			if (aListExcludedComponents == null)
			{
				aListExcludedComponents = new ArrayList();
			}
			for (int i=0;i < aListExcludedComponents .size();i++)
			{
				String str = aListExcludedComponents.get(i).toString();
				if (str.indexOf("$") != -1)
				{
					str = str.substring(0,str.indexOf("$"));
				}
				if (str.indexOf(":") != -1)
				{
					//Check for Oracle component
					if (str.indexOf(":") == str.lastIndexOf(":"))
					{
						if (str.indexOf(":NULL") > -1 && str.indexOf(":null") > -1)
						{
							str = str.substring(0,str.indexOf(":"));
						}
						strExcludedCompList += str + ",";
					}
					else
					{
						strExcludedCompList += str + ",";
					}
				}
			}

			if (strIncludedCompList.endsWith(","))
			{
				strIncludedCompList = strIncludedCompList.substring(0,strIncludedCompList.lastIndexOf(","));
			}
			if (strExcludedCompList.endsWith(","))
			{
				strExcludedCompList = strExcludedCompList.substring(0,strExcludedCompList.lastIndexOf(","));
			}

			if (strIncludedCompList.length() > 0 && strExcludedCompList.length() > 0)
			{
				canWriteLog = true;
				auditLogThread.setCurrentValue("01~~Components Included for the " + _mapping.getTestDescription(strTestName)+" Test",strIncludedCompList);
				auditLogThread.setCurrentValue("02~~Components Excluded for the " + _mapping.getTestDescription(strTestName)+" Test",strExcludedCompList);
				//if(!aListAuditlogTests.contains(strTestName))
				//{
				//	aListAuditlogTests.add(strTestName);
				//}
			}
			else if (strIncludedCompList.length() > 0)
			{
				canWriteLog = true;
				auditLogThread.setCurrentValue("Components Included for the " + _mapping.getTestDescription(strTestName)+" Test",strIncludedCompList);
				//if(!aListAuditlogTests.contains(strTestName))
				//{
				//	aListAuditlogTests.add(strTestName);
				//}
			}
			else if (strExcludedCompList.length() > 0)
			{
				canWriteLog = true;
				auditLogThread.setCurrentValue("Components Excluded for the " + _mapping.getTestDescription(strTestName)+" Test",strExcludedCompList);
				//if(!aListAuditlogTests.contains(strTestName))
				//{
				//	aListAuditlogTests.add(strTestName);
				//}
			}
		}
		if (canWriteLog)
		{
			auditLogThread.sendItToDB();
		}
	}
	//code for auditlog - ends
	//session.setAttribute("aListAuditlogTests",aListAuditlogTests);
	ArrayList selectedTestsList = new ArrayList(selectedTests);
	session.setAttribute("aListSelectedTests",selectedTestsList);

	rootJson.put("success","true");
	rootJson.put("requestStatus","success");
	JSONObject resultMsg = new JSONObject();
	resultMsg.put("title",_mapping.getTextDescription("admin.title.AGENTS-TESTS- INCLUDE/EXCLUDE COMPONENTS"));
	resultMsg.put("message1",_mapping.getTextDescription("admin.test.Components have been included/excluded successfully")+".");
	rootJson.put("result",resultMsg);

	System.out.println("rootJson_____"+rootJson);
	out.println(rootJson.toString());
%>



