<%
/**
 *	Name            :	EgdiagnosisformatpJson.jsp	
 *	Purpose			:	Process page for EgDiagnosisFormat.jsp
 */
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "egurkha.TestBean" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");

	egurkha.ServiceBean serviceBean = new egurkha.ServiceBean();
	String testName = request.getParameter("test");
	String serverType = request.getParameter("server");
	
	String action = request.getParameter("action");
	
	if (action == null)
	{
		action = EgConstants.BLANK_STRING;
	}
	auditLogThread.setCurrentValue("Test name","$test$:"+testName);
	if (action.equalsIgnoreCase("generate"))
	{
		auditLogThread.setValue("Activity","Details Diagnosis - Generate");
		String loadLib = request.getParameter("loadLib");
		String lib = request.getParameter("lib");
		String path = request.getParameter("path");

		TestBean testBean = new TestBean(true);
		if(!testBean.loadDdFile(path, testName)) 
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			String msg = _mapping.getTextDescription("admin.error.Unable to load the class file from")+" " + path;
			msg += _mapping.getTextDescription("admin.error.Please check if the class file is available in the specified path");
			rootJSON.put("AlertMsg",msg);
			auditLogThread.setCurrentValue("Class file name",path);
			auditLogThread.setValue("Description","Unable to load the class file");
		}
		else if(loadLib != null && loadLib.equalsIgnoreCase("yes") && !testBean.loadDdFile(lib, testName))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			String msg = _mapping.getTextDescription("admin.error.Unable to load the library file")+" " + lib;
			msg += "<br>"+_mapping.getTextDescription("admin.error.Please check if the file is available in the specified path")+".";
			msg += "<br>"+_mapping.getTextDescription("admin.error.Please note files of size more than 0*5 MB may not be loaded")+". ";
			msg += "<br>"+_mapping.getTextDescription("admin.error.These files have to be added manually")+". "+_mapping.getTextDescription("admin.error.Please refer User Manual on where to add these library files");
			rootJSON.put("AlertMsg",msg);
			auditLogThread.setCurrentValue("Library file",lib);
			auditLogThread.setValue("Description","Unable to load the library file");
		}
		else if (!testBean.isDdEnabled(testName))
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Generate Detailed Diagnosis"));
			String msg = _mapping.getTextDescription("admin.error.No measure(s) have been selected for Detailed Diagnosis")+". ";
			msg += _mapping.getTextDescription("admin.error.Please select the measure(s) and specify the description and column headings for enabling Detailed Diagnosis")+".";
			rootJSON.put("AlertMsg",msg);
			auditLogThread.setValue("Description","No measure(s) have been selected for Detailed Diagnosis");
		}
		else
		{
			auditLogThread.setValue("Description","Detailed diagnosis generated successfully");
		}
		auditLogThread.sendItToDB();
		String url = "EgDefaultJson.jsp?qctr=0&t_name="+testName;
		if (!StringUtils.isNull(serverType) && !serverType.equalsIgnoreCase("null"))
		{
			url += "&server="+serverType+"&page=true";
		}
		else
		{
			url += "&server=null&page=true";
		}
		rootJSON.put("forwardPage",true);
		rootJSON.put("forwardURL",url);
	}
	else if (action.equalsIgnoreCase("add"))
	{
		auditLogThread.setValue("Activity","Details Diagnosis - Add Measure");
		String colTitles = request.getParameter("ddColTitles");
		String desc = request.getParameter("ddDesc");
		String measureName = request.getParameter("measure");

		if (!StringUtils.isNull(colTitles)
		|| !StringUtils.isNull(desc)
		|| !StringUtils.isNull(testName)
		|| !StringUtils.isNull(measureName))
		{
			//The following line is to ensure that the stopDiscovery & startDiscovery runs inside a sync block
			IniFile infraIni = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir() + "/manager/config/eg_infrastructure.ini");
			serviceBean.stopDiscovery();

			StringBuffer key = new StringBuffer(32);
			key.append(testName);
			key.append(EgConstants.COLON);
			key.append(measureName);

			desc = StringUtils.removeISOControlChar(desc);
			colTitles = StringUtils.removeISOControlChar(colTitles);

			
			StringBuffer value = new StringBuffer(32);
			value.append("Format");
			value.append(EgConstants.COLON);
			/*
			 * Replacing commas in the string to blank spaces
			 */
			value.append(colTitles.replace(',', ' '));
			value.append(EgConstants.COMMA);
			value.append("Desc:");
			value.append(desc);

			/*
			 * Open eg_format.ini and create an entry in the format
			 * TestName:MeasureName=Format:<column names>,Desc:<desc>
			 */
			IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini", true);
			//System.out.println("Setting "+value.toString()+" in ini file");
			iniFile.setValue("FORMAT", key.toString(), value.toString());
			iniFile.saveFile();
			EgConfigFilesSync.releaseInstance(iniFile);
			serviceBean.startDiscovery("1");
			EgConfigFilesSync.releaseInstance(infraIni);

		/*
		 * Go to EgDiagnosisFormat.jsp to add detailed diagnosis for any other measure
		 *
		 */
			String s_url = "EgDiagnosisFormatJson.jsp?test=" + testName + "&server=" +  serverType+ "&measure=";
			rootJSON.put("forwardPage",true);
			rootJSON.put("forwardURL",s_url);
			auditLogThread.setValue("Description","Measure has been added successfully for detailed diagnosis");
			auditLogThread.sendItToDB();
		}
		else
		{
			rootJSON.put("AlertType","Error");
			rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Format Entries For Detailed Diagnosis"));
			String msg = _mapping.getTextDescription("admin.error.One of the following was not available")+".<br>";
			msg += "1) "+_mapping.getTextDescription("admin.error.Column titles for the table")+". <br>";
			msg += "2) "+_mapping.getTextDescription("admin.error.Description for the detailed diagnosis test")+".<br>";
			msg += "3) "+_mapping.getTextDescription("admin.error.Name of the test and/or measure for which the detailed diagnosis is enabled");
			rootJSON.put("AlertMsg",msg);
			auditLogThread.setValue("Reason","One of the following was not available");
			auditLogThread.setValue("Reason","(1) Column titles for the table");
			auditLogThread.setValue("Reason","(2) Description for the detailed diagnosis test");
			auditLogThread.setValue("Reason","(3) Name of the test and/or measure for which the detailed diagnosis is enabled");
			auditLogThread.setValue("Description","Measure has not been added");
			auditLogThread.sendItToDB();
		}
	}
	else if (action.equalsIgnoreCase("del"))
	{
		auditLogThread.setValue("Activity","Details Diagnosis - Delete Measure");
		String add = request.getParameter("add");
		String test = request.getParameter("test");
		String measure = request.getParameter("ddmeasure");
		IniFile iniFile = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini", true);
		StringBuffer key = new StringBuffer(32);
		key.append(test);
		key.append(EgConstants.COLON);
		key.append(measure);
		
		iniFile.deleteValue("FORMAT",key.toString());
		iniFile.saveFile();
		EgConfigFilesSync.releaseInstance(iniFile);
		String s_url1 = "EgDiagnosisFormatJson.jsp?test=" + testName ;
		
		rootJSON.put("AlertType","Result");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Detailed Diagnosis"));
		rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Measure has been deleted successfully"));
		rootJSON.put("forwardPage",true);
		rootJSON.put("forwardURL",s_url1);
		auditLogThread.setValue("Description","Measure has been deleted successfully");
		auditLogThread.sendItToDB();
	}
	else
	{
		auditLogThread.setValue("Activity","Details Diagnosis");
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Format Entries For Detailed Diagnosis"));
		String msg = _mapping.getTextDescription("admin.error.Data insufficient to enable detailed diagnosis")+"."+_mapping.getTextDescription("admin.error.Please try again")+".";
		rootJSON.put("AlertMsg",msg);
		auditLogThread.setValue("Description","Data insufficient to enable detailed diagnosis");
		auditLogThread.sendItToDB();
	}
	out.println(rootJSON);

%>



