<%
/*
 *       Name            :       EgDuplicateTestJson.jsp
 *       Purpose         :       For duplicating IC log test.
 *       Author          :       ArunR
 */
%>

<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page import="java.io.*" %>
<%@ page import="egurkha.TestBean"%>
<%@ page import="egurkha.DbBean"%>

<%@ page import="net.sf.json.JSONObject"%>
<%@ page import="com.egurkha.admin.AuditLogThread"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");
%>

<%
	AuditLogThread auditLogThread = new AuditLogThread();
	auditLogThread.setValue("Category","Admin");
	auditLogThread.setValue("User_id",_user.getLoginID());
	auditLogThread.setValue("Host_ip",_user.getUserIP(session.getId()));
	auditLogThread.setValue("Session_id",session.getId());
	auditLogThread.setValue("Module","Integration Console");
	auditLogThread.setValue("Activity","Duplicate Test");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	TestBean testBean = new TestBean(true);
	String strTestName = request.getParameter("testName");
	String strDupTestName = request.getParameter("duplicate");
	String typeVal = request.getParameter("typeVal");
	if(testBean.doesTestExist(strDupTestName))
	{
		rootJSON.put("AlertType","Error");
		rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.error.Add a Test"));
		String msg = _mapping.getTextDescription("admin.error.You are trying to add a test which already exists")+". <br>";
		msg += _mapping.getTextDescription("admin.error.Please enter a unique test name");
		rootJSON.put("AlertMsg",msg);
		
		out.println(rootJSON);
		auditLogThread.setCurrentValue("Test name","$test$:"+strDupTestName);
		auditLogThread.setValue("Description","Attempt has been made to add a test which already exists");
		auditLogThread.sendItToDB();
		return;
	}

	String strTestType = request.getParameter("testType");
	String strTestName2 = request.getParameter("testName");
	boolean createDD=false;
	
	IniFile ini=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini",true);
	//IniFile ini_table=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tables.ini",true);
	//IniFile ini_spec=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini",true);
	//IniFile ini2=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini",true);
	//IniFile ini_new=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/tests/eg_newtests.ini",true);
	//IniFile ini_test=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini",true);
	//IniFile ini_aggregate=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini",true);
	//IniFile ini_format=new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini",true);
	
	UpdateAndTransmitICInfo updateICInfo = new UpdateAndTransmitICInfo(); //clustering
	DbBean dbbean=new DbBean();
	IniFile ini_new = null;
	long curtime=System.currentTimeMillis();
	String cur_time=Long.toString(curtime);
	if ((new com.eg.EgDbInfo("manager")).getMeasurementsForTest(strTestName) != null)
	{
		List unitname = new ArrayList(Arrays.asList((new com.eg.EgDbInfo("manager")).getMeasurementsForTest(strTestName)));// to get measures for the given test
		if (unitname != null)
		{
			IniFile ini_table=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tables.ini",true);
			ini_new = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/tests/eg_newtests.ini",true);
			IniFile ini_format=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_format.ini",true);
			for(int i=0;i< unitname.size();i++)
			{
				String meas=(String)unitname.get(i);
				meas=meas.trim();
				//For eg_format.ini
				boolean format=(new com.eg.EgFormatInfo("manager")).isDdEnabled(strTestName,meas);
				if(format)
				{
					String value=ini_format.getValue("FORMAT",strTestName+":"+meas);
					ini_format.setValue("FORMAT",strDupTestName+":"+meas,value);
					ini_new.setValue("NEW_LIBS",strDupTestName+":"+strDupTestName+"_DD.class",cur_time);
					ini.setValue("PATH",strDupTestName+"_DD",EgInstallInfo.getInstallDir()+"/manager/config/tests/"+strDupTestName+"_DD"+".class");
					ini_format.saveFile();
					ini_new.saveFile();
					createDD=true;
				}
				
				if(!typeVal.equalsIgnoreCase("Configuration"))
				{
					String measure=ini_table.getValue("MEASUREMENT_UNITS_TABLE",strTestName+":"+meas);
					String alert=ini_table.getValue("MEASUREMENT_ALERTS_TABLE",strTestName+":"+meas);
					ini_table.setValue("MEASUREMENT_UNITS_TABLE",strDupTestName+":"+meas,measure);
					if(alert.length()>0)
						ini_table.setValue("MEASUREMENT_ALERTS_TABLE",strDupTestName+":"+meas,alert);
				}
			}
			ini_table.saveFile();
			EgConfigFilesSync.releaseInstance(ini_table);
			EgConfigFilesSync.releaseInstance(ini_new);
			EgConfigFilesSync.releaseInstance(ini_format);
		}
	}
	//For Ui_designing
	Vector vec = ini.getVariables("IC_DUPLICATE",true);
	
	if(vec != null && vec.contains(strTestName))
	{
		String pre = ini.getValue("IC_DUPLICATE",strTestName);
		if(pre !=null && pre.length()>0)
			pre=pre+","+strDupTestName;
		else
			pre=strDupTestName;
		ini.setValue("IC_DUPLICATE",strTestName,pre);
	}
	else
	{
		ini.setValue("IC_DUPLICATE",strTestName,strDupTestName);
	}
	if(typeVal != null && typeVal.length() > 0)
	{
		ini.setValue("TEST_TYPE",strDupTestName,typeVal);
	}
	ini.saveFile();
	
	//For eg_udtests.ini
	String testParam = ini.getValue("TEST_PARAMS",strTestName);
	String testMeas = ini.getValue("MEASURES",strTestName);
	String port=ini.getValue("PORT_TESTS",strTestName);
	String db=ini.getValue("DB",strTestName);
	String processes=ini.getValue("PROCESSES",strTestName);
	String queries=ini.getValue("QUERIES",strTestName);
	String os=ini.getValue("OS",strTestName);
	String bin=ini.getValue("BINS",strTestName);
	String counter=ini.getValue("COUNTERS",strTestName);
	String object=ini.getValue("OBJECTS",strTestName);
	String instances=ini.getValue("INSTANCES",strTestName);
	String instances_neg=ini.getValue("INSTANCES_NEG",strTestName);
	String conversionfactor=ini.getValue("CONVERSION_FACTOR",strTestName);
	String multiple=ini.getValue("MULTIPLE",strTestName);
	String measureOid=ini.getValue("MEASURE_OID_MAPPING",strTestName);
	String snmpinfoid=ini.getValue("SNMP_INFO_OID",strTestName);
	String mbeanDiscovery=ini.getValue("MBEAN_DISCOVERY",strTestName);
	String lib=ini.getValue("LIBS",strTestName);
	String isDescriptorBasedUdTest="";
	if(typeVal.equalsIgnoreCase("Configuration"))
	{
		isDescriptorBasedUdTest = ini.getValue("DESCRIPTOR_BASED_CONFIG_TEST",strTestName);
	}
	
	//For eg_specs.ini
	IniFile ini_spec= EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_specs.ini",true);
	if(port.length()==0)
	{
		String testSpec = ini_spec.getValue("TEST_SPECIFICATION",strTestName+"::$hostName");
		ini_spec.setValue("TEST_SPECIFICATION",strDupTestName+"::$hostName",testSpec);
		ini_spec.saveFile();
	}
	else
	{
		String testSpecQuery=ini_spec.getValue("TEST_SPECIFICATION",strTestName+"::$hostName:$portNo");
		ini_spec.setValue("TEST_SPECIFICATION",strDupTestName+"::$hostName:$portNo",testSpecQuery);
		ini_spec.saveFile();
		ini.setValue("PORT_TESTS",strDupTestName,port);
		ini.saveFile();
	}
	EgConfigFilesSync.releaseInstance(ini_spec);
	if(testParam.length()!=0)
	{
		ini.setValue("TEST_PARAMS",strDupTestName,testParam);	
		ini.saveFile();
	}

	//For eg_tests.ini
	IniFile ini_test = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_tests.ini",true);
	String testDef=ini_test.getValue("TEST_DEFINITIONS",strTestName);
	String testparamMap=ini_test.getValue("TEST_PARAM_MAPPING",strTestName);
	String testMapping=ini_test.getValue("TEST_MAPPING",strTestName);
	String query=ini_test.getValue("QUERIES",strTestName);
	String testobject=ini_test.getValue("OBJECTS",strTestName);
	String testcounter=ini_test.getValue("COUNTERS",strTestName);
	String testinstances=ini_test.getValue("INSTANCES",strTestName);
	String testinstances_neg=ini_test.getValue("INSTANCES_NEG",strTestName);
	String testConversionFactor=ini_test.getValue("CONVERSION_FACTOR",strTestName);
	String isDescriptorBasedEgTests = "";
	if(typeVal.equalsIgnoreCase("Configuration"))
	{
		isDescriptorBasedEgTests = ini_test.getValue("DESCRIPTOR_BASED_CONFIG_TEST",strTestName);
	}

	//For eg_aggregate.ini
	IniFile ini_aggregate=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_aggregate.ini",true);
	String columnname="";
	String AggregateTest=ini_aggregate.getValue("AGGREGATE_TEST",strTestName);
	String AggregateFunction="";
	
	//purpose for this block is Create DD file in egurkha\lib compile put into class file in manager\config\test
	if(createDD)
	{	
		ArrayList aList = new ArrayList();
		aList.add("public class "+strDupTestName+"_DD"+" extends " + strTestName+"_DD");
		aList.add("{");
		aList.add("public " + strDupTestName+"_DD"+ "(String arg)");
		aList.add("{");
		aList.add("super(arg);");
		aList.add("}");
		aList.add("}");
		if (strTestName != null )
		{
			String strTestNameDD = EgInstallInfo.getInstallDir() + "\\lib\\"+strDupTestName+"_DD"+".java";
			BufferedWriter bw = new BufferedWriter (new OutputStreamWriter(new FileOutputStream(strTestNameDD),"UTF-8"));
			for (int i=0;i<aList.size();i++ )
			{
				String line = (String)aList.get(i);
				bw.write(line,0,line.length());
				bw.newLine();
			}
			bw.close();
			Runtime runtime = Runtime.getRuntime();
			String javapath = System.getenv("JAVA_HOME");
			String compile = javapath + "\\bin\\javac -source 1.3 -target 1.3 -classpath " +EgInstallInfo.getInstallDir() + "\\manager\\config\\tests;"+ EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar -d " + EgInstallInfo.getInstallDir() + "\\manager\\config\\tests " +strTestNameDD;
			Process p = runtime.exec(compile);
		}
	}

	//purpose for this block is Create Test file in egurkha\lib compile put into class file in manager\config\test
	if(strTestType.equals("Custom"))   //if(dbBean.getConnection()) //clustering
	{
		
		ArrayList aList = new ArrayList();
		aList.add("public class "+strDupTestName+" extends " + strTestName );
		aList.add("{");
		aList.add("public " + strDupTestName + "(String arg[])");
		aList.add("{");
		aList.add("super(arg);");
		aList.add("}");
		aList.add("}");
		if (strTestName != null )
		{
			strTestName = EgInstallInfo.getInstallDir() + "\\lib\\"+strDupTestName+".java";
			BufferedWriter bw = new BufferedWriter (new OutputStreamWriter(new FileOutputStream(strTestName),"UTF-8"));
			for (int i=0;i<aList.size();i++ )
			{
				String line = (String)aList.get(i);
				bw.write(line,0,line.length());
				bw.newLine();
			}
			bw.close();
			Runtime runtime = Runtime.getRuntime();
			String javapath = System.getenv("JAVA_HOME");
			String compile = javapath + "\\bin\\javac -source 1.3 -target 1.3 -classpath " +EgInstallInfo.getInstallDir() + "\\manager\\config\\tests;"+ EgInstallInfo.getInstallDir() + "\\lib\\eg_agent.jar -d " + EgInstallInfo.getInstallDir() + "\\manager\\config\\tests " +strTestName;
			Process p = runtime.exec(compile);
		}
		ini.setValue("PATH",strDupTestName,EgInstallInfo.getInstallDir()+"/manager/config/tests/"+strDupTestName+".class");
		//ini.setValue("LIBS",strDupTestName,EgInstallInfo.getInstallDir()+"/manager/config/tests/"+strTestName2+".class");
		
		if(lib!=null && lib.length()>0)
			ini.setValue("LIBS",strDupTestName,lib);
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
		}
		ini.saveFile();
		ini_test.saveFile();
		ini_new = EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/tests/eg_newtests.ini",true);
		ini_new.setValue("NEW_TESTS",strDupTestName,cur_time);
		ini_new.saveFile();
		EgConfigFilesSync.releaseInstance(ini_new);
	}
	else if(strTestType.equals("Sql Query"))
	{
		
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("DB",strDupTestName,db);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("QUERIES",strDupTestName,queries);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.saveFile();
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
			ini.saveFile();
			ini_test.saveFile();
		}
		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("QUERIES",strDupTestName,query);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.saveFile();
	}
	else if(strTestType.equals("Script/Batch File"))
	{
		
		String binvalue="";
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("OS",strDupTestName,os);
		ini.setValue("BINS",strDupTestName,bin);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.saveFile();
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
			ini.saveFile();
			ini_test.saveFile();
		}

		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.saveFile();
	
		String[] variables=ini_new.getVariables("NEW_BINS");
		
		if(variables !=null)
		{
			for(int i=0;i<variables.length;i++)
			{
				
				if(variables[i].startsWith(strTestName))
				{
					binvalue=variables[i];
					binvalue=binvalue.substring(binvalue.indexOf(":")+1,binvalue.length());
					
				}
			}
			ini_new.setValue("NEW_BINS",strDupTestName+":"+binvalue,cur_time);
			ini_new.saveFile();
		}
	}
	else if(strTestType.equals("Perfmon"))
	{
		
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("PORT_TESTS",strDupTestName,port);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("COUNTERS",strDupTestName,counter);
		ini.setValue("OBJECTS",strDupTestName,object);
		ini.setValue("INSTANCES",strDupTestName,instances);
		ini.setValue("INSTANCES_NEG",strDupTestName,instances_neg);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.saveFile();
	
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
			ini.saveFile();
			ini_test.saveFile();
		}

		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("COUNTERS",strDupTestName,counter);
		ini_test.setValue("OBJECTS",strDupTestName,object);
		ini_test.setValue("INSTANCES",strDupTestName,instances);
		ini_test.setValue("INSTANCES_NEG",strDupTestName,instances_neg);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.saveFile();
	}
	else if(strTestType.equals("Snmp"))
	{
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.setValue("MULTIPLE",strDupTestName,multiple);
		ini.setValue("MEASURE_OID_MAPPING",strDupTestName,measureOid);
		if(snmpinfoid.length()!=0)
			ini.setValue("SNMP_INFO_OID",strDupTestName,snmpinfoid);
		ini.saveFile();
	
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
			ini.saveFile();
			ini_test.saveFile();
		}

		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.setValue("MEASURE_OID_MAPPING",strDupTestName,measureOid);
		if(snmpinfoid.length()!=0)
			ini_test.setValue("SNMP_INFO_OID",strDupTestName,snmpinfoid);
		ini_test.saveFile();
	}
	else if(strTestType.equals("Jmx"))
	{
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.setValue("COUNTERS",strDupTestName,counter);
		ini.setValue("OBJECTS",strDupTestName,object);
		ini.setValue("MBEAN_DISCOVERY",strDupTestName,mbeanDiscovery);
		ini.setValue("INSTANCES",strDupTestName,instances);
		ini.setValue("INSTANCES_NEG",strDupTestName,instances_neg);
		ini.saveFile();
	
		if(typeVal.equalsIgnoreCase("Configuration"))
		{
			ini.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedUdTest);
			ini_test.setValue("DESCRIPTOR_BASED_CONFIG_TEST",strDupTestName,isDescriptorBasedEgTests);
			ini.saveFile();
			ini_test.saveFile();
		}

		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.setValue("COUNTERS",strDupTestName,counter);
		ini_test.setValue("OBJECTS",strDupTestName,object);
		ini_test.setValue("INSTANCES",strDupTestName,instances);
		ini_test.setValue("INSTANCES_NEG",strDupTestName,instances_neg);
		ini_test.saveFile();
	}
	else if(strTestType.equals("Aggregate"))
	{
		ini.setValue("MEASURES",strDupTestName,testMeas);
		ini.setValue("UD_TESTS",strDupTestName,strDupTestName);
		ini.setValue("TYPE",strDupTestName,strTestType);
		ini.setValue("PROCESSES",strDupTestName,processes);
		ini.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini.saveFile();

		ini_test.setValue("TEST_DEFINITIONS",strDupTestName,testDef);
		ini_test.setValue("TEST_PARAM_MAPPING",strDupTestName,testparamMap);
		ini_test.setValue("TEST_MAPPING",strDupTestName,testMapping);
		ini_test.setValue("CONVERSION_FACTOR",strDupTestName,conversionfactor);
		ini_test.saveFile();
		ini_aggregate.setValue("AGGREGATE_TEST",strDupTestName,AggregateTest);
		ini_aggregate.saveFile();

		StringTokenizer st=new StringTokenizer(testparamMap,",");
		while(st.hasMoreTokens())
		{
			String metrics=st.nextToken();
			metrics=metrics.substring(0,metrics.indexOf(":"));
			String metricsUcase=metrics.toUpperCase();
			columnname=ini_aggregate.getValue("COLUMN_NAME_MAPPING",strTestName+":"+metrics);
			ini_aggregate.setValue("COLUMN_NAME_MAPPING",strDupTestName+":"+metrics,columnname);
			AggregateFunction=ini_aggregate.getValue("AGGREGATE_FUNCTION",strTestName+":"+metricsUcase);
			ini_aggregate.setValue("AGGREGATE_FUNCTION",strDupTestName+":"+metricsUcase,AggregateFunction);
			ini_aggregate.saveFile();
		}
	}
	EgConfigFilesSync.releaseInstance(ini);
	EgConfigFilesSync.releaseInstance(ini_test);
	EgConfigFilesSync.releaseInstance(ini_aggregate);
	IniFile ini2=EgConfigFilesSync.getInstance(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini",true);
	String thres = ini2.getValue("DEFAULT_THRESHOLDS",strTestName2);
	ini2.setValue("DEFAULT_THRESHOLDS",strDupTestName,thres);
	ini2.saveFile();
	EgConfigFilesSync.releaseInstance(ini2);

	if(updateICInfo.getConnection())
	{
		String error=updateICInfo.setMeasures(strTestType,strDupTestName);
	}
	rootJSON.put("AlertType","Result");
	rootJSON.put("AlertTitle",_mapping.getTextDescription("admin.ic.Integration Console - Test"));
	rootJSON.put("AlertMsg",_mapping.getTextDescription("admin.ic.Test has been added successfully"));
	auditLogThread.setCurrentValue("Test type",strTestType);
	auditLogThread.setCurrentValue("Test name","$test$:"+strTestName2);
	auditLogThread.setValue("Description","Test has been added successfully");
	auditLogThread.sendItToDB();
	out.println(rootJSON);
%>



