<%
/**
 *	Name        :	EgDiagnosisFormat.jsp 
 *	Purpose     :	To configure column titles and description for detailed diagnosis. 
 *					These settings will be stored in eg_format.ini
 */
%>
<%@ include file="../../../admin/EgTrackerAJSON.jsp"%>
<%@ page language = "java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import = "com.egurkha.util.*" %>
<%@ page import = "net.sf.json.JSONObject"%>
<%@ page import = "net.sf.json.JSONArray"%>

<%
	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json;charset=UTF-8");

	String column=request.getParameter("column");
	String descript=request.getParameter("desc");
	String test = request.getParameter("test");

	JSONObject rootJSON = new JSONObject();
	rootJSON.put("success","true");
	JSONObject hiddens = new JSONObject();
	egurkha.TestBean testBean = new egurkha.TestBean();
	String uploadtype="";
	String path = request.getParameter("classPath");
	if (StringUtils.isNull(path))
	{
		path = testBean.getDdPath(test);
	}

	String lib = request.getParameter("libraryPath");

	/*
	 * The way EgRemoteUpload.jsp works, the value of path to the JAR files is
	 * associated with the key libraryPath. 
	 * 
	 * So read from this request parameter only when the page refreshes after the 
	 * upload. Otherwise, read from the INI file.
	 */

	if (lib == null)
	{
		lib = testBean.getDdClasspath(test);
	}
	hiddens.put("test",test);


	IniFile udMeasures = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_udtests.ini");
	String value = udMeasures.getValue("MEASURES", test);
	Object[] measures = null;
	if (!StringUtils.isNull(value))
	{
		String[] tokens = StringUtils.getTokens(value, "#");
		List measureValues = new LinkedList();
		for (int a=0; a<tokens.length; a++)
		{
			measureValues.add(tokens[a].substring(0, tokens[a].indexOf(EgConstants.COLON)));
		}

		measures = measureValues.toArray();
	}

	String measure  = request.getParameter("measure");

	String desc = null;
	String title = null;
	IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_format.ini");
	if (!StringUtils.isNull(test) && !StringUtils.isNull(measure))
	{
		StringBuffer key = new StringBuffer(32);
		key.append(test);
		key.append(":");
		key.append(measure);

		value = iniFile.getValue("FORMAT", key.toString());
		String[] values = StringUtils.split(value, ",");
		if (values == null || values.length != 2)
		{
			desc = "";
			title = "";
		}
		else
		{
			if (values[0].startsWith("Format:"))
			{
				title = values[0].substring(values[0].indexOf(":")+1);
			}
			else
			{
				title = "";
			}

			if (values[1].startsWith("Desc:"))
			{
				desc = values[1].substring(values[1].indexOf(":")+1);
			}
			else
			{
				desc = "";
			}
		}
	}
	else
	{
		desc = "";
		title = "";
	}
	hiddens.put("uploadType",uploadtype);
	hiddens.put("libraryPath",lib);
	hiddens.put("classPath",path);
	rootJSON.put("path",path);
	rootJSON.put("lib",lib);
	rootJSON.put("loadLibCheck","checked");
	
	if(lib != null && lib.length() > 0)
	{
		rootJSON.put("loadLibChecked",true);
	}
	else
	{
		rootJSON.put("loadLibChecked",false);
	}
	/*******************************************************************************************************************
		commented to modify and delete the measures for DD
	*******************************************************************************************************************/
	String val;
	//IniFile formatIni = new IniFile(EgInstallInfo.getInstallDir() + "/manager/config/eg_format.ini");			
	String[] var = iniFile.getVariables("FORMAT");
	boolean mesForDD = false;
	JSONArray measureArr = new JSONArray();
	JSONObject obj = new JSONObject();
	for (int i=0;i<var.length;i++)
	{
		if(var[i].startsWith(test))
		{
			mesForDD = true;
			val = iniFile.getValue("FORMAT",var[i]);
			/**********************************************************
			example : RmanCorruptTest_ex:No_of_Bkp_Corruptions=Format:BackupCorruptions,Desc:aaaaaaaaaaaaaaaaaaaaaaaa
			var[i] = RmanCorruptTest_ex:No_of_Bkp_Corruptions
			val    = Format:BackupCorruptions,Desc:aaaaaaaaaaaaaaaaaaaaaaaa 
			***********************************************************/
			String[] tVal0 = StringUtils.getTokens(var[i],":"); 
			String[] tok = StringUtils.getTokens(val,","); 
			String tok1 = tok[0];
			String tok2 = tok[1];
			String[] tVal = StringUtils.getTokens(tok1,":"); 
			String[] tVal1 = StringUtils.getTokens(tok2,":"); 
			String withCol = StringUtils.replace(tVal[1]," ",",");
			obj = new JSONObject();
			obj.put("measure",tVal0[1]);
			obj.put("column",withCol);
			obj.put("description",tVal1[1]);
			String modInfo = test+"#^#"+tVal0[1]+"#^#"+withCol+"#^#"+tVal1[1];
			obj.put("modifyInfo",modInfo);
			String delURL = "EgdiagnosisformatpJson.jsp?action=del&test="+test+"&ddmeasure="+tVal0[1];
			obj.put("deleteURL",delURL);
			measureArr.add(obj);
		}		
	}
	rootJSON.put("measuresList",measureArr);
	if(!mesForDD)
	{
		rootJSON.put("noMeasuresFnd",true);
	}
	JSONArray measuresArr = new JSONArray();
	if (measures != null)
	{
		obj = new JSONObject();
		obj.put("displayField",_mapping.getTextDescription("admin.ic.Please choose a measure"));
		obj.put("valueField","-1");
		measuresArr.add(obj);
		
		if (StringUtils.isNull(measure))
		{
			rootJSON.put("selectedMeasure","-1");
		}
		for (int a=0; a<measures.length; a++)
		{
			obj = new JSONObject();
			obj.put("displayField",measures[a]);
			obj.put("valueField",measures[a]);
			if (measures[a].equals(measure))
			{
				rootJSON.put("selectedMeasure",measures[a]);
			}
			measuresArr.add(obj);
		}
	}
	rootJSON.put("measures",measuresArr);
	rootJSON.put("columnValue",title.replace(' ', ','));
	rootJSON.put("descriptionValue",desc);
	rootJSON.put("hiddens",hiddens);
	out.println(rootJSON);
%>



