<%@ include file="../../../admin/EgTrackerAJSON.jsp" %>
<%@ page import="com.eg.EgInstallInfo"%>
<%@ page import="com.eg.IniFile"%>
<%@ page import="com.eg.EgMappingInfo"%>
<%@ page import="com.egurkha.ini.IniUI"%>
<%@ page import="com.eg.EgTesterInfo"%>
<%@ page import="com.eg.EgTablesInfo"%>
<%@ page import="com.eg.EgSpecsInfo"%>
<%@ page import="com.egurkha.util.StringUtils" %>
<%@ page import="net.sf.json.*"%>

<%@ page language="java" contentType="text/html;charset=UTF-8" pageEncoding="UTF-8" %>

<%!
	public int getLeniencyFactor(String relValue)
	{
		int leniency = 0;
		if (relValue != null)
		{
			if (relValue.equals("-"))
			{
				leniency = 0;
			}
			else if (relValue.equals("sqc"))
			{
				leniency = 100;
			}
			else
			{
				int idx = relValue.indexOf("*");
				String s1 = relValue.substring(0,idx);
				double d_value = Double.valueOf(s1.trim()).doubleValue();
				d_value = d_value * 100;
				leniency = (new Double(d_value)).intValue();
			}
		}
		return leniency;
	}
%>

<%

	response.setHeader("Cache-Control","no-store");
	response.setHeader("Pragma","no-cache");
	response.setDateHeader("Expires", -1);
	response.setContentType("application/json");

	JSONObject rootJson = new JSONObject();
	JSONObject screenLabels = new JSONObject();
	JSONObject hiddenObj = new JSONObject();
	IniUI iniUI = IniUI.getInstance();
	//user language
	String userLanguage = iniUI.getDefaultLanguage();
	if (_user != null)
	{
		userLanguage = _user.getLanguage();
	}

	EgMappingInfo mappingInfo = new EgMappingInfo(userLanguage);
	EgTesterInfo testerInfo = new EgTesterInfo("manager");
	EgSpecsInfo specsInfo = new EgSpecsInfo("manager");
	EgTablesInfo tablesInfo = new EgTablesInfo("manager");
	ArrayList aListHostLevelTests = (ArrayList) session.getAttribute("sessListHostLevelTests");

	String strComponentType = request.getParameter("componentType");
	String strTestName = request.getParameter("testName");
	String measure = request.getParameter("measure");

	hiddenObj.put("componentType",strComponentType);
	hiddenObj.put("testName",strTestName);
	hiddenObj.put("measure",measure);
	String absMinCritical = request.getParameter("absMinCritical");
	String absMinMajor = request.getParameter("absMinMajor");
	String absMinMinor = request.getParameter("absMinMinor");
	String relMinCritical = request.getParameter("relMinCritical");
	String relMinMajor = request.getParameter("relMinMajor");
	String relMinMinor = request.getParameter("relMinMinor");
	String absMaxCritical = request.getParameter("absMaxCritical");
	String absMaxMajor = request.getParameter("absMaxMajor");
	String absMaxMinor = request.getParameter("absMaxMinor");
	String relMaxCritical = request.getParameter("relMaxCritical");
	String relMaxMajor = request.getParameter("relMaxMajor");
	String relMaxMinor = request.getParameter("relMaxMinor");
	String alarmPolicy = request.getParameter("alarmPolicy");

	String ua = request.getHeader("User-Agent");
	boolean isFirefox = (ua != null && ua.indexOf("Firefox/") != -1);
	boolean isChrome = (ua != null && ua.indexOf("Chrome") != -1);
	boolean isNegativeValuesAllowed = testerInfo.isNegativeValuesAllowed(strTestName,measure);
	rootJson.put("isNegativeValuesAllowed",isNegativeValuesAllowed);
	if (absMinCritical == null)
	{
		absMinCritical = "-";
	}
	if (absMinMajor == null)
	{
		absMinMajor = "-";
	}
	if (absMinMinor == null)
	{
		absMinMinor = "-";
	}

	String minStaticSelected = "";
	String minStaticBlock = "none";
	if ((absMinCritical != null && !absMinCritical.equals("-")) || 
		(absMinMajor != null && !absMinMajor.equals("-")) || 
		(absMinMinor != null && !absMinMinor.equals("-")))
	{
		minStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minStaticBlock = "table-row";
		}
		else
		{
			minStaticBlock = "block";
		}
	}

	String minAutomaticSelected = "";
	String minAutomaticBlock = "none";
	String minAutoToleranceBlock = "";
	String minAutoCriticalSliderBlock = "";
	String minAutoMajorSliderBlock = "";
	String minAutoMinorSliderBlock = "";

	if ((relMinCritical != null && !relMinCritical.equals("-")) || 
		(relMinMajor != null && !relMinMajor.equals("-")) || 
		(relMinMinor != null && !relMinMinor.equals("-")))
	{
		minAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			minAutomaticBlock = "table-row";
		}
		else
		{
			minAutomaticBlock = "block";
		}

		if (relMinCritical != null && !relMinCritical.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoCriticalSliderBlock = "block";
			}
		}

		if (relMinMajor != null && !relMinMajor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMajorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMajorSliderBlock = "block";
			}
		}

		if (relMinMinor != null && !relMinMinor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				minAutoToleranceBlock = "table-row";
				minAutoMinorSliderBlock = "table-row";
			}
			else
			{
				minAutoToleranceBlock = "block";
				minAutoMinorSliderBlock = "block";
			}
		}
	}

	if (absMaxCritical == null)
	{
		absMaxCritical = "-";
	}
	if (absMaxMajor == null)
	{
		absMaxMajor = "-";
	}
	if (absMaxMinor == null)
	{
		absMaxMinor = "-";
	}

	String maxStaticSelected = "";
	String maxStaticBlock = "none";
	if ((absMaxCritical != null && !absMaxCritical.equals("-")) || 
		(absMaxMajor != null && !absMaxMajor.equals("-")) || 
		(absMaxMinor != null && !absMaxMinor.equals("-")))
	{
		maxStaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxStaticBlock = "table-row";
		}
		else
		{
			maxStaticBlock = "block";
		}
	}

	String maxAutomaticSelected = "";
	String maxAutomaticBlock = "none";
	String maxAutoToleranceBlock = "";
	String maxAutoCriticalSliderBlock = "";
	String maxAutoMajorSliderBlock = "";
	String maxAutoMinorSliderBlock = "";
	if ((relMaxCritical != null && !relMaxCritical.equals("-")) || 
		(relMaxMajor != null && !relMaxMajor.equals("-")) || 
		(relMaxMinor != null && !relMaxMinor.equals("-")))
	{
		maxAutomaticSelected = "selected";
		if (isFirefox || isChrome)
		{
			maxAutomaticBlock = "table-row";
		}
		else
		{
			maxAutomaticBlock = "block";
		}

		if (relMaxCritical != null && !relMaxCritical.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoCriticalSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoCriticalSliderBlock = "block";
			}
		}

		if (relMaxMajor != null && !relMaxMajor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMajorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMajorSliderBlock = "block";
			}
		}

		if (relMaxMinor != null && !relMaxMinor.equals("-"))
		{
			if (isFirefox || isChrome)
			{
				maxAutoToleranceBlock = "table-row";
				maxAutoMinorSliderBlock = "table-row";
			}
			else
			{
				maxAutoToleranceBlock = "block";
				maxAutoMinorSliderBlock = "block";
			}
		}
	}

	int relMinCriticalLeniency = getLeniencyFactor(relMinCritical);
	int relMinMajorLeniency = getLeniencyFactor(relMinMajor);
	int relMinMinorLeniency = getLeniencyFactor(relMinMinor);
	int relMaxCriticalLeniency = getLeniencyFactor(relMaxCritical);
	int relMaxMajorLeniency = getLeniencyFactor(relMaxMajor);
	int relMaxMinorLeniency = getLeniencyFactor(relMaxMinor);

	IniFile thresholdsIni = new IniFile(EgInstallInfo.getInstallDir()+"/manager/config/eg_thresholds.ini");
	String alarmVariables[] = thresholdsIni.getVariables("ALARM_POLICY");

	ArrayList aListGlobalThresholds = testerInfo.getGlobalThresholds();
	boolean isGlobalThresholds = false;
	if (aListGlobalThresholds != null && aListGlobalThresholds.contains(strTestName))
	{
		isGlobalThresholds = true;
	}
	rootJson.put("isGlobalThresholds",isGlobalThresholds);
	boolean isHostTest = specsInfo.isTestRelevantForServer("Host_system",strTestName,true);

	rootJson.put("isHostTest",isHostTest);
	if (isHostTest)
	{
		screenLabels.put("hostTest_msg",mappingInfo.getTextDescription("admin.threshold.Changes made to default threshold will be applied to all component types to which this test is mapped"));
	}

	String unit = tablesInfo.getUnitForMeasure(strTestName,measure);
	screenLabels.put("minThresh_tip",mappingInfo.getTextDescription("admin.threshold.Specify minimum threshold values (Critical, Major, and Minor) in ascending order"));
	JSONObject minThreshObj = new JSONObject();
	minThreshObj.put("minStaticOption",minStaticSelected);
	minThreshObj.put("minStaticBlock",minStaticBlock);
	minThreshObj.put("absMinCritical",absMinCritical);
	minThreshObj.put("absMinMajor",absMinMajor);
	minThreshObj.put("absMinMinor",absMinMinor);
	screenLabels.put("test_description","Default thresholds for the '"+mappingInfo.getMeasureDescription(strTestName,measure)+" ("+unit+")' measure of the '"+mappingInfo.getTestDescription(strTestName)+"' test ");

	if (!isGlobalThresholds)
	{
		if(!isNegativeValuesAllowed)
		{
			minThreshObj.put("minAutomaticOption",minAutomaticSelected);
			minThreshObj.put("minAutomaticBlock",minAutomaticBlock);
			minThreshObj.put("minAutoToleranceBlock",minAutoToleranceBlock);
			minThreshObj.put("relMinCritical",relMinCriticalLeniency);
			minThreshObj.put("relMinMajor",relMinMajorLeniency);
			minThreshObj.put("relMinMinor",relMinMinorLeniency);

		}
	}

	screenLabels.put("maxThresh_tip",mappingInfo.getTextDescription("admin.threshold.Specify maximum threshold values (Critical, Major, and Minor) in descending order"));
	JSONObject maxThreshObj = new JSONObject();
	maxThreshObj.put("maxStaticOption",maxStaticSelected);
	maxThreshObj.put("maxStaticBlock",maxStaticBlock);
	maxThreshObj.put("absMaxCritical",absMaxCritical);
	maxThreshObj.put("absMaxMajor",absMaxMajor);
	maxThreshObj.put("absMaxMinor",absMaxMinor);

	if (!isGlobalThresholds )
	{
		if(!isNegativeValuesAllowed)
		{
	maxThreshObj.put("maxAutomaticOption",maxAutomaticSelected);
	maxThreshObj.put("maxAutomaticBlock",maxAutomaticBlock);
	maxThreshObj.put("maxAutoToleranceBlock",maxAutoToleranceBlock);
	maxThreshObj.put("relMaxCritical",relMaxCriticalLeniency);
	maxThreshObj.put("relMaxMajor",relMaxMajorLeniency);
	maxThreshObj.put("relMaxMinor",relMaxMinorLeniency);

		}
	}

	rootJson.put("minThreshObj",minThreshObj);
	rootJson.put("maxThreshObj",maxThreshObj);
	JSONArray alarmPolicyArr = new JSONArray();
	JSONObject alarmPolicyDescriptionObj = new JSONObject();
	for (int i=0;i<alarmVariables.length;i++)
	{
		JSONObject alarmObj = new JSONObject();
		String strAlarmPolicy = alarmVariables[i];
		String selected = "";
		alarmObj.put("displayField",strAlarmPolicy);
		alarmObj.put("valueField",strAlarmPolicy);
		String strDescription = thresholdsIni.getValue("ALARM_POLICY",strAlarmPolicy);
		int i_idx = strDescription.indexOf(",");
		String windowSize = strDescription.substring(0,i_idx);
		String numCrossings = strDescription.substring(i_idx+1);
		if (windowSize.equals("1") && numCrossings.equals("1"))
		{
			alarmPolicyDescriptionObj.put(strAlarmPolicy,numCrossings + " threshold violation out of " + windowSize + " measurement");
		}
		else
		{
			alarmPolicyDescriptionObj.put(strAlarmPolicy,numCrossings + " threshold violations out of " + windowSize + " consecutive measurements");
		}


		if (strAlarmPolicy.equals(alarmPolicy))
		{
			rootJson.put("selectedAlarmType",strAlarmPolicy);
			selected = "selected";
			if (windowSize.equals("1") && numCrossings.equals("1"))
			{
				rootJson.put("selectedAlarmDescription",numCrossings + " threshold violation out of " + windowSize + " measurement");
			}
			else
			{
				rootJson.put("selectedAlarmDescription",numCrossings + " threshold violations out of " + windowSize + " consecutive measurements");
			}
		}
		alarmPolicyArr.add(alarmObj);
	}

	

	rootJson.put("alarmPolicyDescriptionObj",alarmPolicyDescriptionObj);
	rootJson.put("alarmPolicyArr",alarmPolicyArr);
	rootJson.put("screenLabels",screenLabels);
	rootJson.put("hiddenObj",hiddenObj);
	out.println(rootJson.toString());
%>


